/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_ERRORSUPPORT_H
#define _SC_ERRORSUPPORT_H

// sc
namespace sc {
class Error;
}

// qt
class QObject;
class QWidget;


/**
 * post an DialogEvent to the "main widget" to display \b error.
 * Block until the dialog returns.
 * \param error the error.
 */
void handleError( const sc::Error* error );

/**
 * display the given error. Open the dialog with \b parent as
 * parent widget.
 * \param error the error.
 * \param parent the parent widget for the error dialog.
 */
void handleError( const sc::Error* error, QWidget* parent );

#endif // _SC_ERRORSUPPORT_H
