/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef	XMATRIX_H
#define XMATRIX_H

#include <Xm/ScrollBar.h>

extern WidgetClass matrixWidgetClass;

typedef struct _MatrixClass	*MatrixWidgetClass;
typedef struct _MatrixRec	*MatrixWidget;

/* New types */

#define XmRIntArray		"IntArray"

/* Shadow attributes */

/*	The following resources have already been defined:
	XmNshadowThickness, XmNtopShadowColor, XmNbottomShadowColor
*/

/* Callbacks */

/*	The following resources have already been defined:
	XmNexposeCallback
*/

/* Organization Attributes */

/*	The following resources have already been defined:
	XmNnumColumns, XmNspacing, XmNleftAttachment, XmNtopAttachment
	XmNmargin 	*/

#define XmNshadeAttachments		"shadeAttachments"
#define XmCShadeAttachments		"ShadeAttachments"

#ifndef XmNmargin
#define XmNmargin			"margin"
#endif
#ifndef XmCMargin
#define XmCMargin			"Margin"
#endif

/* Window sizes */

#define	XmNmaxColumns			"maxColumns"
#define XmCMaxColumns			"MaxColumns"

#define XmNmaxRows			"maxRows"
#define XmCMaxRows			"MaxRows"

#define XmNcolumnRelSizes		"columnRelSizes"
#define XmCColumnRelSizes		"ColumnRelSizes"

#define XmNrowRelSizes			"rowRelSizes"
#define XmCRowRelSizes			"RowRelSizes"

/* Scroll Bar */

#define		K_NO_SCROLL		0
#define		K_SCROLL_SHARED		1
#define		K_SCROLL_INDIVIDUAL	2

#define XmNscrollBar			"scrollBar"
#define XmCScrollBar			"ScrollBar"

#define XmNscrollBarManage		"scrollBarManage"
#define XmCScrollBarManage		"ScrollBarManage"

/* Prototypes */

#ifndef XmIsMatrix
#define XmIsMatrix(w) XtIsSubclass(w, matrixWidgetClass)
#endif

/* Class record constants */

/*------------------------------------------------------------------------*/
#if defined (__STDC__) || defined (__cplusplus) || defined (c_plusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

#if defined (__cplusplus) || defined (c_plusplus)
extern "C"
{
#endif
/*------------------------------------------------------------------------*/

extern Widget XmCreateMatrix P_((Widget, char*, ArgList, int));
extern Widget XmMatrixScrollBar P_((Widget, int));
extern int XmMatrixGetSelectedItems P_((MatrixWidget, Widget**));
extern int XmMatrixGetSerieItems P_((MatrixWidget,Widget, Widget**));

/*------------------------------------------------------------------------*/
#undef P_
#if defined(__cplusplus) || defined(c_plusplus)
}
#endif
/*------------------------------------------------------------------------*/

#endif /* MATRIX_H */
