
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileNoGridPlottingAttributes.h
    \brief Definition of NoGridPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef NoGridPlottingAttributes_H
#define NoGridPlottingAttributes_H

#include "magics.h"
namespace magics {

class XmlNode;
class NoGridPlottingAttributes 
{
public:
//  --  constructor
    NoGridPlottingAttributes();
    
//  --  destructor
    virtual ~NoGridPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const NoGridPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	double latReference_;
	double latIncrement_;
	double lonReference_;
	double lonIncrement_;
	 

private:
	friend ostream& operator<<(ostream& s,const NoGridPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

