/*
 * iso226_2003.h
 *
 *  Created on: 08 апр. 2016 г.
 *      Author: sadko
 */

#ifndef GENERATED_ISO226_ISO226_2003_H_
#define GENERATED_ISO226_ISO226_2003_H_

#include <generated/iso226/defs.h>

namespace lsp
{
    static const float iso226_2003_curve_0_phons[1382] =
    {
        -42.12, -42.15, -42.22, -42.28,
        -42.34, -42.43, -42.58, -42.69, -42.77, -42.88, -42.93, -43.07, -43.17, -43.25,
        -43.38, -43.53, -43.62, -43.70, -43.82, -43.88, -43.96, -44.09, -44.22, -44.29,
        -44.41, -44.52, -44.63, -44.71, -44.79, -44.97, -45.10, -45.21, -45.34, -45.49,
        -45.57, -45.72, -45.88, -45.93, -45.99, -46.13, -46.20, -46.27, -46.33, -46.44,
        -46.57, -46.67, -46.79, -46.87, -47.00, -47.15, -47.29, -47.38, -47.47, -47.55,
        -47.62, -47.65, -47.74, -47.87, -47.96, -48.02, -48.13, -48.35, -48.39, -48.48,
        -48.63, -48.72, -48.78, -48.86, -48.92, -49.07, -49.20, -49.33, -49.47, -49.48,
        -49.48, -49.60, -49.77, -49.86, -49.87, -50.03, -50.08, -50.18, -50.30, -50.39,
        -50.43, -50.55, -50.64, -50.73, -50.82, -50.92, -51.05, -51.11, -51.19, -51.29,
        -51.38, -51.43, -51.49, -51.59, -51.62, -51.69, -51.80, -51.87, -51.91, -52.02,
        -52.14, -52.25, -52.34, -52.43, -52.53, -52.64, -52.77, -52.86, -52.94, -53.04,
        -53.16, -53.27, -53.37, -53.49, -53.57, -53.63, -53.74, -53.82, -53.91, -53.97,
        -54.04, -54.13, -54.21, -54.24, -54.31, -54.41, -54.45, -54.52, -54.65, -54.73,
        -54.79, -54.89, -54.97, -55.10, -55.16, -55.20, -55.25, -55.35, -55.40, -55.46,
        -55.55, -55.63, -55.70, -55.74, -55.83, -55.94, -56.01, -56.10, -56.21, -56.29,
        -56.35, -56.45, -56.54, -56.62, -56.68, -56.75, -56.86, -56.94, -56.99, -57.05,
        -57.10, -57.16, -57.21, -57.29, -57.34, -57.40, -57.53, -57.59, -57.64, -57.73,
        -57.84, -57.92, -58.04, -58.08, -58.20, -58.26, -58.33, -58.39, -58.48, -58.56,
        -58.66, -58.71, -58.75, -58.85, -58.92, -58.94, -58.94, -59.09, -59.14, -59.24,
        -59.35, -59.41, -59.50, -59.61, -59.68, -59.73, -59.77, -59.82, -59.90, -59.98,
        -60.06, -60.14, -60.18, -60.25, -60.34, -60.41, -60.45, -60.55, -60.56, -60.59,
        -60.67, -60.81, -60.84, -60.94, -61.00, -61.04, -61.06, -61.12, -61.15, -61.18,
        -61.24, -61.26, -61.35, -61.43, -61.50, -61.63, -61.77, -61.80, -61.92, -62.01,
        -62.06, -62.10, -62.15, -62.19, -62.23, -62.26, -62.30, -62.33, -62.42, -62.48,
        -62.58, -62.66, -62.71, -62.83, -62.82, -62.82, -62.93, -63.01, -63.06, -63.16,
        -63.25, -63.29, -63.37, -63.42, -63.43, -63.46, -63.49, -63.54, -63.60, -63.63,
        -63.72, -63.76, -63.82, -63.94, -64.02, -64.06, -64.13, -64.17, -64.21, -64.27,
        -64.29, -64.32, -64.42, -64.46, -64.48, -64.52, -64.55, -64.60, -64.67, -64.80,
        -64.85, -64.94, -65.03, -65.12, -65.23, -65.24, -65.33, -65.39, -65.40, -65.46,
        -65.47, -65.51, -65.56, -65.62, -65.67, -65.74, -65.84, -65.88, -65.95, -65.98,
        -66.00, -66.05, -66.08, -66.09, -66.15, -66.19, -66.23, -66.30, -66.34, -66.38,
        -66.47, -66.52, -66.59, -66.70, -66.75, -66.81, -66.86, -66.91, -66.96, -67.02,
        -67.08, -67.08, -67.09, -67.20, -67.23, -67.25, -67.33, -67.36, -67.38, -67.39,
        -67.47, -67.53, -67.51, -67.60, -67.67, -67.66, -67.70, -67.77, -67.77, -67.85,
        -67.94, -67.93, -68.02, -68.05, -68.12, -68.18, -68.26, -68.36, -68.40, -68.51,
        -68.54, -68.56, -68.60, -68.64, -68.62, -68.62, -68.64, -68.68, -68.69, -68.80,
        -68.89, -68.91, -69.01, -69.05, -69.11, -69.18, -69.23, -69.28, -69.29, -69.35,
        -69.42, -69.40, -69.36, -69.43, -69.43, -69.47, -69.50, -69.55, -69.61, -69.66,
        -69.73, -69.79, -69.86, -69.91, -69.96, -70.02, -70.08, -70.13, -70.18, -70.18,
        -70.26, -70.30, -70.32, -70.40, -70.43, -70.46, -70.51, -70.54, -70.53, -70.61,
        -70.59, -70.59, -70.64, -70.67, -70.70, -70.75, -70.80, -70.82, -70.85, -70.88,
        -70.91, -70.93, -70.97, -71.02, -71.07, -71.12, -71.19, -71.26, -71.24, -71.30,
        -71.37, -71.37, -71.45, -71.50, -71.52, -71.55, -71.64, -71.64, -71.70, -71.77,
        -71.76, -71.84, -71.90, -71.94, -71.98, -72.01, -72.07, -72.09, -72.17, -72.18,
        -72.20, -72.21, -72.23, -72.24, -72.25, -72.26, -72.29, -72.31, -72.34, -72.37,
        -72.42, -72.48, -72.54, -72.61, -72.61, -72.68, -72.73, -72.74, -72.82, -72.85,
        -72.87, -72.91, -72.96, -72.93, -73.01, -73.01, -72.96, -73.03, -73.03, -73.07,
        -73.12, -73.20, -73.26, -73.27, -73.32, -73.39, -73.43, -73.50, -73.50, -73.54,
        -73.55, -73.57, -73.62, -73.70, -73.76, -73.82, -73.84, -73.86, -73.93, -73.94,
        -73.95, -73.97, -73.99, -74.00, -74.03, -74.07, -74.07, -74.15, -74.22, -74.20,
        -74.29, -74.33, -74.34, -74.36, -74.42, -74.41, -74.40, -74.45, -74.43, -74.49,
        -74.54, -74.59, -74.61, -74.66, -74.70, -74.73, -74.79, -74.81, -74.91, -74.93,
        -74.97, -74.99, -75.04, -75.02, -75.00, -75.06, -74.99, -75.05, -75.08, -75.08,
        -75.13, -75.17, -75.19, -75.21, -75.22, -75.29, -75.35, -75.43, -75.51, -75.58,
        -75.63, -75.63, -75.62, -75.63, -75.69, -75.65, -75.72, -75.75, -75.76, -75.82,
        -75.81, -75.85, -75.82, -75.85, -75.91, -76.01, -76.10, -76.17, -76.23, -76.27,
        -76.28, -76.30, -76.28, -76.32, -76.27, -76.26, -76.27, -76.24, -76.27, -76.34,
        -76.44, -76.52, -76.60, -76.67, -76.59, -76.65, -76.66, -76.59, -76.66, -76.63,
        -76.66, -76.65, -76.69, -76.70, -76.71, -76.80, -76.84, -76.84, -76.92, -76.97,
        -77.04, -77.06, -77.08, -77.05, -77.06, -77.10, -77.05, -77.13, -77.16, -77.23,
        -77.27, -77.29, -77.29, -77.31, -77.32, -77.39, -77.45, -77.51, -77.59, -77.64,
        -77.66, -77.67, -77.68, -77.67, -77.73, -77.65, -77.71, -77.73, -77.67, -77.73,
        -77.78, -77.84, -77.88, -77.94, -77.95, -78.00, -78.04, -78.06, -78.10, -78.11,
        -78.08, -78.06, -78.15, -78.16, -78.19, -78.26, -78.27, -78.29, -78.27, -78.28,
        -78.27, -78.30, -78.25, -78.25, -78.27, -78.24, -78.29, -78.35, -78.41, -78.49,
        -78.53, -78.46, -78.54, -78.50, -78.48, -78.55, -78.57, -78.65, -78.67, -78.75,
        -78.70, -78.72, -78.75, -78.67, -78.74, -78.76, -78.84, -78.88, -78.95, -78.89,
        -78.90, -78.95, -78.88, -78.89, -78.94, -78.98, -79.04, -79.10, -79.14, -79.19,
        -79.23, -79.26, -79.32, -79.34, -79.34, -79.34, -79.36, -79.34, -79.35, -79.36,
        -79.36, -79.36, -79.37, -79.39, -79.32, -79.35, -79.38, -79.40, -79.42, -79.49,
        -79.50, -79.58, -79.60, -79.62, -79.64, -79.65, -79.66, -79.66, -79.56, -79.55,
        -79.54, -79.55, -79.56, -79.64, -79.65, -79.74, -79.74, -79.84, -79.84, -79.88,
        -79.89, -79.85, -79.79, -79.84, -79.80, -79.80, -79.81, -79.91, -79.92, -79.93,
        -79.94, -79.89, -79.90, -79.91, -79.96, -80.03, -80.09, -80.09, -80.11, -80.11,
        -80.06, -80.06, -80.05, -79.97, -80.03, -80.07, -80.13, -80.16, -80.16, -80.16,
        -80.16, -80.16, -80.17, -80.11, -80.17, -80.12, -80.16, -80.16, -80.16, -80.22,
        -80.22, -80.22, -80.25, -80.28, -80.30, -80.37, -80.37, -80.37, -80.37, -80.37,
        -80.37, -80.38, -80.38, -80.39, -80.39, -80.39, -80.32, -80.29, -80.30, -80.28,
        -80.19, -80.23, -80.28, -80.33, -80.37, -80.37, -80.37, -80.37, -80.37, -80.37,
        -80.39, -80.44, -80.45, -80.45, -80.46, -80.46, -80.51, -80.57, -80.58, -80.58,
        -80.59, -80.59, -80.59, -80.61, -80.68, -80.70, -80.82, -80.82, -80.82, -80.82,
        -80.82, -80.72, -80.72, -80.72, -80.72, -80.71, -80.59, -80.57, -80.57, -80.49,
        -80.53, -80.53, -80.57, -80.57, -80.67, -80.66, -80.66, -80.72, -80.72, -80.72,
        -80.69, -80.68, -80.66, -80.63, -80.63, -80.62, -80.61, -80.61, -80.61, -80.62,
        -80.61, -80.65, -80.62, -80.63, -80.63, -80.61, -80.65, -80.62, -80.66, -80.67,
        -80.72, -80.76, -80.84, -80.86, -80.88, -80.89, -80.84, -80.87, -80.84, -80.89,
        -80.93, -80.97, -81.06, -81.09, -81.15, -81.19, -81.20, -81.23, -81.30, -81.29,
        -81.34, -81.46, -81.49, -81.54, -81.59, -81.65, -81.69, -81.68, -81.73, -81.76,
        -81.76, -81.82, -81.89, -81.93, -82.01, -82.17, -82.18, -82.31, -82.45, -82.50,
        -82.55, -82.59, -82.63, -82.67, -82.78, -82.84, -82.85, -83.02, -83.04, -83.10,
        -83.15, -83.19, -83.25, -83.37, -83.42, -83.53, -83.60, -83.70, -83.79, -83.88,
        -83.97, -84.06, -84.15, -84.15, -84.24, -84.24, -84.26, -84.33, -84.39, -84.51,
        -84.61, -84.69, -84.62, -84.69, -84.69, -84.61, -84.68, -84.70, -84.76, -84.80,
        -84.87, -84.94, -85.03, -85.12, -85.18, -85.24, -85.27, -85.27, -85.27, -85.27,
        -85.25, -85.27, -85.24, -85.24, -85.27, -85.23, -85.27, -85.31, -85.35, -85.34,
        -85.35, -85.30, -85.25, -85.25, -85.29, -85.27, -85.33, -85.36, -85.34, -85.35,
        -85.32, -85.32, -85.28, -85.25, -85.26, -85.24, -85.20, -85.17, -85.16, -85.16,
        -85.09, -85.07, -85.08, -85.07, -85.03, -85.00, -85.05, -85.05, -85.04, -85.06,
        -85.08, -85.06, -85.05, -84.96, -84.93, -84.95, -84.91, -84.92, -84.97, -85.01,
        -84.99, -85.06, -84.97, -84.91, -84.88, -84.88, -84.86, -84.85, -84.89, -84.88,
        -84.91, -84.94, -84.96, -85.05, -85.08, -84.99, -85.01, -84.92, -84.94, -84.90,
        -84.93, -84.98, -84.95, -85.03, -85.04, -85.03, -85.05, -85.03, -85.09, -85.00,
        -85.08, -85.05, -85.03, -85.13, -85.12, -85.18, -85.21, -85.24, -85.28, -85.27,
        -85.28, -85.27, -85.27, -85.28, -85.23, -85.25, -85.25, -85.27, -85.29, -85.31,
        -85.39, -85.38, -85.39, -85.40, -85.39, -85.41, -85.36, -85.44, -85.44, -85.48,
        -85.53, -85.55, -85.59, -85.58, -85.59, -85.60, -85.65, -85.71, -85.75, -85.81,
        -85.81, -85.81, -85.81, -85.81, -85.82, -85.79, -85.82, -85.80, -85.81, -85.81,
        -85.81, -85.81, -85.81, -85.82, -85.82, -85.88, -85.92, -85.97, -85.99, -85.99,
        -85.99, -85.99, -86.00, -86.10, -86.15, -86.27, -86.33, -86.37, -86.37, -86.37,
        -86.37, -86.36, -86.36, -86.36, -86.36, -86.36, -86.44, -86.46, -86.46, -86.56,
        -86.56, -86.56, -86.56, -86.56, -86.56, -86.60, -86.66, -86.66, -86.70, -86.72,
        -86.70, -86.66, -86.62, -86.55, -86.59, -86.63, -86.68, -86.73, -86.76, -86.76,
        -86.79, -86.80, -86.76, -86.84, -86.81, -86.82, -86.81, -86.83, -86.76, -86.81,
        -86.76, -86.74, -86.74, -86.79, -86.78, -86.84, -86.88, -86.95, -86.94, -86.95,
        -86.94, -86.92, -86.89, -86.87, -86.82, -86.78, -86.82, -86.78, -86.79, -86.89,
        -86.96, -86.90, -86.90, -86.89, -86.84, -86.80, -86.81, -86.75, -86.73, -86.73,
        -86.71, -86.67, -86.65, -86.61, -86.62, -86.60, -86.58, -86.58, -86.61, -86.60,
        -86.54, -86.49, -86.47, -86.45, -86.43, -86.33, -86.28, -86.28, -86.22, -86.16,
        -86.12, -86.09, -86.04, -85.99, -85.90, -85.88, -85.87, -85.87, -85.89, -85.82,
        -85.83, -85.83, -85.78, -85.74, -85.68, -85.65, -85.56, -85.48, -85.46, -85.45,
        -85.41, -85.38, -85.39, -85.35, -85.28, -85.24, -85.16, -85.13, -84.99, -84.96,
        -84.91, -84.86, -84.78, -84.77, -84.72, -84.67, -84.62, -84.58, -84.56, -84.48,
        -84.40, -84.31, -84.25, -84.19, -84.15, -84.05, -83.99, -83.93, -83.91, -83.83,
        -83.81, -83.73, -83.68, -83.67, -83.61, -83.55, -83.55, -83.52, -83.52, -83.49,
        -83.47, -83.40, -83.32, -83.21, -83.15, -83.14, -83.08, -83.00, -82.94, -82.88,
        -82.80, -82.73, -82.73, -82.68, -82.66, -82.65, -82.61, -82.62, -82.53, -82.55,
        -82.56, -82.47, -82.48, -82.47, -82.40, -82.35, -82.30, -82.20, -82.11, -82.09,
        -82.03, -81.89, -81.85, -81.84, -81.78, -81.74, -81.74, -81.74, -81.74, -81.75,
        -81.73, -81.73, -81.64, -81.57, -81.60, -81.52, -81.48, -81.50, -81.47, -81.41,
        -81.42, -81.38, -81.31, -81.32, -81.28, -81.26, -81.31, -81.31, -81.31, -81.36,
        -81.35, -81.43, -81.44, -81.43, -81.50, -81.43, -81.39, -81.34, -81.33, -81.32,
        -81.32, -81.26, -81.19, -81.12, -81.06, -80.98, -80.92, -80.94, -81.00, -81.05,
        -81.04, -81.00, -80.99, -80.90, -80.89, -80.84, -80.73, -80.68, -80.57, -80.47,
        -80.40, -80.39, -80.37, -80.37, -80.41, -80.31, -80.32, -80.26, -80.22, -80.21,
        -80.13, -80.11, -80.02, -80.01, -79.92, -79.84, -79.77, -79.71, -79.60, -79.48,
        -79.39, -79.31, -79.28, -79.15, -79.13, -79.00, -78.92, -78.80, -78.73, -78.56,
        -78.48, -78.38, -78.17, -78.04, -77.83, -77.72, -77.56, -77.40, -77.22, -77.11,
        -77.02, -76.86, -76.63, -76.40, -76.21, -76.02, -75.86, -75.74
    };

    static const float iso226_2003_curve_10_phons[1382] =
    {
        -36.38, -36.41, -36.47, -36.50,
        -36.56, -36.63, -36.75, -36.84, -36.89, -36.99, -37.02, -37.13, -37.19, -37.24,
        -37.34, -37.46, -37.51, -37.58, -37.67, -37.71, -37.74, -37.84, -37.93, -37.97,
        -38.08, -38.16, -38.24, -38.28, -38.33, -38.46, -38.55, -38.62, -38.73, -38.84,
        -38.88, -38.99, -39.12, -39.18, -39.21, -39.32, -39.36, -39.39, -39.44, -39.53,
        -39.62, -39.69, -39.78, -39.84, -39.93, -40.06, -40.17, -40.25, -40.31, -40.35,
        -40.40, -40.39, -40.42, -40.51, -40.57, -40.61, -40.67, -40.86, -40.90, -40.96,
        -41.11, -41.19, -41.24, -41.29, -41.38, -41.49, -41.57, -41.64, -41.75, -41.74,
        -41.76, -41.85, -41.98, -42.04, -42.06, -42.16, -42.19, -42.26, -42.35, -42.42,
        -42.45, -42.54, -42.61, -42.68, -42.72, -42.79, -42.87, -42.91, -42.97, -43.04,
        -43.09, -43.15, -43.20, -43.31, -43.34, -43.38, -43.51, -43.55, -43.56, -43.63,
        -43.71, -43.77, -43.83, -43.90, -43.98, -44.03, -44.15, -44.21, -44.28, -44.36,
        -44.46, -44.54, -44.63, -44.72, -44.78, -44.81, -44.91, -44.98, -45.05, -45.08,
        -45.12, -45.20, -45.25, -45.26, -45.32, -45.41, -45.44, -45.50, -45.61, -45.66,
        -45.71, -45.78, -45.83, -45.93, -45.96, -45.99, -46.05, -46.14, -46.17, -46.23,
        -46.31, -46.36, -46.44, -46.46, -46.54, -46.61, -46.67, -46.72, -46.82, -46.88,
        -46.92, -47.02, -47.07, -47.12, -47.17, -47.21, -47.28, -47.30, -47.33, -47.38,
        -47.41, -47.46, -47.50, -47.58, -47.62, -47.65, -47.77, -47.83, -47.86, -47.96,
        -48.04, -48.12, -48.23, -48.26, -48.37, -48.42, -48.46, -48.51, -48.56, -48.65,
        -48.71, -48.76, -48.80, -48.88, -48.93, -48.94, -48.95, -49.09, -49.14, -49.21,
        -49.30, -49.33, -49.39, -49.48, -49.52, -49.58, -49.61, -49.66, -49.74, -49.79,
        -49.86, -49.92, -49.92, -49.98, -50.08, -50.11, -50.16, -50.28, -50.28, -50.29,
        -50.36, -50.48, -50.50, -50.60, -50.65, -50.67, -50.68, -50.73, -50.75, -50.76,
        -50.85, -50.83, -50.91, -50.98, -51.02, -51.13, -51.25, -51.27, -51.38, -51.47,
        -51.49, -51.55, -51.61, -51.63, -51.68, -51.71, -51.73, -51.74, -51.82, -51.87,
        -51.97, -52.05, -52.11, -52.21, -52.21, -52.21, -52.33, -52.42, -52.46, -52.52,
        -52.61, -52.61, -52.70, -52.74, -52.73, -52.73, -52.75, -52.80, -52.84, -52.87,
        -52.95, -52.99, -53.05, -53.13, -53.20, -53.24, -53.31, -53.35, -53.38, -53.45,
        -53.49, -53.52, -53.62, -53.68, -53.70, -53.73, -53.76, -53.79, -53.84, -53.94,
        -53.97, -54.04, -54.12, -54.20, -54.30, -54.31, -54.40, -54.47, -54.48, -54.53,
        -54.54, -54.58, -54.64, -54.70, -54.76, -54.81, -54.89, -54.94, -55.00, -55.05,
        -55.06, -55.13, -55.13, -55.15, -55.23, -55.27, -55.30, -55.37, -55.39, -55.43,
        -55.51, -55.54, -55.57, -55.64, -55.68, -55.73, -55.78, -55.83, -55.90, -55.97,
        -56.03, -56.04, -56.02, -56.11, -56.15, -56.17, -56.26, -56.29, -56.33, -56.36,
        -56.47, -56.49, -56.49, -56.58, -56.66, -56.64, -56.66, -56.74, -56.76, -56.83,
        -56.89, -56.89, -56.98, -57.02, -57.06, -57.11, -57.17, -57.28, -57.31, -57.41,
        -57.41, -57.45, -57.51, -57.54, -57.53, -57.55, -57.58, -57.63, -57.64, -57.71,
        -57.80, -57.83, -57.92, -57.97, -58.05, -58.13, -58.20, -58.27, -58.28, -58.33,
        -58.38, -58.36, -58.34, -58.40, -58.40, -58.45, -58.48, -58.54, -58.60, -58.65,
        -58.71, -58.76, -58.82, -58.88, -58.93, -58.99, -59.04, -59.09, -59.15, -59.17,
        -59.25, -59.27, -59.28, -59.39, -59.43, -59.45, -59.51, -59.53, -59.51, -59.60,
        -59.59, -59.57, -59.61, -59.67, -59.71, -59.78, -59.86, -59.88, -59.93, -59.97,
        -60.00, -60.00, -60.06, -60.10, -60.15, -60.20, -60.24, -60.32, -60.31, -60.36,
        -60.42, -60.43, -60.52, -60.57, -60.60, -60.64, -60.72, -60.73, -60.80, -60.84,
        -60.83, -60.91, -60.96, -61.01, -61.05, -61.09, -61.15, -61.13, -61.22, -61.25,
        -61.28, -61.31, -61.35, -61.40, -61.40, -61.43, -61.47, -61.49, -61.49, -61.53,
        -61.58, -61.64, -61.69, -61.78, -61.78, -61.83, -61.86, -61.89, -61.97, -62.01,
        -62.03, -62.09, -62.14, -62.13, -62.21, -62.24, -62.19, -62.27, -62.30, -62.32,
        -62.38, -62.46, -62.53, -62.54, -62.58, -62.64, -62.71, -62.76, -62.76, -62.81,
        -62.82, -62.85, -62.93, -63.02, -63.10, -63.16, -63.20, -63.22, -63.30, -63.30,
        -63.33, -63.37, -63.40, -63.42, -63.45, -63.51, -63.53, -63.60, -63.65, -63.63,
        -63.71, -63.74, -63.73, -63.75, -63.80, -63.79, -63.83, -63.87, -63.87, -63.95,
        -63.99, -64.05, -64.08, -64.10, -64.17, -64.24, -64.30, -64.32, -64.42, -64.43,
        -64.45, -64.48, -64.52, -64.52, -64.53, -64.60, -64.58, -64.64, -64.67, -64.67,
        -64.72, -64.74, -64.77, -64.81, -64.83, -64.93, -65.00, -65.06, -65.15, -65.22,
        -65.28, -65.30, -65.30, -65.33, -65.38, -65.34, -65.42, -65.41, -65.41, -65.49,
        -65.49, -65.53, -65.54, -65.58, -65.63, -65.74, -65.83, -65.91, -65.95, -66.00,
        -66.00, -66.01, -66.03, -66.03, -66.02, -66.04, -66.06, -66.03, -66.06, -66.12,
        -66.20, -66.27, -66.33, -66.41, -66.38, -66.43, -66.46, -66.42, -66.51, -66.51,
        -66.55, -66.56, -66.59, -66.59, -66.59, -66.64, -66.66, -66.68, -66.75, -66.82,
        -66.92, -66.97, -66.99, -66.96, -66.99, -67.01, -66.99, -67.05, -67.10, -67.18,
        -67.23, -67.26, -67.28, -67.29, -67.32, -67.38, -67.40, -67.48, -67.53, -67.58,
        -67.61, -67.64, -67.66, -67.66, -67.73, -67.65, -67.70, -67.73, -67.68, -67.72,
        -67.78, -67.86, -67.91, -67.96, -68.02, -68.07, -68.11, -68.17, -68.20, -68.22,
        -68.18, -68.17, -68.24, -68.27, -68.31, -68.35, -68.38, -68.41, -68.40, -68.43,
        -68.45, -68.48, -68.45, -68.48, -68.47, -68.46, -68.50, -68.56, -68.63, -68.70,
        -68.74, -68.71, -68.76, -68.75, -68.76, -68.82, -68.86, -68.92, -68.97, -69.02,
        -69.00, -69.01, -69.03, -68.98, -69.04, -69.08, -69.17, -69.24, -69.30, -69.28,
        -69.29, -69.33, -69.29, -69.28, -69.35, -69.39, -69.45, -69.51, -69.55, -69.58,
        -69.63, -69.66, -69.69, -69.74, -69.70, -69.73, -69.73, -69.73, -69.75, -69.78,
        -69.81, -69.81, -69.85, -69.85, -69.79, -69.82, -69.85, -69.86, -69.90, -69.95,
        -69.98, -70.04, -70.08, -70.11, -70.12, -70.15, -70.18, -70.21, -70.12, -70.14,
        -70.14, -70.14, -70.15, -70.22, -70.25, -70.29, -70.29, -70.34, -70.34, -70.38,
        -70.43, -70.42, -70.38, -70.46, -70.44, -70.47, -70.52, -70.59, -70.60, -70.66,
        -70.66, -70.62, -70.67, -70.68, -70.70, -70.74, -70.77, -70.74, -70.78, -70.80,
        -70.74, -70.78, -70.78, -70.70, -70.75, -70.78, -70.81, -70.85, -70.87, -70.88,
        -70.89, -70.92, -70.95, -70.91, -70.95, -70.90, -70.94, -70.94, -70.99, -71.06,
        -71.06, -71.11, -71.13, -71.17, -71.18, -71.24, -71.24, -71.24, -71.24, -71.26,
        -71.26, -71.29, -71.32, -71.32, -71.35, -71.35, -71.28, -71.25, -71.25, -71.24,
        -71.15, -71.19, -71.22, -71.26, -71.29, -71.31, -71.33, -71.33, -71.33, -71.33,
        -71.35, -71.44, -71.45, -71.49, -71.51, -71.51, -71.56, -71.62, -71.65, -71.68,
        -71.68, -71.73, -71.75, -71.76, -71.80, -71.81, -71.89, -71.89, -71.89, -71.89,
        -71.89, -71.79, -71.83, -71.84, -71.86, -71.86, -71.77, -71.74, -71.73, -71.69,
        -71.69, -71.69, -71.74, -71.71, -71.81, -71.81, -71.81, -71.86, -71.86, -71.86,
        -71.85, -71.87, -71.86, -71.87, -71.86, -71.83, -71.80, -71.78, -71.78, -71.76,
        -71.79, -71.85, -71.85, -71.84, -71.86, -71.84, -71.87, -71.85, -71.89, -71.91,
        -71.95, -72.00, -72.08, -72.08, -72.11, -72.13, -72.07, -72.11, -72.10, -72.12,
        -72.14, -72.15, -72.21, -72.26, -72.29, -72.36, -72.34, -72.37, -72.43, -72.39,
        -72.43, -72.55, -72.60, -72.68, -72.75, -72.79, -72.82, -72.79, -72.82, -72.84,
        -72.81, -72.84, -72.90, -72.91, -72.95, -73.08, -73.05, -73.15, -73.26, -73.28,
        -73.31, -73.32, -73.35, -73.35, -73.44, -73.53, -73.53, -73.68, -73.73, -73.78,
        -73.81, -73.82, -73.85, -73.92, -73.97, -74.04, -74.11, -74.18, -74.24, -74.31,
        -74.38, -74.45, -74.52, -74.52, -74.56, -74.56, -74.57, -74.61, -74.66, -74.74,
        -74.83, -74.88, -74.85, -74.89, -74.88, -74.83, -74.87, -74.88, -74.91, -74.93,
        -74.97, -75.03, -75.10, -75.15, -75.21, -75.26, -75.27, -75.27, -75.27, -75.27,
        -75.25, -75.27, -75.24, -75.25, -75.27, -75.23, -75.25, -75.28, -75.31, -75.30,
        -75.31, -75.28, -75.25, -75.25, -75.29, -75.29, -75.36, -75.36, -75.35, -75.36,
        -75.33, -75.32, -75.29, -75.24, -75.26, -75.25, -75.22, -75.23, -75.23, -75.25,
        -75.25, -75.23, -75.27, -75.26, -75.24, -75.20, -75.24, -75.23, -75.21, -75.19,
        -75.20, -75.17, -75.16, -75.11, -75.08, -75.12, -75.12, -75.12, -75.18, -75.22,
        -75.19, -75.27, -75.22, -75.19, -75.14, -75.15, -75.12, -75.09, -75.10, -75.08,
        -75.12, -75.16, -75.17, -75.24, -75.27, -75.20, -75.21, -75.12, -75.13, -75.08,
        -75.10, -75.13, -75.09, -75.15, -75.16, -75.17, -75.21, -75.22, -75.27, -75.22,
        -75.27, -75.23, -75.24, -75.29, -75.28, -75.32, -75.33, -75.35, -75.37, -75.37,
        -75.39, -75.37, -75.38, -75.39, -75.34, -75.35, -75.35, -75.36, -75.35, -75.38,
        -75.42, -75.41, -75.42, -75.42, -75.42, -75.42, -75.40, -75.44, -75.47, -75.51,
        -75.53, -75.57, -75.59, -75.56, -75.57, -75.55, -75.58, -75.63, -75.67, -75.71,
        -75.72, -75.74, -75.74, -75.74, -75.75, -75.72, -75.73, -75.69, -75.68, -75.68,
        -75.68, -75.70, -75.70, -75.71, -75.73, -75.76, -75.77, -75.80, -75.81, -75.81,
        -75.81, -75.83, -75.84, -75.93, -75.97, -76.06, -76.11, -76.13, -76.12, -76.12,
        -76.12, -76.12, -76.09, -76.09, -76.09, -76.05, -76.13, -76.15, -76.13, -76.20,
        -76.21, -76.21, -76.21, -76.21, -76.23, -76.26, -76.32, -76.32, -76.34, -76.37,
        -76.36, -76.31, -76.30, -76.25, -76.27, -76.32, -76.35, -76.38, -76.37, -76.37,
        -76.40, -76.39, -76.35, -76.41, -76.40, -76.40, -76.42, -76.43, -76.37, -76.43,
        -76.39, -76.38, -76.40, -76.42, -76.42, -76.48, -76.51, -76.58, -76.59, -76.58,
        -76.57, -76.56, -76.52, -76.51, -76.46, -76.42, -76.46, -76.40, -76.43, -76.53,
        -76.58, -76.52, -76.53, -76.53, -76.47, -76.43, -76.45, -76.39, -76.37, -76.37,
        -76.38, -76.34, -76.33, -76.32, -76.32, -76.32, -76.30, -76.31, -76.32, -76.33,
        -76.29, -76.27, -76.25, -76.25, -76.25, -76.17, -76.11, -76.09, -76.04, -75.99,
        -75.97, -75.95, -75.93, -75.90, -75.83, -75.82, -75.79, -75.78, -75.81, -75.76,
        -75.79, -75.81, -75.79, -75.77, -75.73, -75.69, -75.62, -75.51, -75.48, -75.45,
        -75.44, -75.44, -75.42, -75.40, -75.32, -75.30, -75.26, -75.27, -75.15, -75.14,
        -75.11, -75.08, -75.00, -75.00, -74.98, -74.94, -74.92, -74.84, -74.82, -74.76,
        -74.73, -74.64, -74.57, -74.55, -74.52, -74.43, -74.37, -74.34, -74.30, -74.25,
        -74.25, -74.16, -74.12, -74.11, -74.05, -73.99, -73.97, -73.94, -73.94, -73.93,
        -73.92, -73.88, -73.80, -73.71, -73.66, -73.63, -73.56, -73.49, -73.46, -73.41,
        -73.34, -73.30, -73.30, -73.25, -73.23, -73.21, -73.18, -73.21, -73.12, -73.12,
        -73.13, -73.04, -73.05, -73.04, -72.97, -72.92, -72.88, -72.78, -72.71, -72.65,
        -72.59, -72.48, -72.43, -72.43, -72.37, -72.33, -72.33, -72.34, -72.32, -72.30,
        -72.26, -72.26, -72.16, -72.08, -72.09, -72.00, -71.95, -71.94, -71.89, -71.82,
        -71.82, -71.75, -71.70, -71.71, -71.65, -71.61, -71.64, -71.63, -71.61, -71.61,
        -71.56, -71.64, -71.60, -71.54, -71.60, -71.54, -71.49, -71.44, -71.38, -71.33,
        -71.29, -71.19, -71.11, -71.05, -70.97, -70.88, -70.83, -70.81, -70.82, -70.82,
        -70.77, -70.70, -70.67, -70.58, -70.55, -70.47, -70.37, -70.31, -70.21, -70.11,
        -70.03, -69.99, -69.95, -69.96, -69.95, -69.86, -69.81, -69.71, -69.62, -69.57,
        -69.48, -69.47, -69.38, -69.36, -69.28, -69.19, -69.08, -69.01, -68.87, -68.73,
        -68.66, -68.57, -68.51, -68.42, -68.36, -68.22, -68.10, -67.97, -67.89, -67.75,
        -67.69, -67.58, -67.41, -67.29, -67.10, -66.98, -66.84, -66.66, -66.51, -66.43,
        -66.31, -66.20, -66.01, -65.79, -65.64, -65.50, -65.36, -65.28
    };

    static const float iso226_2003_curve_20_phons[1382] =
    {
        -30.64, -30.66, -30.73, -30.73,
        -30.77, -30.83, -30.91, -31.00, -31.01, -31.09, -31.12, -31.19, -31.22, -31.24,
        -31.30, -31.39, -31.41, -31.45, -31.52, -31.53, -31.53, -31.58, -31.63, -31.65,
        -31.74, -31.79, -31.85, -31.86, -31.86, -31.95, -32.01, -32.03, -32.12, -32.19,
        -32.19, -32.26, -32.36, -32.42, -32.43, -32.52, -32.52, -32.52, -32.55, -32.61,
        -32.66, -32.71, -32.76, -32.81, -32.86, -32.98, -33.05, -33.11, -33.14, -33.16,
        -33.17, -33.12, -33.10, -33.15, -33.18, -33.20, -33.21, -33.37, -33.42, -33.44,
        -33.59, -33.66, -33.71, -33.72, -33.85, -33.90, -33.95, -33.95, -34.03, -34.00,
        -34.04, -34.11, -34.18, -34.22, -34.25, -34.29, -34.30, -34.34, -34.40, -34.44,
        -34.46, -34.53, -34.58, -34.63, -34.63, -34.65, -34.70, -34.71, -34.75, -34.79,
        -34.80, -34.88, -34.91, -35.03, -35.07, -35.08, -35.22, -35.22, -35.22, -35.23,
        -35.28, -35.29, -35.33, -35.36, -35.42, -35.43, -35.52, -35.57, -35.62, -35.68,
        -35.77, -35.81, -35.88, -35.95, -36.00, -36.00, -36.08, -36.14, -36.18, -36.19,
        -36.20, -36.27, -36.29, -36.29, -36.32, -36.40, -36.43, -36.47, -36.57, -36.60,
        -36.62, -36.67, -36.68, -36.76, -36.76, -36.79, -36.84, -36.94, -36.95, -37.00,
        -37.08, -37.10, -37.17, -37.18, -37.24, -37.29, -37.33, -37.35, -37.43, -37.47,
        -37.50, -37.58, -37.60, -37.62, -37.65, -37.67, -37.70, -37.67, -37.67, -37.72,
        -37.73, -37.76, -37.80, -37.86, -37.91, -37.90, -38.00, -38.07, -38.09, -38.18,
        -38.24, -38.31, -38.43, -38.44, -38.54, -38.57, -38.58, -38.62, -38.65, -38.74,
        -38.75, -38.81, -38.84, -38.90, -38.94, -38.94, -38.96, -39.09, -39.14, -39.19,
        -39.25, -39.26, -39.29, -39.34, -39.37, -39.43, -39.45, -39.50, -39.57, -39.59,
        -39.67, -39.70, -39.67, -39.71, -39.82, -39.82, -39.86, -40.01, -40.00, -40.00,
        -40.06, -40.16, -40.16, -40.25, -40.31, -40.31, -40.30, -40.35, -40.34, -40.34,
        -40.45, -40.41, -40.47, -40.53, -40.54, -40.64, -40.73, -40.74, -40.83, -40.92,
        -40.93, -41.01, -41.06, -41.07, -41.13, -41.15, -41.16, -41.16, -41.21, -41.25,
        -41.36, -41.44, -41.51, -41.60, -41.59, -41.59, -41.74, -41.83, -41.86, -41.88,
        -41.96, -41.94, -42.02, -42.06, -42.03, -42.00, -42.01, -42.07, -42.08, -42.11,
        -42.18, -42.22, -42.28, -42.33, -42.39, -42.42, -42.49, -42.53, -42.55, -42.63,
        -42.69, -42.72, -42.82, -42.89, -42.91, -42.94, -42.97, -42.98, -43.02, -43.08,
        -43.08, -43.14, -43.22, -43.27, -43.37, -43.37, -43.46, -43.56, -43.56, -43.60,
        -43.61, -43.64, -43.72, -43.79, -43.84, -43.89, -43.95, -44.00, -44.05, -44.12,
        -44.13, -44.21, -44.17, -44.21, -44.31, -44.35, -44.38, -44.44, -44.44, -44.49,
        -44.54, -44.57, -44.55, -44.58, -44.60, -44.66, -44.69, -44.75, -44.84, -44.92,
        -44.98, -45.01, -44.94, -45.03, -45.07, -45.09, -45.19, -45.22, -45.27, -45.33,
        -45.46, -45.45, -45.47, -45.57, -45.65, -45.62, -45.62, -45.70, -45.74, -45.82,
        -45.85, -45.84, -45.94, -45.99, -45.99, -46.04, -46.09, -46.19, -46.22, -46.30,
        -46.28, -46.33, -46.43, -46.45, -46.43, -46.47, -46.51, -46.57, -46.59, -46.62,
        -46.70, -46.75, -46.82, -46.89, -46.99, -47.08, -47.18, -47.26, -47.28, -47.31,
        -47.33, -47.33, -47.33, -47.36, -47.36, -47.42, -47.47, -47.52, -47.58, -47.63,
        -47.68, -47.72, -47.77, -47.84, -47.90, -47.95, -48.00, -48.06, -48.12, -48.15,
        -48.25, -48.25, -48.25, -48.38, -48.43, -48.45, -48.50, -48.52, -48.50, -48.59,
        -48.58, -48.55, -48.59, -48.68, -48.73, -48.82, -48.91, -48.93, -49.01, -49.06,
        -49.09, -49.07, -49.14, -49.19, -49.23, -49.28, -49.28, -49.37, -49.38, -49.41,
        -49.48, -49.49, -49.59, -49.63, -49.67, -49.72, -49.80, -49.81, -49.89, -49.91,
        -49.89, -49.98, -50.03, -50.07, -50.12, -50.17, -50.23, -50.17, -50.27, -50.32,
        -50.37, -50.42, -50.47, -50.56, -50.55, -50.60, -50.64, -50.67, -50.65, -50.69,
        -50.74, -50.79, -50.85, -50.94, -50.95, -50.98, -51.00, -51.04, -51.13, -51.17,
        -51.18, -51.26, -51.31, -51.32, -51.42, -51.46, -51.42, -51.52, -51.56, -51.57,
        -51.64, -51.72, -51.80, -51.80, -51.85, -51.90, -51.98, -52.01, -52.03, -52.09,
        -52.09, -52.14, -52.24, -52.34, -52.44, -52.49, -52.55, -52.58, -52.66, -52.66,
        -52.72, -52.76, -52.81, -52.85, -52.88, -52.95, -52.98, -53.06, -53.08, -53.06,
        -53.14, -53.14, -53.11, -53.14, -53.17, -53.18, -53.26, -53.29, -53.30, -53.40,
        -53.44, -53.50, -53.55, -53.55, -53.65, -53.74, -53.81, -53.83, -53.93, -53.92,
        -53.92, -53.97, -54.00, -54.02, -54.07, -54.14, -54.17, -54.22, -54.26, -54.26,
        -54.31, -54.31, -54.36, -54.41, -54.45, -54.57, -54.65, -54.70, -54.79, -54.87,
        -54.93, -54.97, -54.98, -55.03, -55.07, -55.03, -55.12, -55.07, -55.05, -55.16,
        -55.16, -55.21, -55.26, -55.31, -55.36, -55.46, -55.56, -55.64, -55.67, -55.73,
        -55.72, -55.73, -55.77, -55.74, -55.77, -55.82, -55.85, -55.81, -55.86, -55.91,
        -55.96, -56.02, -56.07, -56.16, -56.17, -56.21, -56.26, -56.26, -56.36, -56.39,
        -56.43, -56.47, -56.48, -56.48, -56.48, -56.48, -56.48, -56.53, -56.58, -56.68,
        -56.80, -56.87, -56.89, -56.87, -56.92, -56.92, -56.92, -56.97, -57.03, -57.12,
        -57.18, -57.22, -57.27, -57.28, -57.32, -57.36, -57.36, -57.45, -57.47, -57.52,
        -57.56, -57.60, -57.63, -57.65, -57.73, -57.65, -57.68, -57.73, -57.69, -57.71,
        -57.79, -57.88, -57.93, -57.98, -58.09, -58.13, -58.18, -58.28, -58.30, -58.33,
        -58.28, -58.28, -58.33, -58.37, -58.43, -58.45, -58.49, -58.54, -58.54, -58.58,
        -58.63, -58.67, -58.64, -58.71, -58.66, -58.69, -58.71, -58.77, -58.85, -58.90,
        -58.94, -58.95, -58.97, -59.00, -59.04, -59.09, -59.15, -59.20, -59.26, -59.30,
        -59.30, -59.30, -59.30, -59.29, -59.34, -59.40, -59.50, -59.60, -59.64, -59.67,
        -59.68, -59.72, -59.70, -59.66, -59.76, -59.80, -59.86, -59.92, -59.96, -59.96,
        -60.03, -60.05, -60.06, -60.14, -60.07, -60.12, -60.10, -60.13, -60.16, -60.19,
        -60.26, -60.27, -60.32, -60.32, -60.27, -60.28, -60.32, -60.32, -60.38, -60.41,
        -60.47, -60.50, -60.56, -60.61, -60.60, -60.66, -60.70, -60.75, -60.69, -60.73,
        -60.73, -60.73, -60.74, -60.81, -60.84, -60.84, -60.84, -60.84, -60.84, -60.89,
        -60.98, -61.00, -60.98, -61.08, -61.09, -61.14, -61.23, -61.28, -61.29, -61.38,
        -61.39, -61.34, -61.44, -61.44, -61.44, -61.44, -61.44, -61.39, -61.44, -61.48,
        -61.43, -61.51, -61.51, -61.43, -61.48, -61.48, -61.49, -61.53, -61.58, -61.60,
        -61.63, -61.67, -61.72, -61.71, -61.72, -61.67, -61.72, -61.72, -61.81, -61.91,
        -61.91, -62.00, -62.01, -62.06, -62.07, -62.11, -62.11, -62.11, -62.11, -62.16,
        -62.16, -62.21, -62.25, -62.26, -62.31, -62.31, -62.24, -62.21, -62.21, -62.20,
        -62.11, -62.15, -62.16, -62.19, -62.20, -62.25, -62.29, -62.29, -62.29, -62.29,
        -62.31, -62.45, -62.46, -62.53, -62.56, -62.56, -62.61, -62.67, -62.72, -62.77,
        -62.78, -62.87, -62.92, -62.92, -62.92, -62.92, -62.97, -62.97, -62.97, -62.97,
        -62.97, -62.86, -62.95, -62.96, -63.00, -63.00, -62.95, -62.90, -62.90, -62.89,
        -62.86, -62.86, -62.90, -62.85, -62.95, -62.95, -62.95, -63.00, -63.00, -63.00,
        -63.00, -63.05, -63.05, -63.10, -63.09, -63.04, -62.99, -62.95, -62.94, -62.90,
        -62.96, -63.04, -63.08, -63.05, -63.09, -63.08, -63.08, -63.08, -63.11, -63.15,
        -63.17, -63.24, -63.31, -63.30, -63.34, -63.38, -63.30, -63.35, -63.35, -63.34,
        -63.35, -63.33, -63.35, -63.42, -63.43, -63.53, -63.48, -63.51, -63.56, -63.48,
        -63.52, -63.65, -63.72, -63.82, -63.91, -63.92, -63.96, -63.91, -63.91, -63.92,
        -63.86, -63.86, -63.90, -63.89, -63.90, -63.99, -63.92, -63.99, -64.06, -64.05,
        -64.08, -64.05, -64.07, -64.03, -64.11, -64.21, -64.22, -64.35, -64.41, -64.46,
        -64.46, -64.45, -64.45, -64.47, -64.52, -64.56, -64.61, -64.66, -64.70, -64.75,
        -64.79, -64.84, -64.88, -64.88, -64.88, -64.88, -64.88, -64.88, -64.92, -64.97,
        -65.04, -65.06, -65.08, -65.08, -65.06, -65.05, -65.06, -65.06, -65.06, -65.06,
        -65.07, -65.12, -65.17, -65.18, -65.23, -65.27, -65.27, -65.27, -65.27, -65.27,
        -65.25, -65.27, -65.24, -65.26, -65.27, -65.23, -65.23, -65.24, -65.27, -65.26,
        -65.26, -65.25, -65.25, -65.25, -65.30, -65.31, -65.40, -65.36, -65.36, -65.37,
        -65.33, -65.32, -65.31, -65.23, -65.26, -65.25, -65.25, -65.28, -65.29, -65.35,
        -65.40, -65.39, -65.45, -65.46, -65.46, -65.41, -65.42, -65.41, -65.37, -65.32,
        -65.31, -65.27, -65.27, -65.26, -65.24, -65.30, -65.32, -65.33, -65.38, -65.42,
        -65.39, -65.48, -65.47, -65.46, -65.39, -65.42, -65.37, -65.32, -65.32, -65.27,
        -65.32, -65.37, -65.38, -65.44, -65.46, -65.41, -65.40, -65.32, -65.32, -65.25,
        -65.27, -65.27, -65.22, -65.28, -65.28, -65.32, -65.37, -65.41, -65.46, -65.44,
        -65.46, -65.42, -65.45, -65.46, -65.44, -65.46, -65.44, -65.46, -65.45, -65.46,
        -65.50, -65.46, -65.50, -65.50, -65.45, -65.46, -65.45, -65.46, -65.42, -65.44,
        -65.46, -65.44, -65.45, -65.44, -65.45, -65.44, -65.44, -65.44, -65.49, -65.53,
        -65.53, -65.59, -65.59, -65.54, -65.54, -65.50, -65.50, -65.55, -65.59, -65.62,
        -65.63, -65.68, -65.68, -65.68, -65.68, -65.64, -65.64, -65.59, -65.55, -65.55,
        -65.55, -65.59, -65.59, -65.59, -65.63, -65.63, -65.63, -65.63, -65.63, -65.63,
        -65.63, -65.68, -65.68, -65.77, -65.79, -65.85, -65.89, -65.88, -65.88, -65.88,
        -65.88, -65.87, -65.82, -65.82, -65.82, -65.75, -65.82, -65.84, -65.80, -65.84,
        -65.85, -65.85, -65.85, -65.85, -65.89, -65.93, -65.99, -65.98, -65.98, -66.03,
        -66.02, -65.97, -65.97, -65.96, -65.96, -66.00, -66.01, -66.02, -65.98, -65.99,
        -66.01, -65.98, -65.94, -65.98, -65.98, -65.98, -66.03, -66.03, -65.98, -66.04,
        -66.02, -66.01, -66.07, -66.06, -66.05, -66.12, -66.14, -66.22, -66.25, -66.22,
        -66.21, -66.20, -66.15, -66.15, -66.10, -66.05, -66.10, -66.02, -66.06, -66.16,
        -66.21, -66.15, -66.16, -66.16, -66.11, -66.06, -66.09, -66.02, -66.00, -66.01,
        -66.05, -66.01, -66.01, -66.02, -66.03, -66.04, -66.03, -66.03, -66.03, -66.06,
        -66.04, -66.04, -66.04, -66.05, -66.07, -66.01, -65.94, -65.89, -65.85, -65.82,
        -65.82, -65.82, -65.82, -65.82, -65.77, -65.76, -65.71, -65.69, -65.73, -65.69,
        -65.74, -65.79, -65.79, -65.79, -65.78, -65.74, -65.68, -65.55, -65.51, -65.46,
        -65.46, -65.50, -65.46, -65.45, -65.37, -65.36, -65.36, -65.40, -65.31, -65.32,
        -65.32, -65.30, -65.22, -65.22, -65.23, -65.20, -65.23, -65.10, -65.09, -65.04,
        -65.06, -64.98, -64.89, -64.91, -64.89, -64.82, -64.75, -64.75, -64.70, -64.67,
        -64.69, -64.60, -64.55, -64.55, -64.50, -64.43, -64.40, -64.36, -64.36, -64.36,
        -64.37, -64.36, -64.27, -64.20, -64.16, -64.13, -64.04, -63.98, -63.97, -63.93,
        -63.87, -63.86, -63.87, -63.83, -63.80, -63.77, -63.75, -63.79, -63.70, -63.69,
        -63.70, -63.61, -63.61, -63.61, -63.54, -63.50, -63.45, -63.35, -63.30, -63.22,
        -63.15, -63.06, -63.02, -63.02, -62.97, -62.92, -62.93, -62.93, -62.90, -62.84,
        -62.79, -62.78, -62.68, -62.58, -62.58, -62.48, -62.42, -62.38, -62.31, -62.23,
        -62.22, -62.13, -62.08, -62.10, -62.02, -61.96, -61.97, -61.95, -61.91, -61.86,
        -61.76, -61.84, -61.76, -61.66, -61.70, -61.66, -61.58, -61.54, -61.44, -61.34,
        -61.27, -61.12, -61.02, -60.98, -60.88, -60.78, -60.74, -60.69, -60.64, -60.60,
        -60.49, -60.41, -60.35, -60.26, -60.21, -60.11, -60.00, -59.95, -59.84, -59.74,
        -59.67, -59.60, -59.54, -59.54, -59.50, -59.40, -59.30, -59.16, -59.02, -58.93,
        -58.83, -58.83, -58.74, -58.70, -58.64, -58.54, -58.40, -58.30, -58.14, -57.98,
        -57.92, -57.82, -57.74, -57.68, -57.58, -57.44, -57.28, -57.15, -57.05, -56.95,
        -56.91, -56.78, -56.66, -56.55, -56.36, -56.23, -56.12, -55.91, -55.81, -55.75,
        -55.60, -55.53, -55.39, -55.18, -55.07, -54.98, -54.87, -54.82
    };

    static const float iso226_2003_curve_30_phons[1382] =
    {
        -25.55, -25.55, -25.60, -25.63,
        -25.66, -25.69, -25.75, -25.81, -25.80, -25.86, -25.87, -25.92, -25.95, -25.98,
        -26.05, -26.12, -26.13, -26.15, -26.19, -26.21, -26.20, -26.24, -26.29, -26.29,
        -26.37, -26.39, -26.44, -26.44, -26.43, -26.52, -26.57, -26.57, -26.64, -26.71,
        -26.71, -26.78, -26.87, -26.89, -26.90, -26.98, -26.99, -26.99, -27.01, -27.04,
        -27.09, -27.12, -27.17, -27.19, -27.26, -27.34, -27.41, -27.46, -27.48, -27.51,
        -27.51, -27.48, -27.47, -27.50, -27.52, -27.52, -27.52, -27.62, -27.64, -27.67,
        -27.79, -27.84, -27.88, -27.89, -28.00, -28.05, -28.08, -28.10, -28.16, -28.15,
        -28.15, -28.19, -28.24, -28.29, -28.30, -28.37, -28.37, -28.41, -28.47, -28.52,
        -28.53, -28.59, -28.64, -28.69, -28.68, -28.69, -28.73, -28.71, -28.72, -28.73,
        -28.76, -28.80, -28.83, -28.93, -28.94, -28.95, -29.08, -29.10, -29.10, -29.11,
        -29.16, -29.18, -29.22, -29.23, -29.28, -29.29, -29.35, -29.38, -29.43, -29.47,
        -29.56, -29.62, -29.66, -29.71, -29.75, -29.73, -29.78, -29.82, -29.86, -29.89,
        -29.90, -29.97, -29.99, -29.99, -30.02, -30.10, -30.11, -30.13, -30.21, -30.25,
        -30.27, -30.30, -30.31, -30.36, -30.37, -30.38, -30.41, -30.48, -30.51, -30.56,
        -30.60, -30.63, -30.69, -30.67, -30.73, -30.78, -30.78, -30.79, -30.87, -30.89,
        -30.91, -30.97, -31.00, -31.04, -31.06, -31.07, -31.10, -31.09, -31.10, -31.13,
        -31.13, -31.16, -31.20, -31.24, -31.29, -31.28, -31.35, -31.39, -31.42, -31.50,
        -31.57, -31.63, -31.73, -31.75, -31.81, -31.84, -31.84, -31.86, -31.88, -31.96,
        -31.95, -32.00, -32.03, -32.09, -32.11, -32.12, -32.12, -32.23, -32.27, -32.32,
        -32.40, -32.41, -32.46, -32.54, -32.54, -32.57, -32.60, -32.60, -32.70, -32.71,
        -32.77, -32.80, -32.79, -32.81, -32.86, -32.85, -32.88, -32.96, -32.95, -32.97,
        -33.05, -33.15, -33.17, -33.25, -33.30, -33.32, -33.31, -33.32, -33.31, -33.32,
        -33.39, -33.35, -33.40, -33.46, -33.46, -33.56, -33.65, -33.66, -33.73, -33.82,
        -33.84, -33.88, -33.89, -33.90, -33.94, -33.92, -33.92, -33.92, -33.98, -34.03,
        -34.12, -34.18, -34.22, -34.32, -34.31, -34.31, -34.41, -34.49, -34.53, -34.58,
        -34.63, -34.61, -34.67, -34.71, -34.69, -34.65, -34.65, -34.70, -34.71, -34.72,
        -34.79, -34.81, -34.86, -34.94, -34.99, -35.01, -35.09, -35.13, -35.14, -35.19,
        -35.22, -35.25, -35.34, -35.38, -35.40, -35.43, -35.46, -35.47, -35.51, -35.58,
        -35.59, -35.67, -35.74, -35.79, -35.88, -35.88, -35.97, -36.04, -36.02, -36.07,
        -36.07, -36.09, -36.15, -36.19, -36.24, -36.28, -36.34, -36.35, -36.39, -36.43,
        -36.43, -36.47, -36.46, -36.49, -36.59, -36.62, -36.62, -36.68, -36.68, -36.70,
        -36.76, -36.76, -36.76, -36.83, -36.86, -36.89, -36.93, -36.99, -37.05, -37.12,
        -37.18, -37.16, -37.13, -37.22, -37.24, -37.23, -37.31, -37.34, -37.39, -37.41,
        -37.52, -37.55, -37.55, -37.63, -37.71, -37.67, -37.67, -37.73, -37.75, -37.83,
        -37.91, -37.92, -38.02, -38.04, -38.07, -38.09, -38.12, -38.19, -38.18, -38.27,
        -38.28, -38.30, -38.38, -38.41, -38.39, -38.41, -38.44, -38.48, -38.47, -38.53,
        -38.62, -38.64, -38.73, -38.79, -38.89, -38.96, -39.03, -39.10, -39.09, -39.12,
        -39.15, -39.13, -39.11, -39.17, -39.17, -39.23, -39.26, -39.32, -39.38, -39.42,
        -39.45, -39.48, -39.53, -39.58, -39.62, -39.67, -39.72, -39.77, -39.84, -39.87,
        -39.94, -39.96, -39.98, -40.09, -40.12, -40.14, -40.19, -40.20, -40.19, -40.26,
        -40.22, -40.18, -40.21, -40.25, -40.30, -40.37, -40.44, -40.46, -40.52, -40.56,
        -40.60, -40.60, -40.65, -40.70, -40.74, -40.79, -40.81, -40.89, -40.89, -40.95,
        -40.99, -41.02, -41.12, -41.16, -41.19, -41.22, -41.31, -41.30, -41.34, -41.38,
        -41.35, -41.42, -41.47, -41.51, -41.54, -41.58, -41.65, -41.63, -41.69, -41.74,
        -41.81, -41.85, -41.90, -41.97, -41.97, -42.00, -42.04, -42.03, -42.02, -42.06,
        -42.09, -42.14, -42.19, -42.27, -42.25, -42.29, -42.30, -42.29, -42.38, -42.42,
        -42.43, -42.50, -42.55, -42.55, -42.65, -42.72, -42.66, -42.75, -42.81, -42.84,
        -42.90, -42.94, -43.01, -42.99, -43.02, -43.06, -43.10, -43.14, -43.17, -43.21,
        -43.21, -43.26, -43.33, -43.42, -43.51, -43.54, -43.61, -43.63, -43.71, -43.72,
        -43.77, -43.81, -43.86, -43.90, -43.92, -44.00, -44.03, -44.09, -44.12, -44.11,
        -44.17, -44.17, -44.15, -44.17, -44.20, -44.18, -44.24, -44.25, -44.25, -44.35,
        -44.40, -44.46, -44.49, -44.51, -44.61, -44.70, -44.74, -44.79, -44.89, -44.88,
        -44.88, -44.91, -44.92, -44.95, -44.98, -45.03, -45.06, -45.11, -45.12, -45.13,
        -45.17, -45.15, -45.20, -45.23, -45.25, -45.36, -45.41, -45.47, -45.56, -45.61,
        -45.70, -45.74, -45.75, -45.79, -45.85, -45.80, -45.87, -45.85, -45.82, -45.90,
        -45.89, -45.92, -45.94, -45.97, -46.04, -46.14, -46.22, -46.29, -46.36, -46.41,
        -46.40, -46.41, -46.44, -46.42, -46.46, -46.50, -46.50, -46.50, -46.53, -46.59,
        -46.64, -46.70, -46.73, -46.82, -46.79, -46.81, -46.87, -46.85, -46.92, -46.96,
        -47.01, -47.04, -47.07, -47.06, -47.07, -47.08, -47.06, -47.10, -47.15, -47.23,
        -47.31, -47.38, -47.37, -47.37, -47.40, -47.40, -47.42, -47.48, -47.55, -47.64,
        -47.70, -47.75, -47.77, -47.78, -47.79, -47.84, -47.86, -47.92, -47.96, -48.00,
        -48.03, -48.04, -48.07, -48.05, -48.13, -48.06, -48.07, -48.14, -48.10, -48.13,
        -48.22, -48.32, -48.38, -48.45, -48.52, -48.54, -48.60, -48.67, -48.69, -48.72,
        -48.67, -48.67, -48.72, -48.77, -48.82, -48.86, -48.89, -48.93, -48.92, -48.95,
        -48.95, -49.01, -48.95, -49.00, -48.98, -48.97, -49.02, -49.11, -49.19, -49.25,
        -49.31, -49.29, -49.32, -49.34, -49.34, -49.39, -49.45, -49.50, -49.55, -49.60,
        -49.59, -49.57, -49.62, -49.57, -49.62, -49.67, -49.75, -49.85, -49.89, -49.88,
        -49.90, -49.93, -49.89, -49.89, -49.94, -49.99, -50.05, -50.10, -50.15, -50.18,
        -50.23, -50.24, -50.28, -50.33, -50.28, -50.31, -50.30, -50.32, -50.35, -50.41,
        -50.45, -50.47, -50.53, -50.52, -50.47, -50.49, -50.53, -50.52, -50.60, -50.64,
        -50.67, -50.71, -50.74, -50.76, -50.74, -50.79, -50.82, -50.86, -50.80, -50.84,
        -50.85, -50.82, -50.87, -50.91, -50.94, -50.98, -50.99, -51.02, -51.03, -51.09,
        -51.14, -51.15, -51.14, -51.19, -51.20, -51.25, -51.32, -51.37, -51.42, -51.47,
        -51.48, -51.48, -51.53, -51.54, -51.56, -51.56, -51.56, -51.53, -51.55, -51.57,
        -51.56, -51.60, -51.60, -51.54, -51.57, -51.57, -51.59, -51.63, -51.65, -51.70,
        -51.72, -51.76, -51.82, -51.78, -51.82, -51.77, -51.81, -51.81, -51.85, -51.93,
        -51.93, -51.98, -52.01, -52.03, -52.06, -52.11, -52.11, -52.11, -52.11, -52.13,
        -52.13, -52.18, -52.23, -52.26, -52.31, -52.31, -52.24, -52.21, -52.21, -52.22,
        -52.13, -52.15, -52.18, -52.23, -52.25, -52.27, -52.29, -52.29, -52.29, -52.29,
        -52.31, -52.43, -52.46, -52.52, -52.54, -52.56, -52.61, -52.67, -52.73, -52.77,
        -52.78, -52.87, -52.89, -52.89, -52.89, -52.89, -52.95, -52.95, -52.95, -52.95,
        -52.95, -52.84, -52.93, -52.96, -52.98, -53.00, -52.95, -52.93, -52.90, -52.87,
        -52.86, -52.86, -52.90, -52.87, -52.95, -52.95, -52.95, -53.00, -52.95, -52.93,
        -52.91, -52.96, -52.96, -53.01, -53.00, -52.97, -52.94, -52.92, -52.92, -52.90,
        -52.94, -53.02, -53.05, -53.03, -53.09, -53.05, -53.04, -53.02, -53.03, -53.06,
        -53.09, -53.15, -53.22, -53.25, -53.30, -53.34, -53.30, -53.35, -53.34, -53.31,
        -53.28, -53.27, -53.28, -53.33, -53.36, -53.42, -53.39, -53.42, -53.45, -53.39,
        -53.43, -53.52, -53.57, -53.65, -53.71, -53.74, -53.78, -53.73, -53.73, -53.75,
        -53.70, -53.70, -53.74, -53.72, -53.73, -53.79, -53.71, -53.78, -53.83, -53.80,
        -53.81, -53.79, -53.80, -53.80, -53.84, -53.92, -53.92, -54.02, -54.05, -54.10,
        -54.10, -54.07, -54.09, -54.10, -54.15, -54.19, -54.24, -54.29, -54.33, -54.36,
        -54.38, -54.40, -54.42, -54.43, -54.43, -54.43, -54.43, -54.43, -54.44, -54.47,
        -54.51, -54.51, -54.50, -54.53, -54.51, -54.49, -54.52, -54.53, -54.56, -54.58,
        -54.61, -54.64, -54.67, -54.67, -54.71, -54.73, -54.73, -54.72, -54.72, -54.73,
        -54.72, -54.73, -54.70, -54.72, -54.72, -54.68, -54.68, -54.68, -54.72, -54.70,
        -54.71, -54.71, -54.68, -54.70, -54.73, -54.70, -54.79, -54.75, -54.74, -54.77,
        -54.75, -54.75, -54.72, -54.69, -54.72, -54.71, -54.70, -54.72, -54.74, -54.80,
        -54.85, -54.83, -54.90, -54.91, -54.91, -54.84, -54.87, -54.89, -54.87, -54.84,
        -54.83, -54.82, -54.79, -54.75, -54.74, -54.76, -54.77, -54.78, -54.84, -54.87,
        -54.84, -54.93, -54.92, -54.90, -54.84, -54.88, -54.82, -54.78, -54.80, -54.73,
        -54.77, -54.80, -54.80, -54.88, -54.88, -54.84, -54.84, -54.77, -54.79, -54.74,
        -54.77, -54.79, -54.74, -54.80, -54.80, -54.81, -54.84, -54.86, -54.88, -54.88,
        -54.89, -54.87, -54.91, -54.91, -54.89, -54.91, -54.89, -54.93, -54.91, -54.91,
        -54.98, -54.92, -54.95, -54.95, -54.90, -54.91, -54.90, -54.89, -54.87, -54.90,
        -54.91, -54.90, -54.88, -54.85, -54.86, -54.83, -54.83, -54.85, -54.87, -54.92,
        -54.92, -54.99, -54.98, -54.95, -54.93, -54.89, -54.89, -54.91, -54.93, -54.95,
        -54.95, -54.98, -54.98, -54.98, -55.01, -54.98, -54.98, -54.95, -54.91, -54.91,
        -54.91, -54.93, -54.93, -54.93, -54.95, -54.95, -54.95, -54.95, -54.95, -54.95,
        -54.95, -54.98, -54.98, -55.07, -55.09, -55.15, -55.19, -55.18, -55.17, -55.17,
        -55.17, -55.16, -55.14, -55.12, -55.10, -55.04, -55.09, -55.11, -55.09, -55.16,
        -55.17, -55.17, -55.17, -55.17, -55.19, -55.22, -55.28, -55.28, -55.30, -55.35,
        -55.34, -55.31, -55.28, -55.25, -55.24, -55.27, -55.25, -55.26, -55.24, -55.23,
        -55.26, -55.25, -55.23, -55.30, -55.30, -55.29, -55.35, -55.32, -55.30, -55.33,
        -55.29, -55.28, -55.33, -55.33, -55.33, -55.39, -55.42, -55.46, -55.46, -55.42,
        -55.41, -55.38, -55.35, -55.34, -55.32, -55.29, -55.35, -55.28, -55.33, -55.43,
        -55.46, -55.42, -55.43, -55.43, -55.38, -55.33, -55.34, -55.28, -55.27, -55.27,
        -55.29, -55.25, -55.27, -55.28, -55.28, -55.29, -55.30, -55.30, -55.30, -55.32,
        -55.31, -55.31, -55.31, -55.32, -55.34, -55.31, -55.24, -55.22, -55.19, -55.18,
        -55.18, -55.18, -55.18, -55.18, -55.12, -55.09, -55.06, -55.05, -55.09, -55.05,
        -55.11, -55.15, -55.15, -55.15, -55.14, -55.11, -55.06, -54.97, -54.96, -54.91,
        -54.90, -54.93, -54.93, -54.93, -54.85, -54.84, -54.83, -54.85, -54.76, -54.77,
        -54.79, -54.77, -54.74, -54.75, -54.77, -54.77, -54.77, -54.66, -54.66, -54.59,
        -54.59, -54.53, -54.44, -54.47, -54.45, -54.40, -54.36, -54.34, -54.32, -54.29,
        -54.30, -54.25, -54.19, -54.21, -54.16, -54.12, -54.10, -54.06, -54.06, -54.07,
        -54.07, -54.06, -53.99, -53.91, -53.87, -53.83, -53.77, -53.73, -53.70, -53.65,
        -53.62, -53.59, -53.60, -53.59, -53.58, -53.56, -53.56, -53.61, -53.52, -53.53,
        -53.54, -53.43, -53.43, -53.40, -53.34, -53.30, -53.25, -53.14, -53.07, -53.03,
        -52.99, -52.90, -52.89, -52.90, -52.85, -52.78, -52.79, -52.77, -52.75, -52.70,
        -52.65, -52.67, -52.57, -52.47, -52.46, -52.39, -52.33, -52.28, -52.24, -52.14,
        -52.13, -52.04, -52.01, -52.02, -51.94, -51.89, -51.91, -51.87, -51.83, -51.80,
        -51.72, -51.75, -51.66, -51.61, -51.63, -51.58, -51.52, -51.46, -51.38, -51.31,
        -51.24, -51.11, -51.02, -50.98, -50.88, -50.80, -50.74, -50.71, -50.66, -50.61,
        -50.50, -50.43, -50.40, -50.30, -50.28, -50.20, -50.09, -50.04, -49.93, -49.83,
        -49.76, -49.69, -49.63, -49.64, -49.59, -49.49, -49.42, -49.30, -49.18, -49.11,
        -49.06, -49.01, -48.93, -48.93, -48.82, -48.74, -48.63, -48.56, -48.42, -48.30,
        -48.20, -48.13, -48.06, -47.98, -47.93, -47.82, -47.70, -47.62, -47.54, -47.42,
        -47.38, -47.28, -47.16, -47.03, -46.87, -46.76, -46.65, -46.48, -46.39, -46.38,
        -46.26, -46.20, -46.08, -45.91, -45.83, -45.73, -45.62, -45.58
    };

    static const float iso226_2003_curve_40_phons[1382] =
    {
        -20.46, -20.44, -20.48, -20.53,
        -20.54, -20.55, -20.59, -20.63, -20.59, -20.63, -20.62, -20.65, -20.69, -20.72,
        -20.79, -20.84, -20.84, -20.84, -20.85, -20.89, -20.86, -20.90, -20.94, -20.94,
        -20.99, -21.00, -21.03, -21.03, -21.00, -21.09, -21.13, -21.12, -21.16, -21.24,
        -21.24, -21.29, -21.38, -21.36, -21.37, -21.44, -21.45, -21.46, -21.47, -21.48,
        -21.52, -21.53, -21.58, -21.58, -21.65, -21.70, -21.76, -21.81, -21.82, -21.86,
        -21.85, -21.83, -21.84, -21.86, -21.86, -21.84, -21.84, -21.87, -21.85, -21.90,
        -21.99, -22.02, -22.04, -22.07, -22.16, -22.19, -22.21, -22.26, -22.29, -22.30,
        -22.26, -22.26, -22.31, -22.35, -22.35, -22.44, -22.45, -22.49, -22.55, -22.59,
        -22.59, -22.66, -22.70, -22.74, -22.74, -22.74, -22.76, -22.70, -22.68, -22.68,
        -22.72, -22.72, -22.75, -22.82, -22.82, -22.83, -22.94, -22.98, -22.98, -22.99,
        -23.05, -23.07, -23.10, -23.10, -23.14, -23.14, -23.19, -23.20, -23.25, -23.26,
        -23.35, -23.42, -23.44, -23.48, -23.50, -23.47, -23.49, -23.50, -23.54, -23.58,
        -23.60, -23.67, -23.69, -23.69, -23.72, -23.79, -23.79, -23.78, -23.85, -23.89,
        -23.92, -23.93, -23.93, -23.97, -23.97, -23.97, -23.98, -24.03, -24.08, -24.12,
        -24.13, -24.17, -24.20, -24.16, -24.22, -24.27, -24.23, -24.24, -24.32, -24.32,
        -24.32, -24.36, -24.41, -24.45, -24.48, -24.48, -24.49, -24.52, -24.52, -24.55,
        -24.52, -24.56, -24.60, -24.62, -24.67, -24.65, -24.71, -24.72, -24.76, -24.81,
        -24.90, -24.96, -25.03, -25.06, -25.08, -25.10, -25.10, -25.10, -25.11, -25.18,
        -25.14, -25.19, -25.22, -25.27, -25.29, -25.29, -25.28, -25.37, -25.40, -25.45,
        -25.55, -25.57, -25.63, -25.73, -25.71, -25.71, -25.75, -25.71, -25.84, -25.84,
        -25.88, -25.90, -25.90, -25.91, -25.89, -25.89, -25.89, -25.92, -25.91, -25.94,
        -26.04, -26.14, -26.19, -26.26, -26.29, -26.33, -26.32, -26.28, -26.28, -26.29,
        -26.33, -26.29, -26.34, -26.38, -26.39, -26.49, -26.58, -26.58, -26.63, -26.71,
        -26.75, -26.75, -26.73, -26.72, -26.75, -26.69, -26.68, -26.68, -26.75, -26.80,
        -26.87, -26.93, -26.94, -27.03, -27.02, -27.02, -27.09, -27.14, -27.19, -27.27,
        -27.29, -27.27, -27.32, -27.36, -27.34, -27.30, -27.30, -27.32, -27.33, -27.33,
        -27.39, -27.40, -27.44, -27.54, -27.59, -27.60, -27.69, -27.72, -27.72, -27.75,
        -27.76, -27.79, -27.85, -27.87, -27.89, -27.92, -27.94, -27.95, -28.00, -28.08,
        -28.10, -28.20, -28.26, -28.31, -28.39, -28.39, -28.48, -28.52, -28.49, -28.54,
        -28.53, -28.54, -28.58, -28.59, -28.64, -28.68, -28.72, -28.70, -28.74, -28.74,
        -28.73, -28.74, -28.74, -28.78, -28.87, -28.88, -28.87, -28.92, -28.91, -28.91,
        -28.97, -28.95, -28.98, -29.08, -29.12, -29.13, -29.18, -29.22, -29.27, -29.31,
        -29.37, -29.32, -29.32, -29.41, -29.40, -29.36, -29.43, -29.46, -29.51, -29.49,
        -29.58, -29.65, -29.63, -29.68, -29.76, -29.72, -29.72, -29.76, -29.76, -29.84,
        -29.98, -30.00, -30.09, -30.10, -30.14, -30.14, -30.15, -30.19, -30.15, -30.25,
        -30.28, -30.26, -30.34, -30.38, -30.35, -30.35, -30.38, -30.40, -30.36, -30.45,
        -30.54, -30.53, -30.64, -30.69, -30.79, -30.84, -30.88, -30.95, -30.91, -30.93,
        -30.98, -30.93, -30.89, -30.98, -30.98, -31.03, -31.06, -31.11, -31.17, -31.22,
        -31.22, -31.24, -31.28, -31.33, -31.33, -31.38, -31.43, -31.48, -31.55, -31.58,
        -31.63, -31.67, -31.72, -31.80, -31.81, -31.83, -31.88, -31.87, -31.88, -31.92,
        -31.86, -31.82, -31.83, -31.83, -31.87, -31.92, -31.96, -31.98, -32.02, -32.07,
        -32.11, -32.12, -32.16, -32.20, -32.25, -32.30, -32.34, -32.40, -32.40, -32.49,
        -32.51, -32.54, -32.64, -32.68, -32.71, -32.72, -32.81, -32.78, -32.79, -32.86,
        -32.81, -32.86, -32.90, -32.95, -32.96, -33.00, -33.06, -33.09, -33.11, -33.16,
        -33.25, -33.29, -33.34, -33.39, -33.38, -33.39, -33.43, -33.38, -33.38, -33.43,
        -33.43, -33.49, -33.53, -33.59, -33.55, -33.60, -33.60, -33.55, -33.63, -33.67,
        -33.69, -33.74, -33.78, -33.79, -33.88, -33.97, -33.89, -33.99, -34.05, -34.12,
        -34.17, -34.17, -34.22, -34.19, -34.19, -34.23, -34.22, -34.28, -34.31, -34.33,
        -34.33, -34.38, -34.43, -34.49, -34.58, -34.59, -34.66, -34.68, -34.77, -34.79,
        -34.82, -34.86, -34.91, -34.95, -34.96, -35.05, -35.08, -35.13, -35.16, -35.16,
        -35.21, -35.20, -35.19, -35.20, -35.22, -35.19, -35.22, -35.22, -35.21, -35.31,
        -35.36, -35.41, -35.42, -35.47, -35.56, -35.65, -35.66, -35.75, -35.84, -35.84,
        -35.84, -35.85, -35.84, -35.89, -35.90, -35.92, -35.95, -36.00, -35.99, -36.00,
        -36.03, -36.00, -36.05, -36.05, -36.05, -36.14, -36.17, -36.25, -36.34, -36.36,
        -36.46, -36.52, -36.53, -36.56, -36.62, -36.58, -36.63, -36.62, -36.58, -36.63,
        -36.62, -36.63, -36.63, -36.63, -36.73, -36.82, -36.87, -36.94, -37.04, -37.09,
        -37.09, -37.10, -37.10, -37.10, -37.14, -37.19, -37.15, -37.18, -37.21, -37.28,
        -37.31, -37.38, -37.39, -37.47, -37.41, -37.40, -37.48, -37.44, -37.48, -37.52,
        -37.58, -37.61, -37.65, -37.64, -37.66, -37.67, -37.65, -37.66, -37.72, -37.77,
        -37.82, -37.88, -37.85, -37.87, -37.88, -37.87, -37.92, -37.98, -38.08, -38.16,
        -38.23, -38.27, -38.27, -38.28, -38.27, -38.32, -38.37, -38.40, -38.46, -38.48,
        -38.50, -38.48, -38.50, -38.46, -38.53, -38.48, -38.46, -38.55, -38.51, -38.56,
        -38.66, -38.75, -38.82, -38.91, -38.95, -38.95, -39.02, -39.06, -39.08, -39.10,
        -39.06, -39.06, -39.11, -39.16, -39.21, -39.27, -39.29, -39.31, -39.29, -39.31,
        -39.27, -39.35, -39.26, -39.30, -39.29, -39.25, -39.34, -39.44, -39.53, -39.59,
        -39.67, -39.64, -39.67, -39.69, -39.63, -39.69, -39.74, -39.79, -39.84, -39.89,
        -39.88, -39.85, -39.93, -39.85, -39.89, -39.94, -40.00, -40.10, -40.14, -40.08,
        -40.13, -40.13, -40.07, -40.12, -40.13, -40.18, -40.24, -40.29, -40.33, -40.39,
        -40.42, -40.42, -40.51, -40.51, -40.48, -40.51, -40.51, -40.52, -40.53, -40.63,
        -40.63, -40.68, -40.73, -40.73, -40.67, -40.69, -40.74, -40.73, -40.82, -40.86,
        -40.87, -40.91, -40.92, -40.92, -40.87, -40.92, -40.93, -40.98, -40.92, -40.96,
        -40.96, -40.92, -41.00, -41.01, -41.05, -41.11, -41.14, -41.20, -41.21, -41.29,
        -41.30, -41.30, -41.30, -41.30, -41.31, -41.36, -41.41, -41.46, -41.55, -41.57,
        -41.58, -41.61, -41.63, -41.63, -41.67, -41.67, -41.67, -41.66, -41.66, -41.67,
        -41.70, -41.70, -41.70, -41.65, -41.66, -41.67, -41.70, -41.72, -41.72, -41.79,
        -41.81, -41.86, -41.91, -41.85, -41.92, -41.87, -41.90, -41.90, -41.90, -41.95,
        -41.95, -41.96, -42.01, -42.01, -42.06, -42.11, -42.11, -42.11, -42.11, -42.11,
        -42.11, -42.16, -42.21, -42.26, -42.31, -42.31, -42.24, -42.21, -42.21, -42.24,
        -42.16, -42.16, -42.20, -42.27, -42.29, -42.29, -42.29, -42.29, -42.29, -42.29,
        -42.31, -42.40, -42.46, -42.51, -42.52, -42.56, -42.61, -42.67, -42.75, -42.77,
        -42.78, -42.87, -42.87, -42.87, -42.87, -42.87, -42.92, -42.92, -42.92, -42.92,
        -42.92, -42.82, -42.91, -42.95, -42.95, -43.00, -42.95, -42.95, -42.90, -42.85,
        -42.86, -42.86, -42.90, -42.90, -42.95, -42.95, -42.95, -43.00, -42.91, -42.86,
        -42.82, -42.87, -42.87, -42.91, -42.91, -42.90, -42.89, -42.89, -42.89, -42.90,
        -42.92, -42.99, -43.03, -43.01, -43.09, -43.03, -42.99, -42.95, -42.95, -42.97,
        -43.01, -43.06, -43.13, -43.20, -43.25, -43.30, -43.30, -43.35, -43.34, -43.28,
        -43.22, -43.21, -43.21, -43.24, -43.29, -43.31, -43.30, -43.33, -43.35, -43.29,
        -43.34, -43.39, -43.41, -43.47, -43.52, -43.56, -43.60, -43.56, -43.55, -43.58,
        -43.54, -43.54, -43.58, -43.56, -43.57, -43.58, -43.51, -43.57, -43.60, -43.55,
        -43.55, -43.54, -43.54, -43.57, -43.57, -43.62, -43.62, -43.70, -43.70, -43.74,
        -43.73, -43.69, -43.73, -43.74, -43.79, -43.82, -43.88, -43.93, -43.97, -43.97,
        -43.97, -43.97, -43.97, -43.97, -43.97, -43.97, -43.97, -43.97, -43.96, -43.96,
        -43.99, -43.96, -43.93, -43.98, -43.96, -43.92, -43.97, -44.00, -44.06, -44.11,
        -44.15, -44.16, -44.16, -44.17, -44.18, -44.18, -44.18, -44.18, -44.18, -44.18,
        -44.19, -44.18, -44.17, -44.18, -44.17, -44.13, -44.13, -44.13, -44.17, -44.14,
        -44.16, -44.16, -44.11, -44.15, -44.15, -44.09, -44.17, -44.13, -44.11, -44.18,
        -44.18, -44.18, -44.14, -44.14, -44.17, -44.16, -44.15, -44.16, -44.19, -44.25,
        -44.31, -44.26, -44.35, -44.36, -44.36, -44.28, -44.33, -44.36, -44.37, -44.37,
        -44.36, -44.36, -44.32, -44.24, -44.24, -44.22, -44.21, -44.23, -44.29, -44.32,
        -44.29, -44.38, -44.37, -44.33, -44.29, -44.33, -44.27, -44.23, -44.27, -44.18,
        -44.22, -44.22, -44.22, -44.31, -44.31, -44.27, -44.28, -44.23, -44.27, -44.22,
        -44.26, -44.31, -44.26, -44.31, -44.31, -44.31, -44.32, -44.32, -44.31, -44.32,
        -44.32, -44.32, -44.36, -44.36, -44.34, -44.35, -44.34, -44.40, -44.36, -44.36,
        -44.45, -44.37, -44.41, -44.41, -44.36, -44.36, -44.35, -44.31, -44.32, -44.35,
        -44.36, -44.35, -44.31, -44.26, -44.26, -44.22, -44.21, -44.26, -44.26, -44.30,
        -44.30, -44.40, -44.37, -44.36, -44.32, -44.27, -44.27, -44.27, -44.27, -44.27,
        -44.27, -44.27, -44.27, -44.27, -44.33, -44.32, -44.32, -44.32, -44.27, -44.27,
        -44.27, -44.27, -44.27, -44.27, -44.27, -44.27, -44.27, -44.27, -44.27, -44.27,
        -44.27, -44.27, -44.28, -44.36, -44.38, -44.44, -44.48, -44.48, -44.47, -44.47,
        -44.47, -44.46, -44.46, -44.42, -44.37, -44.34, -44.36, -44.38, -44.38, -44.48,
        -44.48, -44.48, -44.48, -44.48, -44.48, -44.52, -44.57, -44.57, -44.62, -44.67,
        -44.66, -44.65, -44.60, -44.54, -44.53, -44.54, -44.48, -44.51, -44.50, -44.48,
        -44.51, -44.53, -44.53, -44.61, -44.61, -44.61, -44.66, -44.61, -44.61, -44.62,
        -44.56, -44.55, -44.58, -44.60, -44.60, -44.66, -44.70, -44.71, -44.68, -44.63,
        -44.61, -44.57, -44.55, -44.54, -44.55, -44.53, -44.60, -44.54, -44.60, -44.70,
        -44.72, -44.69, -44.70, -44.70, -44.64, -44.59, -44.58, -44.53, -44.54, -44.54,
        -44.54, -44.50, -44.52, -44.54, -44.54, -44.53, -44.57, -44.57, -44.57, -44.57,
        -44.58, -44.58, -44.57, -44.59, -44.61, -44.60, -44.55, -44.55, -44.53, -44.54,
        -44.54, -44.54, -44.54, -44.54, -44.46, -44.42, -44.41, -44.41, -44.45, -44.42,
        -44.47, -44.51, -44.51, -44.51, -44.49, -44.47, -44.44, -44.39, -44.41, -44.36,
        -44.33, -44.36, -44.41, -44.40, -44.32, -44.31, -44.30, -44.30, -44.21, -44.22,
        -44.27, -44.25, -44.25, -44.27, -44.31, -44.33, -44.32, -44.22, -44.22, -44.14,
        -44.12, -44.07, -43.99, -44.03, -44.02, -43.97, -43.96, -43.93, -43.95, -43.91,
        -43.92, -43.89, -43.83, -43.86, -43.82, -43.81, -43.79, -43.75, -43.75, -43.77,
        -43.77, -43.75, -43.72, -43.62, -43.57, -43.54, -43.49, -43.47, -43.43, -43.38,
        -43.36, -43.31, -43.32, -43.36, -43.37, -43.36, -43.37, -43.42, -43.33, -43.38,
        -43.38, -43.24, -43.25, -43.20, -43.13, -43.09, -43.04, -42.93, -42.84, -42.84,
        -42.83, -42.74, -42.76, -42.79, -42.74, -42.65, -42.65, -42.61, -42.61, -42.56,
        -42.51, -42.55, -42.46, -42.36, -42.35, -42.30, -42.24, -42.18, -42.16, -42.05,
        -42.03, -41.95, -41.95, -41.95, -41.86, -41.81, -41.85, -41.80, -41.75, -41.73,
        -41.67, -41.66, -41.57, -41.55, -41.56, -41.51, -41.47, -41.38, -41.33, -41.28,
        -41.21, -41.11, -41.02, -40.98, -40.88, -40.83, -40.75, -40.73, -40.69, -40.63,
        -40.52, -40.45, -40.44, -40.35, -40.34, -40.29, -40.18, -40.13, -40.02, -39.92,
        -39.85, -39.78, -39.73, -39.73, -39.68, -39.58, -39.54, -39.44, -39.34, -39.29,
        -39.28, -39.20, -39.11, -39.15, -39.01, -38.95, -38.86, -38.81, -38.69, -38.61,
        -38.48, -38.43, -38.37, -38.27, -38.27, -38.19, -38.12, -38.09, -38.03, -37.88,
        -37.86, -37.78, -37.66, -37.51, -37.37, -37.28, -37.19, -37.05, -36.97, -37.00,
        -36.93, -36.86, -36.76, -36.64, -36.58, -36.49, -36.37, -36.33
    };

    static const float iso226_2003_curve_50_phons[1382] =
    {
        -15.66, -15.65, -15.67, -15.67,
        -15.68, -15.69, -15.71, -15.73, -15.71, -15.75, -15.72, -15.76, -15.79, -15.80,
        -15.86, -15.94, -15.94, -15.94, -15.96, -15.96, -15.95, -15.99, -16.01, -15.98,
        -16.04, -16.04, -16.05, -16.03, -16.02, -16.11, -16.13, -16.14, -16.18, -16.25,
        -16.22, -16.27, -16.35, -16.30, -16.31, -16.37, -16.35, -16.35, -16.35, -16.39,
        -16.43, -16.43, -16.49, -16.47, -16.53, -16.58, -16.63, -16.66, -16.68, -16.70,
        -16.69, -16.65, -16.64, -16.65, -16.67, -16.65, -16.66, -16.71, -16.68, -16.70,
        -16.79, -16.82, -16.85, -16.87, -16.93, -16.96, -16.98, -17.00, -17.02, -17.01,
        -16.97, -16.98, -17.02, -17.05, -17.03, -17.10, -17.08, -17.10, -17.16, -17.20,
        -17.20, -17.27, -17.31, -17.33, -17.32, -17.30, -17.35, -17.32, -17.29, -17.31,
        -17.32, -17.29, -17.32, -17.38, -17.37, -17.38, -17.48, -17.50, -17.51, -17.53,
        -17.59, -17.63, -17.64, -17.64, -17.66, -17.67, -17.71, -17.72, -17.76, -17.80,
        -17.86, -17.91, -17.91, -17.93, -17.94, -17.90, -17.93, -17.97, -17.99, -18.01,
        -18.03, -18.10, -18.12, -18.09, -18.12, -18.20, -18.19, -18.16, -18.23, -18.25,
        -18.26, -18.26, -18.24, -18.29, -18.29, -18.28, -18.27, -18.34, -18.37, -18.41,
        -18.44, -18.46, -18.50, -18.45, -18.50, -18.54, -18.52, -18.49, -18.57, -18.57,
        -18.56, -18.58, -18.61, -18.63, -18.64, -18.65, -18.69, -18.73, -18.74, -18.76,
        -18.74, -18.77, -18.78, -18.81, -18.84, -18.80, -18.86, -18.87, -18.89, -18.92,
        -18.99, -19.04, -19.12, -19.14, -19.18, -19.17, -19.17, -19.17, -19.17, -19.20,
        -19.19, -19.21, -19.21, -19.25, -19.26, -19.26, -19.24, -19.35, -19.38, -19.45,
        -19.54, -19.56, -19.63, -19.70, -19.68, -19.68, -19.70, -19.66, -19.74, -19.75,
        -19.76, -19.78, -19.77, -19.79, -19.78, -19.77, -19.77, -19.83, -19.79, -19.80,
        -19.88, -19.98, -20.00, -20.07, -20.10, -20.12, -20.07, -20.07, -20.07, -20.08,
        -20.10, -20.06, -20.12, -20.15, -20.15, -20.25, -20.30, -20.31, -20.35, -20.40,
        -20.41, -20.41, -20.41, -20.42, -20.41, -20.38, -20.38, -20.38, -20.42, -20.47,
        -20.53, -20.59, -20.61, -20.70, -20.65, -20.65, -20.72, -20.76, -20.77, -20.83,
        -20.87, -20.86, -20.88, -20.90, -20.84, -20.79, -20.79, -20.79, -20.80, -20.81,
        -20.88, -20.89, -20.90, -20.99, -21.04, -21.05, -21.09, -21.11, -21.11, -21.17,
        -21.18, -21.17, -21.25, -21.29, -21.29, -21.31, -21.33, -21.34, -21.38, -21.46,
        -21.48, -21.56, -21.59, -21.61, -21.68, -21.66, -21.72, -21.77, -21.73, -21.78,
        -21.75, -21.76, -21.80, -21.83, -21.86, -21.89, -21.93, -21.93, -21.96, -21.96,
        -21.95, -21.96, -21.96, -21.95, -22.02, -22.03, -22.00, -22.03, -22.02, -22.03,
        -22.10, -22.09, -22.13, -22.20, -22.23, -22.26, -22.28, -22.31, -22.33, -22.35,
        -22.40, -22.37, -22.34, -22.42, -22.42, -22.40, -22.45, -22.48, -22.53, -22.54,
        -22.61, -22.66, -22.67, -22.71, -22.76, -22.72, -22.70, -22.71, -22.71, -22.77,
        -22.85, -22.85, -22.95, -22.95, -22.98, -22.98, -22.98, -23.04, -22.98, -23.08,
        -23.12, -23.13, -23.18, -23.21, -23.18, -23.19, -23.21, -23.23, -23.17, -23.26,
        -23.30, -23.28, -23.38, -23.40, -23.48, -23.53, -23.55, -23.61, -23.57, -23.58,
        -23.63, -23.60, -23.54, -23.63, -23.63, -23.67, -23.70, -23.75, -23.82, -23.85,
        -23.88, -23.86, -23.87, -23.91, -23.91, -23.94, -23.98, -24.04, -24.08, -24.12,
        -24.16, -24.16, -24.19, -24.27, -24.27, -24.30, -24.35, -24.34, -24.34, -24.39,
        -24.33, -24.29, -24.29, -24.32, -24.33, -24.39, -24.43, -24.44, -24.47, -24.49,
        -24.51, -24.49, -24.52, -24.54, -24.56, -24.60, -24.62, -24.68, -24.68, -24.75,
        -24.78, -24.81, -24.92, -24.95, -24.99, -25.00, -25.09, -25.06, -25.06, -25.12,
        -25.07, -25.12, -25.14, -25.16, -25.17, -25.19, -25.26, -25.25, -25.30, -25.35,
        -25.39, -25.41, -25.46, -25.49, -25.46, -25.49, -25.48, -25.44, -25.46, -25.48,
        -25.50, -25.55, -25.60, -25.69, -25.65, -25.68, -25.70, -25.65, -25.71, -25.73,
        -25.72, -25.75, -25.79, -25.79, -25.87, -25.93, -25.90, -25.97, -26.01, -26.05,
        -26.07, -26.09, -26.11, -26.08, -26.08, -26.10, -26.12, -26.20, -26.18, -26.22,
        -26.25, -26.27, -26.33, -26.40, -26.48, -26.49, -26.55, -26.53, -26.58, -26.61,
        -26.60, -26.62, -26.65, -26.67, -26.70, -26.75, -26.77, -26.83, -26.89, -26.85,
        -26.92, -26.94, -26.90, -26.92, -26.96, -26.90, -26.96, -26.95, -26.93, -27.03,
        -27.05, -27.11, -27.11, -27.14, -27.21, -27.25, -27.26, -27.30, -27.37, -27.36,
        -27.35, -27.38, -27.38, -27.40, -27.43, -27.45, -27.45, -27.53, -27.52, -27.50,
        -27.53, -27.50, -27.55, -27.57, -27.55, -27.63, -27.68, -27.74, -27.78, -27.83,
        -27.89, -27.91, -27.90, -27.92, -27.97, -27.92, -27.98, -27.95, -27.92, -27.98,
        -27.96, -27.97, -27.98, -27.98, -28.05, -28.15, -28.20, -28.26, -28.37, -28.42,
        -28.39, -28.42, -28.43, -28.44, -28.44, -28.47, -28.45, -28.44, -28.46, -28.51,
        -28.55, -28.61, -28.65, -28.71, -28.64, -28.67, -28.71, -28.67, -28.72, -28.73,
        -28.76, -28.76, -28.80, -28.78, -28.78, -28.81, -28.78, -28.79, -28.85, -28.90,
        -28.95, -29.02, -28.99, -28.99, -29.02, -29.00, -29.02, -29.10, -29.17, -29.24,
        -29.30, -29.33, -29.35, -29.35, -29.32, -29.35, -29.37, -29.39, -29.41, -29.43,
        -29.44, -29.43, -29.44, -29.42, -29.47, -29.43, -29.42, -29.48, -29.44, -29.49,
        -29.57, -29.64, -29.70, -29.75, -29.82, -29.82, -29.86, -29.93, -29.93, -29.95,
        -29.93, -29.93, -29.96, -30.03, -30.06, -30.13, -30.15, -30.16, -30.15, -30.16,
        -30.14, -30.17, -30.08, -30.10, -30.07, -30.02, -30.10, -30.17, -30.24, -30.30,
        -30.36, -30.32, -30.34, -30.37, -30.32, -30.37, -30.42, -30.48, -30.53, -30.56,
        -30.57, -30.53, -30.60, -30.54, -30.55, -30.61, -30.68, -30.75, -30.78, -30.72,
        -30.73, -30.73, -30.66, -30.67, -30.70, -30.75, -30.81, -30.86, -30.88, -30.91,
        -30.92, -30.92, -30.97, -30.99, -30.96, -30.99, -31.01, -31.02, -31.03, -31.12,
        -31.13, -31.16, -31.23, -31.21, -31.16, -31.19, -31.24, -31.21, -31.25, -31.27,
        -31.28, -31.30, -31.35, -31.36, -31.31, -31.38, -31.39, -31.41, -31.33, -31.34,
        -31.32, -31.32, -31.37, -31.38, -31.44, -31.48, -31.49, -31.52, -31.53, -31.57,
        -31.59, -31.60, -31.57, -31.60, -31.60, -31.65, -31.71, -31.76, -31.83, -31.86,
        -31.89, -31.90, -31.94, -31.95, -31.97, -31.97, -31.97, -31.94, -31.94, -31.94,
        -31.93, -31.93, -31.93, -31.89, -31.91, -31.94, -31.98, -31.99, -31.99, -32.03,
        -32.04, -32.06, -32.11, -32.06, -32.12, -32.07, -32.08, -32.08, -32.08, -32.13,
        -32.13, -32.16, -32.22, -32.22, -32.27, -32.29, -32.29, -32.29, -32.29, -32.29,
        -32.29, -32.33, -32.37, -32.42, -32.47, -32.47, -32.40, -32.37, -32.40, -32.40,
        -32.32, -32.32, -32.34, -32.37, -32.38, -32.38, -32.38, -32.38, -32.38, -32.38,
        -32.44, -32.52, -32.57, -32.62, -32.65, -32.68, -32.73, -32.81, -32.87, -32.89,
        -32.92, -32.96, -32.96, -32.96, -32.96, -32.96, -33.01, -33.01, -33.01, -33.01,
        -33.01, -32.91, -32.95, -32.98, -32.98, -33.00, -32.95, -32.95, -32.90, -32.87,
        -32.90, -32.90, -32.92, -32.90, -32.98, -32.95, -32.95, -33.00, -32.95, -32.93,
        -32.91, -32.96, -32.96, -32.98, -32.95, -32.92, -32.89, -32.89, -32.89, -32.90,
        -32.91, -32.97, -32.98, -32.96, -33.04, -32.96, -32.97, -32.95, -32.95, -32.99,
        -33.00, -33.08, -33.13, -33.20, -33.25, -33.26, -33.26, -33.28, -33.28, -33.25,
        -33.19, -33.16, -33.19, -33.20, -33.22, -33.26, -33.23, -33.23, -33.28, -33.23,
        -33.25, -33.32, -33.34, -33.40, -33.44, -33.49, -33.48, -33.44, -33.43, -33.42,
        -33.38, -33.38, -33.39, -33.38, -33.39, -33.42, -33.37, -33.42, -33.48, -33.45,
        -33.43, -33.40, -33.38, -33.36, -33.37, -33.42, -33.42, -33.50, -33.51, -33.55,
        -33.55, -33.53, -33.55, -33.55, -33.60, -33.60, -33.65, -33.69, -33.69, -33.71,
        -33.69, -33.72, -33.70, -33.70, -33.70, -33.70, -33.70, -33.70, -33.71, -33.74,
        -33.78, -33.78, -33.73, -33.76, -33.74, -33.68, -33.70, -33.71, -33.74, -33.76,
        -33.79, -33.84, -33.84, -33.87, -33.90, -33.90, -33.91, -33.90, -33.90, -33.91,
        -33.91, -33.90, -33.88, -33.90, -33.90, -33.86, -33.85, -33.86, -33.88, -33.83,
        -33.85, -33.82, -33.78, -33.79, -33.81, -33.79, -33.87, -33.86, -33.85, -33.90,
        -33.90, -33.90, -33.86, -33.85, -33.87, -33.81, -33.78, -33.81, -33.83, -33.88,
        -33.94, -33.90, -33.99, -34.00, -33.99, -33.95, -33.98, -34.00, -34.00, -34.00,
        -33.99, -33.99, -33.97, -33.93, -33.90, -33.92, -33.92, -33.95, -34.01, -34.03,
        -34.02, -34.08, -34.05, -34.01, -33.97, -34.01, -33.95, -33.93, -33.96, -33.90,
        -33.93, -33.93, -33.93, -33.97, -33.99, -33.94, -33.97, -33.92, -33.95, -33.90,
        -33.93, -33.97, -33.90, -33.97, -33.95, -33.95, -33.97, -33.97, -33.99, -33.97,
        -33.97, -33.99, -34.00, -34.01, -34.00, -34.01, -34.00, -34.02, -34.01, -34.00,
        -34.06, -34.00, -34.02, -34.02, -33.98, -33.98, -33.96, -33.97, -33.96, -33.95,
        -33.99, -33.97, -33.94, -33.92, -33.92, -33.90, -33.87, -33.89, -33.89, -33.91,
        -33.91, -33.99, -33.99, -33.97, -33.97, -33.95, -33.95, -33.95, -33.95, -33.95,
        -33.95, -33.95, -33.95, -33.95, -33.98, -33.97, -33.98, -33.98, -33.95, -33.95,
        -33.95, -33.95, -33.95, -33.95, -33.95, -33.95, -33.95, -33.95, -33.95, -33.95,
        -33.95, -33.95, -33.95, -34.04, -34.06, -34.12, -34.16, -34.13, -34.10, -34.10,
        -34.10, -34.07, -34.07, -34.05, -34.03, -33.98, -34.04, -34.06, -34.06, -34.16,
        -34.16, -34.16, -34.16, -34.16, -34.16, -34.19, -34.21, -34.21, -34.21, -34.25,
        -34.22, -34.19, -34.14, -34.07, -34.06, -34.08, -34.08, -34.12, -34.14, -34.16,
        -34.16, -34.18, -34.16, -34.23, -34.25, -34.24, -34.25, -34.23, -34.20, -34.19,
        -34.17, -34.12, -34.12, -34.14, -34.14, -34.22, -34.25, -34.30, -34.26, -34.23,
        -34.20, -34.18, -34.14, -34.13, -34.11, -34.08, -34.14, -34.07, -34.14, -34.24,
        -34.25, -34.23, -34.24, -34.24, -34.19, -34.13, -34.11, -34.06, -34.08, -34.09,
        -34.08, -34.07, -34.10, -34.14, -34.16, -34.15, -34.19, -34.21, -34.21, -34.20,
        -34.22, -34.21, -34.21, -34.22, -34.22, -34.17, -34.12, -34.12, -34.09, -34.09,
        -34.09, -34.08, -34.09, -34.08, -34.00, -34.03, -34.02, -34.02, -34.09, -34.05,
        -34.10, -34.12, -34.12, -34.12, -34.11, -34.10, -34.04, -33.99, -34.02, -34.00,
        -33.99, -34.00, -34.02, -34.02, -33.98, -33.96, -33.94, -33.96, -33.87, -33.92,
        -33.95, -33.93, -33.92, -33.95, -33.97, -33.98, -33.97, -33.93, -33.93, -33.86,
        -33.83, -33.78, -33.71, -33.75, -33.75, -33.70, -33.69, -33.68, -33.68, -33.66,
        -33.65, -33.61, -33.57, -33.59, -33.54, -33.54, -33.53, -33.50, -33.51, -33.53,
        -33.55, -33.53, -33.51, -33.42, -33.37, -33.35, -33.31, -33.29, -33.24, -33.22,
        -33.17, -33.13, -33.17, -33.18, -33.18, -33.17, -33.19, -33.26, -33.20, -33.24,
        -33.26, -33.17, -33.18, -33.15, -33.09, -33.05, -33.00, -32.91, -32.84, -32.84,
        -32.83, -32.74, -32.77, -32.79, -32.74, -32.67, -32.70, -32.70, -32.70, -32.67,
        -32.65, -32.67, -32.57, -32.46, -32.46, -32.39, -32.33, -32.29, -32.25, -32.18,
        -32.17, -32.11, -32.11, -32.12, -32.07, -32.04, -32.08, -32.06, -32.03, -32.02,
        -31.94, -31.94, -31.89, -31.83, -31.86, -31.84, -31.81, -31.77, -31.72, -31.66,
        -31.60, -31.50, -31.43, -31.41, -31.34, -31.28, -31.25, -31.24, -31.21, -31.18,
        -31.10, -31.04, -31.04, -30.94, -30.94, -30.88, -30.78, -30.72, -30.62, -30.52,
        -30.44, -30.41, -30.37, -30.37, -30.37, -30.27, -30.24, -30.17, -30.09, -30.09,
        -30.04, -30.00, -29.96, -29.99, -29.87, -29.82, -29.75, -29.72, -29.63, -29.57,
        -29.50, -29.43, -29.40, -29.32, -29.31, -29.23, -29.16, -29.13, -29.07, -28.95,
        -28.94, -28.88, -28.78, -28.67, -28.56, -28.49, -28.42, -28.30, -28.26, -28.26,
        -28.19, -28.16, -28.09, -27.98, -27.93, -27.86, -27.76, -27.75
    };

    static const float iso226_2003_curve_60_phons[1382] =
    {
        -10.87, -10.85, -10.85, -10.82,
        -10.82, -10.82, -10.83, -10.83, -10.82, -10.86, -10.82, -10.87, -10.90, -10.87,
        -10.94, -11.03, -11.03, -11.03, -11.06, -11.03, -11.03, -11.08, -11.08, -11.03,
        -11.08, -11.08, -11.07, -11.04, -11.04, -11.13, -11.13, -11.16, -11.20, -11.26,
        -11.21, -11.25, -11.31, -11.24, -11.24, -11.29, -11.24, -11.24, -11.24, -11.30,
        -11.34, -11.34, -11.39, -11.36, -11.40, -11.46, -11.50, -11.51, -11.53, -11.54,
        -11.53, -11.48, -11.45, -11.45, -11.48, -11.47, -11.48, -11.55, -11.50, -11.50,
        -11.59, -11.62, -11.65, -11.66, -11.71, -11.72, -11.75, -11.75, -11.75, -11.71,
        -11.67, -11.69, -11.72, -11.75, -11.71, -11.76, -11.72, -11.71, -11.77, -11.82,
        -11.82, -11.89, -11.92, -11.92, -11.90, -11.87, -11.94, -11.93, -11.90, -11.95,
        -11.92, -11.87, -11.90, -11.94, -11.92, -11.93, -12.02, -12.03, -12.03, -12.07,
        -12.14, -12.18, -12.18, -12.18, -12.18, -12.19, -12.23, -12.24, -12.28, -12.34,
        -12.37, -12.39, -12.39, -12.39, -12.37, -12.33, -12.37, -12.44, -12.44, -12.45,
        -12.46, -12.53, -12.54, -12.50, -12.53, -12.60, -12.59, -12.54, -12.60, -12.60,
        -12.60, -12.60, -12.56, -12.60, -12.60, -12.59, -12.56, -12.64, -12.66, -12.71,
        -12.75, -12.76, -12.79, -12.74, -12.77, -12.81, -12.81, -12.74, -12.81, -12.81,
        -12.81, -12.79, -12.81, -12.81, -12.81, -12.81, -12.89, -12.94, -12.97, -12.97,
        -12.96, -12.97, -12.96, -13.00, -13.02, -12.96, -13.01, -13.02, -13.02, -13.04,
        -13.08, -13.13, -13.20, -13.23, -13.29, -13.23, -13.23, -13.23, -13.23, -13.22,
        -13.23, -13.23, -13.20, -13.22, -13.23, -13.23, -13.20, -13.34, -13.37, -13.44,
        -13.53, -13.55, -13.62, -13.67, -13.65, -13.65, -13.65, -13.61, -13.64, -13.65,
        -13.64, -13.67, -13.64, -13.67, -13.67, -13.65, -13.65, -13.75, -13.67, -13.66,
        -13.72, -13.81, -13.81, -13.88, -13.91, -13.91, -13.82, -13.86, -13.86, -13.87,
        -13.87, -13.83, -13.91, -13.92, -13.92, -14.01, -14.03, -14.03, -14.07, -14.08,
        -14.08, -14.08, -14.10, -14.12, -14.08, -14.07, -14.07, -14.07, -14.08, -14.13,
        -14.19, -14.25, -14.29, -14.38, -14.28, -14.28, -14.34, -14.38, -14.35, -14.40,
        -14.46, -14.44, -14.44, -14.44, -14.34, -14.28, -14.29, -14.26, -14.28, -14.28,
        -14.37, -14.39, -14.36, -14.44, -14.49, -14.49, -14.50, -14.50, -14.50, -14.59,
        -14.60, -14.55, -14.65, -14.70, -14.69, -14.70, -14.71, -14.74, -14.75, -14.84,
        -14.86, -14.91, -14.91, -14.91, -14.96, -14.92, -14.97, -15.02, -14.98, -15.02,
        -14.97, -14.98, -15.02, -15.07, -15.09, -15.09, -15.14, -15.15, -15.19, -15.19,
        -15.17, -15.18, -15.17, -15.12, -15.17, -15.17, -15.12, -15.15, -15.13, -15.14,
        -15.22, -15.23, -15.28, -15.33, -15.33, -15.39, -15.39, -15.39, -15.39, -15.39,
        -15.44, -15.43, -15.35, -15.44, -15.44, -15.43, -15.46, -15.49, -15.56, -15.60,
        -15.65, -15.68, -15.70, -15.75, -15.75, -15.71, -15.69, -15.65, -15.65, -15.70,
        -15.72, -15.71, -15.81, -15.81, -15.81, -15.81, -15.81, -15.90, -15.82, -15.91,
        -15.96, -16.00, -16.02, -16.05, -16.02, -16.02, -16.04, -16.06, -15.98, -16.07,
        -16.06, -16.02, -16.12, -16.12, -16.17, -16.22, -16.22, -16.27, -16.23, -16.23,
        -16.28, -16.27, -16.19, -16.28, -16.28, -16.31, -16.33, -16.40, -16.47, -16.49,
        -16.54, -16.49, -16.47, -16.49, -16.49, -16.51, -16.54, -16.60, -16.62, -16.65,
        -16.70, -16.65, -16.67, -16.75, -16.74, -16.76, -16.81, -16.80, -16.81, -16.85,
        -16.80, -16.75, -16.76, -16.80, -16.80, -16.85, -16.90, -16.91, -16.91, -16.91,
        -16.91, -16.86, -16.89, -16.88, -16.88, -16.91, -16.91, -16.95, -16.96, -17.01,
        -17.06, -17.07, -17.21, -17.21, -17.27, -17.28, -17.37, -17.35, -17.33, -17.39,
        -17.33, -17.37, -17.38, -17.38, -17.38, -17.38, -17.45, -17.40, -17.49, -17.54,
        -17.54, -17.54, -17.58, -17.59, -17.54, -17.59, -17.54, -17.50, -17.54, -17.54,
        -17.56, -17.62, -17.68, -17.79, -17.75, -17.75, -17.80, -17.75, -17.80, -17.79,
        -17.76, -17.76, -17.80, -17.80, -17.85, -17.90, -17.91, -17.96, -17.96, -17.97,
        -17.98, -18.01, -18.01, -17.96, -17.97, -17.97, -18.01, -18.11, -18.06, -18.12,
        -18.17, -18.17, -18.22, -18.32, -18.37, -18.38, -18.44, -18.38, -18.39, -18.43,
        -18.38, -18.38, -18.38, -18.38, -18.43, -18.44, -18.46, -18.54, -18.62, -18.54,
        -18.63, -18.67, -18.61, -18.65, -18.69, -18.62, -18.69, -18.69, -18.65, -18.74,
        -18.74, -18.80, -18.80, -18.81, -18.85, -18.85, -18.85, -18.86, -18.90, -18.87,
        -18.87, -18.90, -18.91, -18.90, -18.96, -18.98, -18.96, -19.06, -19.05, -19.01,
        -19.02, -19.01, -19.06, -19.09, -19.06, -19.11, -19.19, -19.22, -19.22, -19.29,
        -19.32, -19.30, -19.27, -19.28, -19.32, -19.26, -19.32, -19.27, -19.27, -19.32,
        -19.31, -19.32, -19.32, -19.32, -19.38, -19.48, -19.53, -19.59, -19.69, -19.74,
        -19.70, -19.74, -19.76, -19.79, -19.74, -19.74, -19.74, -19.69, -19.71, -19.75,
        -19.80, -19.85, -19.90, -19.95, -19.87, -19.95, -19.95, -19.90, -19.95, -19.94,
        -19.95, -19.90, -19.95, -19.92, -19.90, -19.95, -19.90, -19.91, -19.98, -20.03,
        -20.08, -20.16, -20.13, -20.11, -20.16, -20.12, -20.12, -20.22, -20.26, -20.32,
        -20.38, -20.38, -20.42, -20.42, -20.37, -20.37, -20.37, -20.37, -20.37, -20.38,
        -20.37, -20.38, -20.37, -20.38, -20.41, -20.39, -20.37, -20.42, -20.38, -20.43,
        -20.48, -20.53, -20.58, -20.59, -20.69, -20.69, -20.70, -20.79, -20.78, -20.80,
        -20.79, -20.79, -20.82, -20.90, -20.90, -20.99, -21.01, -21.01, -21.01, -21.00,
        -21.01, -20.99, -20.90, -20.90, -20.85, -20.80, -20.85, -20.90, -20.95, -21.00,
        -21.04, -21.01, -21.01, -21.05, -21.00, -21.06, -21.11, -21.16, -21.21, -21.23,
        -21.25, -21.21, -21.26, -21.22, -21.22, -21.28, -21.36, -21.40, -21.42, -21.36,
        -21.32, -21.32, -21.25, -21.21, -21.27, -21.32, -21.37, -21.42, -21.42, -21.42,
        -21.42, -21.42, -21.42, -21.47, -21.44, -21.47, -21.51, -21.52, -21.53, -21.61,
        -21.63, -21.64, -21.73, -21.69, -21.65, -21.70, -21.73, -21.69, -21.69, -21.69,
        -21.69, -21.69, -21.77, -21.79, -21.74, -21.84, -21.84, -21.84, -21.74, -21.73,
        -21.69, -21.72, -21.74, -21.74, -21.84, -21.84, -21.84, -21.84, -21.84, -21.84,
        -21.88, -21.90, -21.84, -21.90, -21.90, -21.95, -22.00, -22.05, -22.11, -22.16,
        -22.21, -22.18, -22.26, -22.26, -22.26, -22.26, -22.26, -22.21, -22.21, -22.21,
        -22.16, -22.16, -22.15, -22.13, -22.16, -22.22, -22.26, -22.26, -22.26, -22.26,
        -22.26, -22.26, -22.32, -22.27, -22.32, -22.26, -22.26, -22.26, -22.26, -22.32,
        -22.32, -22.37, -22.42, -22.42, -22.47, -22.47, -22.47, -22.47, -22.47, -22.47,
        -22.47, -22.51, -22.53, -22.57, -22.63, -22.63, -22.56, -22.53, -22.58, -22.56,
        -22.48, -22.47, -22.47, -22.47, -22.47, -22.47, -22.47, -22.47, -22.47, -22.47,
        -22.58, -22.63, -22.68, -22.74, -22.79, -22.79, -22.84, -22.95, -23.00, -23.00,
        -23.05, -23.05, -23.05, -23.05, -23.05, -23.05, -23.11, -23.11, -23.11, -23.11,
        -23.11, -23.00, -23.00, -23.00, -23.00, -23.00, -22.95, -22.95, -22.90, -22.89,
        -22.95, -22.95, -22.95, -22.90, -23.00, -22.95, -22.95, -23.00, -23.00, -23.00,
        -23.00, -23.05, -23.05, -23.05, -23.00, -22.95, -22.89, -22.89, -22.89, -22.90,
        -22.91, -22.95, -22.92, -22.92, -23.00, -22.89, -22.95, -22.95, -22.95, -23.02,
        -23.00, -23.11, -23.13, -23.20, -23.25, -23.21, -23.21, -23.21, -23.21, -23.21,
        -23.16, -23.12, -23.16, -23.16, -23.16, -23.21, -23.17, -23.14, -23.21, -23.16,
        -23.16, -23.24, -23.27, -23.32, -23.36, -23.42, -23.37, -23.31, -23.32, -23.26,
        -23.21, -23.22, -23.21, -23.20, -23.21, -23.26, -23.23, -23.26, -23.36, -23.36,
        -23.31, -23.27, -23.22, -23.16, -23.16, -23.21, -23.21, -23.29, -23.32, -23.37,
        -23.37, -23.37, -23.37, -23.37, -23.42, -23.37, -23.42, -23.45, -23.42, -23.45,
        -23.42, -23.47, -23.43, -23.42, -23.42, -23.42, -23.42, -23.42, -23.46, -23.51,
        -23.58, -23.60, -23.53, -23.53, -23.51, -23.43, -23.42, -23.42, -23.42, -23.42,
        -23.43, -23.52, -23.53, -23.58, -23.63, -23.63, -23.64, -23.63, -23.63, -23.63,
        -23.63, -23.63, -23.60, -23.63, -23.62, -23.58, -23.58, -23.58, -23.58, -23.53,
        -23.53, -23.47, -23.46, -23.42, -23.47, -23.48, -23.57, -23.59, -23.58, -23.63,
        -23.63, -23.63, -23.58, -23.57, -23.57, -23.47, -23.42, -23.46, -23.46, -23.51,
        -23.57, -23.53, -23.62, -23.63, -23.63, -23.62, -23.64, -23.64, -23.64, -23.64,
        -23.62, -23.63, -23.63, -23.63, -23.56, -23.62, -23.63, -23.67, -23.73, -23.73,
        -23.74, -23.79, -23.74, -23.68, -23.65, -23.69, -23.63, -23.63, -23.66, -23.63,
        -23.63, -23.65, -23.63, -23.63, -23.67, -23.61, -23.66, -23.61, -23.63, -23.58,
        -23.59, -23.63, -23.53, -23.62, -23.59, -23.58, -23.63, -23.63, -23.67, -23.63,
        -23.63, -23.66, -23.63, -23.67, -23.66, -23.67, -23.66, -23.63, -23.67, -23.63,
        -23.66, -23.64, -23.63, -23.63, -23.60, -23.60, -23.58, -23.63, -23.59, -23.56,
        -23.63, -23.58, -23.58, -23.58, -23.58, -23.58, -23.53, -23.53, -23.53, -23.53,
        -23.53, -23.58, -23.62, -23.58, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63,
        -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.64, -23.63, -23.63, -23.63,
        -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63,
        -23.63, -23.63, -23.63, -23.72, -23.74, -23.80, -23.84, -23.79, -23.74, -23.74,
        -23.73, -23.68, -23.68, -23.68, -23.68, -23.63, -23.72, -23.74, -23.74, -23.83,
        -23.84, -23.84, -23.84, -23.84, -23.84, -23.86, -23.84, -23.84, -23.81, -23.84,
        -23.79, -23.73, -23.68, -23.60, -23.58, -23.63, -23.68, -23.73, -23.79, -23.84,
        -23.82, -23.84, -23.79, -23.85, -23.88, -23.88, -23.84, -23.84, -23.79, -23.76,
        -23.77, -23.68, -23.65, -23.68, -23.69, -23.79, -23.80, -23.89, -23.83, -23.84,
        -23.79, -23.79, -23.73, -23.73, -23.68, -23.63, -23.68, -23.59, -23.68, -23.78,
        -23.79, -23.77, -23.79, -23.79, -23.73, -23.67, -23.64, -23.59, -23.62, -23.63,
        -23.63, -23.63, -23.68, -23.73, -23.79, -23.78, -23.81, -23.84, -23.84, -23.84,
        -23.85, -23.84, -23.84, -23.85, -23.82, -23.74, -23.68, -23.68, -23.66, -23.63,
        -23.63, -23.63, -23.63, -23.62, -23.54, -23.63, -23.63, -23.63, -23.72, -23.68,
        -23.74, -23.73, -23.74, -23.74, -23.74, -23.74, -23.64, -23.59, -23.63, -23.63,
        -23.64, -23.63, -23.63, -23.63, -23.63, -23.61, -23.59, -23.62, -23.53, -23.62,
        -23.63, -23.61, -23.60, -23.63, -23.63, -23.63, -23.63, -23.63, -23.63, -23.58,
        -23.55, -23.49, -23.44, -23.47, -23.47, -23.42, -23.42, -23.42, -23.42, -23.41,
        -23.38, -23.33, -23.32, -23.32, -23.27, -23.26, -23.26, -23.25, -23.27, -23.29,
        -23.32, -23.31, -23.30, -23.23, -23.16, -23.16, -23.13, -23.11, -23.06, -23.06,
        -22.99, -22.95, -23.02, -23.00, -23.00, -22.99, -23.01, -23.11, -23.06, -23.10,
        -23.15, -23.09, -23.11, -23.11, -23.04, -23.00, -22.96, -22.89, -22.85, -22.84,
        -22.83, -22.74, -22.78, -22.79, -22.74, -22.70, -22.75, -22.80, -22.79, -22.79,
        -22.79, -22.78, -22.69, -22.56, -22.58, -22.48, -22.42, -22.41, -22.34, -22.32,
        -22.31, -22.26, -22.27, -22.30, -22.27, -22.26, -22.32, -22.31, -22.31, -22.32,
        -22.22, -22.22, -22.21, -22.12, -22.16, -22.16, -22.16, -22.16, -22.10, -22.05,
        -22.00, -21.90, -21.84, -21.84, -21.79, -21.74, -21.74, -21.74, -21.74, -21.74,
        -21.68, -21.63, -21.63, -21.54, -21.53, -21.48, -21.37, -21.32, -21.21, -21.11,
        -21.04, -21.05, -21.00, -21.02, -21.05, -20.95, -20.95, -20.90, -20.85, -20.89,
        -20.80, -20.79, -20.80, -20.84, -20.74, -20.68, -20.64, -20.63, -20.56, -20.53,
        -20.52, -20.43, -20.43, -20.37, -20.36, -20.27, -20.20, -20.16, -20.11, -20.02,
        -20.01, -19.98, -19.90, -19.84, -19.74, -19.70, -19.65, -19.56, -19.55, -19.52,
        -19.46, -19.46, -19.41, -19.31, -19.28, -19.22, -19.16, -19.16
    };

    static const float iso226_2003_curve_70_phons[1382] =
    {
        -6.14, -6.13, -6.14, -6.11,
        -6.11, -6.12, -6.12, -6.12, -6.11, -6.14, -6.11, -6.14, -6.16, -6.15,
        -6.18, -6.24, -6.23, -6.23, -6.25, -6.23, -6.23, -6.26, -6.26, -6.23,
        -6.26, -6.26, -6.26, -6.24, -6.24, -6.29, -6.29, -6.31, -6.33, -6.36,
        -6.34, -6.36, -6.40, -6.35, -6.35, -6.38, -6.35, -6.35, -6.35, -6.38,
        -6.41, -6.41, -6.44, -6.42, -6.44, -6.47, -6.50, -6.51, -6.52, -6.52,
        -6.52, -6.49, -6.47, -6.47, -6.49, -6.48, -6.49, -6.53, -6.50, -6.50,
        -6.55, -6.57, -6.58, -6.59, -6.62, -6.63, -6.64, -6.64, -6.64, -6.62,
        -6.60, -6.61, -6.63, -6.64, -6.62, -6.65, -6.62, -6.62, -6.65, -6.68,
        -6.68, -6.72, -6.74, -6.74, -6.72, -6.71, -6.75, -6.74, -6.73, -6.75,
        -6.74, -6.71, -6.72, -6.75, -6.74, -6.74, -6.79, -6.80, -6.80, -6.82,
        -6.86, -6.88, -6.89, -6.89, -6.89, -6.89, -6.91, -6.92, -6.94, -6.97,
        -6.99, -7.00, -7.00, -7.00, -6.99, -6.97, -6.99, -7.03, -7.03, -7.03,
        -7.04, -7.08, -7.09, -7.06, -7.08, -7.12, -7.12, -7.09, -7.12, -7.12,
        -7.12, -7.12, -7.10, -7.12, -7.12, -7.12, -7.10, -7.15, -7.15, -7.18,
        -7.21, -7.21, -7.23, -7.20, -7.22, -7.24, -7.24, -7.20, -7.24, -7.24,
        -7.24, -7.23, -7.24, -7.24, -7.24, -7.24, -7.29, -7.32, -7.33, -7.33,
        -7.33, -7.33, -7.32, -7.35, -7.36, -7.32, -7.36, -7.36, -7.36, -7.37,
        -7.39, -7.42, -7.46, -7.48, -7.51, -7.48, -7.48, -7.48, -7.48, -7.47,
        -7.48, -7.48, -7.46, -7.47, -7.48, -7.48, -7.46, -7.54, -7.56, -7.60,
        -7.65, -7.66, -7.70, -7.72, -7.72, -7.72, -7.72, -7.69, -7.71, -7.71,
        -7.71, -7.73, -7.71, -7.73, -7.73, -7.72, -7.72, -7.77, -7.73, -7.72,
        -7.75, -7.81, -7.81, -7.85, -7.86, -7.86, -7.81, -7.84, -7.83, -7.84,
        -7.84, -7.82, -7.86, -7.87, -7.87, -7.92, -7.93, -7.93, -7.95, -7.96,
        -7.96, -7.96, -7.97, -7.98, -7.96, -7.95, -7.95, -7.95, -7.96, -7.99,
        -8.02, -8.06, -8.08, -8.13, -8.07, -8.07, -8.11, -8.13, -8.11, -8.14,
        -8.17, -8.16, -8.16, -8.16, -8.10, -8.07, -8.08, -8.06, -8.07, -8.07,
        -8.12, -8.13, -8.12, -8.16, -8.19, -8.19, -8.19, -8.19, -8.20, -8.25,
        -8.25, -8.22, -8.28, -8.31, -8.30, -8.31, -8.31, -8.33, -8.34, -8.39,
        -8.40, -8.43, -8.43, -8.43, -8.46, -8.43, -8.46, -8.49, -8.46, -8.49,
        -8.46, -8.47, -8.49, -8.52, -8.53, -8.53, -8.55, -8.57, -8.58, -8.58,
        -8.58, -8.58, -8.58, -8.55, -8.57, -8.58, -8.55, -8.56, -8.55, -8.56,
        -8.60, -8.61, -8.63, -8.67, -8.67, -8.70, -8.70, -8.70, -8.70, -8.70,
        -8.73, -8.72, -8.68, -8.73, -8.73, -8.72, -8.74, -8.76, -8.80, -8.82,
        -8.84, -8.86, -8.87, -8.90, -8.90, -8.88, -8.87, -8.85, -8.85, -8.87,
        -8.89, -8.88, -8.93, -8.93, -8.93, -8.94, -8.94, -8.99, -8.94, -8.99,
        -9.02, -9.04, -9.05, -9.07, -9.06, -9.05, -9.07, -9.08, -9.03, -9.08,
        -9.08, -9.05, -9.11, -9.11, -9.14, -9.17, -9.17, -9.19, -9.17, -9.17,
        -9.20, -9.19, -9.15, -9.20, -9.20, -9.22, -9.23, -9.27, -9.31, -9.32,
        -9.35, -9.32, -9.31, -9.32, -9.32, -9.33, -9.35, -9.38, -9.39, -9.41,
        -9.44, -9.41, -9.42, -9.47, -9.46, -9.47, -9.50, -9.50, -9.50, -9.53,
        -9.50, -9.47, -9.47, -9.50, -9.50, -9.53, -9.55, -9.56, -9.56, -9.56,
        -9.56, -9.53, -9.54, -9.54, -9.54, -9.56, -9.56, -9.58, -9.59, -9.62,
        -9.64, -9.65, -9.72, -9.73, -9.76, -9.77, -9.82, -9.81, -9.79, -9.83,
        -9.80, -9.82, -9.82, -9.82, -9.82, -9.82, -9.86, -9.84, -9.88, -9.91,
        -9.91, -9.91, -9.94, -9.94, -9.91, -9.94, -9.91, -9.89, -9.91, -9.91,
        -9.93, -9.96, -9.99, -10.05, -10.03, -10.03, -10.06, -10.03, -10.06, -10.06,
        -10.04, -10.04, -10.06, -10.06, -10.09, -10.12, -10.12, -10.15, -10.15, -10.16,
        -10.16, -10.18, -10.18, -10.15, -10.16, -10.16, -10.18, -10.24, -10.21, -10.24,
        -10.27, -10.27, -10.30, -10.35, -10.38, -10.39, -10.42, -10.39, -10.39, -10.42,
        -10.39, -10.39, -10.39, -10.39, -10.42, -10.42, -10.43, -10.48, -10.52, -10.48,
        -10.53, -10.55, -10.52, -10.54, -10.57, -10.52, -10.56, -10.56, -10.54, -10.59,
        -10.59, -10.62, -10.63, -10.63, -10.66, -10.66, -10.66, -10.66, -10.68, -10.67,
        -10.67, -10.68, -10.69, -10.68, -10.71, -10.73, -10.72, -10.77, -10.77, -10.75,
        -10.75, -10.74, -10.77, -10.79, -10.77, -10.80, -10.85, -10.86, -10.86, -10.90,
        -10.92, -10.91, -10.89, -10.90, -10.92, -10.89, -10.92, -10.89, -10.89, -10.92,
        -10.91, -10.92, -10.92, -10.92, -10.95, -11.01, -11.04, -11.07, -11.13, -11.16,
        -11.14, -11.16, -11.17, -11.18, -11.16, -11.16, -11.16, -11.13, -11.14, -11.16,
        -11.19, -11.22, -11.25, -11.28, -11.23, -11.28, -11.28, -11.25, -11.28, -11.27,
        -11.27, -11.25, -11.28, -11.26, -11.25, -11.28, -11.25, -11.26, -11.29, -11.32,
        -11.35, -11.40, -11.38, -11.37, -11.40, -11.37, -11.37, -11.43, -11.45, -11.49,
        -11.52, -11.52, -11.54, -11.54, -11.52, -11.52, -11.52, -11.52, -11.52, -11.52,
        -11.52, -11.52, -11.52, -11.52, -11.54, -11.53, -11.52, -11.54, -11.52, -11.55,
        -11.58, -11.61, -11.63, -11.64, -11.69, -11.69, -11.70, -11.75, -11.74, -11.76,
        -11.75, -11.75, -11.77, -11.81, -11.81, -11.86, -11.87, -11.87, -11.87, -11.87,
        -11.87, -11.87, -11.82, -11.81, -11.78, -11.76, -11.79, -11.81, -11.84, -11.87,
        -11.89, -11.87, -11.87, -11.90, -11.87, -11.90, -11.93, -11.96, -11.99, -12.00,
        -12.01, -11.99, -12.02, -11.99, -11.99, -12.03, -12.07, -12.10, -12.11, -12.07,
        -12.05, -12.05, -12.01, -11.99, -12.02, -12.05, -12.08, -12.11, -12.11, -12.11,
        -12.11, -12.11, -12.11, -12.14, -12.12, -12.14, -12.16, -12.16, -12.17, -12.22,
        -12.23, -12.23, -12.28, -12.26, -12.23, -12.26, -12.28, -12.26, -12.26, -12.26,
        -12.26, -12.26, -12.31, -12.32, -12.29, -12.34, -12.35, -12.35, -12.29, -12.28,
        -12.26, -12.28, -12.29, -12.29, -12.34, -12.35, -12.35, -12.35, -12.35, -12.35,
        -12.37, -12.38, -12.35, -12.38, -12.38, -12.41, -12.44, -12.47, -12.50, -12.53,
        -12.55, -12.54, -12.58, -12.58, -12.58, -12.58, -12.58, -12.55, -12.55, -12.55,
        -12.53, -12.53, -12.52, -12.51, -12.53, -12.56, -12.58, -12.58, -12.58, -12.58,
        -12.58, -12.58, -12.61, -12.58, -12.61, -12.58, -12.58, -12.58, -12.58, -12.61,
        -12.61, -12.64, -12.67, -12.67, -12.70, -12.70, -12.70, -12.70, -12.70, -12.70,
        -12.70, -12.72, -12.73, -12.76, -12.79, -12.79, -12.75, -12.73, -12.76, -12.75,
        -12.70, -12.70, -12.70, -12.70, -12.70, -12.70, -12.70, -12.70, -12.70, -12.70,
        -12.76, -12.79, -12.82, -12.85, -12.88, -12.88, -12.91, -12.97, -13.00, -13.00,
        -13.03, -13.03, -13.03, -13.03, -13.03, -13.03, -13.06, -13.06, -13.06, -13.06,
        -13.06, -13.00, -13.00, -13.00, -13.00, -13.00, -12.97, -12.97, -12.94, -12.94,
        -12.97, -12.97, -12.97, -12.94, -13.00, -12.97, -12.97, -13.00, -13.00, -13.00,
        -13.00, -13.03, -13.03, -13.03, -13.00, -12.97, -12.94, -12.94, -12.94, -12.94,
        -12.95, -12.97, -12.96, -12.95, -13.00, -12.94, -12.97, -12.97, -12.97, -13.01,
        -13.00, -13.06, -13.07, -13.12, -13.14, -13.12, -13.12, -13.12, -13.12, -13.12,
        -13.09, -13.07, -13.09, -13.09, -13.09, -13.12, -13.09, -13.08, -13.12, -13.09,
        -13.09, -13.13, -13.15, -13.18, -13.20, -13.24, -13.21, -13.18, -13.18, -13.15,
        -13.12, -13.13, -13.12, -13.11, -13.12, -13.15, -13.13, -13.15, -13.21, -13.20,
        -13.18, -13.15, -13.13, -13.09, -13.09, -13.12, -13.12, -13.17, -13.18, -13.21,
        -13.21, -13.21, -13.21, -13.21, -13.24, -13.21, -13.24, -13.25, -13.24, -13.26,
        -13.24, -13.26, -13.24, -13.24, -13.24, -13.24, -13.24, -13.24, -13.26, -13.29,
        -13.33, -13.34, -13.30, -13.30, -13.29, -13.24, -13.24, -13.24, -13.24, -13.24,
        -13.24, -13.30, -13.30, -13.33, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36,
        -13.36, -13.36, -13.34, -13.35, -13.35, -13.33, -13.33, -13.33, -13.33, -13.30,
        -13.30, -13.27, -13.26, -13.24, -13.27, -13.27, -13.32, -13.33, -13.33, -13.36,
        -13.36, -13.36, -13.33, -13.32, -13.32, -13.27, -13.24, -13.26, -13.26, -13.29,
        -13.32, -13.30, -13.35, -13.36, -13.36, -13.35, -13.36, -13.36, -13.36, -13.36,
        -13.35, -13.36, -13.36, -13.36, -13.32, -13.35, -13.36, -13.38, -13.41, -13.41,
        -13.42, -13.44, -13.42, -13.39, -13.37, -13.39, -13.36, -13.36, -13.37, -13.36,
        -13.36, -13.37, -13.36, -13.36, -13.38, -13.34, -13.37, -13.35, -13.36, -13.33,
        -13.33, -13.35, -13.30, -13.35, -13.33, -13.33, -13.36, -13.36, -13.38, -13.36,
        -13.36, -13.37, -13.36, -13.38, -13.37, -13.38, -13.37, -13.36, -13.38, -13.36,
        -13.37, -13.36, -13.36, -13.36, -13.34, -13.34, -13.33, -13.35, -13.33, -13.32,
        -13.36, -13.33, -13.33, -13.33, -13.33, -13.33, -13.30, -13.30, -13.30, -13.30,
        -13.30, -13.33, -13.35, -13.33, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36,
        -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36,
        -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36, -13.36,
        -13.36, -13.36, -13.36, -13.41, -13.42, -13.45, -13.47, -13.45, -13.42, -13.42,
        -13.41, -13.39, -13.39, -13.39, -13.39, -13.36, -13.40, -13.42, -13.42, -13.47,
        -13.47, -13.47, -13.47, -13.47, -13.47, -13.48, -13.48, -13.47, -13.46, -13.47,
        -13.45, -13.41, -13.39, -13.34, -13.33, -13.36, -13.39, -13.42, -13.45, -13.47,
        -13.46, -13.47, -13.45, -13.48, -13.50, -13.50, -13.47, -13.48, -13.45, -13.43,
        -13.44, -13.39, -13.37, -13.39, -13.39, -13.45, -13.45, -13.50, -13.47, -13.47,
        -13.45, -13.45, -13.41, -13.41, -13.38, -13.36, -13.39, -13.33, -13.39, -13.44,
        -13.45, -13.44, -13.44, -13.44, -13.41, -13.38, -13.36, -13.34, -13.35, -13.36,
        -13.35, -13.36, -13.39, -13.41, -13.45, -13.44, -13.46, -13.48, -13.47, -13.47,
        -13.48, -13.48, -13.48, -13.48, -13.47, -13.42, -13.39, -13.39, -13.37, -13.36,
        -13.36, -13.35, -13.36, -13.35, -13.31, -13.36, -13.36, -13.36, -13.41, -13.39,
        -13.42, -13.41, -13.42, -13.42, -13.42, -13.42, -13.36, -13.33, -13.36, -13.36,
        -13.36, -13.36, -13.36, -13.36, -13.36, -13.35, -13.33, -13.35, -13.30, -13.35,
        -13.36, -13.34, -13.34, -13.35, -13.35, -13.36, -13.36, -13.36, -13.36, -13.33,
        -13.31, -13.27, -13.25, -13.26, -13.27, -13.24, -13.24, -13.24, -13.24, -13.23,
        -13.21, -13.19, -13.18, -13.18, -13.15, -13.15, -13.15, -13.14, -13.15, -13.17,
        -13.18, -13.18, -13.17, -13.13, -13.09, -13.09, -13.07, -13.06, -13.03, -13.03,
        -12.99, -12.97, -13.01, -13.00, -13.00, -13.00, -13.00, -13.06, -13.03, -13.06,
        -13.08, -13.05, -13.06, -13.06, -13.02, -13.00, -12.97, -12.94, -12.91, -12.91,
        -12.90, -12.85, -12.88, -12.88, -12.85, -12.83, -12.86, -12.88, -12.88, -12.88,
        -12.88, -12.88, -12.82, -12.75, -12.76, -12.71, -12.67, -12.67, -12.63, -12.62,
        -12.61, -12.58, -12.59, -12.60, -12.59, -12.58, -12.61, -12.61, -12.61, -12.61,
        -12.56, -12.56, -12.55, -12.50, -12.52, -12.52, -12.52, -12.52, -12.49, -12.46,
        -12.43, -12.38, -12.35, -12.35, -12.32, -12.29, -12.29, -12.29, -12.29, -12.29,
        -12.25, -12.23, -12.22, -12.17, -12.17, -12.14, -12.08, -12.05, -11.99, -11.93,
        -11.89, -11.90, -11.87, -11.88, -11.90, -11.84, -11.84, -11.81, -11.78, -11.81,
        -11.76, -11.75, -11.76, -11.78, -11.72, -11.69, -11.66, -11.66, -11.62, -11.60,
        -11.60, -11.55, -11.55, -11.52, -11.51, -11.46, -11.42, -11.40, -11.37, -11.31,
        -11.31, -11.29, -11.25, -11.21, -11.16, -11.14, -11.11, -11.05, -11.05, -11.03,
        -11.00, -11.00, -10.97, -10.91, -10.90, -10.87, -10.83, -10.83
    };

    static const float iso226_2003_curve_80_phons[1382] =
    {
        -1.42, -1.42, -1.42, -1.41,
        -1.41, -1.41, -1.41, -1.41, -1.41, -1.42, -1.41, -1.42, -1.42, -1.42,
        -1.43, -1.44, -1.44, -1.44, -1.44, -1.44, -1.44, -1.45, -1.44, -1.44,
        -1.45, -1.45, -1.44, -1.44, -1.44, -1.45, -1.45, -1.46, -1.46, -1.47,
        -1.46, -1.47, -1.48, -1.47, -1.47, -1.47, -1.47, -1.47, -1.47, -1.47,
        -1.48, -1.48, -1.49, -1.48, -1.49, -1.49, -1.50, -1.50, -1.50, -1.51,
        -1.50, -1.50, -1.49, -1.49, -1.50, -1.50, -1.50, -1.51, -1.50, -1.50,
        -1.51, -1.52, -1.52, -1.52, -1.53, -1.53, -1.53, -1.53, -1.53, -1.53,
        -1.52, -1.53, -1.53, -1.53, -1.53, -1.53, -1.53, -1.53, -1.54, -1.54,
        -1.54, -1.55, -1.55, -1.55, -1.55, -1.55, -1.56, -1.56, -1.55, -1.56,
        -1.55, -1.55, -1.55, -1.56, -1.55, -1.56, -1.57, -1.57, -1.57, -1.57,
        -1.58, -1.59, -1.59, -1.59, -1.59, -1.59, -1.60, -1.60, -1.60, -1.61,
        -1.61, -1.62, -1.62, -1.62, -1.61, -1.61, -1.61, -1.62, -1.62, -1.62,
        -1.63, -1.63, -1.64, -1.63, -1.63, -1.64, -1.64, -1.64, -1.64, -1.64,
        -1.64, -1.64, -1.64, -1.64, -1.64, -1.64, -1.64, -1.65, -1.65, -1.66,
        -1.66, -1.66, -1.67, -1.66, -1.67, -1.67, -1.67, -1.66, -1.67, -1.67,
        -1.67, -1.67, -1.67, -1.67, -1.67, -1.67, -1.68, -1.69, -1.69, -1.69,
        -1.69, -1.69, -1.69, -1.70, -1.70, -1.69, -1.70, -1.70, -1.70, -1.70,
        -1.71, -1.71, -1.72, -1.73, -1.73, -1.73, -1.73, -1.73, -1.73, -1.72,
        -1.73, -1.73, -1.72, -1.72, -1.73, -1.73, -1.72, -1.74, -1.74, -1.75,
        -1.76, -1.77, -1.78, -1.78, -1.78, -1.78, -1.78, -1.78, -1.78, -1.78,
        -1.78, -1.78, -1.78, -1.78, -1.78, -1.78, -1.78, -1.79, -1.78, -1.78,
        -1.79, -1.80, -1.80, -1.81, -1.81, -1.81, -1.80, -1.81, -1.81, -1.81,
        -1.81, -1.80, -1.81, -1.82, -1.82, -1.83, -1.83, -1.83, -1.84, -1.84,
        -1.84, -1.84, -1.84, -1.84, -1.84, -1.84, -1.84, -1.84, -1.84, -1.84,
        -1.85, -1.86, -1.86, -1.88, -1.86, -1.86, -1.87, -1.88, -1.87, -1.88,
        -1.89, -1.88, -1.88, -1.88, -1.87, -1.86, -1.86, -1.86, -1.86, -1.86,
        -1.87, -1.88, -1.87, -1.88, -1.89, -1.89, -1.89, -1.89, -1.89, -1.90,
        -1.90, -1.90, -1.91, -1.92, -1.92, -1.92, -1.92, -1.92, -1.92, -1.94,
        -1.94, -1.95, -1.95, -1.95, -1.95, -1.95, -1.95, -1.96, -1.95, -1.96,
        -1.95, -1.95, -1.96, -1.97, -1.97, -1.97, -1.97, -1.98, -1.98, -1.98,
        -1.98, -1.98, -1.98, -1.97, -1.98, -1.98, -1.97, -1.98, -1.97, -1.97,
        -1.99, -1.99, -1.99, -2.00, -2.00, -2.01, -2.01, -2.01, -2.01, -2.01,
        -2.01, -2.01, -2.00, -2.01, -2.01, -2.01, -2.02, -2.02, -2.03, -2.03,
        -2.04, -2.05, -2.05, -2.05, -2.05, -2.05, -2.05, -2.04, -2.04, -2.05,
        -2.05, -2.05, -2.06, -2.06, -2.06, -2.06, -2.06, -2.07, -2.06, -2.08,
        -2.08, -2.09, -2.09, -2.09, -2.09, -2.09, -2.09, -2.10, -2.08, -2.10,
        -2.09, -2.09, -2.10, -2.10, -2.11, -2.12, -2.12, -2.12, -2.12, -2.12,
        -2.12, -2.12, -2.11, -2.12, -2.12, -2.13, -2.13, -2.14, -2.15, -2.15,
        -2.16, -2.15, -2.15, -2.15, -2.15, -2.15, -2.16, -2.16, -2.17, -2.17,
        -2.18, -2.17, -2.17, -2.18, -2.18, -2.19, -2.19, -2.19, -2.19, -2.20,
        -2.19, -2.18, -2.19, -2.19, -2.19, -2.20, -2.20, -2.21, -2.21, -2.21,
        -2.21, -2.20, -2.20, -2.20, -2.20, -2.21, -2.21, -2.21, -2.21, -2.22,
        -2.23, -2.23, -2.24, -2.24, -2.25, -2.25, -2.27, -2.26, -2.26, -2.27,
        -2.26, -2.27, -2.27, -2.27, -2.27, -2.27, -2.28, -2.27, -2.28, -2.29,
        -2.29, -2.29, -2.29, -2.29, -2.29, -2.29, -2.29, -2.28, -2.29, -2.29,
        -2.29, -2.30, -2.31, -2.32, -2.32, -2.32, -2.32, -2.32, -2.32, -2.32,
        -2.32, -2.32, -2.32, -2.32, -2.33, -2.33, -2.34, -2.34, -2.34, -2.34,
        -2.35, -2.35, -2.35, -2.34, -2.34, -2.34, -2.35, -2.36, -2.36, -2.36,
        -2.37, -2.37, -2.38, -2.39, -2.40, -2.40, -2.41, -2.40, -2.40, -2.40,
        -2.40, -2.40, -2.40, -2.40, -2.40, -2.40, -2.41, -2.42, -2.43, -2.42,
        -2.43, -2.44, -2.43, -2.43, -2.44, -2.43, -2.44, -2.44, -2.43, -2.44,
        -2.44, -2.45, -2.45, -2.45, -2.46, -2.46, -2.46, -2.46, -2.47, -2.46,
        -2.46, -2.47, -2.47, -2.47, -2.47, -2.48, -2.47, -2.49, -2.48, -2.48,
        -2.48, -2.48, -2.49, -2.49, -2.49, -2.49, -2.50, -2.51, -2.51, -2.52,
        -2.52, -2.52, -2.51, -2.51, -2.52, -2.51, -2.52, -2.51, -2.51, -2.52,
        -2.52, -2.52, -2.52, -2.52, -2.53, -2.54, -2.55, -2.55, -2.57, -2.58,
        -2.57, -2.58, -2.58, -2.58, -2.58, -2.58, -2.58, -2.57, -2.57, -2.58,
        -2.58, -2.59, -2.60, -2.60, -2.59, -2.60, -2.60, -2.60, -2.60, -2.60,
        -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.60, -2.61, -2.61,
        -2.62, -2.63, -2.63, -2.62, -2.63, -2.62, -2.62, -2.64, -2.64, -2.65,
        -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66,
        -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66, -2.66,
        -2.67, -2.68, -2.68, -2.69, -2.70, -2.70, -2.70, -2.71, -2.71, -2.71,
        -2.71, -2.71, -2.72, -2.73, -2.73, -2.74, -2.74, -2.74, -2.74, -2.74,
        -2.74, -2.74, -2.73, -2.73, -2.72, -2.71, -2.72, -2.73, -2.73, -2.74,
        -2.74, -2.74, -2.74, -2.75, -2.74, -2.75, -2.75, -2.76, -2.77, -2.77,
        -2.77, -2.77, -2.77, -2.77, -2.77, -2.78, -2.79, -2.79, -2.79, -2.79,
        -2.78, -2.78, -2.77, -2.77, -2.77, -2.78, -2.79, -2.79, -2.79, -2.79,
        -2.79, -2.79, -2.79, -2.80, -2.80, -2.80, -2.81, -2.81, -2.81, -2.82,
        -2.82, -2.82, -2.83, -2.83, -2.82, -2.83, -2.83, -2.83, -2.83, -2.83,
        -2.83, -2.83, -2.84, -2.84, -2.84, -2.85, -2.85, -2.85, -2.84, -2.83,
        -2.83, -2.83, -2.84, -2.84, -2.85, -2.85, -2.85, -2.85, -2.85, -2.85,
        -2.85, -2.86, -2.85, -2.86, -2.86, -2.86, -2.87, -2.88, -2.88, -2.89,
        -2.90, -2.89, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90, -2.90,
        -2.89, -2.89, -2.89, -2.89, -2.89, -2.90, -2.90, -2.90, -2.90, -2.90,
        -2.90, -2.90, -2.91, -2.90, -2.91, -2.90, -2.90, -2.90, -2.90, -2.91,
        -2.91, -2.92, -2.92, -2.92, -2.93, -2.93, -2.93, -2.93, -2.93, -2.93,
        -2.93, -2.94, -2.94, -2.94, -2.95, -2.95, -2.94, -2.94, -2.95, -2.94,
        -2.93, -2.93, -2.93, -2.93, -2.93, -2.93, -2.93, -2.93, -2.93, -2.93,
        -2.95, -2.95, -2.96, -2.97, -2.97, -2.97, -2.98, -2.99, -3.00, -3.00,
        -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01, -3.01,
        -3.01, -3.00, -3.00, -3.00, -3.00, -3.00, -2.99, -2.99, -2.99, -2.99,
        -2.99, -2.99, -2.99, -2.99, -3.00, -2.99, -2.99, -3.00, -3.00, -3.00,
        -3.00, -3.01, -3.01, -3.01, -3.00, -2.99, -2.99, -2.99, -2.99, -2.99,
        -2.99, -2.99, -2.99, -2.99, -3.00, -2.99, -2.99, -2.99, -2.99, -3.00,
        -3.00, -3.01, -3.02, -3.03, -3.03, -3.03, -3.03, -3.03, -3.03, -3.03,
        -3.02, -3.02, -3.02, -3.02, -3.02, -3.03, -3.02, -3.02, -3.03, -3.02,
        -3.02, -3.03, -3.03, -3.04, -3.05, -3.05, -3.05, -3.04, -3.04, -3.03,
        -3.03, -3.03, -3.03, -3.03, -3.03, -3.03, -3.03, -3.03, -3.05, -3.05,
        -3.04, -3.03, -3.03, -3.02, -3.02, -3.03, -3.03, -3.04, -3.04, -3.05,
        -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.05, -3.06, -3.05, -3.06,
        -3.06, -3.06, -3.06, -3.06, -3.06, -3.06, -3.06, -3.06, -3.06, -3.07,
        -3.08, -3.08, -3.07, -3.07, -3.07, -3.06, -3.06, -3.06, -3.06, -3.06,
        -3.06, -3.07, -3.07, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.07,
        -3.07, -3.06, -3.06, -3.06, -3.06, -3.06, -3.07, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.07, -3.07, -3.06, -3.05, -3.06, -3.06, -3.07,
        -3.07, -3.07, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.07, -3.08, -3.08, -3.09, -3.10, -3.10,
        -3.10, -3.10, -3.10, -3.09, -3.08, -3.09, -3.08, -3.08, -3.09, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.09, -3.08, -3.09, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.07, -3.08, -3.08, -3.08, -3.08, -3.08, -3.09, -3.08,
        -3.08, -3.09, -3.08, -3.09, -3.09, -3.09, -3.09, -3.08, -3.09, -3.08,
        -3.09, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.07,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.07, -3.07, -3.07, -3.07,
        -3.07, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.09, -3.10, -3.10, -3.11, -3.10, -3.10, -3.10,
        -3.10, -3.09, -3.09, -3.09, -3.09, -3.08, -3.09, -3.10, -3.10, -3.11,
        -3.11, -3.11, -3.11, -3.11, -3.11, -3.11, -3.11, -3.11, -3.11, -3.11,
        -3.10, -3.10, -3.09, -3.08, -3.08, -3.08, -3.09, -3.10, -3.10, -3.11,
        -3.11, -3.11, -3.10, -3.11, -3.11, -3.11, -3.11, -3.11, -3.10, -3.10,
        -3.10, -3.09, -3.09, -3.09, -3.09, -3.10, -3.10, -3.12, -3.11, -3.11,
        -3.10, -3.10, -3.10, -3.10, -3.09, -3.08, -3.09, -3.08, -3.09, -3.10,
        -3.10, -3.10, -3.10, -3.10, -3.10, -3.09, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.09, -3.10, -3.10, -3.10, -3.11, -3.11, -3.11, -3.11,
        -3.11, -3.11, -3.11, -3.11, -3.11, -3.10, -3.09, -3.09, -3.09, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.07, -3.08, -3.08, -3.08, -3.09, -3.09,
        -3.10, -3.10, -3.10, -3.10, -3.10, -3.10, -3.08, -3.08, -3.08, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.07, -3.08,
        -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08, -3.08,
        -3.07, -3.06, -3.06, -3.06, -3.06, -3.05, -3.05, -3.06, -3.05, -3.05,
        -3.05, -3.04, -3.04, -3.04, -3.04, -3.03, -3.03, -3.03, -3.03, -3.04,
        -3.04, -3.04, -3.04, -3.03, -3.02, -3.02, -3.02, -3.01, -3.01, -3.01,
        -3.00, -2.99, -3.00, -3.00, -3.00, -3.00, -3.00, -3.01, -3.01, -3.01,
        -3.02, -3.01, -3.01, -3.01, -3.01, -3.00, -2.99, -2.99, -2.98, -2.98,
        -2.98, -2.97, -2.97, -2.97, -2.97, -2.96, -2.97, -2.97, -2.97, -2.97,
        -2.97, -2.97, -2.96, -2.94, -2.94, -2.93, -2.92, -2.92, -2.91, -2.91,
        -2.91, -2.90, -2.91, -2.91, -2.91, -2.90, -2.91, -2.91, -2.91, -2.91,
        -2.90, -2.90, -2.90, -2.88, -2.89, -2.89, -2.89, -2.89, -2.88, -2.88,
        -2.87, -2.86, -2.85, -2.85, -2.84, -2.84, -2.84, -2.84, -2.84, -2.84,
        -2.83, -2.82, -2.82, -2.81, -2.81, -2.80, -2.79, -2.78, -2.77, -2.75,
        -2.74, -2.75, -2.74, -2.74, -2.75, -2.73, -2.73, -2.73, -2.72, -2.73,
        -2.71, -2.71, -2.71, -2.72, -2.71, -2.70, -2.69, -2.69, -2.68, -2.68,
        -2.68, -2.66, -2.66, -2.66, -2.66, -2.64, -2.63, -2.63, -2.62, -2.61,
        -2.61, -2.61, -2.60, -2.59, -2.58, -2.57, -2.56, -2.55, -2.55, -2.55,
        -2.54, -2.54, -2.53, -2.52, -2.51, -2.51, -2.50, -2.50
    };

    static const float iso226_2003_curve_90_phons[1382] =
    {
        3.31, 3.30, 3.30, 3.29,
        3.29, 3.29, 3.30, 3.29, 3.29, 3.31, 3.29, 3.31, 3.32, 3.31,
        3.33, 3.36, 3.36, 3.36, 3.37, 3.36, 3.36, 3.37, 3.37, 3.36,
        3.37, 3.37, 3.37, 3.36, 3.36, 3.39, 3.39, 3.40, 3.41, 3.43,
        3.41, 3.42, 3.44, 3.42, 3.42, 3.44, 3.42, 3.42, 3.42, 3.44,
        3.45, 3.45, 3.47, 3.46, 3.47, 3.49, 3.50, 3.50, 3.51, 3.51,
        3.51, 3.49, 3.49, 3.49, 3.49, 3.49, 3.49, 3.51, 3.50, 3.50,
        3.53, 3.54, 3.55, 3.55, 3.56, 3.57, 3.58, 3.58, 3.58, 3.57,
        3.55, 3.56, 3.57, 3.58, 3.56, 3.58, 3.57, 3.56, 3.58, 3.60,
        3.60, 3.62, 3.63, 3.63, 3.62, 3.61, 3.63, 3.63, 3.62, 3.64,
        3.63, 3.61, 3.62, 3.63, 3.63, 3.63, 3.66, 3.66, 3.66, 3.67,
        3.70, 3.71, 3.71, 3.71, 3.71, 3.71, 3.72, 3.73, 3.74, 3.75,
        3.76, 3.77, 3.77, 3.77, 3.76, 3.75, 3.77, 3.79, 3.79, 3.79,
        3.79, 3.81, 3.82, 3.80, 3.81, 3.84, 3.83, 3.82, 3.84, 3.84,
        3.84, 3.84, 3.82, 3.83, 3.84, 3.83, 3.82, 3.85, 3.85, 3.87,
        3.88, 3.88, 3.89, 3.88, 3.89, 3.90, 3.90, 3.88, 3.90, 3.90,
        3.90, 3.89, 3.90, 3.90, 3.90, 3.90, 3.92, 3.94, 3.95, 3.95,
        3.95, 3.95, 3.94, 3.96, 3.96, 3.94, 3.96, 3.96, 3.96, 3.97,
        3.98, 4.00, 4.02, 4.03, 4.04, 4.03, 4.03, 4.03, 4.03, 4.02,
        4.03, 4.03, 4.02, 4.02, 4.03, 4.03, 4.02, 4.06, 4.07, 4.09,
        4.12, 4.12, 4.15, 4.16, 4.15, 4.16, 4.15, 4.14, 4.15, 4.15,
        4.15, 4.16, 4.15, 4.16, 4.16, 4.16, 4.16, 4.18, 4.16, 4.16,
        4.17, 4.20, 4.20, 4.22, 4.23, 4.23, 4.21, 4.22, 4.22, 4.22,
        4.22, 4.21, 4.23, 4.24, 4.24, 4.26, 4.27, 4.27, 4.28, 4.29,
        4.28, 4.28, 4.29, 4.30, 4.29, 4.28, 4.28, 4.28, 4.29, 4.30,
        4.32, 4.34, 4.35, 4.38, 4.35, 4.35, 4.37, 4.38, 4.37, 4.38,
        4.40, 4.39, 4.39, 4.39, 4.36, 4.35, 4.35, 4.34, 4.34, 4.35,
        4.37, 4.38, 4.37, 4.39, 4.41, 4.41, 4.41, 4.41, 4.41, 4.44,
        4.44, 4.43, 4.46, 4.48, 4.47, 4.47, 4.48, 4.48, 4.49, 4.52,
        4.52, 4.54, 4.54, 4.54, 4.55, 4.54, 4.55, 4.57, 4.56, 4.57,
        4.56, 4.56, 4.57, 4.59, 4.59, 4.59, 4.61, 4.61, 4.62, 4.62,
        4.62, 4.62, 4.62, 4.60, 4.62, 4.62, 4.60, 4.61, 4.60, 4.61,
        4.63, 4.64, 4.65, 4.67, 4.67, 4.68, 4.68, 4.69, 4.68, 4.68,
        4.70, 4.70, 4.67, 4.70, 4.70, 4.70, 4.71, 4.72, 4.74, 4.75,
        4.76, 4.77, 4.78, 4.79, 4.79, 4.78, 4.77, 4.76, 4.76, 4.78,
        4.79, 4.78, 4.81, 4.81, 4.81, 4.81, 4.81, 4.84, 4.81, 4.84,
        4.86, 4.87, 4.87, 4.88, 4.88, 4.88, 4.88, 4.89, 4.86, 4.89,
        4.89, 4.88, 4.91, 4.91, 4.92, 4.94, 4.94, 4.95, 4.94, 4.94,
        4.95, 4.95, 4.93, 4.95, 4.95, 4.97, 4.97, 4.99, 5.01, 5.02,
        5.03, 5.02, 5.01, 5.02, 5.02, 5.02, 5.03, 5.05, 5.06, 5.07,
        5.08, 5.07, 5.07, 5.10, 5.09, 5.10, 5.12, 5.11, 5.11, 5.13,
        5.11, 5.10, 5.10, 5.11, 5.11, 5.13, 5.14, 5.15, 5.15, 5.15,
        5.15, 5.13, 5.14, 5.14, 5.14, 5.15, 5.15, 5.16, 5.16, 5.18,
        5.19, 5.20, 5.24, 5.24, 5.26, 5.26, 5.29, 5.28, 5.27, 5.29,
        5.28, 5.29, 5.29, 5.29, 5.29, 5.29, 5.31, 5.30, 5.32, 5.34,
        5.34, 5.34, 5.35, 5.35, 5.34, 5.35, 5.34, 5.33, 5.34, 5.34,
        5.35, 5.36, 5.38, 5.41, 5.40, 5.40, 5.42, 5.40, 5.42, 5.41,
        5.40, 5.41, 5.42, 5.42, 5.43, 5.45, 5.45, 5.46, 5.47, 5.47,
        5.47, 5.48, 5.48, 5.47, 5.47, 5.47, 5.48, 5.51, 5.50, 5.51,
        5.53, 5.53, 5.55, 5.58, 5.59, 5.59, 5.61, 5.59, 5.60, 5.61,
        5.59, 5.59, 5.59, 5.59, 5.61, 5.61, 5.62, 5.64, 5.67, 5.64,
        5.67, 5.68, 5.66, 5.67, 5.69, 5.67, 5.69, 5.69, 5.68, 5.70,
        5.70, 5.72, 5.72, 5.72, 5.74, 5.74, 5.74, 5.74, 5.75, 5.74,
        5.74, 5.75, 5.75, 5.75, 5.77, 5.78, 5.77, 5.80, 5.80, 5.79,
        5.79, 5.79, 5.80, 5.81, 5.80, 5.82, 5.84, 5.85, 5.85, 5.87,
        5.88, 5.87, 5.87, 5.87, 5.88, 5.86, 5.88, 5.87, 5.87, 5.88,
        5.88, 5.88, 5.88, 5.88, 5.90, 5.93, 5.94, 5.96, 5.99, 6.01,
        6.00, 6.01, 6.01, 6.02, 6.01, 6.01, 6.01, 5.99, 6.00, 6.01,
        6.03, 6.04, 6.06, 6.07, 6.05, 6.07, 6.07, 6.06, 6.07, 6.07,
        6.07, 6.06, 6.07, 6.06, 6.06, 6.07, 6.06, 6.06, 6.08, 6.10,
        6.11, 6.14, 6.13, 6.12, 6.14, 6.12, 6.12, 6.15, 6.17, 6.18,
        6.20, 6.20, 6.21, 6.22, 6.20, 6.20, 6.20, 6.20, 6.20, 6.20,
        6.20, 6.20, 6.20, 6.20, 6.21, 6.21, 6.20, 6.21, 6.20, 6.22,
        6.23, 6.25, 6.26, 6.27, 6.30, 6.30, 6.30, 6.33, 6.32, 6.33,
        6.33, 6.33, 6.34, 6.36, 6.36, 6.39, 6.39, 6.39, 6.39, 6.39,
        6.39, 6.39, 6.36, 6.36, 6.35, 6.33, 6.35, 6.36, 6.38, 6.39,
        6.40, 6.39, 6.39, 6.41, 6.39, 6.41, 6.42, 6.44, 6.46, 6.46,
        6.47, 6.46, 6.47, 6.46, 6.46, 6.48, 6.50, 6.51, 6.52, 6.50,
        6.49, 6.49, 6.47, 6.46, 6.47, 6.49, 6.50, 6.52, 6.52, 6.52,
        6.52, 6.52, 6.52, 6.53, 6.53, 6.53, 6.55, 6.55, 6.55, 6.58,
        6.58, 6.59, 6.61, 6.60, 6.59, 6.60, 6.61, 6.60, 6.60, 6.60,
        6.60, 6.60, 6.63, 6.63, 6.62, 6.65, 6.65, 6.65, 6.62, 6.61,
        6.60, 6.61, 6.62, 6.62, 6.65, 6.65, 6.65, 6.65, 6.65, 6.65,
        6.66, 6.67, 6.65, 6.66, 6.67, 6.68, 6.70, 6.71, 6.73, 6.74,
        6.76, 6.75, 6.78, 6.78, 6.78, 6.78, 6.78, 6.76, 6.76, 6.76,
        6.74, 6.74, 6.74, 6.74, 6.75, 6.76, 6.78, 6.78, 6.78, 6.78,
        6.78, 6.78, 6.79, 6.78, 6.79, 6.78, 6.78, 6.78, 6.78, 6.79,
        6.79, 6.81, 6.82, 6.82, 6.84, 6.84, 6.84, 6.84, 6.84, 6.84,
        6.84, 6.85, 6.86, 6.87, 6.89, 6.89, 6.87, 6.86, 6.87, 6.87,
        6.84, 6.84, 6.84, 6.84, 6.84, 6.84, 6.84, 6.84, 6.84, 6.84,
        6.87, 6.89, 6.90, 6.92, 6.94, 6.94, 6.95, 6.98, 7.00, 7.00,
        7.02, 7.02, 7.02, 7.02, 7.02, 7.02, 7.03, 7.03, 7.03, 7.03,
        7.03, 7.00, 7.00, 7.00, 7.00, 7.00, 6.98, 6.98, 6.97, 6.97,
        6.98, 6.98, 6.98, 6.97, 7.00, 6.98, 6.98, 7.00, 7.00, 7.00,
        7.00, 7.02, 7.02, 7.02, 7.00, 6.98, 6.97, 6.97, 6.97, 6.97,
        6.97, 6.98, 6.98, 6.97, 7.00, 6.97, 6.98, 6.98, 6.98, 7.01,
        7.00, 7.03, 7.04, 7.06, 7.08, 7.06, 7.06, 7.06, 7.06, 7.06,
        7.05, 7.04, 7.05, 7.05, 7.05, 7.06, 7.05, 7.04, 7.06, 7.05,
        7.05, 7.07, 7.08, 7.10, 7.11, 7.13, 7.11, 7.10, 7.10, 7.08,
        7.07, 7.07, 7.06, 7.06, 7.06, 7.08, 7.07, 7.08, 7.11, 7.11,
        7.10, 7.08, 7.07, 7.05, 7.05, 7.06, 7.06, 7.09, 7.10, 7.11,
        7.11, 7.11, 7.11, 7.11, 7.13, 7.11, 7.13, 7.14, 7.13, 7.14,
        7.13, 7.14, 7.13, 7.13, 7.13, 7.13, 7.13, 7.13, 7.14, 7.16,
        7.18, 7.18, 7.16, 7.16, 7.16, 7.13, 7.13, 7.13, 7.13, 7.13,
        7.13, 7.16, 7.16, 7.18, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.19, 7.19, 7.18, 7.19, 7.19, 7.18, 7.18, 7.18, 7.18, 7.16,
        7.16, 7.14, 7.14, 7.13, 7.14, 7.15, 7.17, 7.18, 7.18, 7.19,
        7.19, 7.19, 7.18, 7.17, 7.17, 7.14, 7.13, 7.14, 7.14, 7.15,
        7.17, 7.16, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.19, 7.19, 7.19, 7.19, 7.17, 7.19, 7.19, 7.20, 7.22, 7.22,
        7.23, 7.24, 7.22, 7.21, 7.20, 7.21, 7.19, 7.19, 7.20, 7.19,
        7.19, 7.20, 7.19, 7.19, 7.21, 7.19, 7.20, 7.19, 7.19, 7.18,
        7.18, 7.19, 7.16, 7.19, 7.18, 7.18, 7.19, 7.19, 7.21, 7.19,
        7.19, 7.20, 7.19, 7.20, 7.20, 7.20, 7.20, 7.19, 7.20, 7.19,
        7.20, 7.19, 7.19, 7.19, 7.18, 7.18, 7.18, 7.19, 7.18, 7.17,
        7.19, 7.18, 7.18, 7.18, 7.18, 7.18, 7.16, 7.16, 7.16, 7.16,
        7.16, 7.18, 7.19, 7.18, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19,
        7.19, 7.19, 7.19, 7.22, 7.23, 7.24, 7.26, 7.24, 7.22, 7.22,
        7.22, 7.21, 7.21, 7.21, 7.21, 7.19, 7.22, 7.22, 7.23, 7.25,
        7.26, 7.26, 7.26, 7.26, 7.26, 7.26, 7.26, 7.25, 7.25, 7.26,
        7.24, 7.22, 7.21, 7.18, 7.18, 7.19, 7.21, 7.22, 7.24, 7.26,
        7.25, 7.25, 7.24, 7.26, 7.27, 7.27, 7.26, 7.26, 7.24, 7.23,
        7.24, 7.21, 7.20, 7.21, 7.21, 7.24, 7.24, 7.27, 7.25, 7.26,
        7.24, 7.24, 7.22, 7.22, 7.21, 7.19, 7.21, 7.18, 7.21, 7.24,
        7.24, 7.23, 7.24, 7.24, 7.22, 7.20, 7.19, 7.18, 7.19, 7.19,
        7.19, 7.19, 7.21, 7.22, 7.24, 7.24, 7.25, 7.26, 7.26, 7.25,
        7.26, 7.26, 7.26, 7.26, 7.25, 7.23, 7.21, 7.21, 7.20, 7.19,
        7.19, 7.19, 7.19, 7.19, 7.17, 7.19, 7.19, 7.19, 7.22, 7.21,
        7.22, 7.22, 7.22, 7.22, 7.22, 7.22, 7.19, 7.18, 7.19, 7.19,
        7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.18, 7.19, 7.16, 7.19,
        7.19, 7.18, 7.18, 7.19, 7.19, 7.19, 7.19, 7.19, 7.19, 7.18,
        7.17, 7.15, 7.13, 7.14, 7.14, 7.13, 7.13, 7.13, 7.13, 7.12,
        7.12, 7.10, 7.10, 7.10, 7.08, 7.08, 7.08, 7.08, 7.08, 7.09,
        7.10, 7.10, 7.09, 7.07, 7.05, 7.05, 7.04, 7.03, 7.02, 7.02,
        7.00, 6.98, 7.01, 7.00, 7.00, 7.00, 7.00, 7.03, 7.02, 7.03,
        7.05, 7.03, 7.03, 7.03, 7.01, 7.00, 6.99, 6.97, 6.95, 6.95,
        6.95, 6.92, 6.93, 6.94, 6.92, 6.91, 6.92, 6.94, 6.94, 6.94,
        6.94, 6.93, 6.90, 6.86, 6.87, 6.84, 6.82, 6.82, 6.80, 6.79,
        6.79, 6.78, 6.78, 6.79, 6.78, 6.78, 6.79, 6.79, 6.79, 6.79,
        6.76, 6.76, 6.76, 6.73, 6.74, 6.74, 6.74, 6.74, 6.73, 6.71,
        6.70, 6.66, 6.65, 6.65, 6.63, 6.62, 6.62, 6.62, 6.62, 6.62,
        6.60, 6.58, 6.58, 6.55, 6.55, 6.54, 6.50, 6.49, 6.46, 6.42,
        6.40, 6.41, 6.39, 6.40, 6.41, 6.38, 6.38, 6.36, 6.34, 6.36,
        6.33, 6.33, 6.33, 6.34, 6.31, 6.29, 6.28, 6.28, 6.26, 6.25,
        6.25, 6.22, 6.22, 6.20, 6.20, 6.17, 6.15, 6.14, 6.12, 6.09,
        6.09, 6.08, 6.06, 6.04, 6.01, 6.00, 5.98, 5.95, 5.95, 5.94,
        5.92, 5.92, 5.91, 5.88, 5.87, 5.85, 5.83, 5.83
    };

    static const float * const iso226_2003_curves[] =
    {
        iso226_2003_curve_0_phons,
        iso226_2003_curve_10_phons,
        iso226_2003_curve_20_phons,
        iso226_2003_curve_30_phons,
        iso226_2003_curve_40_phons,
        iso226_2003_curve_50_phons,
        iso226_2003_curve_60_phons,
        iso226_2003_curve_70_phons,
        iso226_2003_curve_80_phons,
        iso226_2003_curve_90_phons
    };

    static const freq_curve_t iso226_2003_curve =
    {
        19.75, // fmin
        12719.18, // fmax
        0.00, // amin
        90.00, // amax
        1382, // hdots
        10, // curves
        iso226_2003_curves // curve data
    };
}

#endif /* GENERATED_ISO226_ISO226_2003_H_ */
