#ifndef ADNS_HAVE_RRSIG_H
#define HAVE_ADNS_RRSIG_H

#include "adns_rr.h"
#include "dnskey_rr.h"

namespace ADNS {

/* From IETF.ORG RFC 4034

   The RDATA for an RRSIG RR consists of a 2 octet Type Covered field, a
   1 octet Algorithm field, a 1 octet Labels field, a 4 octet Original
   TTL field, a 4 octet Signature Expiration field, a 4 octet Signature
   Inception field, a 2 octet Key tag, the Signer's Name field, and the
   Signature field.

                        1 1 1 1 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 2 3 3
    0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |        Type Covered           |  Algorithm    |     Labels    |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                         Original TTL                          |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                      Signature Expiration                     |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |                      Signature Inception                      |
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   |            Key Tag            |                               /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+         Signer's Name         /
   /                                                               /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
   /                                                               /
   /                            Signature                          /
   /                                                               /
   +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

*/

	public ref class RRSIG_RR : ResourceRecord
	{
		//Functions
	public:
		RRSIG_RR();
		RR_TYPE GetTypeCovered();
		Void SetTypeCovered(RR_TYPE t);
		SIGN_ALGORITHM GetAlgorithm();
		Void SetAlgorithm(SIGN_ALGORITHM sa);
		Byte GetLabels();
		Void SetLabels(Byte l);
		UInt32 GetOriginalTTL();
		Void SetOriginalTTL(UInt32 newttl);
		UInt32 GetSignatureExpiration();
		Void SetSignatureExpiration(UInt32 sigexp);
		UInt32 GetSignatureInception();
		Void SetSignatureInception(UInt32 siginc);
		UInt16 GetKeyTag();
		Void SetKeyTag(UInt16 keytag);
		DOMAIN_NAME^ GetSignerName();
		Void SetSignerName(DOMAIN_NAME^ sn);
		array<Byte>^ GetSignature();
		Void SetSignature(array<Byte>^ sig);
		String^ Print();
		array<Byte>^ RRSIG_RR::RdataNoSignature();
		Void ToCanonical();
		bool RRSIG_RR::ValidateSignature(array<Byte>^ CanonicalByteArray, DNSKEY_RR^ key);
		RRSIG_RR^ Clone();
		static ResourceRecord^ ParseResourceRecord(array<Byte>^ domainname, UInt16 rr_type, UInt16 rr_class, UInt32 ttl, UInt16 rdata_len, array<Byte>^ packet, int rdata_start);
		static String^ PrintRR(ResourceRecord^ rec);
		static ResourceRecord^ CloneRR(ResourceRecord^ rec);


	private:

		RR_TYPE TypeCovered;
		DOMAIN_NAME^ signer;
		array<Byte>^ signature;
		Byte Labels;
		UInt32 originalttl;
		UInt32 SigExpiration;
		UInt32 SigInception;
		UInt16 KeyTag;
		SIGN_ALGORITHM sig_algo;

		//functions
		Void UpdateRdata();
	};
}

#endif
