/* -*- c++ -*-
*
* fileselector.cpp
*
* Copyright (C) 2004 Petter Stokke <ummo@hellokitty.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
*_ of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*
*/

#include "fileselector.h"

#include <kdebug.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <klineedit.h>
#include <kguiitem.h>
#include <kfiledialog.h>

#include <QLayout>
//Added by qt3to4:
#include <Q3HBoxLayout>

FileSelector::FileSelector( const QString& dialogCaption, bool selectDir, QWidget* parent, const char* name )
        : QWidget( parent )
        , m_caption( dialogCaption )
        , m_selectDir( selectDir )
{
    setObjectName(name);
    Q3HBoxLayout * l = new Q3HBoxLayout( this );
    m_name = new KLineEdit( this );
    m_name->setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );
    l->addWidget( m_name );
    m_button = new KPushButton( KGuiItem( QString::null, "fileopen" ), this );
    m_button->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Expanding );
    l->addWidget( m_button );
    setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Fixed );

    connect( m_button, SIGNAL( clicked() ), this, SLOT( slotButtonClicked() ) );
    connect( m_name, SIGNAL( textChanged( const QString& ) ), this, SLOT( slotTextChanged( const QString& ) ) );
}

void FileSelector::slotTextChanged( const QString& t )
{
    QFileInfo info( t );
    if ( ( m_selectDir && info.isDir() ) || info.exists() )
        emit fileSelected( t );
    else
        emit fileSelected( QString::null );
}

void FileSelector::slotButtonClicked()
{
    QString path;
    if ( m_selectDir ) {
        path = KFileDialog::getExistingDirectory( m_name->text(), this, m_caption );
    } else {
        path = KFileDialog::getOpenFileName( m_name->text(), QString::null, this, m_caption );
    }
    if ( !path.isEmpty() ) {
        m_name->setText( path );
    }
}

bool FileSelector::isExecutable()
{
    QFileInfo info( m_name->text() );
    return info.isExecutable();
}

bool FileSelector::isDir()
{
    QFileInfo info( m_name->text() );
    return info.isDir();
}

QString FileSelector::fileName()
{
    return m_name->text();
}


#include "fileselector.moc"
