/*
 * Copyright (C) 2016 Intel Corporation. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL PRECISION INSIGHT AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "i965_jpeg_test_data.h"
#include "i965_drv_video.h"
#include "i965_streamable.h"
#include "test_utils.h"

#include <algorithm>
#include <numeric>

namespace JPEG {
namespace Decode {

    /**
     * Test Pattern 1
     *
     * Solid Black 10x10
     *
     */
    template<> const bool TestPatternData<1>::m_valid =
        TestPatternData<1>::initialize<10, 10>(

            generateSolid({0x00, 0x80, 0x80}, {10, 10}),

            {{VA_FOURCC_IMC3, {
                0xff,0x00,0x3f,0xfa,0x28,0xa2,0x80,0x3f,0xff,
            }},
            {VA_FOURCC_422H, {
                0xff,0x00,0x3f,0xfa,0x28,0x00,0xa2,0x80,0x3f,0xff,
            }},
            {VA_FOURCC_422V, {
                0xff,0x00,0x3f,0xfa,0x28,0x00,0xa2,0x80,0x3f,0xff,
            }},
            {VA_FOURCC_411P, {
                0xff,0x00,0x3f,0xfa,0x28,0xa2,0x80,0x0a,0x28,0xa2,0x80,0x3f,
                0xff,
            }},
            {VA_FOURCC_444P, {
              0xff,0x00,0x3f,0xfa,0x00,0x28,0x00,0xa0,0x02,0x80,0x3f,0xff,
            }}}
        );


    /**
     * Test Pattern 2
     *
     * R = red
     * G = green
     * B = blue
     * W = white
     * K = black
     * -------------------
     * R R G G B B W W K K
     * R R G G B B W W K K
     * K K R R G G B B W W
     * K K R R G G B B W W
     * W W K K R R G G B B
     * W W K K R R G G B B
     * B B W W K K R R G G
     * B B W W K K R R G G
     * G G B B W W K K R R
     * G G B B W W K K R R
     * -------------------
     *
     */

    template<> const bool TestPatternData<2>::m_valid =
        TestPatternData<2>::initialize<10, 10>({
            // Pixel Y Component
            0x4c,0x4c,0x95,0x95,0x1d,0x1d,0xff,0xff,0x00,0x00,
            0x4c,0x4c,0x95,0x95,0x1d,0x1d,0xff,0xff,0x00,0x00,
            0x00,0x00,0x4c,0x4c,0x95,0x95,0x1d,0x1d,0xff,0xff,
            0x00,0x00,0x4c,0x4c,0x95,0x95,0x1d,0x1d,0xff,0xff,
            0xff,0xff,0x00,0x00,0x4c,0x4c,0x95,0x95,0x1d,0x1d,
            0xff,0xff,0x00,0x00,0x4c,0x4c,0x95,0x95,0x1d,0x1d,
            0x1d,0x1d,0xff,0xff,0x00,0x00,0x4c,0x4c,0x95,0x95,
            0x1d,0x1d,0xff,0xff,0x00,0x00,0x4c,0x4c,0x95,0x95,
            0x95,0x95,0x1d,0x1d,0xff,0xff,0x00,0x00,0x4c,0x4c,
            0x95,0x95,0x1d,0x1d,0xff,0xff,0x00,0x00,0x4c,0x4c,

            // Pixel U Component
            0x54,0x54,0x2b,0x2b,0xff,0xff,0x80,0x80,0x80,0x80,
            0x54,0x54,0x2b,0x2b,0xff,0xff,0x80,0x80,0x80,0x80,
            0x80,0x80,0x54,0x54,0x2b,0x2b,0xff,0xff,0x80,0x80,
            0x80,0x80,0x54,0x54,0x2b,0x2b,0xff,0xff,0x80,0x80,
            0x80,0x80,0x80,0x80,0x54,0x54,0x2b,0x2b,0xff,0xff,
            0x80,0x80,0x80,0x80,0x54,0x54,0x2b,0x2b,0xff,0xff,
            0xff,0xff,0x80,0x80,0x80,0x80,0x54,0x54,0x2b,0x2b,
            0xff,0xff,0x80,0x80,0x80,0x80,0x54,0x54,0x2b,0x2b,
            0x2b,0x2b,0xff,0xff,0x80,0x80,0x80,0x80,0x54,0x54,
            0x2b,0x2b,0xff,0xff,0x80,0x80,0x80,0x80,0x54,0x54,

            // Pixel V Component
            0xff,0xff,0x15,0x15,0x6b,0x6b,0x80,0x80,0x80,0x80,
            0xff,0xff,0x15,0x15,0x6b,0x6b,0x80,0x80,0x80,0x80,
            0x80,0x80,0xff,0xff,0x15,0x15,0x6b,0x6b,0x80,0x80,
            0x80,0x80,0xff,0xff,0x15,0x15,0x6b,0x6b,0x80,0x80,
            0x80,0x80,0x80,0x80,0xff,0xff,0x15,0x15,0x6b,0x6b,
            0x80,0x80,0x80,0x80,0xff,0xff,0x15,0x15,0x6b,0x6b,
            0x6b,0x6b,0x80,0x80,0x80,0x80,0xff,0xff,0x15,0x15,
            0x6b,0x6b,0x80,0x80,0x80,0x80,0xff,0xff,0x15,0x15,
            0x15,0x15,0x6b,0x6b,0x80,0x80,0x80,0x80,0xff,0xff,
            0x15,0x15,0x6b,0x6b,0x80,0x80,0x80,0x80,0xff,0xff,
        },{
            {VA_FOURCC_IMC3, {
                0xf8,0x8b,0xc3,0x7e,0x24,0xf1,0xf7,0xec,0x71,0xe3,0xef,0xd9,
                0x8f,0xc6,0x5e,0x0d,0xfd,0xa7,0x7f,0xe1,0x27,0xf0,0x3f,0x89,
                0xff,0x00,0xe1,0x74,0xff,0x00,0xc3,0xae,0x3f,0xe0,0xa8,0xff,
                0x00,0xf0,0xa5,0xb4,0x5d,0x17,0xfe,0x13,0x5f,0xec,0x5d,0x16,
                0x7d,0x2b,0xf6,0xda,0xff,0x00,0x8c,0x25,0xd5,0x60,0xf1,0x46,
                0xaf,0xe1,0xbf,0xf8,0x46,0xf5,0x7f,0x14,0x5d,0x7e,0xcf,0x1f,
                0xf1,0x90,0xf6,0xb6,0xff,0x00,0xdb,0x1f,0x67,0xff,0x00,0x85,
                0xb5,0xf0,0x93,0xcd,0xb5,0x96,0x39,0x2d,0xfd,0x07,0xfe,0x19,
                0xbb,0xf6,0x07,0xff,0x00,0xa5,0x63,0x7f,0xf3,0xb4,0x5f,0x19,
                0xff,0x00,0xf9,0x7b,0x47,0xed,0x23,0xff,0x00,0x26,0x0f,0xff,
                0x00,0x07,0x39,0x7f,0xde,0x17,0x7f,0xf5,0x73,0xe8,0x55,0xf9,
                0xf7,0x5f,0x1f,0xe2,0x3f,0x8a,0xf8,0xff,0x00,0xa3,0x8e,0x03,
                0xc3,0x8c,0x27,0x03,0x70,0x0f,0x86,0x1e,0x22,0x78,0x59,0xe2,
                0xaf,0x86,0x1e,0x19,0x78,0xeb,0xc0,0x1e,0x1b,0xf8,0xfd,0x85,
                0xf1,0x3f,0x89,0xf1,0x1e,0x04,0xe1,0xfc,0x7c,0xf0,0xc3,0x81,
                0x7c,0x7c,0xce,0xf8,0x1f,0x82,0x38,0xcb,0xc1,0x4f,0x16,0x3e,
                0x8f,0x39,0x9e,0x61,0x92,0x54,0xcc,0xfc,0x56,0x6f,0x88,0xb2,
                0xcc,0xdf,0x03,0x2e,0x03,0xc5,0xf1,0xe6,0x5d,0xc5,0x1e,0x29,
                0x78,0x7b,0xe1,0xdf,0x85,0x39,0xef,0x8b,0x3e,0x26,0xe5,0xfc,
                0x45,0xfd,0x1d,0xf4,0x11,0xfa,0x20,0xf1,0xcf,0xed,0x4a,0xe0,
                0x6c,0xc3,0xc7,0x0f,0x0f,0xbc,0x67,0xe1,0xff,0x00,0xa2,0xef,
                0x1c,0xe6,0x1c,0x3f,0xc0,0x5c,0x75,0xe2,0xed,0x2c,0xf3,0xc2,
                0x5c,0x5f,0x8f,0x7c,0x35,0xe2,0x7f,0x12,0xf8,0xa7,0x83,0xcf,
                0xb3,0x5c,0x3f,0x1b,0xe1,0xf2,0x6c,0x2f,0x8a,0x3e,0x09,0x62,
                0x38,0x3b,0xc5,0x0c,0x46,0x23,0x22,0xce,0x5f,0x8c,0x1c,0x63,
                0x86,0xcc,0xf3,0xac,0xa7,0xc7,0x0c,0xdb,0x15,0x90,0x78,0x89,
                0x9d,0xf0,0x7f,0x0f,0x78,0xcd,0x5f,0xc6,0x6f,0x13,0xfc,0x74,
                0xff,
            }},
            {VA_FOURCC_422H, {
                0xf8,0x8b,0xc3,0x7e,0x24,0xf1,0xf7,0xec,0x71,0xe3,0xef,0xd9,
                0x8f,0xc6,0x5e,0x0d,0xfd,0xa7,0x7f,0xe1,0x27,0xf0,0x3f,0x89,
                0xff,0x00,0xe1,0x74,0xff,0x00,0xc3,0xae,0x3f,0xe0,0xa8,0xff,
                0x00,0xf0,0xa5,0xb4,0x5d,0x17,0xfe,0x13,0x5f,0xec,0x5d,0x16,
                0x7d,0x2b,0xf6,0xda,0xff,0x00,0x8c,0x25,0xd5,0x60,0xf1,0x46,
                0xaf,0xe1,0xbf,0xf8,0x46,0xf5,0x7f,0x14,0x5d,0x7e,0xcf,0x1f,
                0xf1,0x90,0xf6,0xb6,0xff,0x00,0xdb,0x1f,0x67,0xff,0x00,0x85,
                0xb5,0xf0,0x93,0xcd,0xb5,0x96,0x39,0x2d,0xfd,0x07,0xfe,0x19,
                0xbb,0xf6,0x07,0xff,0x00,0xa5,0x63,0x7f,0xf3,0xb4,0x5f,0x19,
                0xff,0x00,0xf9,0x7b,0x5f,0x41,0xc2,0x19,0xf7,0xd1,0xb7,0xc1,
                0x0c,0x57,0x17,0xfd,0x17,0x7e,0x9d,0x3f,0x48,0x4f,0xf8,0x94,
                0xdc,0x77,0x80,0x7c,0x6b,0xc6,0x78,0x0f,0x06,0x73,0xff,0x00,
                0xf8,0x84,0xfc,0x7b,0xe3,0xbf,0xfa,0xcf,0xc1,0xbc,0x6b,0xc6,
                0xbc,0x4f,0xc4,0xbc,0x7f,0xe0,0xe7,0xf6,0x57,0x83,0xd4,0x73,
                0x6a,0x39,0x2f,0xfc,0x41,0x1f,0x1b,0x9f,0x89,0x5c,0x61,0xff,
                0x00,0x11,0x0b,0x8a,0xb8,0x83,0x39,0xcd,0x7c,0x4a,0xff,0x00,
                0x88,0xff,0x00,0xfe,0xaf,0xe4,0xb3,0xc2,0x70,0x8f,0x85,0x59,
                0x05,0x03,0xf1,0xef,0xa4,0xf7,0x8d,0xfc,0x07,0xe0,0x07,0x13,
                0x61,0x7c,0x6f,0xe3,0x3c,0xcf,0xfb,0x3b,0xc3,0xaf,0xa5,0xbe,
                0x6d,0xc5,0x3e,0x24,0xe0,0x31,0xbf,0x52,0xce,0x71,0x7f,0x50,
                0xfa,0x49,0xe0,0x31,0x19,0x5e,0x3f,0xe9,0x65,0xc3,0x7f,0x56,
                0xca,0xb2,0x9c,0xe7,0x3d,0xc5,0x7f,0xad,0xbc,0x51,0xc6,0x5c,
                0x0b,0xf4,0xaa,0xfe,0xd8,0xad,0x94,0xf0,0xdf,0x01,0x64,0x3f,
                0xf1,0x35,0x5f,0xf1,0x03,0x7c,0x35,0xc0,0x4f,0x2f,0xf0,0x37,
                0x38,0x86,0x14,0xfd,0xa4,0x7f,0xe4,0xc1,0xff,0x00,0xe0,0xe7,
                0x2f,0xfb,0xc2,0xef,0xfe,0xae,0x7d,0x0a,0xbf,0x3e,0xeb,0xf9,
                0x7b,0xe9,0x7b,0xff,0x00,0x24,0xb7,0xd1,0x0b,0xfe,0xd0,0xb3,
                0xe8,0x63,0xff,0x00,0xb0,0x57,0xf4,0x65,0x3f,0xdd,0xdf,0xf4,
                0x61,0x7f,0xe5,0x1a,0x38,0xab,0xfe,0xcd,0x4f,0xd1,0x73,0xff,
                0x00,0x54,0x1e,0x27,0x9f,0xff,
            }},
            {VA_FOURCC_422V, {
                0xf8,0x8b,0xc3,0x7e,0x24,0xf1,0xf7,0xec,0x71,0xe3,0xef,0xd9,
                0x8f,0xc6,0x5e,0x0d,0xfd,0xa7,0x7f,0xe1,0x27,0xf0,0x3f,0x89,
                0xff,0x00,0xe1,0x74,0xff,0x00,0xc3,0xae,0x3f,0xe0,0xa8,0xff,
                0x00,0xf0,0xa5,0xb4,0x5d,0x17,0xfe,0x13,0x5f,0xec,0x5d,0x16,
                0x7d,0x2b,0xf6,0xda,0xff,0x00,0x8c,0x25,0xd5,0x60,0xf1,0x46,
                0xaf,0xe1,0xbf,0xf8,0x46,0xf5,0x7f,0x14,0x5d,0x7e,0xcf,0x1f,
                0xf1,0x90,0xf6,0xb6,0xff,0x00,0xdb,0x1f,0x67,0xff,0x00,0x85,
                0xb5,0xf0,0x93,0xcd,0xb5,0x96,0x39,0x2d,0xfd,0x07,0xf6,0x91,
                0xff,0x00,0x93,0x07,0xff,0x00,0x83,0x9c,0xbf,0xef,0x0b,0xbf,
                0xfa,0xb9,0xf4,0x2a,0xfa,0x0c,0x87,0x81,0x70,0xb9,0x4f,0xd1,
                0xb7,0xe8,0xf7,0xf4,0xd8,0xfa,0x2e,0x71,0x4f,0x1a,0xfd,0x1c,
                0xf0,0x1f,0x4c,0xef,0xf8,0x8b,0x1f,0xdb,0xfe,0x0b,0xe3,0xeb,
                0xf0,0x57,0x8c,0x5c,0x1a,0xff,0x00,0xe2,0x5d,0x78,0xf6,0xb7,
                0x84,0xb9,0x57,0xfc,0x46,0x3e,0x1c,0xe2,0x5e,0x04,0xc8,0xfc,
                0x11,0xfa,0x44,0x5a,0xb5,0x4e,0x20,0xe2,0xbf,0x0f,0x7f,0xd7,
                0x0f,0x00,0xb2,0x5f,0xf8,0x84,0x99,0xae,0x79,0x0c,0x7f,0x0f,
                0xff,0x00,0x69,0x71,0x76,0x59,0x43,0x8d,0x2b,0x7e,0x3d,0xe0,
                0x87,0x8f,0xfc,0x33,0xf4,0xdc,0xe0,0x3c,0xb3,0xc6,0xbf,0x1b,
                0xfc,0x3a,0xcd,0xb0,0xbe,0x22,0xf1,0x1f,0xd7,0x7e,0xbb,0xe3,
                0x37,0x86,0xdc,0x79,0x87,0xe0,0xef,0xa4,0x9c,0xbf,0xb1,0xf3,
                0x9c,0xdb,0x84,0xf0,0xdf,0xeb,0x27,0x8b,0x58,0xfe,0x09,0xe2,
                0x6e,0x17,0xf1,0xc6,0xd9,0x17,0x09,0xe5,0x3c,0x2b,0x93,0xff,
                0x00,0xc4,0xd5,0x78,0x4f,0xf4,0x84,0xff,0x00,0x88,0x67,0xc0,
                0x52,0xc7,0xf0,0xd7,0x81,0xbf,0xf1,0x09,0xf3,0x0c,0x54,0x38,
                0x97,0x0e,0x7f,0xc3,0x37,0x7e,0xc0,0xff,0x00,0xf4,0xac,0x6f,
                0xfe,0x76,0x8b,0xe3,0x3f,0xff,0x00,0x2f,0x6b,0xf3,0xee,0xbf,
                0x97,0xbf,0xe2,0x7a,0x78,0xa7,0xfe,0x91,0x6b,0xe8,0x59,0xff,
                0x00,0x86,0x4f,0xa6,0x9f,0xff,0x00,0x57,0x59,0xfe,0xee,0xff,
                0x00,0xc5,0x01,0x7e,0x92,0xff,0x00,0xf4,0xb1,0x3f,0x0a,0x7f,
                0xf1,0x83,0xf3,0xff,0x00,0xfe,0xad,0x73,0xff,
            }},
            {VA_FOURCC_411P, {
                0xf8,0x8b,0xc3,0x7e,0x24,0xf1,0xf7,0xec,0x71,0xe3,0xef,0xd9,
                0x8b,0xc6,0x5e,0x0d,0xfd,0xa7,0x7f,0xe1,0x27,0xf0,0x3f,0x89,
                0xbf,0xe1,0x74,0xff,0x00,0xc3,0xae,0x3f,0xe0,0xa8,0xff,0x00,
                0xf0,0xa5,0xb4,0x5d,0x17,0xfe,0x13,0x6f,0xec,0x5d,0x16,0xe3,
                0x4a,0xfd,0xb6,0xbf,0xe3,0x09,0x75,0x5b,0x7f,0x14,0x6a,0xfe,
                0x1c,0xff,0x00,0x84,0x6f,0x57,0xf1,0x45,0xd7,0xec,0xf1,0xff,
                0x00,0x19,0x0f,0x6b,0x6f,0xfd,0xb1,0xf6,0x7f,0xf8,0x5b,0x5f,
                0x09,0x7c,0xdb,0x59,0xa3,0x92,0xdf,0xd0,0x7f,0xe1,0x9b,0xbf,
                0x60,0x7f,0xfa,0x56,0x37,0xff,0x00,0x3b,0x45,0xf1,0x9f,0xff,
                0x00,0x97,0xb4,0x51,0x5f,0x79,0xc3,0xbc,0x6f,0xfb,0x3c,0xf8,
                0x5b,0x25,0xcb,0xf8,0x23,0xe9,0x37,0xf4,0xf2,0xff,0x00,0x89,
                0x73,0xf1,0xaf,0xc3,0x8a,0x52,0xf0,0xb7,0x8b,0x7c,0x1b,0xff,
                0x00,0x89,0x5e,0xf1,0xbf,0xc5,0xef,0xf5,0x47,0x03,0xe1,0x75,
                0x5a,0x9e,0x1e,0xf0,0x5d,0x5f,0xf8,0x88,0x7e,0x1f,0xe1,0x31,
                0x1c,0x27,0x9f,0xff,0x00,0xac,0xdc,0x07,0xc3,0x5c,0x31,0xc5,
                0xfc,0x99,0x6e,0x2f,0x1d,0x5b,0x25,0xfe,0xdf,0xfe,0xc0,0xcd,
                0x73,0x0c,0xc3,0x39,0xca,0xb3,0x0c,0x6d,0x7f,0xe4,0xff,0x00,
                0x1a,0x3e,0x99,0x9e,0x09,0x78,0x1b,0xe2,0x87,0x17,0xf8,0x79,
                0xc7,0x9c,0x47,0xfd,0x91,0x9f,0xd0,0xcc,0x28,0x71,0x85,0x1c,
                0x9b,0xfb,0x23,0x8b,0x73,0x0f,0xec,0x5e,0x18,0xf1,0x43,0x2f,
                0xc1,0xf8,0xa1,0xc0,0xb9,0x27,0xf6,0x8e,0x4d,0xc2,0xd9,0xb6,
                0x0b,0x32,0xfe,0xc7,0xe0,0x8e,0x31,0xe1,0xdc,0xb7,0xfb,0x4a,
                0x78,0xd7,0x98,0x66,0x1f,0x55,0xfa,0xe6,0x71,0x86,0xcb,0xf3,
                0x7a,0xf8,0xec,0xbf,0x0a,0x7e,0xd2,0x3f,0xf2,0x60,0xff,0x00,
                0xf0,0x73,0x97,0xfd,0xe1,0x77,0xff,0x00,0x57,0x3e,0x85,0x5f,
                0x9f,0x74,0x51,0x5f,0xe6,0xbf,0xd2,0x37,0xfe,0x4f,0x67,0x88,
                0x3f,0xf6,0x36,0xc3,0x7f,0xea,0xab,0x2f,0x3f,0xed,0xab,0xf6,
                0x30,0xff,0x00,0xca,0xb0,0x7e,0x88,0x3f,0xf6,0x6f,0xf3,0xaf,
                0xfd,0x6f,0xf8,0xbc,0xff,
            }},
            {VA_FOURCC_444P, {
                0xf8,0x8b,0xc3,0x7e,0x24,0xf1,0xf7,0xec,0x71,0xe3,0xef,0xd9,
                0x8f,0xc6,0x5e,0x0d,0xfd,0xa7,0x7f,0xe1,0x27,0xf0,0x3f,0x89,
                0xff,0x00,0xe1,0x74,0xff,0x00,0xc3,0xae,0x3f,0xe0,0xa8,0xff,
                0x00,0xf0,0xa5,0xb4,0x5d,0x17,0xfe,0x13,0x5f,0xec,0x5d,0x16,
                0x7d,0x2b,0xf6,0xda,0xff,0x00,0x8c,0x25,0xd5,0x60,0xf1,0x46,
                0xaf,0xe1,0xbf,0xf8,0x46,0xf5,0x7f,0x14,0x5d,0x7e,0xcf,0x1f,
                0xf1,0x90,0xf6,0xb6,0xff,0x00,0xdb,0x1f,0x67,0xff,0x00,0x85,
                0xb5,0xf0,0x93,0xcd,0xb5,0x96,0x39,0x2d,0xfc,0x9c,0xd3,0x2b,
                0xf1,0x8b,0xf6,0x60,0x78,0xc5,0xe2,0xc6,0x47,0x9e,0x78,0x4f,
                0xfe,0xbe,0xf8,0x47,0xc7,0xbf,0xea,0x27,0xfc,0x4d,0xbf,0xd1,
                0x23,0xfd,0x7b,0xe1,0x7e,0x16,0xff,0x00,0x88,0xa3,0xfe,0xab,
                0x70,0xbd,0x3c,0x67,0x80,0x9f,0xf1,0xbe,0xf0,0x75,0x38,0xff,
                0x00,0x89,0xb8,0x27,0xfd,0x49,0xe2,0x6e,0x3f,0xa3,0xe2,0x67,
                0xfc,0x6b,0x3a,0xd8,0x3f,0xf5,0x93,0xea,0x7f,0xea,0x67,0x19,
                0xfd,0x63,0x2f,0xc4,0x4a,0x38,0x2f,0xbe,0xf1,0x2b,0xc3,0x5e,
                0x28,0xfa,0x6d,0x71,0x46,0x37,0xe9,0x11,0xf4,0x77,0xc1,0x7f,
                0x6c,0xfe,0xd0,0xfc,0xe7,0xea,0xdf,0xf1,0x10,0xbc,0x3d,0xfa,
                0xce,0x5d,0x97,0x7f,0xc5,0x46,0xff,0x00,0xb3,0xb2,0xfc,0x07,
                0x03,0xf0,0x9f,0xfc,0x65,0x9c,0x71,0x8f,0xe1,0x4f,0x03,0xfe,
                0x88,0x5f,0xf1,0x28,0x5e,0x07,0x70,0xa6,0x77,0x9d,0xff,0x00,
                0xc2,0x26,0x49,0x4b,0xfe,0x23,0xf7,0xb2,0xfe,0xcd,0xcc,0xb9,
                0xf8,0xbe,0x78,0x4c,0x5e,0x27,0xd0,0x7f,0xe1,0x9b,0xbf,0x60,
                0x7f,0xfa,0x56,0x37,0xff,0x00,0x3b,0x45,0xf1,0x9f,0xff,0x00,
                0x97,0xb5,0xfb,0x67,0xfc,0x45,0x1f,0xd8,0xf3,0xff,0x00,0x4b,
                0x60,0xff,0x00,0xcf,0x14,0xfa,0x51,0x7f,0xf3,0xbc,0xff,0x00,
                0x30,0x7f,0xe2,0xa5,0x3f,0x46,0x0f,0xfa,0x2c,0xff,0x00,0xf3,
                0x5d,0xf1,0x0b,0xff,0x00,0xa0,0x40,0xfd,0xa4,0x7f,0xe4,0xc1,
                0xff,0x00,0xe0,0xe7,0x2f,0xfb,0xc2,0xef,0xfe,0xae,0x7d,0x0a,
                0x8f,0x0b,0xbf,0xe5,0x4f,0x3f,0xb2,0x7f,0xfe,0xf7,0xaf,0xff,
                0x00,0x62,0x8b,0x30,0x0f,0xd9,0xad,0xff,0x00,0x28,0xc1,0xc1,
                0x9f,0xf7,0x71,0x7f,0xeb,0xc2,0xe3,0xb3,0xf3,0xee,0xbf,0xc5,
                0x13,0xff,0x00,0x4f,0x83,0xff,
            }},
        });

    /**
     * Test Pattern 3
     *
     * R = red
     * G = green
     * B = blue
     * W = white
     * C = cyan
     * M = magenta
     * Y = yellow
     * K = black
     * -------------------
     * K R B Y G C M K K W
     * R K R B Y G C M W K
     * B R K R B Y G C M K
     * Y B R K R B Y G C M
     * G Y B R K R B Y G C
     * C G Y B R K R B Y G
     * M C G Y B R K R B Y
     * K M C G Y B R K R K
     * K W M C G Y B R K R
     * W K K M C G Y B R K
     * -------------------
     *
     */
    template<> const bool TestPatternData<3>::m_valid =
        TestPatternData<3>::initialize<10, 10>({
            0x00,0x4c,0x1d,0xe2,0x96,0xb3,0x69,0x00,0x00,0xfe,
            0x4c,0x00,0x4c,0x1d,0xe2,0x96,0xb3,0x69,0xff,0x00,
            0x1d,0x4c,0x00,0x4c,0x1d,0xe3,0x96,0xb3,0x69,0x00,
            0xe2,0x1d,0x4c,0x00,0x4c,0x1d,0xe2,0x96,0xb3,0x68,
            0x96,0xe2,0x1d,0x4c,0x00,0x4c,0x1d,0xe2,0x96,0xb3,
            0xb3,0x96,0xe3,0x1d,0x4c,0x00,0x4c,0x1d,0xe2,0x96,
            0x69,0xb3,0x96,0xe2,0x1d,0x4c,0x00,0x4c,0x1d,0xe2,
            0x00,0x69,0xb3,0x96,0xe2,0x1d,0x4c,0x00,0x4c,0x1d,
            0x00,0xff,0x69,0xb3,0x96,0xe2,0x1d,0x4c,0x00,0x4c,
            0xff,0x00,0x00,0x68,0xb3,0x96,0xe2,0x1d,0x4c,0x00,

            0x80,0x55,0xff,0x00,0x2c,0xab,0xd4,0x80,0x80,0x80,
            0x55,0x80,0x54,0xff,0x00,0x2c,0xab,0xd4,0x80,0x80,
            0xff,0x55,0x80,0x55,0xff,0x00,0x2c,0xab,0xd4,0x80,
            0x00,0xff,0x55,0x80,0x55,0xff,0x00,0x2c,0xab,0xd4,
            0x2c,0x00,0xff,0x55,0x80,0x55,0xff,0x00,0x2c,0xab,
            0xab,0x2c,0x00,0xff,0x55,0x80,0x55,0xff,0x00,0x2c,
            0xd4,0xab,0x2c,0x00,0xff,0x54,0x80,0x55,0xff,0x00,
            0x80,0xd4,0xab,0x2c,0x00,0xff,0x55,0x80,0x55,0xff,
            0x80,0x80,0xd4,0xab,0x2c,0x00,0xff,0x55,0x81,0x54,
            0x80,0x80,0x80,0xd4,0xab,0x2c,0x00,0xff,0x55,0x80,

            0x80,0xff,0x6b,0x95,0x15,0x00,0xeb,0x80,0x80,0x80,
            0xff,0x80,0xff,0x6b,0x95,0x15,0x00,0xeb,0x80,0x80,
            0x6b,0xff,0x80,0xff,0x6b,0x95,0x15,0x00,0xeb,0x80,
            0x95,0x6b,0xff,0x80,0xff,0x6b,0x95,0x15,0x00,0xeb,
            0x15,0x95,0x6b,0xff,0x80,0xff,0x6b,0x95,0x16,0x00,
            0x00,0x15,0x95,0x6b,0xff,0x80,0xff,0x6b,0x95,0x15,
            0xeb,0x00,0x15,0x95,0x6b,0xff,0x80,0xff,0x6b,0x95,
            0x80,0xeb,0x00,0x15,0x95,0x6b,0xff,0x80,0xff,0x6b,
            0x80,0x80,0xeb,0x00,0x15,0x95,0x6b,0xff,0x7f,0xff,
            0x80,0x80,0x80,0xeb,0x00,0x14,0x95,0x6b,0xff,0x80,
        },{
            {VA_FOURCC_IMC3, {
                0xf8,0x6f,0xf7,0x5f,0xb0,0x2c,0x5f,0xf2,0xc3,0xf6,0xa8,0xff,
                0x00,0x82,0x4e,0x7e,0xd5,0x10,0x7f,0xd4,0x03,0xc4,0x96,0x9e,
                0x15,0xb4,0xf1,0x26,0x81,0xff,0x00,0x72,0xe7,0x83,0xac,0x3c,
                0x5f,0x61,0xe0,0xef,0x0e,0x7f,0xd4,0x91,0xf0,0xe7,0xe3,0x27,
                0xc3,0x9f,0x04,0x7f,0xcd,0x2b,0x83,0xe1,0x5f,0xfc,0x6b,0x77,
                0xe9,0xdb,0xdf,0x87,0x16,0xba,0xed,0xed,0xde,0xb7,0xf0,0xeb,
                0xfe,0x0e,0x06,0xfd,0xa3,0x7e,0x0b,0xfc,0x3e,0xd6,0x2e,0xae,
                0x35,0x5f,0x02,0xfc,0x1d,0xf8,0x73,0xff,0x00,0x05,0x0e,0xf8,
                0x3d,0xf0,0x03,0xe1,0xef,0xc2,0x7f,0x06,0xea,0x12,0xbd,0xdf,
                0x86,0x3e,0x1a,0x78,0x13,0xe0,0x3c,0x9f,0x18,0xbe,0x10,0x49,
                0xf0,0x4f,0xc1,0xbe,0x04,0xd1,0x26,0xb1,0xf0,0xb7,0x86,0x3e,
                0x11,0xc9,0xf0,0x9b,0xe1,0x7b,0xfc,0x37,0xd1,0x34,0xab,0x1f,
                0x06,0xb7,0xc3,0xbf,0x04,0xb6,0x8c,0x7c,0x35,0xa6,0x1f,0x0e,
                0x6f,0x6f,0x35,0xcb,0x7f,0xf8,0x38,0x1f,0xe1,0xd6,0xb7,0x77,
                0x75,0xac,0x7c,0x3e,0xf8,0x2f,0xfb,0x47,0x7f,0xc1,0x43,0xfe,
                0x1c,0xfc,0x1d,0xf0,0x2e,0xab,0x71,0x2e,0xa1,0xe0,0xdf,0x84,
                0xff,0x00,0x0f,0x7f,0x67,0xff,0x00,0x83,0xff,0x00,0x18,0xa4,
                0xf8,0x0f,0xe0,0x4f,0x86,0x9e,0x18,0xbb,0x79,0xb4,0x4f,0x02,
                0x78,0x37,0xe0,0x9c,0x9f,0x08,0x3e,0x13,0x49,0xf0,0x8f,0xc2,
                0xfe,0x16,0xb1,0xd2,0xb4,0x4f,0x86,0xef,0xf0,0xbb,0xe1,0xdb,
                0x78,0x36,0xc7,0x46,0x6f,0x04,0xf8,0x68,0xe9,0x9f,0xc6,0x5f,
                0xc4,0xff,0x00,0x89,0xff,0x00,0x12,0xfc,0x35,0xf1,0x2f,0xe2,
                0x1f,0x87,0x7c,0x39,0xf1,0x0f,0xc7,0x3a,0x07,0x87,0xf4,0x0f,
                0x1c,0xf8,0xb7,0x45,0xd0,0xb4,0x2d,0x17,0xc5,0xba,0xfe,0x95,
                0xa3,0x68,0xba,0x36,0x95,0xaf,0xea,0x16,0x3a,0x5e,0x93,0xa4,
                0xe9,0x76,0x3a,0x84,0x16,0x5a,0x6e,0x99,0xa6,0xd8,0xc1,0x05,
                0x9d,0x85,0x85,0x9c,0x10,0xda,0xd9,0xda,0xc3,0x15,0xbd,0xbc,
                0x51,0xc3,0x1a,0x22,0xfc,0xb6,0x75,0xc4,0x99,0x8f,0x86,0xf9,
                0x9e,0x73,0x97,0xe5,0x98,0xaa,0x98,0xca,0x54,0xf3,0x7c,0xa3,
                0x09,0x56,0x38,0xdc,0xab,0x83,0x31,0xb8,0x6c,0xc3,0xeb,0xfe,
                0x17,0xf8,0x5d,0xc7,0x59,0x66,0x6d,0x8e,0xcb,0x33,0x8e,0x10,
                0xcd,0xf2,0x9c,0x17,0x11,0xe0,0x38,0x6f,0x8e,0xf2,0x3e,0x0b,
                0xcc,0xf3,0x4e,0x13,0xc0,0xf0,0xb6,0x17,0x3e,0xa7,0xc2,0x94,
                0xaa,0x57,0xca,0xf0,0x9c,0x1f,0x80,0xf0,0xc7,0xc3,0xef,0x09,
                0xff,0x00,0x64,0xf0,0xa3,0xc1,0xbe,0x25,0xfa,0x4e,0x55,0xf1,
                0x17,0x1d,0x97,0xf8,0xc1,0xc4,0x5e,0x10,0x78,0x8d,0xe1,0xdf,
                0x17,0x70,0xf7,0x08,0xf1,0xcf,0x1f,0xf0,0xdf,0x00,0x78,0x33,
                0xc6,0xf4,0xfc,0x6a,0xc3,0x66,0x7e,0x1a,0x70,0x3f,0x19,0x70,
                0xcf,0x15,0x71,0x8f,0x04,0x78,0xa7,0xe1,0xdf,0x19,0x70,0x76,
                0x43,0xe2,0x4e,0x53,0xc3,0xfc,0x49,0x95,0xf0,0x8f,0x16,0x71,
                0xc7,0x04,0x65,0x9c,0x3d,0x8a,0xf1,0x02,0x3c,0x37,0x97,0x63,
                0x73,0x0c,0x0e,0x55,0x93,0xe0,0xf8,0x77,0x85,0x78,0x6b,0xff,
            }},
            {VA_FOURCC_422H, {
                0xf8,0x6f,0xf7,0x5f,0xb0,0x2c,0x5f,0xf2,0xc3,0xf6,0xa8,0xff,
                0x00,0x82,0x4e,0x7e,0xd5,0x10,0x7f,0xd4,0x03,0xc4,0x96,0x9e,
                0x15,0xb4,0xf1,0x26,0x81,0xff,0x00,0x72,0xe7,0x83,0xac,0x3c,
                0x5f,0x61,0xe0,0xef,0x0e,0x7f,0xd4,0x91,0xf0,0xe7,0xe3,0x27,
                0xc3,0x9f,0x04,0x7f,0xcd,0x2b,0x83,0xe1,0x5f,0xfc,0x6b,0x77,
                0xe9,0xdb,0xdf,0x87,0x16,0xba,0xed,0xed,0xde,0xb7,0xf0,0xeb,
                0xfe,0x0e,0x06,0xfd,0xa3,0x7e,0x0b,0xfc,0x3e,0xd6,0x2e,0xae,
                0x35,0x5f,0x02,0xfc,0x1d,0xf8,0x73,0xff,0x00,0x05,0x0e,0xf8,
                0x3d,0xf0,0x03,0xe1,0xef,0xc2,0x7f,0x06,0xea,0x12,0xbd,0xdf,
                0x86,0x3e,0x1a,0x78,0x13,0xe0,0x3c,0x9f,0x18,0xbe,0x10,0x49,
                0xf0,0x4f,0xc1,0xbe,0x04,0xd1,0x26,0xb1,0xf0,0xb7,0x86,0x3e,
                0x11,0xc9,0xf0,0x9b,0xe1,0x7b,0xfc,0x37,0xd1,0x34,0xab,0x1f,
                0x06,0xb7,0xc3,0xbf,0x04,0xb6,0x8c,0x7c,0x35,0xa6,0x73,0x70,
                0x9e,0x7d,0x9a,0x70,0xfc,0xf3,0x5c,0xb7,0x3b,0xfa,0x2c,0xfd,
                0x2c,0x7c,0x7b,0xc2,0xe2,0x31,0xb5,0x6a,0x67,0x7e,0x1e,0xfd,
                0x0b,0x7c,0x3f,0xcf,0xbc,0x62,0xe3,0x4f,0x07,0xbc,0x47,0xe1,
                0x7e,0x5f,0x0d,0xf8,0xc1,0xe6,0x59,0x65,0x3c,0x8b,0x88,0x33,
                0x7c,0x67,0x83,0xb9,0xfd,0x3e,0x09,0xca,0xb8,0x33,0x82,0xf8,
                0x9f,0x0d,0xc3,0x58,0x2c,0x06,0x6d,0x9a,0xf8,0x4d,0x8c,0xf1,
                0x83,0x34,0xcc,0x9e,0x27,0xe9,0x23,0x93,0xcf,0x36,0xf2,0x3c,
                0x57,0xe3,0xde,0x28,0xc0,0x61,0x32,0x4f,0xa4,0x8f,0x00,0x7d,
                0x1a,0xb1,0x1e,0x30,0xe4,0x9e,0x3b,0xd6,0xc4,0xe0,0x3c,0x6d,
                0xf0,0x8b,0x2f,0xfa,0x48,0xf8,0x5f,0xf4,0x68,0xcd,0x7c,0x0f,
                0xfa,0x56,0x78,0x61,0x4a,0x87,0x87,0xbe,0x29,0x4f,0x1d,0xc4,
                0xfc,0x4d,0xe1,0xbf,0x8b,0x1c,0x25,0x9f,0xe7,0x1c,0x4f,0x84,
                0xe1,0xac,0xaf,0x84,0xf8,0xbb,0x21,0xc4,0xe2,0x71,0x1c,0x41,
                0xf5,0x9f,0x0a,0xb8,0x77,0x34,0xe1,0xfc,0xc3,0x0f,0x96,0x50,
                0xe2,0x88,0x66,0x87,0xc3,0x9b,0xdb,0xcd,0x72,0xdf,0xfe,0x0e,
                0x07,0xf8,0x75,0xad,0xdd,0xdd,0x6b,0x1f,0x0f,0xbe,0x0b,0xfe,
                0xd1,0xdf,0xf0,0x50,0xff,0x00,0x87,0x3f,0x07,0x7c,0x0b,0xaa,
                0xdc,0x4b,0xa8,0x78,0x37,0xe1,0x3f,0xc3,0xdf,0xd9,0xff,0x00,
                0xe0,0xff,0x00,0xc6,0x29,0x3e,0x03,0xf8,0x13,0xe1,0xa7,0x86,
                0x2e,0xde,0x6d,0x13,0xc0,0x9e,0x0d,0xf8,0x27,0x27,0xc2,0x0f,
                0x84,0xd2,0x7c,0x23,0xf0,0xbf,0x85,0xac,0x74,0xad,0x13,0xe1,
                0xbb,0xfc,0x2e,0xf8,0x76,0xde,0x0d,0xb1,0xd1,0x9b,0xc1,0x3e,
                0x1a,0x3a,0x67,0xf1,0x97,0xf1,0x3f,0xe2,0x7f,0xc4,0xbf,0x0d,
                0x7c,0x4b,0xf8,0x87,0xe1,0xdf,0x0e,0x7c,0x43,0xf1,0xce,0x81,
                0xe1,0xfd,0x03,0xc7,0x3e,0x2d,0xd1,0x74,0x2d,0x0b,0x45,0xf1,
                0x6e,0xbf,0xa5,0x68,0xda,0x2e,0x8d,0xa5,0x6b,0xfa,0x85,0x8e,
                0x97,0xa4,0xe9,0x3a,0x5d,0x8e,0xa1,0x05,0x96,0x9b,0xa6,0x69,
                0xb6,0x30,0x41,0x67,0x61,0x61,0x67,0x04,0x36,0xb6,0x76,0xb0,
                0xc5,0x6f,0x6f,0x14,0x70,0xc6,0x88,0xbc,0x9c,0x6b,0x92,0xe4,
                0xf9,0xa7,0x1c,0x62,0x30,0xd9,0x9e,0x53,0x96,0x66,0x38,0x6c,
                0x56,0x4f,0xc2,0xd9,0xd6,0x2b,0x0f,0x8e,0xc0,0x61,0x71,0x74,
                0x31,0x39,0xc4,0x3c,0x21,0xf0,0x57,0x87,0xe1,0x9b,0x57,0xa5,
                0x88,0xa5,0x52,0x9d,0x6c,0xce,0x19,0x0e,0x4d,0x93,0xe4,0x90,
                0xc7,0xd4,0x8c,0xb1,0x51,0xca,0x32,0xac,0xb7,0x2d,0x55,0x56,
                0x0b,0x03,0x85,0xa3,0x4b,0xf4,0xdf,0x06,0xbc,0x4d,0xf1,0x27,
                0xc3,0x5c,0x6f,0xd2,0xfa,0xa7,0x87,0x3e,0x21,0x71,0xc7,0x00,
                0x54,0xc1,0xf8,0xeb,0xf4,0x65,0xc0,0x61,0x27,0xc1,0x5c,0x59,
                0x9f,0x70,0xac,0xf0,0xb8,0x1e,0x25,0xfa,0x0c,0xf8,0x3f,0xc4,
                0xdc,0x47,0x82,0xc3,0xcb,0x22,0xc7,0xe0,0x25,0x43,0x09,0x9f,
                0xf1,0x25,0x38,0x71,0x06,0x77,0x86,0xa4,0xe3,0x47,0x35,0xcf,
                0x21,0x0c,0xdb,0x1d,0x0a,0xf8,0xf8,0xac,0x42,0xff,
            }},
            {VA_FOURCC_422V, {
                0xf8,0x6f,0xf7,0x5f,0xb0,0x2c,0x5f,0xf2,0xc3,0xf6,0xa8,0xff,
                0x00,0x82,0x4e,0x7e,0xd5,0x10,0x7f,0xd4,0x03,0xc4,0x96,0x9e,
                0x15,0xb4,0xf1,0x26,0x81,0xff,0x00,0x72,0xe7,0x83,0xac,0x3c,
                0x5f,0x61,0xe0,0xef,0x0e,0x7f,0xd4,0x91,0xf0,0xe7,0xe3,0x27,
                0xc3,0x9f,0x04,0x7f,0xcd,0x2b,0x83,0xe1,0x5f,0xfc,0x6b,0x77,
                0xe9,0xdf,0x87,0x37,0xb7,0x9a,0xe5,0xbf,0xfc,0x1c,0x0f,0xf0,
                0xeb,0x5b,0xbb,0xba,0xd6,0x3e,0x1f,0x7c,0x17,0xfd,0xa3,0xbf,
                0xe0,0xa1,0xff,0x00,0x0e,0x7e,0x0e,0xf8,0x17,0x55,0xb8,0x97,
                0x50,0xf0,0x6f,0xc2,0x7f,0x87,0xbf,0xb3,0xff,0x00,0xc1,0xff,
                0x00,0x8c,0x52,0x7c,0x07,0xf0,0x27,0xc3,0x4f,0x0c,0x5d,0xbc,
                0xda,0x27,0x81,0x3c,0x1b,0xf0,0x4e,0x4f,0x84,0x1f,0x09,0xa4,
                0xf8,0x47,0xe1,0x7f,0x0b,0x58,0xe9,0x5a,0x27,0xc3,0x77,0xf8,
                0x5d,0xf0,0xed,0xbc,0x1b,0x63,0xa3,0x37,0x82,0x7c,0x34,0x74,
                0xce,0x0e,0x29,0xe1,0xcf,0xf5,0x4f,0x8a,0xbe,0x8b,0xf3,0xc1,
                0x66,0x99,0x86,0x2b,0xfe,0x23,0xaf,0x1e,0x71,0xb7,0x86,0x1e,
                0x1f,0xe7,0xde,0xd3,0xfd,0x59,0xf1,0x03,0xc1,0xff,0x00,0xf5,
                0x7b,0x28,0xcd,0xf8,0xdf,0x88,0x17,0xfa,0xe7,0xe1,0xcb,0xe0,
                0x6f,0xf5,0x83,0x81,0x33,0xff,0x00,0xec,0x4c,0x06,0x59,0xff,
                0x00,0x10,0xfb,0x83,0x72,0x6f,0x09,0x7f,0xd6,0x29,0x52,0xfa,
                0xf7,0x8e,0xbc,0x4f,0xe3,0xc7,0xb6,0xc6,0x60,0xf1,0x77,0x98,
                0x71,0xef,0xfa,0xc9,0xe3,0x27,0xd1,0xcf,0xe8,0xfb,0xe3,0xee,
                0x53,0x1f,0x1b,0xff,0x00,0xe2,0x2c,0xf0,0xbf,0x1b,0xf1,0x3f,
                0x84,0xde,0x3c,0x7d,0x77,0xfe,0x21,0x5f,0xd2,0x63,0xc1,0x0f,
                0xf5,0x37,0x39,0xc9,0xfc,0x30,0x55,0xbf,0xe2,0x2c,0xf8,0x6b,
                0x84,0xc9,0x3f,0xd6,0x9e,0x28,0xcc,0x7f,0xd6,0x2c,0xfb,0x3a,
                0xff,0x00,0x5a,0x38,0x57,0x87,0x7c,0x28,0xfa,0xac,0x33,0x0f,
                0xec,0xaa,0x99,0x46,0x37,0x92,0xb6,0x63,0x89,0x2f,0x7e,0x1c,
                0x5a,0xeb,0xb7,0xb7,0x7a,0xdf,0xc3,0xaf,0xf8,0x38,0x1b,0xf6,
                0x8d,0xf8,0x2f,0xf0,0xfb,0x58,0xba,0xb8,0xd5,0x7c,0x0b,0xf0,
                0x77,0xe1,0xcf,0xfc,0x14,0x3b,0xe0,0xf7,0xc0,0x0f,0x87,0xbf,
                0x09,0xfc,0x1b,0xa8,0x4a,0xf7,0x7e,0x18,0xf8,0x69,0xe0,0x4f,
                0x80,0xf2,0x7c,0x62,0xf8,0x41,0x27,0xc1,0x3f,0x06,0xf8,0x13,
                0x44,0x9a,0xc7,0xc2,0xde,0x18,0xf8,0x47,0x27,0xc2,0x6f,0x85,
                0xef,0xf0,0xdf,0x44,0xd2,0xac,0x7c,0x1a,0xdf,0x0e,0xfc,0x12,
                0xda,0x31,0xf0,0xd6,0x99,0xfc,0x65,0xfc,0x4f,0xf8,0x9f,0xf1,
                0x2f,0xc3,0x5f,0x12,0xfe,0x21,0xf8,0x77,0xc3,0x9f,0x10,0xfc,
                0x73,0xa0,0x78,0x7f,0x40,0xf1,0xcf,0x8b,0x74,0x5d,0x0b,0x42,
                0xd1,0x7c,0x5b,0xaf,0xe9,0x5a,0x36,0x8b,0xa3,0x69,0x5a,0xfe,
                0xa1,0x63,0xa5,0xe9,0x3a,0x4e,0x97,0x63,0xa8,0x41,0x65,0xa6,
                0xe9,0x9a,0x6d,0x8c,0x10,0x59,0xd8,0x58,0x59,0xc1,0x0d,0xad,
                0x9d,0xac,0x31,0x5b,0xdb,0xc5,0x1c,0x31,0xa2,0x2f,0xc6,0xd3,
                0xf1,0xab,0x88,0xa9,0x53,0x85,0x26,0xb0,0xd8,0xe7,0x4a,0x11,
                0xa6,0xf1,0xb9,0x97,0x08,0x78,0x32,0xb3,0x1c,0x63,0x84,0x54,
                0x7e,0xb5,0x98,0x2c,0x8f,0xc2,0x1c,0x83,0x24,0x58,0xdc,0x45,
                0xbd,0xae,0x29,0x64,0xf9,0x16,0x4b,0x95,0x2a,0xf3,0xa9,0xfd,
                0x9f,0x94,0xe5,0xd8,0x4f,0x63,0x83,0xa3,0xfd,0x8b,0x8b,0xfd,
                0x9f,0x3e,0x25,0x7d,0x6f,0x15,0xfd,0x8d,0xf4,0xd5,0xf1,0x17,
                0x29,0xc9,0xfe,0xb1,0x5b,0xfb,0x2b,0x2a,0xaf,0xf4,0x74,0xfa,
                0x1a,0x67,0xd5,0xf2,0xcc,0xb7,0xda,0x4b,0xea,0x39,0x7d,0x6c,
                0xf3,0x3a,0xf0,0x0b,0x17,0x9c,0xe7,0x35,0x70,0x58,0x5f,0x65,
                0x86,0xa9,0x9a,0xe6,0xd8,0xbc,0x56,0x67,0x98,0xce,0x9b,0xc6,
                0x63,0xf1,0x15,0xb1,0x55,0xaa,0xd4,0x97,0xff,
            }},
            {VA_FOURCC_411P, {
                0xf8,0x6f,0xf7,0x5f,0xb0,0x2c,0x5f,0xf2,0xc3,0xf6,0xa8,0xff,
                0x00,0x82,0x4e,0x7e,0xd5,0x10,0x7f,0xd4,0x03,0xc4,0x96,0x9e,
                0x15,0xb4,0xf1,0x26,0x81,0xff,0x00,0x72,0xe7,0x83,0xac,0x3c,
                0x5f,0x61,0xe0,0xef,0x0e,0x7f,0xd4,0x91,0xf0,0xe7,0xe3,0x27,
                0xc3,0x9f,0x04,0x7f,0xcd,0x2b,0x83,0xe1,0x5f,0xfc,0x6b,0x77,
                0xe9,0xdb,0xdf,0x87,0x16,0xba,0xed,0xed,0xde,0xb7,0xf0,0xeb,
                0xfe,0x0e,0x06,0xfd,0xa3,0x7e,0x0b,0xfc,0x3e,0xd6,0x2e,0xae,
                0x35,0x5f,0x02,0xfc,0x1d,0xf8,0x73,0xff,0x00,0x05,0x0e,0xf8,
                0x3d,0xf0,0x03,0xe1,0xf7,0xc2,0x7f,0x07,0x6a,0x12,0xbd,0xdf,
                0x86,0x3e,0x1a,0x78,0x13,0xe0,0x3c,0x9f,0x18,0xbe,0x10,0x49,
                0xf0,0x4f,0xc1,0xbe,0x04,0xd1,0x26,0xb1,0xf0,0xb7,0x86,0x3e,
                0x11,0xc9,0xf0,0x9b,0xe1,0x7b,0xfc,0x37,0xd1,0x34,0xab,0x1f,
                0x06,0xb7,0xc3,0xbf,0x04,0xb6,0x8c,0x7c,0x35,0xa6,0x14,0x57,
                0xa3,0xc3,0xfc,0x53,0x1c,0x0e,0x55,0x86,0xc2,0xe7,0x7f,0x40,
                0x6f,0xda,0x85,0xe3,0x4e,0x3e,0x0e,0xbd,0x59,0xf8,0x8b,0xf4,
                0x50,0xfa,0x3c,0x71,0x67,0x8a,0x3e,0x0b,0xe6,0xd4,0xf1,0x98,
                0x8a,0xb8,0xea,0x59,0x5e,0x45,0xc4,0x58,0x2e,0x01,0xe2,0x4f,
                0xab,0x66,0x9c,0x23,0x1c,0x4f,0xfa,0x9d,0xc4,0x19,0x26,0x2b,
                0x1d,0x87,0xc4,0xe5,0xb9,0xb6,0x41,0x89,0x4b,0x2d,0xc0,0xe1,
                0x6b,0x61,0xa8,0xaf,0xcc,0xfc,0x42,0xf1,0xaf,0x8d,0xf8,0x43,
                0x8a,0xf3,0x0a,0x79,0x37,0xd0,0x7b,0x3a,0xf1,0x7b,0x22,0xe2,
                0xea,0x78,0x1f,0x14,0x32,0x6e,0x38,0xcb,0x7e,0x9f,0x1e,0x02,
                0x78,0x07,0x4f,0x11,0x85,0xf1,0x63,0x05,0x43,0xc4,0x7c,0x57,
                0x0e,0xd7,0xf0,0xdb,0x8b,0xfc,0x03,0xf1,0x03,0x1f,0x96,0x62,
                0x38,0x17,0x37,0xe2,0x7c,0xcb,0x81,0xbe,0xbd,0x83,0xe2,0x9c,
                0xcb,0x2e,0xcd,0x68,0x70,0xe5,0x0c,0x6c,0x2a,0xcf,0x1b,0x53,
                0x1d,0x56,0xaa,0xfc,0x39,0xbd,0xbc,0xd7,0x2d,0xbf,0xe0,0xe0,
                0x7f,0x87,0x5a,0xdd,0xdd,0xd6,0xb1,0xf0,0xfb,0xe0,0xbf,0xed,
                0x1d,0xff,0x00,0x05,0x0f,0xf8,0x73,0xf0,0x77,0xc0,0xba,0xa4,
                0xf2,0xea,0x1e,0x0d,0xf8,0x4f,0xf0,0xf7,0xe0,0x07,0xc1,0xff,
                0x00,0x8c,0x52,0x7c,0x07,0xf0,0x27,0xc3,0x4f,0x0c,0x5d,0xbc,
                0xda,0x27,0x81,0x3c,0x1b,0xf0,0x4e,0x4f,0x84,0x1f,0x09,0x9f,
                0xe1,0x1f,0x86,0x3c,0x2d,0x63,0xa5,0x68,0x9f,0x0d,0xdf,0xe1,
                0x7f,0xc3,0xb6,0xf0,0x6d,0x8e,0x8c,0xde,0x09,0xf0,0xd1,0xd3,
                0x3f,0x8c,0xaf,0x89,0xff,0x00,0x13,0xfe,0x25,0x78,0x6b,0xe2,
                0x57,0xc4,0x3f,0x0e,0xf8,0x77,0xe2,0x1f,0x8e,0x74,0x0f,0x0f,
                0xe8,0x1e,0x39,0xf1,0x6e,0x8b,0xa1,0x68,0x5a,0x2f,0x8b,0x75,
                0xfd,0x2b,0x46,0xd1,0x74,0x6d,0x2b,0x5f,0xd4,0x2c,0x74,0xbd,
                0x27,0x49,0xd2,0xec,0x75,0x08,0x2c,0xb4,0xdd,0x33,0x4d,0xb2,
                0x82,0x0b,0x3b,0x0b,0x0b,0x38,0x21,0xb5,0xb3,0xb5,0x86,0x2b,
                0x7b,0x78,0xa3,0x86,0x34,0x40,0x51,0x5f,0x1f,0x9b,0xf0,0xa7,
                0x0b,0xe6,0x9c,0x4b,0xc5,0xd8,0xcc,0xcf,0x86,0xf2,0x0c,0xc7,
                0x17,0x57,0x8a,0xf3,0xe9,0x54,0xc5,0x63,0xf2,0x7c,0xbb,0x17,
                0x89,0xa9,0x29,0xe3,0xaa,0x55,0x9c,0xa7,0x5f,0x11,0x86,0xa9,
                0x56,0x6e,0x75,0x6a,0x54,0xa9,0x27,0x29,0x37,0x2a,0x95,0x27,
                0x37,0x79,0x4a,0x4d,0xff,0x00,0x53,0xf0,0x6f,0x8f,0xfe,0x3b,
                0xf0,0x1f,0x0b,0xd1,0xe1,0xbe,0x07,0xf1,0xaf,0xc5,0xbe,0x0c,
                0xe1,0xdc,0x0f,0x19,0x78,0xd3,0x47,0x05,0x90,0xf0,0xa7,0x89,
                0x1c,0x63,0xc3,0xb9,0x2e,0x0e,0x96,0x17,0xc7,0xbf,0x14,0xf0,
                0x18,0x6a,0x58,0x5c,0xaf,0x28,0xce,0x70,0x78,0x1c,0x3d,0x3c,
                0x3e,0x07,0x07,0x84,0xc1,0x50,0x85,0x2a,0x10,0x8d,0x2c,0x26,
                0x17,0x0d,0x86,0xa6,0xa3,0x46,0x85,0x28,0x47,0xff,
            }},
            {VA_FOURCC_444P, {
                0xf8,0x6f,0xf7,0x5f,0xb0,0x2c,0x5f,0xf2,0xc3,0xf6,0xa8,0xff,
                0x00,0x82,0x4e,0x7e,0xd5,0x10,0x7f,0xd4,0x03,0xc4,0x96,0x9e,
                0x15,0xb4,0xf1,0x26,0x81,0xff,0x00,0x72,0xe7,0x83,0xac,0x3c,
                0x5f,0x61,0xe0,0xef,0x0e,0x7f,0xd4,0x91,0xf0,0xe7,0xe3,0x27,
                0xc3,0x9f,0x04,0x7f,0xcd,0x2b,0x83,0xe1,0x5f,0xfc,0x6b,0x77,
                0xe2,0x3f,0xe3,0x32,0xcb,0x38,0xcb,0xfe,0x69,0xff,0x00,0x02,
                0x7e,0x93,0xfe,0x04,0xf0,0xff,0x00,0xfd,0x54,0xbe,0x25,0x78,
                0x5f,0x97,0x78,0x5f,0xe2,0x57,0x12,0xff,0x00,0xdd,0xd5,0xc6,
                0xbf,0x49,0xaf,0xd9,0x45,0xf4,0x9a,0xe3,0x5e,0x29,0xff,0x00,
                0xaa,0xef,0xc7,0x2f,0xa2,0x17,0x8e,0x5c,0x77,0xff,0x00,0x35,
                0x6f,0x8e,0x9c,0x5b,0xff,0x00,0x1f,0x61,0xfd,0x13,0xfe,0x10,
                0x3e,0x9f,0xf9,0x07,0xfc,0xbe,0xfa,0x26,0x7e,0xd2,0x2f,0xa2,
                0x65,0x6f,0xfa,0xa0,0x56,0x6f,0xc0,0xf9,0xba,0xe0,0x1f,0xfc,
                0x54,0x3e,0x23,0x78,0x07,0xe2,0x37,0x84,0x3f,0xf6,0x1f,0xf4,
                0x65,0xf1,0x6f,0xe8,0xcb,0x8f,0xeb,0xf4,0x29,0x7f,0xf1,0xec,
                0x9f,0xa7,0x6f,0x7e,0x1c,0xdb,0x6b,0x97,0x97,0x7a,0xdf,0xc3,
                0xaf,0xf8,0x38,0x1f,0xf6,0x8e,0xf8,0x2f,0xf0,0xfb,0x58,0xba,
                0xb8,0xd5,0x7c,0x0b,0xf0,0x77,0xe1,0xcf,0xfc,0x14,0x3f,0xe0,
                0xff,0x00,0xec,0xff,0x00,0xf0,0xf7,0xe1,0x3f,0x83,0x75,0x09,
                0x5e,0xef,0xc3,0x1f,0x0d,0x3c,0x09,0xf0,0x1e,0x4f,0x8c,0x5f,
                0x08,0x24,0xf8,0x27,0xe0,0xdf,0x02,0x68,0x93,0x58,0xf8,0x5b,
                0xc3,0x1f,0x08,0xe4,0xf8,0x4d,0xf0,0xbd,0xfe,0x1b,0xe8,0x9a,
                0x55,0x8f,0x83,0x5b,0xe1,0xdf,0x82,0x5b,0x46,0x3e,0x1a,0xd3,
                0x3f,0x5c,0xa1,0xc7,0x78,0x5c,0x55,0x0a,0x38,0xac,0xd3,0xf6,
                0x5a,0xfe,0xd8,0x3a,0x99,0x9e,0x26,0x95,0x3c,0x46,0x63,0x53,
                0xc1,0x1f,0xa3,0xfe,0x6d,0xe3,0x67,0x83,0x15,0x31,0xd5,0xa1,
                0x1a,0x98,0xb9,0xf8,0x45,0xe3,0x37,0x07,0x70,0x27,0x18,0x70,
                0x8f,0x8b,0x9e,0x18,0x4f,0x11,0x2a,0x92,0xe0,0x1f,0x13,0xb8,
                0x57,0x8b,0xb8,0xa7,0x87,0x38,0xf7,0x85,0x1e,0x53,0xc5,0x59,
                0x1f,0x11,0xe7,0x79,0x66,0x6d,0x85,0xcc,0xf1,0x5f,0xc9,0x79,
                0xb7,0x8f,0x7e,0x37,0x70,0xae,0x6b,0x99,0xf0,0xbf,0x1c,0x7e,
                0xcd,0x6c,0x66,0x23,0x8d,0x78,0x6f,0x30,0xc6,0xe4,0x3c,0x61,
                0x5f,0x84,0xbf,0x69,0x1f,0x83,0xbe,0x15,0xf0,0xad,0x7e,0x28,
                0xc9,0xf1,0x35,0x32,0xfe,0x20,0xad,0xc3,0x3e,0x18,0x78,0xc3,
                0xf4,0x6d,0xe2,0xdf,0x16,0xfc,0x38,0xe1,0xfa,0x99,0xb6,0x1f,
                0x17,0x3c,0x9b,0x80,0xfc,0x52,0xe2,0xae,0x26,0xf1,0x1b,0x84,
                0x32,0xd9,0x61,0xb8,0x7b,0x8d,0xf8,0x83,0x39,0xe2,0x6c,0xbb,
                0x33,0xcc,0x71,0x27,0xc3,0x9b,0xdb,0xcd,0x72,0xdf,0xfe,0x0e,
                0x07,0xf8,0x75,0xad,0xdd,0xdd,0x6b,0x1f,0x0f,0xbe,0x0b,0xfe,
                0xd1,0xdf,0xf0,0x50,0xff,0x00,0x87,0x3f,0x07,0x7c,0x0b,0xaa,
                0xdc,0x4b,0xa8,0x78,0x37,0xe1,0x3f,0xc3,0xdf,0xd9,0xff,0x00,
                0xe0,0xff,0x00,0xc6,0x29,0x3e,0x03,0xf8,0x13,0xe1,0xa7,0x86,
                0x2e,0xde,0x6d,0x13,0xc0,0x9e,0x0d,0xf8,0x27,0x27,0xc2,0x0f,
                0x84,0xd2,0x7c,0x23,0xf0,0xbf,0x85,0xac,0x74,0xad,0x13,0xe1,
                0xbb,0xfc,0x2e,0xf8,0x76,0xde,0x0d,0xb1,0xd1,0x9b,0xc1,0x3e,
                0x1a,0x3a,0x61,0xc7,0x78,0x7a,0x18,0xbc,0x2f,0xec,0xb5,0xcd,
                0x31,0x54,0x69,0x62,0x73,0x3a,0x9f,0xb6,0x0f,0xe8,0xff,0x00,
                0xe0,0x8d,0x4c,0xc7,0x11,0x4e,0x15,0xb1,0xd5,0x3c,0x18,0xf1,
                0xb3,0x36,0xe0,0x4e,0x0e,0xf1,0x9b,0xc2,0x29,0xe2,0xea,0x46,
                0x58,0x89,0xf8,0x61,0xe2,0xe7,0x08,0xf1,0x87,0x17,0x70,0xaf,
                0x89,0xdc,0x03,0x2a,0x8f,0x85,0x38,0xf7,0x87,0x38,0xa7,0x88,
                0xf2,0x3e,0x2a,0xca,0x73,0x6c,0xb3,0x3b,0xcc,0xf0,0xb8,0xa3,
                0xc7,0xbc,0xdb,0x35,0xe1,0x5f,0x1b,0xbf,0x66,0xb7,0x1c,0x70,
                0xbe,0x67,0x98,0x70,0xdf,0x1a,0xe2,0x31,0x9f,0xb4,0x8f,0x84,
                0xab,0xf1,0x86,0x43,0x8d,0xc4,0xe4,0xfc,0x51,0x5f,0x85,0x7c,
                0x2b,0xf0,0x77,0xe8,0xdb,0xe3,0x0f,0x86,0x1c,0x33,0x5b,0x88,
                0x32,0xfa,0x98,0x7c,0xda,0xa7,0x0f,0xf8,0x71,0xe2,0xdf,0x16,
                0xf1,0x57,0x8a,0x5c,0x07,0x92,0xcf,0x17,0x2c,0xb7,0x84,0x3c,
                0x46,0xe2,0x6e,0x20,0xe3,0x7e,0x1e,0xc3,0x65,0xdc,0x4d,0x9c,
                0xe6,0x39,0x9e,0x27,0xf8,0xcb,0xf8,0x9f,0xf1,0x3f,0xe2,0x5f,
                0x86,0xbe,0x25,0xfc,0x43,0xf0,0xef,0x87,0x3e,0x21,0xf8,0xe7,
                0x40,0xf0,0xfe,0x81,0xe3,0x9f,0x16,0xe8,0xba,0x16,0x85,0xa2,
                0xf8,0xb7,0x5f,0xd2,0xb4,0x6d,0x17,0x46,0xd2,0xb5,0xfd,0x42,
                0xc7,0x4b,0xd2,0x74,0x9d,0x2e,0xc7,0x50,0x82,0xcb,0x4d,0xd3,
                0x34,0xdb,0x18,0x20,0xb3,0xb0,0xb0,0xb3,0x82,0x1b,0x5b,0x3b,
                0x58,0x62,0xb7,0xb7,0x8a,0x38,0x63,0x44,0x5f,0xc3,0xf8,0x4b,
                0x84,0xb8,0x57,0x35,0xe1,0x5e,0x19,0xcd,0x33,0x4e,0x19,0xe1,
                0xfc,0xcb,0x32,0xcc,0xb8,0x7f,0x26,0xc7,0xe6,0x39,0x8e,0x3f,
                0x26,0xcb,0x71,0x98,0xec,0x7e,0x3b,0x19,0x97,0x61,0xb1,0x18,
                0xbc,0x6e,0x37,0x17,0x88,0xc3,0x54,0xc4,0x62,0xb1,0x78,0xac,
                0x45,0x4a,0x95,0xf1,0x38,0x9a,0xf5,0x2a,0x56,0xaf,0x5a,0xa4,
                0xea,0xd5,0x9c,0xa7,0x29,0x49,0xff,0x00,0xa9,0xdf,0x48,0x4f,
                0xa4,0x27,0x8f,0xbc,0x05,0xe3,0xef,0x8e,0x1c,0x0b,0xc0,0xbe,
                0x38,0x78,0xbf,0xc1,0x7c,0x13,0xc1,0x7e,0x2f,0xf8,0x97,0xc2,
                0x7c,0x1d,0xc1,0xdc,0x27,0xe2,0x5f,0x1a,0x70,0xe7,0x0a,0xf0,
                0x9f,0x0a,0xf0,0xe7,0x1a,0x67,0x59,0x3f,0x0f,0x70,0xd7,0x0d,
                0x70,0xf6,0x4f,0x9d,0x60,0xf2,0x8c,0x8b,0x87,0xf2,0x2c,0xa3,
                0x07,0x84,0xca,0xf2,0x6c,0x9b,0x2b,0xc1,0xe1,0x72,0xec,0xaf,
                0x2e,0xc2,0xe1,0xb0,0x38,0x1c,0x35,0x0c,0x35,0x0a,0x54,0xa3,
                0xff,
            }}
        });

    /**
     * Test Pattern 4
     *
     * Solid Blue 150x75
     *
     */
    template<> const bool TestPatternData<4>::m_valid =
        TestPatternData<4>::initialize<150, 75>(

            generateSolid({0x1d, 0xff, 0x6b}, {150, 75}),

            {{VA_FOURCC_IMC3, {
                0xfe,0x39,0xe8,0xa2,0x8a,0xff,0x00,0xbf,0x83,0xf9,0x5c,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0xff,
            }},
            {VA_FOURCC_422H, {
                0xfe,0x39,0xe8,0xaf,0xfb,0xf8,0x3f,0x95,0xc2,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0xff,
            }},
            {VA_FOURCC_422V, {
                0xfe,0x39,0xe8,0xaf,0xfb,0xf8,0x3f,0x95,0xc2,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,
                0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,
                0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,
                0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,
                0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,0x00,0x28,0xa0,0x02,0x8a,
                0x00,0x28,0xa0,0x0f,0xff,
            }},
            {VA_FOURCC_411P, {
                0xfe,0x39,0xe8,0xa2,0x8a,0xff,0x00,0xbf,0x83,0xf9,0x5c,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,0xa2,0x8a,0x00,0x28,
                0xa2,0x8a,0x00,0xff,
            }},
            {VA_FOURCC_444P, {
                0xfe,0x39,0xeb,0xfe,0xfe,0x0f,0xe5,0x70,0xa0,0x02,0x80,0x0a,
                0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,
                0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,
                0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,
                0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,
                0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,
                0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,
                0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,
                0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,
                0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,
                0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,
                0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,
                0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,
                0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,
                0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,
                0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,
                0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,
                0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,
                0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,
                0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,
                0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,
                0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,
                0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,
                0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,
                0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,
                0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,
                0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,
                0x02,0x80,0x0a,0x00,0x28,0x00,0xa0,0x02,0x80,0x0a,0x00,0x28,
                0x00,0xa0,0x0f,0xff,
            }}
        });

} // namespace Decode
} // namespace JPEG

namespace JPEG {
namespace Encode {

    TestInput::Shared TestInput::create(
        const unsigned fourcc, const unsigned w, const unsigned h)
    {
        Shared t(new TestInput);

        t->image = YUVImage::create(fourcc, w, h);

        if (not bool(t->image.get()))
            return Shared();

        t->picture.picture_width = t->image->width;
        t->picture.picture_height = t->image->height;

        if (VA_FOURCC_Y800 == fourcc)
            t->picture.num_components = 1;

        return t;
    }

    TestInput::TestInput()
        : image()
        , picture(defaultPictureParameter)
        , matrix(defaultIQMatrix)
        , huffman(defaultHuffmanTable)
        , slice(defaultSliceParameter)
    {
        return;
    }

    const YUVImage::SharedConst TestInput::toExpectedOutput() const
    {
        YUVImage::Shared result;

        switch (image->fourcc) {
        case VA_FOURCC_Y800:
            return image;
        case VA_FOURCC_I420:
        case VA_FOURCC_NV12:
            result = YUVImage::create(VA_FOURCC_IMC3, image->width, image->height);
            break;
        case VA_FOURCC_UYVY:
        case VA_FOURCC_YUY2:
            result = YUVImage::create(VA_FOURCC_422H, image->width, image->height);
            break;
        default:
            break;
        }

        if (bool(result)) {
            result->y() = image->y();
            result->u() = image->u();
            result->v() = image->v();
        }

        return result;
    }

    ::std::ostream& operator<<(::std::ostream& os, const TestInput& t)
    {
        return os
            << std::string((char*)(&t.image->fourcc), 4)
            << " " << t.image->width << "x" << t.image->height
            << " " << t.image->widths << " " << t.image->heights
            << " " << t.image->sizes << " " << t.image->offsets
        ;
    }

    ::std::ostream& operator<<(::std::ostream& os, const TestInput::Shared& t)
    {
        return os << *t;
    }

    ::std::ostream& operator<<(
        ::std::ostream& os, const TestInput::SharedConst& t)
    {
        return os << *t;
    }

    TestInput::Shared TestInputCreator::create(const unsigned fourcc) const
    {
        const std::array<unsigned, 2> res = getResolution();

        TestInput::Shared input(TestInput::create(fourcc, res[0], res[1]));
        if (input.get()) {
            std::generate_n(
                std::begin(input->image->bytes), input->image->bytes.size(),
                RandomValueGenerator<uint8_t>(0x00, 0xff));
        }
        return input;
    }

    ::std::ostream& operator<<(::std::ostream& os, const TestInputCreator& t)
    {
        t.repr(os);
        return os;
    }

    ::std::ostream& operator<<(
        ::std::ostream& os, const TestInputCreator::Shared& t)
    {
        return os << *t;
    }

    ::std::ostream& operator<<(
        ::std::ostream& os, const TestInputCreator::SharedConst& t)
    {
        return os << *t;
    }

    std::array<unsigned, 2> RandomSizeCreator::getResolution() const
    {
        static RandomValueGenerator<unsigned> rg(1, 769);
        return {rg(), rg()};
    }

    void RandomSizeCreator::repr(::std::ostream& os) const
    {
        os << "Random Size";
    }

    FixedSizeCreator::FixedSizeCreator(
        const std::array<unsigned, 2>& resolution)
        : res(resolution)
    {
        return;
    }

    std::array<unsigned, 2> FixedSizeCreator::getResolution() const
    {
        return res;
    }

    void FixedSizeCreator::repr(::std::ostream& os) const
    {
        os << "Fixed Size " << res[0] << "x" << res[1];
    }

} // namespace Encode
} // namespace JPEG
