#include "netbuffer"

bool Netbuffer::insertat(unsigned index, char const *s, unsigned len) {
    PROFILE("Netbuffer::insertat");

    if (!len)
	len = strlen(s);

    if (config.debug()) {
	string pr;
	for (unsigned int i = 0; i < len; i++)
	    pr += printable(s[i]);
	debugmsg("Netbuffer: inserting " << pr << " at " << index << '\n');
    }
    
    if (index >= buf_sz)
	return false;
    check_space(len);
    memmove (buf_data + index + len, buf_data + index, buf_sz - index);
    memcpy (buf_data + index, s, len);
    buf_sz += len;
    
    return true;
}
    
