;
; $Id: sibsx.s,v 1.1.1.1 1996/02/15 17:47:47 mclareni Exp $
;
; $Log: sibsx.s,v $
; Revision 1.1.1.1  1996/02/15 17:47:47  mclareni
; Kernlib
;
;
        .TITLE  SIBSX
;
; CERN PROGLIB# M231    CVTIB
; ORIG.  HYDRA FQT PACKAGE ROUTINE FQTICD
; EXTRACTED AND NAME CHANGED BY H.RENSHALL/DD, 1984-05-11
; AND THEN PARTLY REWRITTEN TO ACCOUNT FOR IBM LARGER FLOAT RANGE
; AND EXACT ZERO CONVERTION BY F.CARMINATI/DD, 1985-02-18
;
;      SUBROUTINE SIBSX (A,NWORDS)
;
; CONVERTS THE FIRST NWORDS OF VECTOR A FROM IBM FLOATING POINT
; NUMBER FORMAT TO VAX FLOATING POINT FORMAT
;
        .PSECT  $CODE,PIC,CON,REL,LCL,SHR,EXE,RD,NOWRT,LONG
;SIBSX::
        .ENTRY  SIBSX,^M<R8,R9,R10,R11>
        MOVAL   @4(AP),R11      ;GET ADRESS OF VECTOR
        MOVL    @8(AP), R9      ;LOAD COUNT
        TSTL    R9              ;COMPARE 0 WITH THE COUNT
        BGTR    L$IAMD          ;LOOP COUNT GT 0
        RET                     ;LOOP COUNT LE 0
  L$IAMD:
;---
        MOVL    (R11)+,R0       ;FIELD SHIFTED ALREADY.
        TSTL    R0              ;TEST IF EXACT ZERO
        BEQL    LOOPG            ;SKIP CONVERTION
        EXTZV   #0,#24,R0,R1    ;EXTRACT MANTISSA
        EXTZV   #24,#7,R0,R8    ;EXTRACT EXPONENT (POWERS OF 64)
        SUBL2   #64,R8          ;TAKE AWAY EXCESS
        ASHL    #2,R8,R8        ;NOW POWERS OF TWO
        CVTLF   R1,R10          ;MANTISSA TO VAX STANDARDS
        EXTZV   #7,#5,R10,R1    ;GET NORMALISATION SHIFT
        ADDL2   R1,R8           ;NEW EXPONENT
        CMPL    R8,#-104        ;SEE IF TOO LITTLE
        BGTR    GRTR            ;NOT TOO LITTLE
        MOVL    #^X00000080,R10       ;JUST THE SMALLEST FLOAT
        BRB     INSIG           ;NOW THE SIGN
 GRTR:  CMPL    R8,#151         ;SEE IF TOO BIG
        BLEQ    LSTN            ;NOT TOO BIG
        MOVL    #^XFFFF7FFF,R10         ;JUST THE BIGGEST FLOAT
        BRB     INSIG           ;NOW THE SIGN
 LSTN:  ADDL2   #^X68,R8        ;ADJUST AND ADD EXCESS 128
        INSV    R8,#7,#8,R10    ;PACK EXPONENT AND MANTISSA
INSIG:  BBC     #31,R0,FIN      ;WAS INPUT NEGATIVE?
        BISL2   #^X00008000,R10        ;YES
  FIN:  MOVL    R10, -4(R11)
LOOPG:  SOBGTR  R9, L$IAMD      ;LOOP
        RET
        .END
