//
// os/winapi/keycodes.h: WinAPI keycode definitions.
//
// CEN64: Cycle-Accurate Nintendo 64 Emulator.
// Copyright (C) 2015, Tyler J. Stachecki.
//
// This file is subject to the terms and conditions defined in
// 'LICENSE', which is part of this source code package.
//

#ifndef CEN64_OS_WINAPI_KEYCODES
#define CEN64_OS_WINAPI_KEYCODES
#include <windows.h>

// Letter keys.
#define CEN64_KEY_A 0x41
#define CEN64_KEY_B 0x42
#define CEN64_KEY_C 0x43
#define CEN64_KEY_D 0x44
#define CEN64_KEY_E 0x45
#define CEN64_KEY_F 0x46
#define CEN64_KEY_G 0x47
#define CEN64_KEY_H 0x48
#define CEN64_KEY_I 0x49
#define CEN64_KEY_J 0x4A
#define CEN64_KEY_K 0x4B
#define CEN64_KEY_L 0x4C
#define CEN64_KEY_M 0x4D
#define CEN64_KEY_N 0x4E
#define CEN64_KEY_O 0x4F
#define CEN64_KEY_P 0x50
#define CEN64_KEY_Q 0x51
#define CEN64_KEY_R 0x52
#define CEN64_KEY_S 0x53
#define CEN64_KEY_T 0x54
#define CEN64_KEY_U 0x55
#define CEN64_KEY_V 0x56
#define CEN64_KEY_W 0x57
#define CEN64_KEY_X 0x58
#define CEN64_KEY_Y 0x59
#define CEN64_KEY_Z 0x5A

// Number keys.
#define CEN64_KEY_0 0x30
#define CEN64_KEY_1 0x31
#define CEN64_KEY_2 0x32
#define CEN64_KEY_3 0x33
#define CEN64_KEY_4 0x34
#define CEN64_KEY_5 0x35
#define CEN64_KEY_6 0x36
#define CEN64_KEY_7 0x37
#define CEN64_KEY_8 0x38
#define CEN64_KEY_9 0x39

// Directional keys.
#define CEN64_KEY_LEFT VK_LEFT
#define CEN64_KEY_UP VK_UP
#define CEN64_KEY_RIGHT VK_RIGHT
#define CEN64_KEY_DOWN VK_DOWN

// Other keys.
#define CEN64_KEY_BSLASH VK_OEM_5
#define CEN64_KEY_COMMA VK_OEM_COMMA
#define CEN64_KEY_EQUALS VK_OEM_PLUS
#define CEN64_KEY_FSLASH VK_OEM_2
#define CEN64_KEY_MINUS VK_OEM_MINUS
#define CEN64_KEY_LALT VK_LMENU
#define CEN64_KEY_LBRACKET VK_OEM_4
#define CEN64_KEY_LCTRL VK_LCONTROL
#define CEN64_KEY_LSHIFT VK_LSHIFT
#define CEN64_KEY_LSUPER VK_LWIN
#define CEN64_KEY_PERIOD VK_OEM_PERIOD
#define CEN64_KEY_RALT VK_RMENU
#define CEN64_KEY_RBRACKET VK_OEM_6
#define CEN64_KEY_RCTRL VK_RCONTROL
#define CEN64_KEY_RETURN VK_RETURN
#define CEN64_KEY_RSHIFT VK_RSHIFT
#define CEN64_KEY_RSUPER VK_RWIN
#define CEN64_KEY_SEMICOLON VK_OEM_1
#define CEN64_KEY_SLASH VK_OEM_2
#define CEN64_KEY_SPACE VK_SPACE

#endif

