This directory contains the C# Protocol Buffers runtime library.

Usage
=====

The easiest way how to use C# protobufs is via the `Google.Protobuf`
NuGet package. Just add the NuGet package to your VS project.

You will also want to install the `Google.Protobuf.Tools` NuGet package, which
contains precompiled version of `protoc.exe` and a copy of well known `.proto`
files under the package's `tools` directory.

To generate C# files from your `.proto` files, invoke `protoc` with the 
`--csharp_out` option.

Supported platforms
===================

The runtime library is built as a portable class library, supporting:

- .NET 4.5
- Windows 8
- Windows Phone Silverlight 8
- Windows Phone 8.1
- .NET Core

You should be able to use Protocol Buffers in Visual Studio 2012 and
all later versions. This includes all code generated by `protoc`,
which only uses features from C# 3 and earlier.

Building
========

Open the `src/Google.Protobuf.sln` solution in Visual Studio 2015 or
later.

Although *users* of this project are only expected to have Visual
Studio 2012 or later, *developers* of the library are required to
have Visual Studio 2015 or later, as the library uses C# 6 features
in its implementation. These features have no impact when using the
compiled code - they're only relevant when building the
`Google.Protobuf` assembly.

Testing
=======

The unit tests use [NUnit 3](https://github.com/nunit/nunit). Vanilla NUnit doesn't 
support .NET Core, so to run the tests you'll need to use 
[dotnet-test-nunit](https://github.com/nunit/dotnet-test-nunit). 
`dotnet-test-nunit` can also run tests for .NET 4.5+, so to run the tests 
for both .NET Core and .NET 4.5, you can simply open the 
`Package Manager Console` in Visual Studio and execute:
```
dotnet test Google.Protobuf.Test
```

.NET 3.5
========

We don't officially support .NET 3.5. However, there has been some effort 
to make enabling .NET 3.5 support relatively painless in case you require it. 
There's no guarantee that this will continue in the future, so rely on .NET 
3.5 support at your peril.

To enable .NET 3.5 support:

1. Modify [src/Google.Protobuf/project.json](src/Google.Protobuf/project.json) to add `"net35": {}` to `"frameworks"`.
2. Modify [src/Google.Protobuf.Test/project.json](src/Google.Protobuf/project.json):
  1. Add `"net35": {}` to `"frameworks"`.
  2. `dotnet-test-nunit` doesn't support .NET 3.5, so remove it from 
  the project-wide `"dependencies"` and add it to the framework-specific 
  dependencies under `"net451"` and `"netcoreapp1.0"`.

Note that `dotnet-test-nunit` doesn't support .NET 3.5. You can instead run the 
tests with [NUnit 3 console](https://github.com/nunit/nunit-console) 
by running something like: 
```
nunit3-console.exe "Google.Protobuf.Test\bin\Debug\net35\win7-x64\Google.Protobuf.Test.dll" --inprocess
```

The exact path may differ depending on your environment (e.g., the `win7-x64` 
directory may be called something else). The `--inprocess` flag seems to be a 
necessary workaround for a bug in NUnit; otherwise, you'll receive 
an error "Exception has been thrown by the target of an invocation" 
([possibly related issue](https://github.com/nunit/nunit/issues/1480)).

If you still want to run the .NET 4.5 and .NET Core tests, you can do so by 
specifying the framework when using `dotnet-test-nunit`, i.e. from 
`Package Manager Console` in Visual Studio:
```
dotnet test Google.Protobuf.Test --framework netcoreapp1.0
dotnet test Google.Protobuf.Test --framework net451
```

History of C# protobufs
=======================

This subtree was originally imported from https://github.com/jskeet/protobuf-csharp-port
and represents the latest development version of C# protobufs, that will now be developed
and maintained by Google. All the development will be done in open, under this repository
(https://github.com/google/protobuf).

The previous project differs from this project in a number of ways:

- The old code only supported proto2; the new code only supports
proto3 (so no unknown fields, no required/optional distinction, no
extensions)
- The old code was based on immutable message types and builders for
them
- The old code did not support maps or `oneof`
- The old code had its own JSON representation, whereas the new code
uses the standard protobuf JSON representation
- The old code had no notion of the "well-known types" which have
special support in the new code
- The old project supported some older platforms (such as older
versions of Silverlight) which are not currently supported in the
new project
