// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package simpledb provides a client for Amazon SimpleDB.
package simpledb

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opBatchDeleteAttributes = "BatchDeleteAttributes"

// BatchDeleteAttributesRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchDeleteAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchDeleteAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchDeleteAttributesRequest method.
//    req, resp := client.BatchDeleteAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) BatchDeleteAttributesRequest(input *BatchDeleteAttributesInput) (req *request.Request, output *BatchDeleteAttributesOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchDeleteAttributesInput{}
	}

	output = &BatchDeleteAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// BatchDeleteAttributes API operation for Amazon SimpleDB.
//
// Performs multiple DeleteAttributes operations in a single call, which reduces
// round trips and latencies. This enables Amazon SimpleDB to optimize requests,
// which generally yields better throughput.
//
// If you specify BatchDeleteAttributes without attributes or values, all the
// attributes for the item are deleted.
//
//  BatchDeleteAttributes is an idempotent operation; running it multiple times
// on the same item or attribute doesn't result in an error.
//
//  The BatchDeleteAttributes operation succeeds or fails in its entirety. There
// are no partial deletes. You can execute multiple BatchDeleteAttributes operations
// and other operations in parallel. However, large numbers of concurrent BatchDeleteAttributes
// calls can result in Service Unavailable (503) responses.
//
//  This operation is vulnerable to exceeding the maximum URL size when making
// a REST request using the HTTP GET method.
//
//  This operation does not support conditions using Expected.X.Name, Expected.X.Value,
// or Expected.X.Exists.
//
// The following limitations are enforced for this operation: 1 MB request size
//
// 25 item limit per BatchDeleteAttributes operation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation BatchDeleteAttributes for usage and error information.
func (c *SimpleDB) BatchDeleteAttributes(input *BatchDeleteAttributesInput) (*BatchDeleteAttributesOutput, error) {
	req, out := c.BatchDeleteAttributesRequest(input)
	return out, req.Send()
}

// BatchDeleteAttributesWithContext is the same as BatchDeleteAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) BatchDeleteAttributesWithContext(ctx aws.Context, input *BatchDeleteAttributesInput, opts ...request.Option) (*BatchDeleteAttributesOutput, error) {
	req, out := c.BatchDeleteAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchPutAttributes = "BatchPutAttributes"

// BatchPutAttributesRequest generates a "aws/request.Request" representing the
// client's request for the BatchPutAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See BatchPutAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the BatchPutAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the BatchPutAttributesRequest method.
//    req, resp := client.BatchPutAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) BatchPutAttributesRequest(input *BatchPutAttributesInput) (req *request.Request, output *BatchPutAttributesOutput) {
	op := &request.Operation{
		Name:       opBatchPutAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchPutAttributesInput{}
	}

	output = &BatchPutAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// BatchPutAttributes API operation for Amazon SimpleDB.
//
// The BatchPutAttributes operation creates or replaces attributes within one
// or more items. By using this operation, the client can perform multiple PutAttribute
// operation with a single call. This helps yield savings in round trips and
// latencies, enabling Amazon SimpleDB to optimize requests and generally produce
// better throughput.
//
// The client may specify the item name with the Item.X.ItemName parameter.
// The client may specify new attributes using a combination of the Item.X.Attribute.Y.Name
// and Item.X.Attribute.Y.Value parameters. The client may specify the first
// attribute for the first item using the parameters Item.0.Attribute.0.Name
// and Item.0.Attribute.0.Value, and for the second attribute for the first
// item by the parameters Item.0.Attribute.1.Name and Item.0.Attribute.1.Value,
// and so on.
//
// Attributes are uniquely identified within an item by their name/value combination.
// For example, a single item can have the attributes { "first_name", "first_value"
// } and { "first_name", "second_value" }. However, it cannot have two attribute
// instances where both the Item.X.Attribute.Y.Name and Item.X.Attribute.Y.Value
// are the same.
//
// Optionally, the requester can supply the Replace parameter for each individual
// value. Setting this value to true will cause the new attribute values to
// replace the existing attribute values. For example, if an item I has the
// attributes { 'a', '1' }, { 'b', '2'} and { 'b', '3' } and the requester does
// a BatchPutAttributes of {'I', 'b', '4' } with the Replace parameter set to
// true, the final attributes of the item will be { 'a', '1' } and { 'b', '4'
// }, replacing the previous values of the 'b' attribute with the new value.
//
// You cannot specify an empty string as an item or as an attribute name. The
// BatchPutAttributes operation succeeds or fails in its entirety. There are
// no partial puts. This operation is vulnerable to exceeding the maximum URL size when making
// a REST request using the HTTP GET method. This operation does not support
// conditions using Expected.X.Name, Expected.X.Value, or Expected.X.Exists.
// You can execute multiple BatchPutAttributes operations and other operations
// in parallel. However, large numbers of concurrent BatchPutAttributes calls
// can result in Service Unavailable (503) responses.
//
// The following limitations are enforced for this operation: 256 attribute
// name-value pairs per item
// 1 MB request size
// 1 billion attributes per domain
// 10 GB of total user data storage per domain
// 25 item limit per BatchPutAttributes operation
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation BatchPutAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeDuplicateItemName "DuplicateItemName"
//   The item name was specified more than once.
//
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
//   * ErrCodeNumberItemAttributesExceeded "NumberItemAttributesExceeded"
//   Too many attributes in this item.
//
//   * ErrCodeNumberDomainAttributesExceeded "NumberDomainAttributesExceeded"
//   Too many attributes in this domain.
//
//   * ErrCodeNumberDomainBytesExceeded "NumberDomainBytesExceeded"
//   Too many bytes in this domain.
//
//   * ErrCodeNumberSubmittedItemsExceeded "NumberSubmittedItemsExceeded"
//   Too many items exist in a single call.
//
//   * ErrCodeNumberSubmittedAttributesExceeded "NumberSubmittedAttributesExceeded"
//   Too many attributes exist in a single call.
//
func (c *SimpleDB) BatchPutAttributes(input *BatchPutAttributesInput) (*BatchPutAttributesOutput, error) {
	req, out := c.BatchPutAttributesRequest(input)
	return out, req.Send()
}

// BatchPutAttributesWithContext is the same as BatchPutAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See BatchPutAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) BatchPutAttributesWithContext(ctx aws.Context, input *BatchPutAttributesInput, opts ...request.Option) (*BatchPutAttributesOutput, error) {
	req, out := c.BatchPutAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateDomain API operation for Amazon SimpleDB.
//
// The CreateDomain operation creates a new domain. The domain name should be
// unique among the domains associated with the Access Key ID provided in the
// request. The CreateDomain operation may take 10 or more seconds to complete.
//
// CreateDomain is an idempotent operation; running it multiple times using
// the same domain name will not result in an error response. The client can create up to 100 domains per account.
//
// If the client requires additional domains, go to  http://aws.amazon.com/contact-us/simpledb-limit-request/
// (http://aws.amazon.com/contact-us/simpledb-limit-request/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation CreateDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNumberDomainsExceeded "NumberDomainsExceeded"
//   Too many domains exist per this account.
//
func (c *SimpleDB) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttributes = "DeleteAttributes"

// DeleteAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAttributesRequest method.
//    req, resp := client.DeleteAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) DeleteAttributesRequest(input *DeleteAttributesInput) (req *request.Request, output *DeleteAttributesOutput) {
	op := &request.Operation{
		Name:       opDeleteAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAttributesInput{}
	}

	output = &DeleteAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAttributes API operation for Amazon SimpleDB.
//
// Deletes one or more attributes associated with an item. If all attributes
// of the item are deleted, the item is deleted.
//
// If DeleteAttributes is called without being passed any attributes or values
// specified, all the attributes for the item are deleted. DeleteAttributes is an idempotent operation; running it multiple times on
// the same item or attribute does not result in an error response.
//
// Because Amazon SimpleDB makes multiple copies of item data and uses an eventual
// consistency update model, performing a GetAttributes or Select operation
// (read) immediately after a DeleteAttributes or PutAttributes operation (write)
// might not return updated item data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation DeleteAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
//   * ErrCodeAttributeDoesNotExist "AttributeDoesNotExist"
//   The specified attribute does not exist.
//
func (c *SimpleDB) DeleteAttributes(input *DeleteAttributesInput) (*DeleteAttributesOutput, error) {
	req, out := c.DeleteAttributesRequest(input)
	return out, req.Send()
}

// DeleteAttributesWithContext is the same as DeleteAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) DeleteAttributesWithContext(ctx aws.Context, input *DeleteAttributesInput, opts ...request.Option) (*DeleteAttributesOutput, error) {
	req, out := c.DeleteAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomain API operation for Amazon SimpleDB.
//
// The DeleteDomain operation deletes a domain. Any items (and their attributes)
// in the domain are deleted as well. The DeleteDomain operation might take
// 10 or more seconds to complete.
//
// Running DeleteDomain on a domain that does not exist or running the function
// multiple times using the same domain name will not result in an error response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
func (c *SimpleDB) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDomainMetadata = "DomainMetadata"

// DomainMetadataRequest generates a "aws/request.Request" representing the
// client's request for the DomainMetadata operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DomainMetadata for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DomainMetadata method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DomainMetadataRequest method.
//    req, resp := client.DomainMetadataRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) DomainMetadataRequest(input *DomainMetadataInput) (req *request.Request, output *DomainMetadataOutput) {
	op := &request.Operation{
		Name:       opDomainMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DomainMetadataInput{}
	}

	output = &DomainMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DomainMetadata API operation for Amazon SimpleDB.
//
// Returns information about the domain, including when the domain was created,
// the number of items and attributes in the domain, and the size of the attribute
// names and values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation DomainMetadata for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
func (c *SimpleDB) DomainMetadata(input *DomainMetadataInput) (*DomainMetadataOutput, error) {
	req, out := c.DomainMetadataRequest(input)
	return out, req.Send()
}

// DomainMetadataWithContext is the same as DomainMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See DomainMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) DomainMetadataWithContext(ctx aws.Context, input *DomainMetadataInput, opts ...request.Option) (*DomainMetadataOutput, error) {
	req, out := c.DomainMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttributes = "GetAttributes"

// GetAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetAttributesRequest method.
//    req, resp := client.GetAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) GetAttributesRequest(input *GetAttributesInput) (req *request.Request, output *GetAttributesOutput) {
	op := &request.Operation{
		Name:       opGetAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAttributesInput{}
	}

	output = &GetAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttributes API operation for Amazon SimpleDB.
//
// Returns all of the attributes associated with the specified item. Optionally,
// the attributes returned can be limited to one or more attributes by specifying
// an attribute name parameter.
//
// If the item does not exist on the replica that was accessed for this operation,
// an empty set is returned. The system does not return an error as it cannot
// guarantee the item does not exist on other replicas.
//
// If GetAttributes is called without being passed any attribute names, all
// the attributes for the item are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation GetAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
func (c *SimpleDB) GetAttributes(input *GetAttributesInput) (*GetAttributesOutput, error) {
	req, out := c.GetAttributesRequest(input)
	return out, req.Send()
}

// GetAttributesWithContext is the same as GetAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) GetAttributesWithContext(ctx aws.Context, input *GetAttributesInput, opts ...request.Option) (*GetAttributesOutput, error) {
	req, out := c.GetAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDomains for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDomains method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxNumberOfDomains",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon SimpleDB.
//
// The ListDomains operation lists all domains associated with the Access Key
// ID. It returns domain names up to the limit set by MaxNumberOfDomains (#MaxNumberOfDomains).
// A NextToken (#NextToken) is returned if there are more than MaxNumberOfDomains
// domains. Calling ListDomains successive times with the NextToken provided
// by the operation returns up to MaxNumberOfDomains more domain names with
// each successive operation call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation ListDomains for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified NextToken is not valid.
//
func (c *SimpleDB) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDomainsPages iterates over the pages of a ListDomains operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDomains method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDomains operation.
//    pageNum := 0
//    err := client.ListDomainsPages(params,
//        func(page *ListDomainsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SimpleDB) ListDomainsPages(input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool) error {
	return c.ListDomainsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDomainsPagesWithContext same as ListDomainsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) ListDomainsPagesWithContext(ctx aws.Context, input *ListDomainsInput, fn func(*ListDomainsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.ListDomainsRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListDomainsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opPutAttributes = "PutAttributes"

// PutAttributesRequest generates a "aws/request.Request" representing the
// client's request for the PutAttributes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutAttributes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutAttributes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutAttributesRequest method.
//    req, resp := client.PutAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) PutAttributesRequest(input *PutAttributesInput) (req *request.Request, output *PutAttributesOutput) {
	op := &request.Operation{
		Name:       opPutAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutAttributesInput{}
	}

	output = &PutAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutAttributes API operation for Amazon SimpleDB.
//
// The PutAttributes operation creates or replaces attributes in an item. The
// client may specify new attributes using a combination of the Attribute.X.Name
// and Attribute.X.Value parameters. The client specifies the first attribute
// by the parameters Attribute.0.Name and Attribute.0.Value, the second attribute
// by the parameters Attribute.1.Name and Attribute.1.Value, and so on.
//
// Attributes are uniquely identified in an item by their name/value combination.
// For example, a single item can have the attributes { "first_name", "first_value"
// } and { "first_name", second_value" }. However, it cannot have two attribute
// instances where both the Attribute.X.Name and Attribute.X.Value are the same.
//
// Optionally, the requestor can supply the Replace parameter for each individual
// attribute. Setting this value to true causes the new attribute value to replace
// the existing attribute value(s). For example, if an item has the attributes
// { 'a', '1' }, { 'b', '2'} and { 'b', '3' } and the requestor calls PutAttributes
// using the attributes { 'b', '4' } with the Replace parameter set to true,
// the final attributes of the item are changed to { 'a', '1' } and { 'b', '4'
// }, which replaces the previous values of the 'b' attribute with the new value.
//
// Using PutAttributes to replace attribute values that do not exist will not
// result in an error response. You cannot specify an empty string as an attribute name.
//
// Because Amazon SimpleDB makes multiple copies of client data and uses an
// eventual consistency update model, an immediate GetAttributes or Select operation
// (read) immediately after a PutAttributes or DeleteAttributes operation (write)
// might not return the updated data.
//
// The following limitations are enforced for this operation: 256 total attribute
// name-value pairs per item
// One billion attributes per domain
// 10 GB of total user data storage per domain
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation PutAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
//   * ErrCodeNumberDomainAttributesExceeded "NumberDomainAttributesExceeded"
//   Too many attributes in this domain.
//
//   * ErrCodeNumberDomainBytesExceeded "NumberDomainBytesExceeded"
//   Too many bytes in this domain.
//
//   * ErrCodeNumberItemAttributesExceeded "NumberItemAttributesExceeded"
//   Too many attributes in this item.
//
//   * ErrCodeAttributeDoesNotExist "AttributeDoesNotExist"
//   The specified attribute does not exist.
//
func (c *SimpleDB) PutAttributes(input *PutAttributesInput) (*PutAttributesOutput, error) {
	req, out := c.PutAttributesRequest(input)
	return out, req.Send()
}

// PutAttributesWithContext is the same as PutAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See PutAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) PutAttributesWithContext(ctx aws.Context, input *PutAttributesInput, opts ...request.Option) (*PutAttributesOutput, error) {
	req, out := c.PutAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSelect = "Select"

// SelectRequest generates a "aws/request.Request" representing the
// client's request for the Select operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Select for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Select method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SelectRequest method.
//    req, resp := client.SelectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SimpleDB) SelectRequest(input *SelectInput) (req *request.Request, output *SelectOutput) {
	op := &request.Operation{
		Name:       opSelect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SelectInput{}
	}

	output = &SelectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Select API operation for Amazon SimpleDB.
//
// The Select operation returns a set of attributes for ItemNames that match
// the select expression. Select is similar to the standard SQL SELECT statement.
//
// The total size of the response cannot exceed 1 MB in total size. Amazon SimpleDB
// automatically adjusts the number of items returned per page to enforce this
// limit. For example, if the client asks to retrieve 2500 items, but each individual
// item is 10 kB in size, the system returns 100 items and an appropriate NextToken
// so the client can access the next page of results.
//
// For information on how to construct select expressions, see Using Select
// to Create Amazon SimpleDB Queries in the Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon SimpleDB's
// API operation Select for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterValue "InvalidParameterValue"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidNextToken "InvalidNextToken"
//   The specified NextToken is not valid.
//
//   * ErrCodeInvalidNumberPredicates "InvalidNumberPredicates"
//   Too many predicates exist in the query expression.
//
//   * ErrCodeInvalidNumberValueTests "InvalidNumberValueTests"
//   Too many predicates exist in the query expression.
//
//   * ErrCodeInvalidQueryExpression "InvalidQueryExpression"
//   The specified query expression syntax is not valid.
//
//   * ErrCodeMissingParameter "MissingParameter"
//   The request must contain the specified missing parameter.
//
//   * ErrCodeNoSuchDomain "NoSuchDomain"
//   The specified domain does not exist.
//
//   * ErrCodeRequestTimeout "RequestTimeout"
//   A timeout occurred when attempting to query the specified domain with specified
//   query expression.
//
//   * ErrCodeTooManyRequestedAttributes "TooManyRequestedAttributes"
//   Too many attributes requested.
//
func (c *SimpleDB) Select(input *SelectInput) (*SelectOutput, error) {
	req, out := c.SelectRequest(input)
	return out, req.Send()
}

// SelectWithContext is the same as Select with the addition of
// the ability to pass a context and additional request options.
//
// See Select for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) SelectWithContext(ctx aws.Context, input *SelectInput, opts ...request.Option) (*SelectOutput, error) {
	req, out := c.SelectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SelectPages iterates over the pages of a Select operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See Select method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a Select operation.
//    pageNum := 0
//    err := client.SelectPages(params,
//        func(page *SelectOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *SimpleDB) SelectPages(input *SelectInput, fn func(*SelectOutput, bool) bool) error {
	return c.SelectPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SelectPagesWithContext same as SelectPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SimpleDB) SelectPagesWithContext(ctx aws.Context, input *SelectInput, fn func(*SelectOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			inCpy := *input
			req, _ := c.SelectRequest(&inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*SelectOutput), !p.HasNextPage())
	}
	return p.Err()
}

type Attribute struct {
	_ struct{} `type:"structure"`

	AlternateNameEncoding *string `type:"string"`

	AlternateValueEncoding *string `type:"string"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the attribute.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Attribute) GoString() string {
	return s.String()
}

// SetAlternateNameEncoding sets the AlternateNameEncoding field's value.
func (s *Attribute) SetAlternateNameEncoding(v string) *Attribute {
	s.AlternateNameEncoding = &v
	return s
}

// SetAlternateValueEncoding sets the AlternateValueEncoding field's value.
func (s *Attribute) SetAlternateValueEncoding(v string) *Attribute {
	s.AlternateValueEncoding = &v
	return s
}

// SetName sets the Name field's value.
func (s *Attribute) SetName(v string) *Attribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Attribute) SetValue(v string) *Attribute {
	s.Value = &v
	return s
}

type BatchDeleteAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the attributes are being deleted.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A list of items on which to perform the operation.
	//
	// Items is a required field
	Items []*DeletableItem `locationNameList:"Item" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BatchDeleteAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteAttributesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *BatchDeleteAttributesInput) SetDomainName(v string) *BatchDeleteAttributesInput {
	s.DomainName = &v
	return s
}

// SetItems sets the Items field's value.
func (s *BatchDeleteAttributesInput) SetItems(v []*DeletableItem) *BatchDeleteAttributesInput {
	s.Items = v
	return s
}

type BatchDeleteAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchDeleteAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteAttributesOutput) GoString() string {
	return s.String()
}

type BatchPutAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the attributes are being stored.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// A list of items on which to perform the operation.
	//
	// Items is a required field
	Items []*ReplaceableItem `locationNameList:"Item" type:"list" flattened:"true" required:"true"`
}

// String returns the string representation
func (s BatchPutAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchPutAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchPutAttributesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *BatchPutAttributesInput) SetDomainName(v string) *BatchPutAttributesInput {
	s.DomainName = &v
	return s
}

// SetItems sets the Items field's value.
func (s *BatchPutAttributesInput) SetItems(v []*ReplaceableItem) *BatchPutAttributesInput {
	s.Items = v
	return s
}

type BatchPutAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s BatchPutAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPutAttributesOutput) GoString() string {
	return s.String()
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to create. The name can range between 3 and 255 characters
	// and can contain the following characters: a-z, A-Z, 0-9, '_', '-', and '.'.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

type DeletableAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The value of the attribute.
	Value *string `type:"string"`
}

// String returns the string representation
func (s DeletableAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletableAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletableAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletableAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletableAttribute) SetName(v string) *DeletableAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *DeletableAttribute) SetValue(v string) *DeletableAttribute {
	s.Value = &v
	return s
}

type DeletableItem struct {
	_ struct{} `type:"structure"`

	Attributes []*DeletableAttribute `locationNameList:"Attribute" type:"list" flattened:"true"`

	// Name is a required field
	Name *string `locationName:"ItemName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletableItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletableItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletableItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletableItem"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DeletableItem) SetAttributes(v []*DeletableAttribute) *DeletableItem {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *DeletableItem) SetName(v string) *DeletableItem {
	s.Name = &v
	return s
}

type DeleteAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of Attributes. Similar to columns on a spreadsheet, attributes represent
	// categories of data that can be assigned to items.
	Attributes []*DeletableAttribute `locationNameList:"Attribute" type:"list" flattened:"true"`

	// The name of the domain in which to perform the operation.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The update condition which, if specified, determines whether the specified
	// attributes will be deleted or not. The update condition must be satisfied
	// in order for this request to be processed and the attributes to be deleted.
	Expected *UpdateCondition `type:"structure"`

	// The name of the item. Similar to rows on a spreadsheet, items represent individual
	// objects that contain one or more value-attribute pairs.
	//
	// ItemName is a required field
	ItemName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttributesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.ItemName == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemName"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *DeleteAttributesInput) SetAttributes(v []*DeletableAttribute) *DeleteAttributesInput {
	s.Attributes = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteAttributesInput) SetDomainName(v string) *DeleteAttributesInput {
	s.DomainName = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *DeleteAttributesInput) SetExpected(v *UpdateCondition) *DeleteAttributesInput {
	s.Expected = v
	return s
}

// SetItemName sets the ItemName field's value.
func (s *DeleteAttributesInput) SetItemName(v string) *DeleteAttributesInput {
	s.ItemName = &v
	return s
}

type DeleteAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAttributesOutput) GoString() string {
	return s.String()
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to delete.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

type DomainMetadataInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain for which to display the metadata of.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DomainMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DomainMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DomainMetadataInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DomainMetadataInput) SetDomainName(v string) *DomainMetadataInput {
	s.DomainName = &v
	return s
}

type DomainMetadataOutput struct {
	_ struct{} `type:"structure"`

	// The number of unique attribute names in the domain.
	AttributeNameCount *int64 `type:"integer"`

	// The total size of all unique attribute names in the domain, in bytes.
	AttributeNamesSizeBytes *int64 `type:"long"`

	// The number of all attribute name/value pairs in the domain.
	AttributeValueCount *int64 `type:"integer"`

	// The total size of all attribute values in the domain, in bytes.
	AttributeValuesSizeBytes *int64 `type:"long"`

	// The number of all items in the domain.
	ItemCount *int64 `type:"integer"`

	// The total size of all item names in the domain, in bytes.
	ItemNamesSizeBytes *int64 `type:"long"`

	// The data and time when metadata was calculated, in Epoch (UNIX) seconds.
	Timestamp *int64 `type:"integer"`
}

// String returns the string representation
func (s DomainMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainMetadataOutput) GoString() string {
	return s.String()
}

// SetAttributeNameCount sets the AttributeNameCount field's value.
func (s *DomainMetadataOutput) SetAttributeNameCount(v int64) *DomainMetadataOutput {
	s.AttributeNameCount = &v
	return s
}

// SetAttributeNamesSizeBytes sets the AttributeNamesSizeBytes field's value.
func (s *DomainMetadataOutput) SetAttributeNamesSizeBytes(v int64) *DomainMetadataOutput {
	s.AttributeNamesSizeBytes = &v
	return s
}

// SetAttributeValueCount sets the AttributeValueCount field's value.
func (s *DomainMetadataOutput) SetAttributeValueCount(v int64) *DomainMetadataOutput {
	s.AttributeValueCount = &v
	return s
}

// SetAttributeValuesSizeBytes sets the AttributeValuesSizeBytes field's value.
func (s *DomainMetadataOutput) SetAttributeValuesSizeBytes(v int64) *DomainMetadataOutput {
	s.AttributeValuesSizeBytes = &v
	return s
}

// SetItemCount sets the ItemCount field's value.
func (s *DomainMetadataOutput) SetItemCount(v int64) *DomainMetadataOutput {
	s.ItemCount = &v
	return s
}

// SetItemNamesSizeBytes sets the ItemNamesSizeBytes field's value.
func (s *DomainMetadataOutput) SetItemNamesSizeBytes(v int64) *DomainMetadataOutput {
	s.ItemNamesSizeBytes = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *DomainMetadataOutput) SetTimestamp(v int64) *DomainMetadataOutput {
	s.Timestamp = &v
	return s
}

type GetAttributesInput struct {
	_ struct{} `type:"structure"`

	// The names of the attributes.
	AttributeNames []*string `locationNameList:"AttributeName" type:"list" flattened:"true"`

	// Determines whether or not strong consistency should be enforced when data
	// is read from SimpleDB. If true
	ConsistentRead *bool `type:"boolean"`

	// The name of the domain in which to perform the operation.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The name of the item.
	//
	// ItemName is a required field
	ItemName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttributesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.ItemName == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeNames sets the AttributeNames field's value.
func (s *GetAttributesInput) SetAttributeNames(v []*string) *GetAttributesInput {
	s.AttributeNames = v
	return s
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *GetAttributesInput) SetConsistentRead(v bool) *GetAttributesInput {
	s.ConsistentRead = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetAttributesInput) SetDomainName(v string) *GetAttributesInput {
	s.DomainName = &v
	return s
}

// SetItemName sets the ItemName field's value.
func (s *GetAttributesInput) SetItemName(v string) *GetAttributesInput {
	s.ItemName = &v
	return s
}

type GetAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The list of attributes returned by the operation.
	Attributes []*Attribute `locationNameList:"Attribute" type:"list" flattened:"true"`
}

// String returns the string representation
func (s GetAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *GetAttributesOutput) SetAttributes(v []*Attribute) *GetAttributesOutput {
	s.Attributes = v
	return s
}

type Item struct {
	_ struct{} `type:"structure"`

	AlternateNameEncoding *string `type:"string"`

	// A list of attributes.
	//
	// Attributes is a required field
	Attributes []*Attribute `locationNameList:"Attribute" type:"list" flattened:"true" required:"true"`

	// The name of the item.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Item) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Item) GoString() string {
	return s.String()
}

// SetAlternateNameEncoding sets the AlternateNameEncoding field's value.
func (s *Item) SetAlternateNameEncoding(v string) *Item {
	s.AlternateNameEncoding = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Item) SetAttributes(v []*Attribute) *Item {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *Item) SetName(v string) *Item {
	s.Name = &v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of domain names you want returned. The range is 1 to 100.
	// The default setting is 100.
	MaxNumberOfDomains *int64 `type:"integer"`

	// A string informing Amazon SimpleDB where to start the next list of domain
	// names.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// SetMaxNumberOfDomains sets the MaxNumberOfDomains field's value.
func (s *ListDomainsInput) SetMaxNumberOfDomains(v int64) *ListDomainsInput {
	s.MaxNumberOfDomains = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// A list of domain names that match the expression.
	DomainNames []*string `locationNameList:"DomainName" type:"list" flattened:"true"`

	// An opaque token indicating that there are more domains than the specified
	// MaxNumberOfDomains
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainsOutput) SetDomainNames(v []*string) *ListDomainsOutput {
	s.DomainNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

type PutAttributesInput struct {
	_ struct{} `type:"structure"`

	// The list of attributes.
	//
	// Attributes is a required field
	Attributes []*ReplaceableAttribute `locationNameList:"Attribute" type:"list" flattened:"true" required:"true"`

	// The name of the domain in which to perform the operation.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The update condition which, if specified, determines whether the specified
	// attributes will be updated or not. The update condition must be satisfied
	// in order for this request to be processed and the attributes to be updated.
	Expected *UpdateCondition `type:"structure"`

	// The name of the item.
	//
	// ItemName is a required field
	ItemName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s PutAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutAttributesInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.ItemName == nil {
		invalidParams.Add(request.NewErrParamRequired("ItemName"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *PutAttributesInput) SetAttributes(v []*ReplaceableAttribute) *PutAttributesInput {
	s.Attributes = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PutAttributesInput) SetDomainName(v string) *PutAttributesInput {
	s.DomainName = &v
	return s
}

// SetExpected sets the Expected field's value.
func (s *PutAttributesInput) SetExpected(v *UpdateCondition) *PutAttributesInput {
	s.Expected = v
	return s
}

// SetItemName sets the ItemName field's value.
func (s *PutAttributesInput) SetItemName(v string) *PutAttributesInput {
	s.ItemName = &v
	return s
}

type PutAttributesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutAttributesOutput) GoString() string {
	return s.String()
}

type ReplaceableAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the replaceable attribute.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A flag specifying whether or not to replace the attribute/value pair or to
	// add a new attribute/value pair. The default setting is false
	Replace *bool `type:"boolean"`

	// The value of the replaceable attribute.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ReplaceableAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceableAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceableAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplaceableAttribute"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ReplaceableAttribute) SetName(v string) *ReplaceableAttribute {
	s.Name = &v
	return s
}

// SetReplace sets the Replace field's value.
func (s *ReplaceableAttribute) SetReplace(v bool) *ReplaceableAttribute {
	s.Replace = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ReplaceableAttribute) SetValue(v string) *ReplaceableAttribute {
	s.Value = &v
	return s
}

type ReplaceableItem struct {
	_ struct{} `type:"structure"`

	// The list of attributes for a replaceable item.
	//
	// Attributes is a required field
	Attributes []*ReplaceableAttribute `locationNameList:"Attribute" type:"list" flattened:"true" required:"true"`

	// The name of the replaceable item.
	//
	// Name is a required field
	Name *string `locationName:"ItemName" type:"string" required:"true"`
}

// String returns the string representation
func (s ReplaceableItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplaceableItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReplaceableItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReplaceableItem"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Attributes != nil {
		for i, v := range s.Attributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Attributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *ReplaceableItem) SetAttributes(v []*ReplaceableAttribute) *ReplaceableItem {
	s.Attributes = v
	return s
}

// SetName sets the Name field's value.
func (s *ReplaceableItem) SetName(v string) *ReplaceableItem {
	s.Name = &v
	return s
}

type SelectInput struct {
	_ struct{} `type:"structure"`

	// Determines whether or not strong consistency should be enforced when data
	// is read from SimpleDB. If true
	ConsistentRead *bool `type:"boolean"`

	// A string informing Amazon SimpleDB where to start the next list of ItemNames
	NextToken *string `type:"string"`

	// The expression used to query the domain.
	//
	// SelectExpression is a required field
	SelectExpression *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SelectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelectInput"}
	if s.SelectExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConsistentRead sets the ConsistentRead field's value.
func (s *SelectInput) SetConsistentRead(v bool) *SelectInput {
	s.ConsistentRead = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SelectInput) SetNextToken(v string) *SelectInput {
	s.NextToken = &v
	return s
}

// SetSelectExpression sets the SelectExpression field's value.
func (s *SelectInput) SetSelectExpression(v string) *SelectInput {
	s.SelectExpression = &v
	return s
}

type SelectOutput struct {
	_ struct{} `type:"structure"`

	// A list of items that match the select expression.
	Items []*Item `locationNameList:"Item" type:"list" flattened:"true"`

	// An opaque token indicating that more items than MaxNumberOfItems
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s SelectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelectOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *SelectOutput) SetItems(v []*Item) *SelectOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SelectOutput) SetNextToken(v string) *SelectOutput {
	s.NextToken = &v
	return s
}

// Specifies the conditions under which data should be updated. If an update
// condition is specified for a request, the data will only be updated if the
// condition is satisfied. For example, if an attribute with a specific name
// and value exists, or if a specific attribute doesn't exist.
type UpdateCondition struct {
	_ struct{} `type:"structure"`

	// A value specifying whether or not the specified attribute must exist with
	// the specified value in order for the update condition to be satisfied. Specify
	// true if the attribute must exist for the update condition to be satisfied.
	// Specify false if the attribute should not exist in order for the update condition
	// to be satisfied.
	Exists *bool `type:"boolean"`

	// The name of the attribute involved in the condition.
	Name *string `type:"string"`

	// The value of an attribute. This value can only be specified when the Exists
	// parameter is equal to true.
	Value *string `type:"string"`
}

// String returns the string representation
func (s UpdateCondition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCondition) GoString() string {
	return s.String()
}

// SetExists sets the Exists field's value.
func (s *UpdateCondition) SetExists(v bool) *UpdateCondition {
	s.Exists = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCondition) SetName(v string) *UpdateCondition {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateCondition) SetValue(v string) *UpdateCondition {
	s.Value = &v
	return s
}
