"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.isTcpPath = isTcpPath;
exports.parseTcpPath = parseTcpPath;
exports.readBackup = readBackup;
const node_assert_1 = __importDefault(require("node:assert"));
const node_fs_1 = require("node:fs");
const node_url_1 = require("node:url");
function isTcpPath(path) {
    try {
        // validation as side-effect
        new URL(path);
        return true;
    }
    catch {
        return false;
    }
}
function parseTcpPath(path) {
    const info = (0, node_url_1.urlToHttpOptions)(new URL(path));
    // urlToHttpOptions has a weird return type, extra validation doesn't hurt
    (0, node_assert_1.default)(info.hostname && info.port);
    return {
        host: info.hostname,
        port: Number(info.port),
    };
}
function readBackup(path) {
    if (!(0, node_fs_1.existsSync)(path)) {
        return undefined;
    }
    try {
        return JSON.parse((0, node_fs_1.readFileSync)(path).toString());
    }
    catch (error) {
        throw new Error(`[BACKUP] Coordinator backup is corrupted. This can happen due to filesystem corruption. To re-create the backup, delete '${path}' and start again. (${error.stack})`);
    }
}
//# sourceMappingURL=utils.js.map