/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.util.StringComparator;

public class OBOFormatPrefixManager
implements PrefixManager {
    private final String OBO_NS = "http://purl.obolibrary.org/obo/";
    @Nonnull
    private StringComparator comparator = new StringComparator(){
        private final Comparator<String> alphabetical = Comparator.comparing(s -> s);
        private final Comparator<String> byLength = Comparator.comparing(s -> -s.length());
        private final Comparator<String> byBoth = this.byLength.thenComparing(this.alphabetical);

        @Override
        public int compare(String o1, String o2) {
            return this.byBoth.compare(o1, o2);
        }
    };
    @Nonnull
    private final TreeMap<String, String> nsToPrefix;
    @Nonnull
    private final TreeMap<String, String> prefixToNS = new TreeMap(this.comparator);

    public OBOFormatPrefixManager(@Nullable PrefixManager pm) {
        this.nsToPrefix = new TreeMap(this.comparator);
        if (pm != null) {
            this.copyPrefixesFrom(pm);
        }
    }

    @Override
    @Nonnull
    public StringComparator getPrefixComparator() {
        return this.comparator;
    }

    @Override
    public void setPrefixComparator(@Nonnull StringComparator comparator) {
        this.comparator = comparator;
    }

    @Override
    @Nullable
    public String getDefaultPrefix() {
        return null;
    }

    @Override
    public boolean containsPrefixMapping(@Nonnull String prefixName) {
        return this.prefixToNS.containsKey(prefixName);
    }

    @Override
    @Nullable
    public String getPrefix(@Nonnull String prefixName) {
        return this.prefixToNS.get(prefixName);
    }

    @Override
    @Nonnull
    public Map<String, String> getPrefixName2PrefixMap() {
        return Collections.unmodifiableMap(this.prefixToNS);
    }

    @Override
    @Nonnull
    public IRI getIRI(@Nonnull String prefixIRI) {
        if (prefixIRI.startsWith("<")) {
            return IRI.create(prefixIRI.substring(1, prefixIRI.length() - 1));
        }
        int sep = prefixIRI.indexOf(58);
        if (sep == -1) {
            if (this.getDefaultPrefix() != null) {
                return IRI.create(this.getDefaultPrefix() + prefixIRI);
            }
            return IRI.create(prefixIRI);
        }
        String prefixName = prefixIRI.substring(0, sep + 1);
        if (!this.containsPrefixMapping(prefixName)) {
            throw new OWLRuntimeException("Prefix not registered for prefix name: " + prefixName);
        }
        String prefix = this.getPrefix(prefixName);
        String localName = prefixIRI.substring(sep + 1);
        return IRI.create(prefix, localName);
    }

    @Override
    @Nullable
    public String getPrefixIRI(@Nonnull IRI iri) {
        String iriString = iri.toString();
        Optional<Map.Entry> mappingOpt = this.nsToPrefix.entrySet().stream().filter(e -> iriString.startsWith((String)e.getKey())).findFirst();
        if (mappingOpt.isPresent()) {
            Map.Entry mapping = mappingOpt.get();
            String localId = iriString.substring(((String)mapping.getKey()).length());
            return (String)mapping.getValue() + ":" + localId;
        }
        return null;
    }

    @Override
    @Nullable
    public String getPrefixIRIIgnoreQName(@Nonnull IRI iri) {
        return this.getPrefixIRI(iri);
    }

    @Override
    @Nonnull
    public Set<String> getPrefixNames() {
        return this.prefixToNS.keySet();
    }

    @Override
    public void setDefaultPrefix(@Nullable String defaultPrefix) {
    }

    @Override
    public void setPrefix(@Nonnull String prefixName, @Nonnull String prefix) {
        if (!(prefixName.isEmpty() || prefixName.equals(":") || "http://purl.obolibrary.org/obo/".startsWith(prefix) || prefix.startsWith("http://purl.obolibrary.org/obo/"))) {
            String cleanPrefixName = prefixName;
            if (prefixName.endsWith(":")) {
                cleanPrefixName = prefixName.substring(0, prefixName.length() - 1);
            }
            this.prefixToNS.put(cleanPrefixName, prefix);
            this.nsToPrefix.put(prefix, cleanPrefixName);
        }
    }

    @Override
    public void copyPrefixesFrom(@Nonnull PrefixManager from) {
        this.copyPrefixesFrom(from.getPrefixName2PrefixMap());
    }

    @Override
    public void copyPrefixesFrom(@Nonnull Map<String, String> from) {
        for (Map.Entry<String, String> e : from.entrySet()) {
            String prefix = e.getKey();
            if (prefix.isEmpty()) continue;
            this.setPrefix(e.getKey(), e.getValue());
        }
    }

    @Override
    public void unregisterNamespace(@Nonnull String namespace) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, String> e : this.prefixToNS.entrySet()) {
            if (!e.getValue().equals(namespace)) continue;
            toRemove.add(e.getKey());
        }
        for (String s : toRemove) {
            this.prefixToNS.remove(s);
        }
        this.nsToPrefix.remove(namespace);
    }

    @Override
    public void clear() {
        this.prefixToNS.clear();
        this.nsToPrefix.clear();
    }
}

