"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deflateValue = deflateValue;
exports.inflateValue = inflateValue;
var _nodeZlib = _interopRequireDefault(require("node:zlib"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 *   Copyright OpenSearch Contributors
 *
 *   Licensed under the Apache License, Version 2.0 (the "License").
 *   You may not use this file except in compliance with the License.
 *   A copy of the License is located at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   or in the "license" file accompanying this file. This file is distributed
 *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 *   express or implied. See the License for the specific language governing
 *   permissions and limitations under the License.
 */

function deflateValue(value, options = {}) {
  const compressedBuffer = _nodeZlib.default.deflateSync(value, options);
  return compressedBuffer;
}
function inflateValue(value, options = {}) {
  const uncompressedBuffer = _nodeZlib.default.inflateSync(value, options);
  return uncompressedBuffer;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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