/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jsampler.event.ParameterEvent;
import org.jsampler.event.ParameterListener;
import org.jsampler.view.NumberCellEditor;
import org.linuxsampler.lscp.Parameter;
import org.linuxsampler.lscp.ParameterType;
import org.linuxsampler.lscp.StringListParameter;

public class ParameterTableModel
extends AbstractTableModel {
    public static final int PARAMETER_NAME_COLUMN = 0;
    public static final int PARAMETER_VALUE_COLUMN = 1;
    private Parameter[] parameters;
    private final BooleanCellRenderer booleanRenderer = new BooleanCellRenderer();
    private final BooleanCellEditor booleanEditor = new BooleanCellEditor();
    private final IntegerCellRenderer integerRenderer = new IntegerCellRenderer();
    private final IntegerCellEditor integerEditor = new IntegerCellEditor();
    private final FloatCellRenderer floatRenderer = new FloatCellRenderer();
    private final FloatCellEditor floatEditor = new FloatCellEditor();
    private final StringListCellRenderer stringListRenderer = new StringListCellRenderer();
    private final StringListCellEditor stringListEditor = new StringListCellEditor();
    private boolean editFixedParameters;
    private final Vector<ParameterListener> parameterListeners = new Vector();

    public ParameterTableModel(Parameter[] parameterArray) {
        this(parameterArray, false);
    }

    public ParameterTableModel(Parameter[] parameterArray, boolean bl) {
        this.setParameters(parameterArray);
        this.setEditFixedParameters(bl);
    }

    public void addParameterListener(ParameterListener parameterListener) {
        this.parameterListeners.add(parameterListener);
    }

    public void removeParameterListener(ParameterListener parameterListener) {
        this.parameterListeners.remove(parameterListener);
    }

    public void setEditFixedParameters(boolean bl) {
        this.editFixedParameters = bl;
    }

    public boolean canEditFixedParameters() {
        return this.editFixedParameters;
    }

    public Parameter getParameter(int n) {
        return this.parameters[n];
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 != 1) {
            return null;
        }
        if (this.parameters[n].getType() == ParameterType.BOOL) {
            return this.booleanRenderer;
        }
        if (this.parameters[n].getType() == ParameterType.INT) {
            return this.integerRenderer;
        }
        if (this.parameters[n].getType() == ParameterType.FLOAT) {
            return this.floatRenderer;
        }
        if (this.parameters[n].getType() == ParameterType.STRING_LIST) {
            return this.stringListRenderer;
        }
        return null;
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        if (n2 != 1) {
            return null;
        }
        Parameter parameter = this.parameters[n];
        if (parameter.getType() == ParameterType.BOOL) {
            return this.booleanEditor;
        }
        if (parameter.getType() == ParameterType.BOOL_LIST) {
            // empty if block
        }
        if (parameter.getType() == ParameterType.FLOAT_LIST) {
            // empty if block
        }
        if (parameter.getType() == ParameterType.INT_LIST) {
            // empty if block
        }
        if (parameter.getType() == ParameterType.STRING_LIST) {
            return this.stringListEditor;
        }
        if (parameter.hasPossibilities()) {
            JComboBox jComboBox = new JComboBox(parameter.getPossibilities());
            jComboBox.setSelectedItem(null);
            return new DefaultCellEditor(jComboBox);
        }
        if (parameter.getType() == ParameterType.INT) {
            Integer n3 = parameter.hasRangeMin() ? Integer.valueOf(parameter.getRangeMin().intValue()) : null;
            this.integerEditor.setMinimum(n3);
            n3 = parameter.hasRangeMax() ? Integer.valueOf(parameter.getRangeMax().intValue()) : null;
            this.integerEditor.setMaximum(n3);
            return this.integerEditor;
        }
        if (parameter.getType() == ParameterType.FLOAT) {
            Float f = parameter.hasRangeMin() ? Float.valueOf(parameter.getRangeMin().floatValue()) : null;
            this.floatEditor.setMinimum(f);
            f = parameter.hasRangeMax() ? Float.valueOf(parameter.getRangeMax().floatValue()) : null;
            this.floatEditor.setMaximum(f);
            return this.floatEditor;
        }
        return null;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Parameter[] parameterArray) {
        this.parameters = parameterArray;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.parameters.length;
    }

    @Override
    public String getColumnName(int n) {
        return " ";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.parameters[n].getName();
            }
            case 1: {
                return this.parameters[n].getValue();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 != 1) {
            return;
        }
        this.parameters[n].setValue(object);
        this.fireTableCellUpdated(n, n2);
        this.fireParameterChanged(this.parameters[n]);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return false;
            }
            case 1: {
                return this.canEditFixedParameters() || !this.parameters[n].isFixed();
            }
        }
        return false;
    }

    private void fireParameterChanged(Parameter parameter) {
        ParameterEvent parameterEvent = new ParameterEvent(this, parameter);
        for (ParameterListener parameterListener : this.parameterListeners) {
            parameterListener.parameterChanged(parameterEvent);
        }
    }

    class StringListCellRenderer
    extends DefaultTableCellRenderer {
        private final StringBuffer sb = new StringBuffer();

        StringListCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof String) {
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
            String[] stringArray = (String[])object;
            this.sb.setLength(0);
            if (stringArray != null) {
                if (stringArray.length > 0) {
                    this.sb.append(stringArray[0]);
                }
                for (int i = 1; i < stringArray.length; ++i) {
                    this.sb.append(", ").append(stringArray[i]);
                }
            }
            return super.getTableCellRendererComponent(jTable, this.sb.toString(), bl, bl2, n, n2);
        }
    }

    class StringListCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JButton editor = new JButton();
        private final JPopupMenu menu = new JPopupMenu();
        private final Vector<JCheckBoxMenuItem> menuItems = new Vector();
        private final Vector<String> strings = new Vector();
        private final StringBuffer sb = new StringBuffer();

        StringListCellEditor() {
            this.editor.setBorderPainted(false);
            this.editor.setContentAreaFilled(false);
            this.editor.setFocusPainted(false);
            this.editor.setMargin(new Insets(0, 0, 0, 0));
            this.editor.setFont(this.editor.getFont().deriveFont(0));
            this.editor.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringListCellEditor.this.menu.show(StringListCellEditor.this.editor, 0, 0);
                }
            });
            this.menu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    StringListCellEditor.this.cancelCellEditing();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            this.strings.removeAllElements();
            for (JCheckBoxMenuItem jCheckBoxMenuItem : this.menuItems) {
                if (!jCheckBoxMenuItem.isSelected()) continue;
                this.strings.add(jCheckBoxMenuItem.getText());
            }
            return this.strings.toArray(new String[this.strings.size()]);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            StringListParameter stringListParameter = (StringListParameter)ParameterTableModel.this.parameters[n];
            if (((String[][])stringListParameter.getPossibilities()).length == 0) {
                this.editor.setText("");
                return this.editor;
            }
            String[] stringArray = ((String[][])stringListParameter.getPossibilities())[0];
            String[] stringArray2 = (String[])object;
            this.sb.setLength(0);
            if (stringArray2 != null) {
                if (stringArray2.length > 0) {
                    this.sb.append(stringArray2[0]);
                }
                for (int i = 1; i < stringArray2.length; ++i) {
                    this.sb.append(", ").append(stringArray2[i]);
                }
            }
            this.editor.setText(this.sb.toString());
            this.menu.removeAll();
            this.menuItems.removeAllElements();
            for (String string : stringArray) {
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
                this.setListener(jCheckBoxMenuItem);
                for (String string2 : stringArray2) {
                    if (!string2.equals(string)) continue;
                    jCheckBoxMenuItem.setSelected(true);
                }
                this.menu.add(jCheckBoxMenuItem);
                this.menuItems.add(jCheckBoxMenuItem);
            }
            return this.editor;
        }

        private void setListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
            jCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    StringListCellEditor.this.stopCellEditing();
                }
            });
        }
    }

    class FloatCellRenderer
    extends DefaultTableCellRenderer {
        FloatCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    class FloatCellEditor
    extends NumberCellEditor {
        FloatCellEditor() {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0);
            this.setModel(spinnerNumberModel);
        }
    }

    class IntegerCellRenderer
    extends DefaultTableCellRenderer {
        IntegerCellRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    class IntegerCellEditor
    extends NumberCellEditor {
        IntegerCellEditor() {
        }
    }

    class BooleanCellEditor
    extends DefaultCellEditor {
        BooleanCellEditor() {
            super(new JCheckBox());
            JCheckBox jCheckBox = (JCheckBox)this.getComponent();
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    class BooleanCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private final Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        BooleanCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            Boolean bl3 = (Boolean)object;
            this.setSelected(bl3 != null && bl3 != false);
            if (bl2) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(this.emptyBorder);
            }
            return this;
        }
    }
}

