/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<T>
implements Set<T>,
Cloneable {
    private static final Object PRESENT = Boolean.TRUE;
    private final WeakHashMap<T, Object> map;

    public WeakHashSet() {
        this.map = new WeakHashMap();
    }

    public WeakHashSet(int size2) {
        this.map = new WeakHashMap(size2);
    }

    @Override
    public boolean add(T o) {
        return this.map.put(o, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this.map.keySet().containsAll(coll);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this.map.keySet().removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this.map.keySet().retainAll(coll);
    }

    @Override
    public boolean addAll(Collection<? extends T> coll) {
        boolean added = false;
        for (T i2 : coll) {
            this.add(i2);
            added = true;
        }
        return added;
    }

    @Override
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this.map.keySet().toArray(arr);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Set) {
            Set that = (Set)o;
            if (that.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(that);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 11 * this.map.hashCode();
    }

    public WeakHashSet<T> clone() {
        WeakHashSet<T> newSet = new WeakHashSet<T>(this.map.size());
        newSet.map.putAll(this.map);
        return newSet;
    }

    public String toString() {
        Iterator<T> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            T e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

