/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.srtm;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.function.srtm.SrtmAuthException;
import tim.prune.function.srtm.SrtmSource;
import tim.prune.function.srtm.SrtmTile;

public class SrtmHighResSource
extends SrtmSource {
    private boolean _enabled = true;
    private final String _authString;
    private static final String URL_PREFIX = "https://e4ftl01.cr.usgs.gov/MEASURES/SRTMGL1.003/2000.02.11/";
    private static final String AUTH_HOST = "urs.earthdata.nasa.gov";
    private static final int HTTP_CODE_OK = 200;
    private static final int HTTP_CODE_REDIRECT = 302;
    private static final int HTTP_CODE_NOTFOUND = 404;

    SrtmHighResSource(String string, String string2) {
        super(string);
        this._authString = string2;
    }

    @Override
    public int getTilePixels() {
        return 3601;
    }

    @Override
    public URL getUrl(SrtmTile srtmTile) {
        URL uRL = null;
        try {
            uRL = new URL(URL_PREFIX + this.getFilename(srtmTile));
        }
        catch (MalformedURLException malformedURLException) {}
        return uRL;
    }

    @Override
    public SrtmSource.Result downloadTile(SrtmTile srtmTile) throws SrtmAuthException {
        String string = this.getAuthString();
        if (string == null || !this._enabled) {
            return SrtmSource.Result.NOT_ENABLED;
        }
        try {
            URL uRL = this.getUrl(srtmTile);
            InputStream inputStream = SrtmHighResSource.getResource(uRL, string);
            if (this.writeFileFromStream(uRL, inputStream)) {
                return SrtmSource.Result.DOWNLOADED;
            }
        }
        catch (SrtmAuthException srtmAuthException) {
            this._enabled = false;
            throw srtmAuthException;
        }
        catch (Exception exception) {}
        return SrtmSource.Result.DOWNLOAD_FAILED;
    }

    @Override
    public String getFilename(SrtmTile srtmTile) {
        return String.valueOf(srtmTile.getTileName()) + ".SRTMGL1.hgt.zip";
    }

    private String getAuthString() {
        if (this._authString == null) {
            return null;
        }
        return "Basic " + this._authString;
    }

    private static InputStream getResource(URL uRL, String string) throws Exception {
        int n = 0;
        URL uRL2 = uRL;
        while (n < 10) {
            int n2;
            ++n;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setDoInput(true);
            if (uRL2.getHost().startsWith(AUTH_HOST)) {
                httpURLConnection.setDoOutput(true);
                httpURLConnection.setRequestProperty("Authorization", string);
            }
            if ((n2 = httpURLConnection.getResponseCode()) == 200) {
                return httpURLConnection.getInputStream();
            }
            if (n2 == 302) {
                uRL2 = new URL(httpURLConnection.getHeaderField("Location"));
                continue;
            }
            if (n2 == 404) {
                throw new Exception("SRTM file not found");
            }
            throw new SrtmAuthException(n2);
        }
        throw new Exception("Redirection limit exceeded");
    }
}

