/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.timeline;

import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class DateTick {
    protected static final int MIN_PIXELS = 10;
    private final DateTime min;
    private final DateTime max;
    private final TickPeriod[] tickPeriods;

    public DateTick(DateTime min, DateTime max, DateTimeFieldType[] types) {
        this.min = min;
        this.max = max;
        this.tickPeriods = new TickPeriod[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.tickPeriods[i] = new TickPeriod(min, max, types[i]);
        }
    }

    public static DateTick create(double min, double max, int width) {
        int intervalSize;
        DateTimeFieldType bottomType;
        Period p;
        int intervals;
        DateTime minDate = new DateTime((long)min);
        DateTime maxDate = new DateTime((long)max);
        Period period = new Period((ReadableInstant)minDate, (ReadableInstant)maxDate, PeriodType.yearMonthDayTime());
        int years = period.getYears();
        int months = period.getMonths();
        int days = period.getDays();
        int hours = period.getHours();
        int minutes = period.getMinutes();
        int seconds = period.getSeconds();
        DateTimeFieldType topType = years > 0 ? DateTimeFieldType.year() : (months > 0 ? DateTimeFieldType.monthOfYear() : (days > 0 ? DateTimeFieldType.dayOfMonth() : (hours > 0 ? DateTimeFieldType.hourOfDay() : (minutes > 0 ? DateTimeFieldType.minuteOfHour() : (seconds > 0 ? DateTimeFieldType.secondOfMinute() : DateTimeFieldType.millisOfSecond())))));
        if (topType != DateTimeFieldType.millisOfSecond() && (intervals = (p = new Period((ReadableInstant)minDate, (ReadableInstant)maxDate, PeriodType.forFields((DurationFieldType[])new DurationFieldType[]{(bottomType = topType.equals(DateTimeFieldType.year()) ? DateTimeFieldType.monthOfYear() : (topType.equals(DateTimeFieldType.monthOfYear()) ? DateTimeFieldType.dayOfMonth() : (topType.equals(DateTimeFieldType.dayOfMonth()) ? DateTimeFieldType.hourOfDay() : (topType.equals(DateTimeFieldType.hourOfDay()) ? DateTimeFieldType.minuteOfHour() : (topType.equals(DateTimeFieldType.minuteOfHour()) ? DateTimeFieldType.secondOfMinute() : DateTimeFieldType.millisOfSecond()))))).getDurationType()}))).get(bottomType.getDurationType())) > 0 && (intervalSize = width / intervals) >= 10) {
            return new DateTick(minDate, maxDate, new DateTimeFieldType[]{topType, bottomType});
        }
        return new DateTick(minDate, maxDate, new DateTimeFieldType[]{topType});
    }

    public int getTypeCount() {
        return this.tickPeriods.length;
    }

    public Interval[] getIntervals(int type) {
        return this.tickPeriods[type].getIntervals();
    }

    public String getTickValue(int type, DateTime dateTime) {
        return this.tickPeriods[type].getTickValue(dateTime);
    }

    public DurationFieldType getDurationType(int type) {
        return this.tickPeriods[type].getDurationType();
    }

    public int getTickPixelPosition(long ms, int width) {
        long minMs = this.min.getMillis();
        long maxMs = this.max.getMillis();
        long duration = maxMs - minMs;
        return (int)((ms - minMs) * (long)width / duration);
    }

    private static class TickPeriod {
        protected final DateTime min;
        protected final DateTime max;
        protected final Period period;
        protected final Interval interval;
        protected final DateTimeFieldType type;

        public TickPeriod(DateTime min, DateTime max, DateTimeFieldType type) {
            this.min = min;
            this.max = max;
            this.period = new Period((ReadableInstant)min, (ReadableInstant)max, PeriodType.forFields((DurationFieldType[])new DurationFieldType[]{type.getDurationType()}));
            this.interval = new Interval((ReadableInstant)min, (ReadableInstant)max);
            this.type = type;
        }

        public Interval[] getIntervals() {
            int totalIntervals = this.period.get(this.type.getDurationType()) + 2;
            Interval[] intervals = new Interval[totalIntervals];
            for (int i = 0; i < totalIntervals; ++i) {
                Interval currentInterval = i == 0 ? this.min.property(this.type).toInterval() : this.min.property(this.type).addToCopy(i).property(this.type).toInterval();
                intervals[i] = currentInterval;
            }
            return intervals;
        }

        public int getIntervalCount() {
            return this.period.get(this.type.getDurationType());
        }

        public String getTickValue(DateTime dateTime) {
            return dateTime.property(this.type).getAsShortText();
        }

        public DurationFieldType getDurationType() {
            return this.type.getDurationType();
        }
    }
}

