/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.curve.opengl;

import com.jogamp.graph.curve.Region;
import com.jogamp.math.Vec4f;
import com.jogamp.math.geom.Frustum;
import com.jogamp.math.util.PMVMatrix4f;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.FloatBuffer;
import jogamp.common.os.PlatformPropsImpl;

public class RenderState {
    private static final String thisKey = "jogamp.graph.curve.RenderState";
    public static final int BITHINT_BLENDING_ENABLED = 1;
    public static final int BITHINT_GLOBAL_DEPTH_TEST_ENABLED = 2;
    public static final int DEBUG_LINESTRIP = 1;
    private final int id = RenderState.getNextID();
    private final PMVMatrix4f pmvMatrix;
    private final float[] weight;
    private final FloatBuffer weightBuffer;
    private final float[] colorStatic;
    private final FloatBuffer colorStaticBuffer;
    private int aaQuality;
    private int sampleCount;
    private final Frustum clipFrustum;
    private boolean useClipFrustum;
    private int hintBits;
    private int debugBits;
    private ShaderProgram sp;
    private static int nextID = 1;

    public static final RenderState getRenderState(GL2ES2 gL2ES2) {
        return (RenderState)gL2ES2.getContext().getAttachedObject(thisKey);
    }

    private static synchronized int getNextID() {
        return nextID++;
    }

    RenderState(PMVMatrix4f pMVMatrix4f) {
        this.pmvMatrix = null != pMVMatrix4f ? pMVMatrix4f : new PMVMatrix4f();
        this.weight = new float[1];
        this.weightBuffer = FloatBuffer.wrap(this.weight);
        this.colorStatic = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.colorStaticBuffer = FloatBuffer.wrap(this.colorStatic);
        this.aaQuality = 1;
        this.sampleCount = 4;
        this.clipFrustum = new Frustum();
        this.useClipFrustum = false;
        this.hintBits = 0;
        this.debugBits = 0;
        this.sp = null;
    }

    public final int id() {
        return this.id;
    }

    public final ShaderProgram getShaderProgram() {
        return this.sp;
    }

    public final boolean isShaderProgramInUse() {
        return null != this.sp ? this.sp.inUse() : false;
    }

    public final boolean setShaderProgram(GL2ES2 gL2ES2, ShaderProgram shaderProgram) {
        if (shaderProgram.equals(this.sp)) {
            shaderProgram.useProgram(gL2ES2, true);
            return false;
        }
        if (null != this.sp) {
            this.sp.notifyNotInUse();
        }
        this.sp = shaderProgram;
        shaderProgram.useProgram(gL2ES2, true);
        return true;
    }

    public final PMVMatrix4f getMatrix() {
        return this.pmvMatrix;
    }

    public static boolean isWeightValid(float f) {
        return 0.0f <= f && f <= 1.9f;
    }

    public final float getWeight() {
        return this.weight[0];
    }

    public final void setWeight(float f) {
        if (!RenderState.isWeightValid(f)) {
            throw new IllegalArgumentException("Weight out of range");
        }
        this.weight[0] = f;
    }

    public final Vec4f getColorStatic(Vec4f vec4f) {
        return vec4f.set(this.colorStatic);
    }

    public final void setColorStatic(Vec4f vec4f) {
        this.colorStatic[0] = vec4f.x();
        this.colorStatic[1] = vec4f.y();
        this.colorStatic[2] = vec4f.z();
        this.colorStatic[3] = vec4f.w();
    }

    public final void setColorStatic(float f, float f2, float f3, float f4) {
        this.colorStatic[0] = f;
        this.colorStatic[1] = f2;
        this.colorStatic[2] = f3;
        this.colorStatic[3] = f4;
    }

    public final int setAAQuality(int n) {
        int n2;
        this.aaQuality = n2 = Region.clipAAQuality(n);
        return n2;
    }

    public final int getAAQuality() {
        return this.aaQuality;
    }

    public final int setSampleCount(int n) {
        int n2;
        this.sampleCount = n2 = Region.clipAASampleCount(n);
        return n2;
    }

    public final int getSampleCount() {
        return this.sampleCount;
    }

    public final void setClipFrustum(Frustum frustum) {
        if (null != frustum) {
            this.clipFrustum.set(frustum);
            this.useClipFrustum = true;
        } else {
            this.useClipFrustum = false;
        }
    }

    public final Frustum getClipFrustum() {
        return this.useClipFrustum ? this.clipFrustum : null;
    }

    public final int getHintBits() {
        return this.hintBits;
    }

    public final boolean hintBitsSet(int n) {
        return n == (this.hintBits & n);
    }

    public final void setHintBits(int n) {
        this.hintBits |= n;
    }

    public final void clearHintBits(int n) {
        this.hintBits &= ~n;
    }

    public final int getDebugBits() {
        return this.debugBits;
    }

    public final boolean debugBitsSet(int n) {
        return n == (this.debugBits & n);
    }

    public final void setDebugBits(int n) {
        this.debugBits |= n;
    }

    public final void clearDebugBits(int n) {
        this.debugBits &= ~n;
    }

    public final boolean updateUniformLoc(GL2ES2 gL2ES2, boolean bl, GLUniformData gLUniformData, boolean bl2) {
        if (bl || 0 > gLUniformData.getLocation()) {
            boolean bl3;
            boolean bl4 = bl3 = 0 <= gLUniformData.setLocation(gL2ES2, this.sp.program());
            if (bl2 && !bl3) {
                this.sp.dumpSource(System.err);
                throw new GLException("Could not locate " + gLUniformData.getName() + " in " + this.sp + ", " + gLUniformData);
            }
            return bl3;
        }
        return true;
    }

    public final boolean updateUniformDataLoc(GL2ES2 gL2ES2, boolean bl, boolean bl2, GLUniformData gLUniformData, boolean bl3) {
        boolean bl4 = bl = bl || 0 > gLUniformData.getLocation();
        if (bl) {
            boolean bl5 = bl2 = 0 <= gLUniformData.setLocation(gL2ES2, this.sp.program());
            if (bl3 && !bl2) {
                this.sp.dumpSource(System.err);
                throw new GLException("Could not locate " + gLUniformData.getName() + " in " + this.sp + ", " + gLUniformData);
            }
        }
        if (bl2) {
            gL2ES2.glUniform(gLUniformData);
            return true;
        }
        return !bl;
    }

    public final boolean updateAttributeLoc(GL2ES2 gL2ES2, boolean bl, GLArrayDataWrapper gLArrayDataWrapper, boolean bl2) {
        if (bl || 0 > gLArrayDataWrapper.getLocation()) {
            boolean bl3;
            boolean bl4 = bl3 = 0 <= gLArrayDataWrapper.setLocation(gL2ES2, this.sp.program());
            if (bl2 && !bl3) {
                this.sp.dumpSource(System.err);
                throw new GLException("Could not locate " + gLArrayDataWrapper.getName() + " in " + this.sp + ", " + gLArrayDataWrapper);
            }
            return bl3;
        }
        return true;
    }

    void destroy() {
        this.sp = null;
    }

    public final RenderState attachTo(GL2ES2 gL2ES2) {
        return (RenderState)gL2ES2.getContext().attachObject(thisKey, this);
    }

    public final boolean detachFrom(GL2ES2 gL2ES2) {
        RenderState renderState = (RenderState)gL2ES2.getContext().getAttachedObject(thisKey);
        if (renderState == this) {
            gL2ES2.getContext().detachObject(thisKey);
            return true;
        }
        return false;
    }

    public String toString() {
        return "RenderState[" + this.sp + "]";
    }

    public static class ProgramLocal {
        public final GLUniformData gcu_PMVMatrix01 = GLUniformData.creatEmptyMatrix("gcu_PMVMatrix01", 4, 4);
        public final GLUniformData gcu_Weight = GLUniformData.creatEmptyVector("gcu_Weight", 1);
        public final GLUniformData gcu_ColorStatic = GLUniformData.creatEmptyVector("gcu_ColorStatic", 4);
        private int rsId = -1;

        public final int getRenderStateId() {
            return this.rsId;
        }

        public final boolean update(GL2ES2 gL2ES2, RenderState renderState, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) {
            if (renderState.id() != this.rsId) {
                this.gcu_PMVMatrix01.setData(renderState.pmvMatrix.getSyncPMv());
                this.gcu_Weight.setData(renderState.weightBuffer);
                this.gcu_ColorStatic.setData(renderState.colorStaticBuffer);
                this.rsId = renderState.id();
            }
            boolean bl5 = true;
            if (null != renderState.sp && renderState.sp.inUse()) {
                boolean bl6;
                if (bl2) {
                    bl6 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_PMVMatrix01, bl4);
                    boolean bl7 = bl5 = bl5 && bl6;
                }
                if (bl3) {
                    if (Region.hasVariableWeight(n)) {
                        bl6 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_Weight, bl4);
                        bl5 = bl5 && bl6;
                    }
                    bl6 = renderState.updateUniformDataLoc(gL2ES2, bl, true, this.gcu_ColorStatic, bl4);
                    bl5 = bl5 && bl6;
                }
            }
            return bl5;
        }

        public StringBuilder toString(StringBuilder stringBuilder, boolean bl) {
            if (null == stringBuilder) {
                stringBuilder = new StringBuilder();
            }
            stringBuilder.append("ProgramLocal[rsID ").append(this.rsId).append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(this.gcu_PMVMatrix01).append(", ").append(PlatformPropsImpl.NEWLINE);
            stringBuilder.append(this.gcu_ColorStatic).append(", ");
            stringBuilder.append(this.gcu_Weight).append("]");
            return stringBuilder;
        }

        public String toString() {
            return this.toString(null, false).toString();
        }
    }
}

