// generated by Fast Light User Interface Designer (fluid) version 1.0404

#include "MasterUI.h"
// MasterUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2026, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.
#include "Misc/FileMgrFuncs.h"
    using file::isRegularFile;
    using file::findLeafName;
#include "Misc/FormatFuncs.h"
    using func::string2uint;
    using func::asString;
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }
using std::to_string;
int lineitem;
int effDisplayType;

void FilerLine::cb_nametop_i(Fl_Button*, void*) {
  //
              lineitem = n;
}
void FilerLine::cb_nametop(Fl_Button* o, void* v) {
  ((FilerLine*)(o->parent()->user_data()))->cb_nametop_i(o,v);
}

Fl_Group* FilerLine::make_window() {
  { filerlist = new Fl_Group(0, 0, 440, 20);
    filerlist->box(FL_FLAT_BOX);
    filerlist->color(FL_BACKGROUND2_COLOR);
    filerlist->selection_color(FL_BACKGROUND_COLOR);
    filerlist->labeltype(FL_NO_LABEL);
    filerlist->labelfont(0);
    filerlist->labelsize(14);
    filerlist->labelcolor(FL_FOREGROUND_COLOR);
    filerlist->user_data((void*)(this));
    filerlist->align(Fl_Align(FL_ALIGN_TOP));
    filerlist->when(FL_WHEN_RELEASE);
    { fileIcon = new Fl_Group(0, 0, 23, 30);
      fileIcon->box(FL_FLAT_BOX);
      fileIcon->color(FL_BACKGROUND2_COLOR);
      { outer_box = new Fl_Box(3, 0, 16, 20);
        outer_box->box(FL_GTK_THIN_UP_BOX);
        outer_box->color((Fl_Color)174);
        outer_box->labeltype(FL_NO_LABEL);
      } // Fl_Box* outer_box
      { inner_box = new Fl_Box(5, 2, 12, 16);
        inner_box->box(FL_GTK_THIN_DOWN_BOX);
        inner_box->color((Fl_Color)174);
        inner_box->labeltype(FL_NO_LABEL);
      } // Fl_Box* inner_box
      { line1 = new Fl_Box(7, 5, 8, 2);
        line1->box(FL_FLAT_BOX);
        line1->color((Fl_Color)124);
      } // Fl_Box* line1
      { line2 = new Fl_Box(7, 9, 8, 2);
        line2->box(FL_FLAT_BOX);
        line2->color((Fl_Color)124);
      } // Fl_Box* line2
      { type = new Fl_Box(4, 6, 15, 17, "xiz");
        type->labelsize(4);
      } // Fl_Box* type
      fileIcon->end();
    } // Fl_Group* fileIcon
    { dirIcon = new Fl_Group(0, 0, 21, 20);
      dirIcon->box(FL_FLAT_BOX);
      dirIcon->color(FL_BACKGROUND2_COLOR);
      dirIcon->hide();
      { Fl_Box* o = new Fl_Box(1, 1, 18, 15);
        o->box(FL_PLASTIC_THIN_UP_BOX);
        o->color((Fl_Color)183);
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(3, 4, 18, 16);
        o->box(FL_PLASTIC_THIN_UP_BOX);
        o->color((Fl_Color)183);
      } // Fl_Box* o
      { Fl_Box* o = new Fl_Box(5, 7, 14, 1);
        o->box(FL_DOWN_BOX);
      } // Fl_Box* o
      dirIcon->end();
    } // Fl_Group* dirIcon
    { name = new Fl_Button(25, 0, 415, 21);
      name->box(FL_NO_BOX);
      name->color(FL_BACKGROUND2_COLOR);
      name->labelsize(12);
      name->labelcolor((Fl_Color)64);
      name->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
    } // Fl_Button* name
    { nametop = new Fl_Button(0, 1, 420, 18);
      nametop->box(FL_NO_BOX);
      nametop->labelcolor((Fl_Color)64);
      nametop->callback((Fl_Callback*)cb_nametop);
    } // Fl_Button* nametop
    filerlist->end();
  } // Fl_Group* filerlist
  return filerlist;
}

FilerLine::FilerLine(int x, int y, int w, int h, const char *label):Fl_Group(x,y,w,h,label) {
  n = 0;
}

void FilerLine::init(SynthEngine *synth_, int n_, bool isDir_, string typeName_, string title_) {
  //

      synth = synth_;
      n = n_;
      isDir = isDir_;
      typeName = typeName_;
      title = title_;
      make_window();
      if (isDir)
      {
          dirIcon->show();
          fileIcon->hide();
      }
      else
      {
          dirIcon->hide();
          fileIcon->show();
          type->copy_label(typeName.c_str());
          name->copy_label(title.c_str());
      }
      show();
      end();
}

FilerLine::~FilerLine() {
  //
      filerlist->hide();
      delete (filerlist);
}

KeyHandle::KeyHandle(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
}

void KeyHandle::init(SynthEngine *_synth) {
  //
          synth = _synth;
}

int KeyHandle::handle(int event) {
  //
      int ev = 0;
      if (event == FL_FOCUS)
          ev = 1;
      else if (event == FL_UNFOCUS)
          ev = 1;
      else if (event == FL_SHORTCUT)
      {
          auto key = Fl::event_key();
          if (key == FL_Escape)
              ev = 1;
          else if (key == 'z')
          {
              if (Fl::event_state() == 327680) //ctrl + shift
              {
                  synth->getGuiMaster()->redo->do_callback();
                  ev = 1;
              }
               else if (Fl::event_ctrl())
               {
                   synth->getGuiMaster()->undo->do_callback();
                   ev = 1;
               }
          }
          /*else if (Fl::event_alt()) // apparently not needed!
          {
              switch (key)
              {
                  case 'r':
                  {
                      synth->getGuiMaster()->redo->do_callback();
                      ev = 1;
                      break;
                  }
                  case 'u':
                  {
                      synth->getGuiMaster()->undo->do_callback();
                      ev = 1;
                      break;
                  }
              }
          }*/
      }
      return ev;
}

void MasterUI::cb_masterwindow_i(ScaleTrackedWindow*, void*) {
  //
              if (instrumentsWarning("Still exit"))
              {
                  return;
              }
              bool close = true;
              bool force = Fl::event_state(FL_CTRL);
              if (close)
              {
                  if (force)
                      Config::primary().exitType = FORCED_EXIT;
                      /*
                      * The above line shouldn't be necessary!
                      * It works fine on jack but fails on ALSA.
                      * My best guess is that ALSA shuts down so quickly
                      * that one of the ringbuffers carrying the command
                      * is deleted before it can be read.
                      */
                      //send_data(0, TOPLEVEL::control::forceExit, 0, UNUSED);

                  synth->signalGuiWindowClosed();
              }
}
void MasterUI::cb_masterwindow(ScaleTrackedWindow* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_masterwindow_i(o,v);
}

void MasterUI::cb_mastermenu_i(Fl_Menu_Bar* o, void*) {
  //
      int found = o->value();
      //std::cout << "switch found " << found << std::endl;
      switch (found)
          {
          case 1: // about
              {
              int X, Y, W, H, O;
              loadWin(synth, W, H, X, Y, O, "Master-about");
              if (W < aboutDW || H < aboutDH)
              {
                  W = aboutDW;
                  H = aboutDH;
              }
              checkSane(X, Y, W, H, aboutDW, aboutDH);
              aboutwindow->resize(X, Y, W, H);
              aboutwindow->show();
              }
              break;
          case 2: // new instance
              if (synth->getRuntime().isLV2)
              {
                  query("", "", "", "Start new instances from host");
                  return;
              }
              if (current_ID != 0)
              {
                  query("", "", "", "Only main instance can start others");
                  return;
              }
              startInstance();
              break;
          case 3: // settings
              configui->Show(synth);
              break;
          case 4: // reports
              if (logenable)
                  yoshiLog->Show(synth);
              else
                  alert(synth, "Logging configured for std::cout");
              break;
          case 5: // manual
              send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::openManual, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
              break;
          case 6: // exit
              masterwindow->do_callback();
              break;

          case 7: // section instruments
              break;
          case 8: // section instruments
              break;
          case 9: // show
              bankui->Show();
              break;
          case 10: // load
              {
                  if (instrumentSingleWarning(npart, "Overwrite"))
                  {
                      return;
                  }
                  string filename = setfiler("", "", false, TOPLEVEL::XML::Instrument);
                  if (!filename.empty())
                      do_load_instrument(filename);
              }
              break;
          case 11: // save
              {
              /*
              * Instruments are an exception for saving as we always want
              * to offer the INTERNAL name first rather than a possibly
              * confusing external filename.
              */
              string newname = synth->part[npart]->Pname;
              if (newname == DEFAULT_NAME)
              {
                  query("", "", "", "Nothing to save!");
                  return;
              }
              if (synth->part[npart]->info.Ptype == 0)
              {
                  if (choice(synth, "", "Save", "Cancel", "Please set instrument type before saving.\nCopyright info also recommended.") != 2)
                      return;
              }
              string filename = setfiler("", newname, true, TOPLEVEL::XML::Instrument);
              if (!filename.empty())
                  send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::saveNamedInstrument, npart, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(string(filename)));
              }
              break;
          case 12: // recent
              {
                  if (instrumentSingleWarning(npart, "Overwrite"))
                  {
                      return;
                  }
              int xpos = masterwindow->x() + (masterwindow->w() * 0.15f);
              if (xpos + paramsui->Recent->w() > masterwindow->x() + masterwindow->w())
                  xpos = masterwindow->x() + masterwindow->w() - paramsui->Recent->w();
              paramsui->Recent->position(xpos,masterwindow->y()+20);
              paramsui->Show(TOPLEVEL::XML::Instrument);
              }
              break;
          case 13: // clear
          if (!fetchData(0, PART::control::enable, npart))
              {
                  alert(synth, "Active part disabled");
                  return;
              }
              partui->instrumentReset->do_callback();
              break;
          case 14: // search
              if (instrumentSingleWarning(npart, "Overwrite"))
              {
                  return;
              }
          if (!fetchData(0, PART::control::enable, npart))
              {
                  alert(synth, "Active part disabled");
                  return;
              }
              bankui->ShowSearch();
              break;

          case 15: // section parameters
              break;
          case 16: // section parameters
              break;
          case 17: // show
              bankui->Showbank();
              break;
          case 18: // load
              if (instrumentsWarning("Overwrite"))
              {
                  return;
              }
               do_load_master("");
              break;
          case 19: // save
              {
                  bool valid = false;
                  for (int npart = 0; npart < NUM_MIDI_PARTS; npart ++)
                  if (synth->part[npart]->Pname != DEFAULT_NAME)
                  {
                      valid = true;
                      npart = NUM_MIDI_PARTS;
                  }
                  if (valid)
                      do_save_master();
                  else
                      query("", "", "", "Nothing to save!");
              }
              break;
          case 20: // recent
              {
                  if (instrumentsWarning("Overwrite"))
                  {
                      return;
                  }
                  int xpos = masterwindow->x() + (masterwindow->w() * 0.35f);
                  if (xpos + paramsui->Recent->w() > masterwindow->x() + masterwindow->w())
                      xpos = masterwindow->x() + masterwindow->w() - paramsui->Recent->w();
                  paramsui->Recent->position(xpos,masterwindow->y()+20);
                  paramsui->Show(TOPLEVEL::XML::Patch);
              }
              break;

          case 21: // section paths
              break;
          case 22: // section paths
              break;
          case 23: // root dir
              bankui->ShowRoot();
              break;
          case 24: // preset dir
              configui->Showpresets(synth);
              break;

          case 25: // section state
              break;
          case 26: // section state
              break;

          case 27: // load
              {
                  if (instrumentsWarning("Overwrite"))
                  {
                       return;
                  }
                  // for Alessandro
                  string filename = setfiler("", "", false, TOPLEVEL::XML::State);
                  if (!filename.empty())
                  {
                      setState(filename);
                  }
                  else
                      refresh_master_ui(0x80 | (textMsgBuffer.push(" ") << 8));
              }
              break;
          case 28: // save
              {
              // for Alessandro
                  string filename = setfiler("", "", true, TOPLEVEL::XML::State);
                  if (!filename.empty())
                  {
                      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::saveNamedState, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(filename));
                  }
              }
              break;
          case 29: // default
              {
                  string name = synth->getRuntime().defaultSession;
                  send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::saveNamedState, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(name));
              }
              break;
          case 30: // recent
              {
                  if (instrumentsWarning("Overwrite"))
                      return;
                  int xpos = masterwindow->x() + (masterwindow->w() * 0.616f);
                  if (xpos + paramsui->Recent->w() > masterwindow->x() + masterwindow->w())
                      xpos = masterwindow->x() + masterwindow->w() - paramsui->Recent->w();
                  paramsui->Recent->position(xpos,masterwindow->y()+20);

                  paramsui->Show(TOPLEVEL::XML::State);
              }
              break;

          case 31: // section scales
              break;
          case 32: // section scales
              break;
          case 33: // show
              microtonalui->showScales();
              break;
          case 34: // load
              {
                  filename = setfiler("", "", false, TOPLEVEL::XML::Scale);
                  if (!filename.empty())
                      do_load_scale(string(filename));
              }
              break;
          case 35: // save
              {
                  string filename = setfiler("", "", true, TOPLEVEL::XML::Scale);
                  if (!filename.empty())
                      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::saveNamedScale, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(filename));
              }
              break;
          case 36: // recent
              paramsui->Recent->position(masterwindow->x() + masterwindow->w() - paramsui->Recent->w(), masterwindow->y()+20);
              paramsui->Show(TOPLEVEL::XML::Scale);
              break;
          case 37: // clear
              if (query("", "Yes", "No", "Set scales to the defaults?") > 1)
              {
                  synth->microtonal.defaults();
                  synth->setAllPartMaps();
                  if (NULL != microtonalui)
                      delete microtonalui;
                  microtonalui = new MicrotonalUI(&synth->microtonal, synth);
                  send_data(TOPLEVEL::action::forceUpdate, SCALES::control::clearAll, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::scales);
              }
              break;
        }
}
void MasterUI::cb_mastermenu(Fl_Menu_Bar* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_mastermenu_i(o,v);
}

void MasterUI::cb_mainreset_i(Fl_Button*, void*) {
  //
            bool wasCtrl = (Fl::event_state(FL_CTRL) != 0);
            if (query("", "Yes", "No", "Set *ALL* dynamic values to their defaults?") > 1)
            {
                if (instrumentsWarning("Still reset"))
                    return;

                if (wasCtrl || (Fl::event_state(FL_CTRL) != 0))
                    send_data(TOPLEVEL::action::muteAndLoop | TOPLEVEL::action::forceUpdate, MAIN::control::masterResetAndMlearn, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
                else
                    send_data(TOPLEVEL::action::muteAndLoop | TOPLEVEL::action::forceUpdate, MAIN::control::masterReset, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);}
}
void MasterUI::cb_mainreset(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mainreset_i(o,v);
}

void MasterUI::cb_mainstop_i(Fl_Button*, void*) {
  //
                  send_data(TOPLEVEL::action::muteAndLoop, MAIN::control::stopSound, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_mainstop(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mainstop_i(o,v);
}

void MasterUI::cb_mainvirtkeyb_i(Fl_Button*, void*) {
  //
                  virkeyboard->ShowKbd();
}
void MasterUI::cb_mainvirtkeyb(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mainvirtkeyb_i(o,v);
}

void MasterUI::cb_mixerpanel_i(Fl_Button*, void*) {
  //
                  if(panelwindow->visible())
                      return;
                  panelType &= 3;
                  changepanelstyle(panelType);
                  updatepanel();
            ;
}
void MasterUI::cb_mixerpanel(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mixerpanel_i(o,v);
}

void MasterUI::cb_mainmidilearn_i(Fl_Button*, void*) {
  //
                  midilearnui->showLearn();
}
void MasterUI::cb_mainmidilearn(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mainmidilearn_i(o,v);
}

void MasterUI::cb_vectors_i(Fl_Button*, void*) {
  //
                  vectorui->Show(synth);
}
void MasterUI::cb_vectors(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_vectors_i(o,v);
}

void MasterUI::cb_undo_i(Fl_Button*, void*) {
  //
                  send_data(0, MAIN::control::undo,  0, TOPLEVEL::type::Integer, TOPLEVEL::section::undoMark);
}
void MasterUI::cb_undo(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_undo_i(o,v);
}

void MasterUI::cb_redo_i(Fl_Button*, void*) {
  //
                  send_data(0, MAIN::control::redo,  0, TOPLEVEL::type::Integer, TOPLEVEL::section::undoMark);
}
void MasterUI::cb_redo(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_redo_i(o,v);
}

void MasterUI::cb_globalfinedetune_i(WidgetPDial* o, void*) {
  //
            o->selection_color(setKnob(o->value(),64));
            send_data(TOPLEVEL::action::lowPrio, MAIN::control::detune, o->value(), 0, TOPLEVEL::section::main);
}
void MasterUI::cb_globalfinedetune(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_globalfinedetune_i(o,v);
}

void MasterUI::cb_mastervolumedial_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),90));
                  send_data(0, MAIN::control::volume, o->value(), 0, TOPLEVEL::section::main);
}
void MasterUI::cb_mastervolumedial(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_mastervolumedial_i(o,v);
}

void MasterUI::cb_masterkeyshift_i(WidgetSpinner* o, void*) {
  //
          send_data(TOPLEVEL::action::lowPrio, MAIN::control::keyShift, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_masterkeyshift(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_masterkeyshift_i(o,v);
}

void MasterUI::cb_bpmfallback_i(WidgetSpinner* o, void*) {
  //
          send_data(TOPLEVEL::action::forceUpdate, MAIN::control::bpmFallback, o->value(), 0, TOPLEVEL::section::main);
}
void MasterUI::cb_bpmfallback(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_bpmfallback_i(o,v);
}

void MasterUI::cb_sysDisplay_i(Fl_Button* o, void*) {
  //
  	o->color(223);
  	insDisplay->color(49);

  	InsertionEffectsGrp->hide();
  	SystemEffectsGrp->show();

  	inseffectuigroup->hide();
  	syseffectuigroup->show();
  	syseffectui->refresh();

  	effDisplayType = 0;
}
void MasterUI::cb_sysDisplay(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_sysDisplay_i(o,v);
}

void MasterUI::cb_insDisplay_i(Fl_Button* o, void*) {
  //
  	o->color(223);
  	sysDisplay->color(49);

  	SystemEffectsGrp->hide();
  	InsertionEffectsGrp->show();

  	syseffectuigroup->hide();
  	inseffectuigroup->show();
  	inseffectui->refresh();

  	effDisplayType = 1;
}
void MasterUI::cb_insDisplay(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_insDisplay_i(o,v);
}

void MasterUI::cb_syseffnocounter_i(WidgetSpinner* o, void*) {
  //
                  int effNum = o->value() - 1;
                  send_data(TOPLEVEL::action::forceUpdate, EFFECT::sysIns::effectNumber, effNum, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects, effNum);
}
void MasterUI::cb_syseffnocounter(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_syseffnocounter_i(o,v);
}

void MasterUI::cb_sysefftype_i(Fl_Choice* o, void*) {
  //
                  uchar effType = o->value();
                  uchar effNum = syseffectui->effNum();
                  send_data(TOPLEVEL::action::forceUpdate, EFFECT::sysIns::effectType, effType, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects, effNum);
                  // update sys-effect enabled checkbox as immediate feedback
                  // the next push-update will then set it so to reflect the actual activation state in the core
                  SysEffOn->value(effType != 0);
}
void MasterUI::cb_sysefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_sysefftype_i(o,v);
}

void MasterUI::cb_SysEffOn_i(Fl_Check_Button2* o, void*) {
  //
                  /*if (o->value())
                  {
                      sysCopy->activate();
                      sysPaste->activate();
                  }
                  else
                  {
                      // note: the effect-type select box remains enabled
                      sysCopy->deactivate();
                      sysPaste->deactivate();
                  }*/
                  uchar effNum = syseffectui->effNum();
                  send_data(0, EFFECT::sysIns::effectEnable, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects, effNum);
}
void MasterUI::cb_SysEffOn(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_SysEffOn_i(o,v);
}

void MasterUI::cb_sysEffSend_i(Fl_Button*, void*) {
  showSysEffSends();
}
void MasterUI::cb_sysEffSend(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_sysEffSend_i(o,v);
}

void MasterUI::cb_sysCopy_i(Fl_Button*, void*) {
  //
                  uchar effNum = syseffectui->effNum();
                  synth->getGuiMaster()->getPresetsUi()->Ucopy(TOPLEVEL::section::systemEffects, 16, effNum);
}
void MasterUI::cb_sysCopy(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_sysCopy_i(o,v);
}

void MasterUI::cb_sysPaste_i(Fl_Button*, void*) {
  //
                  uchar effNum = syseffectui->effNum();
                  synth->getGuiMaster()->getPresetsUi()->Upaste(TOPLEVEL::section::systemEffects, 16, effNum);
}
void MasterUI::cb_sysPaste(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_sysPaste_i(o,v);
}

void MasterUI::cb_inseffnocounter_i(WidgetSpinner* o, void*) {
  //
                  int effNum = o->value() - 1;
                  send_data(TOPLEVEL::action::forceUpdate, EFFECT::sysIns::effectNumber, effNum, TOPLEVEL::type::Integer, TOPLEVEL::section::insertEffects, effNum);
}
void MasterUI::cb_inseffnocounter(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_inseffnocounter_i(o,v);
}

void MasterUI::cb_insefftype_i(Fl_Choice* o, void*) {
  //
                  uchar effType = o->value();
                  uchar effNum = inseffectui->effNum();
                  send_data(TOPLEVEL::action::forceUpdate, EFFECT::sysIns::effectType, effType, TOPLEVEL::type::Integer, TOPLEVEL::section::insertEffects, effNum);
                  // note: when processing this in InterChange, an insertion destination is automatically pre-selected;
}
void MasterUI::cb_insefftype(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_insefftype_i(o,v);
}

void MasterUI::cb_inseffpart_i(Fl_Choice* o, void*) {
  //
                  int routing = o->value() - 2;
                  uchar effNum = inseffectui->effNum();
                  send_data(TOPLEVEL::action::forceUpdate, EFFECT::sysIns::effectDestination, routing, TOPLEVEL::type::Integer, TOPLEVEL::section::insertEffects, effNum);
}
void MasterUI::cb_inseffpart(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_inseffpart_i(o,v);
}

void MasterUI::cb_insCopy_i(Fl_Button*, void*) {
  //
                  uchar effNum = inseffectui->effNum();
                  synth->getGuiMaster()->getPresetsUi()->Ucopy(TOPLEVEL::section::insertEffects, 16, effNum);
}
void MasterUI::cb_insCopy(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_insCopy_i(o,v);
}

void MasterUI::cb_insPaste_i(Fl_Button*, void*) {
  //
                  uchar effNum = inseffectui->effNum();
                  synth->getGuiMaster()->getPresetsUi()->Upaste(TOPLEVEL::section::insertEffects, 16, effNum);
}
void MasterUI::cb_insPaste(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_insPaste_i(o,v);
}

void MasterUI::cb_partVol_i(WidgetPDial* o, void*) {
  //
                  if (npart >= panelgroup && npart < (panelgroup + NUM_MIDI_CHANNELS))
                      o->selection_color(setKnob(o->value(),96));
                  setPanelPartVolWidget(npart % NUM_MIDI_CHANNELS, o->value());

                  send_data(0, PART::control::volume, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partVol(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partVol_i(o,v);
}

void MasterUI::cb_partPan_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));

                  send_data(TOPLEVEL::action::forceUpdate, PART::control::panning, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partPan(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partPan_i(o,v);
}

void MasterUI::cb_partVelOffset_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, PART::control::velocityOffset, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partVelOffset(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partVelOffset_i(o,v);
}

void MasterUI::cb_partVelSense_i(WidgetPDial* o, void*) {
  //
                  o->selection_color(setKnob(o->value(),64));
                  send_data(0, PART::control::velocitySense, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partVelSense(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partVelSense_i(o,v);
}

void MasterUI::cb_buttontop_i(Fl_Button*, void*) {
  //
            int event = Fl::event_button();
            if (event == FL_LEFT_MOUSE)
            {
                bankui->Show();
            }
            else if (event == FL_RIGHT_MOUSE)
            {
                string name = input_text(synth, "Instrument name:", synth->part[npart]->Pname);
                if (name == DEFAULT_NAME)
                    alert(synth, "Can't use name of default sound");
                else if (name != synth->part[npart]->Pname)
                {
                    unsigned char id = textMsgBuffer.push(name);
                    send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, PART::control::instrumentName, 0, TOPLEVEL::type::Integer, npart, UNUSED, UNUSED, UNUSED, id);
                }
            }
}
void MasterUI::cb_buttontop(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_buttontop_i(o,v);
}

void MasterUI::cb_partMidiCh_i(WidgetSpinner* o, void*) {
  //
                  int tmp = int(o->value()) -1;
                  if (tmp >= NUM_MIDI_CHANNELS)
                  {
                      tmp &= (NUM_MIDI_CHANNELS - 1);
                      o->value(tmp +1);
                  }
                  o->textcolor(gen_text);
                  if (npart >= panelgroup && npart < (panelgroup + NUM_MIDI_CHANNELS))
                      setPanelPartMidiWidget(npart % NUM_MIDI_CHANNELS, tmp);

                  send_data(0, PART::control::midiChannel, tmp, TOPLEVEL::type::Integer, npart);
                  ;
}
void MasterUI::cb_partMidiCh(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partMidiCh_i(o,v);
}

void MasterUI::cb_partEdit_i(Fl_Button*, void*) {
  //
         /* bool divert = true;
          if (lastkey >= 49 && lastkey <= 56)
          { // not working yet :(
              int voiceNum = lastkey - 49;
              if (Fl::event_button() == 3)
              {
                  send_data(0, PART::control::enable, 1, TOPLEVEL::type::Integer, UNUSED, 0);
                  adsynenabledcheck->value(1);
                  send_data(TOPLEVEL::action::forceUpdate, PART::control::volumeEnable, voiceNum, TOPLEVEL::type::Integer);
                  //synth->getGuiMaster()->partui->adnoteui->advoice->nvoice = voiceNum;
                  //synth->getGuiMaster()->partui->adnoteui->advoice->voiceonbutton->value(1);
              }
              if (adsynenabledcheck->value() == 1)
              {
                  ;
              }
              lastkey = -1;
          }
          switch(lastkey)
          {
              case 97: // a
                  if (Fl::event_button() == 3)
                  {
                      send_data(0, PART::control::enableAdd, 1, TOPLEVEL::type::Integer, UNUSED, 0);
                      adsynenabledcheck->value(1);
                  }

                  lastkey = -1;
                  if (adsynenabledcheck->value() == 1)
                  {
                      showparameters(0,0);
                      partui->checkEngines();
                      seteditname();
                  }
                  else
                      divert = false;
                  break;
              case 115: // s
                  if (Fl::event_button() == 3)
                  {
                      send_data(0, PART::control::enableSub, 1, TOPLEVEL::type::Integer, UNUSED, 1);
                      subsynenabledcheck->value(1);
                  }
                  lastkey = -1;
                  if (subsynenabledcheck->value() == 1)
                  {
                  showparameters(0,1);
                  partui->checkEngines();
                  seteditname();
                  }
                  else
                      divert = false;
                  break;
              case 100: // d
              case 112: // p
                  if (Fl::event_button() == 3)
                  {
                      send_data(0, PART::control::enablePad, 1, TOPLEVEL::type::Integer, UNUSED, 2);
                      padsynenabledcheck->value(1);
                  }
                  lastkey = -1;
                  if (padsynenabledcheck->value() == 1)
                  {
                      showparameters(0,2);
                      partui->checkEngines();
                      seteditname();
                      lastkey = -1;
                  }
                  else
                      divert = false;
                  break;
              case 107: // k
                  lastkey = -1;
                  Showkit();
                  break;
              case 101: // e
                  lastkey = -1;
                  Showefx();
                  break;
              default:
                  divert = false;
                  break;
          }
          */
          //if (!divert)
          //{
              //lastkey = -1;
              partui->Showedit();
         // }
}
void MasterUI::cb_partEdit(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partEdit_i(o,v);
}

void MasterUI::cb_partControllers_i(Fl_Button*, void*) {
  //
            partui->Showctl();
}
void MasterUI::cb_partControllers(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partControllers_i(o,v);
}

void MasterUI::cb_partMidiCCs_i(Fl_Button*, void*) {
  //
            partui->Showctlmidi();
}
void MasterUI::cb_partMidiCCs(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partMidiCCs_i(o,v);
}

void MasterUI::cb_partKeymode_i(Fl_Choice* o, void*) {
  //
                  updateModepatch(o->value() > 1 && partui->drumMode->value() != 0);
                  send_data(0, PART::control::keyMode, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partKeymode(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partKeymode_i(o,v);
}

void MasterUI::cb_partPortamento_i(Fl_Check_Button2* o, void*) {
  //
            send_data(0, PART::control::portamento, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partPortamento(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partPortamento_i(o,v);
}

void MasterUI::cb_minKeyCount_i(WidgetSpinner* o, void*) {
  //
            int tmp = o->value();
            int other = maxKeyCount->value();
            if (tmp > other)
            {
                tmp = other;
                o->value(tmp);
            }

            send_data(0, PART::control::minNote, tmp, TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_minKeyCount(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_minKeyCount_i(o,v);
}

void MasterUI::cb_maxKeyCount_i(WidgetSpinner* o, void*) {
  //
            int tmp = o->value();
            int other = minKeyCount->value();
            if (tmp < other)
            {
                tmp = other;
                o->value(tmp);
            }

            send_data(0, PART::control::maxNote, tmp, TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_maxKeyCount(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_maxKeyCount_i(o,v);
}

void MasterUI::cb_setMinToLast_i(Fl_Button*, void*) {
  //
            int lastnote = synth->part[npart]->getLastNote();
            if (lastnote >= 0)
            {
                minKeyCount->value(lastnote);
                send_data(0, PART::control::minToLastKey, 1, TOPLEVEL::type::Integer, npart);
            }
}
void MasterUI::cb_setMinToLast(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_setMinToLast_i(o,v);
}

void MasterUI::cb_setNormal_i(Fl_Button*, void*) {
  //
            minKeyCount->value(0);
            maxKeyCount->value(127);
            send_data(0, PART::control::resetMinMaxKey, 1, TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_setNormal(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_setNormal_i(o,v);
}

void MasterUI::cb_setMaxToLast_i(Fl_Button*, void*) {
  //
            int lastnote = synth->part[npart]->getLastNote();
            if (lastnote >= 0)
            {
                maxKeyCount->value(lastnote);
                send_data(0, PART::control::maxToLastKey, 1, TOPLEVEL::type::Integer, npart);
            }
}
void MasterUI::cb_setMaxToLast(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_setMaxToLast_i(o,v);
}

void MasterUI::cb_partKeyShift_i(WidgetSpinner* o, void*) {
  //
            send_data(TOPLEVEL::action::lowPrio, PART::control::keyShift, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partKeyShift(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partKeyShift_i(o,v);
}

void MasterUI::cb_partKeyLimit_i(WidgetSpinner* o, void*) {
  //
            send_data(0, PART::control::maxNotes, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partKeyLimit(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partKeyLimit_i(o,v);
}

void MasterUI::cb_sysEff1_i(WidgetPDial* o, void*) {
  //
      o->selection_color(setKnob(o->value(),0));
      send_data(TOPLEVEL::action::forceUpdate, PART::partToSystemEffect1, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_sysEff1(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sysEff1_i(o,v);
}

void MasterUI::cb_sysEff2_i(WidgetPDial* o, void*) {
  //
      o->selection_color(setKnob(o->value(),0));
      send_data(TOPLEVEL::action::forceUpdate, PART::partToSystemEffect2, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_sysEff2(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sysEff2_i(o,v);
}

void MasterUI::cb_sysEff3_i(WidgetPDial* o, void*) {
  //
      o->selection_color(setKnob(o->value(),0));
      send_data(TOPLEVEL::action::forceUpdate, PART::partToSystemEffect3, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_sysEff3(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sysEff3_i(o,v);
}

void MasterUI::cb_sysEff4_i(WidgetPDial* o, void*) {
  //
      o->selection_color(setKnob(o->value(),0));
      send_data(TOPLEVEL::action::forceUpdate, PART::partToSystemEffect4, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_sysEff4(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sysEff4_i(o,v);
}

void MasterUI::cb_partOmniEnable_i(Fl_Check_Button2* o, void*) {
  //;
          send_data(0, PART::control::omni, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partOmniEnable(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->parent()->user_data()))->cb_partOmniEnable_i(o,v);
}

void MasterUI::cb_partEnable_i(Fl_Check_Button2* o, void*) {
  //;
          if (o->value() != 1)
              partControls->deactivate();
          else
              partControls->activate();

          if (npart >= panelgroup && npart < (panelgroup + NUM_MIDI_CHANNELS))
          {
              panellistitem[npart % NUM_MIDI_CHANNELS]->partenabled->value(o->value());
              if (o->value() != 1)
                  panellistitem[npart % NUM_MIDI_CHANNELS]->panellistitemgroup->deactivate();
              else
                  panellistitem[npart % NUM_MIDI_CHANNELS]->panellistitemgroup->activate();
          }

          send_data(0, PART::control::enable, o->value(), TOPLEVEL::type::Integer, npart);
}
void MasterUI::cb_partEnable(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_partEnable_i(o,v);
}

void MasterUI::cb__i(Fl_Button*, void*) {
  vumeter->init(-1, synth);
}
void MasterUI::cb_(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb__i(o,v);
}

void MasterUI::cb_mastermono_i(Fl_Button* o, void*) {
  //
          int tmp = 1 -  o->value();
          o->value(tmp);
          if (tmp == 0)
              o->label("Stereo");
          else
              o->label("Mono");
          send_data(0, MAIN::control::mono,  tmp, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_mastermono(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_mastermono_i(o,v);
}

void MasterUI::cb_maxparts_i(WidgetSpinner* o, void*) {
  //
          int tmp = o->value();
          if (tmp == 48) // must be 16,32,64
          {
              if (partmax == 32) // rolling upwards
                  tmp = 64;
              else
                  tmp = 32;
          }
          send_data(TOPLEVEL::action::forceUpdate, MAIN::control::availableParts, tmp, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_maxparts(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_maxparts_i(o,v);
}

void MasterUI::cb_npartcounter_i(WidgetSpinner* o, void*) {
  //
          npart = o->value() - 1;
          send_data(TOPLEVEL::action::forceUpdate, MAIN::control::partNumber, npart, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_npartcounter(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_npartcounter_i(o,v);
}

void MasterUI::cb_panning_law_i(Fl_Choice* o, void*) {
  //
                         send_data(0, MAIN::control::panLawType, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_panning_law(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_panning_law_i(o,v);
}

void MasterUI::cb_1_i(Fl_Button*, void*) {
  //;
}
void MasterUI::cb_1(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_1_i(o,v);
}

void MasterUI::cb_cancelInst_i(Fl_Button*, void*) {
  //;
}
void MasterUI::cb_cancelInst(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_cancelInst_i(o,v);
}

void MasterUI::cb_nextInst_i(Fl_Button*, void*) {
  //;
}
void MasterUI::cb_nextInst(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_nextInst_i(o,v);
}

void MasterUI::cb_valueInst_i(Fl_Input*, void*) {
  //;
}
void MasterUI::cb_valueInst(Fl_Input* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_valueInst_i(o,v);
}

void MasterUI::cb_about5_i(Fl_Button*, void*) {
  //
                   contributors->show();
                   aboutFirst->hide();
}
void MasterUI::cb_about5(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_about5_i(o,v);
}

void MasterUI::cb_aboutClose_i(Fl_Button*, void*) {
  //
          aboutFirst->show();
          contributors->hide();
          aboutwindow->hide();
}
void MasterUI::cb_aboutClose(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_aboutClose_i(o,v);
}

void MasterUI::cb_syseffsendwindow_i(ScaleTrackedWindow*, void*) {
  syseffClose->do_callback();
}
void MasterUI::cb_syseffsendwindow(ScaleTrackedWindow* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_syseffsendwindow_i(o,v);
}

void MasterUI::cb_syseffClose_i(Fl_Button*, void*) {
  //
      saveWin(synth, syseffsendwindow->w(), syseffsendwindow->h(), syseffsendwindow->x(), syseffsendwindow->y(), false, "Master-systemeffectsend");
      syseffsendwindow->hide();
      syseffSeen = false;
}
void MasterUI::cb_syseffClose(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseffClose_i(o,v);
}

void MasterUI::cb_syseff01_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 1, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,0,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff01(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff01_i(o,v);
}

void MasterUI::cb_syseff02_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 2, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,0,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff02(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff02_i(o,v);
}

void MasterUI::cb_syseff03_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 3, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,0,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff03(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff03_i(o,v);
}

void MasterUI::cb_syseff12_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 2, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,1,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff12(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff12_i(o,v);
}

void MasterUI::cb_syseff13_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 3, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,1,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff13(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff13_i(o,v);
}

void MasterUI::cb_syseff23_i(WidgetPDial* o, void*) {
  //
          int val = lrint(o->value());
          if (Fl::event_button() == 3)
          {
              val = 0;
              o->value(val);
          }
          o->selection_color(setKnob(val,0));
          send_data(TOPLEVEL::action:: forceUpdate, 3, val, TOPLEVEL::type::Integer, TOPLEVEL::section::systemEffects,2,TOPLEVEL::insert::systemEffectSend);
}
void MasterUI::cb_syseff23(WidgetPDial* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_syseff23_i(o,v);
}

void MasterUI::cb_panelwindow_i(ScaleTrackedWindow*, void*) {
  Panelclose->do_callback();
}
void MasterUI::cb_panelwindow(ScaleTrackedWindow* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_panelwindow_i(o,v);
}

void MasterUI::cb_towide_i(Fl_Button*, void*) {
  //
          changepanelstyle(1, true);
}
void MasterUI::cb_towide(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_towide_i(o,v);
}

void MasterUI::cb_todeep_i(Fl_Button*, void*) {
  //
          changepanelstyle(2, true);
}
void MasterUI::cb_todeep(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_todeep_i(o,v);
}

void MasterUI::cb_Panelgroups_i(Fl_Choice* o, void*) {
  //
          panelgroup = o->value() * NUM_MIDI_CHANNELS;
          for (int i = 0; i < NUM_MIDI_CHANNELS; ++i)
              panellistitem[i]->refresh();
}
void MasterUI::cb_Panelgroups(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Panelgroups_i(o,v);
}

void MasterUI::cb_Panelsmallgroups_i(Fl_Choice* o, void*) {
  //
          panelgroup = o->value() * NUM_MIDI_CHANNELS;
          for (int i = 0; i < NUM_MIDI_CHANNELS; ++i)
              panellistitem[i]->refresh();
}
void MasterUI::cb_Panelsmallgroups(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Panelsmallgroups_i(o,v);
}

void MasterUI::cb_CSspinner_i(WidgetSpinner*, void*) {
  //
          CSpend->show();
}
void MasterUI::cb_CSspinner(WidgetSpinner* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_CSspinner_i(o,v);
}

void MasterUI::cb_CSpend_i(Fl_Button* o, void*) {
  //
          CS_CC = collect_readData(synth, 0, MAIN::control::soloType, TOPLEVEL::section::main);
          int candidate = CSspinner->value();
          if (candidate == CS_CC)
          {
              o->hide();
              return;
          }

          string name = textMsgBuffer.fetch(collect_readData(synth, candidate, MAIN::knownCCtest, TOPLEVEL::main));
          if (!name.empty())
          {
              query("", "", "", "In use for " + name);
              if (CS_CC < 128)
              {
                  CSspinner->value(CS_CC);
                  CSspinner->redraw();
              }

          }
          else
          {
              send_data(TOPLEVEL::action::forceUpdate, MAIN::control::soloCC, CSspinner->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::main);
          }
}
void MasterUI::cb_CSpend(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_CSpend_i(o,v);
}

void MasterUI::cb_channelswitch_i(Fl_Choice* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, MAIN::control::soloType, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void MasterUI::cb_channelswitch(Fl_Choice* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_channelswitch_i(o,v);
}

void MasterUI::cb_Panelclose_i(Fl_Button*, void*) {
  //
      panelType |= 4;
      saveWin(synth, panelwindow->w(), panelwindow->h(), panelwindow->x(), panelwindow->y(), panelType, "Mixer");
      panelwindow->hide();
}
void MasterUI::cb_Panelclose(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_Panelclose_i(o,v);
}

void MasterUI::cb_yesdoit_i(Fl_Button*, void*) {
  //
                  send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, BANK::control::refreshDefaults, 1, TOPLEVEL::type::Integer, TOPLEVEL::section::bank);
                  closebutton->do_callback();
}
void MasterUI::cb_yesdoit(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_yesdoit_i(o,v);
}

void MasterUI::cb_cancel_i(Fl_Button*, void*) {
  //
                  if (msgGroup == TOPLEVEL::msgResponse::refreshBankDefaults)
                      send_data(TOPLEVEL::action::lowPrio, BANK::control::refreshDefaults, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::bank);
                  else
                      send_data(0, MIDILEARN::control::cancelLearn, 0, 3, TOPLEVEL::section::midiLearn);
                  closebutton->do_callback();
}
void MasterUI::cb_cancel(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_cancel_i(o,v);
}

void MasterUI::cb_closebutton_i(Fl_Button*, void*) {
  //
                  yesdoit->hide();
                  cancel->hide();
                  message->hide();
                  msgSeen = false;
}
void MasterUI::cb_closebutton(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_closebutton_i(o,v);
}

void MasterUI::cb_querywindow_i(ScaleTrackedWindow*, void *) {
  cancelQ->do_callback();
}
void MasterUI::cb_querywindow(ScaleTrackedWindow* o, void * v) {
  ((MasterUI*)(o->user_data()))->cb_querywindow_i(o,v);
}

void MasterUI::cb_yesQ_i(Fl_Button*, void*) {
  //
      querywindow->hide();
}
void MasterUI::cb_yesQ(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_yesQ_i(o,v);
}

void MasterUI::cb_noQ_i(Fl_Button*, void*) {
  //
      querywindow->hide();
}
void MasterUI::cb_noQ(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_noQ_i(o,v);
}

void MasterUI::cb_cancelQ_i(Fl_Button*, void*) {
  //
      querywindow->hide();
}
void MasterUI::cb_cancelQ(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_cancelQ_i(o,v);
}

void MasterUI::cb_textwindow_i(ScaleTrackedWindow* o, void*) {
  //
        saveWin(synth, o->w(), o->h(), o->x(), o->y(), false, "Master-textin");
        o->hide();
}
void MasterUI::cb_textwindow(ScaleTrackedWindow* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_textwindow_i(o,v);
}

void MasterUI::cb_filerwindow_i(ScaleTrackedWindow*, void*) {
  //
          filerclose->do_callback();
}
void MasterUI::cb_filerwindow(ScaleTrackedWindow* o, void* v) {
  ((MasterUI*)(o->user_data()))->cb_filerwindow_i(o,v);
}

void MasterUI::cb_fileroldpath_i(Fl_Input* o, void*) {
  //
          if (Fl::event_key() == FL_Enter)
          {
              filernewname->value("");
              string name = string(o->value());
              if (name.back() != '/')
                  name += "/";
              if(!file::isDirectory(name))
              {
                  if (!dosave && extension != TOPLEVEL::XML::Dir && extension != TOPLEVEL::XML::Bank)
                  {
                      alert(synth, "Not a valid path to load from.");
                      return;
                  }
                  if (choice(synth, "", "Yes", "No", "Add to path?") < 2)
                      return;
                  if (file::createDir(name))
                  {
                      alert(synth, "Unable to change a path here.");
                      return;
                  }
              }
              filerpath = name;
              o->value(name.c_str());
              fillfiler(type_name);
          }
}
void MasterUI::cb_fileroldpath(Fl_Input* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_fileroldpath_i(o,v);
}

void MasterUI::cb_filerback_i(Fl_Button*, void*) {
  //
          if (filerpath == "/")
              return;
          filernewname->value("");
          size_t pos = filerpath.rfind('/', filerpath.length() - 2);
          filerpath = filerpath.substr(0, pos +1);
          if (filerpath.empty())
              filerpath = "/";
          fileroldpath->value(filerpath.c_str());
          fillfiler(type_name);
}
void MasterUI::cb_filerback(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerback_i(o,v);
}

void MasterUI::cb_filerfave_i(Fl_Button*, void*) {
  //
          setfavourites();
}
void MasterUI::cb_filerfave(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_filerfave_i(o,v);
}

void MasterUI::cb_faveadd_i(Fl_Button*, void*) {
  //
      string name = string(fileroldpath->value());
      if (name.back() != '/')
          name += "/";
      if (!file::isDirectory(name))
      {
          alert(synth, "Not a valid path");
          return;
      }
      fileroldpath->value(name.c_str());
      filerpath = name;
      favebrowse->add(name.c_str());
      setfavourites();
}
void MasterUI::cb_faveadd(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_faveadd_i(o,v);
}

void MasterUI::cb_filerclose_i(Fl_Button*, void*) {
  //
          if (favourites->visible())
              favecancel->do_callback();
          filerfound.clear();
          filerdone = true;
          filernewname->value("Exit");
          saveWin(synth, filerwindow->w(), filerwindow->h(), filerwindow->x(), filerwindow->y(), false, "Master-filer");
}
void MasterUI::cb_filerclose(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerclose_i(o,v);
}

void MasterUI::cb_filernewname_i(Fl_Input*, void*) {
  //
        if (Fl::event_key() == FL_Enter)
            fileruse->do_callback();
}
void MasterUI::cb_filernewname(Fl_Input* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_filernewname_i(o,v);
}

void MasterUI::cb_fileruse_i(Fl_Button*, void*) {
  //
          filerpath = string(fileroldpath->value());
          if (filerpath.back() != '/')
          {
              filerpath += '/';
              fileroldpath->value(filerpath.c_str());
          }
          string leaf = string(filernewname->value());
          if (!dosave || !leaf.empty())
              filerfound = filerpath + leaf;
          // error picked up in main loop
          filerdone = true;
}
void MasterUI::cb_fileruse(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_fileruse_i(o,v);
}

void MasterUI::cb_filerOpt8_i(Fl_Check_Button2* o, void*) {
  //
      if (o->value() != 0)
          filerOpt1->deactivate();
      else
          filerOpt1->activate();
      fillfiler(type_name);
}
void MasterUI::cb_filerOpt8(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerOpt8_i(o,v);
}

void MasterUI::cb_filerOpt1_i(Fl_Check_Button2*, void*) {
  //
      fillfiler(type_name);
}
void MasterUI::cb_filerOpt1(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerOpt1_i(o,v);
}

void MasterUI::cb_filerOpt2_i(Fl_Check_Button2*, void*) {
  //
      fillfiler(type_name);
}
void MasterUI::cb_filerOpt2(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerOpt2_i(o,v);
}

void MasterUI::cb_filerOpt16_i(Fl_Check_Button2*, void*) {
  //
      ;
}
void MasterUI::cb_filerOpt16(Fl_Check_Button2* o, void* v) {
  ((MasterUI*)(o->parent()->user_data()))->cb_filerOpt16_i(o,v);
}

void MasterUI::cb_favebrowse_i(Fl_Browser*, void*) {
  //
          if (!favebrowse->value())
              return;
          int result = favebrowse->value();
          if (result < 1)
              return;
          if (Fl::event_clicks())
          {
              Fl::event_clicks(0);
              faveset->do_callback();
          }
          clearfavelist();
          setfavecolour(result);
}
void MasterUI::cb_favebrowse(Fl_Browser* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_favebrowse_i(o,v);
}

void MasterUI::cb_favecancel_i(Fl_Button*, void*) {
  //
      fileroldpath->activate();
      filernewname->activate();
      fileruse->activate();
      filerback->activate();
      filerfave->activate();
      filerscroll->show();
      faveGroup->show();
      favourites->hide();
}
void MasterUI::cb_favecancel(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_favecancel_i(o,v);
}

void MasterUI::cb_favedefault_i(Fl_Button*, void*) {
  //
      size_t pos = favebrowse->value();
      if (pos > 0)
          favebrowse->move(1, pos);
}
void MasterUI::cb_favedefault(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_favedefault_i(o,v);
}

void MasterUI::cb_favedelete_i(Fl_Button*, void*) {
  //
      clearfavelist();
      size_t pos = favebrowse->value();
      setfavecolour(1);
      if (pos > 0)
          favebrowse->remove(pos);
}
void MasterUI::cb_favedelete(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_favedelete_i(o,v);
}

void MasterUI::cb_faveset_i(Fl_Button*, void*) {
  //
      size_t pos = favebrowse->value();
      if (pos > 0)
          filerpath = clearfavecolour(pos);
      else
         filerpath = clearfavecolour(1);

      if (filerpath.back() != '/')
          filerpath += '/';
      fileroldpath->value(filerpath.c_str());
      fillfiler(type_name);
      favecancel->do_callback();
}
void MasterUI::cb_faveset(Fl_Button* o, void* v) {
  ((MasterUI*)(o->parent()->parent()->user_data()))->cb_faveset_i(o,v);
}

MasterUI::MasterUI(InterChange& _interChange, InterfaceAnchor connectionData)
	 : GuiUpdates{_interChange, std::move(connectionData)} {
  //
        synth = nullptr;
        presetsui = nullptr;
        npart = 0;
        panelgroup = 0;
        panelScale = 1;

        microtonalui = nullptr;
        bankui = nullptr;
        virkeyboard = nullptr;
        configui = nullptr;
        presetsui = nullptr;
        paramsui = nullptr;
        syseffectui = nullptr;
        inseffectui = nullptr;
        yoshiLog = nullptr;
        queryDW = 0;

        lastmainW = -1;
        lastpanelW = 0;
        lastmsgW = 0;
        lasttextW = 0;
        lastsyseffW = 0;
        lastvirtW = 0;
        lastaboutW = 0;
        oldH = 0;

        filerpath.clear();
        lastfilerW = 0;
}

MasterUI::~MasterUI() {
  //
        aboutwindow->hide();
        delete aboutwindow;

        syseffsendwindow->hide();
        if (syseffSeen)
            saveWin(synth, syseffsendwindow->w(), syseffsendwindow->h(), syseffsendwindow->x(), syseffsendwindow->y(), true, "Master-systemeffectsend");
        delete syseffsendwindow;

        if (panelType < 4)
            saveWin(synth, panelwindow->w(), panelwindow->h(), panelwindow->x(), panelwindow->y(), panelType, "Mixer");
        panelwindow->hide();
        delete panelwindow;

        message->hide();
        delete message;

        if (microtonalui)
            delete microtonalui;

        if (bankui)
            delete bankui;

        if (virkeyboard)
            delete virkeyboard;

        if (configui)
            delete configui;

        if (presetsui)
            delete presetsui;

        if (paramsui)
            delete paramsui;

        if (vectorui)
            delete vectorui;

        if (midilearnui)
            delete midilearnui;

        if (yoshiLog)
            delete yoshiLog;

        if (querywindow)
        {
            querywindow->hide();
            delete querywindow;
        }

        if (filerwindow)
        {
            filerlist.clear();
            if (filerwindow->visible())
                saveWin(synth, filerwindow->w(), filerwindow->h(), filerwindow->x(), filerwindow->y(), true, "Master-filer");
            filerwindow->hide();
            delete filerwindow;
        }

        saveWin(synth, masterwindow->w(), masterwindow->h(), masterwindow->x(), masterwindow->y(), true, "Master");

        masterwindow->hide();
        delete masterwindow;
}

void MasterUI::Init() {
  //
        current_ID = anchor.synthID;
        synth = anchor.synth;
        assert(synth);
        file::createDir(file::configDir() + "/windows");
        panelType = 5;
        msgSeen = false;
        syseffSeen = false;
        effDisplayType = 0;
        partmax = collect_readData(synth, 0, MAIN::control::availableParts, TOPLEVEL::main);
        microtonalui = new MicrotonalUI(&synth->microtonal, synth);
        bankui = new BankUI(synth);
        virkeyboard = new VirKeyboard(synth);
        configui = new ConfigUI(synth, current_ID);
        presetsui = new PresetsUI(synth);
        paramsui = new ParametersUI(synth);
        vectorui = new VectorUI(synth, bankui, paramsui);
        midilearnui = new MidiLearnUI(synth);
        yoshiLog = new ConsoleUI(synth);
        Fl_Tooltip::color(tooltip_back);
        Fl_Tooltip::textcolor(tooltip_text);
        make_window();
        partui->checkEngines();
        themeTrigger = 0;

        bool foundWindows = Showmaster();
        if (current_ID > 0)
            foundWindows = true; //  not relevant for later windows
        loadWindowData();
        string starterror = "";
        if (synth->getRuntime().isLV2)
        {
            masterwindow->label(synth->getWindowTitle().c_str());
        }
        else
        {
            starterror = textMsgBuffer.fetch(0);
            setMasterLabel(synth->getRuntime().paramsLoad);
        }
        if (starterror.find("Could not") != std::string::npos)
            query("", "", "", starterror);
        microtonalui->microtonaluiwindow->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Scales"), UNUSED, TOPLEVEL::windowTitle)).c_str());
        yoshiLog->logConsole->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Console"), UNUSED, TOPLEVEL::windowTitle)).c_str());
        logenable = fetchData(0, CONFIG::control::reportsDestination, TOPLEVEL::section::config);
        if (!foundWindows)
        {
            // fake previously seen.
            saveWin(synth, 0, 0, masterwindow->x() + masterwindow->w() + 16, masterwindow->y(), true, "Midi-virtualkeyboard");
            virkeyboard->ShowKbd();
            panelwindow->resize(masterwindow->x(), masterwindow->y(), PANEL_SINGLE_X, PANEL_SINGLE_Y);
            saveWin(synth, panelwindow->w(), panelwindow->h(), panelwindow->x(), panelwindow->y(), panelType, "Mixer");
            string msg = "As this is a first time start, please check 'Yoshimi->Settings'. More information can be found in the manual.";
            setmessage(UNUSED, true, msg, "Close");
        }
        else if (not Config::is_compatible(synth->getRuntime().loadedConfigVer))
        {
            auto& newVer = synth->getRuntime().loadedConfigVer;
            auto& currVer = Config::VER_YOSHI_CURR;
            string msg{"Existing config from v"
                      + asString(newVer.maj)
                      + "."
                      + asString(newVer.min)
                      + (newVer < currVer? " < v":" > v")
                      + asString(currVer.maj)
                      + "."
                      + asString(currVer.min)
                      + (currVer < newVer? "\nWARNING: if you change and thus save this config, some newer settings may be lost."
                                         : "\nImported settings were auto-saved, please check config.")
                      };
            setmessage(UNUSED, true, msg, "Close");
        }
        else
        {
            if (current_ID == 0 && fetchData(0, BANK::control::refreshDefaults, TOPLEVEL::section::bank) == false)
            {
                string msg = "Default banks have been copied to {user}.local/share/yoshimi/found \nAdd these to the bank roots window?";
                setmessage(TOPLEVEL::msgResponse::refreshBankDefaults, true, msg, "Ask Later", "No", "Yes");
            ;}
        ;} {}
}

bool MasterUI::Showmaster() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Master");
      if (fetchW < mainDW || fetchH < mainDH)
      {
          fetchW = mainDW;
          fetchH = mainDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, mainDW, mainDH);

      masterwindow->resize(fetchX, fetchY, fetchW, fetchH);
      masterwindow->show();
      lastmainW = 0;
      mainRtext();

      return (fetchO != 0);
}

void MasterUI::refreshInit() {
  // update to current state and refresh sub-UIs and config
      refresh_master_ui(1);
      resetPartsClip();
      bankui->readbankcfg();
      bankui->rescan_for_banks();
      //
}

ScaleTrackedWindow* MasterUI::make_window() {
  { masterwindow = new ScaleTrackedWindow(385, 525, "Yoshimi meets ZynAddSubFX");
    masterwindow->box(FL_FLAT_BOX);
    masterwindow->color(FL_BACKGROUND_COLOR);
    masterwindow->selection_color(FL_BACKGROUND_COLOR);
    masterwindow->labeltype(FL_NO_LABEL);
    masterwindow->labelfont(13);
    masterwindow->labelsize(12);
    masterwindow->labelcolor(FL_FOREGROUND_COLOR);
    masterwindow->callback((Fl_Callback*)cb_masterwindow, (void*)(this));
    masterwindow->align(Fl_Align(FL_ALIGN_TOP));
    masterwindow->when(FL_WHEN_RELEASE);
    { KeyHandle* o = keyHandle = new KeyHandle(0, 0, 385, 500, "keyhandler");
      keyHandle->box(FL_FLAT_BOX);
      keyHandle->color(FL_BACKGROUND_COLOR);
      keyHandle->selection_color(FL_BACKGROUND_COLOR);
      keyHandle->labeltype(FL_NORMAL_LABEL);
      keyHandle->labelfont(0);
      keyHandle->labelsize(14);
      keyHandle->labelcolor(FL_FOREGROUND_COLOR);
      keyHandle->align(Fl_Align(FL_ALIGN_CENTER));
      keyHandle->when(FL_WHEN_RELEASE);
      o->init(synth);
    } // KeyHandle* keyHandle
    { Fl_Menu_Bar* o = mastermenu = new Fl_Menu_Bar(-7, 0, 395, 25);
      mastermenu->tooltip("Click to open menus");
      mastermenu->labelsize(12);
      mastermenu->labelcolor((Fl_Color)64);
      mastermenu->textsize(12);
      mastermenu->textcolor((Fl_Color)64);
      mastermenu->callback((Fl_Callback*)cb_mastermenu);
      //
        o->add("&Yoshimi  /&About...");
        o->add("&Yoshimi  /&New Instance");
        o->add("&Yoshimi  /&Settings...");
        o->add("&Yoshimi  /&Reports");
        o->add("&Yoshimi  /&View Manual");
        o->add("&Yoshimi  /&Exit");

        o->add("&Instrument  /S&how Stored...");
        o->add("&Instrument  /&Load External...");
        o->add("&Instrument  /&Save External...");
        o->add("&Instrument  /&Recent Instruments...");
        o->add("&Instrument  /&Clear");
        o->add("&Instrument  /S&earch...");

        o->add("&PatchSet  /&S&how Patch Banks...");
        o->add("&PatchSet  /&Load External...");
        o->add("&PatchSet  /&Save External...");
        o->add("&PatchSet  /&Recent sets...");

        o->add("P&ath  /&Bank Root Dirs...");
        o->add("P&ath  /&Preset Dirs...");

        o->add("&State  /&Load...");
        o->add("&State  /&Save...");
        o->add("&State  /Save As &default");
        o->add("&State  /&Recent States");

        o->add("Sca&le/S&how Settings...");
        o->add("S&cale/&Load...");
        o->add("S&cale/&Save...");
        o->add("S&cale/&Recent Scales...");
    } // Fl_Menu_Bar* mastermenu
    { MasterControls = new Fl_Group(2, 25, 380, 148, "Master  ");
      MasterControls->labeltype(FL_NO_LABEL);
      MasterControls->labelsize(11);
      MasterControls->labelcolor((Fl_Color)96);
      MasterControls->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT|FL_ALIGN_INSIDE));
      { mainreset = new Fl_Button(6, 61, 66, 24, "Reset");
        mainreset->tooltip("Clear all dynamic settings\n(+Ctrl includes MIDI-learn)");
        mainreset->box(FL_PLASTIC_UP_BOX);
        mainreset->color((Fl_Color)228);
        mainreset->labelfont(1);
        mainreset->labelsize(11);
        mainreset->labelcolor((Fl_Color)64);
        mainreset->callback((Fl_Callback*)cb_mainreset);
        mainreset->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Button* mainreset
      { mainstop = new Fl_Button(6, 31, 66, 24, "Stop!");
        mainstop->tooltip("Cease all sound immediately!");
        mainstop->box(FL_PLASTIC_UP_BOX);
        mainstop->color((Fl_Color)89);
        mainstop->labelfont(1);
        mainstop->labelsize(11);
        mainstop->labelcolor((Fl_Color)64);
        mainstop->callback((Fl_Callback*)cb_mainstop);
        mainstop->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
      } // Fl_Button* mainstop
      { mainvirtkeyb = new Fl_Button(80, 61, 106, 24, "Virtual Key&board");
        mainvirtkeyb->tooltip("Virtual Keyboard");
        mainvirtkeyb->box(FL_GTK_THIN_UP_BOX);
        mainvirtkeyb->color((Fl_Color)198);
        mainvirtkeyb->labelsize(11);
        mainvirtkeyb->labelcolor((Fl_Color)64);
        mainvirtkeyb->callback((Fl_Callback*)cb_mainvirtkeyb);
      } // Fl_Button* mainvirtkeyb
      { mixerpanel = new Fl_Button(80, 31, 106, 24, "Mixer &Panel");
        mixerpanel->tooltip("Mixer Panel Window");
        mixerpanel->box(FL_GTK_THIN_UP_BOX);
        mixerpanel->color((Fl_Color)198);
        mixerpanel->labelsize(11);
        mixerpanel->labelcolor((Fl_Color)64);
        mixerpanel->callback((Fl_Callback*)cb_mixerpanel);
      } // Fl_Button* mixerpanel
      { mainmidilearn = new Fl_Button(80, 91, 106, 24, "&Midi Learn");
        mainmidilearn->tooltip("Message Log");
        mainmidilearn->box(FL_GTK_THIN_UP_BOX);
        mainmidilearn->color((Fl_Color)198);
        mainmidilearn->labelsize(11);
        mainmidilearn->labelcolor((Fl_Color)64);
        mainmidilearn->callback((Fl_Callback*)cb_mainmidilearn);
      } // Fl_Button* mainmidilearn
      { vectors = new Fl_Button(194, 31, 66, 24, "&Vectors");
        vectors->tooltip("Vector Setup Window");
        vectors->box(FL_GTK_THIN_UP_BOX);
        vectors->color((Fl_Color)198);
        vectors->labelsize(11);
        vectors->labelcolor((Fl_Color)64);
        vectors->callback((Fl_Callback*)cb_vectors);
      } // Fl_Button* vectors
      { undo = new Fl_Button(194, 61, 66, 24, "&Undo");
        undo->tooltip("Revert last change");
        undo->box(FL_PLASTIC_UP_BOX);
        undo->color((Fl_Color)228);
        undo->labelsize(11);
        undo->labelcolor((Fl_Color)64);
        undo->callback((Fl_Callback*)cb_undo);
      } // Fl_Button* undo
      { redo = new Fl_Button(194, 92, 66, 24, "&Redo");
        redo->tooltip("Re-apply last change");
        redo->box(FL_PLASTIC_UP_BOX);
        redo->color((Fl_Color)228);
        redo->labelsize(11);
        redo->labelcolor((Fl_Color)64);
        redo->callback((Fl_Callback*)cb_redo);
      } // Fl_Button* redo
      { topcontrols1 = new Fl_Box(266, 31, 114, 142);
        topcontrols1->box(FL_ENGRAVED_FRAME);
      } // Fl_Box* topcontrols1
      { WidgetPDial* o = globalfinedetune = new WidgetPDial(277, 43, 40, 40, "Detune");
        globalfinedetune->tooltip("Global Fine Detune");
        globalfinedetune->box(FL_ROUND_UP_BOX);
        globalfinedetune->color((Fl_Color)29);
        globalfinedetune->selection_color(FL_INACTIVE_COLOR);
        globalfinedetune->labeltype(FL_NORMAL_LABEL);
        globalfinedetune->labelfont(0);
        globalfinedetune->labelsize(10);
        globalfinedetune->labelcolor((Fl_Color)64);
        globalfinedetune->maximum(127);
        globalfinedetune->value(64);
        globalfinedetune->callback((Fl_Callback*)cb_globalfinedetune);
        globalfinedetune->align(Fl_Align(FL_ALIGN_BOTTOM));
        globalfinedetune->when(FL_WHEN_CHANGED);
        o->setValueType(VC_GlobalFineDetune);
        o->value(synth->microtonal.Pglobalfinedetune);
        o->selection_color(setKnob(o->value(),64));
      } // WidgetPDial* globalfinedetune
      { WidgetPDial* o = mastervolumedial = new WidgetPDial(329, 43, 40, 40, "Volume");
        mastervolumedial->tooltip("Master Volume");
        mastervolumedial->box(FL_ROUND_UP_BOX);
        mastervolumedial->color((Fl_Color)29);
        mastervolumedial->selection_color(FL_INACTIVE_COLOR);
        mastervolumedial->labeltype(FL_NORMAL_LABEL);
        mastervolumedial->labelfont(0);
        mastervolumedial->labelsize(10);
        mastervolumedial->labelcolor((Fl_Color)64);
        mastervolumedial->maximum(127);
        mastervolumedial->callback((Fl_Callback*)cb_mastervolumedial);
        mastervolumedial->align(Fl_Align(FL_ALIGN_BOTTOM));
        mastervolumedial->when(FL_WHEN_CHANGED);
        o->setValueType(VC_MasterVolume);
        o->value(synth->Pvolume);
        o->selection_color(setKnob(o->value(),90));
      } // WidgetPDial* mastervolumedial
      { WidgetSpinner* o = masterkeyshift = new WidgetSpinner(327, 109, 44, 20, "Key Shift");
        masterkeyshift->tooltip("Shift pitch +/- N semitones");
        masterkeyshift->box(FL_NO_BOX);
        masterkeyshift->color(FL_BACKGROUND_COLOR);
        masterkeyshift->selection_color(FL_BACKGROUND_COLOR);
        masterkeyshift->labeltype(FL_NORMAL_LABEL);
        masterkeyshift->labelfont(0);
        masterkeyshift->labelsize(10);
        masterkeyshift->labelcolor((Fl_Color)64);
        masterkeyshift->minimum(-36);
        masterkeyshift->maximum(36);
        masterkeyshift->textfont(1);
        masterkeyshift->textsize(12);
        masterkeyshift->textcolor((Fl_Color)64);
        masterkeyshift->callback((Fl_Callback*)cb_masterkeyshift);
        masterkeyshift->align(Fl_Align(FL_ALIGN_LEFT));
        masterkeyshift->when(FL_WHEN_RELEASE);
        o->range(MIN_KEY_SHIFT, MAX_KEY_SHIFT);o->step(1.0);
        o->value(synth->Pkeyshift - 64);
      } // WidgetSpinner* masterkeyshift
      { WidgetSpinner* o = bpmfallback = new WidgetSpinner(315, 143, 56, 20, "F. BPM");
        bpmfallback->tooltip("Fallback BPM (Beats Per Minute). This is only used if the MIDI driver does no"
"t provide its own BPM information.");
        bpmfallback->box(FL_NO_BOX);
        bpmfallback->color(FL_BACKGROUND_COLOR);
        bpmfallback->selection_color(FL_BACKGROUND_COLOR);
        bpmfallback->labeltype(FL_NORMAL_LABEL);
        bpmfallback->labelfont(0);
        bpmfallback->labelsize(10);
        bpmfallback->labelcolor((Fl_Color)64);
        bpmfallback->minimum(0);
        bpmfallback->maximum(0);
        bpmfallback->value(120);
        bpmfallback->textfont(1);
        bpmfallback->textsize(12);
        bpmfallback->textcolor((Fl_Color)64);
        bpmfallback->callback((Fl_Callback*)cb_bpmfallback);
        bpmfallback->align(Fl_Align(FL_ALIGN_LEFT));
        bpmfallback->when(FL_WHEN_RELEASE);
        o->range(BPM_FALLBACK_MIN, BPM_FALLBACK_MAX);
        o->step(1.0); o->type(FL_FLOAT_INPUT);
        setBpmFallbackValue(synth->PbpmFallback);
      } // WidgetSpinner* bpmfallback
      MasterControls->end();
    } // Fl_Group* MasterControls
    { sysDisplay = new Fl_Button(5, 150, 110, 28, "System Effects");
      sysDisplay->box(FL_PLASTIC_THIN_UP_BOX);
      sysDisplay->color(FL_CYAN);
      sysDisplay->labelfont(1);
      sysDisplay->labelsize(12);
      sysDisplay->callback((Fl_Callback*)cb_sysDisplay);
    } // Fl_Button* sysDisplay
    { insDisplay = new Fl_Button(116, 150, 110, 28, "Insertion Effects");
      insDisplay->box(FL_PLASTIC_THIN_UP_BOX);
      insDisplay->labelfont(1);
      insDisplay->labelsize(12);
      insDisplay->callback((Fl_Callback*)cb_insDisplay);
    } // Fl_Button* insDisplay
    { SystemEffectsGrp = new Fl_Group(3, 178, 380, 39, " System Effects ");
      SystemEffectsGrp->box(FL_PLASTIC_UP_BOX);
      SystemEffectsGrp->color(FL_CYAN);
      SystemEffectsGrp->selection_color((Fl_Color)31);
      SystemEffectsGrp->labelfont(1);
      SystemEffectsGrp->labelsize(12);
      SystemEffectsGrp->labelcolor((Fl_Color)64);
      SystemEffectsGrp->align(Fl_Align(FL_ALIGN_LEFT));
      { WidgetSpinner* o = syseffnocounter = new WidgetSpinner(30, 187, 36, 20, "Effect");
        syseffnocounter->box(FL_NO_BOX);
        syseffnocounter->color(FL_BACKGROUND_COLOR);
        syseffnocounter->selection_color(FL_BACKGROUND_COLOR);
        syseffnocounter->labeltype(FL_NO_LABEL);
        syseffnocounter->labelfont(0);
        syseffnocounter->labelsize(11);
        syseffnocounter->labelcolor((Fl_Color)64);
        syseffnocounter->maximum(4);
        syseffnocounter->textfont(1);
        syseffnocounter->textsize(11);
        syseffnocounter->textcolor((Fl_Color)64);
        syseffnocounter->callback((Fl_Callback*)cb_syseffnocounter);
        syseffnocounter->align(Fl_Align(FL_ALIGN_CENTER));
        syseffnocounter->when(FL_WHEN_RELEASE);
        o->range(1, NUM_SYS_EFX);
        o->value(1);
      } // WidgetSpinner* syseffnocounter
      { Fl_Choice* o = sysefftype = new Fl_Choice(110, 187, 96, 20, "Type");
        sysefftype->down_box(FL_BORDER_BOX);
        sysefftype->labeltype(FL_NO_LABEL);
        sysefftype->labelsize(11);
        sysefftype->labelcolor((Fl_Color)64);
        sysefftype->textfont(1);
        sysefftype->textsize(11);
        sysefftype->textcolor((Fl_Color)64);
        sysefftype->callback((Fl_Callback*)cb_sysefftype);
        sysefftype->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        o->add("No Effect");o->add("Reverb");o->add("Echo");o->add("Chorus");o->add("Phaser");o->add("AlienWah");o->add("Distortion");o->add("EQ");o->add("DynFilter");
        o->value(0); // initially disabled -- enabled only when effect slot is occupied
      } // Fl_Choice* sysefftype
      { SysEffOn = new Fl_Check_Button2(237, 187, 20, 20, "On");
        SysEffOn->box(FL_NO_BOX);
        SysEffOn->down_box(FL_DOWN_BOX);
        SysEffOn->value(1);
        SysEffOn->color(FL_BACKGROUND_COLOR);
        SysEffOn->selection_color((Fl_Color)64);
        SysEffOn->labeltype(FL_NORMAL_LABEL);
        SysEffOn->labelfont(3);
        SysEffOn->labelsize(14);
        SysEffOn->labelcolor((Fl_Color)226);
        SysEffOn->callback((Fl_Callback*)cb_SysEffOn);
        SysEffOn->align(Fl_Align(FL_ALIGN_LEFT));
        SysEffOn->when(FL_WHEN_RELEASE);
      } // Fl_Check_Button2* SysEffOn
      { sysEffSend = new Fl_Button(275, 187, 62, 20, "Send to");
        sysEffSend->box(FL_GTK_THIN_UP_BOX);
        sysEffSend->color((Fl_Color)221);
        sysEffSend->labelfont(1);
        sysEffSend->labelsize(11);
        sysEffSend->labelcolor((Fl_Color)64);
        sysEffSend->callback((Fl_Callback*)cb_sysEffSend);
      } // Fl_Button* sysEffSend
      { sysCopy = new Fl_Button(353, 183, 25, 14, "C");
        sysCopy->box(FL_THIN_UP_BOX);
        sysCopy->color((Fl_Color)179);
        sysCopy->labelfont(1);
        sysCopy->labelsize(11);
        sysCopy->labelcolor((Fl_Color)197);
        sysCopy->callback((Fl_Callback*)cb_sysCopy);
      } // Fl_Button* sysCopy
      { sysPaste = new Fl_Button(353, 198, 25, 14, "P");
        sysPaste->box(FL_THIN_UP_BOX);
        sysPaste->color((Fl_Color)179);
        sysPaste->labelfont(1);
        sysPaste->labelsize(11);
        sysPaste->labelcolor((Fl_Color)197);
        sysPaste->callback((Fl_Callback*)cb_sysPaste);
      } // Fl_Button* sysPaste
      SystemEffectsGrp->end();
    } // Fl_Group* SystemEffectsGrp
    { InsertionEffectsGrp = new Fl_Group(3, 178, 380, 39, " Insertion Effects ");
      InsertionEffectsGrp->box(FL_PLASTIC_UP_BOX);
      InsertionEffectsGrp->color(FL_CYAN);
      InsertionEffectsGrp->selection_color((Fl_Color)31);
      InsertionEffectsGrp->labelfont(1);
      InsertionEffectsGrp->labelsize(12);
      InsertionEffectsGrp->labelcolor((Fl_Color)64);
      InsertionEffectsGrp->align(Fl_Align(FL_ALIGN_LEFT));
      InsertionEffectsGrp->hide();
      { WidgetSpinner* o = inseffnocounter = new WidgetSpinner(30, 187, 36, 20, "Effect");
        inseffnocounter->box(FL_NO_BOX);
        inseffnocounter->color(FL_BACKGROUND_COLOR);
        inseffnocounter->selection_color(FL_BACKGROUND_COLOR);
        inseffnocounter->labeltype(FL_NO_LABEL);
        inseffnocounter->labelfont(0);
        inseffnocounter->labelsize(11);
        inseffnocounter->labelcolor((Fl_Color)64);
        inseffnocounter->maximum(8);
        inseffnocounter->textfont(1);
        inseffnocounter->textsize(11);
        inseffnocounter->textcolor((Fl_Color)64);
        inseffnocounter->callback((Fl_Callback*)cb_inseffnocounter);
        inseffnocounter->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
        inseffnocounter->when(FL_WHEN_RELEASE);
        o->range(1, NUM_INS_EFX);
        o->value(1);
      } // WidgetSpinner* inseffnocounter
      { Fl_Choice* o = insefftype = new Fl_Choice(110, 187, 96, 20, "Type");
        insefftype->down_box(FL_BORDER_BOX);
        insefftype->labeltype(FL_NO_LABEL);
        insefftype->labelsize(11);
        insefftype->labelcolor((Fl_Color)64);
        insefftype->textfont(1);
        insefftype->textsize(11);
        insefftype->textcolor((Fl_Color)64);
        insefftype->callback((Fl_Callback*)cb_insefftype);
        insefftype->align(Fl_Align(FL_ALIGN_CENTER));
        o->add("No Effect");o->add("Reverb");o->add("Echo");o->add("Chorus");o->add("Phaser");o->add("AlienWah");o->add("Distortion");o->add("EQ");o->add("DynFilter");
        o->value(0);
        o->activate(); // not disabled; user may activate this slot by picking some effect type
      } // Fl_Choice* insefftype
      { Fl_Choice* o = inseffpart = new Fl_Choice(232, 187, 96, 20, "To ");
        inseffpart->down_box(FL_BORDER_BOX);
        inseffpart->labelfont(1);
        inseffpart->labelsize(11);
        inseffpart->labelcolor((Fl_Color)64);
        inseffpart->textfont(1);
        inseffpart->textsize(11);
        inseffpart->textcolor((Fl_Color)64);
        inseffpart->callback((Fl_Callback*)cb_inseffpart);
        setinspartlist();
        o->value(1); // initially deactivated
      } // Fl_Choice* inseffpart
      { insCopy = new Fl_Button(353, 183, 25, 14, "C");
        insCopy->box(FL_THIN_UP_BOX);
        insCopy->color((Fl_Color)179);
        insCopy->labelfont(1);
        insCopy->labelsize(11);
        insCopy->labelcolor((Fl_Color)197);
        insCopy->callback((Fl_Callback*)cb_insCopy);
      } // Fl_Button* insCopy
      { insPaste = new Fl_Button(353, 198, 25, 14, "P");
        insPaste->box(FL_THIN_UP_BOX);
        insPaste->color((Fl_Color)179);
        insPaste->labelfont(1);
        insPaste->labelsize(11);
        insPaste->labelcolor((Fl_Color)197);
        insPaste->callback((Fl_Callback*)cb_insPaste);
      } // Fl_Button* insPaste
      InsertionEffectsGrp->end();
    } // Fl_Group* InsertionEffectsGrp
    { Fl_Group* o = syseffectuigroup = new Fl_Group(3, 218, 379, 95);
      syseffectuigroup->box(FL_FLAT_BOX);
      syseffectuigroup->color((Fl_Color)48);
      syseffectuigroup->labeltype(FL_NO_LABEL);
      syseffectuigroup->labelcolor((Fl_Color)64);
      { EffUI* o = syseffectui = new EffUI(3, 218, 379, 95);
        syseffectui->box(FL_NO_BOX);
        syseffectui->color(FL_BACKGROUND_COLOR);
        syseffectui->selection_color(FL_BACKGROUND_COLOR);
        syseffectui->labeltype(FL_NO_LABEL);
        syseffectui->labelfont(0);
        syseffectui->labelsize(14);
        syseffectui->labelcolor((Fl_Color)64);
        syseffectui->align(Fl_Align(FL_ALIGN_TOP));
        syseffectui->when(FL_WHEN_RELEASE);
        o->init(synth, anchor.sysEffectParam, anchor.sysEffectEQ, TOPLEVEL::section::systemEffects);
                 o->activate();
                 o->show();
        syseffectui->end();
      } // EffUI* syseffectui
      o->show();
      syseffectuigroup->end();
    } // Fl_Group* syseffectuigroup
    { Fl_Group* o = inseffectuigroup = new Fl_Group(3, 218, 379, 95);
      inseffectuigroup->box(FL_FLAT_BOX);
      inseffectuigroup->color((Fl_Color)48);
      inseffectuigroup->labelcolor((Fl_Color)64);
      inseffectuigroup->hide();
      { EffUI* o = inseffectui = new EffUI(3, 218, 379, 95);
        inseffectui->box(FL_NO_BOX);
        inseffectui->color(FL_LIGHT2);
        inseffectui->selection_color(FL_BACKGROUND_COLOR);
        inseffectui->labeltype(FL_NORMAL_LABEL);
        inseffectui->labelfont(0);
        inseffectui->labelsize(14);
        inseffectui->labelcolor((Fl_Color)64);
        inseffectui->align(Fl_Align(FL_ALIGN_TOP));
        inseffectui->when(FL_WHEN_RELEASE);
        o->init(synth, anchor.insEffectParam, anchor.insEffectEQ, TOPLEVEL::section::insertEffects);
                 o->hide();
        o->deactivate(); // initially deactivated
        inseffectui->end();
      } // EffUI* inseffectui
      o->hide();
      inseffectuigroup->end();
    } // Fl_Group* inseffectuigroup
    { partuigroup = new Fl_Group(3, 315, 379, 178);
      partuigroup->box(FL_ENGRAVED_FRAME);
      { partui = new PartUI(3, 315, 379, 172);
        partui->box(FL_NO_BOX);
        partui->color(FL_DARK1);
        partui->selection_color(FL_BACKGROUND_COLOR);
        partui->labeltype(FL_NORMAL_LABEL);
        partui->labelfont(0);
        partui->labelsize(14);
        partui->labelcolor(FL_FOREGROUND_COLOR);
        partui->align(Fl_Align(FL_ALIGN_TOP));
        partui->when(FL_WHEN_RELEASE);
        partui->init(synth->part[npart], npart, bankui);
        partui->end();
      } // PartUI* partui
      { partControls = new Fl_Group(3, 315, 378, 175);
        { WidgetPDial* o = partVol = new WidgetPDial(340, 356, 32, 32, "Volume");
          partVol->box(FL_OVAL_BOX);
          partVol->color(FL_BACKGROUND_COLOR);
          partVol->selection_color(FL_INACTIVE_COLOR);
          partVol->labeltype(FL_NORMAL_LABEL);
          partVol->labelfont(0);
          partVol->labelsize(10);
          partVol->labelcolor((Fl_Color)64);
          partVol->maximum(127);
          partVol->step(1);
          partVol->callback((Fl_Callback*)cb_partVol);
          partVol->align(Fl_Align(FL_ALIGN_BOTTOM));
          partVol->when(FL_WHEN_CHANGED);
          o->value(fetchData(0, PART::control::volume, npart));
          o->setValueType(VC_PartVolume);
          o->selection_color(setKnob(o->value(),96));
        } // WidgetPDial* partVol
        { WidgetPDial* o = partPan = new WidgetPDial(292, 356, 32, 32, "Panning");
          partPan->box(FL_OVAL_BOX);
          partPan->color(FL_BACKGROUND_COLOR);
          partPan->selection_color(FL_INACTIVE_COLOR);
          partPan->labeltype(FL_NORMAL_LABEL);
          partPan->labelfont(0);
          partPan->labelsize(10);
          partPan->labelcolor((Fl_Color)64);
          partPan->maximum(127);
          partPan->step(1);
          partPan->callback((Fl_Callback*)cb_partPan);
          partPan->align(Fl_Align(FL_ALIGN_BOTTOM));
          partPan->when(FL_WHEN_CHANGED);
          o->value(fetchData(0, PART::control::panning, npart));
          o->setValueType(VC_PanningStd);
          o->selection_color(setKnob(o->value(),64));
        } // WidgetPDial* partPan
        { WidgetPDial* o = partVelOffset = new WidgetPDial(244, 356, 32, 32, "Vel.Offs");
          partVelOffset->box(FL_OVAL_BOX);
          partVelOffset->color(FL_BACKGROUND_COLOR);
          partVelOffset->selection_color(FL_INACTIVE_COLOR);
          partVelOffset->labeltype(FL_NORMAL_LABEL);
          partVelOffset->labelfont(0);
          partVelOffset->labelsize(10);
          partVelOffset->labelcolor((Fl_Color)64);
          partVelOffset->maximum(127);
          partVelOffset->step(1);
          partVelOffset->callback((Fl_Callback*)cb_partVelOffset);
          partVelOffset->align(Fl_Align(FL_ALIGN_BOTTOM));
          partVelOffset->when(FL_WHEN_CHANGED);
          o->value(fetchData(0, PART::control::velocityOffset, npart));
          o->selection_color(setKnob(o->value(),64));
        } // WidgetPDial* partVelOffset
        { WidgetPDial* o = partVelSense = new WidgetPDial(196, 356, 32, 32, "Vel.Sense");
          partVelSense->box(FL_OVAL_BOX);
          partVelSense->color(FL_BACKGROUND_COLOR);
          partVelSense->selection_color(FL_INACTIVE_COLOR);
          partVelSense->labeltype(FL_NORMAL_LABEL);
          partVelSense->labelfont(0);
          partVelSense->labelsize(10);
          partVelSense->labelcolor((Fl_Color)64);
          partVelSense->maximum(127);
          partVelSense->step(1);
          partVelSense->callback((Fl_Callback*)cb_partVelSense);
          partVelSense->align(Fl_Align(FL_ALIGN_BOTTOM));
          partVelSense->when(FL_WHEN_CHANGED);
          o->value(fetchData(0, PART::control::velocitySense, npart));
          o->setValueType(VC_AmpVelocitySense);
          o->selection_color(setKnob(o->value(),64));
        } // WidgetPDial* partVelSense
        { instrumentGroup = new Fl_Group(136, 320, 195, 25);
          instrumentGroup->box(FL_GTK_THIN_UP_BOX);
          instrumentGroup->color((Fl_Color)198);
          { instrumentaddbox = new Fl_Box(140, 325, 60, 15);
            instrumentaddbox->box(FL_FLAT_BOX);
          } // Fl_Box* instrumentaddbox
          { instrumentsubbox = new Fl_Box(200, 325, 65, 15);
            instrumentsubbox->box(FL_FLAT_BOX);
          } // Fl_Box* instrumentsubbox
          { instrumentpadbox = new Fl_Box(264, 325, 63, 15);
            instrumentpadbox->box(FL_FLAT_BOX);
          } // Fl_Box* instrumentpadbox
          { instrumentlabel = new Fl_Box(139, 324, 187, 16, "Simple Sound");
            instrumentlabel->selection_color((Fl_Color)64);
            instrumentlabel->labelfont(1);
            instrumentlabel->labelsize(12);
            instrumentlabel->labelcolor((Fl_Color)64);
            instrumentlabel->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
          } // Fl_Box* instrumentlabel
          { instrumentFrame = new Fl_Box(140, 325, 187, 15);
            instrumentFrame->box(FL_THIN_DOWN_FRAME);
            instrumentFrame->labelcolor(FL_BACKGROUND_COLOR);
          } // Fl_Box* instrumentFrame
          { buttontop = new Fl_Button(136, 320, 195, 25);
            buttontop->tooltip("Left mouse button: choose/save/.. from/to bank, Right button: instrument name");
            buttontop->box(FL_NO_BOX);
            buttontop->selection_color((Fl_Color)64);
            buttontop->labeltype(FL_NO_LABEL);
            buttontop->labelsize(12);
            buttontop->labelcolor((Fl_Color)64);
            buttontop->callback((Fl_Callback*)cb_buttontop);
            buttontop->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
          } // Fl_Button* buttontop
          instrumentGroup->end();
        } // Fl_Group* instrumentGroup
        { WidgetSpinner* o = partMidiCh = new WidgetSpinner(35, 381, 40, 19, "Midi");
          partMidiCh->tooltip("MIDI channel for this part");
          partMidiCh->box(FL_NO_BOX);
          partMidiCh->color(FL_BACKGROUND2_COLOR);
          partMidiCh->selection_color(FL_BACKGROUND_COLOR);
          partMidiCh->labeltype(FL_NORMAL_LABEL);
          partMidiCh->labelfont(0);
          partMidiCh->labelsize(12);
          partMidiCh->labelcolor((Fl_Color)64);
          partMidiCh->maximum(16);
          partMidiCh->textsize(11);
          partMidiCh->textcolor((Fl_Color)64);
          partMidiCh->callback((Fl_Callback*)cb_partMidiCh);
          partMidiCh->align(Fl_Align(FL_ALIGN_LEFT));
          partMidiCh->when(FL_WHEN_RELEASE);
          int num = fetchData(0,  PART::control::midiChannel, npart); o->value(num + 1); if (num < NUM_MIDI_CHANNELS) o->textcolor(gen_text); else o->textcolor(gen_opp_text);
        } // WidgetSpinner* partMidiCh
        { partEdit = new Fl_Button(334, 320, 42, 25, "&Edit");
          partEdit->tooltip("View/change instrument sound and details");
          partEdit->box(FL_GTK_THIN_UP_BOX);
          partEdit->color((Fl_Color)198);
          partEdit->labelfont(1);
          partEdit->labelsize(12);
          partEdit->labelcolor((Fl_Color)64);
          partEdit->callback((Fl_Callback*)cb_partEdit);
        } // Fl_Button* partEdit
        { partControllers = new Fl_Button(72, 405, 81, 20, "Con&trollers");
          partControllers->tooltip("MIDI Controller range settings");
          partControllers->box(FL_GTK_THIN_UP_BOX);
          partControllers->color((Fl_Color)198);
          partControllers->labelsize(12);
          partControllers->labelcolor((Fl_Color)64);
          partControllers->callback((Fl_Callback*)cb_partControllers);
        } // Fl_Button* partControllers
        { partMidiCCs = new Fl_Button(164, 405, 64, 20, "Mi&di CCs");
          partMidiCCs->tooltip("Emulates common MIDI CCs");
          partMidiCCs->box(FL_GTK_THIN_UP_BOX);
          partMidiCCs->color((Fl_Color)198);
          partMidiCCs->labelsize(12);
          partMidiCCs->labelcolor((Fl_Color)64);
          partMidiCCs->callback((Fl_Callback*)cb_partMidiCCs);
        } // Fl_Button* partMidiCCs
        { modepatch = new Fl_Box(141, 357, 32, 16, "Mode");
          modepatch->box(FL_FLAT_BOX);
          modepatch->labelsize(11);
          modepatch->labelcolor((Fl_Color)64);
        } // Fl_Box* modepatch
        { Fl_Choice* o = partKeymode = new Fl_Choice(65, 355, 72, 19);
          partKeymode->tooltip("Poly, Mono or Legato mode");
          partKeymode->down_box(FL_BORDER_BOX);
          partKeymode->labelsize(11);
          partKeymode->labelcolor((Fl_Color)64);
          partKeymode->textfont(1);
          partKeymode->textsize(11);
          partKeymode->textcolor((Fl_Color)64);
          partKeymode->callback((Fl_Callback*)cb_partKeymode);
          o->add("Poly");o->add("Mono");o->add("Legato");
          int tmp = synth->ReadPartKeyMode(npart); if (tmp > 1) o->value(2); else o->value(tmp);
          o->value(fetchData(0, PART::control::keyMode, npart));
        } // Fl_Choice* partKeymode
        { Fl_Check_Button2* o = partPortamento = new Fl_Check_Button2(83, 381, 20, 20, "Portamento");
          partPortamento->tooltip("Enable/Disable the portamento");
          partPortamento->box(FL_NO_BOX);
          partPortamento->down_box(FL_DOWN_BOX);
          partPortamento->color(FL_BACKGROUND_COLOR);
          partPortamento->selection_color(FL_FOREGROUND_COLOR);
          partPortamento->labeltype(FL_NORMAL_LABEL);
          partPortamento->labelfont(3);
          partPortamento->labelsize(11);
          partPortamento->labelcolor((Fl_Color)226);
          partPortamento->callback((Fl_Callback*)cb_partPortamento);
          partPortamento->align(Fl_Align(FL_ALIGN_RIGHT));
          partPortamento->when(FL_WHEN_RELEASE);
          o->value(fetchData(0, PART::control::portamento, npart));
        } // Fl_Check_Button2* partPortamento
        { WidgetSpinner* o = minKeyCount = new WidgetSpinner(59, 431, 41, 20, "Min Note");
          minKeyCount->tooltip("Minimum note the part receives");
          minKeyCount->box(FL_NO_BOX);
          minKeyCount->color(FL_BACKGROUND_COLOR);
          minKeyCount->selection_color(FL_BACKGROUND_COLOR);
          minKeyCount->labeltype(FL_NORMAL_LABEL);
          minKeyCount->labelfont(0);
          minKeyCount->labelsize(10);
          minKeyCount->labelcolor((Fl_Color)64);
          minKeyCount->minimum(0);
          minKeyCount->maximum(127);
          minKeyCount->textsize(11);
          minKeyCount->textcolor((Fl_Color)64);
          minKeyCount->callback((Fl_Callback*)cb_minKeyCount);
          minKeyCount->align(Fl_Align(FL_ALIGN_LEFT));
          minKeyCount->when(FL_WHEN_RELEASE);
          o->value(fetchData(0, PART::control::minNote, npart));
        } // WidgetSpinner* minKeyCount
        { WidgetSpinner* o = maxKeyCount = new WidgetSpinner(59, 463, 41, 20, "Max Note");
          maxKeyCount->tooltip("Maximum note the part receives");
          maxKeyCount->box(FL_NO_BOX);
          maxKeyCount->color(FL_BACKGROUND_COLOR);
          maxKeyCount->selection_color(FL_BACKGROUND_COLOR);
          maxKeyCount->labeltype(FL_NORMAL_LABEL);
          maxKeyCount->labelfont(0);
          maxKeyCount->labelsize(10);
          maxKeyCount->labelcolor((Fl_Color)64);
          maxKeyCount->minimum(0);
          maxKeyCount->maximum(127);
          maxKeyCount->textsize(11);
          maxKeyCount->textcolor((Fl_Color)64);
          maxKeyCount->callback((Fl_Callback*)cb_maxKeyCount);
          maxKeyCount->align(Fl_Align(FL_ALIGN_LEFT));
          maxKeyCount->when(FL_WHEN_RELEASE);
          o->value(fetchData(0, PART::control::maxNote, npart));
        } // WidgetSpinner* maxKeyCount
        { setMinToLast = new Fl_Button(105, 432, 30, 16, "Set");
          setMinToLast->tooltip("Set minimum note to the last note played");
          setMinToLast->box(FL_PLASTIC_UP_BOX);
          setMinToLast->color((Fl_Color)228);
          setMinToLast->labelsize(10);
          setMinToLast->labelcolor((Fl_Color)64);
          setMinToLast->callback((Fl_Callback*)cb_setMinToLast);
        } // Fl_Button* setMinToLast
        { setNormal = new Fl_Button(105, 450, 30, 16, "R");
          setNormal->tooltip("Reset the minimum key to 0 and maximum key to 127");
          setNormal->box(FL_PLASTIC_UP_BOX);
          setNormal->color((Fl_Color)228);
          setNormal->labelfont(1);
          setNormal->labelsize(11);
          setNormal->labelcolor((Fl_Color)64);
          setNormal->callback((Fl_Callback*)cb_setNormal);
        } // Fl_Button* setNormal
        { setMaxToLast = new Fl_Button(105, 468, 30, 16, "Set");
          setMaxToLast->tooltip("Set maximum note to the last note played");
          setMaxToLast->box(FL_PLASTIC_UP_BOX);
          setMaxToLast->color((Fl_Color)228);
          setMaxToLast->labelsize(10);
          setMaxToLast->labelcolor((Fl_Color)64);
          setMaxToLast->callback((Fl_Callback*)cb_setMaxToLast);
        } // Fl_Button* setMaxToLast
        { WidgetSpinner* o = partKeyShift = new WidgetSpinner(192, 432, 38, 20, "Key Shift");
          partKeyShift->box(FL_NO_BOX);
          partKeyShift->color(FL_BACKGROUND_COLOR);
          partKeyShift->selection_color(FL_BACKGROUND_COLOR);
          partKeyShift->labeltype(FL_NORMAL_LABEL);
          partKeyShift->labelfont(0);
          partKeyShift->labelsize(10);
          partKeyShift->labelcolor((Fl_Color)64);
          partKeyShift->minimum(-36);
          partKeyShift->maximum(36);
          partKeyShift->textsize(11);
          partKeyShift->textcolor((Fl_Color)64);
          partKeyShift->callback((Fl_Callback*)cb_partKeyShift);
          partKeyShift->align(Fl_Align(FL_ALIGN_LEFT));
          partKeyShift->when(FL_WHEN_RELEASE);
          o->range(MIN_KEY_SHIFT, MAX_KEY_SHIFT);
          o->value(fetchData(0, PART::control::keyShift, npart));
        } // WidgetSpinner* partKeyShift
        { WidgetSpinner* o = partKeyLimit = new WidgetSpinner(192, 464, 38, 20, "Key Limit");
          partKeyLimit->tooltip("Maximum keys for this part");
          partKeyLimit->box(FL_NO_BOX);
          partKeyLimit->color(FL_BACKGROUND_COLOR);
          partKeyLimit->selection_color(FL_BACKGROUND_COLOR);
          partKeyLimit->labeltype(FL_NORMAL_LABEL);
          partKeyLimit->labelfont(0);
          partKeyLimit->labelsize(10);
          partKeyLimit->labelcolor((Fl_Color)64);
          partKeyLimit->value(20);
          partKeyLimit->textsize(11);
          partKeyLimit->textcolor((Fl_Color)64);
          partKeyLimit->callback((Fl_Callback*)cb_partKeyLimit);
          partKeyLimit->align(Fl_Align(FL_ALIGN_LEFT));
          partKeyLimit->when(FL_WHEN_RELEASE);
          o->range(1, POLYPHONY); // enough for one part!
          o->value(fetchData(0, PART::control::maxNotes, npart));
        } // WidgetSpinner* partKeyLimit
        { sysEffBox = new Fl_Group(236, 412, 139, 73);
          sysEffBox->box(FL_ENGRAVED_FRAME);
          sysEffBox->labelcolor((Fl_Color)64);
          { sysEffName = new Fl_Text_Display(255, 463, 103, 1, "Send to System Effect");
            sysEffName->box(FL_NO_BOX);
            sysEffName->selection_color((Fl_Color)64);
            sysEffName->labelsize(11);
            sysEffName->labelcolor((Fl_Color)64);
            sysEffName->textcolor((Fl_Color)64);
            sysEffName->align(Fl_Align(FL_ALIGN_BOTTOM));
          } // Fl_Text_Display* sysEffName
          { WidgetPDial* o = sysEff1 = new WidgetPDial(243, 434, 25, 25, "1");
            sysEff1->box(FL_OVAL_BOX);
            sysEff1->color(FL_BACKGROUND_COLOR);
            sysEff1->selection_color(FL_INACTIVE_COLOR);
            sysEff1->labeltype(FL_NORMAL_LABEL);
            sysEff1->labelfont(1);
            sysEff1->labelsize(10);
            sysEff1->labelcolor((Fl_Color)64);
            sysEff1->maximum(127);
            sysEff1->step(1);
            sysEff1->callback((Fl_Callback*)cb_sysEff1);
            sysEff1->align(Fl_Align(FL_ALIGN_TOP));
            sysEff1->when(FL_WHEN_CHANGED);
            o->value(fetchData(0, PART::control::partToSystemEffect1, npart));
            o->setValueType(VC_percent127);
            o->selection_color(setKnob(o->value(),0));
          } // WidgetPDial* sysEff1
          { WidgetPDial* o = sysEff2 = new WidgetPDial(276, 434, 25, 25, "2");
            sysEff2->box(FL_OVAL_BOX);
            sysEff2->color(FL_BACKGROUND_COLOR);
            sysEff2->selection_color(FL_INACTIVE_COLOR);
            sysEff2->labeltype(FL_NORMAL_LABEL);
            sysEff2->labelfont(1);
            sysEff2->labelsize(10);
            sysEff2->labelcolor((Fl_Color)64);
            sysEff2->maximum(127);
            sysEff2->step(1);
            sysEff2->callback((Fl_Callback*)cb_sysEff2);
            sysEff2->align(Fl_Align(FL_ALIGN_TOP));
            sysEff2->when(FL_WHEN_CHANGED);
            o->value(fetchData(0, PART::control::partToSystemEffect2, npart));
            o->setValueType(VC_percent127);
            o->selection_color(setKnob(o->value(),0));
          } // WidgetPDial* sysEff2
          { WidgetPDial* o = sysEff3 = new WidgetPDial(309, 434, 25, 25, "3");
            sysEff3->box(FL_OVAL_BOX);
            sysEff3->color(FL_BACKGROUND_COLOR);
            sysEff3->selection_color(FL_INACTIVE_COLOR);
            sysEff3->labeltype(FL_NORMAL_LABEL);
            sysEff3->labelfont(1);
            sysEff3->labelsize(10);
            sysEff3->labelcolor((Fl_Color)64);
            sysEff3->maximum(127);
            sysEff3->step(1);
            sysEff3->callback((Fl_Callback*)cb_sysEff3);
            sysEff3->align(Fl_Align(FL_ALIGN_TOP));
            sysEff3->when(FL_WHEN_CHANGED);
            o->value(fetchData(0, PART::control::partToSystemEffect3, npart));
            o->setValueType(VC_percent127);
            o->selection_color(setKnob(o->value(),0));
          } // WidgetPDial* sysEff3
          { WidgetPDial* o = sysEff4 = new WidgetPDial(342, 434, 25, 25, "4");
            sysEff4->box(FL_OVAL_BOX);
            sysEff4->color(FL_BACKGROUND_COLOR);
            sysEff4->selection_color(FL_INACTIVE_COLOR);
            sysEff4->labeltype(FL_NORMAL_LABEL);
            sysEff4->labelfont(1);
            sysEff4->labelsize(10);
            sysEff4->labelcolor((Fl_Color)64);
            sysEff4->maximum(127);
            sysEff4->step(1);
            sysEff4->callback((Fl_Callback*)cb_sysEff4);
            sysEff4->align(Fl_Align(FL_ALIGN_TOP));
            sysEff4->when(FL_WHEN_CHANGED);
            o->value(fetchData(0, PART::control::partToSystemEffect4, npart));
            o->setValueType(VC_percent127);
            o->selection_color(setKnob(o->value(),0));
          } // WidgetPDial* sysEff4
          sysEffBox->end();
        } // Fl_Group* sysEffBox
        { Fl_Check_Button2* o = partOmniEnable = new Fl_Check_Button2(46, 406, 15, 20, "Omni");
          partOmniEnable->tooltip("Enable part to listen on all MIDI channels. If Omni Mode Change is enabled in"
" configuration, then a MIDI message of that type overrides this setting. Toggl"
"e this setting to reset it after such a MIDI message.");
          partOmniEnable->box(FL_NO_BOX);
          partOmniEnable->down_box(FL_DOWN_BOX);
          partOmniEnable->color(FL_BACKGROUND_COLOR);
          partOmniEnable->selection_color((Fl_Color)64);
          partOmniEnable->labeltype(FL_NORMAL_LABEL);
          partOmniEnable->labelfont(0);
          partOmniEnable->labelsize(12);
          partOmniEnable->labelcolor((Fl_Color)64);
          partOmniEnable->callback((Fl_Callback*)cb_partOmniEnable);
          partOmniEnable->align(Fl_Align(FL_ALIGN_LEFT));
          partOmniEnable->when(FL_WHEN_RELEASE);
          o->value(fetchData(0,  PART::control::omni, npart));
        } // Fl_Check_Button2* partOmniEnable
        partControls->end();
      } // Fl_Group* partControls
      { Fl_Check_Button2* o = partEnable = new Fl_Check_Button2(35, 355, 20, 20, "On");
        partEnable->box(FL_NO_BOX);
        partEnable->down_box(FL_DOWN_BOX);
        partEnable->color(FL_BACKGROUND_COLOR);
        partEnable->selection_color((Fl_Color)64);
        partEnable->labeltype(FL_NORMAL_LABEL);
        partEnable->labelfont(0);
        partEnable->labelsize(14);
        partEnable->labelcolor((Fl_Color)64);
        partEnable->callback((Fl_Callback*)cb_partEnable);
        partEnable->align(Fl_Align(FL_ALIGN_LEFT));
        partEnable->when(FL_WHEN_RELEASE);
        o->value(fetchData(0,  PART::control::enable, npart));
      } // Fl_Check_Button2* partEnable
      partuigroup->end();
    } // Fl_Group* partuigroup
    { Fl_Group* o = new Fl_Group(3, 490, 379, 35);
      o->box(FL_DOWN_BOX);
      o->color((Fl_Color)43);
      o->labelsize(12);
      { VUMeter* o = vumeter = new VUMeter(3, 491, 379, 34, "VU-Meter");
        vumeter->box(FL_NO_BOX);
        vumeter->color((Fl_Color)48);
        vumeter->selection_color(FL_BACKGROUND_COLOR);
        vumeter->labeltype(FL_NORMAL_LABEL);
        vumeter->labelfont(0);
        vumeter->labelsize(14);
        vumeter->labelcolor(FL_FOREGROUND_COLOR);
        vumeter->align(Fl_Align(FL_ALIGN_CENTER));
        vumeter->when(FL_WHEN_RELEASE);
        o->init(-1, synth);
      } // VUMeter* vumeter
      { Fl_Button* o = new Fl_Button(5, 493, 376, 30);
        o->tooltip("Click here to clear VU peak reading and overload warning.");
        o->box(FL_NO_BOX);
        o->labelcolor((Fl_Color)64);
        o->callback((Fl_Callback*)cb_);
      } // Fl_Button* o
      o->end();
    } // Fl_Group* o
    { Fl_Button* o = mastermono = new Fl_Button(7, 90, 66, 24, "Stereo");
      mastermono->tooltip("Master Mono/Stereo switch");
      mastermono->box(FL_PLASTIC_UP_BOX);
      mastermono->down_box(FL_PLASTIC_UP_BOX);
      mastermono->color((Fl_Color)228);
      mastermono->selection_color((Fl_Color)89);
      mastermono->labelfont(3);
      mastermono->labelsize(11);
      mastermono->labelcolor((Fl_Color)226);
      mastermono->callback((Fl_Callback*)cb_mastermono);
      o->value(synth->masterMono);
    } // Fl_Button* mastermono
    { WidgetSpinner* o = maxparts = new WidgetSpinner(93, 322, 40, 20, "of");
      maxparts->tooltip("Set the number of available parts");
      maxparts->box(FL_NO_BOX);
      maxparts->color(FL_BACKGROUND_COLOR);
      maxparts->selection_color(FL_BACKGROUND_COLOR);
      maxparts->labeltype(FL_NORMAL_LABEL);
      maxparts->labelfont(0);
      maxparts->labelsize(11);
      maxparts->labelcolor((Fl_Color)64);
      maxparts->minimum(16);
      maxparts->maximum(64);
      maxparts->step(16);
      maxparts->value(16);
      maxparts->textsize(11);
      maxparts->textcolor((Fl_Color)64);
      maxparts->callback((Fl_Callback*)cb_maxparts);
      maxparts->align(Fl_Align(FL_ALIGN_LEFT));
      maxparts->when(FL_WHEN_RELEASE);
      o->value(partmax);
    } // WidgetSpinner* maxparts
    { WidgetSpinner* o = npartcounter = new WidgetSpinner(36, 322, 40, 20, "Part");
      npartcounter->box(FL_NO_BOX);
      npartcounter->color(FL_BACKGROUND_COLOR);
      npartcounter->selection_color(FL_BACKGROUND_COLOR);
      npartcounter->labeltype(FL_NORMAL_LABEL);
      npartcounter->labelfont(0);
      npartcounter->labelsize(11);
      npartcounter->labelcolor((Fl_Color)64);
      npartcounter->minimum(0);
      npartcounter->maximum(64);
      npartcounter->textsize(11);
      npartcounter->textcolor((Fl_Color)64);
      npartcounter->callback((Fl_Callback*)cb_npartcounter);
      npartcounter->align(Fl_Align(FL_ALIGN_LEFT));
      npartcounter->when(FL_WHEN_RELEASE_ALWAYS);
      o->value(collect_readData(synth, 0, MAIN::control::partNumber, TOPLEVEL::main) + 1);
      bankui->init(o);
    } // WidgetSpinner* npartcounter
    { Fl_Choice* o = panning_law = new Fl_Choice(84, 122, 164, 20, "Pan Law ");
      panning_law->tooltip("Relative values when panned to extremes:\n   Per side, Equivalent Mono");
      panning_law->down_box(FL_BORDER_BOX);
      panning_law->labelsize(11);
      panning_law->labelcolor((Fl_Color)64);
      panning_law->textfont(1);
      panning_law->textsize(12);
      panning_law->textcolor((Fl_Color)64);
      panning_law->callback((Fl_Callback*)cb_panning_law);
      o->add("Cut: 0dB, -6dB");o->add("Default: +3dB, -3dB");o->add("Boost: +6dB, 0dB");
      o->value(fetchData(0, MAIN::control::panLawType, TOPLEVEL::section::main));
    } // Fl_Choice* panning_law
    { setInstance = new Fl_Group(82, 57, 193, 60);
      setInstance->box(FL_PLASTIC_UP_BOX);
      setInstance->color(FL_CYAN);
      setInstance->hide();
      { Fl_Button* o = new Fl_Button(84, 59, 188, 57);
        o->box(FL_NO_BOX);
      } // Fl_Button* o
      { InstBlurb = new Fl_Text_Display(95, 89, 163, 6, "Accept next, or enter\nInstance from 1 to 31");
        InstBlurb->box(FL_NO_BOX);
        InstBlurb->labelsize(12);
      } // Fl_Text_Display* InstBlurb
      { Fl_Button* o = new Fl_Button(162, 91, 35, 22);
        o->box(FL_FLAT_BOX);
        o->down_box(FL_FLAT_BOX);
        o->labelfont(1);
        o->labelsize(11);
        o->callback((Fl_Callback*)cb_1);
      } // Fl_Button* o
      { cancelInst = new Fl_Button(209, 90, 56, 22, "Cancel");
        cancelInst->box(FL_PLASTIC_UP_BOX);
        cancelInst->labelfont(1);
        cancelInst->labelsize(11);
        cancelInst->callback((Fl_Callback*)cb_cancelInst);
      } // Fl_Button* cancelInst
      { nextInst = new Fl_Button(93, 90, 56, 22, "Next");
        nextInst->box(FL_PLASTIC_UP_BOX);
        nextInst->labelfont(1);
        nextInst->labelsize(11);
        nextInst->callback((Fl_Callback*)cb_nextInst);
      } // Fl_Button* nextInst
      { valueInst = new Fl_Input(162, 90, 37, 22);
        valueInst->textsize(11);
        valueInst->callback((Fl_Callback*)cb_valueInst);
      } // Fl_Input* valueInst
      setInstance->end();
    } // Fl_Group* setInstance
    { divider = new Fl_Box(18, 350, 350, 2);
      divider->box(FL_THIN_DOWN_FRAME);
    } // Fl_Box* divider
    masterwindow->resizable(masterwindow);
    mainDW = 385; mainDH = 470;
    masterwindow->size_range(394, 500, 0, 0, 0, 0, 1);
    masterwindow->end();
  } // ScaleTrackedWindow* masterwindow
// line spaces in boxes below are critical
  { ScaleTrackedWindow* o = aboutwindow = new ScaleTrackedWindow(365, 290, "Yoshimi : About");
    aboutwindow->box(FL_FLAT_BOX);
    aboutwindow->color(FL_BACKGROUND2_COLOR);
    aboutwindow->selection_color(FL_BACKGROUND_COLOR);
    aboutwindow->labeltype(FL_NO_LABEL);
    aboutwindow->labelfont(13);
    aboutwindow->labelsize(13);
    aboutwindow->labelcolor((Fl_Color)64);
    aboutwindow->user_data((void*)(this));
    aboutwindow->align(Fl_Align(FL_ALIGN_TOP));
    aboutwindow->when(FL_WHEN_NEVER);
    { aboutFirst = new Fl_Group(0, 0, 365, 290);
      aboutFirst->color(FL_BACKGROUND2_COLOR);
      aboutFirst->labelcolor((Fl_Color)64);
      { about1 = new Fl_Box(10, 15, 345, 70, "Yoshimi\nmeets\nZynAddSubFX");
        about1->labelfont(9);
        about1->labelsize(18);
        about1->labelcolor(FL_BLUE);
        about1->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        about1->when(FL_WHEN_NEVER);
      } // Fl_Box* about1
      { about2 = new Fl_Box(25, 90, 315, 91, "Copyright 2002-2009, Nasca O. Paul and others\nCopyright 2009-2011, Alan Calv"
"ert\nCopyright 2012-2013, Jeremy Jongepier and others\nCopyright 2014-2024, Wi"
"ll Godfrey and others\nLV2 plugin Copyright 2014, Andrew Deryabin\nSplash Imag"
"e Copyright 2017, Jesper Lloyd");
        about2->labelfont(13);
        about2->labelsize(11);
        about2->labelcolor((Fl_Color)64);
      } // Fl_Box* about2
      { about3 = new Fl_Box(10, 190, 340, 53, "This is free software, and comes with ABSOLUTELY NO\nWARRANTY; you may redist"
"ribute it and/or modify it\nunder the terms of GPL version 2, or (at your opti"
"on)\nany later version.");
        about3->labelsize(11);
        about3->labelcolor((Fl_Color)64);
      } // Fl_Box* about3
      { Fl_Box* o = about4 = new Fl_Box(61, 254, 240, 20, " version");
        about4->labelfont(1);
        about4->labelsize(12);
        about4->labelcolor((Fl_Color)224);
        //
            o->copy_label((string("Yoshimi version ")
                           + string(YOSHIMI_VERSION)).c_str());
      } // Fl_Box* about4
      { about5 = new Fl_Button(15, 253, 43, 22, "more");
        about5->tooltip("Yoshimi\'s little band of helpers");
        about5->box(FL_PLASTIC_THIN_UP_BOX);
        about5->color((Fl_Color)228);
        about5->labelfont(1);
        about5->labelsize(11);
        about5->labelcolor((Fl_Color)64);
        about5->callback((Fl_Callback*)cb_about5);
      } // Fl_Button* about5
      aboutFirst->end();
    } // Fl_Group* aboutFirst
    { contributors = new Fl_Group(5, 5, 355, 280);
      contributors->box(FL_FLAT_BOX);
      contributors->color(FL_BACKGROUND2_COLOR);
      contributors->labelcolor((Fl_Color)64);
      contributors->hide();
      { cont1 = new Fl_Box(12, 8, 340, 57, "Some people who have helped Yoshimi\n in various ways since\nAlan Calvert sta"
"rted the project");
        cont1->labelfont(9);
        cont1->labelsize(15);
        cont1->labelcolor((Fl_Color)224);
      } // Fl_Box* cont1
      { cont2 = new Fl_Box(25, 70, 155, 200, "\n          Chris Ahlstrom\n          Kristian Amlie\n          Jonathan Bric"
"kman\n          Jeanette Claassen\n          Rob Couto\n          Andrew Derya"
"bin\n          J\303\266rn Eichler\n          Csaba Erdei\n          James Fra"
"ser\n          Will Godfrey\n          Alexander Hirsch\n          Jeremy Jong"
"epier\n          Iain King-Speir\n          Tobias Kortkamp\n          ");
        cont2->labelsize(12);
        cont2->labelcolor((Fl_Color)64);
      } // Fl_Box* cont2
      { cont3 = new Fl_Box(194, 70, 155, 200, "\n          Tito Latini\n          Rainer Liffers\n          Jesper Lloyd\n  "
"        Lars Luthman\n          Holger Marzen\n          Lieven Moors\n       "
"   Harry Nakos\n          Iurie Nistor\n          Stephen Parry\n          Lor"
"enzo Sutton\n          Hermann Vo\303\237eler\n          Nikita Zlobin\n\n\n  "
"        ");
        cont3->labelsize(12);
        cont3->labelcolor((Fl_Color)64);
      } // Fl_Box* cont3
      contributors->end();
    } // Fl_Group* contributors
    { aboutClose = new Fl_Button(305, 253, 43, 22, "Close");
      aboutClose->box(FL_THIN_UP_BOX);
      aboutClose->color((Fl_Color)196);
      aboutClose->labelfont(1);
      aboutClose->labelsize(11);
      aboutClose->labelcolor((Fl_Color)64);
      aboutClose->callback((Fl_Callback*)cb_aboutClose);
    } // Fl_Button* aboutClose
    aboutwindow->resizable(aboutwindow);
    aboutDW = 365; aboutDH = 290;
    o->size_range(aboutDW,aboutDH, 0, 0, 0, 0, 1);
    aboutwindow->end();
  } // ScaleTrackedWindow* aboutwindow
  { ScaleTrackedWindow* o = syseffsendwindow = new ScaleTrackedWindow(120, 245, "Yoshimi : Sys Send");
    syseffsendwindow->box(FL_FLAT_BOX);
    syseffsendwindow->color(FL_BACKGROUND_COLOR);
    syseffsendwindow->selection_color(FL_BACKGROUND_COLOR);
    syseffsendwindow->labeltype(FL_NO_LABEL);
    syseffsendwindow->labelfont(13);
    syseffsendwindow->labelsize(13);
    syseffsendwindow->labelcolor(FL_FOREGROUND_COLOR);
    syseffsendwindow->callback((Fl_Callback*)cb_syseffsendwindow, (void*)(this));
    syseffsendwindow->align(Fl_Align(FL_ALIGN_TOP));
    syseffsendwindow->when(FL_WHEN_RELEASE);
    { syseffClose = new Fl_Button(20, 216, 80, 25, "Close");
      syseffClose->box(FL_THIN_UP_BOX);
      syseffClose->color((Fl_Color)196);
      syseffClose->labelcolor((Fl_Color)64);
      syseffClose->callback((Fl_Callback*)cb_syseffClose);
    } // Fl_Button* syseffClose
    { syseffname = new Fl_Box(5, 5, 110, 35, "Send output of system effect  to other system effects");
      syseffname->labelsize(10);
      syseffname->labelcolor((Fl_Color)64);
      syseffname->align(Fl_Align(192));
    } // Fl_Box* syseffname
    { WidgetPDial* o = syseff01 = new WidgetPDial(9, 65, 30, 30);
      syseff01->box(FL_OVAL_BOX);
      syseff01->color(FL_BACKGROUND_COLOR);
      syseff01->selection_color(FL_INACTIVE_COLOR);
      syseff01->labeltype(FL_NORMAL_LABEL);
      syseff01->labelfont(0);
      syseff01->labelsize(10);
      syseff01->labelcolor(FL_FOREGROUND_COLOR);
      syseff01->maximum(127);
      syseff01->step(1);
      syseff01->callback((Fl_Callback*)cb_syseff01);
      syseff01->align(Fl_Align(FL_ALIGN_TOP));
      syseff01->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff01
    { WidgetPDial* o = syseff02 = new WidgetPDial(45, 65, 30, 30);
      syseff02->box(FL_OVAL_BOX);
      syseff02->color(FL_BACKGROUND_COLOR);
      syseff02->selection_color(FL_INACTIVE_COLOR);
      syseff02->labeltype(FL_NORMAL_LABEL);
      syseff02->labelfont(0);
      syseff02->labelsize(10);
      syseff02->labelcolor(FL_FOREGROUND_COLOR);
      syseff02->maximum(127);
      syseff02->step(1);
      syseff02->callback((Fl_Callback*)cb_syseff02);
      syseff02->align(Fl_Align(FL_ALIGN_TOP));
      syseff02->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff02
    { WidgetPDial* o = syseff03 = new WidgetPDial(83, 65, 30, 30);
      syseff03->box(FL_OVAL_BOX);
      syseff03->color(FL_BACKGROUND_COLOR);
      syseff03->selection_color(FL_INACTIVE_COLOR);
      syseff03->labeltype(FL_NORMAL_LABEL);
      syseff03->labelfont(0);
      syseff03->labelsize(10);
      syseff03->labelcolor(FL_FOREGROUND_COLOR);
      syseff03->maximum(127);
      syseff03->step(1);
      syseff03->callback((Fl_Callback*)cb_syseff03);
      syseff03->align(Fl_Align(FL_ALIGN_TOP));
      syseff03->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff03
    { WidgetPDial* o = syseff12 = new WidgetPDial(45, 118, 30, 30);
      syseff12->box(FL_OVAL_BOX);
      syseff12->color(FL_BACKGROUND_COLOR);
      syseff12->selection_color(FL_INACTIVE_COLOR);
      syseff12->labeltype(FL_NORMAL_LABEL);
      syseff12->labelfont(0);
      syseff12->labelsize(10);
      syseff12->labelcolor(FL_FOREGROUND_COLOR);
      syseff12->maximum(127);
      syseff12->step(1);
      syseff12->callback((Fl_Callback*)cb_syseff12);
      syseff12->align(Fl_Align(FL_ALIGN_TOP));
      syseff12->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff12
    { WidgetPDial* o = syseff13 = new WidgetPDial(83, 118, 30, 30);
      syseff13->box(FL_OVAL_BOX);
      syseff13->color(FL_BACKGROUND_COLOR);
      syseff13->selection_color(FL_INACTIVE_COLOR);
      syseff13->labeltype(FL_NORMAL_LABEL);
      syseff13->labelfont(0);
      syseff13->labelsize(10);
      syseff13->labelcolor(FL_FOREGROUND_COLOR);
      syseff13->maximum(127);
      syseff13->step(1);
      syseff13->callback((Fl_Callback*)cb_syseff13);
      syseff13->align(Fl_Align(FL_ALIGN_TOP));
      syseff13->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff13
    { WidgetPDial* o = syseff23 = new WidgetPDial(83, 171, 30, 30);
      syseff23->box(FL_OVAL_BOX);
      syseff23->color(FL_BACKGROUND_COLOR);
      syseff23->selection_color(FL_INACTIVE_COLOR);
      syseff23->labeltype(FL_NORMAL_LABEL);
      syseff23->labelfont(0);
      syseff23->labelsize(10);
      syseff23->labelcolor(FL_FOREGROUND_COLOR);
      syseff23->maximum(127);
      syseff23->step(1);
      syseff23->callback((Fl_Callback*)cb_syseff23);
      syseff23->align(Fl_Align(FL_ALIGN_TOP));
      syseff23->when(FL_WHEN_CHANGED);
      o->setValueType(VC_percent127);
    } // WidgetPDial* syseff23
    { sys01txt = new Fl_Box(7, 50, 35, 17, "1->2");
      sys01txt->labelsize(10);
      sys01txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys01txt
    { sys02txt = new Fl_Box(43, 50, 35, 17, "1->3");
      sys02txt->labelsize(10);
      sys02txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys02txt
    { sys03txt = new Fl_Box(80, 50, 35, 17, "1->4");
      sys03txt->labelsize(10);
      sys03txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys03txt
    { sys12txt = new Fl_Box(44, 103, 35, 17, "2->3");
      sys12txt->labelsize(10);
      sys12txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys12txt
    { sys13txt = new Fl_Box(82, 103, 35, 17, "2->4");
      sys13txt->labelsize(10);
      sys13txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys13txt
    { sys23txt = new Fl_Box(82, 156, 35, 17, "3->4");
      sys23txt->labelsize(10);
      sys23txt->labelcolor((Fl_Color)64);
    } // Fl_Box* sys23txt
    syseffsendwindow->resizable(syseffsendwindow);
    syseffDW = 120; syseffDH = 245;
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Sends"), UNUSED, TOPLEVEL::windowTitle)).c_str());
    o->size_range(syseffDW, syseffDH, 0, 0, 0, 0, 1);
    syseffsendwindow->end();
  } // ScaleTrackedWindow* syseffsendwindow
  { ScaleTrackedWindow* o = panelwindow = new ScaleTrackedWindow(1040, 320, "Yoshimi : Mixer Panel");
    panelwindow->box(FL_FLAT_BOX);
    panelwindow->color(FL_BACKGROUND_COLOR);
    panelwindow->selection_color(FL_BACKGROUND_COLOR);
    panelwindow->labeltype(FL_NO_LABEL);
    panelwindow->labelfont(13);
    panelwindow->labelsize(13);
    panelwindow->labelcolor(FL_FOREGROUND_COLOR);
    panelwindow->callback((Fl_Callback*)cb_panelwindow, (void*)(this));
    panelwindow->align(Fl_Align(FL_ALIGN_TOP));
    panelwindow->when(FL_WHEN_RELEASE);
    { Panelframe = new Fl_Group(2, 2, 1036, 286);
      Panelframe->box(FL_ENGRAVED_FRAME);
      //
          for (int i = 0; i < 16; i++)
          {
              panellistitem[i] = new Panellistitem(0, 0, 64, 270, "");
              panellistitem[i]->init(i, bankui, synth);
          }
      Panelframe->end();
    } // Fl_Group* Panelframe
    { towide = new Fl_Button(360, 290, 130, 25, "Change to 1 x 16");
      towide->box(FL_PLASTIC_THIN_UP_BOX);
      towide->color((Fl_Color)228);
      towide->labelcolor((Fl_Color)64);
      towide->callback((Fl_Callback*)cb_towide);
    } // Fl_Button* towide
    { todeep = new Fl_Button(831, 290, 120, 25, "Change to 2 x 8");
      todeep->box(FL_PLASTIC_THIN_UP_BOX);
      todeep->color((Fl_Color)228);
      todeep->labelcolor((Fl_Color)64);
      todeep->callback((Fl_Callback*)cb_todeep);
    } // Fl_Button* todeep
    { Fl_Choice* o = Panelgroups = new Fl_Choice(5, 300, 86, 18, "Part Group");
      Panelgroups->down_box(FL_BORDER_BOX);
      Panelgroups->labelsize(12);
      Panelgroups->labelcolor((Fl_Color)64);
      Panelgroups->textsize(12);
      Panelgroups->textcolor((Fl_Color)64);
      Panelgroups->callback((Fl_Callback*)cb_Panelgroups);
      Panelgroups->align(Fl_Align(FL_ALIGN_TOP));
      o->add("1 to 16");o->add("17 to 32");o->add("33 to 48");o->add("49 to 64");
      o->value(panelgroup / NUM_MIDI_CHANNELS);
    } // Fl_Choice* Panelgroups
    { Fl_Choice* o = Panelsmallgroups = new Fl_Choice(5, 300, 86, 18, "Part Group");
      Panelsmallgroups->down_box(FL_BORDER_BOX);
      Panelsmallgroups->labelsize(12);
      Panelsmallgroups->labelcolor((Fl_Color)64);
      Panelsmallgroups->textsize(12);
      Panelsmallgroups->callback((Fl_Callback*)cb_Panelsmallgroups);
      Panelsmallgroups->align(Fl_Align(FL_ALIGN_TOP));
      o->add("1 to 16");o->add("17 to 32");
      o->value(panelgroup / NUM_MIDI_CHANNELS);
    } // Fl_Choice* Panelsmallgroups
    { WidgetSpinner* o = CSspinner = new WidgetSpinner(209, 300, 50, 18, "CC");
      CSspinner->box(FL_NO_BOX);
      CSspinner->color(FL_BACKGROUND_COLOR);
      CSspinner->selection_color(FL_BACKGROUND_COLOR);
      CSspinner->labeltype(FL_NORMAL_LABEL);
      CSspinner->labelfont(0);
      CSspinner->labelsize(12);
      CSspinner->labelcolor((Fl_Color)64);
      CSspinner->minimum(0);
      CSspinner->maximum(127);
      CSspinner->value(115);
      CSspinner->textsize(12);
      CSspinner->textcolor((Fl_Color)64);
      CSspinner->callback((Fl_Callback*)cb_CSspinner);
      CSspinner->align(Fl_Align(FL_ALIGN_TOP));
      CSspinner->when(FL_WHEN_RELEASE);
      CS_CC = collect_readData(synth, 0, MAIN::control::soloCC, TOPLEVEL::section::main);
      if (CS_CC < 128) o->value(CS_CC); else o->value(115);
    } // WidgetSpinner* CSspinner
    { CSpend = new Fl_Button(276, 290, 70, 25, "Pending");
      CSpend->tooltip("Click to set");
      CSpend->box(FL_PLASTIC_UP_BOX);
      CSpend->color((Fl_Color)90);
      CSpend->labelsize(12);
      CSpend->labelcolor((Fl_Color)64);
      CSpend->callback((Fl_Callback*)cb_CSpend);
      CSpend->hide();
    } // Fl_Button* CSpend
    { Fl_Choice* o = channelswitch = new Fl_Choice(114, 300, 74, 18, "Solo");
      channelswitch->tooltip("Assign groups of parts to Ch 1, singly enabled by MIDI");
      channelswitch->down_box(FL_BORDER_BOX);
      channelswitch->labelsize(12);
      channelswitch->labelcolor((Fl_Color)64);
      channelswitch->textsize(12);
      channelswitch->textcolor((Fl_Color)64);
      channelswitch->callback((Fl_Callback*)cb_channelswitch);
      channelswitch->align(Fl_Align(FL_ALIGN_TOP));
      o->add("Off");o->add("Row");o->add("Column");o->add("Loop");o->add("TwoWay");o->add("Channel");
      o->value(collect_readData(synth, 0, MAIN::control::soloType, TOPLEVEL::section::main));
      if (o->value() == 0) CSspinner->hide(); else CSspinner->show();
      CS_CC = o->value();
    } // Fl_Choice* channelswitch
    { Panelclose = new Fl_Button(975, 290, 60, 25, "&Close");
      Panelclose->box(FL_THIN_UP_BOX);
      Panelclose->color((Fl_Color)196);
      Panelclose->labelfont(1);
      Panelclose->labelcolor((Fl_Color)64);
      Panelclose->callback((Fl_Callback*)cb_Panelclose);
    } // Fl_Button* Panelclose
    panelwindow->resizable(panelwindow);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Mixer Panel"), UNUSED, TOPLEVEL::windowTitle)).c_str());
    panelwindow->end();
  } // ScaleTrackedWindow* panelwindow
  { Fl_Double_Window* o = message = new Fl_Double_Window(290, 85, "Yoshimi");
    message->labelsize(12);
    message->labelcolor((Fl_Color)64);
    message->user_data((void*)(this));
    { words = new Fl_Box(5, 9, 280, 45, "?");
      words->color((Fl_Color)55);
      words->selection_color((Fl_Color)55);
      words->labelfont(1);
      words->labelsize(12);
      words->labelcolor((Fl_Color)64);
      words->align(Fl_Align(133|FL_ALIGN_INSIDE));
    } // Fl_Box* words
    { yesdoit = new Fl_Button(49, 60, 70, 20, "Yes");
      yesdoit->box(FL_PLASTIC_THIN_UP_BOX);
      yesdoit->color((Fl_Color)228);
      yesdoit->labelcolor((Fl_Color)64);
      yesdoit->callback((Fl_Callback*)cb_yesdoit);
      yesdoit->hide();
    } // Fl_Button* yesdoit
    { cancel = new Fl_Button(130, 60, 70, 20, "Cancel");
      cancel->box(FL_PLASTIC_THIN_UP_BOX);
      cancel->color((Fl_Color)228);
      cancel->labelcolor((Fl_Color)64);
      cancel->callback((Fl_Callback*)cb_cancel);
      cancel->hide();
    } // Fl_Button* cancel
    { closebutton = new Fl_Button(211, 60, 70, 20, "Close");
      closebutton->color((Fl_Color)196);
      closebutton->labelcolor((Fl_Color)64);
      closebutton->callback((Fl_Callback*)cb_closebutton);
    } // Fl_Button* closebutton
    message->resizable(message);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push(""), UNUSED, TOPLEVEL::windowTitle)).c_str());
    msgDW = o->w(); msgDH = o->h();
    o->size_range(290, 85, 0, 0, 0, 0, 1);
    message->end();
  } // Fl_Double_Window* message
  { ScaleTrackedWindow* o = querywindow = new ScaleTrackedWindow(420, 105, "Yoshimi");
    querywindow->box(FL_FLAT_BOX);
    querywindow->color(FL_BACKGROUND_COLOR);
    querywindow->selection_color(FL_BACKGROUND_COLOR);
    querywindow->labeltype(FL_NO_LABEL);
    querywindow->labelfont(0);
    querywindow->labelsize(14);
    querywindow->labelcolor(FL_FOREGROUND_COLOR);
    querywindow->callback((Fl_Callback*)cb_querywindow, (void*)(this));
    querywindow->align(Fl_Align(FL_ALIGN_TOP));
    querywindow->when(FL_WHEN_RELEASE);
    { Fl_Button* o = yesQ = new Fl_Button(205, 80, 60, 20, "Yes");
      yesQ->box(FL_PLASTIC_THIN_UP_BOX);
      yesQ->color((Fl_Color)228);
      yesQ->labelcolor((Fl_Color)64);
      yesQ->callback((Fl_Callback*)cb_yesQ);
      o->value(0);
    } // Fl_Button* yesQ
    { Fl_Button* o = noQ = new Fl_Button(276, 80, 60, 20, "No");
      noQ->box(FL_PLASTIC_THIN_UP_BOX);
      noQ->color((Fl_Color)228);
      noQ->labelcolor((Fl_Color)64);
      noQ->callback((Fl_Callback*)cb_noQ);
      o->value(0);
    } // Fl_Button* noQ
    { Fl_Button* o = cancelQ = new Fl_Button(348, 80, 66, 20, "Cancel");
      cancelQ->color((Fl_Color)196);
      cancelQ->labelfont(1);
      cancelQ->labelcolor((Fl_Color)64);
      cancelQ->callback((Fl_Callback*)cb_cancelQ);
      o->value(0);
    } // Fl_Button* cancelQ
    { typeQ = new Fl_Box(8, 26, 45, 45, "?");
      typeQ->box(FL_THIN_DOWN_BOX);
      typeQ->color((Fl_Color)191);
      typeQ->labelfont(9);
      typeQ->labelsize(40);
      typeQ->labelcolor((Fl_Color)218);
    } // Fl_Box* typeQ
    { textQ = new Fl_Box(65, 11, 345, 63, "text goes here");
      textQ->labelcolor((Fl_Color)64);
      textQ->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Box* textQ
    querywindow->set_modal();
    querywindow->resizable(querywindow);
    queryDW = 420; queryDH = 105;
    o->size_range(queryDW, queryDH, 0, 0, 0, 0, 1);
    querywindow->end();
  } // ScaleTrackedWindow* querywindow
  { ScaleTrackedWindow* o = textwindow = new ScaleTrackedWindow(270, 60, "Yoshimi");
    textwindow->box(FL_FLAT_BOX);
    textwindow->color(FL_BACKGROUND_COLOR);
    textwindow->selection_color(FL_BACKGROUND_COLOR);
    textwindow->labeltype(FL_NO_LABEL);
    textwindow->labelfont(0);
    textwindow->labelsize(14);
    textwindow->labelcolor((Fl_Color)64);
    textwindow->callback((Fl_Callback*)cb_textwindow, (void*)(this));
    textwindow->align(Fl_Align(FL_ALIGN_TOP));
    textwindow->when(FL_WHEN_RELEASE);
    { textLine = new Fl_Input(20, 23, 230, 25, "input:");
      textLine->labelcolor((Fl_Color)64);
      textLine->textcolor((Fl_Color)64);
      textLine->align(Fl_Align(FL_ALIGN_TOP));
    } // Fl_Input* textLine
    textwindow->set_modal();
    textwindow->resizable(textwindow);
    textinDW = o->w(); textinDH = o->h();
    o->size_range(textinDW, textinDH, 0, 0, 0, 0, 1);
    textwindow->end();
  } // ScaleTrackedWindow* textwindow
  { ScaleTrackedWindow* o = filerwindow = new ScaleTrackedWindow(550, 350, "Yoshimi : Filer");
    filerwindow->box(FL_FLAT_BOX);
    filerwindow->color(FL_BACKGROUND_COLOR);
    filerwindow->selection_color(FL_BACKGROUND_COLOR);
    filerwindow->labeltype(FL_NO_LABEL);
    filerwindow->labelfont(0);
    filerwindow->labelsize(14);
    filerwindow->labelcolor(FL_FOREGROUND_COLOR);
    filerwindow->callback((Fl_Callback*)cb_filerwindow, (void*)(this));
    filerwindow->align(Fl_Align(FL_ALIGN_TOP));
    filerwindow->when(FL_WHEN_RELEASE);
    { fileroldpath = new Fl_Input(10, 20, 448, 25, "file paths");
      fileroldpath->tooltip("Current path to use(editable)");
      fileroldpath->labelfont(1);
      fileroldpath->labelsize(12);
      fileroldpath->labelcolor((Fl_Color)64);
      fileroldpath->textfont(1);
      fileroldpath->textsize(12);
      fileroldpath->textcolor((Fl_Color)64);
      fileroldpath->callback((Fl_Callback*)cb_fileroldpath);
      fileroldpath->align(Fl_Align(FL_ALIGN_TOP));
    } // Fl_Input* fileroldpath
    { filerback = new Fl_Button(463, 21, 78, 24, "Up");
      filerback->tooltip("Go up one directory in path");
      filerback->box(FL_PLASTIC_THIN_UP_BOX);
      filerback->color((Fl_Color)228);
      filerback->labelfont(1);
      filerback->labelsize(12);
      filerback->labelcolor((Fl_Color)64);
      filerback->callback((Fl_Callback*)cb_filerback);
    } // Fl_Button* filerback
    { faveGroup = new Fl_Group(458, 116, 85, 60, "Favourites");
      faveGroup->box(FL_ENGRAVED_FRAME);
      faveGroup->labelcolor((Fl_Color)64);
      { filerfave = new Fl_Button(463, 123, 75, 20, "Show List");
        filerfave->tooltip("Examine, re-order or delete entries");
        filerfave->box(FL_GTK_THIN_UP_BOX);
        filerfave->color((Fl_Color)198);
        filerfave->labelfont(1);
        filerfave->labelsize(12);
        filerfave->labelcolor((Fl_Color)64);
        filerfave->callback((Fl_Callback*)cb_filerfave);
      } // Fl_Button* filerfave
      { faveadd = new Fl_Button(463, 150, 75, 20, "Add");
        faveadd->tooltip("Add the current path to the favourites list");
        faveadd->box(FL_GTK_THIN_UP_BOX);
        faveadd->color((Fl_Color)198);
        faveadd->labelfont(1);
        faveadd->labelsize(12);
        faveadd->labelcolor((Fl_Color)64);
        faveadd->callback((Fl_Callback*)cb_faveadd);
      } // Fl_Button* faveadd
      faveGroup->end();
    } // Fl_Group* faveGroup
    { filerclose = new Fl_Button(463, 320, 78, 20, "Close");
      filerclose->color((Fl_Color)196);
      filerclose->labelfont(1);
      filerclose->labelsize(12);
      filerclose->labelcolor((Fl_Color)64);
      filerclose->callback((Fl_Callback*)cb_filerclose);
    } // Fl_Button* filerclose
    { filernamegroup = new Fl_Group(10, 50, 533, 26, "Name");
      filernamegroup->box(FL_ENGRAVED_FRAME);
      filernamegroup->labelfont(1);
      filernamegroup->labelsize(12);
      filernamegroup->labelcolor((Fl_Color)64);
      filernamegroup->align(Fl_Align(FL_ALIGN_BOTTOM));
      { filernewname = new Fl_Input(14, 53, 444, 20);
        filernewname->tooltip("Name of file item to load or save");
        filernewname->labelsize(12);
        filernewname->labelcolor((Fl_Color)64);
        filernewname->textfont(1);
        filernewname->textsize(12);
        filernewname->textcolor((Fl_Color)64);
        filernewname->callback((Fl_Callback*)cb_filernewname);
        filernewname->align(Fl_Align(FL_ALIGN_BOTTOM));
      } // Fl_Input* filernewname
      filernamegroup->end();
    } // Fl_Group* filernamegroup
    { fileruse = new Fl_Button(464, 53, 74, 20, "< Use");
      fileruse->tooltip("Apply this name to the path and load/save");
      fileruse->box(FL_PLASTIC_THIN_UP_BOX);
      fileruse->color((Fl_Color)228);
      fileruse->labelfont(1);
      fileruse->labelsize(12);
      fileruse->labelcolor((Fl_Color)64);
      fileruse->callback((Fl_Callback*)cb_fileruse);
    } // Fl_Button* fileruse
    { filerOpt8 = new Fl_Check_Button2(490, 204, 18, 18, "Hide Dirs");
      filerOpt8->tooltip("Hide sub directories so that files are easier to see");
      filerOpt8->box(FL_NO_BOX);
      filerOpt8->down_box(FL_DOWN_BOX);
      filerOpt8->color(FL_BACKGROUND_COLOR);
      filerOpt8->selection_color((Fl_Color)64);
      filerOpt8->labeltype(FL_NORMAL_LABEL);
      filerOpt8->labelfont(0);
      filerOpt8->labelsize(12);
      filerOpt8->labelcolor((Fl_Color)64);
      filerOpt8->callback((Fl_Callback*)cb_filerOpt8);
      filerOpt8->align(Fl_Align(FL_ALIGN_TOP));
      filerOpt8->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* filerOpt8
    { filerOpt1 = new Fl_Check_Button2(490, 244, 18, 18, ". (dot) Dirs");
      filerOpt1->tooltip("Show hidden paths");
      filerOpt1->box(FL_NO_BOX);
      filerOpt1->down_box(FL_DOWN_BOX);
      filerOpt1->color(FL_BACKGROUND_COLOR);
      filerOpt1->selection_color((Fl_Color)64);
      filerOpt1->labeltype(FL_NORMAL_LABEL);
      filerOpt1->labelfont(0);
      filerOpt1->labelsize(12);
      filerOpt1->labelcolor((Fl_Color)64);
      filerOpt1->callback((Fl_Callback*)cb_filerOpt1);
      filerOpt1->align(Fl_Align(FL_ALIGN_TOP));
      filerOpt1->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* filerOpt1
    { filerOpt2 = new Fl_Check_Button2(490, 284, 18, 18, ". (dot) Files");
      filerOpt2->tooltip("Show hidden files");
      filerOpt2->box(FL_NO_BOX);
      filerOpt2->down_box(FL_DOWN_BOX);
      filerOpt2->color(FL_BACKGROUND_COLOR);
      filerOpt2->selection_color(FL_FOREGROUND_COLOR);
      filerOpt2->labeltype(FL_NORMAL_LABEL);
      filerOpt2->labelfont(0);
      filerOpt2->labelsize(12);
      filerOpt2->labelcolor((Fl_Color)64);
      filerOpt2->callback((Fl_Callback*)cb_filerOpt2);
      filerOpt2->align(Fl_Align(FL_ALIGN_TOP));
      filerOpt2->when(FL_WHEN_RELEASE);
    } // Fl_Check_Button2* filerOpt2
    { filerOpt16 = new Fl_Check_Button2(490, 130, 18, 18, "Hide Files");
      filerOpt16->box(FL_NO_BOX);
      filerOpt16->down_box(FL_DOWN_BOX);
      filerOpt16->color(FL_BACKGROUND_COLOR);
      filerOpt16->selection_color((Fl_Color)64);
      filerOpt16->labeltype(FL_NORMAL_LABEL);
      filerOpt16->labelfont(0);
      filerOpt16->labelsize(12);
      filerOpt16->labelcolor((Fl_Color)64);
      filerOpt16->callback((Fl_Callback*)cb_filerOpt16);
      filerOpt16->align(Fl_Align(FL_ALIGN_TOP));
      filerOpt16->when(FL_WHEN_RELEASE);
      filerOpt16->hide();
    } // Fl_Check_Button2* filerOpt16
    { filerframe = new Fl_Group(4, 4, 542, 88);
      filerframe->box(FL_ENGRAVED_FRAME);
      filerframe->labelcolor((Fl_Color)64);
      filerframe->end();
    } // Fl_Group* filerframe
    { filershort = new Fl_Group(4, 4, 542, 74);
      filershort->box(FL_ENGRAVED_FRAME);
      filershort->labelcolor((Fl_Color)64);
      filershort->end();
    } // Fl_Group* filershort
    { favourites = new Fl_Group(4, 49, 542, 265);
      favourites->box(FL_FLAT_BOX);
      favourites->labelcolor((Fl_Color)64);
      favourites->hide();
      { favename = new Fl_Group(4, 49, 542, 42);
        favename->box(FL_ENGRAVED_FRAME);
        favename->labelcolor((Fl_Color)64);
        favename->end();
      } // Fl_Group* favename
      { favebrowse = new Fl_Browser(5, 91, 540, 220);
        favebrowse->type(1);
        favebrowse->box(FL_FLAT_BOX);
        favebrowse->color((Fl_Color)206);
        favebrowse->labelsize(12);
        favebrowse->labelcolor((Fl_Color)64);
        favebrowse->textfont(1);
        favebrowse->textsize(12);
        favebrowse->textcolor((Fl_Color)64);
        favebrowse->callback((Fl_Callback*)cb_favebrowse);
      } // Fl_Browser* favebrowse
      { favecancel = new Fl_Button(455, 61, 70, 20, "Back");
        favecancel->tooltip("Cancel any selection and return to filer window");
        favecancel->box(FL_GTK_THIN_UP_BOX);
        favecancel->color((Fl_Color)198);
        favecancel->labelfont(1);
        favecancel->labelsize(12);
        favecancel->labelcolor((Fl_Color)64);
        favecancel->callback((Fl_Callback*)cb_favecancel);
      } // Fl_Button* favecancel
      { favedefault = new Fl_Button(287, 61, 110, 20, "Make Default");
        favedefault->tooltip("Set selected entry as the default (move to top)");
        favedefault->box(FL_PLASTIC_THIN_UP_BOX);
        favedefault->color((Fl_Color)228);
        favedefault->labelfont(1);
        favedefault->labelsize(12);
        favedefault->labelcolor((Fl_Color)64);
        favedefault->callback((Fl_Callback*)cb_favedefault);
      } // Fl_Button* favedefault
      { favedelete = new Fl_Button(156, 61, 70, 20, "Delete");
        favedelete->tooltip("Remove selected entry");
        favedelete->box(FL_PLASTIC_THIN_UP_BOX);
        favedelete->color((Fl_Color)228);
        favedelete->labelfont(1);
        favedelete->labelsize(12);
        favedelete->labelcolor((Fl_Color)64);
        favedelete->callback((Fl_Callback*)cb_favedelete);
      } // Fl_Button* favedelete
      { faveset = new Fl_Button(20, 61, 70, 20, "Set");
        faveset->tooltip("Set the current path to the selected entry and exit");
        faveset->box(FL_PLASTIC_THIN_UP_BOX);
        faveset->color((Fl_Color)228);
        faveset->labelfont(1);
        faveset->labelsize(12);
        faveset->labelcolor((Fl_Color)64);
        faveset->callback((Fl_Callback*)cb_faveset);
      } // Fl_Button* faveset
      favourites->end();
    } // Fl_Group* favourites
    { filerscroll = new Fl_Scroll(10, 96, 444, 244);
      filerscroll->type(2);
      filerscroll->color(FL_BACKGROUND2_COLOR);
      filerscroll->labelcolor((Fl_Color)64);
      filerscroll->end();
    } // Fl_Scroll* filerscroll
    filerwindow->set_modal();
    filerwindow->resizable(filerwindow);
    filerDW = o->w(); filerDH = o->h();
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("File Manager"), UNUSED, TOPLEVEL::windowTitle)).c_str());
    o->size_range(filerDW, filerDH, 0, 0, 0, 0, 1);
    filerwindow->end();
  } // ScaleTrackedWindow* filerwindow
  return filerwindow;
}

string MasterUI::setfiler(string title, string name, bool save, int exten) {
  //
      dosave = save;
      extension = exten;
      loadfavourites();

      string lastname = textMsgBuffer.fetch(fetchData(extension, MAIN::control::readLastSeen, TOPLEVEL::section::main));
      string path;
      type_name = "";
      size_t pos = string::npos;
      fileruseX = 464;
      fileruse->copy_label("< New Dir");
      filernamegroup->show();
      filerframe ->show();
      filershort->hide();
      string currentfave = string(favebrowse->text(1)).substr(4);
      if (extension == TOPLEVEL::XML::Dir)
      {
          if (!dosave)
          {
              fileruseX = 234;
              fileruse->copy_label("^ From");
              filernamegroup->hide();
              filerframe ->hide();
              filershort->show();
          }
          path = currentfave;
          filernewname->value("");
          filerOpt16->value(1);
          filerOpt8->hide();
          filerOpt2->hide();
      }
      else if(extension == TOPLEVEL::XML::Bank)
      {
          if(!dosave)
          {
              fileruseX = 234;
              fileruse->copy_label("^ Import");
              path = currentfave + name;
              filernewname->value("");
              filernamegroup->hide();
              filerframe ->hide();
              filershort->show();
          }
          else
          {
              fileruse->copy_label("< Export");
              path = currentfave;
              filernewname->value(name.c_str());
          }
          filerOpt16->value(1); // hide files
          filerOpt8->hide(); // hide dirs
          filerOpt2->hide(); // dot files
      }
      else
      {
          if (extension == TOPLEVEL::XML::ScalaTune || extension == TOPLEVEL::XML::ScalaMap || extension == TOPLEVEL::XML::Themes)
          {
              if (dosave)
                  fileruse->copy_label("< Export");
              else
                  fileruse->copy_label("< Import");
          }

          else if (dosave)
              fileruse->copy_label("< Save");
          else
              fileruse->copy_label("< Load");
          if (lastname.empty())
          {
              path = currentfave;
              filernewname->value("");
          }
          else
          {
              pos = lastname.rfind('/');
              path = lastname.substr(0, pos);
          }

          if (name.empty() && pos != string::npos)
          {
              name = lastname.substr(pos + 1);
          }
          filerOpt16->value(0);
          filerOpt8->show();
          filerOpt2->show();

          if (!name.empty())
          {
              pos = name.find('.');
              if (pos != string::npos)
                  name = name.substr(0, pos);
              filernewname->value(name.c_str());
          }

          switch(extension)
          {
              case TOPLEVEL::XML::Instrument:
                  filerext = EXTEN::zynInst;
                  fileroldpath->copy_label("Path to Instruments");
                  type_name = "xiz";
                  break;
              case TOPLEVEL::XML::Patch:
                  filerext = EXTEN::patchset;
                  fileroldpath->copy_label("Path to Patch Sets");
                  type_name = "xmz";
                  break;
              case TOPLEVEL::XML::Presets:
                  filerext = EXTEN::presets;
                  fileroldpath->copy_label("Path to Presets");
                  type_name = "xpz";
                  break;

              case TOPLEVEL::XML::Scale:
                  filerext = EXTEN::scale;
                  fileroldpath->copy_label("Path to Scales");
                  type_name = "xsz";
                  break;
              case TOPLEVEL::XML::State:
                  filerext = EXTEN::state;
                  fileroldpath->copy_label("Path to States");
                  type_name = "state";
                  break;
              case TOPLEVEL::XML::Vector:
                  filerext = EXTEN::vector;
                  fileroldpath->copy_label("Path to Vectors");
                  type_name = "xvy";
                  break;
              case TOPLEVEL::XML::MLearn:
                  filerext = EXTEN::mlearn;
                  fileroldpath->copy_label("Path to Midi-Learn files");
                  type_name = "xly";
                  break;
              case TOPLEVEL::XML::PadSample:
                  filerext = EXTEN::MSwave;
                  fileroldpath->copy_label("Path to PadSynth samples");
                  type_name = "wav";
                  break;
              case TOPLEVEL::XML::ScalaTune:
                  filerext = EXTEN::scalaTuning;
                  fileroldpath->copy_label("Path to Scala tunings");
                  type_name = "scl";
                  break;
              case TOPLEVEL::XML::ScalaMap:
                  filerext = EXTEN::scalaKeymap;
                  fileroldpath->copy_label("Path to Scala keymaps");
                  type_name = "kbm";
                  break;
              case TOPLEVEL::XML::Bank:
                  fileroldpath->copy_label("Path to Instrument Banks");
                  break;
              case TOPLEVEL::XML::Themes:
               filerext = EXTEN::theme;
                  fileroldpath->copy_label("Path to UI themes");
                  type_name = "clr";
                  break;

          }
      }
      if (!title.empty())
          fileroldpath->copy_label(title.c_str());
      if (path.back() != '/')
          path += '/';
      filerpath = path;
      fileroldpath->value(path.c_str());

      fillfiler(type_name);

      int X, Y, W, H, O;
      loadWin(synth, W, H, X, Y, O, "Master-filer");
      if (W < filerDW || H < filerDH)
      {
          W = filerDW;
          H = filerDH;
      }
      checkSane(X, Y, W, H, filerDW, filerDH);
      filerwindow->resize(X, Y, W, H);

      lastfilerW = 0;
      filerdone = false;
      filerwindow->show();
      lineitem = -1;
      while (true)
      {
          if (lastfilerW != filerwindow->w())
          {
              filerRtext();
              lastfilerW = filerwindow->w();
          }
          Fl::wait();
          if (lineitem > -1)
          {
              filerselect(lineitem);
              lineitem = -1;
          }
          if (filerdone && (extension == TOPLEVEL::XML::Dir || extension == TOPLEVEL::XML::Bank))
          {
              if (dosave && string(filernewname->value()).empty())
              {
                  filerdone = false;
                  query("", "", "", "Nothing given to use!");
              }
              else
                  break;
          }
          else if (filerdone && string(filernewname->value()).empty())
          {
              filerdone = false;
              query("", "", "", "Nothing given to use!");
          }
          else if (filerdone)
          break;
      }
      filerwindow->hide();

      if (extension == TOPLEVEL::XML::Dir || extension == TOPLEVEL::XML::Bank)
      {
          if (dosave)
          {
              if (string(filernewname->value()).length() < 3)
                  filerfound.clear();
          }
          else
          {
              if (filerfound.back() != '/')
                  filerfound += '/';
          }
      }
      else if (dosave)
      {
          if (extension == TOPLEVEL::XML::Instrument)
          { // try to cover all possibilities!
              int type = fetchData(0, CONFIG::control::savedInstrumentFormat,TOPLEVEL::section::config);
              if ((type == 3 || type == 1) && isRegularFile(filerfound + EXTEN::zynInst))
              {
                  if (query("", "Yes", "No", "The file exists. \nOverwrite it?") < 2)
                      filerfound.clear();
              }
              else if ((type == 3 || type == 2) && isRegularFile(filerfound + EXTEN::yoshInst))
              {
                  if (query("", "Yes", "No", "The file exists. \nOverwrite it?") < 2)
                      filerfound.clear();
              }
          }
          else if (isRegularFile(filerfound + filerext))
          {
              if (query("", "Yes", "No", "The file exists. \nOverwrite it?") < 2)
              {
                  filerfound.clear();
              }
          }
      }
      savefavourites();
      return filerfound;
}

void MasterUI::fillfiler(string type_name) {
  //
          string tofetch;
          int options = filerOpt1->value();
          if (filerOpt2->value() > 0)
              options |= 2;
          if (filerOpt8->value() > 0)
              options |= 8;
          if (filerOpt16->value() > 0)
              options |= 16;

          file::dir2string(tofetch, filerpath, filerext, options);
          filerlist.clear();        // Note: must come first; dtor of FL_Group automatically
          filerscroll->clear();     //       detaches child widgets from the FL_Scroll
          lineno = 0;
          //std::cout << "*** list start ***" << std::endl;
          //std::cout << "ext " << filerext << std::endl;
          while(!tofetch.empty())
          {
              size_t pos = tofetch.find("\n");
              string next = tofetch.substr(0, pos);
              bool isDir = false;
              filerlist.emplace_back(0, 0, 390, 20);
              if (next.find("Dir:") != std::string::npos)
              {
                  next = next.substr(5);
                  isDir = true;
              }
              filerlist.back().init(synth,lineno, isDir, type_name, next);
              //std::cout << "name >" << next << "<" << std::endl;
              filerlist.back().name->copy_label(next.c_str());
              filerscroll->add(&filerlist.back());
              ++lineno;
              tofetch = tofetch.substr(pos + 1);
          }
          filerscroll->end();
          filerscroll->scroll_to(-10,-10);
          filerRtext();
          //std::cout << "list end " << lineno << std::endl;
          ;
}

void MasterUI::filerselect(int item) {
  //
          string line = string(filerlist[item].name->label());
          if (filerlist[item].dirIcon->visible())
          {
              //std::cout << "in dir" << std::endl;
              if (line.back() !='/')
                  line += '/';
              if (Fl::event_clicks())
              {
                  Fl::event_clicks(0);
                  filerpath = filerpath + line;
                  fileroldpath->value(filerpath.c_str());
                  fillfiler(type_name);
              }
              return;
          }
          //std::cout << "files" << std::endl;
          filernewname->value(line.c_str());
          if (Fl::event_clicks())
          {
              Fl::event_clicks(0);
              fileruse->do_callback();
          }
}

void MasterUI::setfavourites() {
  //
      fileroldpath->deactivate();
      filernewname->deactivate();
      fileruse->deactivate();
      filerback->deactivate();
      filerfave->deactivate();
      filerscroll->hide();
      faveGroup->hide();
      favourites->show();
}

void MasterUI::loadfavourites() {
  //
          string favetext = file::loadText(file::configDir() + "/yoshimi-favourites");
          if (favetext.empty())
              favetext = file::userHome();
          favebrowse->clear();
          string cr = "\n";
          for (int count = 0; count < 20; ++count)
          {
              size_t pos = favetext.find(cr);
              string next = favetext.substr(0, pos);
              favebrowse->add(next.c_str());
              favetext = favetext.substr(pos + 1);
              if (pos == string::npos)
                  break;
          }
          setfavecolour(1);
}

void MasterUI::savefavourites() {
  //
      clearfavelist();
      string favetext;
      string cr = "\n";
      for (int i = 1; i <= favebrowse->size(); ++ i)
      {
          string line = string(favebrowse->text(i));
          favetext += (line + cr);
      }
      file::saveText(favetext, file::configDir() + "/yoshimi-favourites");
}

void MasterUI::clearfavelist() {
  //
      for (int i = 1; i <= favebrowse->size(); ++ i)
      {
          string line = string(favebrowse->text(i));
          if (line.substr(0, 4) == "@C4 ")
          {
              line = line.substr(4);
              favebrowse->text(i, line.c_str());
          }
      }
}

void MasterUI::setfavecolour(int num) {
  //
      string line = "@C4 " + string(favebrowse->text(num));
      favebrowse->text(num, line.c_str());
}

string MasterUI::clearfavecolour(int num) {
  //

          string line = string(favebrowse->text(num));
          if (line.substr(0, 4) == "@C4 ")
              line = line.substr(4);
          return line;
}

void MasterUI::filerRtext() {
  //
          float dScale = filerwindow->w() / float(filerDW);
          int size12 = int(12 * dScale);
          int size14 = int(14 * dScale);

          fileroldpath->labelsize(size12);
              fileroldpath->textsize(size12);
          filernamegroup->labelsize(size12);
              filernewname->textsize(size12);
          faveGroup->labelsize(size14);
          fileruse->position(fileruseX * dScale, 53 * dScale);
          fileruse->labelsize(size12);

          filerback->labelsize(size12);
          faveadd->labelsize(size12);
          filerfave->labelsize(size12);

          filerOpt8->labelsize(size12);
          filerOpt1->labelsize(size12);
          filerOpt2->labelsize(size12);

          filerclose->labelsize(size12);

          favename->labelsize(size14);
          favebrowse->textsize(size12);
          favecancel->labelsize(size12);
          favedefault->labelsize(size12);
          favedelete->labelsize(size12);
          faveset->labelsize(size12);
          for (int i = 0; i < lineno; ++i)
          {
              filerlist[i].resize(int(10 * dScale), int(((i * 20) + 96) * dScale), int(440 * dScale), int(20 * dScale));
              filerlist[i].name->labelsize(size12);
              filerlist[i].type->labelsize(int(4 * dScale));
          }
          filerwindow->redraw();
}

void MasterUI::startInstance() {
  //
      cancelInst->value(0);
      nextInst->value(0);
      valueInst->value("");
      setInstance->show();
      while (setInstance->visible())
      {
          if (cancelInst->value())
          {
              setInstance->hide();
              break;
          }
          if (nextInst->value())
          {
              send_data(TOPLEVEL::action::lowPrio, MAIN::control::startInstance, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
              setInstance->hide();
              break;
          }
          if (Fl::get_key(FL_Enter))
          {
              string testval = valueInst->value();
              if (!testval.empty())
              {
                  if (func::isDigits(testval))
                  {
                      int result = stoi(testval);
                      if (result > 0 && result < 32)
                      {
                          send_data(TOPLEVEL::action::lowPrio, MAIN::control::startInstance, result, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
                          setInstance->hide();
                          break;
                      }
                  }
              }
          }
          Fl::wait();
      };
}

void MasterUI::send_data(int action, int control, float value, int type, int part , int engine , int insert , int parameter , int miscmsg ) {
  //
          type |= TOPLEVEL::type::Write;
          /*
              The following variations are due to the way the section was built
              up over time. It really needs the whole lot expanding for the calls
              to natively include all parameters.
          */
          if (control == MAIN::control::loadInstrumentByName && part == TOPLEVEL::section::main && miscmsg < NO_MSG)
          {
              collect_writeData(synth, 0, action, type, control, part, engine, UNUSED, UNUSED, UNUSED, UNUSED, miscmsg);
              return;
          }

          if (control <= MAIN::control::soloType)
              type |= Fl::event_button();
          if (parameter == 0)
          {
              collect_writeData(synth, 0, action, type, control, part, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, miscmsg);
              return;
          }

          collect_writeData(synth, value, action, type, control, part, UNUSED, engine, insert, parameter, UNUSED, miscmsg);
}

float MasterUI::fetchData(float value, int control, int part, int kititem , int engine , int insert , int parameter , int offset , int miscmsg , int request ) {
  //
          return collect_readData(synth, value, control, part, kititem, engine, insert, parameter, offset, miscmsg, request);
}

bool MasterUI::part_group_returns(CommandBlock *getData) {
  //
          float value = getData->data.value;
          unsigned char control = getData->data.control;
          unsigned char npart = getData->data.part;
          int value_int = lrint(value);
          bool value_bool = _SYS_::F2B(value);
          int panelpart = 0;
          bool panelVisible = ((npart / NUM_MIDI_CHANNELS) == (panelgroup / NUM_MIDI_CHANNELS));
          if (panelVisible)
              panelpart = npart % NUM_MIDI_CHANNELS;

          bool seen = false;;
          switch (control)
          {
              case PART::control::enable:
              {
                  {
                      partEnable->value(value);
                      if (value)
                          partControls->activate();
                      else
                          partControls->deactivate();
                  }
                  if (panelVisible)
                  {
                      panellistitem[panelpart]->partenabled->value(value);
                      if (value)
                          panellistitem[panelpart]->panellistitemgroup->activate();
                      else
                          panellistitem[panelpart]->panellistitemgroup->deactivate();
                  }
                  seen = true;
                  break;
              }
              case PART::control::volume:
                  partVol->value(value);
                  partVol->selection_color(setKnob(value,96));
                  if (panelVisible)
                  {
                      panellistitem[panelpart]->partvolume->value(value);
                      panellistitem[panelpart]->partvolume->selection_color(setSlider(value,96));
                  }
                  seen = true;
                  break;
              case PART::control::panning:
                  partPan->value(value);
                  partPan->selection_color(setKnob(value,64));
                  if (panelVisible)
                  {
                      panellistitem[panelpart]->partpanning->value(value);
                      panellistitem[panelpart]->partpanning->selection_color(setKnob(value,64));
                  }
                  seen = true;
                  break;
              case PART::control::velocityOffset:
                  partVelOffset->value(value);
                  partVelOffset->selection_color(setKnob(value,64));
                  seen = true;
                  break;

              case PART::control::velocitySense:
                  partVelSense->value(value);
                  partVelSense->selection_color(setKnob(value,64));
                  seen = true;
                  break;

              case PART::control::midiChannel:
              {
                  int tmp = value_int;
                  int textCol = gen_text;
                  if (tmp >= NUM_MIDI_CHANNELS)
                  {
                      if (tmp >= NUM_MIDI_CHANNELS * 2)
                          textCol = midi_ignored;
                      else
                          textCol = gen_text;
                      tmp = (tmp % NUM_MIDI_CHANNELS);
                  }
                  partMidiCh->textcolor(textCol);
                  partMidiCh->value(tmp + 1);
                  if (panelVisible)
                  {
                      panellistitem[panelpart]->partrcv->textcolor(textCol);
                      panellistitem[panelpart]->partrcv->value(tmp);
                  }
                  seen = true;
                  break;
              }

              case PART::control::omni:
                  partOmniEnable->value(value);
                  seen = true;
                  break;

              case PART::control::keyMode:
                  partKeymode->value(value_int);
                  updateModepatch(value_int > 1 && partui->part->Pdrummode != 0);
                  seen = true;
                  break;

              case PART::control::drumMode: // we allow this to cayry on to PartUI
                  updateModepatch(value_bool != 0 && partKeymode->value() > 1);
                  break;

              case PART::control::portamento:
                  partPortamento->value(value_bool);
                  break;

              case PART::control::instrumentName:
                  partui->checkEngines();
                  synth->getGuiMaster()->instrumentlabel->copy_label(synth->part[npart]->Pname.c_str());
                  seen = true;
                  break;

              case PART::control::minNote:
              case PART::control::minToLastKey: // this will have been modified for last key press
                  minKeyCount->value(value_int);
                  seen = true;
                  break;

              case PART::control::maxNote:
              case PART::control::maxToLastKey: // this will have been modified for last key press
                  maxKeyCount->value(value_int);
                  seen = true;
                  break;

              case PART::control::resetMinMaxKey:
                  minKeyCount->value(0);
                  maxKeyCount->value(127);
                  seen = true;
                  break;

              case PART::control::keyShift:
                  partKeyShift->value(value_int);
                  seen = true;
                  break;

              case PART::control::maxNotes:
                  partKeyLimit->value(value_int);
                  seen = true;
                  break;

              case PART::partToSystemEffect1:
                  sysEff1->value(value);
                  sysEff1->selection_color(setKnob(value,0));
                  seen = true;
                  break;
              case PART::partToSystemEffect2:
                  sysEff2->value(value);
                  sysEff2->selection_color(setKnob(value,0));
                  seen = true;
                  break;
              case PART::partToSystemEffect3:
                  sysEff3->value(value);
                  sysEff3->selection_color(setKnob(value,0));
                  seen = true;
                  break;
              case PART::partToSystemEffect4:
                  sysEff4->value(value);
                  sysEff4->selection_color(setKnob(value,0));
                  seen = true;
                  break;

              case PART::control::audioDestination:
                  int send = value_int - 1;
                  if (send < 0 or send > 2)
                      send = 0;
                  if (panelVisible)
                      panellistitem[panelpart]->audiosend->value(send);
                  seen = true;
                  break;
          }
          return seen;
}

bool MasterUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      bool wasFromHere = ((getData->data.source & TOPLEVEL::action::noAction) == TOPLEVEL::action::fromGUI);
      unsigned char control = getData->data.control;
      unsigned char newpart = getData->data.part;
      unsigned char kititem = getData->data.kit;
      unsigned char engine = getData->data.engine;
      unsigned char insert = getData->data.insert;
      unsigned char parameter = getData->data.parameter;
      unsigned char miscmsg = getData->data.miscmsg;
      int value_int = lrint(value);
      bool value_bool = _SYS_::F2B(value);
      int chan = kititem & 0x3f;
      bool isSingle = kititem >= 0x40;
      int mask = NUM_MIDI_CHANNELS - 1;
      string name;
      if (miscmsg != NO_MSG)
          name = textMsgBuffer.fetch(miscmsg);
      if (newpart == TOPLEVEL::section::midiIn)
      {
          if (engine == MIDI::CC::volume && partui->part->ctl->volume.receive == 0)
              return false; // disabled
          if (engine == MIDI::CC::expression && partui->part->ctl->expression.receive == 0)
              return false; // disabled

          float vol = (value * synth->part[npart]->ctl->volume.data) / 127;
          if (control == MIDI::control::controller)
          { // MIDI panel entries only
              for (int i = 0; i < NUM_MIDI_CHANNELS; ++i)
              {
                  if (panellistitem[i]->partenabled->value() != 0)
                  {
                      if ((isSingle && i == (chan & mask)
                                   && panellistitem[i]->partrcv->value() == (chan & mask)
                                   && (chan / NUM_MIDI_CHANNELS) == (panelgroup / NUM_MIDI_CHANNELS))
                           || (!isSingle && panellistitem[i]->partrcv->value() == (chan & mask)))
                      {
                          if (engine == MIDI::CC::volume)
                          {
                              panellistitem[i]->partvolume->value(vol);
                              panellistitem[i]->partvolume->selection_color(setSlider(vol,96));
                          }
                          else if (engine == MIDI::CC::panning)
                          {
                              panellistitem[i]->partpanning->value(value);
                              panellistitem[i]->partpanning->selection_color(setKnob(value,64));
                          }
                      }
                  }
              }
          }

          bool isForUs = (isSingle && chan == npart)
               || (!isSingle &&  (partMidiCh->value() == (chan & mask) + 1));
          switch(control)
          {
              case MIDI::control::noteOn:
              case MIDI::control::noteOff:
                  break;
              case MIDI::control::controller:
                  if (engine <= 119 && fetchData(0, MAIN::control::soloCC, TOPLEVEL::section::main))
                  { // it's a valid channel switch
                      int newch = partMidiCh->value() - 1;
                      int switchType = collect_readData(synth, 0, MAIN::control::soloType, TOPLEVEL::section::main);
                      switch (switchType)
                      {
                          case MIDI::SoloType::Row:
                              if (npart < NUM_MIDI_CHANNELS)
                              {
                                  if (npart != value_int)
                                      newch = NUM_MIDI_CHANNELS;
                                  else
                                      newch = 0;
                              }
                              break;

                          case MIDI::SoloType::Column:
                              if (value_int == npart)
                                  newch = (value_int & mask);
                              else if ((value_int & mask) == (npart & mask))
                                  newch = (value_int & mask) + NUM_MIDI_CHANNELS;
                              break;

                          case MIDI::SoloType::Loop:
                          case MIDI::SoloType::TwoWay:
                              if (npart < NUM_MIDI_CHANNELS)
                              {
                                  if (npart == collect_readData(synth, 0, MAIN::control::soloType, TOPLEVEL::section::main))
                                      newch = 0;
                                  else if (value_int > 0)
                                      newch = NUM_MIDI_CHANNELS;
                              }
                              break;

                          case MIDI::SoloType::Channel:
                              //int ch = value_int % NUM_MIDI_CHANNELS;
                              if (newch == chan || newch == chan + NUM_MIDI_CHANNELS)
                                  newch = chan;
                              else
                                  newch = newch + NUM_MIDI_CHANNELS;
                              break;

                      }
                      partMidiCh->value(newch + 1);

                      //if (newch < NUM_MIDI_CHANNELS)
                          partMidiCh->textcolor(gen_text);
                      //else
                          //partMidiCh->textcolor(midi_solo_release);
                      updatepanel();
                  }
                  else if (isForUs)
                  {
                      switch(engine)
                      {
                          case MIDI::CC::modulation:
                              partui->modulation->value(value);
                              partui->modulation->selection_color(setKnob(value,64));
                              break;
                          case MIDI::CC::volume:
                              partVol->value(vol);
                              partVol->selection_color(setKnob(vol,96));
                              break;
                          case MIDI::CC::panning:
                              partPan->value(value);
                              partPan->selection_color(setKnob(value,64));
                              break;
                          case MIDI::CC::expression:
                              partui->expression->value(value);
                              partui->expression->selection_color(setKnob(value,127));
                              break;
                          case MIDI::CC::legato:
                          {
                              int mode = synth->ReadPartKeyMode(npart);
                              if (mode > 1)
                                  partKeymode->value(2);
                              else
                                  partKeymode->value(mode);
                              updateModepatch(mode > 1 && partui->drumMode->value() != 0);
                              break;
                          }
                          case MIDI::CC::filterQ:
                              partui->filterq->value(value);
                              partui->filterq->selection_color(setKnob(value,64));
                              break;
                          case MIDI::CC::filterCutoff:
                              partui->filtercutoff->value(value);
                              partui->filtercutoff->selection_color(setKnob(value,64));
                              break;
                          case MIDI::CC::bandwidth:
                              partui->masterbandwidth->value(value);
                              partui->masterbandwidth->selection_color(setKnob(value,64));
                              break;
                      }
                  }
                  break;
              case MIDI::control::bankChange:
                  if (engine != UNUSED)
                      bankui->readbankcfg();
                  bankui->rescan_for_banks();
                  break;
          }
          return false;
      }
      if (newpart == TOPLEVEL::section::systemEffects)
      {
          if (insert == TOPLEVEL::insert::systemEffectSend && !wasFromHere)
          {
              switch (engine)
              {
                  case 0:
                      if(control == 1)
                      {
                          syseff01->value(value_int);
                          syseff01->selection_color(setKnob(value_int,0));
                      }
                      else if(control == 2)
                      {
                          syseff02->value(value_int);
                          syseff02->selection_color(setKnob(value_int,0));
                      }
                      else if(control == 3)
                      {
                          syseff03->value(value_int);
                          syseff03->selection_color(setKnob(value_int,0));
                      }
                      break;
                  case 1:
                      if(control == 2)
                      {
                          syseff12->value(value_int);
                          syseff12->selection_color(setKnob(value_int,0));
                      }
                      else if(control == 3)
                      {
                          syseff13->value(value_int);
                          syseff13->selection_color(setKnob(value_int,0));
                      }
                      break;
                  case 2:
                      if(control == 3)
                      {
                          syseff23->value(value_int);
                          syseff23->selection_color(setKnob(value_int,0));
                      }
                      break;
              }
          }

          else
          {
              if (control == EFFECT::sysIns::effectNumber)
              {   //note: using local settings from the last push-update into MirrorData
                  syseffnocounter->value(syseffectui->effNum() + 1);
                  sysefftype->value(syseffectui->effType());
                  syseffectui->refresh();
                  syseffectui->UpdatePresetColour(parameter, sysefftype->value());
                  SysEffOn->value(syseffectui->isEnabled());
                  // note: effect type selection not disabled/enabled
              }
              else if (control == EFFECT::sysIns::effectType)
              {
                  syseffnocounter->value(syseffectui->effNum() + 1);
                  sysefftype->value(syseffectui->effType());
                  syseffectui->refresh();
                  syseffectui->UpdatePresetColour(0, sysefftype->value());
                  // changing effect type always sets default values
                  if (effDisplayType == 0)
                  {
                      showSysEfxUI();
                      syseffectui->effRtext(mainScale, sysefftype->value());
                  }
              }
              else if (control == EFFECT::sysIns::effectEnable)
              {
                 SysEffOn->value(value_bool);
                 if (value_bool)
                      sysefftype->activate();
                  else
                      sysefftype->deactivate();
              }
          }
          return false;
      }
      else if (newpart == TOPLEVEL::section::insertEffects)
      {
          if (control == EFFECT::sysIns::effectNumber)
          {
              refreshInsEffUI();
              if (effDisplayType == 1)
                  showInsEfxUI();
              inseffectui->UpdatePresetColour(parameter, insefftype->value());

          }
          else if (control == EFFECT::sysIns::effectType)
          {
              refreshInsEffUI();
              inseffectui->UpdatePresetColour(0, insefftype->value());
              // changing effect type always sets default values
              if (effDisplayType == 1)
              {
                  showInsEfxUI();
                  inseffectui->effRtext(mainScale, insefftype->value());
              }
          }
          else if (control == EFFECT::sysIns::effectDestination)
          {
              inseffpart->value(value_int + 2);
              if (value_int != -1)
              {
                  // note: effect type selection is never disabled
                  refreshInsEffUI();
                  if (effDisplayType == 1)
                      showInsEfxUI();
              }
          }
          return false;
      }

      switch(control)
      {
          case MAIN::control::volume:
              mastervolumedial->value(value);
              mastervolumedial->selection_color(setKnob(value,90));
              break;

          case MAIN::control::partNumber:
              partSwitch(value_int);
              updatepanel();
              break;

          case MAIN::control::availableParts:
              partmax = value_int;
              updatepart();
              updatepanel();
              setinspartlist();
              vectorui->checkParts(value_int);
              break;
          case MAIN::control::panLawType:
              panning_law->value(value_int);
              break;

          case MAIN::control::detune:
              globalfinedetune->value(value);
              globalfinedetune->selection_color(setKnob(value,64));
              break;

          case MAIN::control::keyShift:
              masterkeyshift->value(value_int);
              break;

          case MAIN::control::bpmFallback:
              setBpmFallbackValue(value);
              break;

          case MAIN::control::mono:
              mastermono->value(value_int);
              if (value_int)
                  mastermono->label("Mono");
              else
                  mastermono->label("Stereo");
              break;

          case MAIN::control::soloType:
              channelswitch->value(value_int);
              if (value_int == 0)
              {
                  CS_CC = 128;
                  CSspinner->value(115); // default
                  CSspinner->hide();
                  CSpend->hide();
                  for (int i = 0; i < NUM_MIDI_CHANNELS; ++i)
                      setPanelPartMidiWidget(i, i);
              }
              else
              {
                  CS_CC = 115;
                  CSspinner->value(115);
                  CSpend->show();
                  CSspinner->show();
                  for (int i = 1; i < NUM_MIDI_CHANNELS; ++i)
                  {
                      if (value_int == 2)
                          setPanelPartMidiWidget(i, i);
                      else
                          setPanelPartMidiWidget(i, 16);
                  }
              }
              panelwindow->changed();
              break;
          case MAIN::control::soloCC:
              updatepanel();
              break;
          case MAIN::control::exportBank:
              if (wasFromHere)
                  query("", "", "", name);
              break;
          case MAIN::control::importBank: // import bank
              if (wasFromHere)
              {
                  if (name.find("FAILED") == 1)
                      query("", "", "", name);
                  else
                  {
                      unsigned int other = name.find(" : ");
                      if (other < 1024) // a bit of a hack :(
                      {
                          name = name.substr(other + 3);
                          query("", "", "", name);
                      }
                  }
              }
              bankui->rescan_for_banks();
              break;
          case MAIN::control::deleteBank: // delete bank and contents
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              bankui->rescan_for_banks();
              bankui->set_bank_slot();
              break;

          case MAIN::control::loadInstrumentFromBank:
          case MAIN::control::refreshInstrumentUI:
              bankui->refreshinstrumentwindow();
              updatepartprogram(kititem);
              break;

          case MAIN::control::loadInstrumentByName:
              updatepartprogram(kititem);
              break;

          case MAIN::control::saveNamedInstrument: // save instrument
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  partui->setinstrumentlabel();
                  panellistitem[newpart % NUM_MIDI_CHANNELS]->refresh();
                  //RecentInstruments->activate();
              }
              break;

          case MAIN::control::loadNamedPatchset: // load patchset
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  vectorui->RefreshChans();
                  //RecentParams->activate();
                  setMasterLabel(findLeafName(name));
                  refresh_master_ui(2);
              }
              lastsyseffeqW = 0;
              lastsysDynFiltW = 0;
              lastinsDynFiltW = 0;
              break;

          case MAIN::control::saveNamedPatchset: // save patch set
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  setMasterLabel(findLeafName(name));
                  //RecentParams->activate();
              }
              break;

          case MAIN::control::loadNamedVector: // load vector
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  vectorui->setLoadLabelRemote(insert, synth->getRuntime().vectordata.Name[insert]);
                  setMasterLabel(findLeafName(name) + " - Vector " + to_string(int(insert) + 1));
                  vectorui->setRecent(true);
                  refresh_master_ui(5);
              }
              break;

          case MAIN::control::saveNamedVector: // save vector
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  setMasterLabel(findLeafName(name) + " - Vector " + to_string(int(insert) + 1));
                  vectorui->setRecent(true);
              }
              break;

          case MAIN::control::loadNamedScale: // load scales
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      query("", "", "", name);
              }
              else
              {
                  //RecentScale->activate();
                  microtonalui->microtonaluiwindow->hide();
                  microtonalui->make_window();
                  microtonalui->showScales();
              }
              break;

          case MAIN::control::saveNamedScale: // save scales
              if (wasFromHere && name.find("FAILED") == 1)
                  query("", "", "", name);
              //else
                  //RecentScale->activate();
              break;

          case MAIN::control::loadNamedState: // load state
              if (wasFromHere && name.find("FAILED") == 1)
              {
                  query("", "", "", name);
                  refresh_master_ui(1);
              }
              else
              {
                  setMasterLabel(findLeafName(name) + " - State");
                  refresh_master_ui(0x14);
              }
              break;

          case MAIN::control::saveNamedState: // save state
              if (wasFromHere && name.find("FAILED") == 1)
                  query("", "", "", name);
              else
                  setMasterLabel(findLeafName(name) + " - State");
              break;
          case MAIN::control::defaultPart:
          case MAIN::control::defaultInstrument:
              partSwitch(npart);
              updatepanel();
              break;
          case MAIN::control::masterReset:
              if (newpart == TOPLEVEL::section::main)
              {
                  refresh_master_ui(1);
                  vumeter->init(-1, synth);
                  resetPartsClip();
              }
              else if (newpart < NUM_MIDI_PARTS)
                  partSwitch(newpart);
              setMasterLabel("");
              break;

          case MAIN::control::masterResetAndMlearn:
              refresh_master_ui(1);
              resetPartsClip();
              if (midilearnui)
                  midilearnui->midilearnwindow->hide();//Hide();
              setMasterLabel("");
              break;

          case MAIN::control::openManual:
              message->hide();
              if (miscmsg != NO_MSG)
                  query("", "", "", textMsgBuffer.fetch(miscmsg));
              break;

          case MAIN::control::startInstance: // new instance (do nothing here)
              break;

          case MAIN::control::stopSound:
              virkeyboard->relaseallkeys();
              vumeter->init(-1, synth);
              resetPartsClip();
              break;
      }
      return false;
}

void MasterUI::paste(CommandBlock *getData) {
  //
            if (getData->data.part == TOPLEVEL::section::systemEffects)
            {
                effDisplayType = 0;
                sysefftype->value(syseffectui->effType());
                syseffnocounter->value(syseffectui->effNum() + 1);
                syseffectui->refresh();
                syseffectui->UpdatePresetColour(0, sysefftype->value());
                showSysEfxUI();
            }
            else
            {
                effDisplayType = 1;
                refreshInsEffUI();
                inseffectui->UpdatePresetColour(0, insefftype->value());
                showInsEfxUI();
            }
}

int MasterUI::query(string one, string two, string three, string text) {
  //
      if (one.empty())
          yesQ->hide();
      else
      {
          if(one == "!")
          {
              yesQ->copy_label("Yes");
          }
          else
          {
              yesQ->copy_label(one.c_str());
          }
          yesQ->show();
      }

      if (two.empty())
          noQ->hide();
      else
      {
          if (two == "!")
          {
              noQ->copy_label("No");
          }
          else
          {
              noQ->copy_label(two.c_str());
          }
          noQ->show();
      }
      if (three.empty())
      {
          cancelQ->copy_label("Close");
          typeQ->copy_label("!");
      }
      else
      {
          if (three == "!")
          {
              cancelQ->copy_label("Cancel");
          }
          else
          {
              cancelQ->copy_label(three.c_str());
          }
          typeQ->copy_label("?");
      }

      textQ->copy_label(text.c_str());

      int X, Y, W, H, O;
      loadWin(synth, W, H, X, Y, O, "Master-query");

      if (W < queryDW || H < queryDH)
      {
          W = queryDW;
          H = queryDH;
      }
      checkSane(X, Y, W, H, queryDW, queryDH);
      querywindow->resize(Fl::event_x_root() + 16, Fl::event_y_root(), W, H);

      querywindow->show();
      int result = 0;
      while(querywindow->shown())
      {
          querywindow->show(); // keep it on top
          queryRtext();
          if (yesQ->value())
              result = 3;
          else if (noQ->value())
              result = 2;
          else if  (cancelQ->value())
              result = 1;
          Fl::wait();
      }
      saveWin(synth, querywindow->w(),querywindow->h(), querywindow->x(), querywindow->y(), false, "Master-query");
      return result;
}

void MasterUI::setmessage(int group, bool fixedPos, string text, string B1 , string B2 , string B3 ) {
  //
          msgGroup = group;
          if (B3.empty())
              yesdoit->hide();
          else
          {
              yesdoit->copy_label(B3.c_str());
              yesdoit->show();
          }
          if (B2.empty())
              cancel->hide();
          else
          {
              cancel->copy_label(B2.c_str());
              cancel->show();
          }
          closebutton->copy_label(B1.c_str());
          int X, Y, W, H, O;
          loadWin(synth, W, H,  X,  Y, O, "Master-message");
          if(W < msgDW || H < msgDW)
          {
              W = msgDW;
              H = msgDH;

          }
          checkSane(X, Y, W, H, msgDW, msgDH);

          if (fixedPos)
              message->resize(masterwindow->x() + masterwindow->w() / 2 - message->w() / 2, masterwindow->y() + masterwindow->h() / 2 - message->h() / 2, W, H);
          else
              message->resize(Fl::event_x_root() + 16, Fl::event_y_root(), W, H);
          words->copy_label(text.c_str());
          message->show();
}

string MasterUI::setinput(string label, string oldLine) {
  //
      textLine->copy_label(label.c_str());
      textLine->value(oldLine.c_str());
      int X, Y, W, H, O;
      loadWin(synth, W, H, X, Y, O, "Master-textin");
      X = Fl::event_x_root(); // always want these relative to parent
      Y = Fl::event_y_root();
      if(W < textinDW || H < textinDH)
      {
          W = textinDW;
          H = textinDH;
      }
      checkSane(X, Y, W, H, textinDW, textinDH, true);

      textwindow->size(W, H);
      textwindow->show();
      string text;
      string oldline = textLine->value();
      size_t pos = 1;
      while (textwindow->shown())
      {
          textwindow->show(); // keep it on top
          textinRtext();
          text = string(textLine->value());
          Fl::wait();
          pos = text.find_last_not_of(' ');
          if (pos != string::npos)
              pos -= text.find_first_not_of(' ');
          if (Fl::event_key() == FL_Enter)
          {
              if (pos == 0 || pos > 1)
                  textwindow->hide();
              else
                  textLine->copy_label("Must be at least 3 letters or none");
          }
      }
      saveWin(synth, textwindow->w(), textwindow->h(), textwindow->x(), textwindow->y(), false, "Master-textin");
      if (pos == 0 || pos == string::npos)
          return oldline;

      return text;
}

void MasterUI::updatesendwindow() {
  //

          ;
}

void MasterUI::updatelistitem(int part) {
  //
      int tmp = part % NUM_MIDI_CHANNELS;
      panellistitem[tmp]->refresh();
}

void MasterUI::changepanelstyle(int type, bool force ) {
  //
      if (type == 0)
          type = 1;
      panelwindow->hide();
      if (type == 1)
      {
          panelwindow->reset(PANEL_SINGLE_X, PANEL_SINGLE_Y);
          if (force)
              panelwindow->size(PANEL_SINGLE_X, PANEL_SINGLE_Y);
          panelwindow->size_range((PANEL_SINGLE_X * 9) / 10, (PANEL_SINGLE_Y * 9) / 10, 0, 0, 0, 0, 1);
          towide->hide();
          todeep->show();
          if (force)
              Panelclose->position(975, 290);
      }
      else if (type == 2)
      {
          panelwindow->reset(PANEL_DUAL_X, PANEL_DUAL_Y);
          if (force)
              panelwindow->size(PANEL_DUAL_X, PANEL_DUAL_Y);
          panelwindow->size_range((PANEL_DUAL_X * 4) / 5, (PANEL_DUAL_Y * 4) / 5, 0, 0, 0, 0, 1);
          towide->show();
          todeep->hide();
      }
      panelwindow->show();
      panelType = type;
      configui->PanelLayout->value(2 - type);
      if (configui->configwindow->visible())
          configui->configwindow->redraw();
      panelRtext();
}

void MasterUI::Showpanel() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Mixer");
      //std::cout << "fetch " << fetchO << std::endl;
      if (fetchO == 0)
          fetchO = 1; // it's never been seen so set the default

      int tmp = fetchO & 3;
      // find default sizes
      int defW = (PANEL_SINGLE_X * 9) / 10;
      int defH = (PANEL_SINGLE_Y * 9) / 10;
      if (tmp == 2)
      {
          defW = (PANEL_DUAL_X * 4) / 5;
          defH = (PANEL_DUAL_Y * 4) / 5;
      }
      panelwindow->reset(defW, defH);
      if (fetchW < defW || fetchH < defH)
      {
          fetchW = defW; // it's messed up so force default
          fetchH = defH;
      }
      configui->PanelLayout->value(2 - tmp);
      panelwindow->size_range(defW, defH, 0, 0, 0, 0, 1);
      checkSane(fetchX, fetchY, fetchW, fetchH, defW, defH);
      panelwindow->resize(fetchX, fetchY, fetchW, fetchH);

      if (fetchO < 4)
      {
          changepanelstyle(tmp);
          updatepanel();
      }
      else
      {
          panelType = fetchO;
          panelwindow->hide();
      }
}

void MasterUI::updatepanel(bool full ) {
  //

      if (partmax == (NUM_MIDI_CHANNELS * 4))
      {
          Panelgroups->show();
          Panelgroups->value(panelgroup / NUM_MIDI_CHANNELS);
      }
      else
          Panelgroups->hide();

      if (partmax == (NUM_MIDI_CHANNELS * 2))
      {
          Panelsmallgroups->show();
          Panelsmallgroups->value(panelgroup / NUM_MIDI_CHANNELS);
      }
      else
          Panelsmallgroups->hide();

      for (int part = 0; part < NUM_MIDI_CHANNELS; ++part)
      {
          panellistitem[part]->refresh();
      }

      if (vectorui->vectorwindow->visible()) // should this really be here?
      {
          for (int part = 0; part < partmax; ++part)
          {
              vectorui->setInstrumentLabel(part);
          }
      }

      int oldswitch = channelswitch->value();
      int nextValue = collect_readData(synth, 0, MAIN::control::soloType, TOPLEVEL::section::main);
      channelswitch->value(nextValue);
      if (full)
      {
          oldswitch = channelswitch->value(); // disables 'pending'
          CS_CC = nextValue;
      }
      if (nextValue > MIDI::SoloType::Disabled)
      {
          if (oldswitch == MIDI::SoloType::Disabled)
          {
              CSspinner->value(115);
              CSpend->show();
          }
          else
          {
              CSspinner->value(fetchData(0, MAIN::control::soloCC, TOPLEVEL::section::main));
              CSpend->hide();
          }
          CSspinner->show();
      }
      else
      {
          synth->getRuntime().channelSwitchCC = 128; // TODO why does the following fail?
          //send_data(TOPLEVEL::action::forceUpdate, MAIN::control::soloCC, 128, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
          CSspinner->hide();
          CSpend->hide();
      }
      panelwindow->changed();
      ;
}

void MasterUI::partSwitch(int next) {
  //
      if (npart != next)
      {
          npartcounter->value(next + 1);
          npartcounter->redraw();
          updatelistitem(npart); // deselect old one
          npart = next;
      }
      updatelistitem(next); // select and/or modify
      partui->rebuild(npart);

      partEnable->value(synth->part[npart]->Penabled == 1);
      if (partEnable->value() == 1)
          partControls->activate();
      else
          partControls->deactivate();
      refreshControls(npart);
      masterwindow->redraw();
}

void MasterUI::updateEngines(int engine, string instrumentName) {
  //
          if (engine & 1) // addsynth
          instrumentaddbox->color(add_back);
      else
          instrumentaddbox->color(bank_back_used);

      if (engine & 2) // subsynth
          instrumentsubbox->color(sub_back);
      else
          instrumentsubbox->color(bank_back_used);

      if (engine & 4) // padsynth
          instrumentpadbox->color(pad_back);
      else
          instrumentpadbox->color(bank_back_used);

      instrumentlabel->copy_label(instrumentName.c_str());

      if (npart >= panelgroup && npart < (panelgroup + NUM_MIDI_CHANNELS))
      {
          int num = npart % NUM_MIDI_CHANNELS;
          panellistitem[num]->refresh();
      }
}

void MasterUI::updateModepatch(bool inactive) {
  //
          if (inactive)
              modepatch->color(warning_background);
          else
              modepatch->color(FL_BACKGROUND_COLOR);
          modepatch->redraw();
}

void MasterUI::updatepart() {
  //
      if (checkmaxparts())
      {
          if (npart >= partmax)
          {
              npart %= NUM_MIDI_CHANNELS;
              npart += (partmax - NUM_MIDI_CHANNELS);
              npartcounter->value(npart + 1);
              npartcounter->do_callback();
          }
          maxparts->value(partmax);
          maxparts->redraw();
          return;
      }

      partEnable->value(synth->partonoffRead(npart));
      maxparts->value(partmax);
      maxparts->redraw();
      npartcounter->value(npart + 1);
      npartcounter->redraw();
      refreshControls(npart);
}

void MasterUI::refreshControls(int npart) {
  //
      partVol->value(synth->part[npart]->Pvolume);
      partVol->selection_color(setKnob(partVol->value(),96));
      partPan->value(synth->part[npart]->Ppanning);
      partPan->selection_color(setKnob(partPan->value(),64));
      partVelOffset->value(synth->part[npart]->Pveloffs);
      partVelOffset->selection_color(setKnob(partVelOffset->value(),64));
      partVelSense->value(synth->part[npart]->Pvelsns);
      partVelSense->selection_color(setKnob(partVelSense->value(),64));
      partui->setinstrumentlabel();
      partMidiCh->value(synth->part[npart]->Prcvchn + 1);
      partOmniEnable->value(synth->part[npart]->Pomni);
      partKeyLimit->value(synth->part[npart]->Pkeylimit);
      partKeyShift->value(synth->part[npart]->Pkeyshift - 64);
      minKeyCount->value(synth->part[npart]->Pminkey);
      maxKeyCount->value(synth->part[npart]->Pmaxkey);
      partPortamento->value(synth->part[npart]->ctl->portamento.portamento);

      sysEff1->value(synth->Psysefxvol[0][npart]);
          sysEff1->selection_color(setKnob(sysEff1->value(),0));
      sysEff2->value(synth->Psysefxvol[1][npart]);
          sysEff2->selection_color(setKnob(sysEff2->value(),0));
      sysEff3->value(synth->Psysefxvol[2][npart]);
          sysEff3->selection_color(setKnob(sysEff3->value(),0));
      sysEff4->value(synth->Psysefxvol[3][npart]);
          sysEff4->selection_color(setKnob(sysEff4->value(),0));

      int tmp = synth->ReadPartKeyMode(npart);
      if (tmp > PART_MONO)
          partKeymode->value(PART_LEGATO);
      else
          partKeymode->value(tmp);
      updateModepatch(tmp > PART_MONO && synth->part[npart]->Pdrummode != 0);

      partui->checkEngines();
}

void MasterUI::updatepartprogram(int next) {
  //
      if (vectorui)
          vectorui->setInstrumentLabel(next);

      if (partui->part->Prcvchn <  NUM_MIDI_CHANNELS)
      {
          partMidiCh->value(partui->part->Prcvchn + 1);
          partMidiCh->textcolor(gen_text);
      }
      else
      {
          //partMidiCh->textcolor(midi_solo_release);
          partMidiCh->textcolor(gen_text);
          partMidiCh->redraw();
      }
      partSwitch(next);
}

void MasterUI::setMasterLabel(string name) {
  //
          string spacer = "";
          if (!name.empty())
              spacer = " - ";
          masterwindow->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push(name), UNUSED, TOPLEVEL::windowTitle)).c_str());
          panelwindow->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Mixer Panel" + spacer + name), UNUSED, TOPLEVEL::windowTitle)).c_str());
          masterwindow->changed();
}

void MasterUI::do_load_scale(string fname) {
  //
      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::loadNamedScale, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(fname));
}

void MasterUI::do_load_instrument(string fname) {
  //
      int npart = partui->npart;

      if ((npart & 0x30) == (panelgroup & 0x30))
      {
          int displaypart = npart & 0x0f;
          panellistitem[displaypart]->partenabled->value(0);
          panellistitem[displaypart]->panellistitemgroup->deactivate();
      }
      partEnable->value(0);
      send_data(TOPLEVEL::action::forceUpdate, MAIN::control::loadInstrumentByName, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, npart, UNUSED, UNUSED, textMsgBuffer.push(fname));
}

void MasterUI::do_load_master(string filename) {
  //
      if (filename.empty())
      {
          filename = setfiler("", "", false, TOPLEVEL::XML::Patch);
          if (filename.empty())
              return;
      }

      send_data(TOPLEVEL::action::muteAndLoop | TOPLEVEL::action::forceUpdate, MAIN::control::loadNamedPatchset, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(filename));
}

void MasterUI::do_save_master() {
  //
      string filename = setfiler("", "", true, TOPLEVEL::XML::Patch);
      if (filename.empty())
          return;
      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate, MAIN::control::saveNamedPatchset, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(filename));
}

void MasterUI::refresh_master_ui(int type) {
  //
      if (microtonalui) // not taking chances!
          delete microtonalui;
      partmax = collect_readData(synth, 0, MAIN::control::availableParts, TOPLEVEL::main);
      maxparts->value(partmax);
      maxparts->redraw();
      checkmaxparts();
      panning_law->value(fetchData(0, MAIN::control::panLawType, TOPLEVEL::section::main));

      int next = collect_readData(synth, 0, MAIN::control::partNumber, TOPLEVEL::main); // make sure it's the right one!
      npartcounter->value(next + 1);
      partSwitch(next);

      // resync to effect data from last push-update
      syseffnocounter->value(syseffectui->effNum() + 1);
      sysefftype->value(syseffectui->effType());
      syseffectui->refresh();

      refreshInsEffUI();

      effDisplayType = 0;

      bool isDirty;
      SysEffOn->value(syseffectui->isEnabled());
      // note: effect type selection is never disabled
      if (syseffectui->effType() > 0)
      {
          isDirty = syseffectui->isChanged();
          syseffectui->UpdatePresetColour(isDirty, sysefftype->value());
      }
      if (inseffectui->effType() > 0)
      {
          isDirty = inseffectui->isChanged();
          inseffectui->UpdatePresetColour(isDirty, insefftype->value());
      }

      showSysEfxUI();

      masterkeyshift->value(synth->Pkeyshift - 64);
      setBpmFallbackValue(synth->PbpmFallback);
      mastervolumedial->value(synth->Pvolume);
      mastervolumedial->selection_color(setKnob(synth->Pvolume,90));
      globalfinedetune->value(synth->microtonal.Pglobalfinedetune);
      globalfinedetune->selection_color(setKnob(synth->microtonal.Pglobalfinedetune,64));
      microtonalui = new MicrotonalUI(&synth->microtonal, synth);
      if (type & 0x80)
          setMasterLabel(textMsgBuffer.fetch((type >> 8) & UNUSED));
      updatesendwindow();
      updatepanel(type > 0);
      if (type != 5)
          vectorui->RefreshChans();
      mastermono->value(0);
      mastermono->label("Stereo");
      if (type == 0x14)
      {
          for (int i = 1; i < 6; ++i)
              configui->update_config(i);
      }
}

bool MasterUI::checkmaxparts() {
  //
      bool changed = false;
      if (panelgroup >= partmax)
      {
          panelgroup = 0;
          Panelgroups->value(0);
          Panelsmallgroups->value(0);
          changed = true;
      }
      npartcounter->range(1, maxparts->value());
      if (npart >= maxparts->value())
      {
          npartcounter->value(1);
          changed = true;
      }
      return changed;
}

void MasterUI::strategicRetreat() {
  query("", "", "", "Bad things happened,\nYoshimi strategically retreats.");
}

void MasterUI::Log(string msg) {
  yoshiLog->log(msg);
}

void MasterUI::showSysEfxUI() {
  //
      inseffectui->hide();
      inseffectuigroup->hide();

      syseffectui->show();
      syseffectuigroup->show();
      lastmainW = 0;
}

void MasterUI::showInsEfxUI() {
  //
      syseffectui->hide();
      syseffectuigroup->hide();

      inseffectui->show();
      inseffectuigroup->show();
      lastmainW = 0;
}

void MasterUI::showSysEffSends() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Master-systemeffectsend");

      if(fetchW < syseffDW || fetchH < syseffDH)
      {
          fetchW = syseffDW;
          fetchH = syseffDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, syseffDW, syseffDH);

      syseffsendwindow->resize(fetchX, fetchY, fetchW, fetchH);
      syseffsendwindow->redraw();
      syseffsendwindow->show();
      syseffSeen = true;
}

void MasterUI::setinspartlist() {
  //
      inseffpart->clear();
      inseffpart->add("Master Out"); // 0
      inseffpart->add("Off");        // 1
      for (int i = 0; i < partmax; ++i)
      {
          string num = string("00") + asString(i + 1);
          inseffpart->add((string("Part ") + asString(i + 1)).c_str());
      }
      int current = inseffectui? inseffectui->getInsertFxRouting() : 2;
      assert(current < partmax);
      inseffpart->value(current + 2);
}

PresetsUI * MasterUI::getPresetsUi() {
  //
      return presetsui;
}

void MasterUI::resetPartsClip() {
  //
      for (int i = 0; i < NUM_MIDI_CHANNELS; i++)
      {
          if (panellistitem[i] && panellistitem[i]->partVUMeter)
          {
              panellistitem[i]->partVUMeter->resetPart(true);
          }
      }
}

void MasterUI::refreshInsEffUI() {
  //
      insefftype->value(inseffectui->effType());
      inseffnocounter->value(inseffectui->effNum() + 1);
      int routing = inseffectui->getInsertFxRouting();
      inseffpart->value(routing + 2); // offset since -2 ≙ master-out and -1 ≙ disabled
      inseffectui->refresh();
      if (routing != -1)
      {
          inseffectui->activate();
          inseffectuigroup->activate();
      }
      else
      {
          // note: effect type selection is never disabled
          inseffectui->deactivate();
          inseffectuigroup->deactivate();
      }
}

void MasterUI::setState(string filename) {
  //
      send_data(TOPLEVEL::action::muteAndLoop | TOPLEVEL::action::forceUpdate, MAIN::control::loadNamedState, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(filename));
}

void MasterUI::setPartActive(int _npart, bool active) {
  //
      if (_npart == npart)
      {
          partEnable->value(active);
      }
}

void MasterUI::setPanelPartVolWidget(int _npart, float _value) {
  //
      panellistitem[_npart]->partvolume->value(_value);
      panellistitem[_npart]->partvolume->selection_color(setSlider(_value,96));
}

void MasterUI::setPanelPartPanWidget(int _npart, float _value) {
  //
      panellistitem[_npart]->partpanning->value(_value);
      panellistitem[_npart]->partpanning->selection_color(setKnob(_value,64));
}

void MasterUI::setPartMidiWidget(int _npart, unsigned char _value) {
  //
      if (_npart == npart)
          partMidiCh->value(_value);
      partMidiCh->textcolor(gen_text);
}

void MasterUI::setPanelPartMidiWidget(int _npart, unsigned char _value) {
  //
      panellistitem[_npart]->partrcv->value(_value);
      panellistitem[_npart]->partrcv->textcolor(gen_text);
      panellistitem[_npart]->partrcv->redraw();
}

void MasterUI::setLogging(bool isConsole) {
  //
      logenable = isConsole;
      if (logenable)
          yoshiLog->Show(synth);
      else if (yoshiLog->logConsole->visible())
          yoshiLog->Hide(synth);
}

void MasterUI::setBpmFallbackValue(float value) {
  bpmfallback->value(value);
  // Force format to include up to two decimal spaces, but only if
  // they are non-zero.
  char tmp[50];
  snprintf(tmp, sizeof(tmp), "%.2f", value);
  size_t len = strlen(tmp);

  // Use const char references, since Fl_Spinner does not make an
  // internal copy.
  const char *format = "%.2f";
  if (tmp[len-1] == '0')
  {
      format = "%.1f";
      if (tmp[len-2] == '0')
          format = "%.0f";
  }
  bpmfallback->format(format);
}

void MasterUI::updateBankRootDirs() {
  bankui->readbankcfg();
}

void MasterUI::updatepaths(int type) {
  //
      if (type == 0)
      {
          bankui->readbankcfg();
          bankui-> rescan_for_banks();
      }
}

SynthEngine * MasterUI::getSynth() {
  return synth;
}

void MasterUI::loadWindowData() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;

      if (lastSeen(synth, "Mixer") & 3)
          Showpanel();

      if (lastSeen(synth, "Bank-instrument"))
          bankui->ShowInst();

      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Bank-bank");
      bankui->bankuiwindow->position(fetchX, fetchY);
      if (fetchO)
          bankui->Showbank();
      else
          bankui->bankuiwindow->hide();

      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Bank-root");
      bankui->rootuiwindow->position(fetchX, fetchY);
      if (fetchO)
          bankui->ShowRoot();
      else
          bankui->rootuiwindow->hide();

      if (lastSeen(synth, "Midi-virtualkeyboard"))
          virkeyboard->ShowKbd();
      else
          virkeyboard->virkeyboardwindow->hide();

      if (lastSeen(synth, "Scales"))
          microtonalui->showScales();
      else
          microtonalui->microtonaluiwindow->hide();

      if (lastSeen(synth, "Midi-learn"))
          midilearnui->showLearn();
      else
          midilearnui->midilearnwindow->hide();

      if (lastSeen(synth, "Config"))
          configui->Show(synth); // this does some initialising
      else
          configui->configwindow->hide();

      if (lastSeen(synth, "System-log") & 1)
          yoshiLog->Show(synth);
      else if (yoshiLog->logConsole->visible())
          yoshiLog->Hide(synth);

      if (lastSeen(synth, "Vector"))
          vectorui->Show(synth);
      else
          vectorui->vectorwindow->hide();

       if (lastSeen(synth, "Part-effects"))
          partui->Showefx();
      else
          partui->partfx->hide();

      if (lastSeen(synth, "Part-controllers"))
          partui->Showctl();
      else
          partui->ctlwindow->hide();

      if (lastSeen(synth, "Part-aftertouch"))
          partui->ShowAT();
      else
          partui->aftertouchcontrol->hide();

      if (lastSeen(synth, "Part-ctlmidi"))
          partui->Showctlmidi();
      else
          partui->ctlmidi->hide();

      if (lastSeen(synth, "Part-kit"))
          partui->Showkit();
      else
          partui->instrumentkitlist->hide();

      if (lastSeen(synth, "Part-edit"))
          partui->Showedit();
      else
          partui->instrumenteditwindow->hide();
}

void MasterUI::checkBuffer() {
  //
              if (lastmainW < 0) // not ready yet!
                  return;
              read_updates(synth);
              wincheck();
}

void MasterUI::rescaleMain() {
  //
              if (lastmainW < 0) // not ready yet!
                  return;
              float ratio = Fl::w() / float(1024); // reference width
              if (ratio < 1.0f)
                  ratio = 1.0f;


              int x, y, w, h;
              if (syseffSeen)
              {
                  x = syseffsendwindow->x();
                  y = syseffsendwindow->y();
                  w = syseffDW * ratio;
                  h = syseffDH * ratio;
                  if ((x + w) > Fl::w())
                      x = Fl::w() - w;
                  if ((y + h) > Fl::h())
                      y = Fl::h() - h;
                  syseffsendwindow->resize(x, y, w, h);
              }

              // we always check the main window last
              x = masterwindow->x();
              y = masterwindow->y();
              w = mainDW * ratio;
              h = mainDH * ratio;
              if ((x + w) > Fl::w())
                  x = Fl::w() - w;
              if ((y + h) > Fl::h())
                  y = Fl::h() - h;
              masterwindow->resize(x, y, w, h);
              //std::cout << "Screen ratio " << ratio << std::endl;
              ;
}

bool MasterUI::instrumentsWarning(string message) {
  //
      bool result = false;
      int count = 0;
      string changed = "";
      for (int i = 0; i < 64; ++i)
      {
          bool set = collect_readData(synth, 0, MAIN::control::partsChanged, TOPLEVEL::main, i);
          if (set)
          {
              ++count;
              changed = (changed + " " + to_string(i + 1));
          }
      }
      if (count)
      {
          if (count == 1)
              changed = ("Instrument in part " + changed + " has been edited. ");
          else
              changed = ("Instruments in parts " + changed + " have been edited. ");
          changed = changed + message;
          result = (query("", "Yes", "No", changed) < 2);
      }
      return result;
      ;
}

bool MasterUI::instrumentSingleWarning(int npart, string message) {
  //
      bool result = false;
      string changed = "";

      bool set = collect_readData(synth, 0, MAIN::control::partsChanged, TOPLEVEL::main, npart);
      if (set)
      {
          changed = (changed + " " + to_string(npart + 1));
          changed = ("Instrument in part " + changed + " has been edited. ");
          changed = changed + message;
          result = (query("", "Yes", "No", changed) < 2);
      }
      return result;
      ;
}

void MasterUI::wincheck() {
  //
      /*
       * Below is a pragmatic method of making tooltips
       * fairly readable at all screen resolutions.
       * 768 is the reference height.
       */
          if (oldH != Fl::h())
          {
              int setsize = int((11.0f / 768.0f) * Fl::h());
              Fl_Tooltip::size(setsize);
              oldH = Fl::h();
              //std::cout << "tipset " << setsize << "  actual " <<  Fl_Tooltip::size() << std::endl;

              if (masterwindow->x() >= Fl::w() || masterwindow->y() >= Fl::h())
                  Showmaster(); // ensure it's always visible
          }

      if (themeTrigger)
      {
          theme();
          themeTrigger = false;
      }
      if (masterwindow->w() != lastmainW)
      {
          mainRtext();
          if (lastmainW < 3)
              ++lastmainW;
          else
              lastmainW = masterwindow->w();
      }

      if (yoshiLog->logConsole->visible())
          yoshiLog->consoleRtext();

      if (panelwindow->visible())
      {
          if (panelwindow->w() != lastpanelW)
          {
              panelRtext();
              lastpanelW = panelwindow->w();
          }
      }

      if (message->visible() && message->w() != lastmsgW)
      {
          msgRtext();
          lastmsgW = message->w();
          msgSeen = true;
      }

      if (syseffectui->visible())
      {
          int efftype = EFFECT::type::eq - EFFECT::type::none;
          if(sysefftype->value() == efftype)
          {
              if (lastsyseffeqW < 0.15f)
              {
                  lastsyseffeqW += 0.01f;
              }
              else if (lastsyseffeqW != mainScale)
              {
                  syseffectui->effRtext(mainScale, efftype);
                  lastsyseffeqW = mainScale;
              }
          }
      }
      if (syseffectui != NULL)
      {
          if (syseffectui->filterwindow != NULL)
          {
              if (syseffectui->filterwindow->visible())
              {
                  if (lastsysDynFiltW != syseffectui->filterwindow->w())
                  {
                      syseffectui->filtRtext();
                      lastsysDynFiltW = syseffectui->filterwindow->w();
                  }
              }
          }
      }

      if (inseffectui != NULL)
      {
          if(inseffectui->filterwindow != NULL)
          {
              if (inseffectui->filterwindow->visible())
              {
                  if (lastinsDynFiltW != inseffectui->filterwindow->w())
                  {
                      inseffectui->filtRtext();
                      lastinsDynFiltW = inseffectui->filterwindow->w();
                  }
              }
          }
      }

      if (syseffsendwindow->visible() &&  syseffsendwindow->w() != lastsyseffW)
      {
          syseffRtext();
          lastsyseffW = syseffsendwindow->w();
      }

      if (vectorui->vectorwindow->visible())
          vectorui->vectorRtext();

      if (microtonalui->microtonaluiwindow->visible())
          microtonalui->scaleRtext();

      if (midilearnui->midilearnwindow->visible())
          midilearnui->learnRtext();

      if (virkeyboard->virkeyboardwindow->visible() && lastvirtW != virkeyboard->virkeyboardwindow->w())
      {
          virkeyboard->virtRtext();
          lastvirtW = virkeyboard->virkeyboardwindow->w();
      }

      if (aboutwindow->visible() && lastaboutW != aboutwindow->w())
      {
          aboutRtext();
          lastaboutW = aboutwindow->w();
      }

      if (paramsui->Recent->visible())
          paramsui->paramRtext();

      if (configui->configwindow->visible())
          configui->configRtext();

      if (configui->presets->visible())
          configui->presetsRtext();

      presetsui->UpresetsRtext();
      bankui->wincheck();
      partui->wincheck();
}

void MasterUI::mainRtext() {
  //

      mainScale = float(masterwindow->w() / mainDW);

      int size = int(10 * mainScale);
      int size11 = int(11 * mainScale);
      int size12 = int(12 * mainScale);
      int size14 = int(14 * mainScale);

      mastermenu->textsize(size12);

      // part insert controls
      partVol->labelsize(size);
      partPan->labelsize(size);
      partVelOffset->labelsize(size);
      partVelSense->labelsize(size);
      instrumentlabel->labelsize(size12);
      partEdit->labelsize(size12);
      partControllers->labelsize(size12);
      partMidiCCs->labelsize(size12);
      partMidiCh->labelsize(size11);
          partMidiCh->textsize(size11);
      partOmniEnable->labelsize(size11);
      partKeymode->textsize(size11);
          modepatch->labelsize(size11);
      partPortamento->labelsize(size11);
      minKeyCount->labelsize(size);
          minKeyCount->textsize(size11);
      maxKeyCount->labelsize(size);
          maxKeyCount->textsize(size11);
      setMinToLast->labelsize(size);
      setNormal->labelsize(size11);
      setMaxToLast->labelsize(size);
      partKeyShift->labelsize(size);
          partKeyShift->textsize(size11);
      partKeyLimit->labelsize(size);
          partKeyLimit->textsize(size11);

      sysEff1->labelsize(size);
      sysEff2->labelsize(size);
      sysEff3->labelsize(size);
      sysEff4->labelsize(size);
      sysEffName->labelsize(size);

      partEnable->labelsize(size14);

      mainreset->labelsize(size11);
      mainstop->labelsize(size11);
      mainvirtkeyb->labelsize(size11);
      mixerpanel->labelsize(size11);
      mainmidilearn->labelsize(size11);
      vectors->labelsize(size11);
      globalfinedetune->labelsize(size);
      mastervolumedial->labelsize(size);
      mastermono->labelsize(size11);
      masterkeyshift->labelsize(size);
      masterkeyshift->textsize(size12);
      bpmfallback->labelsize(size);
      bpmfallback->textsize(size12);

      InstBlurb->labelsize(size11);
      nextInst->labelsize(size11);
      valueInst->textsize(size11);
      cancelInst->labelsize(size11);
      SystemEffectsGrp->labelsize(size12);
      sysDisplay->labelsize(size12);
      InsertionEffectsGrp->labelsize(size12);
      insDisplay->labelsize(size12);
      if (syseffectui->visible())
      {;
          syseffnocounter->labelsize(size11);
              syseffnocounter->textsize(size11);
          sysefftype->labelsize(size11);
              sysefftype->textsize(size11);

          SysEffOn->labelsize(size14);
          sysEffSend->labelsize(size11);
          sysCopy->labelsize(size11);
          sysPaste->labelsize(size11);
          syseffectui->effRtext(mainScale, sysefftype->value());
      }
      else
      {
          inseffnocounter->labelsize(size11);
              inseffnocounter->textsize(size11);
          insefftype->labelsize(size11);
              insefftype->textsize(size11);

          inseffpart->labelsize(size11);
              inseffpart->textsize(size11);
          insCopy->labelsize(size11);
          insPaste->labelsize(size11);
          inseffectui->effRtext(mainScale, insefftype->value());
      }
      npartcounter->labelsize(size11);
          npartcounter->textsize(size11);
      maxparts->labelsize(size11);
          maxparts->textsize(size11);

      panning_law->labelsize(size12);
          panning_law->textsize(size12);

      undo->labelsize(size11);
      redo->labelsize(size11);

      masterwindow->redraw();
}

void MasterUI::panelRtext() {
  //
      int w = panelwindow->w();
      int h = panelwindow->h();
      float dW;
      float dH;

      if (panelType == 1)
      {
          dW = w / float(PANEL_SINGLE_X);
          dH = h / float(PANEL_SINGLE_Y);

      }
      else
      {
          dW = w / float(PANEL_DUAL_X);
          dH = h / float(PANEL_DUAL_Y);
      }

      float dScale;

      if (dW < dH)
          dScale = dW;
      else
          dScale = dH;
      if (dScale < 0.2f)
          dScale = 0.2f;
      panelScale = dScale;
      if (panelType == 1)
      {
          for (int i = 0; i < 16; ++ i)
          {
              panellistitem[i]->resize((8 + (i * 64)) * dW, 12 * dH, 63 * dW, 268 * dH);
              panellistitem[i]->itemRtext(dScale);
          }

      }
      else
      {
          for (int i = 0; i < 8; ++ i)
          {
              panellistitem[i]->resize((8 + (i * 64)) * dW, 12 * dH, 63 * dW, 268 * dH);
              panellistitem[i]->itemRtext(dScale);
          }
          for (int i = 8; i < 16; ++ i)
          {
              panellistitem[i]->resize((8 + ((i - 8) * 64)) * dW, 290 * dH, 63 * dW, 268 * dH);
              panellistitem[i]->itemRtext(dScale);
          }

          towide->resize(335 * dW, (PANEL_DUAL_Y - 30) * dH, 130 * dW, 25 * dH);
          Panelsmallgroups->resize(5 * dW, (PANEL_DUAL_Y - 23) * dH, 86 * dW, 18 * dH);
          Panelgroups->resize(5 * dW, (PANEL_DUAL_Y - 23) * dH, 86 * dW, 18 * dH);
          CSspinner->resize(173 * dW, (PANEL_DUAL_Y - 23) * dH, 50 * dW, 18 * dH);
          CSpend->resize(227 * dW, (PANEL_DUAL_Y - 30) * dH, 74 * dW, 25 * dH);
          channelswitch->resize(95 * dW, (PANEL_DUAL_Y -23) * dH, 74 * dW, 18 * dH);
          Panelclose->resize((PANEL_DUAL_X - 55) * dW, (PANEL_DUAL_Y - 30) * dH, 50 * dW, 25 * dH);

      }

      int size12 = int(12 * dScale);
      int size14 = int(14 * dScale);
      towide->labelsize(size14);
      todeep->labelsize(size14);
      Panelgroups->labelsize(size12);
          Panelgroups->textsize(size12);
      Panelsmallgroups->labelsize(size12);
          Panelsmallgroups->textsize(size12);
      CSspinner->labelsize(size12);
          CSspinner->textsize(size12);
      CSpend->labelsize(size12);
      channelswitch->labelsize(size12);
          channelswitch->textsize(size12);
      Panelclose->labelsize(size14);

      panelwindow->redraw();
}

void MasterUI::aboutRtext() {
  //
      float dScale = aboutwindow->w() / float(aboutDW);

      int size11 = int(11 * dScale);
      int size12 = int(12 * dScale);

      about2->labelsize(size11);
      about3->labelsize(size11);
      about4->labelsize(size12);
      about5->labelsize(size11);
      cont2->labelsize(size12);
      cont3->labelsize(size12);
      aboutClose->labelsize(size11);
      about1->labelsize(int(18 * dScale));
      cont1->labelsize(int(15 * dScale));

      aboutwindow->redraw();
      saveWin(synth, aboutwindow->w(), aboutwindow->h(), aboutwindow->x(), aboutwindow->y(), true, "Master-about");
}

void MasterUI::syseffRtext() {
  //
      float dScale = syseffsendwindow->w() / float(syseffDW);

      int size = int(10 * dScale);
      syseffname->labelsize(size);

      syseffClose->labelsize(int(14 * dScale));
      sys01txt->labelsize(size);
      sys02txt->labelsize(size);
      sys03txt->labelsize(size);
      sys12txt->labelsize(size);
      sys13txt->labelsize(size);
      sys23txt->labelsize(size);
      syseffsendwindow->redraw();
}

void MasterUI::queryRtext() {
  //
      if (lastqueryW == querywindow->w())
          return;
      lastqueryW = querywindow->w();

      float dScale = querywindow->w() / float(queryDW);

      int size14 = int(14 * dScale);

      yesQ->labelsize(size14);
      noQ->labelsize(size14);
      cancelQ->labelsize(size14);
      textQ->labelsize(size14);
      typeQ->labelsize(int(40 * dScale));

      querywindow->redraw();
}

void MasterUI::msgRtext() {
  //
      float dScale = message->w() / float(msgDW);

      int size14 = int(14 * dScale);

      words->labelsize(12 * dScale);
      yesdoit->labelsize(size14);
      cancel->labelsize(size14);
      closebutton->labelsize(size14);

      message->redraw();
      saveWin(synth, message->w(), message->h(),  message->x(),  message->y(), true, "Master-message");
}

void MasterUI::textinRtext() {
  //
      if (lasttextW == textwindow->w())
          return;
      lasttextW = textwindow->w();

      float dScale = textwindow->w() / float(textinDW);

      int size14 = int(14 * dScale);

      textLine->labelsize(size14);
      textLine->textsize(size14);
      textwindow->redraw();
}

void MasterUI::theme() {
  //
          lastmainW = 0;
          if (yoshiLog->logConsole->visible())
          {
              yoshiLog->lastlogW = 0;
              yoshiLog->consoleRtext();
          }
          if (panelwindow->visible())
          {
              panelRtext();
          }
          if (message->visible())
          {
              lastmsgW = 0;
              msgRtext();
          }
          if (syseffsendwindow->visible())
          {
              syseffRtext();
          }
          if (syseffectui != NULL)
          {
              if (syseffectui->filterwindow != NULL)
              {
                      if (syseffectui->filterwindow->visible())
                      {
                          lastsysDynFiltW = 0;
                          syseffectui->filtRtext();
                      }
                      if(syseffectui->fwin_filterui)
                          syseffectui->fwin_filterui->theme();
              }

          }
          if (inseffectui != NULL)
          {
              if (inseffectui->filterwindow != NULL)
              {
                      if (inseffectui->filterwindow->visible())
                      {
                          lastinsDynFiltW = 0;
                          inseffectui->filtRtext();
                      }
                      if(inseffectui->fwin_filterui)
                          inseffectui->fwin_filterui->theme();
              }
          }

          if (vectorui->vectorwindow->visible())
          {
              vectorui->lastvectorW = 0;
              vectorui->vectorRtext();
          }
          if (microtonalui->microtonaluiwindow->visible())
          {
              microtonalui->lastscaleW = 0;
              microtonalui->scaleRtext();
          }
          if (midilearnui->midilearnwindow->visible())
          {
              midilearnui->learnW = 0;
              midilearnui->learnRtext();
          }
          if (virkeyboard->virkeyboardwindow->visible())
          {
              virkeyboard->lastvirtW = 0;
              virkeyboard->virtRtext();
          }
          if (aboutwindow->visible())
          {
              aboutRtext();
          }
          if (paramsui->Recent->visible())
          {
              paramsui->lastParamW = 0;
              paramsui->paramRtext();
          }
          if (configui->configwindow->visible())
          {
              configui->configRtext();
          }
          if (configui->presets->visible())
          {
              configui->lastpresetW = 0;
              configui->presetsRtext();

          }
          bankui->theme();
          partui->theme();
          ;
}
