/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// ContainerUserApplyConfiguration represents a declarative configuration of the ContainerUser type for use
// with apply.
//
// ContainerUser represents user identity information
type ContainerUserApplyConfiguration struct {
	// Linux holds user identity information initially attached to the first process of the containers in Linux.
	// Note that the actual running identity can be changed if the process has enough privilege to do so.
	Linux *LinuxContainerUserApplyConfiguration `json:"linux,omitempty"`
}

// ContainerUserApplyConfiguration constructs a declarative configuration of the ContainerUser type for use with
// apply.
func ContainerUser() *ContainerUserApplyConfiguration {
	return &ContainerUserApplyConfiguration{}
}

// WithLinux sets the Linux field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Linux field is set to the value of the last call.
func (b *ContainerUserApplyConfiguration) WithLinux(value *LinuxContainerUserApplyConfiguration) *ContainerUserApplyConfiguration {
	b.Linux = value
	return b
}
