/* Generated by wayland-scanner 1.23.1 */

#ifndef WLR_DATA_CONTROL_UNSTABLE_V1_CLIENT_PROTOCOL_H
#define WLR_DATA_CONTROL_UNSTABLE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wlr_data_control_unstable_v1 The wlr_data_control_unstable_v1 protocol
 * control data devices
 *
 * @section page_desc_wlr_data_control_unstable_v1 Description
 *
 * This protocol allows a privileged client to control data devices. In
 * particular, the client will be able to manage the current selection and take
 * the role of a clipboard manager.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible changes
 * may be added together with the corresponding interface version bump.
 * Backward incompatible changes are done by bumping the version number in
 * the protocol and interface names and resetting the interface version.
 * Once the protocol is to be declared stable, the 'z' prefix and the
 * version number in the protocol and interface names are removed and the
 * interface version number is reset.
 *
 * @section page_ifaces_wlr_data_control_unstable_v1 Interfaces
 * - @subpage page_iface_zwlr_data_control_manager_v1 - manager to control data devices
 * - @subpage page_iface_zwlr_data_control_device_v1 - manage a data device for a seat
 * - @subpage page_iface_zwlr_data_control_source_v1 - offer to transfer data
 * - @subpage page_iface_zwlr_data_control_offer_v1 - offer to transfer data
 * @section page_copyright_wlr_data_control_unstable_v1 Copyright
 * <pre>
 *
 * Copyright © 2018 Simon Ser
 * Copyright © 2019 Ivan Molodetskikh
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct wl_seat;
struct zwlr_data_control_device_v1;
struct zwlr_data_control_manager_v1;
struct zwlr_data_control_offer_v1;
struct zwlr_data_control_source_v1;

#ifndef ZWLR_DATA_CONTROL_MANAGER_V1_INTERFACE
#define ZWLR_DATA_CONTROL_MANAGER_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_manager_v1 zwlr_data_control_manager_v1
 * @section page_iface_zwlr_data_control_manager_v1_desc Description
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 * @section page_iface_zwlr_data_control_manager_v1_api API
 * See @ref iface_zwlr_data_control_manager_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_manager_v1 The zwlr_data_control_manager_v1 interface
 *
 * This interface is a manager that allows creating per-seat data device
 * controls.
 */
extern const struct wl_interface zwlr_data_control_manager_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_DEVICE_V1_INTERFACE
#define ZWLR_DATA_CONTROL_DEVICE_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_device_v1 zwlr_data_control_device_v1
 * @section page_iface_zwlr_data_control_device_v1_desc Description
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 * @section page_iface_zwlr_data_control_device_v1_api API
 * See @ref iface_zwlr_data_control_device_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_device_v1 The zwlr_data_control_device_v1 interface
 *
 * This interface allows a client to manage a seat's selection.
 *
 * When the seat is destroyed, this object becomes inert.
 */
extern const struct wl_interface zwlr_data_control_device_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_SOURCE_V1_INTERFACE
#define ZWLR_DATA_CONTROL_SOURCE_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_source_v1 zwlr_data_control_source_v1
 * @section page_iface_zwlr_data_control_source_v1_desc Description
 *
 * The wlr_data_control_source object is the source side of a
 * wlr_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 * @section page_iface_zwlr_data_control_source_v1_api API
 * See @ref iface_zwlr_data_control_source_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_source_v1 The zwlr_data_control_source_v1 interface
 *
 * The wlr_data_control_source object is the source side of a
 * wlr_data_control_offer. It is created by the source client in a data
 * transfer and provides a way to describe the offered data and a way to
 * respond to requests to transfer the data.
 */
extern const struct wl_interface zwlr_data_control_source_v1_interface;
#endif
#ifndef ZWLR_DATA_CONTROL_OFFER_V1_INTERFACE
#define ZWLR_DATA_CONTROL_OFFER_V1_INTERFACE
/**
 * @page page_iface_zwlr_data_control_offer_v1 zwlr_data_control_offer_v1
 * @section page_iface_zwlr_data_control_offer_v1_desc Description
 *
 * A wlr_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 * @section page_iface_zwlr_data_control_offer_v1_api API
 * See @ref iface_zwlr_data_control_offer_v1.
 */
/**
 * @defgroup iface_zwlr_data_control_offer_v1 The zwlr_data_control_offer_v1 interface
 *
 * A wlr_data_control_offer represents a piece of data offered for transfer
 * by another client (the source client). The offer describes the different
 * MIME types that the data can be converted to and provides the mechanism
 * for transferring the data directly from the source client.
 */
extern const struct wl_interface zwlr_data_control_offer_v1_interface;
#endif

#define ZWLR_DATA_CONTROL_MANAGER_V1_CREATE_DATA_SOURCE 0
#define ZWLR_DATA_CONTROL_MANAGER_V1_GET_DATA_DEVICE 1
#define ZWLR_DATA_CONTROL_MANAGER_V1_DESTROY 2


/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_CREATE_DATA_SOURCE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_GET_DATA_DEVICE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_manager_v1
 */
#define ZWLR_DATA_CONTROL_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_data_control_manager_v1 */
static inline void
zwlr_data_control_manager_v1_set_user_data(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_data_control_manager_v1, user_data);
}

/** @ingroup iface_zwlr_data_control_manager_v1 */
static inline void *
zwlr_data_control_manager_v1_get_user_data(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_data_control_manager_v1);
}

static inline uint32_t
zwlr_data_control_manager_v1_get_version(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_manager_v1);
}

/**
 * @ingroup iface_zwlr_data_control_manager_v1
 *
 * Create a new data source.
 */
static inline struct zwlr_data_control_source_v1 *
zwlr_data_control_manager_v1_create_data_source(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_manager_v1,
			 ZWLR_DATA_CONTROL_MANAGER_V1_CREATE_DATA_SOURCE, &zwlr_data_control_source_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_manager_v1), 0, NULL);

	return (struct zwlr_data_control_source_v1 *) id;
}

/**
 * @ingroup iface_zwlr_data_control_manager_v1
 *
 * Create a data device that can be used to manage a seat's selection.
 */
static inline struct zwlr_data_control_device_v1 *
zwlr_data_control_manager_v1_get_data_device(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1, struct wl_seat *seat)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_manager_v1,
			 ZWLR_DATA_CONTROL_MANAGER_V1_GET_DATA_DEVICE, &zwlr_data_control_device_v1_interface, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_manager_v1), 0, NULL, seat);

	return (struct zwlr_data_control_device_v1 *) id;
}

/**
 * @ingroup iface_zwlr_data_control_manager_v1
 *
 * All objects created by the manager will still remain valid, until their
 * appropriate destroy request has been called.
 */
static inline void
zwlr_data_control_manager_v1_destroy(struct zwlr_data_control_manager_v1 *zwlr_data_control_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_manager_v1,
			 ZWLR_DATA_CONTROL_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
#define ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM
enum zwlr_data_control_device_v1_error {
	/**
	 * source given to set_selection or set_primary_selection was already used before
	 */
	ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_USED_SOURCE = 1,
};
#endif /* ZWLR_DATA_CONTROL_DEVICE_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_data_control_device_v1
 * @struct zwlr_data_control_device_v1_listener
 */
struct zwlr_data_control_device_v1_listener {
	/**
	 * introduce a new wlr_data_control_offer
	 *
	 * The data_offer event introduces a new wlr_data_control_offer
	 * object, which will subsequently be used in either the
	 * wlr_data_control_device.selection event (for the regular
	 * clipboard selections) or the
	 * wlr_data_control_device.primary_selection event (for the primary
	 * clipboard selections). Immediately following the
	 * wlr_data_control_device.data_offer event, the new data_offer
	 * object will send out wlr_data_control_offer.offer events to
	 * describe the MIME types it offers.
	 */
	void (*data_offer)(void *data,
			   struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1,
			   struct zwlr_data_control_offer_v1 *id);
	/**
	 * advertise new selection
	 *
	 * The selection event is sent out to notify the client of a new
	 * wlr_data_control_offer for the selection for this device. The
	 * wlr_data_control_device.data_offer and the
	 * wlr_data_control_offer.offer events are sent out immediately
	 * before this event to introduce the data offer object. The
	 * selection event is sent to a client when a new selection is set.
	 * The wlr_data_control_offer is valid until a new
	 * wlr_data_control_offer or NULL is received. The client must
	 * destroy the previous selection wlr_data_control_offer, if any,
	 * upon receiving this event.
	 *
	 * The first selection event is sent upon binding the
	 * wlr_data_control_device object.
	 */
	void (*selection)(void *data,
			  struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1,
			  struct zwlr_data_control_offer_v1 *id);
	/**
	 * this data control is no longer valid
	 *
	 * This data control object is no longer valid and should be
	 * destroyed by the client.
	 */
	void (*finished)(void *data,
			 struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1);
	/**
	 * advertise new primary selection
	 *
	 * The primary_selection event is sent out to notify the client
	 * of a new wlr_data_control_offer for the primary selection for
	 * this device. The wlr_data_control_device.data_offer and the
	 * wlr_data_control_offer.offer events are sent out immediately
	 * before this event to introduce the data offer object. The
	 * primary_selection event is sent to a client when a new primary
	 * selection is set. The wlr_data_control_offer is valid until a
	 * new wlr_data_control_offer or NULL is received. The client must
	 * destroy the previous primary selection wlr_data_control_offer,
	 * if any, upon receiving this event.
	 *
	 * If the compositor supports primary selection, the first
	 * primary_selection event is sent upon binding the
	 * wlr_data_control_device object.
	 * @since 2
	 */
	void (*primary_selection)(void *data,
				  struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1,
				  struct zwlr_data_control_offer_v1 *id);
};

/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
static inline int
zwlr_data_control_device_v1_add_listener(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1,
					 const struct zwlr_data_control_device_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_data_control_device_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_SELECTION 0
#define ZWLR_DATA_CONTROL_DEVICE_V1_DESTROY 1
#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_PRIMARY_SELECTION 2

/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_DATA_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_FINISHED_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_PRIMARY_SELECTION_SINCE_VERSION 2

/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_SELECTION_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_device_v1
 */
#define ZWLR_DATA_CONTROL_DEVICE_V1_SET_PRIMARY_SELECTION_SINCE_VERSION 2

/** @ingroup iface_zwlr_data_control_device_v1 */
static inline void
zwlr_data_control_device_v1_set_user_data(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_data_control_device_v1, user_data);
}

/** @ingroup iface_zwlr_data_control_device_v1 */
static inline void *
zwlr_data_control_device_v1_get_user_data(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_data_control_device_v1);
}

static inline uint32_t
zwlr_data_control_device_v1_get_version(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_device_v1);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 *
 * This request asks the compositor to set the selection to the data from
 * the source on behalf of the client.
 *
 * The given source may not be used in any further set_selection or
 * set_primary_selection requests. Attempting to use a previously used
 * source is a protocol error.
 *
 * To unset the selection, set the source to NULL.
 */
static inline void
zwlr_data_control_device_v1_set_selection(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1, struct zwlr_data_control_source_v1 *source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_device_v1,
			 ZWLR_DATA_CONTROL_DEVICE_V1_SET_SELECTION, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_device_v1), 0, source);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 *
 * Destroys the data device object.
 */
static inline void
zwlr_data_control_device_v1_destroy(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_device_v1,
			 ZWLR_DATA_CONTROL_DEVICE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_device_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwlr_data_control_device_v1
 *
 * This request asks the compositor to set the primary selection to the
 * data from the source on behalf of the client.
 *
 * The given source may not be used in any further set_selection or
 * set_primary_selection requests. Attempting to use a previously used
 * source is a protocol error.
 *
 * To unset the primary selection, set the source to NULL.
 *
 * The compositor will ignore this request if it does not support primary
 * selection.
 */
static inline void
zwlr_data_control_device_v1_set_primary_selection(struct zwlr_data_control_device_v1 *zwlr_data_control_device_v1, struct zwlr_data_control_source_v1 *source)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_device_v1,
			 ZWLR_DATA_CONTROL_DEVICE_V1_SET_PRIMARY_SELECTION, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_device_v1), 0, source);
}

#ifndef ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
#define ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM
enum zwlr_data_control_source_v1_error {
	/**
	 * offer sent after wlr_data_control_device.set_selection
	 */
	ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_INVALID_OFFER = 1,
};
#endif /* ZWLR_DATA_CONTROL_SOURCE_V1_ERROR_ENUM */

/**
 * @ingroup iface_zwlr_data_control_source_v1
 * @struct zwlr_data_control_source_v1_listener
 */
struct zwlr_data_control_source_v1_listener {
	/**
	 * send the data
	 *
	 * Request for data from the client. Send the data as the
	 * specified MIME type over the passed file descriptor, then close
	 * it.
	 * @param mime_type MIME type for the data
	 * @param fd file descriptor for the data
	 */
	void (*send)(void *data,
		     struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1,
		     const char *mime_type,
		     int32_t fd);
	/**
	 * selection was cancelled
	 *
	 * This data source is no longer valid. The data source has been
	 * replaced by another data source.
	 *
	 * The client should clean up and destroy this data source.
	 */
	void (*cancelled)(void *data,
			  struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1);
};

/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
static inline int
zwlr_data_control_source_v1_add_listener(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1,
					 const struct zwlr_data_control_source_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_data_control_source_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_DATA_CONTROL_SOURCE_V1_OFFER 0
#define ZWLR_DATA_CONTROL_SOURCE_V1_DESTROY 1

/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_SEND_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_CANCELLED_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_OFFER_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_source_v1
 */
#define ZWLR_DATA_CONTROL_SOURCE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_data_control_source_v1 */
static inline void
zwlr_data_control_source_v1_set_user_data(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_data_control_source_v1, user_data);
}

/** @ingroup iface_zwlr_data_control_source_v1 */
static inline void *
zwlr_data_control_source_v1_get_user_data(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_data_control_source_v1);
}

static inline uint32_t
zwlr_data_control_source_v1_get_version(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_source_v1);
}

/**
 * @ingroup iface_zwlr_data_control_source_v1
 *
 * This request adds a MIME type to the set of MIME types advertised to
 * targets. Can be called several times to offer multiple types.
 *
 * Calling this after wlr_data_control_device.set_selection is a protocol
 * error.
 */
static inline void
zwlr_data_control_source_v1_offer(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1, const char *mime_type)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_source_v1,
			 ZWLR_DATA_CONTROL_SOURCE_V1_OFFER, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_source_v1), 0, mime_type);
}

/**
 * @ingroup iface_zwlr_data_control_source_v1
 *
 * Destroys the data source object.
 */
static inline void
zwlr_data_control_source_v1_destroy(struct zwlr_data_control_source_v1 *zwlr_data_control_source_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_source_v1,
			 ZWLR_DATA_CONTROL_SOURCE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_source_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 * @struct zwlr_data_control_offer_v1_listener
 */
struct zwlr_data_control_offer_v1_listener {
	/**
	 * advertise offered MIME type
	 *
	 * Sent immediately after creating the wlr_data_control_offer
	 * object. One event per offered MIME type.
	 * @param mime_type offered MIME type
	 */
	void (*offer)(void *data,
		      struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1,
		      const char *mime_type);
};

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
static inline int
zwlr_data_control_offer_v1_add_listener(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1,
					const struct zwlr_data_control_offer_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zwlr_data_control_offer_v1,
				     (void (**)(void)) listener, data);
}

#define ZWLR_DATA_CONTROL_OFFER_V1_RECEIVE 0
#define ZWLR_DATA_CONTROL_OFFER_V1_DESTROY 1

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_OFFER_SINCE_VERSION 1

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_RECEIVE_SINCE_VERSION 1
/**
 * @ingroup iface_zwlr_data_control_offer_v1
 */
#define ZWLR_DATA_CONTROL_OFFER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_zwlr_data_control_offer_v1 */
static inline void
zwlr_data_control_offer_v1_set_user_data(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zwlr_data_control_offer_v1, user_data);
}

/** @ingroup iface_zwlr_data_control_offer_v1 */
static inline void *
zwlr_data_control_offer_v1_get_user_data(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zwlr_data_control_offer_v1);
}

static inline uint32_t
zwlr_data_control_offer_v1_get_version(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_offer_v1);
}

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 *
 * To transfer the offered data, the client issues this request and
 * indicates the MIME type it wants to receive. The transfer happens
 * through the passed file descriptor (typically created with the pipe
 * system call). The source client writes the data in the MIME type
 * representation requested and then closes the file descriptor.
 *
 * The receiving client reads from the read end of the pipe until EOF and
 * then closes its end, at which point the transfer is complete.
 *
 * This request may happen multiple times for different MIME types.
 */
static inline void
zwlr_data_control_offer_v1_receive(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1, const char *mime_type, int32_t fd)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_offer_v1,
			 ZWLR_DATA_CONTROL_OFFER_V1_RECEIVE, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_offer_v1), 0, mime_type, fd);
}

/**
 * @ingroup iface_zwlr_data_control_offer_v1
 *
 * Destroys the data offer object.
 */
static inline void
zwlr_data_control_offer_v1_destroy(struct zwlr_data_control_offer_v1 *zwlr_data_control_offer_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zwlr_data_control_offer_v1,
			 ZWLR_DATA_CONTROL_OFFER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) zwlr_data_control_offer_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
