/** @file
 * VirtualBox API class wrapper code for IRecordingScreenSettings.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_RECORDINGSCREENSETTINGS

#include "RecordingScreenSettingsWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(RecordingScreenSettingsWrap)

//
// IRecordingScreenSettings properties
//

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Id)(ULONG *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "RecordingScreenSettings::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(aId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ID_RETURN(this, hrc, 0 /*normal*/,*aId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,*aId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,*aId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Enabled)(BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%p\n", this, "RecordingScreenSettings::getEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnabled(aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ENABLED_RETURN(this, hrc, 0 /*normal*/,*aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnabled=%RTbool hrc=%Rhrc\n", this, "RecordingScreenSettings::getEnabled", *aEnabled, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(Enabled)(BOOL aEnabled)
{
    LogRelFlow(("{%p} %s: enter aEnabled=%RTbool\n", this, "RecordingScreenSettings::setEnabled", aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_ENABLED_ENTER(this, aEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnabled(aEnabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_ENABLED_RETURN(this, hrc, 0 /*normal*/,aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setEnabled", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Features)(ComSafeArrayOut(RecordingFeature_T, aFeatures))
{
    LogRelFlow(("{%p} %s: enter aFeatures=%p\n", this, "RecordingScreenSettings::getFeatures", aFeatures));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFeatures);
        ArrayOutConverter<RecordingFeature_T> TmpFeatures(ComSafeArrayOutArg(aFeatures));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FEATURES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFeatures(TmpFeatures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FEATURES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFeatures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FEATURES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FEATURES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFeatures=%zu hrc=%Rhrc\n", this, "RecordingScreenSettings::getFeatures", ComSafeArraySize(*aFeatures), hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(Features)(ComSafeArrayIn(RecordingFeature_T, aFeatures))
{
    LogRelFlow(("{%p} %s: enter aFeatures=%zu\n", this, "RecordingScreenSettings::setFeatures", ComSafeArraySize(aFeatures)));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        ArrayInConverter<RecordingFeature_T> TmpFeatures(ComSafeArrayInArg(aFeatures));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FEATURES_ENTER(this, (uint32_t)TmpFeatures.array().size(), NULL /*for now*/);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFeatures(TmpFeatures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FEATURES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpFeatures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FEATURES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FEATURES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setFeatures", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Destination)(RecordingDestination_T *aDestination)
{
    LogRelFlow(("{%p} %s: enter aDestination=%p\n", this, "RecordingScreenSettings::getDestination", aDestination));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDestination);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_DESTINATION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDestination(aDestination);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_DESTINATION_RETURN(this, hrc, 0 /*normal*/,*aDestination);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_DESTINATION_RETURN(this, hrc, 1 /*hrc exception*/,*aDestination);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_DESTINATION_RETURN(this, hrc, 9 /*unhandled exception*/,*aDestination);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDestination=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getDestination", *aDestination, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(Destination)(RecordingDestination_T aDestination)
{
    LogRelFlow(("{%p} %s: enter aDestination=%RU32\n", this, "RecordingScreenSettings::setDestination", aDestination));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_DESTINATION_ENTER(this, aDestination);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDestination(aDestination);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_DESTINATION_RETURN(this, hrc, 0 /*normal*/,aDestination);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_DESTINATION_RETURN(this, hrc, 1 /*hrc exception*/,aDestination);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_DESTINATION_RETURN(this, hrc, 9 /*unhandled exception*/,aDestination);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setDestination", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Filename)(BSTR *aFilename)
{
    LogRelFlow(("{%p} %s: enter aFilename=%p\n", this, "RecordingScreenSettings::getFilename", aFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilename);
        BSTROutConverter TmpFilename(aFilename);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FILENAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFilename(TmpFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FILENAME_RETURN(this, hrc, 0 /*normal*/,TmpFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FILENAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_FILENAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFilename=%ls hrc=%Rhrc\n", this, "RecordingScreenSettings::getFilename", *aFilename, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(Filename)(IN_BSTR aFilename)
{
    LogRelFlow(("{%p} %s: enter aFilename=%ls\n", this, "RecordingScreenSettings::setFilename", aFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpFilename(aFilename);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FILENAME_ENTER(this, TmpFilename.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setFilename(TmpFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FILENAME_RETURN(this, hrc, 0 /*normal*/,TmpFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FILENAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_FILENAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setFilename", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(MaxTime)(ULONG *aMaxTime)
{
    LogRelFlow(("{%p} %s: enter aMaxTime=%p\n", this, "RecordingScreenSettings::getMaxTime", aMaxTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxTime);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXTIME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxTime(aMaxTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXTIME_RETURN(this, hrc, 0 /*normal*/,*aMaxTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXTIME_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXTIME_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxTime=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getMaxTime", *aMaxTime, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(MaxTime)(ULONG aMaxTime)
{
    LogRelFlow(("{%p} %s: enter aMaxTime=%RU32\n", this, "RecordingScreenSettings::setMaxTime", aMaxTime));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXTIME_ENTER(this, aMaxTime);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxTime(aMaxTime);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXTIME_RETURN(this, hrc, 0 /*normal*/,aMaxTime);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXTIME_RETURN(this, hrc, 1 /*hrc exception*/,aMaxTime);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXTIME_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxTime);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setMaxTime", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(MaxFileSize)(ULONG *aMaxFileSize)
{
    LogRelFlow(("{%p} %s: enter aMaxFileSize=%p\n", this, "RecordingScreenSettings::getMaxFileSize", aMaxFileSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxFileSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXFILESIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxFileSize(aMaxFileSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXFILESIZE_RETURN(this, hrc, 0 /*normal*/,*aMaxFileSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXFILESIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxFileSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_MAXFILESIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxFileSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxFileSize=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getMaxFileSize", *aMaxFileSize, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(MaxFileSize)(ULONG aMaxFileSize)
{
    LogRelFlow(("{%p} %s: enter aMaxFileSize=%RU32\n", this, "RecordingScreenSettings::setMaxFileSize", aMaxFileSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXFILESIZE_ENTER(this, aMaxFileSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setMaxFileSize(aMaxFileSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXFILESIZE_RETURN(this, hrc, 0 /*normal*/,aMaxFileSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXFILESIZE_RETURN(this, hrc, 1 /*hrc exception*/,aMaxFileSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_MAXFILESIZE_RETURN(this, hrc, 9 /*unhandled exception*/,aMaxFileSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setMaxFileSize", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(Options)(BSTR *aOptions)
{
    LogRelFlow(("{%p} %s: enter aOptions=%p\n", this, "RecordingScreenSettings::getOptions", aOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOptions);
        BSTROutConverter TmpOptions(aOptions);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_OPTIONS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOptions(TmpOptions.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_OPTIONS_RETURN(this, hrc, 0 /*normal*/,TmpOptions.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_OPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_OPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOptions=%ls hrc=%Rhrc\n", this, "RecordingScreenSettings::getOptions", *aOptions, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(Options)(IN_BSTR aOptions)
{
    LogRelFlow(("{%p} %s: enter aOptions=%ls\n", this, "RecordingScreenSettings::setOptions", aOptions));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpOptions(aOptions);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_OPTIONS_ENTER(this, TmpOptions.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setOptions(TmpOptions.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_OPTIONS_RETURN(this, hrc, 0 /*normal*/,TmpOptions.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_OPTIONS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_OPTIONS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setOptions", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioCodec)(RecordingAudioCodec_T *aAudioCodec)
{
    LogRelFlow(("{%p} %s: enter aAudioCodec=%p\n", this, "RecordingScreenSettings::getAudioCodec", aAudioCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioCodec);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCODEC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioCodec(aAudioCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCODEC_RETURN(this, hrc, 0 /*normal*/,*aAudioCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioCodec=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioCodec", *aAudioCodec, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioCodec)(RecordingAudioCodec_T aAudioCodec)
{
    LogRelFlow(("{%p} %s: enter aAudioCodec=%RU32\n", this, "RecordingScreenSettings::setAudioCodec", aAudioCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCODEC_ENTER(this, aAudioCodec);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioCodec(aAudioCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCODEC_RETURN(this, hrc, 0 /*normal*/,aAudioCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,aAudioCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioCodec", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioRateControlMode)(RecordingRateControlMode_T *aAudioRateControlMode)
{
    LogRelFlow(("{%p} %s: enter aAudioRateControlMode=%p\n", this, "RecordingScreenSettings::getAudioRateControlMode", aAudioRateControlMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioRateControlMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIORATECONTROLMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioRateControlMode(aAudioRateControlMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIORATECONTROLMODE_RETURN(this, hrc, 0 /*normal*/,*aAudioRateControlMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIORATECONTROLMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioRateControlMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIORATECONTROLMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioRateControlMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioRateControlMode=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioRateControlMode", *aAudioRateControlMode, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioRateControlMode)(RecordingRateControlMode_T aAudioRateControlMode)
{
    LogRelFlow(("{%p} %s: enter aAudioRateControlMode=%RU32\n", this, "RecordingScreenSettings::setAudioRateControlMode", aAudioRateControlMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIORATECONTROLMODE_ENTER(this, aAudioRateControlMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioRateControlMode(aAudioRateControlMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIORATECONTROLMODE_RETURN(this, hrc, 0 /*normal*/,aAudioRateControlMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIORATECONTROLMODE_RETURN(this, hrc, 1 /*hrc exception*/,aAudioRateControlMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIORATECONTROLMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioRateControlMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioRateControlMode", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioDeadline)(RecordingCodecDeadline_T *aAudioDeadline)
{
    LogRelFlow(("{%p} %s: enter aAudioDeadline=%p\n", this, "RecordingScreenSettings::getAudioDeadline", aAudioDeadline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioDeadline);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIODEADLINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioDeadline(aAudioDeadline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIODEADLINE_RETURN(this, hrc, 0 /*normal*/,*aAudioDeadline);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIODEADLINE_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioDeadline);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIODEADLINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioDeadline);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioDeadline=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioDeadline", *aAudioDeadline, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioDeadline)(RecordingCodecDeadline_T aAudioDeadline)
{
    LogRelFlow(("{%p} %s: enter aAudioDeadline=%RU32\n", this, "RecordingScreenSettings::setAudioDeadline", aAudioDeadline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIODEADLINE_ENTER(this, aAudioDeadline);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioDeadline(aAudioDeadline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIODEADLINE_RETURN(this, hrc, 0 /*normal*/,aAudioDeadline);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIODEADLINE_RETURN(this, hrc, 1 /*hrc exception*/,aAudioDeadline);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIODEADLINE_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioDeadline);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioDeadline", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioHz)(ULONG *aAudioHz)
{
    LogRelFlow(("{%p} %s: enter aAudioHz=%p\n", this, "RecordingScreenSettings::getAudioHz", aAudioHz));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioHz);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOHZ_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioHz(aAudioHz);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOHZ_RETURN(this, hrc, 0 /*normal*/,*aAudioHz);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOHZ_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioHz);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOHZ_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioHz);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioHz=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioHz", *aAudioHz, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioHz)(ULONG aAudioHz)
{
    LogRelFlow(("{%p} %s: enter aAudioHz=%RU32\n", this, "RecordingScreenSettings::setAudioHz", aAudioHz));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOHZ_ENTER(this, aAudioHz);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioHz(aAudioHz);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOHZ_RETURN(this, hrc, 0 /*normal*/,aAudioHz);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOHZ_RETURN(this, hrc, 1 /*hrc exception*/,aAudioHz);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOHZ_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioHz);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioHz", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioBits)(ULONG *aAudioBits)
{
    LogRelFlow(("{%p} %s: enter aAudioBits=%p\n", this, "RecordingScreenSettings::getAudioBits", aAudioBits));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioBits);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOBITS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioBits(aAudioBits);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOBITS_RETURN(this, hrc, 0 /*normal*/,*aAudioBits);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOBITS_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioBits);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOBITS_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioBits);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioBits=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioBits", *aAudioBits, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioBits)(ULONG aAudioBits)
{
    LogRelFlow(("{%p} %s: enter aAudioBits=%RU32\n", this, "RecordingScreenSettings::setAudioBits", aAudioBits));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOBITS_ENTER(this, aAudioBits);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioBits(aAudioBits);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOBITS_RETURN(this, hrc, 0 /*normal*/,aAudioBits);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOBITS_RETURN(this, hrc, 1 /*hrc exception*/,aAudioBits);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOBITS_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioBits);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioBits", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(AudioChannels)(ULONG *aAudioChannels)
{
    LogRelFlow(("{%p} %s: enter aAudioChannels=%p\n", this, "RecordingScreenSettings::getAudioChannels", aAudioChannels));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAudioChannels);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCHANNELS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAudioChannels(aAudioChannels);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCHANNELS_RETURN(this, hrc, 0 /*normal*/,*aAudioChannels);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCHANNELS_RETURN(this, hrc, 1 /*hrc exception*/,*aAudioChannels);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_AUDIOCHANNELS_RETURN(this, hrc, 9 /*unhandled exception*/,*aAudioChannels);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAudioChannels=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getAudioChannels", *aAudioChannels, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(AudioChannels)(ULONG aAudioChannels)
{
    LogRelFlow(("{%p} %s: enter aAudioChannels=%RU32\n", this, "RecordingScreenSettings::setAudioChannels", aAudioChannels));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCHANNELS_ENTER(this, aAudioChannels);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAudioChannels(aAudioChannels);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCHANNELS_RETURN(this, hrc, 0 /*normal*/,aAudioChannels);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCHANNELS_RETURN(this, hrc, 1 /*hrc exception*/,aAudioChannels);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_AUDIOCHANNELS_RETURN(this, hrc, 9 /*unhandled exception*/,aAudioChannels);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setAudioChannels", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoCodec)(RecordingVideoCodec_T *aVideoCodec)
{
    LogRelFlow(("{%p} %s: enter aVideoCodec=%p\n", this, "RecordingScreenSettings::getVideoCodec", aVideoCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoCodec);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOCODEC_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoCodec(aVideoCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOCODEC_RETURN(this, hrc, 0 /*normal*/,*aVideoCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoCodec=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoCodec", *aVideoCodec, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoCodec)(RecordingVideoCodec_T aVideoCodec)
{
    LogRelFlow(("{%p} %s: enter aVideoCodec=%RU32\n", this, "RecordingScreenSettings::setVideoCodec", aVideoCodec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOCODEC_ENTER(this, aVideoCodec);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoCodec(aVideoCodec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOCODEC_RETURN(this, hrc, 0 /*normal*/,aVideoCodec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOCODEC_RETURN(this, hrc, 1 /*hrc exception*/,aVideoCodec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOCODEC_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoCodec);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoCodec", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoDeadline)(RecordingCodecDeadline_T *aVideoDeadline)
{
    LogRelFlow(("{%p} %s: enter aVideoDeadline=%p\n", this, "RecordingScreenSettings::getVideoDeadline", aVideoDeadline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoDeadline);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEODEADLINE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoDeadline(aVideoDeadline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEODEADLINE_RETURN(this, hrc, 0 /*normal*/,*aVideoDeadline);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEODEADLINE_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoDeadline);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEODEADLINE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoDeadline);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoDeadline=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoDeadline", *aVideoDeadline, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoDeadline)(RecordingCodecDeadline_T aVideoDeadline)
{
    LogRelFlow(("{%p} %s: enter aVideoDeadline=%RU32\n", this, "RecordingScreenSettings::setVideoDeadline", aVideoDeadline));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEODEADLINE_ENTER(this, aVideoDeadline);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoDeadline(aVideoDeadline);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEODEADLINE_RETURN(this, hrc, 0 /*normal*/,aVideoDeadline);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEODEADLINE_RETURN(this, hrc, 1 /*hrc exception*/,aVideoDeadline);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEODEADLINE_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoDeadline);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoDeadline", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoWidth)(ULONG *aVideoWidth)
{
    LogRelFlow(("{%p} %s: enter aVideoWidth=%p\n", this, "RecordingScreenSettings::getVideoWidth", aVideoWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoWidth);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOWIDTH_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoWidth(aVideoWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOWIDTH_RETURN(this, hrc, 0 /*normal*/,*aVideoWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOWIDTH_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOWIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoWidth=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoWidth", *aVideoWidth, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoWidth)(ULONG aVideoWidth)
{
    LogRelFlow(("{%p} %s: enter aVideoWidth=%RU32\n", this, "RecordingScreenSettings::setVideoWidth", aVideoWidth));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOWIDTH_ENTER(this, aVideoWidth);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoWidth(aVideoWidth);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOWIDTH_RETURN(this, hrc, 0 /*normal*/,aVideoWidth);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOWIDTH_RETURN(this, hrc, 1 /*hrc exception*/,aVideoWidth);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOWIDTH_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoWidth);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoWidth", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoHeight)(ULONG *aVideoHeight)
{
    LogRelFlow(("{%p} %s: enter aVideoHeight=%p\n", this, "RecordingScreenSettings::getVideoHeight", aVideoHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoHeight);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOHEIGHT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoHeight(aVideoHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOHEIGHT_RETURN(this, hrc, 0 /*normal*/,*aVideoHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOHEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOHEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoHeight=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoHeight", *aVideoHeight, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoHeight)(ULONG aVideoHeight)
{
    LogRelFlow(("{%p} %s: enter aVideoHeight=%RU32\n", this, "RecordingScreenSettings::setVideoHeight", aVideoHeight));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOHEIGHT_ENTER(this, aVideoHeight);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoHeight(aVideoHeight);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOHEIGHT_RETURN(this, hrc, 0 /*normal*/,aVideoHeight);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOHEIGHT_RETURN(this, hrc, 1 /*hrc exception*/,aVideoHeight);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOHEIGHT_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoHeight);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoHeight", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoRate)(ULONG *aVideoRate)
{
    LogRelFlow(("{%p} %s: enter aVideoRate=%p\n", this, "RecordingScreenSettings::getVideoRate", aVideoRate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoRate);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoRate(aVideoRate);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATE_RETURN(this, hrc, 0 /*normal*/,*aVideoRate);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATE_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoRate);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoRate);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoRate=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoRate", *aVideoRate, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoRate)(ULONG aVideoRate)
{
    LogRelFlow(("{%p} %s: enter aVideoRate=%RU32\n", this, "RecordingScreenSettings::setVideoRate", aVideoRate));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATE_ENTER(this, aVideoRate);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoRate(aVideoRate);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATE_RETURN(this, hrc, 0 /*normal*/,aVideoRate);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATE_RETURN(this, hrc, 1 /*hrc exception*/,aVideoRate);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATE_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoRate);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoRate", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoRateControlMode)(RecordingRateControlMode_T *aVideoRateControlMode)
{
    LogRelFlow(("{%p} %s: enter aVideoRateControlMode=%p\n", this, "RecordingScreenSettings::getVideoRateControlMode", aVideoRateControlMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoRateControlMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATECONTROLMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoRateControlMode(aVideoRateControlMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATECONTROLMODE_RETURN(this, hrc, 0 /*normal*/,*aVideoRateControlMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATECONTROLMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoRateControlMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEORATECONTROLMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoRateControlMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoRateControlMode=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoRateControlMode", *aVideoRateControlMode, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoRateControlMode)(RecordingRateControlMode_T aVideoRateControlMode)
{
    LogRelFlow(("{%p} %s: enter aVideoRateControlMode=%RU32\n", this, "RecordingScreenSettings::setVideoRateControlMode", aVideoRateControlMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATECONTROLMODE_ENTER(this, aVideoRateControlMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoRateControlMode(aVideoRateControlMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATECONTROLMODE_RETURN(this, hrc, 0 /*normal*/,aVideoRateControlMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATECONTROLMODE_RETURN(this, hrc, 1 /*hrc exception*/,aVideoRateControlMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEORATECONTROLMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoRateControlMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoRateControlMode", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoFPS)(ULONG *aVideoFPS)
{
    LogRelFlow(("{%p} %s: enter aVideoFPS=%p\n", this, "RecordingScreenSettings::getVideoFPS", aVideoFPS));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoFPS);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOFPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoFPS(aVideoFPS);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOFPS_RETURN(this, hrc, 0 /*normal*/,*aVideoFPS);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOFPS_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoFPS);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOFPS_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoFPS);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoFPS=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoFPS", *aVideoFPS, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoFPS)(ULONG aVideoFPS)
{
    LogRelFlow(("{%p} %s: enter aVideoFPS=%RU32\n", this, "RecordingScreenSettings::setVideoFPS", aVideoFPS));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOFPS_ENTER(this, aVideoFPS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoFPS(aVideoFPS);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOFPS_RETURN(this, hrc, 0 /*normal*/,aVideoFPS);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOFPS_RETURN(this, hrc, 1 /*hrc exception*/,aVideoFPS);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOFPS_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoFPS);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoFPS", hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMGETTER(VideoScalingMode)(RecordingVideoScalingMode_T *aVideoScalingMode)
{
    LogRelFlow(("{%p} %s: enter aVideoScalingMode=%p\n", this, "RecordingScreenSettings::getVideoScalingMode", aVideoScalingMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVideoScalingMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOSCALINGMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVideoScalingMode(aVideoScalingMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOSCALINGMODE_RETURN(this, hrc, 0 /*normal*/,*aVideoScalingMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOSCALINGMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aVideoScalingMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_GET_VIDEOSCALINGMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aVideoScalingMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVideoScalingMode=%RU32 hrc=%Rhrc\n", this, "RecordingScreenSettings::getVideoScalingMode", *aVideoScalingMode, hrc));
    return hrc;
}

STDMETHODIMP RecordingScreenSettingsWrap::COMSETTER(VideoScalingMode)(RecordingVideoScalingMode_T aVideoScalingMode)
{
    LogRelFlow(("{%p} %s: enter aVideoScalingMode=%RU32\n", this, "RecordingScreenSettings::setVideoScalingMode", aVideoScalingMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOSCALINGMODE_ENTER(this, aVideoScalingMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setVideoScalingMode(aVideoScalingMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOSCALINGMODE_RETURN(this, hrc, 0 /*normal*/,aVideoScalingMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOSCALINGMODE_RETURN(this, hrc, 1 /*hrc exception*/,aVideoScalingMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_SET_VIDEOSCALINGMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aVideoScalingMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "RecordingScreenSettings::setVideoScalingMode", hrc));
    return hrc;
}


//
// IRecordingScreenSettings methods
//

STDMETHODIMP RecordingScreenSettingsWrap::IsFeatureEnabled(RecordingFeature_T aFeature,
                                                           BOOL *aEnabled)
{
    LogRelFlow(("{%p} %s: enter aFeature=%RU32 aEnabled=%p\n", this, "RecordingScreenSettings::isFeatureEnabled", aFeature, aEnabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnabled);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_ISFEATUREENABLED_ENTER(this, aFeature);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isFeatureEnabled(aFeature,
                                   aEnabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_ISFEATUREENABLED_RETURN(this, hrc, 0 /*normal*/, aFeature, *aEnabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_ISFEATUREENABLED_RETURN(this, hrc, 1 /*hrc exception*/, aFeature, *aEnabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_RECORDINGSCREENSETTINGS_ISFEATUREENABLED_RETURN(this, hrc, 9 /*unhandled exception*/, aFeature, *aEnabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aEnabled=%RTbool hrc=%Rhrc\n", this, "RecordingScreenSettings::isFeatureEnabled", *aEnabled, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(RecordingScreenSettingsWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(RecordingScreenSettingsWrap, IRecordingScreenSettings)
#endif // VBOX_WITH_XPCOM
