/** @file
 * VirtualBox API class wrapper code for INATEngine.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_NATENGINE

#include "NATEngineWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(NATEngineWrap)

//
// INATEngine properties
//

STDMETHODIMP NATEngineWrap::COMGETTER(Network)(BSTR *aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%p\n", this, "NATEngine::getNetwork", aNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNetwork);
        BSTROutConverter TmpNetwork(aNetwork);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NETWORK_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetwork(TmpNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNetwork=%ls hrc=%Rhrc\n", this, "NATEngine::getNetwork", *aNetwork, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(Network)(IN_BSTR aNetwork)
{
    LogRelFlow(("{%p} %s: enter aNetwork=%ls\n", this, "NATEngine::setNetwork", aNetwork));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpNetwork(aNetwork);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NETWORK_ENTER(this, TmpNetwork.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetwork(TmpNetwork.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NETWORK_RETURN(this, hrc, 0 /*normal*/,TmpNetwork.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NETWORK_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NETWORK_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setNetwork", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(HostIP)(BSTR *aHostIP)
{
    LogRelFlow(("{%p} %s: enter aHostIP=%p\n", this, "NATEngine::getHostIP", aHostIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostIP);
        BSTROutConverter TmpHostIP(aHostIP);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_HOSTIP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostIP(TmpHostIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_HOSTIP_RETURN(this, hrc, 0 /*normal*/,TmpHostIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_HOSTIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_HOSTIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostIP=%ls hrc=%Rhrc\n", this, "NATEngine::getHostIP", *aHostIP, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(HostIP)(IN_BSTR aHostIP)
{
    LogRelFlow(("{%p} %s: enter aHostIP=%ls\n", this, "NATEngine::setHostIP", aHostIP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpHostIP(aHostIP);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_HOSTIP_ENTER(this, TmpHostIP.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setHostIP(TmpHostIP.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_HOSTIP_RETURN(this, hrc, 0 /*normal*/,TmpHostIP.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_HOSTIP_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_HOSTIP_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setHostIP", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(TFTPPrefix)(BSTR *aTFTPPrefix)
{
    LogRelFlow(("{%p} %s: enter aTFTPPrefix=%p\n", this, "NATEngine::getTFTPPrefix", aTFTPPrefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTFTPPrefix);
        BSTROutConverter TmpTFTPPrefix(aTFTPPrefix);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPPREFIX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTFTPPrefix(TmpTFTPPrefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPPREFIX_RETURN(this, hrc, 0 /*normal*/,TmpTFTPPrefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPPREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPPREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTFTPPrefix=%ls hrc=%Rhrc\n", this, "NATEngine::getTFTPPrefix", *aTFTPPrefix, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(TFTPPrefix)(IN_BSTR aTFTPPrefix)
{
    LogRelFlow(("{%p} %s: enter aTFTPPrefix=%ls\n", this, "NATEngine::setTFTPPrefix", aTFTPPrefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTFTPPrefix(aTFTPPrefix);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPPREFIX_ENTER(this, TmpTFTPPrefix.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTFTPPrefix(TmpTFTPPrefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPPREFIX_RETURN(this, hrc, 0 /*normal*/,TmpTFTPPrefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPPREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPPREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setTFTPPrefix", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(TFTPBootFile)(BSTR *aTFTPBootFile)
{
    LogRelFlow(("{%p} %s: enter aTFTPBootFile=%p\n", this, "NATEngine::getTFTPBootFile", aTFTPBootFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTFTPBootFile);
        BSTROutConverter TmpTFTPBootFile(aTFTPBootFile);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPBOOTFILE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTFTPBootFile(TmpTFTPBootFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPBOOTFILE_RETURN(this, hrc, 0 /*normal*/,TmpTFTPBootFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPBOOTFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPBOOTFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTFTPBootFile=%ls hrc=%Rhrc\n", this, "NATEngine::getTFTPBootFile", *aTFTPBootFile, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(TFTPBootFile)(IN_BSTR aTFTPBootFile)
{
    LogRelFlow(("{%p} %s: enter aTFTPBootFile=%ls\n", this, "NATEngine::setTFTPBootFile", aTFTPBootFile));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTFTPBootFile(aTFTPBootFile);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPBOOTFILE_ENTER(this, TmpTFTPBootFile.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTFTPBootFile(TmpTFTPBootFile.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPBOOTFILE_RETURN(this, hrc, 0 /*normal*/,TmpTFTPBootFile.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPBOOTFILE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPBOOTFILE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setTFTPBootFile", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(TFTPNextServer)(BSTR *aTFTPNextServer)
{
    LogRelFlow(("{%p} %s: enter aTFTPNextServer=%p\n", this, "NATEngine::getTFTPNextServer", aTFTPNextServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTFTPNextServer);
        BSTROutConverter TmpTFTPNextServer(aTFTPNextServer);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPNEXTSERVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTFTPNextServer(TmpTFTPNextServer.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPNEXTSERVER_RETURN(this, hrc, 0 /*normal*/,TmpTFTPNextServer.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPNEXTSERVER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_TFTPNEXTSERVER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTFTPNextServer=%ls hrc=%Rhrc\n", this, "NATEngine::getTFTPNextServer", *aTFTPNextServer, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(TFTPNextServer)(IN_BSTR aTFTPNextServer)
{
    LogRelFlow(("{%p} %s: enter aTFTPNextServer=%ls\n", this, "NATEngine::setTFTPNextServer", aTFTPNextServer));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpTFTPNextServer(aTFTPNextServer);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPNEXTSERVER_ENTER(this, TmpTFTPNextServer.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setTFTPNextServer(TmpTFTPNextServer.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPNEXTSERVER_RETURN(this, hrc, 0 /*normal*/,TmpTFTPNextServer.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPNEXTSERVER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_TFTPNEXTSERVER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setTFTPNextServer", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(AliasMode)(ULONG *aAliasMode)
{
    LogRelFlow(("{%p} %s: enter aAliasMode=%p\n", this, "NATEngine::getAliasMode", aAliasMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAliasMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ALIASMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAliasMode(aAliasMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ALIASMODE_RETURN(this, hrc, 0 /*normal*/,*aAliasMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ALIASMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aAliasMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ALIASMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAliasMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAliasMode=%RU32 hrc=%Rhrc\n", this, "NATEngine::getAliasMode", *aAliasMode, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(AliasMode)(ULONG aAliasMode)
{
    LogRelFlow(("{%p} %s: enter aAliasMode=%RU32\n", this, "NATEngine::setAliasMode", aAliasMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ALIASMODE_ENTER(this, aAliasMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setAliasMode(aAliasMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ALIASMODE_RETURN(this, hrc, 0 /*normal*/,aAliasMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ALIASMODE_RETURN(this, hrc, 1 /*hrc exception*/,aAliasMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ALIASMODE_RETURN(this, hrc, 9 /*unhandled exception*/,aAliasMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setAliasMode", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(DNSPassDomain)(BOOL *aDNSPassDomain)
{
    LogRelFlow(("{%p} %s: enter aDNSPassDomain=%p\n", this, "NATEngine::getDNSPassDomain", aDNSPassDomain));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDNSPassDomain);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPASSDOMAIN_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDNSPassDomain(aDNSPassDomain);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPASSDOMAIN_RETURN(this, hrc, 0 /*normal*/,*aDNSPassDomain != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPASSDOMAIN_RETURN(this, hrc, 1 /*hrc exception*/,*aDNSPassDomain != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPASSDOMAIN_RETURN(this, hrc, 9 /*unhandled exception*/,*aDNSPassDomain != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDNSPassDomain=%RTbool hrc=%Rhrc\n", this, "NATEngine::getDNSPassDomain", *aDNSPassDomain, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(DNSPassDomain)(BOOL aDNSPassDomain)
{
    LogRelFlow(("{%p} %s: enter aDNSPassDomain=%RTbool\n", this, "NATEngine::setDNSPassDomain", aDNSPassDomain));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPASSDOMAIN_ENTER(this, aDNSPassDomain != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDNSPassDomain(aDNSPassDomain != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPASSDOMAIN_RETURN(this, hrc, 0 /*normal*/,aDNSPassDomain != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPASSDOMAIN_RETURN(this, hrc, 1 /*hrc exception*/,aDNSPassDomain != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPASSDOMAIN_RETURN(this, hrc, 9 /*unhandled exception*/,aDNSPassDomain != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setDNSPassDomain", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(DNSProxy)(BOOL *aDNSProxy)
{
    LogRelFlow(("{%p} %s: enter aDNSProxy=%p\n", this, "NATEngine::getDNSProxy", aDNSProxy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDNSProxy);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPROXY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDNSProxy(aDNSProxy);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPROXY_RETURN(this, hrc, 0 /*normal*/,*aDNSProxy != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPROXY_RETURN(this, hrc, 1 /*hrc exception*/,*aDNSProxy != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSPROXY_RETURN(this, hrc, 9 /*unhandled exception*/,*aDNSProxy != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDNSProxy=%RTbool hrc=%Rhrc\n", this, "NATEngine::getDNSProxy", *aDNSProxy, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(DNSProxy)(BOOL aDNSProxy)
{
    LogRelFlow(("{%p} %s: enter aDNSProxy=%RTbool\n", this, "NATEngine::setDNSProxy", aDNSProxy));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPROXY_ENTER(this, aDNSProxy != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDNSProxy(aDNSProxy != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPROXY_RETURN(this, hrc, 0 /*normal*/,aDNSProxy != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPROXY_RETURN(this, hrc, 1 /*hrc exception*/,aDNSProxy != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSPROXY_RETURN(this, hrc, 9 /*unhandled exception*/,aDNSProxy != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setDNSProxy", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(DNSUseHostResolver)(BOOL *aDNSUseHostResolver)
{
    LogRelFlow(("{%p} %s: enter aDNSUseHostResolver=%p\n", this, "NATEngine::getDNSUseHostResolver", aDNSUseHostResolver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDNSUseHostResolver);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSUSEHOSTRESOLVER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDNSUseHostResolver(aDNSUseHostResolver);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 0 /*normal*/,*aDNSUseHostResolver != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 1 /*hrc exception*/,*aDNSUseHostResolver != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 9 /*unhandled exception*/,*aDNSUseHostResolver != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDNSUseHostResolver=%RTbool hrc=%Rhrc\n", this, "NATEngine::getDNSUseHostResolver", *aDNSUseHostResolver, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(DNSUseHostResolver)(BOOL aDNSUseHostResolver)
{
    LogRelFlow(("{%p} %s: enter aDNSUseHostResolver=%RTbool\n", this, "NATEngine::setDNSUseHostResolver", aDNSUseHostResolver));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSUSEHOSTRESOLVER_ENTER(this, aDNSUseHostResolver != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDNSUseHostResolver(aDNSUseHostResolver != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 0 /*normal*/,aDNSUseHostResolver != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 1 /*hrc exception*/,aDNSUseHostResolver != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_DNSUSEHOSTRESOLVER_RETURN(this, hrc, 9 /*unhandled exception*/,aDNSUseHostResolver != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setDNSUseHostResolver", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(Redirects)(ComSafeArrayOut(BSTR, aRedirects))
{
    LogRelFlow(("{%p} %s: enter aRedirects=%p\n", this, "NATEngine::getRedirects", aRedirects));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRedirects);
        ArrayBSTROutConverter TmpRedirects(ComSafeArrayOutArg(aRedirects));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_REDIRECTS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRedirects(TmpRedirects.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_REDIRECTS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpRedirects.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_REDIRECTS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_REDIRECTS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRedirects=%zu hrc=%Rhrc\n", this, "NATEngine::getRedirects", ComSafeArraySize(*aRedirects), hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(LocalhostReachable)(BOOL *aLocalhostReachable)
{
    LogRelFlow(("{%p} %s: enter aLocalhostReachable=%p\n", this, "NATEngine::getLocalhostReachable", aLocalhostReachable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLocalhostReachable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_LOCALHOSTREACHABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLocalhostReachable(aLocalhostReachable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 0 /*normal*/,*aLocalhostReachable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aLocalhostReachable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_LOCALHOSTREACHABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aLocalhostReachable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLocalhostReachable=%RTbool hrc=%Rhrc\n", this, "NATEngine::getLocalhostReachable", *aLocalhostReachable, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(LocalhostReachable)(BOOL aLocalhostReachable)
{
    LogRelFlow(("{%p} %s: enter aLocalhostReachable=%RTbool\n", this, "NATEngine::setLocalhostReachable", aLocalhostReachable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_LOCALHOSTREACHABLE_ENTER(this, aLocalhostReachable != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setLocalhostReachable(aLocalhostReachable != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 0 /*normal*/,aLocalhostReachable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 1 /*hrc exception*/,aLocalhostReachable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_LOCALHOSTREACHABLE_RETURN(this, hrc, 9 /*unhandled exception*/,aLocalhostReachable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setLocalhostReachable", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(ForwardBroadcast)(BOOL *aForwardBroadcast)
{
    LogRelFlow(("{%p} %s: enter aForwardBroadcast=%p\n", this, "NATEngine::getForwardBroadcast", aForwardBroadcast));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aForwardBroadcast);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_FORWARDBROADCAST_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getForwardBroadcast(aForwardBroadcast);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_FORWARDBROADCAST_RETURN(this, hrc, 0 /*normal*/,*aForwardBroadcast != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_FORWARDBROADCAST_RETURN(this, hrc, 1 /*hrc exception*/,*aForwardBroadcast != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_FORWARDBROADCAST_RETURN(this, hrc, 9 /*unhandled exception*/,*aForwardBroadcast != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aForwardBroadcast=%RTbool hrc=%Rhrc\n", this, "NATEngine::getForwardBroadcast", *aForwardBroadcast, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(ForwardBroadcast)(BOOL aForwardBroadcast)
{
    LogRelFlow(("{%p} %s: enter aForwardBroadcast=%RTbool\n", this, "NATEngine::setForwardBroadcast", aForwardBroadcast));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_FORWARDBROADCAST_ENTER(this, aForwardBroadcast != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setForwardBroadcast(aForwardBroadcast != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_FORWARDBROADCAST_RETURN(this, hrc, 0 /*normal*/,aForwardBroadcast != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_FORWARDBROADCAST_RETURN(this, hrc, 1 /*hrc exception*/,aForwardBroadcast != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_FORWARDBROADCAST_RETURN(this, hrc, 9 /*unhandled exception*/,aForwardBroadcast != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setForwardBroadcast", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(EnableTFTP)(BOOL *aEnableTFTP)
{
    LogRelFlow(("{%p} %s: enter aEnableTFTP=%p\n", this, "NATEngine::getEnableTFTP", aEnableTFTP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEnableTFTP);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ENABLETFTP_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEnableTFTP(aEnableTFTP);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ENABLETFTP_RETURN(this, hrc, 0 /*normal*/,*aEnableTFTP != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ENABLETFTP_RETURN(this, hrc, 1 /*hrc exception*/,*aEnableTFTP != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_ENABLETFTP_RETURN(this, hrc, 9 /*unhandled exception*/,*aEnableTFTP != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEnableTFTP=%RTbool hrc=%Rhrc\n", this, "NATEngine::getEnableTFTP", *aEnableTFTP, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(EnableTFTP)(BOOL aEnableTFTP)
{
    LogRelFlow(("{%p} %s: enter aEnableTFTP=%RTbool\n", this, "NATEngine::setEnableTFTP", aEnableTFTP));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ENABLETFTP_ENTER(this, aEnableTFTP != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setEnableTFTP(aEnableTFTP != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ENABLETFTP_RETURN(this, hrc, 0 /*normal*/,aEnableTFTP != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ENABLETFTP_RETURN(this, hrc, 1 /*hrc exception*/,aEnableTFTP != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_ENABLETFTP_RETURN(this, hrc, 9 /*unhandled exception*/,aEnableTFTP != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setEnableTFTP", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(NatMRU)(ULONG *aNatMRU)
{
    LogRelFlow(("{%p} %s: enter aNatMRU=%p\n", this, "NATEngine::getNatMRU", aNatMRU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNatMRU);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NATMRU_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNatMRU(aNatMRU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NATMRU_RETURN(this, hrc, 0 /*normal*/,*aNatMRU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NATMRU_RETURN(this, hrc, 1 /*hrc exception*/,*aNatMRU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_NATMRU_RETURN(this, hrc, 9 /*unhandled exception*/,*aNatMRU);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNatMRU=%RU32 hrc=%Rhrc\n", this, "NATEngine::getNatMRU", *aNatMRU, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(NatMRU)(ULONG aNatMRU)
{
    LogRelFlow(("{%p} %s: enter aNatMRU=%RU32\n", this, "NATEngine::setNatMRU", aNatMRU));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NATMRU_ENTER(this, aNatMRU);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNatMRU(aNatMRU);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NATMRU_RETURN(this, hrc, 0 /*normal*/,aNatMRU);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NATMRU_RETURN(this, hrc, 1 /*hrc exception*/,aNatMRU);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_NATMRU_RETURN(this, hrc, 9 /*unhandled exception*/,aNatMRU);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setNatMRU", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(IPv6Enabled)(BOOL *aIPv6Enabled)
{
    LogRelFlow(("{%p} %s: enter aIPv6Enabled=%p\n", this, "NATEngine::getIPv6Enabled", aIPv6Enabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPv6Enabled);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6ENABLED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPv6Enabled(aIPv6Enabled);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6ENABLED_RETURN(this, hrc, 0 /*normal*/,*aIPv6Enabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,*aIPv6Enabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,*aIPv6Enabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPv6Enabled=%RTbool hrc=%Rhrc\n", this, "NATEngine::getIPv6Enabled", *aIPv6Enabled, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(IPv6Enabled)(BOOL aIPv6Enabled)
{
    LogRelFlow(("{%p} %s: enter aIPv6Enabled=%RTbool\n", this, "NATEngine::setIPv6Enabled", aIPv6Enabled));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6ENABLED_ENTER(this, aIPv6Enabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIPv6Enabled(aIPv6Enabled != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6ENABLED_RETURN(this, hrc, 0 /*normal*/,aIPv6Enabled != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6ENABLED_RETURN(this, hrc, 1 /*hrc exception*/,aIPv6Enabled != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6ENABLED_RETURN(this, hrc, 9 /*unhandled exception*/,aIPv6Enabled != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setIPv6Enabled", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(IPv6Prefix)(BSTR *aIPv6Prefix)
{
    LogRelFlow(("{%p} %s: enter aIPv6Prefix=%p\n", this, "NATEngine::getIPv6Prefix", aIPv6Prefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIPv6Prefix);
        BSTROutConverter TmpIPv6Prefix(aIPv6Prefix);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6PREFIX_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIPv6Prefix(TmpIPv6Prefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6PREFIX_RETURN(this, hrc, 0 /*normal*/,TmpIPv6Prefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6PREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GET_IPV6PREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIPv6Prefix=%ls hrc=%Rhrc\n", this, "NATEngine::getIPv6Prefix", *aIPv6Prefix, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMSETTER(IPv6Prefix)(IN_BSTR aIPv6Prefix)
{
    LogRelFlow(("{%p} %s: enter aIPv6Prefix=%ls\n", this, "NATEngine::setIPv6Prefix", aIPv6Prefix));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpIPv6Prefix(aIPv6Prefix);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6PREFIX_ENTER(this, TmpIPv6Prefix.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setIPv6Prefix(TmpIPv6Prefix.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6PREFIX_RETURN(this, hrc, 0 /*normal*/,TmpIPv6Prefix.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6PREFIX_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SET_IPV6PREFIX_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setIPv6Prefix", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute1INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute2INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute3INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute4INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute5INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::COMGETTER(InternalAndReservedAttribute6INATEngine)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// INATEngine methods
//

STDMETHODIMP NATEngineWrap::SetNetworkSettings(ULONG aMtu,
                                               ULONG aSockSnd,
                                               ULONG aSockRcv,
                                               ULONG aTcpWndSnd,
                                               ULONG aTcpWndRcv)
{
    LogRelFlow(("{%p} %s: enter aMtu=%RU32 aSockSnd=%RU32 aSockRcv=%RU32 aTcpWndSnd=%RU32 aTcpWndRcv=%RU32\n", this, "NATEngine::setNetworkSettings", aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SETNETWORKSETTINGS_ENTER(this, aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setNetworkSettings(aMtu,
                                     aSockSnd,
                                     aSockRcv,
                                     aTcpWndSnd,
                                     aTcpWndRcv);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SETNETWORKSETTINGS_RETURN(this, hrc, 0 /*normal*/, aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SETNETWORKSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_SETNETWORKSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::setNetworkSettings", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::GetNetworkSettings(ULONG *aMtu,
                                               ULONG *aSockSnd,
                                               ULONG *aSockRcv,
                                               ULONG *aTcpWndSnd,
                                               ULONG *aTcpWndRcv)
{
    LogRelFlow(("{%p} %s: enter aMtu=%p aSockSnd=%p aSockRcv=%p aTcpWndSnd=%p aTcpWndRcv=%p\n", this, "NATEngine::getNetworkSettings", aMtu, aSockSnd, aSockRcv, aTcpWndSnd, aTcpWndRcv));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMtu);
        CheckComArgOutPointerValidThrow(aSockSnd);
        CheckComArgOutPointerValidThrow(aSockRcv);
        CheckComArgOutPointerValidThrow(aTcpWndSnd);
        CheckComArgOutPointerValidThrow(aTcpWndRcv);


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GETNETWORKSETTINGS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNetworkSettings(aMtu,
                                     aSockSnd,
                                     aSockRcv,
                                     aTcpWndSnd,
                                     aTcpWndRcv);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GETNETWORKSETTINGS_RETURN(this, hrc, 0 /*normal*/, *aMtu, *aSockSnd, *aSockRcv, *aTcpWndSnd, *aTcpWndRcv);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GETNETWORKSETTINGS_RETURN(this, hrc, 1 /*hrc exception*/, *aMtu, *aSockSnd, *aSockRcv, *aTcpWndSnd, *aTcpWndRcv);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_GETNETWORKSETTINGS_RETURN(this, hrc, 9 /*unhandled exception*/, *aMtu, *aSockSnd, *aSockRcv, *aTcpWndSnd, *aTcpWndRcv);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMtu=%RU32 *aSockSnd=%RU32 *aSockRcv=%RU32 *aTcpWndSnd=%RU32 *aTcpWndRcv=%RU32 hrc=%Rhrc\n", this, "NATEngine::getNetworkSettings", *aMtu, *aSockSnd, *aSockRcv, *aTcpWndSnd, *aTcpWndRcv, hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::AddRedirect(IN_BSTR aName,
                                        NATProtocol_T aProto,
                                        IN_BSTR aHostIP,
                                        USHORT aHostPort,
                                        IN_BSTR aGuestIP,
                                        USHORT aGuestPort)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aProto=%RU32 aHostIP=%ls aHostPort=%RU16 aGuestIP=%ls aGuestPort=%RU16\n", this, "NATEngine::addRedirect", aName, aProto, aHostIP, aHostPort, aGuestIP, aGuestPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        BSTRInConverter TmpHostIP(aHostIP);
        
        BSTRInConverter TmpGuestIP(aGuestIP);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_ADDREDIRECT_ENTER(this, TmpName.str().c_str(), aProto, TmpHostIP.str().c_str(), aHostPort, TmpGuestIP.str().c_str(), aGuestPort);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = addRedirect(TmpName.str(),
                              aProto,
                              TmpHostIP.str(),
                              aHostPort,
                              TmpGuestIP.str(),
                              aGuestPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_ADDREDIRECT_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aProto, TmpHostIP.str().c_str(), aHostPort, TmpGuestIP.str().c_str(), aGuestPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_ADDREDIRECT_RETURN(this, hrc, 1 /*hrc exception*/, 0, aProto, 0, aHostPort, 0, aGuestPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_ADDREDIRECT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aProto, 0, aHostPort, 0, aGuestPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::addRedirect", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::RemoveRedirect(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "NATEngine::removeRedirect", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_REMOVEREDIRECT_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = removeRedirect(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_REMOVEREDIRECT_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_REMOVEREDIRECT_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_NATENGINE_REMOVEREDIRECT_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "NATEngine::removeRedirect", hrc));
    return hrc;
}

STDMETHODIMP NATEngineWrap::InternalAndReservedMethod1INATEngine()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::InternalAndReservedMethod2INATEngine()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::InternalAndReservedMethod3INATEngine()
{
    return E_NOTIMPL;
}

STDMETHODIMP NATEngineWrap::InternalAndReservedMethod4INATEngine()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(NATEngineWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(NATEngineWrap, INATEngine)
#endif // VBOX_WITH_XPCOM
