/** @file
 * VirtualBox API class wrapper code for IBandwidthControl.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_BANDWIDTHCONTROL

#include "BandwidthControlWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(BandwidthControlWrap)

//
// IBandwidthControl properties
//

STDMETHODIMP BandwidthControlWrap::COMGETTER(NumGroups)(ULONG *aNumGroups)
{
    LogRelFlow(("{%p} %s: enter aNumGroups=%p\n", this, "BandwidthControl::getNumGroups", aNumGroups));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNumGroups);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GET_NUMGROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getNumGroups(aNumGroups);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GET_NUMGROUPS_RETURN(this, hrc, 0 /*normal*/,*aNumGroups);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GET_NUMGROUPS_RETURN(this, hrc, 1 /*hrc exception*/,*aNumGroups);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GET_NUMGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/,*aNumGroups);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aNumGroups=%RU32 hrc=%Rhrc\n", this, "BandwidthControl::getNumGroups", *aNumGroups, hrc));
    return hrc;
}

STDMETHODIMP BandwidthControlWrap::COMGETTER(InternalAndReservedAttribute1IBandwidthControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP BandwidthControlWrap::COMGETTER(InternalAndReservedAttribute2IBandwidthControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IBandwidthControl methods
//

STDMETHODIMP BandwidthControlWrap::CreateBandwidthGroup(IN_BSTR aName,
                                                        BandwidthGroupType_T aType,
                                                        LONG64 aMaxBytesPerSec)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aType=%RU32 aMaxBytesPerSec=%RI64\n", this, "BandwidthControl::createBandwidthGroup", aName, aType, aMaxBytesPerSec));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_CREATEBANDWIDTHGROUP_ENTER(this, TmpName.str().c_str(), aType, aMaxBytesPerSec);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = createBandwidthGroup(TmpName.str(),
                                       aType,
                                       aMaxBytesPerSec);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_CREATEBANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), aType, aMaxBytesPerSec);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_CREATEBANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/, 0, aType, aMaxBytesPerSec);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_CREATEBANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aType, aMaxBytesPerSec);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BandwidthControl::createBandwidthGroup", hrc));
    return hrc;
}

STDMETHODIMP BandwidthControlWrap::DeleteBandwidthGroup(IN_BSTR aName)
{
    LogRelFlow(("{%p} %s: enter aName=%ls\n", this, "BandwidthControl::deleteBandwidthGroup", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpName(aName);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_DELETEBANDWIDTHGROUP_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = deleteBandwidthGroup(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_DELETEBANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_DELETEBANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_DELETEBANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "BandwidthControl::deleteBandwidthGroup", hrc));
    return hrc;
}

STDMETHODIMP BandwidthControlWrap::GetBandwidthGroup(IN_BSTR aName,
                                                     IBandwidthGroup **aBandwidthGroup)
{
    LogRelFlow(("{%p} %s: enter aName=%ls aBandwidthGroup=%p\n", this, "BandwidthControl::getBandwidthGroup", aName, aBandwidthGroup));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBandwidthGroup);


        BSTRInConverter TmpName(aName);
        ComTypeOutConverter<IBandwidthGroup> TmpBandwidthGroup(aBandwidthGroup);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETBANDWIDTHGROUP_ENTER(this, TmpName.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getBandwidthGroup(TmpName.str(),
                                    TmpBandwidthGroup.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETBANDWIDTHGROUP_RETURN(this, hrc, 0 /*normal*/, TmpName.str().c_str(), (void *)TmpBandwidthGroup.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETBANDWIDTHGROUP_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETBANDWIDTHGROUP_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aBandwidthGroup=%p hrc=%Rhrc\n", this, "BandwidthControl::getBandwidthGroup", *aBandwidthGroup, hrc));
    return hrc;
}

STDMETHODIMP BandwidthControlWrap::GetAllBandwidthGroups(ComSafeArrayOut(IBandwidthGroup *, aBandwidthGroups))
{
    LogRelFlow(("{%p} %s: enter aBandwidthGroups=%p\n", this, "BandwidthControl::getAllBandwidthGroups", aBandwidthGroups));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aBandwidthGroups);


        ArrayComTypeOutConverter<IBandwidthGroup> TmpBandwidthGroups(ComSafeArrayOutArg(aBandwidthGroups));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETALLBANDWIDTHGROUPS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAllBandwidthGroups(TmpBandwidthGroups.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETALLBANDWIDTHGROUPS_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpBandwidthGroups.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETALLBANDWIDTHGROUPS_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_BANDWIDTHCONTROL_GETALLBANDWIDTHGROUPS_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aBandwidthGroups=%zu hrc=%Rhrc\n", this, "BandwidthControl::getAllBandwidthGroups", ComSafeArraySize(*aBandwidthGroups), hrc));
    return hrc;
}

STDMETHODIMP BandwidthControlWrap::InternalAndReservedMethod1IBandwidthControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP BandwidthControlWrap::InternalAndReservedMethod2IBandwidthControl()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(BandwidthControlWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(BandwidthControlWrap, IBandwidthControl)
#endif // VBOX_WITH_XPCOM
