// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudIamSearchPrincipalsFilter SearchPrincipalsFilter contains optional filter fields when making a SearchPrincipalsRequest.
//
// swagger:model hashicorp.cloud.iam.SearchPrincipalsFilter
type HashicorpCloudIamSearchPrincipalsFilter struct {

	// exclude_members_of_group_names is an optional list of group resource names.
	// If a principal is a member of any of the groups specified, the principal will be excluded
	// from the search results.
	ExcludeMembersOfGroupNames []string `json:"exclude_members_of_group_names"`

	// principal_type_filter is an optional list of principal types. When specified,
	// the search results will only contain principals whose type is included in the
	// filter.
	PrincipalTypes []*HashicorpCloudIamPrincipalType `json:"principal_types"`

	// search_text is the search text which cause the results will be filtered to
	// principals whose name/email contains the text.
	SearchText string `json:"search_text,omitempty"`
}

// Validate validates this hashicorp cloud iam search principals filter
func (m *HashicorpCloudIamSearchPrincipalsFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePrincipalTypes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamSearchPrincipalsFilter) validatePrincipalTypes(formats strfmt.Registry) error {
	if swag.IsZero(m.PrincipalTypes) { // not required
		return nil
	}

	for i := 0; i < len(m.PrincipalTypes); i++ {
		if swag.IsZero(m.PrincipalTypes[i]) { // not required
			continue
		}

		if m.PrincipalTypes[i] != nil {
			if err := m.PrincipalTypes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("principal_types" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("principal_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud iam search principals filter based on the context it is used
func (m *HashicorpCloudIamSearchPrincipalsFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePrincipalTypes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudIamSearchPrincipalsFilter) contextValidatePrincipalTypes(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PrincipalTypes); i++ {

		if m.PrincipalTypes[i] != nil {

			if swag.IsZero(m.PrincipalTypes[i]) { // not required
				return nil
			}

			if err := m.PrincipalTypes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("principal_types" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("principal_types" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudIamSearchPrincipalsFilter) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudIamSearchPrincipalsFilter) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudIamSearchPrincipalsFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
