package kms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolicy invokes the kms.DescribePolicy API synchronously
func (client *Client) DescribePolicy(request *DescribePolicyRequest) (response *DescribePolicyResponse, err error) {
	response = CreateDescribePolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolicyWithChan invokes the kms.DescribePolicy API asynchronously
func (client *Client) DescribePolicyWithChan(request *DescribePolicyRequest) (<-chan *DescribePolicyResponse, <-chan error) {
	responseChan := make(chan *DescribePolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolicyWithCallback invokes the kms.DescribePolicy API asynchronously
func (client *Client) DescribePolicyWithCallback(request *DescribePolicyRequest, callback func(response *DescribePolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribePolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolicyRequest is the request struct for api DescribePolicy
type DescribePolicyRequest struct {
	*requests.RpcRequest
	Name string `position:"Query" name:"Name"`
}

// DescribePolicyResponse is the response struct for api DescribePolicy
type DescribePolicyResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	Arn                string   `json:"Arn" xml:"Arn"`
	Name               string   `json:"Name" xml:"Name"`
	Description        string   `json:"Description" xml:"Description"`
	KmsInstance        string   `json:"KmsInstance" xml:"KmsInstance"`
	AccessControlRules string   `json:"AccessControlRules" xml:"AccessControlRules"`
	Permissions        []string `json:"Permissions" xml:"Permissions"`
	Resources          []string `json:"Resources" xml:"Resources"`
}

// CreateDescribePolicyRequest creates a request to invoke DescribePolicy API
func CreateDescribePolicyRequest() (request *DescribePolicyRequest) {
	request = &DescribePolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Kms", "2016-01-20", "DescribePolicy", "kms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePolicyResponse creates a response to parse from DescribePolicy response
func CreateDescribePolicyResponse() (response *DescribePolicyResponse) {
	response = &DescribePolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
