/* Request.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Request.vala, do not modify */

#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_REQUEST (tuba_request_get_type ())
#define TUBA_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_REQUEST, TubaRequest))
#define TUBA_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_REQUEST, TubaRequestClass))
#define TUBA_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_REQUEST))
#define TUBA_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_REQUEST))
#define TUBA_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_REQUEST, TubaRequestClass))

typedef struct _TubaRequest TubaRequest;
typedef struct _TubaRequestClass TubaRequestClass;
typedef struct _TubaRequestPrivate TubaRequestPrivate;

#define TUBA_TYPE_ENTITY (tuba_entity_get_type ())
#define TUBA_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ENTITY, TubaEntity))
#define TUBA_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ENTITY, TubaEntityClass))
#define TUBA_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ENTITY))
#define TUBA_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ENTITY))
#define TUBA_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ENTITY, TubaEntityClass))

typedef struct _TubaEntity TubaEntity;
typedef struct _TubaEntityClass TubaEntityClass;

#define TUBA_API_TYPE_ACCOUNT (tuba_api_account_get_type ())
#define TUBA_API_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccount))
#define TUBA_API_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))
#define TUBA_API_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))

typedef struct _TubaAPIAccount TubaAPIAccount;
typedef struct _TubaAPIAccountClass TubaAPIAccountClass;

#define TUBA_TYPE_INSTANCE_ACCOUNT (tuba_instance_account_get_type ())
#define TUBA_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccount))
#define TUBA_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))
#define TUBA_IS_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_IS_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_INSTANCE_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))

typedef struct _TubaInstanceAccount TubaInstanceAccount;
typedef struct _TubaInstanceAccountClass TubaInstanceAccountClass;
typedef void (*TubaNetworkSuccessCallback) (GInputStream* in_stream, SoupMessageHeaders* response_headers, gpointer user_data, GError** error);
typedef void (*TubaNetworkErrorCallback) (gint32 code, const gchar* reason, gpointer user_data);
typedef enum  {
	TUBA_NETWORK_EXTRA_DATA_RESPONSE_HEADERS
} TubaNetworkExtraData;

#define TUBA_NETWORK_TYPE_EXTRA_DATA (tuba_network_extra_data_get_type ())
enum  {
	TUBA_REQUEST_0_PROPERTY,
	TUBA_REQUEST_MSG_PROPERTY,
	TUBA_REQUEST_URL_PROPERTY,
	TUBA_REQUEST_PRIORITY_PROPERTY,
	TUBA_REQUEST_METHOD_PROPERTY,
	TUBA_REQUEST_RESPONSE_BODY_PROPERTY,
	TUBA_REQUEST_ACCOUNT_PROPERTY,
	TUBA_REQUEST_NUM_PROPERTIES
};
static GParamSpec* tuba_request_properties[TUBA_REQUEST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_SoupMultipart_free0(var) ((var == NULL) ? NULL : (var = (_vala_SoupMultipart_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef void (*TubaNetworkNodeCallback) (JsonNode* node, gpointer user_data, GError** error);
typedef struct _Block62Data Block62Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
typedef struct _Block63Data Block63Data;
typedef struct _Block64Data Block64Data;
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;
typedef struct _Block65Data Block65Data;

#define TUBA_TYPE_OOPSIE (tuba_oopsie_get_type ())
typedef struct _TubaRequestAwaitData TubaRequestAwaitData;
typedef struct _Block66Data Block66Data;

struct _TubaRequest {
	GObject parent_instance;
	TubaRequestPrivate * priv;
	GCancellable* cancellable;
};

struct _TubaRequestClass {
	GObjectClass parent_class;
};

struct _TubaRequestPrivate {
	SoupMessage* _msg;
	gchar* _url;
	SoupMessagePriority _priority;
	gchar* _method;
	GInputStream* _response_body;
	TubaInstanceAccount* _account;
	TubaNetworkSuccessCallback cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	TubaNetworkErrorCallback error_cb;
	gpointer error_cb_target;
	GDestroyNotify error_cb_target_destroy_notify;
	GeeHashMap* pars;
	SoupMultipart* form_data;
	TubaNetworkExtraData* extra_data;
	GtkWidget* ctx;
	gboolean has_ctx;
	gchar* content_type;
	GBytes* body_bytes;
	gchar* force_token;
	gboolean cache;
};

struct _Block62Data {
	int _ref_count_;
	TubaRequest* self;
	TubaNetworkNodeCallback _cb;
	gpointer _cb_target;
	GDestroyNotify _cb_target_destroy_notify;
};

struct _Block63Data {
	int _ref_count_;
	TubaRequest* self;
	gchar* parameters;
};

struct _Block64Data {
	int _ref_count_;
	Block63Data * _data63_;
	gint parameters_counter;
};

struct _Block65Data {
	int _ref_count_;
	TubaRequest* self;
	gchar* _error_;
	gpointer _async_data_;
};

typedef enum  {
	TUBA_OOPSIE_USER,
	TUBA_OOPSIE_PARSING,
	TUBA_OOPSIE_INSTANCE,
	TUBA_OOPSIE_INTERNAL
} TubaOopsie;
#define TUBA_OOPSIE tuba_oopsie_quark ()

struct _TubaRequestAwaitData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	TubaRequest* self;
	TubaRequest* result;
	Block65Data* _data65_;
	TubaRequest* _tmp0_;
	TubaRequest* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GError* _tmp4_;
	TubaRequest* _tmp5_;
	GError* _inner_error0_;
};

struct _Block66Data {
	int _ref_count_;
	gchar* _result_;
	GeeArrayList* array;
	gchar* key;
};

static gint TubaRequest_private_offset;
static gpointer tuba_request_parent_class = NULL;
VALA_EXTERN TubaNetwork* tuba_network;

VALA_EXTERN GType tuba_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaRequest, g_object_unref)
VALA_EXTERN GType tuba_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaEntity, g_object_unref)
VALA_EXTERN GType tuba_api_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIAccount, g_object_unref)
VALA_EXTERN GType tuba_instance_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaInstanceAccount, g_object_unref)
VALA_EXTERN GType tuba_network_extra_data_get_type (void) G_GNUC_CONST ;
static void _vala_SoupMultipart_free (SoupMultipart* self);
VALA_EXTERN TubaRequest* tuba_request_new_GET (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_GET (GType object_type,
                                         const gchar* url);
VALA_EXTERN void tuba_request_set_url (TubaRequest* self,
                           const gchar* value);
VALA_EXTERN void tuba_request_set_method (TubaRequest* self,
                              const gchar* value);
VALA_EXTERN const gchar* tuba_request_get_method (TubaRequest* self);
VALA_EXTERN void tuba_request_set_msg (TubaRequest* self,
                           SoupMessage* value);
VALA_EXTERN TubaRequest* tuba_request_new_POST (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_POST (GType object_type,
                                          const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_new_PUT (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_PUT (GType object_type,
                                         const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_new_DELETE (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_DELETE (GType object_type,
                                            const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_new_PATCH (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_PATCH (GType object_type,
                                           const gchar* url);
VALA_EXTERN void tuba_request_set_request_body_from_bytes (TubaRequest* self,
                                               const gchar* t_content_type,
                                               GBytes* t_bytes);
VALA_EXTERN TubaRequest* tuba_request_then (TubaRequest* self,
                                TubaNetworkSuccessCallback cb,
                                gpointer cb_target,
                                GDestroyNotify cb_target_destroy_notify);
VALA_EXTERN TubaRequest* tuba_request_then_parse_array (TubaRequest* self,
                                            TubaNetworkNodeCallback _cb,
                                            gpointer _cb_target,
                                            GDestroyNotify _cb_target_destroy_notify);
static Block62Data* block62_data_ref (Block62Data* _data62_);
static void block62_data_unref (void * _userdata_);
static void __lambda8_ (Block62Data* _data62_,
                 GInputStream* in_stream,
                 GError** error);
VALA_EXTERN JsonParser* tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                                      GError** error);
VALA_EXTERN void tuba_network_parse_array (JsonParser* parser,
                               TubaNetworkNodeCallback cb,
                               gpointer cb_target,
                               GDestroyNotify cb_target_destroy_notify,
                               GError** error);
static void ___lambda8__tuba_network_success_callback (GInputStream* in_stream,
                                                SoupMessageHeaders* response_headers,
                                                gpointer self,
                                                GError** error);
VALA_EXTERN TubaRequest* tuba_request_with_extra_data (TubaRequest* self,
                                           TubaNetworkExtraData xtra_data);
static TubaNetworkExtraData* _tuba_network_extra_data_dup (TubaNetworkExtraData* self);
VALA_EXTERN TubaRequest* tuba_request_with_ctx (TubaRequest* self,
                                    GtkWidget* ctx);
static void tuba_request_on_ctx_destroy (TubaRequest* self);
static void _tuba_request_on_ctx_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                      gpointer self);
VALA_EXTERN TubaRequest* tuba_request_on_error (TubaRequest* self,
                                    TubaNetworkErrorCallback cb,
                                    gpointer cb_target,
                                    GDestroyNotify cb_target_destroy_notify);
VALA_EXTERN TubaRequest* tuba_request_with_account (TubaRequest* self,
                                        TubaInstanceAccount* account);
VALA_EXTERN void tuba_request_set_account (TubaRequest* self,
                               TubaInstanceAccount* value);
VALA_EXTERN TubaRequest* tuba_request_with_token (TubaRequest* self,
                                      const gchar* token);
VALA_EXTERN TubaRequest* tuba_request_with_param (TubaRequest* self,
                                      const gchar* name,
                                      const gchar* val);
VALA_EXTERN TubaRequest* tuba_request_with_form_data (TubaRequest* self,
                                          const gchar* name,
                                          const gchar* val);
VALA_EXTERN TubaRequest* tuba_request_with_form_data_file (TubaRequest* self,
                                               const gchar* name,
                                               const gchar* mime,
                                               GBytes* buffer);
VALA_EXTERN TubaRequest* tuba_request_body (TubaRequest* self,
                                const gchar* t_content_type,
                                GBytes* t_bytes);
VALA_EXTERN TubaRequest* tuba_request_body_json (TubaRequest* self,
                                     JsonBuilder* t_builder);
static void _vala_JsonNode_free (JsonNode* self);
static guint8* _vala_array_dup30 (guint8* self,
                           gssize length);
VALA_EXTERN TubaRequest* tuba_request_disable_cache (TubaRequest* self);
VALA_EXTERN TubaRequest* tuba_request_exec (TubaRequest* self);
static Block63Data* block63_data_ref (Block63Data* _data63_);
static void block63_data_unref (void * _userdata_);
static Block64Data* block64_data_ref (Block64Data* _data64_);
static void block64_data_unref (void * _userdata_);
VALA_EXTERN const gchar* tuba_request_get_url (TubaRequest* self);
static gboolean ___lambda14_ (Block64Data* _data64_,
                       GeeMapEntry* entry);
static gboolean ____lambda14__gee_forall_func (gpointer g,
                                        gpointer self);
VALA_EXTERN TubaInstanceAccount* tuba_request_get_account (TubaRequest* self);
VALA_EXTERN const gchar* tuba_instance_account_get_instance (TubaInstanceAccount* self);
VALA_EXTERN SoupMessage* tuba_request_get_msg (TubaRequest* self);
VALA_EXTERN const gchar* tuba_instance_account_get_access_token (TubaInstanceAccount* self);
VALA_EXTERN SoupMessagePriority tuba_request_get_priority (TubaRequest* self);
VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN void tuba_network_queue (TubaNetwork* self,
                         SoupMessage* msg,
                         GCancellable* cancellable,
                         TubaNetworkSuccessCallback cb,
                         gpointer cb_target,
                         GDestroyNotify cb_target_destroy_notify,
                         TubaNetworkErrorCallback ecb,
                         gpointer ecb_target,
                         GDestroyNotify ecb_target_destroy_notify,
                         TubaNetworkExtraData* extra_data);
static void tuba_request_await_data_free (gpointer _data);
VALA_EXTERN void tuba_request_await (TubaRequest* self,
                         GAsyncReadyCallback _callback_,
                         gpointer _user_data_);
VALA_EXTERN TubaRequest* tuba_request_await_finish (TubaRequest* self,
                                        GAsyncResult* _res_,
                                        GError** error);
static gboolean tuba_request_await_co (TubaRequestAwaitData* _data_);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void __lambda15_ (Block65Data* _data65_,
                  gint32 code,
                  const gchar* reason);
static void ___lambda15__tuba_network_error_callback (gint32 code,
                                               const gchar* reason,
                                               gpointer self);
static void __lambda16_ (Block65Data* _data65_,
                  GInputStream* in_stream,
                  GError** error);
VALA_EXTERN void tuba_request_set_response_body (TubaRequest* self,
                                     GInputStream* value);
static void ___lambda16__tuba_network_success_callback (GInputStream* in_stream,
                                                 SoupMessageHeaders* response_headers,
                                                 gpointer self,
                                                 GError** error);
VALA_EXTERN GQuark tuba_oopsie_quark (void);
VALA_EXTERN GType tuba_oopsie_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* tuba_request_array2string (GeeArrayList* array,
                                  const gchar* key);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static gboolean __lambda17_ (Block66Data* _data66_,
                      gchar* i);
static gboolean ___lambda17__gee_forall_func (gpointer g,
                                       gpointer self);
VALA_EXTERN TubaRequest* tuba_request_new (void);
VALA_EXTERN TubaRequest* tuba_request_construct (GType object_type);
VALA_EXTERN void tuba_request_set_priority (TubaRequest* self,
                                SoupMessagePriority value);
VALA_EXTERN GInputStream* tuba_request_get_response_body (TubaRequest* self);
static void tuba_request_finalize (GObject * obj);
static GType tuba_request_get_type_once (void);
static void _vala_tuba_request_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_tuba_request_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
tuba_request_get_instance_private (TubaRequest* self)
{
	return G_STRUCT_MEMBER_P (self, TubaRequest_private_offset);
}

static void
_vala_SoupMultipart_free (SoupMultipart* self)
{
	g_boxed_free (soup_multipart_get_type (), self);
}

TubaRequest*
tuba_request_construct_GET (GType object_type,
                            const gchar* url)
{
	TubaRequest * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaRequest*) g_object_new (object_type, NULL);
	tuba_request_set_url (self, url);
	tuba_request_set_method (self, "GET");
	_tmp0_ = tuba_request_get_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (_tmp1_, url);
	_tmp3_ = _tmp2_;
	tuba_request_set_msg (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

TubaRequest*
tuba_request_new_GET (const gchar* url)
{
	return tuba_request_construct_GET (TUBA_TYPE_REQUEST, url);
}

TubaRequest*
tuba_request_construct_POST (GType object_type,
                             const gchar* url)
{
	TubaRequest * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaRequest*) g_object_new (object_type, NULL);
	tuba_request_set_url (self, url);
	tuba_request_set_method (self, "POST");
	_tmp0_ = tuba_request_get_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (_tmp1_, url);
	_tmp3_ = _tmp2_;
	tuba_request_set_msg (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

TubaRequest*
tuba_request_new_POST (const gchar* url)
{
	return tuba_request_construct_POST (TUBA_TYPE_REQUEST, url);
}

TubaRequest*
tuba_request_construct_PUT (GType object_type,
                            const gchar* url)
{
	TubaRequest * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaRequest*) g_object_new (object_type, NULL);
	tuba_request_set_url (self, url);
	tuba_request_set_method (self, "PUT");
	_tmp0_ = tuba_request_get_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (_tmp1_, url);
	_tmp3_ = _tmp2_;
	tuba_request_set_msg (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

TubaRequest*
tuba_request_new_PUT (const gchar* url)
{
	return tuba_request_construct_PUT (TUBA_TYPE_REQUEST, url);
}

TubaRequest*
tuba_request_construct_DELETE (GType object_type,
                               const gchar* url)
{
	TubaRequest * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaRequest*) g_object_new (object_type, NULL);
	tuba_request_set_url (self, url);
	tuba_request_set_method (self, "DELETE");
	_tmp0_ = tuba_request_get_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (_tmp1_, url);
	_tmp3_ = _tmp2_;
	tuba_request_set_msg (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

TubaRequest*
tuba_request_new_DELETE (const gchar* url)
{
	return tuba_request_construct_DELETE (TUBA_TYPE_REQUEST, url);
}

TubaRequest*
tuba_request_construct_PATCH (GType object_type,
                              const gchar* url)
{
	TubaRequest * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessage* _tmp3_;
	g_return_val_if_fail (url != NULL, NULL);
	self = (TubaRequest*) g_object_new (object_type, NULL);
	tuba_request_set_url (self, url);
	tuba_request_set_method (self, "PATCH");
	_tmp0_ = tuba_request_get_method (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = soup_message_new (_tmp1_, url);
	_tmp3_ = _tmp2_;
	tuba_request_set_msg (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

TubaRequest*
tuba_request_new_PATCH (const gchar* url)
{
	return tuba_request_construct_PATCH (TUBA_TYPE_REQUEST, url);
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

void
tuba_request_set_request_body_from_bytes (TubaRequest* self,
                                          const gchar* t_content_type,
                                          GBytes* t_bytes)
{
	gchar* _tmp0_;
	GBytes* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (t_content_type);
	_g_free0 (self->priv->content_type);
	self->priv->content_type = _tmp0_;
	_tmp1_ = _g_bytes_ref0 (t_bytes);
	_g_bytes_unref0 (self->priv->body_bytes);
	self->priv->body_bytes = _tmp1_;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

TubaRequest*
tuba_request_then (TubaRequest* self,
                   TubaNetworkSuccessCallback cb,
                   gpointer cb_target,
                   GDestroyNotify cb_target_destroy_notify)
{
	TubaNetworkSuccessCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	TubaRequest* _tmp1_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	self->priv->cb = _tmp0_;
	self->priv->cb_target = _tmp0__target;
	self->priv->cb_target_destroy_notify = _tmp0__target_destroy_notify;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	return result;
}

static Block62Data*
block62_data_ref (Block62Data* _data62_)
{
	g_atomic_int_inc (&_data62_->_ref_count_);
	return _data62_;
}

static void
block62_data_unref (void * _userdata_)
{
	Block62Data* _data62_;
	_data62_ = (Block62Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data62_->_ref_count_)) {
		TubaRequest* self;
		self = _data62_->self;
		(_data62_->_cb_target_destroy_notify == NULL) ? NULL : (_data62_->_cb_target_destroy_notify (_data62_->_cb_target), NULL);
		_data62_->_cb = NULL;
		_data62_->_cb_target = NULL;
		_data62_->_cb_target_destroy_notify = NULL;
		_g_object_unref0 (self);
		g_slice_free (Block62Data, _data62_);
	}
}

static void
__lambda8_ (Block62Data* _data62_,
            GInputStream* in_stream,
            GError** error)
{
	TubaRequest* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	JsonParser* _tmp1_;
	TubaNetworkNodeCallback _tmp2_;
	gpointer _tmp2__target;
	GDestroyNotify _tmp2__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	self = _data62_->self;
	g_return_if_fail (in_stream != NULL);
	_tmp0_ = tuba_network_get_parser_from_inputstream (in_stream, &_inner_error0_);
	parser = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = parser;
	_tmp2_ = _data62_->_cb;
	_tmp2__target = _data62_->_cb_target;
	_tmp2__target_destroy_notify = _data62_->_cb_target_destroy_notify;
	_data62_->_cb = NULL;
	_data62_->_cb_target = NULL;
	_data62_->_cb_target_destroy_notify = NULL;
	tuba_network_parse_array (_tmp1_, _tmp2_, _tmp2__target, _tmp2__target_destroy_notify, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (parser);
		return;
	}
	_g_object_unref0 (parser);
}

static void
___lambda8__tuba_network_success_callback (GInputStream* in_stream,
                                           SoupMessageHeaders* response_headers,
                                           gpointer self,
                                           GError** error)
{
	__lambda8_ (self, in_stream, error);
}

TubaRequest*
tuba_request_then_parse_array (TubaRequest* self,
                               TubaNetworkNodeCallback _cb,
                               gpointer _cb_target,
                               GDestroyNotify _cb_target_destroy_notify)
{
	Block62Data* _data62_;
	TubaRequest* _tmp0_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data62_ = g_slice_new0 (Block62Data);
	_data62_->_ref_count_ = 1;
	_data62_->self = g_object_ref (self);
	(_data62_->_cb_target_destroy_notify == NULL) ? NULL : (_data62_->_cb_target_destroy_notify (_data62_->_cb_target), NULL);
	_data62_->_cb = NULL;
	_data62_->_cb_target = NULL;
	_data62_->_cb_target_destroy_notify = NULL;
	_data62_->_cb = _cb;
	_data62_->_cb_target = _cb_target;
	_data62_->_cb_target_destroy_notify = _cb_target_destroy_notify;
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	self->priv->cb = ___lambda8__tuba_network_success_callback;
	self->priv->cb_target = block62_data_ref (_data62_);
	self->priv->cb_target_destroy_notify = block62_data_unref;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	block62_data_unref (_data62_);
	_data62_ = NULL;
	return result;
}

static TubaNetworkExtraData*
_tuba_network_extra_data_dup (TubaNetworkExtraData* self)
{
	TubaNetworkExtraData* dup;
	dup = g_new0 (TubaNetworkExtraData, 1);
	memcpy (dup, self, sizeof (TubaNetworkExtraData));
	return dup;
}

static gpointer
__tuba_network_extra_data_dup0 (gpointer self)
{
	return self ? _tuba_network_extra_data_dup (self) : NULL;
}

TubaRequest*
tuba_request_with_extra_data (TubaRequest* self,
                              TubaNetworkExtraData xtra_data)
{
	TubaNetworkExtraData* _tmp0_;
	TubaRequest* _tmp1_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = __tuba_network_extra_data_dup0 (&xtra_data);
	_g_free0 (self->priv->extra_data);
	self->priv->extra_data = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

static void
_tuba_request_on_ctx_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                 gpointer self)
{
	tuba_request_on_ctx_destroy ((TubaRequest*) self);
}

TubaRequest*
tuba_request_with_ctx (TubaRequest* self,
                       GtkWidget* ctx)
{
	GtkWidget* _tmp0_;
	TubaRequest* _tmp1_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ctx != NULL, NULL);
	self->priv->has_ctx = TRUE;
	self->priv->ctx = ctx;
	_tmp0_ = self->priv->ctx;
	g_signal_connect_object (_tmp0_, "destroy", (GCallback) _tuba_request_on_ctx_destroy_gtk_widget_destroy, self, 0);
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

static void
tuba_request_on_ctx_destroy (TubaRequest* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cancellable;
	g_cancellable_cancel (_tmp0_);
	self->priv->ctx = NULL;
}

TubaRequest*
tuba_request_on_error (TubaRequest* self,
                       TubaNetworkErrorCallback cb,
                       gpointer cb_target,
                       GDestroyNotify cb_target_destroy_notify)
{
	TubaNetworkErrorCallback _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	TubaRequest* _tmp1_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp0__target_destroy_notify = cb_target_destroy_notify;
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	(self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (self->priv->error_cb_target_destroy_notify (self->priv->error_cb_target), NULL);
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	self->priv->error_cb = _tmp0_;
	self->priv->error_cb_target = _tmp0__target;
	self->priv->error_cb_target_destroy_notify = _tmp0__target_destroy_notify;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	return result;
}

TubaRequest*
tuba_request_with_account (TubaRequest* self,
                           TubaInstanceAccount* account)
{
	TubaRequest* _tmp0_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	tuba_request_set_account (self, account);
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

TubaRequest*
tuba_request_with_token (TubaRequest* self,
                         const gchar* token)
{
	gchar* _tmp0_;
	TubaRequest* _tmp1_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (token != NULL, NULL);
	_tmp0_ = g_strdup (token);
	_g_free0 (self->priv->force_token);
	self->priv->force_token = _tmp0_;
	_tmp1_ = _g_object_ref0 (self);
	result = _tmp1_;
	return result;
}

TubaRequest*
tuba_request_with_param (TubaRequest* self,
                         const gchar* name,
                         const gchar* val)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	TubaRequest* _tmp3_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = self->priv->pars;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->pars);
		self->priv->pars = _tmp1_;
	}
	_tmp2_ = self->priv->pars;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, name, val);
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}

TubaRequest*
tuba_request_with_form_data (TubaRequest* self,
                             const gchar* name,
                             const gchar* val)
{
	SoupMultipart* _tmp0_;
	SoupMultipart* _tmp2_;
	TubaRequest* _tmp3_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (val != NULL, NULL);
	_tmp0_ = self->priv->form_data;
	if (_tmp0_ == NULL) {
		SoupMultipart* _tmp1_;
		_tmp1_ = soup_multipart_new (SOUP_FORM_MIME_TYPE_MULTIPART);
		__vala_SoupMultipart_free0 (self->priv->form_data);
		self->priv->form_data = _tmp1_;
	}
	_tmp2_ = self->priv->form_data;
	soup_multipart_append_form_string (_tmp2_, name, val);
	_tmp3_ = _g_object_ref0 (self);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

TubaRequest*
tuba_request_with_form_data_file (TubaRequest* self,
                                  const gchar* name,
                                  const gchar* mime,
                                  GBytes* buffer)
{
	SoupMultipart* _tmp0_;
	SoupMultipart* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	TubaRequest* _tmp5_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (mime != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	_tmp0_ = self->priv->form_data;
	if (_tmp0_ == NULL) {
		SoupMultipart* _tmp1_;
		_tmp1_ = soup_multipart_new (SOUP_FORM_MIME_TYPE_MULTIPART);
		__vala_SoupMultipart_free0 (self->priv->form_data);
		self->priv->form_data = _tmp1_;
	}
	_tmp2_ = self->priv->form_data;
	_tmp3_ = string_replace (mime, "/", ".");
	_tmp4_ = _tmp3_;
	soup_multipart_append_form_file (_tmp2_, name, _tmp4_, mime, buffer);
	_g_free0 (_tmp4_);
	_tmp5_ = _g_object_ref0 (self);
	result = _tmp5_;
	return result;
}

TubaRequest*
tuba_request_body (TubaRequest* self,
                   const gchar* t_content_type,
                   GBytes* t_bytes)
{
	gchar* _tmp0_;
	GBytes* _tmp1_;
	TubaRequest* _tmp2_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (t_content_type);
	_g_free0 (self->priv->content_type);
	self->priv->content_type = _tmp0_;
	_tmp1_ = _g_bytes_ref0 (t_bytes);
	_g_bytes_unref0 (self->priv->body_bytes);
	self->priv->body_bytes = _tmp1_;
	_tmp2_ = _g_object_ref0 (self);
	result = _tmp2_;
	return result;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup30 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return g_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

TubaRequest*
tuba_request_body_json (TubaRequest* self,
                        JsonBuilder* t_builder)
{
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp0_;
	JsonNode* _tmp1_;
	JsonNode* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GBytes* _tmp9_;
	GBytes* _tmp10_;
	TubaRequest* _tmp11_;
	TubaRequest* _tmp12_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t_builder != NULL, NULL);
	_tmp0_ = json_generator_new ();
	generator = _tmp0_;
	_tmp1_ = json_builder_get_root (t_builder);
	_tmp2_ = _tmp1_;
	json_generator_set_root (generator, _tmp2_);
	__vala_JsonNode_free0 (_tmp2_);
	_tmp3_ = json_generator_to_data (generator, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_get_data (_tmp4_, &_tmp6_);
	_tmp5__length1 = _tmp6_;
	_tmp7_ = _tmp5_;
	_tmp7__length1 = _tmp5__length1;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup30 (_tmp7_, _tmp7__length1) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp9_ = g_bytes_new_take (_tmp8_, _tmp8__length1);
	_tmp10_ = _tmp9_;
	_tmp11_ = tuba_request_body (self, "application/json", _tmp10_);
	_tmp12_ = _tmp11_;
	_g_bytes_unref0 (_tmp10_);
	_g_free0 (_tmp4_);
	result = _tmp12_;
	_g_object_unref0 (generator);
	return result;
}

TubaRequest*
tuba_request_disable_cache (TubaRequest* self)
{
	TubaRequest* _tmp0_;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->cache = FALSE;
	_tmp0_ = _g_object_ref0 (self);
	result = _tmp0_;
	return result;
}

static Block63Data*
block63_data_ref (Block63Data* _data63_)
{
	g_atomic_int_inc (&_data63_->_ref_count_);
	return _data63_;
}

static void
block63_data_unref (void * _userdata_)
{
	Block63Data* _data63_;
	_data63_ = (Block63Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data63_->_ref_count_)) {
		TubaRequest* self;
		self = _data63_->self;
		_g_free0 (_data63_->parameters);
		_g_object_unref0 (self);
		g_slice_free (Block63Data, _data63_);
	}
}

static Block64Data*
block64_data_ref (Block64Data* _data64_)
{
	g_atomic_int_inc (&_data64_->_ref_count_);
	return _data64_;
}

static void
block64_data_unref (void * _userdata_)
{
	Block64Data* _data64_;
	_data64_ = (Block64Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data64_->_ref_count_)) {
		TubaRequest* self;
		self = _data64_->_data63_->self;
		block63_data_unref (_data64_->_data63_);
		_data64_->_data63_ = NULL;
		g_slice_free (Block64Data, _data64_);
	}
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
___lambda14_ (Block64Data* _data64_,
              GeeMapEntry* entry)
{
	Block63Data* _data63_;
	TubaRequest* self;
	gint _tmp0_;
	gchar* key = NULL;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gchar* _tmp3_;
	gchar* val = NULL;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GeeHashMap* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gboolean result;
	_data63_ = _data64_->_data63_;
	self = _data63_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = _data64_->parameters_counter;
	_data64_->parameters_counter = _tmp0_ + 1;
	_tmp1_ = gee_map_entry_get_key (entry);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup ((const gchar*) ((const gchar*) _tmp2_));
	key = _tmp3_;
	_tmp4_ = gee_map_entry_get_value (entry);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_uri_escape_string ((const gchar*) ((const gchar*) _tmp5_), NULL, TRUE);
	val = _tmp6_;
	_tmp7_ = _data63_->parameters;
	_tmp8_ = key;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = val;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat (_tmp9_, "=", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp7_, _tmp13_, NULL);
	_g_free0 (_data63_->parameters);
	_data63_->parameters = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = self->priv->pars;
	_tmp16_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp15_);
	_tmp17_ = _tmp16_;
	if (_data64_->parameters_counter < _tmp17_) {
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp18_ = _data63_->parameters;
		_tmp19_ = g_strconcat (_tmp18_, "&", NULL);
		_g_free0 (_data63_->parameters);
		_data63_->parameters = _tmp19_;
	}
	result = TRUE;
	_g_free0 (val);
	_g_free0 (key);
	_g_object_unref0 (entry);
	return result;
}

static gboolean
____lambda14__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = ___lambda14_ (self, (GeeMapEntry*) g);
	return result;
}

TubaRequest*
tuba_request_exec (TubaRequest* self)
{
	Block63Data* _data63_;
	gchar* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp6_;
	SoupMessage* _tmp13_;
	SoupMessage* _tmp14_;
	SoupMultipart* _tmp20_;
	const gchar* _tmp47_;
	SoupMessage* _tmp81_;
	SoupMessage* _tmp82_;
	SoupMessagePriority _tmp83_;
	gboolean _tmp84_ = FALSE;
	const gchar* _tmp85_;
	TubaNetwork* _tmp91_;
	SoupMessage* _tmp92_;
	SoupMessage* _tmp93_;
	SoupMessage* _tmp94_;
	GCancellable* _tmp95_;
	TubaNetworkSuccessCallback _tmp96_;
	gpointer _tmp96__target;
	GDestroyNotify _tmp96__target_destroy_notify;
	TubaNetworkErrorCallback _tmp97_;
	gpointer _tmp97__target;
	GDestroyNotify _tmp97__target_destroy_notify;
	TubaNetworkExtraData* _tmp98_;
	TubaRequest* _tmp99_;
	GError* _inner_error0_ = NULL;
	TubaRequest* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data63_ = g_slice_new0 (Block63Data);
	_data63_->_ref_count_ = 1;
	_data63_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("");
	_data63_->parameters = _tmp0_;
	_tmp1_ = self->priv->pars;
	if (_tmp1_ != NULL) {
		Block64Data* _data64_;
		const gchar* _tmp2_;
		GeeHashMap* _tmp5_;
		_data64_ = g_slice_new0 (Block64Data);
		_data64_->_ref_count_ = 1;
		_data64_->_data63_ = block63_data_ref (_data63_);
		_tmp2_ = self->priv->_url;
		if (string_contains (_tmp2_, "?")) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("&");
			_g_free0 (_data63_->parameters);
			_data63_->parameters = _tmp3_;
		} else {
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("?");
			_g_free0 (_data63_->parameters);
			_data63_->parameters = _tmp4_;
		}
		_data64_->parameters_counter = 0;
		_tmp5_ = self->priv->pars;
		gee_abstract_map_foreach ((GeeAbstractMap*) _tmp5_, ____lambda14__gee_forall_func, _data64_);
		block64_data_unref (_data64_);
		_data64_ = NULL;
	}
	_tmp6_ = self->priv->_url;
	if (!string_contains (_tmp6_, "://")) {
		TubaInstanceAccount* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = self->priv->_account;
		_tmp8_ = tuba_instance_account_get_instance (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = self->priv->_url;
		_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		tuba_request_set_url (self, _tmp12_);
		_g_free0 (_tmp12_);
	}
	_tmp13_ = tuba_request_get_msg (self);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		SoupMessage* _tmp18_;
		SoupMessage* _tmp19_;
		_tmp15_ = tuba_request_get_method (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->_url;
		_tmp18_ = soup_message_new (_tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		tuba_request_set_msg (self, _tmp19_);
		_g_object_unref0 (_tmp19_);
	}
	_tmp20_ = self->priv->form_data;
	if (_tmp20_ != NULL) {
		gchar* t_method = NULL;
		SoupMessage* _tmp21_;
		SoupMessage* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		SoupMultipart* _tmp27_;
		SoupMessage* _tmp28_;
		SoupMessage* _tmp29_;
		SoupMessage* _tmp30_;
		SoupMessage* _tmp31_;
		const gchar* _tmp32_;
		_tmp21_ = tuba_request_get_msg (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = soup_message_get_method (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup (_tmp24_);
		t_method = _tmp25_;
		_tmp26_ = self->priv->_url;
		_tmp27_ = self->priv->form_data;
		_tmp28_ = soup_message_new_from_multipart (_tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		tuba_request_set_msg (self, _tmp29_);
		_g_object_unref0 (_tmp29_);
		_tmp30_ = tuba_request_get_msg (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = t_method;
		soup_message_set_method (_tmp31_, _tmp32_);
		_g_free0 (t_method);
	} else {
		GUri* t_uri = NULL;
		SoupMessage* _tmp44_;
		SoupMessage* _tmp45_;
		GUri* _tmp46_;
		{
			GUri* _tmp33_ = NULL;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GUri* _tmp38_;
			GUri* _tmp39_;
			GUri* _tmp40_;
			_tmp34_ = self->priv->_url;
			_tmp35_ = _data63_->parameters;
			_tmp36_ = g_strconcat (_tmp34_, _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_uri_parse (_tmp37_, G_URI_FLAGS_ENCODED_PATH | G_URI_FLAGS_ENCODED_QUERY, &_inner_error0_);
			_tmp39_ = _tmp38_;
			_g_free0 (_tmp37_);
			_tmp33_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_URI_ERROR) {
					goto __catch0_g_uri_error;
				}
				_g_uri_unref0 (t_uri);
				block63_data_unref (_data63_);
				_data63_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp40_ = _tmp33_;
			_tmp33_ = NULL;
			_g_uri_unref0 (t_uri);
			t_uri = _tmp40_;
			_g_uri_unref0 (_tmp33_);
		}
		goto __finally0;
		__catch0_g_uri_error:
		{
			GError* e = NULL;
			GError* _tmp41_;
			const gchar* _tmp42_;
			TubaRequest* _tmp43_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp41_ = e;
			_tmp42_ = _tmp41_->message;
			g_warning ("Request.vala:206: %s", _tmp42_);
			_tmp43_ = _g_object_ref0 (self);
			result = _tmp43_;
			_g_error_free0 (e);
			_g_uri_unref0 (t_uri);
			block63_data_unref (_data63_);
			_data63_ = NULL;
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_uri_unref0 (t_uri);
			block63_data_unref (_data63_);
			_data63_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp44_ = tuba_request_get_msg (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = t_uri;
		soup_message_set_uri (_tmp45_, _tmp46_);
		_g_uri_unref0 (t_uri);
	}
	_tmp47_ = self->priv->force_token;
	if (_tmp47_ != NULL) {
		SoupMessage* _tmp48_;
		SoupMessage* _tmp49_;
		SoupMessageHeaders* _tmp50_;
		SoupMessageHeaders* _tmp51_;
		SoupMessage* _tmp52_;
		SoupMessage* _tmp53_;
		SoupMessageHeaders* _tmp54_;
		SoupMessageHeaders* _tmp55_;
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp48_ = tuba_request_get_msg (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = soup_message_get_request_headers (_tmp49_);
		_tmp51_ = _tmp50_;
		soup_message_headers_remove (_tmp51_, "Authorization");
		_tmp52_ = tuba_request_get_msg (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = soup_message_get_request_headers (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = self->priv->force_token;
		_tmp57_ = string_to_string (_tmp56_);
		_tmp58_ = g_strconcat ("Bearer ", _tmp57_, NULL);
		_tmp59_ = _tmp58_;
		soup_message_headers_append (_tmp55_, "Authorization", _tmp59_);
		_g_free0 (_tmp59_);
	} else {
		gboolean _tmp60_ = FALSE;
		TubaInstanceAccount* _tmp61_;
		_tmp61_ = self->priv->_account;
		if (_tmp61_ != NULL) {
			TubaInstanceAccount* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			_tmp62_ = self->priv->_account;
			_tmp63_ = tuba_instance_account_get_access_token (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp60_ = _tmp64_ != NULL;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			SoupMessage* _tmp65_;
			SoupMessage* _tmp66_;
			SoupMessageHeaders* _tmp67_;
			SoupMessageHeaders* _tmp68_;
			SoupMessage* _tmp69_;
			SoupMessage* _tmp70_;
			SoupMessageHeaders* _tmp71_;
			SoupMessageHeaders* _tmp72_;
			TubaInstanceAccount* _tmp73_;
			const gchar* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			gchar* _tmp77_;
			gchar* _tmp78_;
			_tmp65_ = tuba_request_get_msg (self);
			_tmp66_ = _tmp65_;
			_tmp67_ = soup_message_get_request_headers (_tmp66_);
			_tmp68_ = _tmp67_;
			soup_message_headers_remove (_tmp68_, "Authorization");
			_tmp69_ = tuba_request_get_msg (self);
			_tmp70_ = _tmp69_;
			_tmp71_ = soup_message_get_request_headers (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = self->priv->_account;
			_tmp74_ = tuba_instance_account_get_access_token (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = string_to_string (_tmp75_);
			_tmp77_ = g_strconcat ("Bearer ", _tmp76_, NULL);
			_tmp78_ = _tmp77_;
			soup_message_headers_append (_tmp72_, "Authorization", _tmp78_);
			_g_free0 (_tmp78_);
		}
	}
	if (!self->priv->cache) {
		SoupMessage* _tmp79_;
		SoupMessage* _tmp80_;
		_tmp79_ = tuba_request_get_msg (self);
		_tmp80_ = _tmp79_;
		soup_message_disable_feature (_tmp80_, soup_cache_get_type ());
	}
	_tmp81_ = tuba_request_get_msg (self);
	_tmp82_ = _tmp81_;
	_tmp83_ = self->priv->_priority;
	soup_message_set_priority (_tmp82_, _tmp83_);
	_tmp85_ = self->priv->content_type;
	if (_tmp85_ != NULL) {
		GBytes* _tmp86_;
		_tmp86_ = self->priv->body_bytes;
		_tmp84_ = _tmp86_ != NULL;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		SoupMessage* _tmp87_;
		SoupMessage* _tmp88_;
		const gchar* _tmp89_;
		GBytes* _tmp90_;
		_tmp87_ = tuba_request_get_msg (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = self->priv->content_type;
		_tmp90_ = self->priv->body_bytes;
		soup_message_set_request_body_from_bytes (_tmp88_, _tmp89_, _tmp90_);
	}
	_tmp91_ = tuba_network;
	_tmp92_ = tuba_request_get_msg (self);
	_tmp93_ = _tmp92_;
	_tmp94_ = _g_object_ref0 (_tmp93_);
	_tmp95_ = self->cancellable;
	_tmp96_ = self->priv->cb;
	_tmp96__target = self->priv->cb_target;
	_tmp96__target_destroy_notify = self->priv->cb_target_destroy_notify;
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	_tmp97_ = self->priv->error_cb;
	_tmp97__target = self->priv->error_cb_target;
	_tmp97__target_destroy_notify = self->priv->error_cb_target_destroy_notify;
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	_tmp98_ = self->priv->extra_data;
	tuba_network_queue (_tmp91_, _tmp94_, _tmp95_, _tmp96_, _tmp96__target, _tmp96__target_destroy_notify, _tmp97_, _tmp97__target, _tmp97__target_destroy_notify, _tmp98_);
	_tmp99_ = _g_object_ref0 (self);
	result = _tmp99_;
	block63_data_unref (_data63_);
	_data63_ = NULL;
	return result;
}

static void
tuba_request_await_data_free (gpointer _data)
{
	TubaRequestAwaitData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TubaRequestAwaitData, _data_);
}

void
tuba_request_await (TubaRequest* self,
                    GAsyncReadyCallback _callback_,
                    gpointer _user_data_)
{
	TubaRequestAwaitData* _data_;
	TubaRequest* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (TubaRequestAwaitData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, tuba_request_await_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tuba_request_await_co (_data_);
}

TubaRequest*
tuba_request_await_finish (TubaRequest* self,
                           GAsyncResult* _res_,
                           GError** error)
{
	TubaRequest* result;
	TubaRequestAwaitData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		TubaRequest* self;
		self = _data65_->self;
		_g_free0 (_data65_->_error_);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static void
__lambda15_ (Block65Data* _data65_,
             gint32 code,
             const gchar* reason)
{
	TubaRequest* self;
	gchar* _tmp0_;
	self = _data65_->self;
	g_return_if_fail (reason != NULL);
	_tmp0_ = g_strdup (reason);
	_g_free0 (_data65_->_error_);
	_data65_->_error_ = _tmp0_;
	tuba_request_await_co (_data65_->_async_data_);
}

static void
___lambda15__tuba_network_error_callback (gint32 code,
                                          const gchar* reason,
                                          gpointer self)
{
	__lambda15_ (self, code, reason);
}

static void
__lambda16_ (Block65Data* _data65_,
             GInputStream* in_stream,
             GError** error)
{
	TubaRequest* self;
	self = _data65_->self;
	g_return_if_fail (in_stream != NULL);
	tuba_request_set_response_body (self, in_stream);
	tuba_request_await_co (_data65_->_async_data_);
}

static void
___lambda16__tuba_network_success_callback (GInputStream* in_stream,
                                            SoupMessageHeaders* response_headers,
                                            gpointer self,
                                            GError** error)
{
	__lambda16_ (self, in_stream, error);
}

static gboolean
tuba_request_await_co (TubaRequestAwaitData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data65_ = g_slice_new0 (Block65Data);
	_data_->_data65_->_ref_count_ = 1;
	_data_->_data65_->self = g_object_ref (_data_->self);
	_data_->_data65_->_async_data_ = _data_;
	_data_->_data65_->_error_ = NULL;
	(_data_->self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->error_cb_target_destroy_notify (_data_->self->priv->error_cb_target), NULL);
	_data_->self->priv->error_cb = NULL;
	_data_->self->priv->error_cb_target = NULL;
	_data_->self->priv->error_cb_target_destroy_notify = NULL;
	_data_->self->priv->error_cb = ___lambda15__tuba_network_error_callback;
	_data_->self->priv->error_cb_target = block65_data_ref (_data_->_data65_);
	_data_->self->priv->error_cb_target_destroy_notify = block65_data_unref;
	(_data_->self->priv->cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->cb_target_destroy_notify (_data_->self->priv->cb_target), NULL);
	_data_->self->priv->cb = NULL;
	_data_->self->priv->cb_target = NULL;
	_data_->self->priv->cb_target_destroy_notify = NULL;
	_data_->self->priv->cb = ___lambda16__tuba_network_success_callback;
	_data_->self->priv->cb_target = block65_data_ref (_data_->_data65_);
	_data_->self->priv->cb_target_destroy_notify = block65_data_unref;
	_data_->_tmp0_ = tuba_request_exec (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_g_object_unref0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp2_ = _data_->_data65_->_error_;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->_data65_->_error_;
		_data_->_tmp4_ = g_error_new_literal (TUBA_OOPSIE, TUBA_OOPSIE_INSTANCE, _data_->_tmp3_);
		_data_->_inner_error0_ = _data_->_tmp4_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		block65_data_unref (_data_->_data65_);
		_data_->_data65_ = NULL;
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->_tmp5_ = _g_object_ref0 (_data_->self);
		_data_->result = _data_->_tmp5_;
		block65_data_unref (_data_->_data65_);
		_data_->_data65_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static Block66Data*
block66_data_ref (Block66Data* _data66_)
{
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}

static void
block66_data_unref (void * _userdata_)
{
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		_g_free0 (_data66_->_result_);
		_g_object_unref0 (_data66_->array);
		_g_free0 (_data66_->key);
		g_slice_free (Block66Data, _data66_);
	}
}

static gboolean
__lambda17_ (Block66Data* _data66_,
             gchar* i)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean result;
	g_return_val_if_fail (i != NULL, FALSE);
	_tmp0_ = string_to_string (_data66_->key);
	_tmp1_ = string_to_string (i);
	_tmp2_ = g_strconcat (_tmp0_, "[]=", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_data66_->_result_, _tmp3_, NULL);
	_g_free0 (_data66_->_result_);
	_data66_->_result_ = _tmp4_;
	_g_free0 (_tmp3_);
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _data66_->array);
	_tmp6_ = _tmp5_;
	if ((gee_abstract_list_index_of ((GeeAbstractList*) _data66_->array, i) + 1) != _tmp6_) {
		gchar* _tmp7_;
		_tmp7_ = g_strconcat (_data66_->_result_, "&", NULL);
		_g_free0 (_data66_->_result_);
		_data66_->_result_ = _tmp7_;
	}
	result = TRUE;
	_g_free0 (i);
	return result;
}

static gboolean
___lambda17__gee_forall_func (gpointer g,
                              gpointer self)
{
	gboolean result;
	result = __lambda17_ (self, (gchar*) g);
	return result;
}

gchar*
tuba_request_array2string (GeeArrayList* array,
                           const gchar* key)
{
	Block66Data* _data66_;
	GeeArrayList* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (array != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (array);
	_g_object_unref0 (_data66_->array);
	_data66_->array = _tmp0_;
	_tmp1_ = g_strdup (key);
	_g_free0 (_data66_->key);
	_data66_->key = _tmp1_;
	_tmp2_ = g_strdup ("");
	_data66_->_result_ = _tmp2_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _data66_->array, ___lambda17__gee_forall_func, _data66_);
	_tmp3_ = g_strdup (_data66_->_result_);
	result = _tmp3_;
	block66_data_unref (_data66_);
	_data66_ = NULL;
	return result;
}

TubaRequest*
tuba_request_construct (GType object_type)
{
	TubaRequest * self = NULL;
	self = (TubaRequest*) g_object_new (object_type, NULL);
	return self;
}

TubaRequest*
tuba_request_new (void)
{
	return tuba_request_construct (TUBA_TYPE_REQUEST);
}

SoupMessage*
tuba_request_get_msg (TubaRequest* self)
{
	SoupMessage* result;
	SoupMessage* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_msg;
	result = _tmp0_;
	return result;
}

void
tuba_request_set_msg (TubaRequest* self,
                      SoupMessage* value)
{
	gboolean _tmp0_ = FALSE;
	GCancellable* _tmp1_;
	SoupMessage* _tmp4_;
	GCancellable* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->cancellable;
	if (_tmp1_ != NULL) {
		GCancellable* _tmp2_;
		_tmp2_ = self->cancellable;
		_tmp0_ = !g_cancellable_is_cancelled (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GCancellable* _tmp3_;
		_tmp3_ = self->cancellable;
		g_cancellable_cancel (_tmp3_);
	}
	_tmp4_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_msg);
	self->priv->_msg = _tmp4_;
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->cancellable);
	self->cancellable = _tmp5_;
	g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_MSG_PROPERTY]);
}

const gchar*
tuba_request_get_url (TubaRequest* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_url;
	result = _tmp0_;
	return result;
}

void
tuba_request_set_url (TubaRequest* self,
                      const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_request_get_url (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_url);
		self->priv->_url = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_URL_PROPERTY]);
	}
}

SoupMessagePriority
tuba_request_get_priority (TubaRequest* self)
{
	SoupMessagePriority result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_priority;
	return result;
}

void
tuba_request_set_priority (TubaRequest* self,
                           SoupMessagePriority value)
{
	SoupMessagePriority old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_request_get_priority (self);
	if (old_value != value) {
		self->priv->_priority = value;
		g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_PRIORITY_PROPERTY]);
	}
}

const gchar*
tuba_request_get_method (TubaRequest* self)
{
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = tuba_request_get_msg (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->_method;
		_tmp0_ = _tmp3_;
	} else {
		SoupMessage* _tmp4_;
		SoupMessage* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = tuba_request_get_msg (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = soup_message_get_method (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

void
tuba_request_set_method (TubaRequest* self,
                         const gchar* value)
{
	gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_method);
	self->priv->_method = _tmp0_;
	_tmp1_ = tuba_request_get_msg (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		SoupMessage* _tmp3_;
		SoupMessage* _tmp4_;
		_tmp3_ = tuba_request_get_msg (self);
		_tmp4_ = _tmp3_;
		soup_message_set_method (_tmp4_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_METHOD_PROPERTY]);
}

GInputStream*
tuba_request_get_response_body (TubaRequest* self)
{
	GInputStream* result;
	GInputStream* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_response_body;
	result = _tmp0_;
	return result;
}

void
tuba_request_set_response_body (TubaRequest* self,
                                GInputStream* value)
{
	GInputStream* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_request_get_response_body (self);
	if (old_value != value) {
		GInputStream* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_response_body);
		self->priv->_response_body = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_RESPONSE_BODY_PROPERTY]);
	}
}

TubaInstanceAccount*
tuba_request_get_account (TubaRequest* self)
{
	TubaInstanceAccount* result;
	TubaInstanceAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}

void
tuba_request_set_account (TubaRequest* self,
                          TubaInstanceAccount* value)
{
	TubaInstanceAccount* old_value;
	g_return_if_fail (self != NULL);
	old_value = tuba_request_get_account (self);
	if (old_value != value) {
		TubaInstanceAccount* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_account);
		self->priv->_account = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tuba_request_properties[TUBA_REQUEST_ACCOUNT_PROPERTY]);
	}
}

static void
tuba_request_class_init (TubaRequestClass * klass,
                         gpointer klass_data)
{
	tuba_request_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaRequest_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_request_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_request_set_property;
	G_OBJECT_CLASS (klass)->finalize = tuba_request_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_MSG_PROPERTY, tuba_request_properties[TUBA_REQUEST_MSG_PROPERTY] = g_param_spec_object ("msg", "msg", "msg", soup_message_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_URL_PROPERTY, tuba_request_properties[TUBA_REQUEST_URL_PROPERTY] = g_param_spec_string ("url", "url", "url", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_PRIORITY_PROPERTY, tuba_request_properties[TUBA_REQUEST_PRIORITY_PROPERTY] = g_param_spec_enum ("priority", "priority", "priority", soup_message_priority_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_METHOD_PROPERTY, tuba_request_properties[TUBA_REQUEST_METHOD_PROPERTY] = g_param_spec_string ("method", "method", "method", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_RESPONSE_BODY_PROPERTY, tuba_request_properties[TUBA_REQUEST_RESPONSE_BODY_PROPERTY] = g_param_spec_object ("response-body", "response-body", "response-body", g_input_stream_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_REQUEST_ACCOUNT_PROPERTY, tuba_request_properties[TUBA_REQUEST_ACCOUNT_PROPERTY] = g_param_spec_object ("account", "account", "account", TUBA_TYPE_INSTANCE_ACCOUNT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
tuba_request_instance_init (TubaRequest * self,
                            gpointer klass)
{
	self->priv = tuba_request_get_instance_private (self);
	self->priv->_account = NULL;
	self->priv->has_ctx = FALSE;
	self->priv->content_type = NULL;
	self->priv->body_bytes = NULL;
	self->priv->force_token = NULL;
	self->priv->cache = TRUE;
}

static void
tuba_request_finalize (GObject * obj)
{
	TubaRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_REQUEST, TubaRequest);
	_g_object_unref0 (self->priv->_msg);
	_g_free0 (self->priv->_url);
	_g_free0 (self->priv->_method);
	_g_object_unref0 (self->priv->_response_body);
	_g_object_unref0 (self->priv->_account);
	(self->priv->cb_target_destroy_notify == NULL) ? NULL : (self->priv->cb_target_destroy_notify (self->priv->cb_target), NULL);
	self->priv->cb = NULL;
	self->priv->cb_target = NULL;
	self->priv->cb_target_destroy_notify = NULL;
	(self->priv->error_cb_target_destroy_notify == NULL) ? NULL : (self->priv->error_cb_target_destroy_notify (self->priv->error_cb_target), NULL);
	self->priv->error_cb = NULL;
	self->priv->error_cb_target = NULL;
	self->priv->error_cb_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->pars);
	__vala_SoupMultipart_free0 (self->priv->form_data);
	_g_object_unref0 (self->cancellable);
	_g_free0 (self->priv->extra_data);
	_g_free0 (self->priv->content_type);
	_g_bytes_unref0 (self->priv->body_bytes);
	_g_free0 (self->priv->force_token);
	G_OBJECT_CLASS (tuba_request_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_request_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaRequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaRequest), 0, (GInstanceInitFunc) tuba_request_instance_init, NULL };
	GType tuba_request_type_id;
	tuba_request_type_id = g_type_register_static (G_TYPE_OBJECT, "TubaRequest", &g_define_type_info, 0);
	TubaRequest_private_offset = g_type_add_instance_private (tuba_request_type_id, sizeof (TubaRequestPrivate));
	return tuba_request_type_id;
}

GType
tuba_request_get_type (void)
{
	static gsize tuba_request_type_id__once = 0;
	if (g_once_init_enter (&tuba_request_type_id__once)) {
		GType tuba_request_type_id;
		tuba_request_type_id = tuba_request_get_type_once ();
		g_once_init_leave (&tuba_request_type_id__once, tuba_request_type_id);
	}
	return tuba_request_type_id__once;
}

static void
_vala_tuba_request_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	TubaRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_REQUEST, TubaRequest);
	switch (property_id) {
		case TUBA_REQUEST_MSG_PROPERTY:
		g_value_set_object (value, tuba_request_get_msg (self));
		break;
		case TUBA_REQUEST_URL_PROPERTY:
		g_value_set_string (value, tuba_request_get_url (self));
		break;
		case TUBA_REQUEST_PRIORITY_PROPERTY:
		g_value_set_enum (value, tuba_request_get_priority (self));
		break;
		case TUBA_REQUEST_METHOD_PROPERTY:
		g_value_set_string (value, tuba_request_get_method (self));
		break;
		case TUBA_REQUEST_RESPONSE_BODY_PROPERTY:
		g_value_set_object (value, tuba_request_get_response_body (self));
		break;
		case TUBA_REQUEST_ACCOUNT_PROPERTY:
		g_value_set_object (value, tuba_request_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_request_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	TubaRequest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_TYPE_REQUEST, TubaRequest);
	switch (property_id) {
		case TUBA_REQUEST_MSG_PROPERTY:
		tuba_request_set_msg (self, g_value_get_object (value));
		break;
		case TUBA_REQUEST_URL_PROPERTY:
		tuba_request_set_url (self, g_value_get_string (value));
		break;
		case TUBA_REQUEST_PRIORITY_PROPERTY:
		tuba_request_set_priority (self, g_value_get_enum (value));
		break;
		case TUBA_REQUEST_METHOD_PROPERTY:
		tuba_request_set_method (self, g_value_get_string (value));
		break;
		case TUBA_REQUEST_RESPONSE_BODY_PROPERTY:
		tuba_request_set_response_body (self, g_value_get_object (value));
		break;
		case TUBA_REQUEST_ACCOUNT_PROPERTY:
		tuba_request_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

