/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_PRELAUNCH_SPLASH_V1_SERVER_PROTOCOL_H
#define TREELAND_PRELAUNCH_SPLASH_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_prelaunch_splash_v1 The treeland_prelaunch_splash_v1 protocol
 * @section page_ifaces_treeland_prelaunch_splash_v1 Interfaces
 * - @subpage page_iface_treeland_prelaunch_splash_manager_v1 - prelaunch splash screen manager
 * @section page_copyright_treeland_prelaunch_splash_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_prelaunch_splash_manager_v1;
struct wl_buffer;

#ifndef TREELAND_PRELAUNCH_SPLASH_MANAGER_V1_INTERFACE
#define TREELAND_PRELAUNCH_SPLASH_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_prelaunch_splash_manager_v1 treeland_prelaunch_splash_manager_v1
 * @section page_iface_treeland_prelaunch_splash_manager_v1_desc Description
 *
 * This interface is a manager for creating prelaunch splash screens.
 * A prelaunch splash screen is a placeholder surface that is shown
 * before an application's main window is mapped. This helps to improve
 * the perceived startup time.
 *
 * It is particularly useful for application launchers to provide immediate
 * feedback to the user.
 * @section page_iface_treeland_prelaunch_splash_manager_v1_api API
 * See @ref iface_treeland_prelaunch_splash_manager_v1.
 */
/**
 * @defgroup iface_treeland_prelaunch_splash_manager_v1 The treeland_prelaunch_splash_manager_v1 interface
 *
 * This interface is a manager for creating prelaunch splash screens.
 * A prelaunch splash screen is a placeholder surface that is shown
 * before an application's main window is mapped. This helps to improve
 * the perceived startup time.
 *
 * It is particularly useful for application launchers to provide immediate
 * feedback to the user.
 */
extern const struct wl_interface treeland_prelaunch_splash_manager_v1_interface;
#endif

/**
 * @ingroup iface_treeland_prelaunch_splash_manager_v1
 * @struct treeland_prelaunch_splash_manager_v1_interface
 */
struct treeland_prelaunch_splash_manager_v1_interface {
	/**
	 * destroy the manager
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * create a new splash screen
	 *
	 * Creates a new prelaunch splash screen.
	 *
	 * The `app_id` is a string that identifies the application. The
	 * compositor will use this ID together with `sandbox_engine_name`
	 * to match the splash screen with the actual application window
	 * when it appears. This matching mechanism should also work for
	 * XWayland windows.
	 *
	 * Callers MUST provide a non-empty `sandbox_engine_name` string
	 * which identifies the sandboxing/container.
	 *
	 * If there is already an active (not-yet-completed) splash for the
	 * same `sandbox_engine_name` and `app_id`, the compositor will
	 * silently ignore this request (no new splash will be created and
	 * no error is raised).
	 * @param app_id the application ID
	 * @param sandbox_engine_name the sandbox engine / security context name (required, non-empty)
	 * @param icon_buffer optional icon image as wl_buffer (e.g. wl_shm)
	 */
	void (*create_splash)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *app_id,
			      const char *sandbox_engine_name,
			      struct wl_resource *icon_buffer);
};


/**
 * @ingroup iface_treeland_prelaunch_splash_manager_v1
 */
#define TREELAND_PRELAUNCH_SPLASH_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_prelaunch_splash_manager_v1
 */
#define TREELAND_PRELAUNCH_SPLASH_MANAGER_V1_CREATE_SPLASH_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
