/* TimeoutCounter.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TimeoutCounter.vala, do not modify */

/*
 * TimeoutCounter.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define TIMEOUT_COUNTER_DEFAULT_SECONDS_TO_WAIT 60
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TIMEOUT_COUNTER (timeout_counter_get_type ())
#define TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounter))
#define TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))
#define IS_TIMEOUT_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TIMEOUT_COUNTER))
#define IS_TIMEOUT_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TIMEOUT_COUNTER))
#define TIMEOUT_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TIMEOUT_COUNTER, TimeoutCounterClass))

typedef struct _TimeoutCounter TimeoutCounter;
typedef struct _TimeoutCounterClass TimeoutCounterClass;
typedef struct _TimeoutCounterPrivate TimeoutCounterPrivate;
enum  {
	TIMEOUT_COUNTER_0_PROPERTY,
	TIMEOUT_COUNTER_NUM_PROPERTIES
};
static GParamSpec* timeout_counter_properties[TIMEOUT_COUNTER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _TimeoutCounter {
	GObject parent_instance;
	TimeoutCounterPrivate * priv;
	gboolean active;
	gchar* process_to_kill;
	gint seconds_to_wait;
	gboolean exit_app;
};

struct _TimeoutCounterClass {
	GObjectClass parent_class;
};

static gpointer timeout_counter_parent_class = NULL;

VALA_EXTERN GType timeout_counter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TimeoutCounter, g_object_unref)
VALA_EXTERN void timeout_counter_kill_process_on_timeout (TimeoutCounter* self,
                                              const gchar* process_to_kill,
                                              gint seconds_to_wait,
                                              gboolean exit_app);
static void ___lambda4_ (TimeoutCounter* self);
VALA_EXTERN void timeout_counter_start_counter_thread (TimeoutCounter* self);
static gpointer ____lambda4__gthread_func (gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN void timeout_counter_exit_on_timeout (TimeoutCounter* self,
                                      gint seconds_to_wait);
static void ___lambda5_ (TimeoutCounter* self);
static gpointer ____lambda5__gthread_func (gpointer self);
VALA_EXTERN void timeout_counter_stop (TimeoutCounter* self);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
void exit (gint exit_code);
VALA_EXTERN TimeoutCounter* timeout_counter_new (void);
VALA_EXTERN TimeoutCounter* timeout_counter_construct (GType object_type);
static void timeout_counter_finalize (GObject * obj);
static GType timeout_counter_get_type_once (void);

static void
___lambda4_ (TimeoutCounter* self)
{
	timeout_counter_start_counter_thread (self);
}

static gpointer
____lambda4__gthread_func (gpointer self)
{
	gpointer result;
	___lambda4_ ((TimeoutCounter*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

void
timeout_counter_kill_process_on_timeout (TimeoutCounter* self,
                                         const gchar* process_to_kill,
                                         gint seconds_to_wait,
                                         gboolean exit_app)
{
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (process_to_kill != NULL);
	_tmp0_ = g_strdup (process_to_kill);
	_g_free0 (self->process_to_kill);
	self->process_to_kill = _tmp0_;
	self->seconds_to_wait = seconds_to_wait;
	self->exit_app = exit_app;
	{
		GThread* _tmp1_;
		GThread* _tmp2_;
		self->active = TRUE;
		_tmp1_ = g_thread_try_new ("timeout-counter", ____lambda4__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_thread_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5_ (TimeoutCounter* self)
{
	timeout_counter_start_counter_thread (self);
}

static gpointer
____lambda5__gthread_func (gpointer self)
{
	gpointer result;
	___lambda5_ ((TimeoutCounter*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

void
timeout_counter_exit_on_timeout (TimeoutCounter* self,
                                 gint seconds_to_wait)
{
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->process_to_kill);
	self->process_to_kill = _tmp0_;
	self->seconds_to_wait = seconds_to_wait;
	self->exit_app = TRUE;
	{
		GThread* _tmp1_;
		GThread* _tmp2_;
		self->active = TRUE;
		_tmp1_ = g_thread_try_new ("timeout-counter", ____lambda5__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_thread_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
timeout_counter_stop (TimeoutCounter* self)
{
	g_return_if_fail (self != NULL);
	self->active = FALSE;
}

void
timeout_counter_start_counter_thread (TimeoutCounter* self)
{
	gint secs = 0;
	g_return_if_fail (self != NULL);
	secs = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->active) {
			_tmp0_ = secs < self->seconds_to_wait;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		g_usleep (((gulong) G_TIME_SPAN_MILLISECOND) * 1000);
		secs += 1;
	}
	if (self->active) {
		FILE* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		self->active = FALSE;
		_tmp1_ = stdout;
		fprintf (_tmp1_, "\n");
		_tmp2_ = self->process_to_kill;
		_tmp3_ = strlen (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ > 0) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp5_ = self->process_to_kill;
			_tmp6_ = g_strconcat ("killall ", _tmp5_, NULL);
			_tmp7_ = _tmp6_;
			system (_tmp7_);
			_g_free0 (_tmp7_);
			_tmp8_ = self->process_to_kill;
			_tmp9_ = g_strdup_printf (": %s", _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat ("[timeout] Killed process", _tmp10_, NULL);
			_tmp12_ = _tmp11_;
			tee_jee_logging_log_debug (_tmp12_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp10_);
		}
		if (self->exit_app) {
			tee_jee_logging_log_debug ("[timeout] Exit application");
			exit (0);
		}
	}
}

TimeoutCounter*
timeout_counter_construct (GType object_type)
{
	TimeoutCounter * self = NULL;
	self = (TimeoutCounter*) g_object_new (object_type, NULL);
	return self;
}

TimeoutCounter*
timeout_counter_new (void)
{
	return timeout_counter_construct (TYPE_TIMEOUT_COUNTER);
}

static void
timeout_counter_class_init (TimeoutCounterClass * klass,
                            gpointer klass_data)
{
	timeout_counter_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = timeout_counter_finalize;
}

static void
timeout_counter_instance_init (TimeoutCounter * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->active = FALSE;
	_tmp0_ = g_strdup ("");
	self->process_to_kill = _tmp0_;
	self->seconds_to_wait = 60;
	self->exit_app = FALSE;
}

static void
timeout_counter_finalize (GObject * obj)
{
	TimeoutCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TIMEOUT_COUNTER, TimeoutCounter);
	_g_free0 (self->process_to_kill);
	G_OBJECT_CLASS (timeout_counter_parent_class)->finalize (obj);
}

static GType
timeout_counter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TimeoutCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) timeout_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TimeoutCounter), 0, (GInstanceInitFunc) timeout_counter_instance_init, NULL };
	GType timeout_counter_type_id;
	timeout_counter_type_id = g_type_register_static (G_TYPE_OBJECT, "TimeoutCounter", &g_define_type_info, 0);
	return timeout_counter_type_id;
}

GType
timeout_counter_get_type (void)
{
	static volatile gsize timeout_counter_type_id__once = 0;
	if (g_once_init_enter (&timeout_counter_type_id__once)) {
		GType timeout_counter_type_id;
		timeout_counter_type_id = timeout_counter_get_type_once ();
		g_once_init_leave (&timeout_counter_type_id__once, timeout_counter_type_id);
	}
	return timeout_counter_type_id__once;
}

