/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// FileKeySelectorApplyConfiguration represents a declarative configuration of the FileKeySelector type for use
// with apply.
//
// FileKeySelector selects a key of the env file.
type FileKeySelectorApplyConfiguration struct {
	// The name of the volume mount containing the env file.
	VolumeName *string `json:"volumeName,omitempty"`
	// The path within the volume from which to select the file.
	// Must be relative and may not contain the '..' path or start with '..'.
	Path *string `json:"path,omitempty"`
	// The key within the env file. An invalid key will prevent the pod from starting.
	// The keys defined within a source may consist of any printable ASCII characters except '='.
	// During Alpha stage of the EnvFiles feature gate, the key size is limited to 128 characters.
	Key *string `json:"key,omitempty"`
	// Specify whether the file or its key must be defined. If the file or key
	// does not exist, then the env var is not published.
	// If optional is set to true and the specified key does not exist,
	// the environment variable will not be set in the Pod's containers.
	//
	// If optional is set to false and the specified key does not exist,
	// an error will be returned during Pod creation.
	Optional *bool `json:"optional,omitempty"`
}

// FileKeySelectorApplyConfiguration constructs a declarative configuration of the FileKeySelector type for use with
// apply.
func FileKeySelector() *FileKeySelectorApplyConfiguration {
	return &FileKeySelectorApplyConfiguration{}
}

// WithVolumeName sets the VolumeName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the VolumeName field is set to the value of the last call.
func (b *FileKeySelectorApplyConfiguration) WithVolumeName(value string) *FileKeySelectorApplyConfiguration {
	b.VolumeName = &value
	return b
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *FileKeySelectorApplyConfiguration) WithPath(value string) *FileKeySelectorApplyConfiguration {
	b.Path = &value
	return b
}

// WithKey sets the Key field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Key field is set to the value of the last call.
func (b *FileKeySelectorApplyConfiguration) WithKey(value string) *FileKeySelectorApplyConfiguration {
	b.Key = &value
	return b
}

// WithOptional sets the Optional field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Optional field is set to the value of the last call.
func (b *FileKeySelectorApplyConfiguration) WithOptional(value bool) *FileKeySelectorApplyConfiguration {
	b.Optional = &value
	return b
}
