/* StylusView.c generated by valac 0.56.18, the Vala compiler
 * generated from StylusView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2019-2024 elementary, Inc. (https://elementary.io)
 */

#include "wacom.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <libwacom/libwacom.h>
#include <granite-7.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WACOM_STYLUS_VIEW_0_PROPERTY,
	WACOM_STYLUS_VIEW_NUM_PROPERTIES
};
static GParamSpec* wacom_stylus_view_properties[WACOM_STYLUS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _libwacom_database_destroy0(var) ((var == NULL) ? NULL : (var = (libwacom_database_destroy (var), NULL)))

struct _WacomStylusViewPrivate {
	GSettings* settings;
	GtkBox* stylus_box;
};

struct _Block1Data {
	int _ref_count_;
	WacomStylusView* self;
	WacomWidgetsDrawingArea* test_area;
	GraniteDialog* test_dialog;
};

struct _Block2Data {
	int _ref_count_;
	WacomStylusView* self;
	GtkScale* scale;
	gchar* schema_key;
};

static gint WacomStylusView_private_offset;
static gpointer wacom_stylus_view_parent_class = NULL;
static GtkSizeGroup* wacom_stylus_view_label_sizegroup;
static GtkSizeGroup* wacom_stylus_view_label_sizegroup = NULL;
static WacomDeviceDatabase* wacom_stylus_view_wacom_db;
static WacomDeviceDatabase* wacom_stylus_view_wacom_db = NULL;

static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static GtkBox* wacom_stylus_view_pressure_setting (WacomStylusView* self,
                                            const gchar* label,
                                            const gchar* schema_key);
static GtkBox* wacom_stylus_view_button_setting (WacomStylusView* self,
                                          const gchar* label,
                                          const gchar* schema_key);
static void __lambda7_ (Block1Data* _data1_);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
static void __lambda8_ (Block1Data* _data1_);
static void ___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void wacom_stylus_view_set_pressure_scale_value_from_settings (WacomStylusView* self,
                                                               GtkScale* scale,
                                                               const gchar* schema_key);
static void __lambda6_ (Block2Data* _data2_);
static void wacom_stylus_view_on_pressure_value_changed (WacomStylusView* self,
                                                  gint new_value,
                                                  const gchar* schema_key);
static void ___lambda6__gtk_range_value_changed (GtkRange* _sender,
                                          gpointer self);
static GObject * wacom_stylus_view_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void wacom_stylus_view_finalize (GObject * obj);
static GType wacom_stylus_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gint32 WACOM_STYLUS_VIEW_PRESSURE_CURVES[7][4] = {{(gint32) 0, (gint32) 75, (gint32) 25, (gint32) 100}, {(gint32) 0, (gint32) 50, (gint32) 50, (gint32) 100}, {(gint32) 0, (gint32) 25, (gint32) 75, (gint32) 100}, {(gint32) 0, (gint32) 0, (gint32) 100, (gint32) 100}, {(gint32) 25, (gint32) 0, (gint32) 100, (gint32) 75}, {(gint32) 50, (gint32) 0, (gint32) 100, (gint32) 50}, {(gint32) 75, (gint32) 0, (gint32) 100, (gint32) 25}};

static inline gpointer
wacom_stylus_view_get_instance_private (WacomStylusView* self)
{
	return G_STRUCT_MEMBER_P (self, WacomStylusView_private_offset);
}

gboolean
wacom_stylus_view_is_stylus_supported (WacomStylusView* self,
                                       WacomBackendWacomTool* wacom_tool)
{
	WacomStylus* stylus = NULL;
	WacomDeviceDatabase* _tmp0_;
	guint64 _tmp1_;
	guint64 _tmp2_;
	WacomStylus* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (wacom_tool != NULL, FALSE);
	_tmp0_ = wacom_stylus_view_wacom_db;
	_tmp1_ = wacom_backend_wacom_tool_get_id (wacom_tool);
	_tmp2_ = _tmp1_;
	_tmp3_ = libwacom_stylus_get_for_id (_tmp0_, (gint) _tmp2_);
	stylus = _tmp3_;
	result = stylus != NULL;
	return result;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WacomStylusView* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->test_dialog);
		_g_object_unref0 (_data1_->test_area);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_libwacom_stylus_has_eraser (WacomStylus* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = libwacom_stylus_has_eraser (self) != 0;
	return result;
}

static void
__lambda7_ (Block1Data* _data1_)
{
	WacomStylusView* self;
	WacomWidgetsDrawingArea* _tmp0_;
	GraniteDialog* _tmp1_;
	self = _data1_->self;
	_tmp0_ = _data1_->test_area;
	wacom_widgets_drawing_area_clear (_tmp0_);
	_tmp1_ = _data1_->test_dialog;
	gtk_window_present ((GtkWindow*) _tmp1_);
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ (self);
}

static void
__lambda8_ (Block1Data* _data1_)
{
	WacomStylusView* self;
	GraniteDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->test_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
___lambda8__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda8_ (self);
}

void
wacom_stylus_view_set_device (WacomStylusView* self,
                              WacomBackendWacomTool* wacom_tool)
{
	Block1Data* _data1_;
	WacomStylus* stylus = NULL;
	WacomDeviceDatabase* _tmp5_;
	guint64 _tmp6_;
	guint64 _tmp7_;
	WacomStylus* _tmp8_;
	GraniteHeaderLabel* header_label = NULL;
	WacomStylus* _tmp9_;
	const gchar* _tmp10_;
	GraniteHeaderLabel* _tmp11_ = NULL;
	GtkButton* test_button = NULL;
	GtkButton* _tmp12_;
	WacomWidgetsDrawingArea* _tmp13_ = NULL;
	WacomWidgetsDrawingArea* _tmp14_;
	GApplication* _tmp15_;
	GtkWindow* _tmp16_;
	GtkWindow* _tmp17_;
	GtkWindow* _tmp18_;
	GraniteDialog* _tmp19_ = NULL;
	GraniteDialog* _tmp20_;
	GtkBox* _tmp21_;
	WacomWidgetsDrawingArea* _tmp22_;
	GraniteDialog* _tmp23_;
	GtkBox* header_box = NULL;
	GtkBox* _tmp24_;
	GtkBox* _tmp25_;
	GraniteHeaderLabel* _tmp26_;
	GtkBox* _tmp27_;
	GtkButton* _tmp28_;
	GtkBox* _tmp29_;
	GtkBox* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	GSettings* _tmp33_;
	gboolean has_pressure_detection = FALSE;
	WacomStylus* _tmp34_;
	gboolean _tmp35_ = FALSE;
	WacomStylus* _tmp40_;
	GtkButton* _tmp62_;
	GraniteDialog* _tmp63_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wacom_tool != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	while (TRUE) {
		GtkBox* _tmp0_;
		GtkWidget* _tmp1_;
		GtkBox* _tmp2_;
		GtkBox* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp0_ = self->priv->stylus_box;
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = self->priv->stylus_box;
		_tmp3_ = self->priv->stylus_box;
		_tmp4_ = gtk_widget_get_first_child ((GtkWidget*) _tmp3_);
		gtk_box_remove (_tmp2_, _tmp4_);
	}
	_tmp5_ = wacom_stylus_view_wacom_db;
	_tmp6_ = wacom_backend_wacom_tool_get_id (wacom_tool);
	_tmp7_ = _tmp6_;
	_tmp8_ = libwacom_stylus_get_for_id (_tmp5_, (gint) _tmp7_);
	stylus = _tmp8_;
	_tmp9_ = stylus;
	_tmp10_ = libwacom_stylus_get_name (_tmp9_);
	_tmp11_ = granite_header_label_new (_tmp10_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	g_object_ref_sink (_tmp11_);
	header_label = _tmp11_;
	_tmp12_ = (GtkButton*) gtk_button_new_with_label (_ ("Test Settings"));
	g_object_ref_sink (_tmp12_);
	test_button = _tmp12_;
	_tmp13_ = wacom_widgets_drawing_area_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	_data1_->test_area = _tmp13_;
	_tmp14_ = _data1_->test_area;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, GRANITE_STYLE_CLASS_FRAME);
	_tmp15_ = g_application_get_default ();
	_tmp16_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_application_get_type (), GtkApplication));
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	_tmp19_ = granite_dialog_new ();
	g_object_set ((GtkWindow*) _tmp19_, "default-width", 500, NULL);
	g_object_set ((GtkWindow*) _tmp19_, "default-height", 400, NULL);
	gtk_window_set_modal ((GtkWindow*) _tmp19_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp19_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_data1_->test_dialog = _tmp19_;
	_tmp20_ = _data1_->test_dialog;
	_tmp21_ = gtk_dialog_get_content_area ((GtkDialog*) _tmp20_);
	_tmp22_ = _data1_->test_area;
	gtk_box_append (_tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = _data1_->test_dialog;
	granite_dialog_add_button (_tmp23_, "Close", (gint) GTK_RESPONSE_CLOSE);
	_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp24_);
	header_box = _tmp24_;
	_tmp25_ = header_box;
	_tmp26_ = header_label;
	gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = header_box;
	_tmp28_ = test_button;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->stylus_box;
	_tmp30_ = header_box;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = wacom_backend_wacom_tool_get_settings_path (wacom_tool);
	_tmp32_ = _tmp31_;
	_tmp33_ = g_settings_new_with_path ("org.gnome.desktop.peripherals.tablet.stylus", _tmp32_);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp33_;
	_tmp34_ = stylus;
	has_pressure_detection = (libwacom_stylus_get_axes (_tmp34_) & WACOM_AXIS_TYPE_PRESSURE) == WACOM_AXIS_TYPE_PRESSURE;
	if (has_pressure_detection) {
		WacomStylus* _tmp36_;
		_tmp36_ = stylus;
		_tmp35_ = _vala_libwacom_stylus_has_eraser (_tmp36_);
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		GtkBox* _tmp37_;
		GtkBox* _tmp38_;
		GtkBox* _tmp39_;
		_tmp37_ = self->priv->stylus_box;
		_tmp38_ = wacom_stylus_view_pressure_setting (self, _ ("Eraser Pressure Feel"), "eraser-pressure-curve");
		_tmp39_ = _tmp38_;
		gtk_box_append (_tmp37_, (GtkWidget*) _tmp39_);
		_g_object_unref0 (_tmp39_);
	}
	_tmp40_ = stylus;
	switch (libwacom_stylus_get_num_buttons (_tmp40_)) {
		case 1:
		{
			GtkBox* _tmp41_;
			GtkBox* _tmp42_;
			GtkBox* _tmp43_;
			_tmp41_ = self->priv->stylus_box;
			_tmp42_ = wacom_stylus_view_button_setting (self, _ ("Button Action"), "button-action");
			_tmp43_ = _tmp42_;
			gtk_box_append (_tmp41_, (GtkWidget*) _tmp43_);
			_g_object_unref0 (_tmp43_);
			break;
		}
		case 2:
		{
			GtkBox* _tmp44_;
			GtkBox* _tmp45_;
			GtkBox* _tmp46_;
			GtkBox* _tmp47_;
			GtkBox* _tmp48_;
			GtkBox* _tmp49_;
			_tmp44_ = self->priv->stylus_box;
			_tmp45_ = wacom_stylus_view_button_setting (self, _ ("Top Button Action"), "secondary-button-action");
			_tmp46_ = _tmp45_;
			gtk_box_append (_tmp44_, (GtkWidget*) _tmp46_);
			_g_object_unref0 (_tmp46_);
			_tmp47_ = self->priv->stylus_box;
			_tmp48_ = wacom_stylus_view_button_setting (self, _ ("Bottom Button Action"), "button-action");
			_tmp49_ = _tmp48_;
			gtk_box_append (_tmp47_, (GtkWidget*) _tmp49_);
			_g_object_unref0 (_tmp49_);
			break;
		}
		case 3:
		{
			GtkBox* _tmp50_;
			GtkBox* _tmp51_;
			GtkBox* _tmp52_;
			GtkBox* _tmp53_;
			GtkBox* _tmp54_;
			GtkBox* _tmp55_;
			GtkBox* _tmp56_;
			GtkBox* _tmp57_;
			GtkBox* _tmp58_;
			_tmp50_ = self->priv->stylus_box;
			_tmp51_ = wacom_stylus_view_button_setting (self, _ ("Top Button Action"), "secondary-button-action");
			_tmp52_ = _tmp51_;
			gtk_box_append (_tmp50_, (GtkWidget*) _tmp52_);
			_g_object_unref0 (_tmp52_);
			_tmp53_ = self->priv->stylus_box;
			_tmp54_ = wacom_stylus_view_button_setting (self, _ ("Middle Button Action"), "button-action");
			_tmp55_ = _tmp54_;
			gtk_box_append (_tmp53_, (GtkWidget*) _tmp55_);
			_g_object_unref0 (_tmp55_);
			_tmp56_ = self->priv->stylus_box;
			_tmp57_ = wacom_stylus_view_button_setting (self, _ ("Bottom Button Action"), "tertiary-button-action");
			_tmp58_ = _tmp57_;
			gtk_box_append (_tmp56_, (GtkWidget*) _tmp58_);
			_g_object_unref0 (_tmp58_);
			break;
		}
		default:
		break;
	}
	if (has_pressure_detection) {
		GtkBox* _tmp59_;
		GtkBox* _tmp60_;
		GtkBox* _tmp61_;
		_tmp59_ = self->priv->stylus_box;
		_tmp60_ = wacom_stylus_view_pressure_setting (self, _ ("Tip Pressure Feel"), "pressure-curve");
		_tmp61_ = _tmp60_;
		gtk_box_append (_tmp59_, (GtkWidget*) _tmp61_);
		_g_object_unref0 (_tmp61_);
	}
	_tmp62_ = test_button;
	g_signal_connect_data (_tmp62_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp63_ = _data1_->test_dialog;
	g_signal_connect_data ((GtkDialog*) _tmp63_, "response", (GCallback) ___lambda8__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (header_box);
	_g_object_unref0 (test_button);
	_g_object_unref0 (header_label);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static GtkBox*
wacom_stylus_view_button_setting (WacomStylusView* self,
                                  const gchar* label,
                                  const gchar* schema_key)
{
	GtkComboBoxText* button_combo = NULL;
	GtkComboBoxText* _tmp0_ = NULL;
	GtkLabel* setting_label = NULL;
	GtkWidget* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkSizeGroup* _tmp3_;
	GtkBox* box = NULL;
	GtkBox* _tmp4_;
	GSettings* _tmp5_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (schema_key != NULL, NULL);
	_tmp0_ = (GtkComboBoxText*) gtk_combo_box_text_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	button_combo = _tmp0_;
	gtk_combo_box_text_append (button_combo, "default", _ ("Default"));
	gtk_combo_box_text_append (button_combo, "middle", _ ("Middle Mouse Button Click"));
	gtk_combo_box_text_append (button_combo, "right", _ ("Right Mouse Button Click"));
	gtk_combo_box_text_append (button_combo, "back", _ ("Back"));
	gtk_combo_box_text_append (button_combo, "forward", _ ("Forward"));
	_tmp1_ = _g_object_ref0 ((GtkWidget*) button_combo);
	_tmp2_ = (GtkLabel*) gtk_label_new (label);
	gtk_label_set_mnemonic_widget (_tmp2_, _tmp1_);
	_g_object_unref0 (_tmp1_);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	g_object_ref_sink (_tmp2_);
	setting_label = _tmp2_;
	_tmp3_ = wacom_stylus_view_label_sizegroup;
	gtk_size_group_add_widget (_tmp3_, (GtkWidget*) setting_label);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp4_);
	box = _tmp4_;
	gtk_box_append (box, (GtkWidget*) setting_label);
	gtk_box_append (box, (GtkWidget*) button_combo);
	_tmp5_ = self->priv->settings;
	g_settings_bind (_tmp5_, schema_key, (GObject*) button_combo, "active-id", G_SETTINGS_BIND_DEFAULT);
	result = box;
	_g_object_unref0 (setting_label);
	_g_object_unref0 (button_combo);
	return result;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		WacomStylusView* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->scale);
		_g_free0 (_data2_->schema_key);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda6_ (Block2Data* _data2_)
{
	WacomStylusView* self;
	self = _data2_->self;
	wacom_stylus_view_on_pressure_value_changed (self, (gint) gtk_range_get_value ((GtkRange*) _data2_->scale), _data2_->schema_key);
}

static void
___lambda6__gtk_range_value_changed (GtkRange* _sender,
                                     gpointer self)
{
	__lambda6_ (self);
}

static GtkBox*
wacom_stylus_view_pressure_setting (WacomStylusView* self,
                                    const gchar* label,
                                    const gchar* schema_key)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	GtkScale* _tmp1_ = NULL;
	GtkLabel* setting_label = NULL;
	GtkWidget* _tmp2_;
	GtkLabel* _tmp3_ = NULL;
	GtkSizeGroup* _tmp4_;
	GtkBox* box = NULL;
	GtkBox* _tmp5_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (schema_key != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (schema_key);
	_g_free0 (_data2_->schema_key);
	_data2_->schema_key = _tmp0_;
	_tmp1_ = (GtkScale*) gtk_scale_new_with_range (GTK_ORIENTATION_HORIZONTAL, (gdouble) 0, (gdouble) 6, (gdouble) 1);
	gtk_scale_set_draw_value (_tmp1_, FALSE);
	gtk_scale_set_has_origin (_tmp1_, FALSE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_range_set_round_digits ((GtkRange*) _tmp1_, 0);
	g_object_ref_sink (_tmp1_);
	_data2_->scale = _tmp1_;
	gtk_scale_add_mark (_data2_->scale, (gdouble) 0, GTK_POS_BOTTOM, _ ("Soft"));
	gtk_scale_add_mark (_data2_->scale, (gdouble) 6, GTK_POS_BOTTOM, _ ("Firm"));
	wacom_stylus_view_set_pressure_scale_value_from_settings (self, _data2_->scale, _data2_->schema_key);
	g_signal_connect_data ((GtkRange*) _data2_->scale, "value-changed", (GCallback) ___lambda6__gtk_range_value_changed, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp2_ = _g_object_ref0 ((GtkWidget*) _data2_->scale);
	_tmp3_ = (GtkLabel*) gtk_label_new (label);
	gtk_label_set_mnemonic_widget (_tmp3_, _tmp2_);
	_g_object_unref0 (_tmp2_);
	gtk_label_set_xalign (_tmp3_, (gfloat) 0);
	g_object_ref_sink (_tmp3_);
	setting_label = _tmp3_;
	_tmp4_ = wacom_stylus_view_label_sizegroup;
	gtk_size_group_add_widget (_tmp4_, (GtkWidget*) setting_label);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 12);
	g_object_ref_sink (_tmp5_);
	box = _tmp5_;
	gtk_box_append (box, (GtkWidget*) setting_label);
	gtk_box_append (box, (GtkWidget*) _data2_->scale);
	result = box;
	_g_object_unref0 (setting_label);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}

static void
wacom_stylus_view_on_pressure_value_changed (WacomStylusView* self,
                                             gint new_value,
                                             const gchar* schema_key)
{
	gboolean _tmp0_ = FALSE;
	GVariant** values = NULL;
	gint _tmp1_;
	GVariant** _tmp2_;
	gint values_length1;
	gint _values_size_;
	GVariant* array = NULL;
	const GVariantType* _tmp9_;
	GVariant** _tmp10_;
	gint _tmp10__length1;
	GVariant* _tmp11_;
	GSettings* _tmp12_;
	GVariant* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (schema_key != NULL);
	if (new_value < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = new_value > 6;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
	_tmp2_ = g_new0 (GVariant*, _tmp1_ + 1);
	values = _tmp2_;
	values_length1 = _tmp1_;
	_values_size_ = values_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GVariant** _tmp5_;
				gint _tmp5__length1;
				GVariant** _tmp6_;
				gint _tmp6__length1;
				gint32 _tmp7_;
				GVariant* _tmp8_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = values;
				_tmp5__length1 = values_length1;
				if (!(i < _tmp5__length1)) {
					break;
				}
				_tmp6_ = values;
				_tmp6__length1 = values_length1;
				_tmp7_ = WACOM_STYLUS_VIEW_PRESSURE_CURVES[new_value][i];
				_tmp8_ = g_variant_new_int32 (_tmp7_);
				g_variant_ref_sink (_tmp8_);
				_g_variant_unref0 (_tmp6_[i]);
				_tmp6_[i] = _tmp8_;
			}
		}
	}
	_tmp9_ = G_VARIANT_TYPE_INT32;
	_tmp10_ = values;
	_tmp10__length1 = values_length1;
	_tmp11_ = g_variant_new_array (_tmp9_, _tmp10_, _tmp10__length1);
	g_variant_ref_sink (_tmp11_);
	_g_variant_unref0 (array);
	array = _tmp11_;
	_tmp12_ = self->priv->settings;
	_tmp13_ = array;
	g_settings_set_value (_tmp12_, schema_key, _tmp13_);
	_g_variant_unref0 (array);
	values = (_vala_array_free (values, values_length1, (GDestroyNotify) g_variant_unref), NULL);
}

static void
wacom_stylus_view_set_pressure_scale_value_from_settings (WacomStylusView* self,
                                                          GtkScale* scale,
                                                          const gchar* schema_key)
{
	GVariant* settings_value = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gint _tmp3_;
	gint* values = NULL;
	gint _tmp5_;
	gint* _tmp6_;
	gint values_length1;
	gint _values_size_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scale != NULL);
	g_return_if_fail (schema_key != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, schema_key);
	settings_value = _tmp1_;
	_tmp2_ = settings_value;
	_tmp3_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
	if (g_variant_n_children (_tmp2_) != ((gsize) _tmp3_)) {
		gint _tmp4_;
		_tmp4_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
		g_warning ("StylusView.vala:186: Invalid pressure curve format, expected %d values", _tmp4_);
		_g_variant_unref0 (settings_value);
		return;
	}
	_tmp5_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
	_tmp6_ = g_new0 (gint, _tmp5_);
	values = _tmp6_;
	values_length1 = _tmp5_;
	_values_size_ = values_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				gint* _tmp10_;
				gint _tmp10__length1;
				GVariant* _tmp11_;
				GVariant* _tmp12_;
				GVariant* _tmp13_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
				if (!(i < _tmp9_)) {
					break;
				}
				_tmp10_ = values;
				_tmp10__length1 = values_length1;
				_tmp11_ = settings_value;
				_tmp12_ = g_variant_get_child_value (_tmp11_, (gsize) i);
				_tmp13_ = _tmp12_;
				_tmp10_[i] = (gint) g_variant_get_int32 (_tmp13_);
				_g_variant_unref0 (_tmp13_);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				gboolean match = FALSE;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES);
				if (!(i < _tmp16_)) {
					break;
				}
				match = TRUE;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp17_ = FALSE;
						_tmp17_ = TRUE;
						while (TRUE) {
							gint _tmp19_;
							gint* _tmp20_;
							gint _tmp20__length1;
							gint _tmp21_;
							gint32 _tmp22_;
							if (!_tmp17_) {
								gint _tmp18_;
								_tmp18_ = j;
								j = _tmp18_ + 1;
							}
							_tmp17_ = FALSE;
							_tmp19_ = G_N_ELEMENTS (WACOM_STYLUS_VIEW_PRESSURE_CURVES[0]);
							if (!(j < _tmp19_)) {
								break;
							}
							_tmp20_ = values;
							_tmp20__length1 = values_length1;
							_tmp21_ = _tmp20_[j];
							_tmp22_ = WACOM_STYLUS_VIEW_PRESSURE_CURVES[i][j];
							if (_tmp21_ != ((gint) _tmp22_)) {
								match = FALSE;
								break;
							}
						}
					}
				}
				if (match) {
					gtk_range_set_value ((GtkRange*) scale, (gdouble) i);
					break;
				}
			}
		}
	}
	values = (g_free (values), NULL);
	_g_variant_unref0 (settings_value);
}

WacomStylusView*
wacom_stylus_view_construct (GType object_type)
{
	WacomStylusView * self = NULL;
	self = (WacomStylusView*) g_object_new (object_type, NULL);
	return self;
}

WacomStylusView*
wacom_stylus_view_new (void)
{
	return wacom_stylus_view_construct (WACOM_TYPE_STYLUS_VIEW);
}

static GObject *
wacom_stylus_view_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	WacomStylusView * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	parent_class = G_OBJECT_CLASS (wacom_stylus_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_STYLUS_VIEW, WacomStylusView);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->stylus_box);
	self->priv->stylus_box = _tmp0_;
	_tmp1_ = self->priv->stylus_box;
	gtk_box_append ((GtkBox*) self, (GtkWidget*) _tmp1_);
	return obj;
}

static void
wacom_stylus_view_class_init (WacomStylusViewClass * klass,
                              gpointer klass_data)
{
	GtkSizeGroup* _tmp0_;
	WacomDeviceDatabase* _tmp1_;
	wacom_stylus_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WacomStylusView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = wacom_stylus_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = wacom_stylus_view_finalize;
	_tmp0_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	_g_object_unref0 (wacom_stylus_view_label_sizegroup);
	wacom_stylus_view_label_sizegroup = _tmp0_;
	_tmp1_ = libwacom_database_new ();
	_libwacom_database_destroy0 (wacom_stylus_view_wacom_db);
	wacom_stylus_view_wacom_db = _tmp1_;
}

static void
wacom_stylus_view_instance_init (WacomStylusView * self,
                                 gpointer klass)
{
	self->priv = wacom_stylus_view_get_instance_private (self);
}

static void
wacom_stylus_view_finalize (GObject * obj)
{
	WacomStylusView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WACOM_TYPE_STYLUS_VIEW, WacomStylusView);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->stylus_box);
	G_OBJECT_CLASS (wacom_stylus_view_parent_class)->finalize (obj);
}

static GType
wacom_stylus_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WacomStylusViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wacom_stylus_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WacomStylusView), 0, (GInstanceInitFunc) wacom_stylus_view_instance_init, NULL };
	GType wacom_stylus_view_type_id;
	wacom_stylus_view_type_id = g_type_register_static (gtk_box_get_type (), "WacomStylusView", &g_define_type_info, 0);
	WacomStylusView_private_offset = g_type_add_instance_private (wacom_stylus_view_type_id, sizeof (WacomStylusViewPrivate));
	return wacom_stylus_view_type_id;
}

GType
wacom_stylus_view_get_type (void)
{
	static volatile gsize wacom_stylus_view_type_id__once = 0;
	if (g_once_init_enter (&wacom_stylus_view_type_id__once)) {
		GType wacom_stylus_view_type_id;
		wacom_stylus_view_type_id = wacom_stylus_view_get_type_once ();
		g_once_init_leave (&wacom_stylus_view_type_id__once, wacom_stylus_view_type_id);
	}
	return wacom_stylus_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

