/* App.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from App.vala, do not modify */

/*
* SPDX-License-Identifier: LGPL-3.0-or-later
* SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
*
* Authored by: Leonhard Kargl <leo.kargl@proton.me>
*/

#include "io.elementary.settings.sound.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pulse/pulseaudio.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SOUND_APP_0_PROPERTY,
	SOUND_APP_INDEX_PROPERTY,
	SOUND_APP_NAME_PROPERTY,
	SOUND_APP_DISPLAY_NAME_PROPERTY,
	SOUND_APP_ICON_PROPERTY,
	SOUND_APP_MEDIA_NAME_PROPERTY,
	SOUND_APP_VOLUME_PROPERTY,
	SOUND_APP_MUTED_PROPERTY,
	SOUND_APP_HIDDEN_PROPERTY,
	SOUND_APP_NUM_PROPERTIES
};
static GParamSpec* sound_app_properties[SOUND_APP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SOUND_APP_CHANGED_SIGNAL,
	SOUND_APP_NUM_SIGNALS
};
static guint sound_app_signals[SOUND_APP_NUM_SIGNALS] = {0};

struct _SoundAppPrivate {
	guint32 _index;
	gchar* _name;
	gchar* _display_name;
	GIcon* _icon;
	gchar* _media_name;
	gdouble _volume;
	gboolean _muted;
	pa_channel_map _channel_map;
	gboolean _hidden;
};

static gint SoundApp_private_offset;
static gpointer sound_app_parent_class = NULL;
static GSettings* sound_app_settings;
static GSettings* sound_app_settings = NULL;

static void sound_app_set_index (SoundApp* self,
                          guint32 value);
static void sound_app_set_name (SoundApp* self,
                         const gchar* value);
static void sound_app_set_display_name (SoundApp* self,
                                 const gchar* value);
static void sound_app_set_icon (SoundApp* self,
                         GIcon* value);
static void sound_app_finalize (GObject * obj);
static GType sound_app_get_type_once (void);
static void _vala_sound_app_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_sound_app_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
sound_app_get_instance_private (SoundApp* self)
{
	return G_STRUCT_MEMBER_P (self, SoundApp_private_offset);
}

SoundApp*
sound_app_construct_from_sink_input_info (GType object_type,
                                          pa_sink_input_info* sink_input)
{
	SoundApp * self = NULL;
	pa_sink_input_info _tmp0_;
	pa_sink_input_info _tmp1_;
	pa_proplist* _tmp2_;
	const gchar* _tmp3_;
	gchar* app_id = NULL;
	pa_sink_input_info _tmp4_;
	pa_proplist* _tmp5_;
	GDesktopAppInfo* app_info = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GDesktopAppInfo* _tmp15_;
	GDesktopAppInfo* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	GDesktopAppInfo* _tmp19_;
	g_return_val_if_fail (sink_input != NULL, NULL);
	self = (SoundApp*) g_object_new (object_type, NULL);
	_tmp0_ = *sink_input;
	sound_app_set_index (self, _tmp0_.index);
	_tmp1_ = *sink_input;
	_tmp2_ = _tmp1_.proplist;
	_tmp3_ = pa_proplist_gets (_tmp2_, PA_PROP_APPLICATION_NAME);
	sound_app_set_name (self, _tmp3_);
	_tmp4_ = *sink_input;
	_tmp5_ = _tmp4_.proplist;
	if (pa_proplist_contains (_tmp5_, PA_PROP_APPLICATION_ID) == 1) {
		pa_sink_input_info _tmp6_;
		pa_proplist* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = *sink_input;
		_tmp7_ = _tmp6_.proplist;
		_tmp8_ = pa_proplist_gets (_tmp7_, PA_PROP_APPLICATION_ID);
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (app_id);
		app_id = _tmp9_;
	} else {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->priv->_name;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (app_id);
		app_id = _tmp11_;
	}
	_tmp12_ = app_id;
	_tmp13_ = g_strconcat (_tmp12_, ".desktop", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_desktop_app_info_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	app_info = _tmp16_;
	_tmp17_ = app_info;
	if (_tmp17_ == NULL) {
		GSettings* _tmp18_;
		_tmp18_ = sound_app_settings;
		g_settings_bind (_tmp18_, "show-unknown-apps", (GObject*) self, "hidden", G_SETTINGS_BIND_GET | G_SETTINGS_BIND_INVERT_BOOLEAN);
	}
	_tmp19_ = app_info;
	if (_tmp19_ != NULL) {
		GDesktopAppInfo* _tmp20_;
		const gchar* _tmp21_;
		GDesktopAppInfo* _tmp22_;
		GIcon* _tmp23_;
		_tmp20_ = app_info;
		_tmp21_ = g_app_info_get_name ((GAppInfo*) _tmp20_);
		sound_app_set_display_name (self, _tmp21_);
		_tmp22_ = app_info;
		_tmp23_ = g_app_info_get_icon ((GAppInfo*) _tmp22_);
		sound_app_set_icon (self, _tmp23_);
	} else {
		const gchar* _tmp24_;
		pa_sink_input_info _tmp25_;
		pa_proplist* _tmp26_;
		_tmp24_ = self->priv->_name;
		sound_app_set_display_name (self, _tmp24_);
		_tmp25_ = *sink_input;
		_tmp26_ = _tmp25_.proplist;
		if (pa_proplist_contains (_tmp26_, PA_PROP_APPLICATION_ICON_NAME) == 1) {
			pa_sink_input_info _tmp27_;
			pa_proplist* _tmp28_;
			const gchar* _tmp29_;
			GThemedIcon* _tmp30_;
			GThemedIcon* _tmp31_;
			_tmp27_ = *sink_input;
			_tmp28_ = _tmp27_.proplist;
			_tmp29_ = pa_proplist_gets (_tmp28_, PA_PROP_APPLICATION_ICON_NAME);
			_tmp30_ = (GThemedIcon*) g_themed_icon_new (_tmp29_);
			_tmp31_ = _tmp30_;
			sound_app_set_icon (self, (GIcon*) _tmp31_);
			_g_object_unref0 (_tmp31_);
		} else {
			GThemedIcon* _tmp32_;
			GThemedIcon* _tmp33_;
			_tmp32_ = (GThemedIcon*) g_themed_icon_new ("application-default-icon");
			_tmp33_ = _tmp32_;
			sound_app_set_icon (self, (GIcon*) _tmp33_);
			_g_object_unref0 (_tmp33_);
		}
	}
	_g_object_unref0 (app_info);
	_g_free0 (app_id);
	return self;
}

SoundApp*
sound_app_new_from_sink_input_info (pa_sink_input_info* sink_input)
{
	return sound_app_construct_from_sink_input_info (SOUND_TYPE_APP, sink_input);
}

SoundApp*
sound_app_construct (GType object_type)
{
	SoundApp * self = NULL;
	self = (SoundApp*) g_object_new (object_type, NULL);
	return self;
}

SoundApp*
sound_app_new (void)
{
	return sound_app_construct (SOUND_TYPE_APP);
}

guint32
sound_app_get_index (SoundApp* self)
{
	guint32 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_index;
	return result;
}

static void
sound_app_set_index (SoundApp* self,
                     guint32 value)
{
	guint32 old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_index (self);
	if (old_value != value) {
		self->priv->_index = value;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_INDEX_PROPERTY]);
	}
}

const gchar*
sound_app_get_name (SoundApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
sound_app_set_name (SoundApp* self,
                    const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_NAME_PROPERTY]);
	}
}

const gchar*
sound_app_get_display_name (SoundApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

static void
sound_app_set_display_name (SoundApp* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_DISPLAY_NAME_PROPERTY]);
	}
}

GIcon*
sound_app_get_icon (SoundApp* self)
{
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sound_app_set_icon (SoundApp* self,
                    GIcon* value)
{
	GIcon* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_icon (self);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_icon);
		self->priv->_icon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_ICON_PROPERTY]);
	}
}

const gchar*
sound_app_get_media_name (SoundApp* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_media_name;
	result = _tmp0_;
	return result;
}

void
sound_app_set_media_name (SoundApp* self,
                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_media_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_media_name);
		self->priv->_media_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_MEDIA_NAME_PROPERTY]);
	}
}

gdouble
sound_app_get_volume (SoundApp* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_volume;
	return result;
}

void
sound_app_set_volume (SoundApp* self,
                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_volume (self);
	if (old_value != value) {
		self->priv->_volume = value;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_VOLUME_PROPERTY]);
	}
}

gboolean
sound_app_get_muted (SoundApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_muted;
	return result;
}

void
sound_app_set_muted (SoundApp* self,
                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_muted (self);
	if (old_value != value) {
		self->priv->_muted = value;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_MUTED_PROPERTY]);
	}
}

void
sound_app_get_channel_map (SoundApp* self,
                           pa_channel_map * result)
{
	pa_channel_map _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_channel_map;
	*result = _tmp0_;
	return;
}

void
sound_app_set_channel_map (SoundApp* self,
                           pa_channel_map * value)
{
	pa_channel_map _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	self->priv->_channel_map = _tmp0_;
}

gboolean
sound_app_get_hidden (SoundApp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hidden;
	return result;
}

void
sound_app_set_hidden (SoundApp* self,
                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = sound_app_get_hidden (self);
	if (old_value != value) {
		self->priv->_hidden = value;
		g_object_notify_by_pspec ((GObject *) self, sound_app_properties[SOUND_APP_HIDDEN_PROPERTY]);
	}
}

static void
sound_app_class_init (SoundAppClass * klass,
                      gpointer klass_data)
{
	GSettings* _tmp0_;
	sound_app_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SoundApp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sound_app_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sound_app_set_property;
	G_OBJECT_CLASS (klass)->finalize = sound_app_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_INDEX_PROPERTY, sound_app_properties[SOUND_APP_INDEX_PROPERTY] = g_param_spec_uint ("index", "index", "index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_NAME_PROPERTY, sound_app_properties[SOUND_APP_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_DISPLAY_NAME_PROPERTY, sound_app_properties[SOUND_APP_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_ICON_PROPERTY, sound_app_properties[SOUND_APP_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_MEDIA_NAME_PROPERTY, sound_app_properties[SOUND_APP_MEDIA_NAME_PROPERTY] = g_param_spec_string ("media-name", "media-name", "media-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_VOLUME_PROPERTY, sound_app_properties[SOUND_APP_VOLUME_PROPERTY] = g_param_spec_double ("volume", "volume", "volume", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_MUTED_PROPERTY, sound_app_properties[SOUND_APP_MUTED_PROPERTY] = g_param_spec_boolean ("muted", "muted", "muted", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SOUND_APP_HIDDEN_PROPERTY, sound_app_properties[SOUND_APP_HIDDEN_PROPERTY] = g_param_spec_boolean ("hidden", "hidden", "hidden", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sound_app_signals[SOUND_APP_CHANGED_SIGNAL] = g_signal_new ("changed", SOUND_TYPE_APP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	_tmp0_ = g_settings_new ("io.elementary.switchboard.sound");
	_g_object_unref0 (sound_app_settings);
	sound_app_settings = _tmp0_;
}

static void
sound_app_instance_init (SoundApp * self,
                         gpointer klass)
{
	self->priv = sound_app_get_instance_private (self);
	self->priv->_hidden = FALSE;
}

static void
sound_app_finalize (GObject * obj)
{
	SoundApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SOUND_TYPE_APP, SoundApp);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_media_name);
	G_OBJECT_CLASS (sound_app_parent_class)->finalize (obj);
}

static GType
sound_app_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SoundAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sound_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SoundApp), 0, (GInstanceInitFunc) sound_app_instance_init, NULL };
	GType sound_app_type_id;
	sound_app_type_id = g_type_register_static (G_TYPE_OBJECT, "SoundApp", &g_define_type_info, 0);
	SoundApp_private_offset = g_type_add_instance_private (sound_app_type_id, sizeof (SoundAppPrivate));
	return sound_app_type_id;
}

GType
sound_app_get_type (void)
{
	static volatile gsize sound_app_type_id__once = 0;
	if (g_once_init_enter (&sound_app_type_id__once)) {
		GType sound_app_type_id;
		sound_app_type_id = sound_app_get_type_once ();
		g_once_init_leave (&sound_app_type_id__once, sound_app_type_id);
	}
	return sound_app_type_id__once;
}

static void
_vala_sound_app_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	SoundApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_APP, SoundApp);
	switch (property_id) {
		case SOUND_APP_INDEX_PROPERTY:
		g_value_set_uint (value, sound_app_get_index (self));
		break;
		case SOUND_APP_NAME_PROPERTY:
		g_value_set_string (value, sound_app_get_name (self));
		break;
		case SOUND_APP_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, sound_app_get_display_name (self));
		break;
		case SOUND_APP_ICON_PROPERTY:
		g_value_set_object (value, sound_app_get_icon (self));
		break;
		case SOUND_APP_MEDIA_NAME_PROPERTY:
		g_value_set_string (value, sound_app_get_media_name (self));
		break;
		case SOUND_APP_VOLUME_PROPERTY:
		g_value_set_double (value, sound_app_get_volume (self));
		break;
		case SOUND_APP_MUTED_PROPERTY:
		g_value_set_boolean (value, sound_app_get_muted (self));
		break;
		case SOUND_APP_HIDDEN_PROPERTY:
		g_value_set_boolean (value, sound_app_get_hidden (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sound_app_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	SoundApp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SOUND_TYPE_APP, SoundApp);
	switch (property_id) {
		case SOUND_APP_INDEX_PROPERTY:
		sound_app_set_index (self, g_value_get_uint (value));
		break;
		case SOUND_APP_NAME_PROPERTY:
		sound_app_set_name (self, g_value_get_string (value));
		break;
		case SOUND_APP_DISPLAY_NAME_PROPERTY:
		sound_app_set_display_name (self, g_value_get_string (value));
		break;
		case SOUND_APP_ICON_PROPERTY:
		sound_app_set_icon (self, g_value_get_object (value));
		break;
		case SOUND_APP_MEDIA_NAME_PROPERTY:
		sound_app_set_media_name (self, g_value_get_string (value));
		break;
		case SOUND_APP_VOLUME_PROPERTY:
		sound_app_set_volume (self, g_value_get_double (value));
		break;
		case SOUND_APP_MUTED_PROPERTY:
		sound_app_set_muted (self, g_value_get_boolean (value));
		break;
		case SOUND_APP_HIDDEN_PROPERTY:
		sound_app_set_hidden (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

