/* PrinterPage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PrinterPage.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2015-2023 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "io.elementary.settings.printers.h"
#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "cups/cups.h"
#include "cups/ipp.h"
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <switchboard.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	PRINTERS_PRINTER_PAGE_0_PROPERTY,
	PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY,
	PRINTERS_PRINTER_PAGE_NUM_PROPERTIES
};
static GParamSpec* printers_printer_page_properties[PRINTERS_PRINTER_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ippDelete0(var) ((var == NULL) ? NULL : (var = (ippDelete (var), NULL)))
typedef struct _Block1Data Block1Data;

struct _PrintersPrinterPagePrivate {
	PrintersPrinter* _printer;
};

struct _Block1Data {
	int _ref_count_;
	PrintersPrinterPage* self;
	GtkButton* set_default;
};

static gint PrintersPrinterPage_private_offset;
static gpointer printers_printer_page_parent_class = NULL;

static gchar* printers_printer_page_get_testprint_filename (PrintersPrinterPage* self,
                                                     const gchar* datadir);
static void printers_printer_page_print_test_page (PrintersPrinterPage* self);
static GObject * printers_printer_page_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _printers_printer_set_as_default_gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _printers_printer_page___lambda21_ (PrintersPrinterPage* self);
static void __printers_printer_page___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self);
static void _printers_printer_page___lambda22_ (Block1Data* _data1_);
static void __printers_printer_page___lambda22__printers_printer_default_changed (PrintersPrinter* _sender,
                                                                           gpointer self);
static void printers_printer_page_finalize (GObject * obj);
static GType printers_printer_page_get_type_once (void);
static void _vala_printers_printer_page_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_printers_printer_page_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
printers_printer_page_get_instance_private (PrintersPrinterPage* self)
{
	return G_STRUCT_MEMBER_P (self, PrintersPrinterPage_private_offset);
}

PrintersPrinterPage*
printers_printer_page_construct (GType object_type,
                                 PrintersPrinter* printer)
{
	PrintersPrinterPage * self = NULL;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (printer != NULL, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("printer");
	_tmp1_ = _tmp0_;
	_tmp2_ = printers_printer_get_info (printer);
	_tmp3_ = _tmp2_;
	self = (PrintersPrinterPage*) g_object_new (object_type, "activatable", TRUE, "icon", _tmp1_, "title", _tmp3_, "printer", printer, NULL);
	_g_object_unref0 (_tmp1_);
	return self;
}

PrintersPrinterPage*
printers_printer_page_new (PrintersPrinter* printer)
{
	return printers_printer_page_construct (PRINTERS_TYPE_PRINTER_PAGE, printer);
}

static gchar*
printers_printer_page_get_testprint_filename (PrintersPrinterPage* self,
                                              const gchar* datadir)
{
	gchar** testprints = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint testprints_length1;
	gint _testprints_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (datadir != NULL, NULL);
	_tmp0_ = g_strdup ("/data/testprint");
	_tmp1_ = g_strdup ("/data/testprint.ps");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	testprints = _tmp2_;
	testprints_length1 = 2;
	_testprints_size_ = testprints_length1;
	_tmp3_ = testprints;
	_tmp3__length1 = testprints_length1;
	{
		gchar** testprint_collection = NULL;
		gint testprint_collection_length1 = 0;
		gint _testprint_collection_size_ = 0;
		gint testprint_it = 0;
		testprint_collection = _tmp3_;
		testprint_collection_length1 = _tmp3__length1;
		for (testprint_it = 0; testprint_it < testprint_collection_length1; testprint_it = testprint_it + 1) {
			gchar* _tmp4_;
			gchar* testprint = NULL;
			_tmp4_ = g_strdup (testprint_collection[testprint_it]);
			testprint = _tmp4_;
			{
				gchar* filename = NULL;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp5_ = testprint;
				_tmp6_ = g_strconcat (datadir, _tmp5_, NULL);
				filename = _tmp6_;
				_tmp7_ = filename;
				if (access (_tmp7_, R_OK) == 0) {
					result = filename;
					_g_free0 (testprint);
					testprints = (_vala_array_free (testprints, testprints_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (filename);
				_g_free0 (testprint);
			}
		}
	}
	result = NULL;
	testprints = (_vala_array_free (testprints, testprints_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
printers_printer_page_print_test_page (PrintersPrinterPage* self)
{
	gchar* filename = NULL;
	gchar* datadir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	filename = NULL;
	_tmp0_ = g_getenv ("CUPS_DATADIR");
	_tmp1_ = g_strdup (_tmp0_);
	datadir = _tmp1_;
	_tmp2_ = datadir;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = datadir;
		_tmp4_ = printers_printer_page_get_testprint_filename (self, _tmp3_);
		_g_free0 (filename);
		filename = _tmp4_;
	} else {
		gchar** dirs = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_;
		gint dirs_length1;
		gint _dirs_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp5_ = g_strdup ("/usr/share/cups");
		_tmp6_ = g_strdup ("/usr/local/share/cups");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		dirs = _tmp7_;
		dirs_length1 = 2;
		_dirs_size_ = dirs_length1;
		_tmp8_ = dirs;
		_tmp8__length1 = dirs_length1;
		{
			gchar** dir_collection = NULL;
			gint dir_collection_length1 = 0;
			gint _dir_collection_size_ = 0;
			gint dir_it = 0;
			dir_collection = _tmp8_;
			dir_collection_length1 = _tmp8__length1;
			for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
				gchar* _tmp9_;
				gchar* dir = NULL;
				_tmp9_ = g_strdup (dir_collection[dir_it]);
				dir = _tmp9_;
				{
					const gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					_tmp10_ = dir;
					_tmp11_ = printers_printer_page_get_testprint_filename (self, _tmp10_);
					_g_free0 (filename);
					filename = _tmp11_;
					_tmp12_ = filename;
					if (_tmp12_ != NULL) {
						_g_free0 (dir);
						break;
					}
					_g_free0 (dir);
				}
			}
		}
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp13_ = filename;
	if (_tmp13_ != NULL) {
		gint type = 0;
		PrintersPrinter* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* printer_uri = NULL;
		gchar* resource = NULL;
		ipp_t* request = NULL;
		ipp_t* _tmp33_;
		ipp_t* _tmp34_;
		const gchar* _tmp35_;
		ipp_t* _tmp36_;
		const gchar* _tmp37_;
		ipp_t* _tmp38_;
		http_t* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp14_ = self->priv->_printer;
		_tmp15_ = printers_printer_get_printer_type (_tmp14_);
		_tmp16_ = _tmp15_;
		type = atoi (_tmp16_);
		if ((type & CUPS_PRINTER_CLASS) == CUPS_PRINTER_CLASS) {
			PrintersPrinter* _tmp17_;
			cups_dest_t _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			PrintersPrinter* _tmp21_;
			cups_dest_t _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp17_ = self->priv->_printer;
			_tmp18_ = _tmp17_->dest;
			_tmp19_ = _tmp18_.name;
			_tmp20_ = g_strdup_printf ("ipp://localhost/classes/%s", _tmp19_);
			_g_free0 (printer_uri);
			printer_uri = _tmp20_;
			_tmp21_ = self->priv->_printer;
			_tmp22_ = _tmp21_->dest;
			_tmp23_ = _tmp22_.name;
			_tmp24_ = g_strdup_printf ("/classes/%s", _tmp23_);
			_g_free0 (resource);
			resource = _tmp24_;
		} else {
			PrintersPrinter* _tmp25_;
			cups_dest_t _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			PrintersPrinter* _tmp29_;
			cups_dest_t _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp25_ = self->priv->_printer;
			_tmp26_ = _tmp25_->dest;
			_tmp27_ = _tmp26_.name;
			_tmp28_ = g_strdup_printf ("ipp://localhost/printers/%s", _tmp27_);
			_g_free0 (printer_uri);
			printer_uri = _tmp28_;
			_tmp29_ = self->priv->_printer;
			_tmp30_ = _tmp29_->dest;
			_tmp31_ = _tmp30_.name;
			_tmp32_ = g_strdup_printf ("/printers/%s", _tmp31_);
			_g_free0 (resource);
			resource = _tmp32_;
		}
		_tmp33_ = ippNewRequest (IPP_PRINT_JOB);
		request = _tmp33_;
		_tmp34_ = request;
		_tmp35_ = printer_uri;
		ippAddString (_tmp34_, IPP_TAG_OPERATION, IPP_TAG_URI, "printer-uri", NULL, _tmp35_);
		_tmp36_ = request;
		_tmp37_ = cupsUser ();
		ippAddString (_tmp36_, IPP_TAG_OPERATION, IPP_TAG_NAME, "requesting-user-name", NULL, _tmp37_);
		_tmp38_ = request;
		ippAddString (_tmp38_, IPP_TAG_OPERATION, IPP_TAG_NAME, "job-name", NULL, _ ("Test page"));
		_tmp39_ = CUPS_HTTP_DEFAULT;
		_tmp40_ = resource;
		_tmp41_ = filename;
		request = cupsDoFileRequest (_tmp39_, request, _tmp40_, _tmp41_);
		_ippDelete0 (request);
		_g_free0 (resource);
		_g_free0 (printer_uri);
	}
	_g_free0 (datadir);
	_g_free0 (filename);
}

PrintersPrinter*
printers_printer_page_get_printer (PrintersPrinterPage* self)
{
	PrintersPrinter* result;
	PrintersPrinter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_printer;
	result = _tmp0_;
	return result;
}

static void
printers_printer_page_set_printer (PrintersPrinterPage* self,
                                   PrintersPrinter* value)
{
	PrintersPrinter* old_value;
	g_return_if_fail (self != NULL);
	old_value = printers_printer_page_get_printer (self);
	if (old_value != value) {
		self->priv->_printer = value;
		g_object_notify_by_pspec ((GObject *) self, printers_printer_page_properties[PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY]);
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PrintersPrinterPage* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->set_default);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_printers_printer_set_as_default_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	printers_printer_set_as_default ((PrintersPrinter*) self);
}

static void
_printers_printer_page___lambda21_ (PrintersPrinterPage* self)
{
	printers_printer_page_print_test_page (self);
}

static void
__printers_printer_page___lambda21__gtk_button_clicked (GtkButton* _sender,
                                                        gpointer self)
{
	_printers_printer_page___lambda21_ ((PrintersPrinterPage*) self);
}

static void
_printers_printer_page___lambda22_ (Block1Data* _data1_)
{
	PrintersPrinterPage* self;
	GtkButton* _tmp0_;
	PrintersPrinter* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data1_->self;
	_tmp0_ = _data1_->set_default;
	_tmp1_ = self->priv->_printer;
	_tmp2_ = printers_printer_get_is_default (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, !_tmp3_);
}

static void
__printers_printer_page___lambda22__printers_printer_default_changed (PrintersPrinter* _sender,
                                                                      gpointer self)
{
	_printers_printer_page___lambda22_ (self);
}

static GObject *
printers_printer_page_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PrintersPrinterPage * self;
	Block1Data* _data1_;
	PrintersJobsView* jobs_view = NULL;
	PrintersPrinter* _tmp0_;
	PrintersJobsView* _tmp1_;
	GtkStack* stack = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkStack* _tmp3_;
	PrintersJobsView* _tmp4_;
	GtkStack* _tmp5_;
	PrintersPrinter* _tmp6_;
	PrintersOptionsPage* _tmp7_;
	PrintersOptionsPage* _tmp8_;
	GtkStack* _tmp9_;
	PrintersPrinter* _tmp10_;
	PrintersSuppliesView* _tmp11_;
	PrintersSuppliesView* _tmp12_;
	GtkStackSwitcher* stack_switcher = NULL;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GtkStackSwitcher* _tmp15_ = NULL;
	GtkSizeGroup* sizegroup = NULL;
	GtkSizeGroup* _tmp16_;
	GtkWidget* switcher_child = NULL;
	GtkStackSwitcher* _tmp17_;
	GtkWidget* _tmp18_;
	GtkWidget* _tmp19_;
	GtkBox* box = NULL;
	GtkBox* _tmp26_;
	GtkBox* _tmp27_;
	GtkStackSwitcher* _tmp28_;
	GtkBox* _tmp29_;
	GtkStack* _tmp30_;
	GtkBox* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	PrintersPrinter* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	GtkButton* _tmp37_;
	PrintersPrinter* _tmp38_;
	GtkButton* print_test = NULL;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	PrintersPrinter* _tmp41_;
	PrintersPrinter* _tmp42_;
	GtkSwitch* _tmp43_;
	GtkSwitch* _tmp44_;
	PrintersPrinter* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	GtkButton* _tmp48_;
	GtkSwitch* _tmp49_;
	GtkSwitch* _tmp50_;
	gboolean _tmp51_;
	gboolean _tmp52_;
	GtkSwitch* _tmp53_;
	GtkSwitch* _tmp54_;
	PrintersPrinter* _tmp55_;
	GtkSwitch* _tmp56_;
	GtkSwitch* _tmp57_;
	GtkButton* _tmp58_;
	PrintersPrinter* _tmp59_;
	parent_class = G_OBJECT_CLASS (printers_printer_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER_PAGE, PrintersPrinterPage);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = self->priv->_printer;
	_tmp1_ = printers_jobs_view_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	jobs_view = _tmp1_;
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_vhomogeneous (_tmp2_, FALSE);
	g_object_ref_sink (_tmp2_);
	stack = _tmp2_;
	_tmp3_ = stack;
	_tmp4_ = jobs_view;
	gtk_stack_add_titled (_tmp3_, (GtkWidget*) _tmp4_, "general", _ ("Print Queue"));
	_tmp5_ = stack;
	_tmp6_ = self->priv->_printer;
	_tmp7_ = printers_options_page_new (_tmp6_);
	g_object_ref_sink (_tmp7_);
	_tmp8_ = _tmp7_;
	gtk_stack_add_titled (_tmp5_, (GtkWidget*) _tmp8_, "options", _ ("Page Setup"));
	_g_object_unref0 (_tmp8_);
	_tmp9_ = stack;
	_tmp10_ = self->priv->_printer;
	_tmp11_ = printers_supplies_view_new (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp12_, "supplies", _ ("Settings & Supplies"));
	_g_object_unref0 (_tmp12_);
	_tmp13_ = stack;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_tmp15_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
	gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
	gtk_stack_switcher_set_stack (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	stack_switcher = _tmp15_;
	_tmp16_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	sizegroup = _tmp16_;
	_tmp17_ = stack_switcher;
	_tmp18_ = gtk_widget_get_first_child ((GtkWidget*) _tmp17_);
	_tmp19_ = _g_object_ref0 (_tmp18_);
	switcher_child = _tmp19_;
	while (TRUE) {
		GtkWidget* _tmp20_;
		GtkSizeGroup* _tmp21_;
		GtkWidget* _tmp22_;
		GtkWidget* _tmp23_;
		GtkWidget* _tmp24_;
		GtkWidget* _tmp25_;
		_tmp20_ = switcher_child;
		if (!(_tmp20_ != NULL)) {
			break;
		}
		_tmp21_ = sizegroup;
		_tmp22_ = switcher_child;
		gtk_size_group_add_widget (_tmp21_, _tmp22_);
		_tmp23_ = switcher_child;
		_tmp24_ = gtk_widget_get_next_sibling (_tmp23_);
		_tmp25_ = _g_object_ref0 (_tmp24_);
		_g_object_unref0 (switcher_child);
		switcher_child = _tmp25_;
	}
	_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 24);
	g_object_ref_sink (_tmp26_);
	box = _tmp26_;
	_tmp27_ = box;
	_tmp28_ = stack_switcher;
	gtk_box_append (_tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = box;
	_tmp30_ = stack;
	gtk_box_append (_tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp31_);
	switchboard_settings_page_set_show_end_title_buttons ((SwitchboardSettingsPage*) self, TRUE);
	_tmp32_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Set as Default"));
	_data1_->set_default = _tmp32_;
	_tmp33_ = _data1_->set_default;
	_tmp34_ = self->priv->_printer;
	_tmp35_ = printers_printer_get_is_default (_tmp34_);
	_tmp36_ = _tmp35_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp33_, !_tmp36_);
	_tmp37_ = _data1_->set_default;
	_tmp38_ = self->priv->_printer;
	g_signal_connect_object (_tmp37_, "clicked", (GCallback) _printers_printer_set_as_default_gtk_button_clicked, _tmp38_, 0);
	_tmp39_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Print Test Page"));
	print_test = _tmp39_;
	_tmp40_ = print_test;
	g_signal_connect_object (_tmp40_, "clicked", (GCallback) __printers_printer_page___lambda21__gtk_button_clicked, self, 0);
	_tmp41_ = self->priv->_printer;
	g_object_bind_property_with_closures ((GObject*) _tmp41_, "info", (GObject*) self, "title", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp42_ = self->priv->_printer;
	g_object_bind_property_with_closures ((GObject*) _tmp42_, "location", (GObject*) self, "description", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp43_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = self->priv->_printer;
	_tmp46_ = printers_printer_get_is_enabled (_tmp45_);
	_tmp47_ = _tmp46_;
	gtk_switch_set_active (_tmp44_, _tmp47_);
	_tmp48_ = print_test;
	_tmp49_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp50_ = _tmp49_;
	_tmp51_ = gtk_switch_get_active (_tmp50_);
	_tmp52_ = _tmp51_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp48_, _tmp52_);
	_tmp53_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = self->priv->_printer;
	g_object_bind_property_with_closures ((GObject*) _tmp54_, "active", (GObject*) _tmp55_, "is-enabled", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp56_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp57_ = _tmp56_;
	_tmp58_ = print_test;
	g_object_bind_property_with_closures ((GObject*) _tmp57_, "active", (GObject*) _tmp58_, "sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp59_ = self->priv->_printer;
	g_signal_connect_data (_tmp59_, "default-changed", (GCallback) __printers_printer_page___lambda22__printers_printer_default_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_g_object_unref0 (print_test);
	_g_object_unref0 (box);
	_g_object_unref0 (switcher_child);
	_g_object_unref0 (sizegroup);
	_g_object_unref0 (stack_switcher);
	_g_object_unref0 (stack);
	_g_object_unref0 (jobs_view);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return obj;
}

static void
printers_printer_page_class_init (PrintersPrinterPageClass * klass,
                                  gpointer klass_data)
{
	printers_printer_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintersPrinterPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_printers_printer_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_printers_printer_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = printers_printer_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = printers_printer_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY, printers_printer_page_properties[PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY] = g_param_spec_object ("printer", "printer", "printer", PRINTERS_TYPE_PRINTER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
printers_printer_page_instance_init (PrintersPrinterPage * self,
                                     gpointer klass)
{
	self->priv = printers_printer_page_get_instance_private (self);
}

static void
printers_printer_page_finalize (GObject * obj)
{
	PrintersPrinterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PRINTERS_TYPE_PRINTER_PAGE, PrintersPrinterPage);
	G_OBJECT_CLASS (printers_printer_page_parent_class)->finalize (obj);
}

static GType
printers_printer_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintersPrinterPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) printers_printer_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintersPrinterPage), 0, (GInstanceInitFunc) printers_printer_page_instance_init, NULL };
	GType printers_printer_page_type_id;
	printers_printer_page_type_id = g_type_register_static (SWITCHBOARD_TYPE_SETTINGS_PAGE, "PrintersPrinterPage", &g_define_type_info, 0);
	PrintersPrinterPage_private_offset = g_type_add_instance_private (printers_printer_page_type_id, sizeof (PrintersPrinterPagePrivate));
	return printers_printer_page_type_id;
}

GType
printers_printer_page_get_type (void)
{
	static volatile gsize printers_printer_page_type_id__once = 0;
	if (g_once_init_enter (&printers_printer_page_type_id__once)) {
		GType printers_printer_page_type_id;
		printers_printer_page_type_id = printers_printer_page_get_type_once ();
		g_once_init_leave (&printers_printer_page_type_id__once, printers_printer_page_type_id);
	}
	return printers_printer_page_type_id__once;
}

static void
_vala_printers_printer_page_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	PrintersPrinterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER_PAGE, PrintersPrinterPage);
	switch (property_id) {
		case PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY:
		g_value_set_object (value, printers_printer_page_get_printer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_printers_printer_page_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	PrintersPrinterPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PRINTERS_TYPE_PRINTER_PAGE, PrintersPrinterPage);
	switch (property_id) {
		case PRINTERS_PRINTER_PAGE_PRINTER_PROPERTY:
		printers_printer_page_set_printer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

