/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
* Copyright (c) 2017 elementary, LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "keyboard.h"
#include <adwaita.h>
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <granite-7.h>
#include <gmodule.h>
#include <ibus.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	KEYBOARD_PLUG_0_PROPERTY,
	KEYBOARD_PLUG_NUM_PROPERTIES
};
static GParamSpec* keyboard_plug_properties[KEYBOARD_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KEYBOARD_SHORTCUTS_TYPE_PAGE (keyboard_shortcuts_page_get_type ())
#define KEYBOARD_SHORTCUTS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBOARD_SHORTCUTS_TYPE_PAGE, KeyboardShortcutsPage))
#define KEYBOARD_SHORTCUTS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBOARD_SHORTCUTS_TYPE_PAGE, KeyboardShortcutsPageClass))
#define KEYBOARD_SHORTCUTS_IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBOARD_SHORTCUTS_TYPE_PAGE))
#define KEYBOARD_SHORTCUTS_IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBOARD_SHORTCUTS_TYPE_PAGE))
#define KEYBOARD_SHORTCUTS_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBOARD_SHORTCUTS_TYPE_PAGE, KeyboardShortcutsPageClass))

typedef struct _KeyboardShortcutsPage KeyboardShortcutsPage;
typedef struct _KeyboardShortcutsPageClass KeyboardShortcutsPageClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _KeyboardPlugSearchData KeyboardPlugSearchData;

struct _KeyboardPlugPrivate {
	AdwToolbarView* toolbarview;
	GtkStack* stack;
};

struct _KeyboardPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	KeyboardPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
};

static gint KeyboardPlug_private_offset;
static gpointer keyboard_plug_parent_class = NULL;
GSettings* keyboard_plug_ibus_general_settings = NULL;

static GtkWidget* keyboard_plug_real_get_widget (SwitchboardPlug* base);
VALA_EXTERN KeyboardShortcutsPage* keyboard_shortcuts_page_new (void);
VALA_EXTERN KeyboardShortcutsPage* keyboard_shortcuts_page_construct (GType object_type);
VALA_EXTERN GType keyboard_shortcuts_page_get_type (void) G_GNUC_CONST ;
static void keyboard_plug_real_shown (SwitchboardPlug* base);
static void keyboard_plug_real_hidden (SwitchboardPlug* base);
static void keyboard_plug_real_search_callback (SwitchboardPlug* base,
                                         const gchar* location);
VALA_EXTERN void keyboard_shortcuts_page_open_custom_shortcuts (KeyboardShortcutsPage* self);
static void keyboard_plug_real_search_data_free (gpointer _data);
static void keyboard_plug_real_search (SwitchboardPlug* base,
                                const gchar* search,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
static gboolean keyboard_plug_real_search_co (KeyboardPlugSearchData* _data_);
static void keyboard_plug_finalize (GObject * obj);
static GType keyboard_plug_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
keyboard_plug_get_instance_private (KeyboardPlug* self)
{
	return G_STRUCT_MEMBER_P (self, KeyboardPlug_private_offset);
}

KeyboardPlug*
keyboard_plug_construct (GType object_type)
{
	KeyboardPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard", "Layout");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard/layout", "Layout");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard/behavior", "Behavior");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard/inputmethod", "Input Method");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard/shortcuts", "Shortcuts");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/keyboard/shortcuts/custom", "Custom Shortcuts");
	self = (KeyboardPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.keyboard", "display-name", _ ("Keyboard"), "description", _ ("Configure keyboard behavior, layouts, and shortcuts"), "icon", "preferences-desktop-keyboard", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

KeyboardPlug*
keyboard_plug_new (void)
{
	return keyboard_plug_construct (KEYBOARD_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
keyboard_plug_real_get_widget (SwitchboardPlug* base)
{
	KeyboardPlug * self;
	AdwToolbarView* _tmp0_;
	AdwToolbarView* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* result;
	self = (KeyboardPlug*) base;
	_tmp0_ = self->priv->toolbarview;
	if (_tmp0_ == NULL) {
		GdkDisplay* _tmp1_;
		GtkIconTheme* _tmp2_;
		GtkStack* _tmp3_;
		GtkStack* _tmp4_;
		KeyboardLayoutPagePage* _tmp5_;
		KeyboardLayoutPagePage* _tmp6_;
		GtkStack* _tmp7_;
		KeyboardInputMethodPagePage* _tmp8_;
		KeyboardInputMethodPagePage* _tmp9_;
		GtkStack* _tmp10_;
		KeyboardShortcutsPage* _tmp11_;
		KeyboardShortcutsPage* _tmp12_;
		GtkStack* _tmp13_;
		KeyboardBehaviourPage* _tmp14_;
		KeyboardBehaviourPage* _tmp15_;
		GtkStackSwitcher* stack_switcher = NULL;
		GtkStack* _tmp16_;
		GtkStack* _tmp17_;
		GtkStackSwitcher* _tmp18_ = NULL;
		GtkSizeGroup* size_group = NULL;
		GtkSizeGroup* _tmp19_;
		GtkWidget* switcher_child = NULL;
		GtkStackSwitcher* _tmp20_;
		GtkWidget* _tmp21_;
		AdwHeaderBar* headerbar = NULL;
		GtkStackSwitcher* _tmp27_;
		GtkWidget* _tmp28_;
		AdwHeaderBar* _tmp29_ = NULL;
		AdwHeaderBar* _tmp30_;
		GtkStack* _tmp31_;
		GtkWidget* _tmp32_;
		AdwToolbarView* _tmp33_ = NULL;
		AdwToolbarView* _tmp34_;
		AdwHeaderBar* _tmp35_;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gtk_icon_theme_get_for_display (_tmp1_);
		gtk_icon_theme_add_resource_path (_tmp2_, "/io/elementary/settings/keyboard");
		_tmp3_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp3_;
		_tmp4_ = self->priv->stack;
		_tmp5_ = keyboard_layout_page_page_new ();
		g_object_ref_sink (_tmp5_);
		_tmp6_ = _tmp5_;
		gtk_stack_add_titled (_tmp4_, (GtkWidget*) _tmp6_, "layout", _ ("Layout"));
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->stack;
		_tmp8_ = keyboard_input_method_page_page_new ();
		g_object_ref_sink (_tmp8_);
		_tmp9_ = _tmp8_;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp9_, "inputmethod", _ ("Input Method"));
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->priv->stack;
		_tmp11_ = keyboard_shortcuts_page_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_stack_add_titled (_tmp10_, (GtkWidget*) _tmp12_, "shortcuts", _ ("Shortcuts"));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = self->priv->stack;
		_tmp14_ = keyboard_behaviour_page_new ();
		g_object_ref_sink (_tmp14_);
		_tmp15_ = _tmp14_;
		gtk_stack_add_titled (_tmp13_, (GtkWidget*) _tmp15_, "behavior", _ ("Behavior"));
		_g_object_unref0 (_tmp15_);
		_tmp16_ = self->priv->stack;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_tmp18_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		gtk_stack_switcher_set_stack (_tmp18_, _tmp17_);
		_g_object_unref0 (_tmp17_);
		g_object_ref_sink (_tmp18_);
		stack_switcher = _tmp18_;
		_tmp19_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		size_group = _tmp19_;
		_tmp20_ = stack_switcher;
		_tmp21_ = gtk_widget_get_first_child ((GtkWidget*) _tmp20_);
		switcher_child = _tmp21_;
		while (TRUE) {
			GtkWidget* _tmp22_;
			GtkSizeGroup* _tmp23_;
			GtkWidget* _tmp24_;
			GtkWidget* _tmp25_;
			GtkWidget* _tmp26_;
			_tmp22_ = switcher_child;
			if (!(_tmp22_ != NULL)) {
				break;
			}
			_tmp23_ = size_group;
			_tmp24_ = switcher_child;
			gtk_size_group_add_widget (_tmp23_, _tmp24_);
			_tmp25_ = switcher_child;
			_tmp26_ = gtk_widget_get_next_sibling (_tmp25_);
			switcher_child = _tmp26_;
		}
		_tmp27_ = stack_switcher;
		_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
		_tmp29_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_title_widget (_tmp29_, _tmp28_);
		_g_object_unref0 (_tmp28_);
		g_object_ref_sink (_tmp29_);
		headerbar = _tmp29_;
		_tmp30_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp30_, GRANITE_STYLE_CLASS_FLAT);
		_tmp31_ = self->priv->stack;
		_tmp32_ = _g_object_ref0 ((GtkWidget*) _tmp31_);
		_tmp33_ = (AdwToolbarView*) adw_toolbar_view_new ();
		adw_toolbar_view_set_content (_tmp33_, _tmp32_);
		_g_object_unref0 (_tmp32_);
		g_object_ref_sink (_tmp33_);
		_g_object_unref0 (self->priv->toolbarview);
		self->priv->toolbarview = _tmp33_;
		_tmp34_ = self->priv->toolbarview;
		_tmp35_ = headerbar;
		adw_toolbar_view_add_top_bar (_tmp34_, (GtkWidget*) _tmp35_);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (size_group);
		_g_object_unref0 (stack_switcher);
	}
	_tmp36_ = self->priv->toolbarview;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	result = _tmp37_;
	return result;
}

static void
keyboard_plug_real_shown (SwitchboardPlug* base)
{
	KeyboardPlug * self;
	self = (KeyboardPlug*) base;
}

static void
keyboard_plug_real_hidden (SwitchboardPlug* base)
{
	KeyboardPlug * self;
	self = (KeyboardPlug*) base;
}

static void
keyboard_plug_real_search_callback (SwitchboardPlug* base,
                                    const gchar* location)
{
	KeyboardPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	self = (KeyboardPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Shortcuts")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, "shortcuts");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Behavior")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, "behavior");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Input Method")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp5_;
				_tmp5_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp5_, "inputmethod");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Layout")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp6_;
				_tmp6_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp6_, "layout");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkStack* _tmp7_;
				GtkStack* _tmp8_;
				GtkWidget* _tmp9_;
				_tmp7_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp7_, "shortcuts");
				_tmp8_ = self->priv->stack;
				_tmp9_ = gtk_stack_get_child_by_name (_tmp8_, "shortcuts");
				keyboard_shortcuts_page_open_custom_shortcuts (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, KEYBOARD_SHORTCUTS_TYPE_PAGE, KeyboardShortcutsPage));
				break;
			}
		}
	}
}

static void
keyboard_plug_real_search_data_free (gpointer _data)
{
	KeyboardPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (KeyboardPlugSearchData, _data_);
}

static void
keyboard_plug_real_search (SwitchboardPlug* base,
                           const gchar* search,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	KeyboardPlug * self;
	KeyboardPlugSearchData* _data_;
	KeyboardPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (KeyboardPlug*) base;
	_data_ = g_slice_new0 (KeyboardPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, keyboard_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	keyboard_plug_real_search_co (_data_);
}

static GeeTreeMap*
keyboard_plug_search_finish (SwitchboardPlug* base,
                             GAsyncResult* _res_)
{
	GeeTreeMap* result;
	KeyboardPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
keyboard_plug_real_search_co (KeyboardPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Layout"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "Layout");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp8_, _ ("Layout"), _ ("Switch layout"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "Layout");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp12_, _ ("Layout"), _ ("Compose Key"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "Layout");
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp16_, _ ("Layout"), _ ("⌘ key behavior"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, "Layout");
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp20_, _ ("Layout"), _ ("Caps Lock behavior"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, "Layout");
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s", _data_->_tmp24_, _ ("Input Method"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, "Input Method");
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp28_, _ ("Input Method"), _ ("Switch engines"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, "Input Method");
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp32_, _ ("Input Method"), _ ("Show candidate window"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, "Input Method");
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp36_, _ ("Input Method"), _ ("Embed preedit text in application window"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, "Input Method");
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s", _data_->_tmp40_, _ ("Shortcuts"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp42_, "Shortcuts");
	_g_free0 (_data_->_tmp42_);
	_data_->_tmp43_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp45_ = g_strdup_printf ("%s → %s", _data_->_tmp44_, _ ("Behavior"));
	_data_->_tmp46_ = _data_->_tmp45_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp46_, "Behavior");
	_g_free0 (_data_->_tmp46_);
	_data_->_tmp47_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp48_, _ ("Behavior"), _ ("Show On-screen Keyboard"));
	_data_->_tmp50_ = _data_->_tmp49_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp50_, "Behavior");
	_g_free0 (_data_->_tmp50_);
	_data_->_tmp51_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp53_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp52_, _ ("Behavior"), _ ("Bounce Keys"));
	_data_->_tmp54_ = _data_->_tmp53_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp54_, "Behavior");
	_g_free0 (_data_->_tmp54_);
	_data_->_tmp55_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp56_ = _data_->_tmp55_;
	_data_->_tmp57_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp56_, _ ("Behavior"), _ ("Cursor Blinking"));
	_data_->_tmp58_ = _data_->_tmp57_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp58_, "Behavior");
	_g_free0 (_data_->_tmp58_);
	_data_->_tmp59_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp60_ = _data_->_tmp59_;
	_data_->_tmp61_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp60_, _ ("Behavior"), _ ("Repeat Keys"));
	_data_->_tmp62_ = _data_->_tmp61_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp62_, "Behavior");
	_g_free0 (_data_->_tmp62_);
	_data_->_tmp63_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp64_ = _data_->_tmp63_;
	_data_->_tmp65_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp64_, _ ("Behavior"), _ ("Slow Keys"));
	_data_->_tmp66_ = _data_->_tmp65_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp66_, "Behavior");
	_g_free0 (_data_->_tmp66_);
	_data_->_tmp67_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp68_ = _data_->_tmp67_;
	_data_->_tmp69_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp68_, _ ("Behavior"), _ ("Sticky Keys"));
	_data_->_tmp70_ = _data_->_tmp69_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp70_, "Behavior");
	_g_free0 (_data_->_tmp70_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
keyboard_plug_class_init (KeyboardPlugClass * klass,
                          gpointer klass_data)
{
	GSettings* _tmp0_;
	keyboard_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KeyboardPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) keyboard_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) keyboard_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) keyboard_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) keyboard_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) keyboard_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) keyboard_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = keyboard_plug_finalize;
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.general");
	_g_object_unref0 (keyboard_plug_ibus_general_settings);
	keyboard_plug_ibus_general_settings = _tmp0_;
}

static void
keyboard_plug_instance_init (KeyboardPlug * self,
                             gpointer klass)
{
	self->priv = keyboard_plug_get_instance_private (self);
}

static void
keyboard_plug_finalize (GObject * obj)
{
	KeyboardPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBOARD_TYPE_PLUG, KeyboardPlug);
	_g_object_unref0 (self->priv->toolbarview);
	_g_object_unref0 (self->priv->stack);
	G_OBJECT_CLASS (keyboard_plug_parent_class)->finalize (obj);
}

static GType
keyboard_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KeyboardPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keyboard_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeyboardPlug), 0, (GInstanceInitFunc) keyboard_plug_instance_init, NULL };
	GType keyboard_plug_type_id;
	keyboard_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "KeyboardPlug", &g_define_type_info, 0);
	KeyboardPlug_private_offset = g_type_add_instance_private (keyboard_plug_type_id, sizeof (KeyboardPlugPrivate));
	return keyboard_plug_type_id;
}

GType
keyboard_plug_get_type (void)
{
	static volatile gsize keyboard_plug_type_id__once = 0;
	if (g_once_init_enter (&keyboard_plug_type_id__once)) {
		GType keyboard_plug_type_id;
		keyboard_plug_type_id = keyboard_plug_get_type_once ();
		g_once_init_leave (&keyboard_plug_type_id__once, keyboard_plug_type_id);
	}
	return keyboard_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	KeyboardPlug* plug = NULL;
	KeyboardPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:139: Activating Keyboard plug");
	ibus_init ();
	_tmp0_ = keyboard_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

