/* Monitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Monitor.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC.
 *
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this software; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "display.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DISPLAY_MONITOR_0_PROPERTY,
	DISPLAY_MONITOR_CONNECTOR_PROPERTY,
	DISPLAY_MONITOR_VENDOR_PROPERTY,
	DISPLAY_MONITOR_PRODUCT_PROPERTY,
	DISPLAY_MONITOR_SERIAL_PROPERTY,
	DISPLAY_MONITOR_HASH_PROPERTY,
	DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY,
	DISPLAY_MONITOR_IS_BUILTIN_PROPERTY,
	DISPLAY_MONITOR_MODES_PROPERTY,
	DISPLAY_MONITOR_CURRENT_MODE_PROPERTY,
	DISPLAY_MONITOR_PREFERRED_MODE_PROPERTY,
	DISPLAY_MONITOR_NUM_PROPERTIES
};
static GParamSpec* display_monitor_properties[DISPLAY_MONITOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _DisplayMonitorPrivate {
	gchar* _connector;
	gchar* _vendor;
	gchar* _product;
	gchar* _serial;
	gchar* _display_name;
	gboolean _is_builtin;
	GeeLinkedList* _modes;
};

static gint DisplayMonitor_private_offset;
static gpointer display_monitor_parent_class = NULL;

static GObject * display_monitor_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void display_monitor_finalize (GObject * obj);
static GType display_monitor_get_type_once (void);
static void _vala_display_monitor_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_display_monitor_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
display_monitor_get_instance_private (DisplayMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, DisplayMonitor_private_offset);
}

gdouble
display_monitor_get_max_scale (DisplayMonitor* self)
{
	gdouble max_scale = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	max_scale = 1.0;
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mode_index = 0;
		_tmp0_ = self->priv->_modes;
		_mode_list = _tmp0_;
		_tmp1_ = _mode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mode_size = _tmp3_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitorMode* _tmp8_;
			gdouble* _tmp9_;
			gint _tmp9__length1;
			_mode_index = _mode_index + 1;
			_tmp4_ = _mode_index;
			_tmp5_ = _mode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp7_;
			_tmp8_ = mode;
			_tmp9_ = _tmp8_->supported_scales;
			_tmp9__length1 = _tmp8_->supported_scales_length1;
			{
				gdouble* scale_collection = NULL;
				gint scale_collection_length1 = 0;
				gint _scale_collection_size_ = 0;
				gint scale_it = 0;
				scale_collection = _tmp9_;
				scale_collection_length1 = _tmp9__length1;
				for (scale_it = 0; scale_it < scale_collection_length1; scale_it = scale_it + 1) {
					gdouble scale = 0.0;
					scale = scale_collection[scale_it];
					{
						max_scale = MAX (max_scale, scale);
					}
				}
			}
			_g_object_unref0 (mode);
		}
	}
	result = max_scale;
	return result;
}

DisplayMonitorMode*
display_monitor_get_mode_by_id (DisplayMonitor* self,
                                const gchar* id)
{
	DisplayMonitorMode* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mode_index = 0;
		_tmp0_ = self->priv->_modes;
		_mode_list = _tmp0_;
		_tmp1_ = _mode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mode_size = _tmp3_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitorMode* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_mode_index = _mode_index + 1;
			_tmp4_ = _mode_index;
			_tmp5_ = _mode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp7_;
			_tmp8_ = mode;
			_tmp9_ = display_monitor_mode_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, id) == 0) {
				result = mode;
				return result;
			}
			_g_object_unref0 (mode);
		}
	}
	result = NULL;
	return result;
}

DisplayMonitor*
display_monitor_construct (GType object_type)
{
	DisplayMonitor * self = NULL;
	self = (DisplayMonitor*) g_object_new (object_type, NULL);
	return self;
}

DisplayMonitor*
display_monitor_new (void)
{
	return display_monitor_construct (DISPLAY_TYPE_MONITOR);
}

const gchar*
display_monitor_get_connector (DisplayMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connector;
	result = _tmp0_;
	return result;
}

void
display_monitor_set_connector (DisplayMonitor* self,
                               const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_connector (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_connector);
		self->priv->_connector = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_CONNECTOR_PROPERTY]);
	}
}

const gchar*
display_monitor_get_vendor (DisplayMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_vendor;
	result = _tmp0_;
	return result;
}

void
display_monitor_set_vendor (DisplayMonitor* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_vendor (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_vendor);
		self->priv->_vendor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_VENDOR_PROPERTY]);
	}
}

const gchar*
display_monitor_get_product (DisplayMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_product;
	result = _tmp0_;
	return result;
}

void
display_monitor_set_product (DisplayMonitor* self,
                             const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_product (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_product);
		self->priv->_product = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_PRODUCT_PROPERTY]);
	}
}

const gchar*
display_monitor_get_serial (DisplayMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_serial;
	result = _tmp0_;
	return result;
}

void
display_monitor_set_serial (DisplayMonitor* self,
                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_serial (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_serial);
		self->priv->_serial = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_SERIAL_PROPERTY]);
	}
}

guint
display_monitor_get_hash (DisplayMonitor* self)
{
	guint result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	guint _tmp10_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_connector;
	_tmp1_ = self->priv->_vendor;
	_tmp2_ = g_strconcat (_tmp0_, _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_product;
	_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->_serial;
	_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_str_hash (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	result = _tmp10_;
	return result;
}

const gchar*
display_monitor_get_display_name (DisplayMonitor* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}

void
display_monitor_set_display_name (DisplayMonitor* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_display_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_display_name);
		self->priv->_display_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY]);
	}
}

gboolean
display_monitor_get_is_builtin (DisplayMonitor* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_builtin;
	return result;
}

void
display_monitor_set_is_builtin (DisplayMonitor* self,
                                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_is_builtin (self);
	if (old_value != value) {
		self->priv->_is_builtin = value;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_IS_BUILTIN_PROPERTY]);
	}
}

GeeLinkedList*
display_monitor_get_modes (DisplayMonitor* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_modes;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
display_monitor_set_modes (DisplayMonitor* self,
                           GeeLinkedList* value)
{
	GeeLinkedList* old_value;
	g_return_if_fail (self != NULL);
	old_value = display_monitor_get_modes (self);
	if (old_value != value) {
		GeeLinkedList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_modes);
		self->priv->_modes = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, display_monitor_properties[DISPLAY_MONITOR_MODES_PROPERTY]);
	}
}

DisplayMonitorMode*
display_monitor_get_current_mode (DisplayMonitor* self)
{
	DisplayMonitorMode* result;
	GeeLinkedList* _tmp11_;
	gpointer _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mode_index = 0;
		_tmp0_ = self->priv->_modes;
		_mode_list = _tmp0_;
		_tmp1_ = _mode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mode_size = _tmp3_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitorMode* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_mode_index = _mode_index + 1;
			_tmp4_ = _mode_index;
			_tmp5_ = _mode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp7_;
			_tmp8_ = mode;
			_tmp9_ = display_monitor_mode_get_is_current (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				result = mode;
				return result;
			}
			_g_object_unref0 (mode);
		}
	}
	_tmp11_ = self->priv->_modes;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, 0);
	result = (DisplayMonitorMode*) _tmp12_;
	return result;
}

DisplayMonitorMode*
display_monitor_get_preferred_mode (DisplayMonitor* self)
{
	DisplayMonitorMode* result;
	GeeLinkedList* _tmp11_;
	gpointer _tmp12_;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _mode_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _mode_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mode_index = 0;
		_tmp0_ = self->priv->_modes;
		_mode_list = _tmp0_;
		_tmp1_ = _mode_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mode_size = _tmp3_;
		_mode_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			DisplayMonitorMode* mode = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			DisplayMonitorMode* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_mode_index = _mode_index + 1;
			_tmp4_ = _mode_index;
			_tmp5_ = _mode_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mode_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mode_index);
			mode = (DisplayMonitorMode*) _tmp7_;
			_tmp8_ = mode;
			_tmp9_ = display_monitor_mode_get_is_preferred (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_) {
				result = mode;
				return result;
			}
			_g_object_unref0 (mode);
		}
	}
	_tmp11_ = self->priv->_modes;
	_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, 0);
	result = (DisplayMonitorMode*) _tmp12_;
	return result;
}

static GObject *
display_monitor_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	DisplayMonitor * self;
	GeeLinkedList* _tmp0_;
	GeeLinkedList* _tmp1_;
	parent_class = G_OBJECT_CLASS (display_monitor_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_MONITOR, DisplayMonitor);
	_tmp0_ = gee_linked_list_new (DISPLAY_TYPE_MONITOR_MODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	display_monitor_set_modes (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
display_monitor_class_init (DisplayMonitorClass * klass,
                            gpointer klass_data)
{
	display_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DisplayMonitor_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_display_monitor_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_display_monitor_set_property;
	G_OBJECT_CLASS (klass)->constructor = display_monitor_constructor;
	G_OBJECT_CLASS (klass)->finalize = display_monitor_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_CONNECTOR_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_CONNECTOR_PROPERTY] = g_param_spec_string ("connector", "connector", "connector", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_VENDOR_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_VENDOR_PROPERTY] = g_param_spec_string ("vendor", "vendor", "vendor", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_PRODUCT_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_PRODUCT_PROPERTY] = g_param_spec_string ("product", "product", "product", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_SERIAL_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_SERIAL_PROPERTY] = g_param_spec_string ("serial", "serial", "serial", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_HASH_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_HASH_PROPERTY] = g_param_spec_uint ("hash", "hash", "hash", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_IS_BUILTIN_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_IS_BUILTIN_PROPERTY] = g_param_spec_boolean ("is-builtin", "is-builtin", "is-builtin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_MODES_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_MODES_PROPERTY] = g_param_spec_object ("modes", "modes", "modes", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_CURRENT_MODE_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_CURRENT_MODE_PROPERTY] = g_param_spec_object ("current-mode", "current-mode", "current-mode", DISPLAY_TYPE_MONITOR_MODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DISPLAY_MONITOR_PREFERRED_MODE_PROPERTY, display_monitor_properties[DISPLAY_MONITOR_PREFERRED_MODE_PROPERTY] = g_param_spec_object ("preferred-mode", "preferred-mode", "preferred-mode", DISPLAY_TYPE_MONITOR_MODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
display_monitor_instance_init (DisplayMonitor * self,
                               gpointer klass)
{
	self->priv = display_monitor_get_instance_private (self);
}

static void
display_monitor_finalize (GObject * obj)
{
	DisplayMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DISPLAY_TYPE_MONITOR, DisplayMonitor);
	_g_free0 (self->priv->_connector);
	_g_free0 (self->priv->_vendor);
	_g_free0 (self->priv->_product);
	_g_free0 (self->priv->_serial);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_modes);
	G_OBJECT_CLASS (display_monitor_parent_class)->finalize (obj);
}

static GType
display_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DisplayMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) display_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DisplayMonitor), 0, (GInstanceInitFunc) display_monitor_instance_init, NULL };
	GType display_monitor_type_id;
	display_monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "DisplayMonitor", &g_define_type_info, 0);
	DisplayMonitor_private_offset = g_type_add_instance_private (display_monitor_type_id, sizeof (DisplayMonitorPrivate));
	return display_monitor_type_id;
}

GType
display_monitor_get_type (void)
{
	static volatile gsize display_monitor_type_id__once = 0;
	if (g_once_init_enter (&display_monitor_type_id__once)) {
		GType display_monitor_type_id;
		display_monitor_type_id = display_monitor_get_type_once ();
		g_once_init_leave (&display_monitor_type_id__once, display_monitor_type_id);
	}
	return display_monitor_type_id__once;
}

static void
_vala_display_monitor_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	DisplayMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR, DisplayMonitor);
	switch (property_id) {
		case DISPLAY_MONITOR_CONNECTOR_PROPERTY:
		g_value_set_string (value, display_monitor_get_connector (self));
		break;
		case DISPLAY_MONITOR_VENDOR_PROPERTY:
		g_value_set_string (value, display_monitor_get_vendor (self));
		break;
		case DISPLAY_MONITOR_PRODUCT_PROPERTY:
		g_value_set_string (value, display_monitor_get_product (self));
		break;
		case DISPLAY_MONITOR_SERIAL_PROPERTY:
		g_value_set_string (value, display_monitor_get_serial (self));
		break;
		case DISPLAY_MONITOR_HASH_PROPERTY:
		g_value_set_uint (value, display_monitor_get_hash (self));
		break;
		case DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, display_monitor_get_display_name (self));
		break;
		case DISPLAY_MONITOR_IS_BUILTIN_PROPERTY:
		g_value_set_boolean (value, display_monitor_get_is_builtin (self));
		break;
		case DISPLAY_MONITOR_MODES_PROPERTY:
		g_value_set_object (value, display_monitor_get_modes (self));
		break;
		case DISPLAY_MONITOR_CURRENT_MODE_PROPERTY:
		g_value_take_object (value, display_monitor_get_current_mode (self));
		break;
		case DISPLAY_MONITOR_PREFERRED_MODE_PROPERTY:
		g_value_take_object (value, display_monitor_get_preferred_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_display_monitor_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	DisplayMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DISPLAY_TYPE_MONITOR, DisplayMonitor);
	switch (property_id) {
		case DISPLAY_MONITOR_CONNECTOR_PROPERTY:
		display_monitor_set_connector (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_VENDOR_PROPERTY:
		display_monitor_set_vendor (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_PRODUCT_PROPERTY:
		display_monitor_set_product (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_SERIAL_PROPERTY:
		display_monitor_set_serial (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_DISPLAY_NAME_PROPERTY:
		display_monitor_set_display_name (self, g_value_get_string (value));
		break;
		case DISPLAY_MONITOR_IS_BUILTIN_PROPERTY:
		display_monitor_set_is_builtin (self, g_value_get_boolean (value));
		break;
		case DISPLAY_MONITOR_MODES_PROPERTY:
		display_monitor_set_modes (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

