/* ProgressDialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ProgressDialog.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 * Copyright 2017 Jens Georg <mail@jensge.org>
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>

#define RESOURCES_CANCEL_LABEL _ ("_Cancel")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PROGRESS_DIALOG (progress_dialog_get_type ())
#define PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROGRESS_DIALOG, ProgressDialog))
#define PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROGRESS_DIALOG, ProgressDialogClass))
#define IS_PROGRESS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROGRESS_DIALOG))
#define IS_PROGRESS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROGRESS_DIALOG))
#define PROGRESS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROGRESS_DIALOG, ProgressDialogClass))

typedef struct _ProgressDialog ProgressDialog;
typedef struct _ProgressDialogClass ProgressDialogClass;
typedef struct _ProgressDialogPrivate ProgressDialogPrivate;
enum  {
	PROGRESS_DIALOG_0_PROPERTY,
	PROGRESS_DIALOG_NUM_PROPERTIES
};
static GParamSpec* progress_dialog_properties[PROGRESS_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ProgressDialog {
	GtkWindow parent_instance;
	ProgressDialogPrivate * priv;
};

struct _ProgressDialogClass {
	GtkWindowClass parent_class;
};

struct _ProgressDialogPrivate {
	GtkProgressBar* progress_bar;
	GtkButton* cancel_button;
	GCancellable* cancellable;
	guint64 last_count;
	gint update_every;
	gint minimum_on_screen_time_msec;
	gulong time_started;
};

static gint ProgressDialog_private_offset;
static gpointer progress_dialog_parent_class = NULL;

VALA_EXTERN GType progress_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ProgressDialog, g_object_unref)
VALA_EXTERN ProgressDialog* progress_dialog_new (GtkWindow* owner,
                                     const gchar* text,
                                     GCancellable* cancellable);
VALA_EXTERN ProgressDialog* progress_dialog_construct (GType object_type,
                                           GtkWindow* owner,
                                           const gchar* text,
                                           GCancellable* cancellable);
static void progress_dialog_on_cancel (ProgressDialog* self);
static void _progress_dialog_on_cancel_gtk_button_clicked (GtkButton* _sender,
                                                    gpointer self);
static gboolean progress_dialog_on_window_closed (ProgressDialog* self);
static gboolean _progress_dialog_on_window_closed_gtk_widget_delete_event (GtkWidget* _sender,
                                                                    GdkEventAny* event,
                                                                    gpointer self);
static gboolean _gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                             GdkEventAny* event,
                                                             gpointer self);
VALA_EXTERN gulong now_ms (void);
static void progress_dialog_real_realize (GtkWidget* base);
VALA_EXTERN void progress_dialog_update_display_every (ProgressDialog* self,
                                           gint update_every);
VALA_EXTERN void progress_dialog_set_minimum_on_screen_time_msec (ProgressDialog* self,
                                                      gint minimum_on_screen_time_msec);
VALA_EXTERN void progress_dialog_set_fraction (ProgressDialog* self,
                                   gint current,
                                   gint total);
VALA_EXTERN void progress_dialog_set_percentage (ProgressDialog* self,
                                     gdouble pct);
static void progress_dialog_maybe_show_all (ProgressDialog* self,
                                     gdouble pct);
VALA_EXTERN void progress_dialog_set_status (ProgressDialog* self,
                                 const gchar* text);
VALA_EXTERN gboolean progress_dialog_monitor (ProgressDialog* self,
                                  guint64 count,
                                  guint64 total,
                                  gboolean do_event_loop);
VALA_EXTERN void spin_event_loop (void);
VALA_EXTERN void progress_dialog_close (ProgressDialog* self);
static void progress_dialog_finalize (GObject * obj);
static GType progress_dialog_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
progress_dialog_get_instance_private (ProgressDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ProgressDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_progress_dialog_on_cancel_gtk_button_clicked (GtkButton* _sender,
                                               gpointer self)
{
	progress_dialog_on_cancel ((ProgressDialog*) self);
}

static gboolean
_progress_dialog_on_window_closed_gtk_widget_delete_event (GtkWidget* _sender,
                                                           GdkEventAny* event,
                                                           gpointer self)
{
	gboolean result;
	result = progress_dialog_on_window_closed ((ProgressDialog*) self);
	return result;
}

static gboolean
_gtk_widget_hide_on_delete_gtk_widget_delete_event (GtkWidget* _sender,
                                                    GdkEventAny* event,
                                                    gpointer self)
{
	gboolean result;
	result = gtk_widget_hide_on_delete ((GtkWidget*) self);
	return result;
}

ProgressDialog*
progress_dialog_construct (GType object_type,
                           GtkWindow* owner,
                           const gchar* text,
                           GCancellable* cancellable)
{
	ProgressDialog * self = NULL;
	GCancellable* _tmp0_;
	GtkProgressBar* _tmp1_;
	GtkProgressBar* _tmp2_;
	GtkBox* vbox_bar = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkProgressBar* _tmp5_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkButton* _tmp11_;
	GtkLabel* primary_text_label = NULL;
	GtkLabel* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GtkBox* vbox = NULL;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	g_return_val_if_fail ((owner == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (owner, gtk_window_get_type ()), NULL);
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail ((cancellable == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	self = (ProgressDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp0_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), text);
	gtk_window_set_resizable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), FALSE);
	if (owner != NULL) {
		gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), owner);
	}
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	gtk_window_set_type_hint (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	_tmp1_ = self->priv->progress_bar;
	gtk_widget_set_size_request (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), 300, -1);
	_tmp2_ = self->priv->progress_bar;
	gtk_progress_bar_set_show_text (_tmp2_, TRUE);
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp3_);
	vbox_bar = _tmp3_;
	_tmp4_ = vbox_bar;
	_tmp5_ = self->priv->progress_bar;
	gtk_box_pack_start (_tmp4_, G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	if (cancellable != NULL) {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		_tmp6_ = (GtkButton*) gtk_button_new_with_mnemonic (RESOURCES_CANCEL_LABEL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->cancel_button);
		self->priv->cancel_button = _tmp6_;
		_tmp7_ = self->priv->cancel_button;
		g_signal_connect_object (_tmp7_, "clicked", (GCallback) _progress_dialog_on_cancel_gtk_button_clicked, self, 0);
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _progress_dialog_on_window_closed_gtk_widget_delete_event, self, 0);
	} else {
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "delete-event", (GCallback) _gtk_widget_hide_on_delete_gtk_widget_delete_event, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 0);
	}
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 8);
	g_object_ref_sink (_tmp8_);
	hbox = _tmp8_;
	_tmp9_ = hbox;
	_tmp10_ = vbox_bar;
	gtk_box_pack_start (_tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	_tmp11_ = self->priv->cancel_button;
	if (_tmp11_ != NULL) {
		GtkBox* _tmp12_;
		GtkButton* _tmp13_;
		_tmp12_ = hbox;
		_tmp13_ = self->priv->cancel_button;
		gtk_box_pack_end (_tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	}
	_tmp14_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp14_);
	primary_text_label = _tmp14_;
	_tmp15_ = g_strdup_printf ("<span weight=\"bold\">%s</span>", text);
	_tmp16_ = _tmp15_;
	gtk_label_set_markup (primary_text_label, _tmp16_);
	_g_free0 (_tmp16_);
	gtk_label_set_xalign (primary_text_label, 0.0f);
	gtk_label_set_yalign (primary_text_label, 0.5f);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 12);
	g_object_ref_sink (_tmp17_);
	vbox = _tmp17_;
	gtk_box_pack_start (vbox, G_TYPE_CHECK_INSTANCE_CAST (primary_text_label, gtk_widget_get_type (), GtkWidget), FALSE, FALSE, (guint) 0);
	_tmp18_ = hbox;
	gtk_box_pack_start (vbox, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), TRUE, FALSE, (guint) 0);
	gtk_widget_set_halign (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	gtk_widget_set_valign (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), GTK_ALIGN_CENTER);
	gtk_widget_set_hexpand (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_widget_set_vexpand (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), TRUE);
	gtk_widget_set_margin_start (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), 12);
	gtk_widget_set_margin_end (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), 12);
	gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), 12);
	gtk_widget_set_margin_bottom (G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget), 12);
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (vbox, gtk_widget_get_type (), GtkWidget));
	self->priv->time_started = now_ms ();
	_g_object_unref0 (vbox);
	_g_object_unref0 (primary_text_label);
	_g_object_unref0 (hbox);
	_g_object_unref0 (vbox_bar);
	return self;
}

ProgressDialog*
progress_dialog_new (GtkWindow* owner,
                     const gchar* text,
                     GCancellable* cancellable)
{
	return progress_dialog_construct (TYPE_PROGRESS_DIALOG, owner, text, cancellable);
}

static void
progress_dialog_real_realize (GtkWidget* base)
{
	ProgressDialog * self;
	GCancellable* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PROGRESS_DIALOG, ProgressDialog);
	GTK_WIDGET_CLASS (progress_dialog_parent_class)->realize (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), gtk_widget_get_type (), GtkWidget));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ == NULL) {
		GdkWindow* _tmp1_;
		_tmp1_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		gdk_window_set_functions (_tmp1_, GDK_FUNC_MOVE);
	}
}

void
progress_dialog_update_display_every (ProgressDialog* self,
                                      gint update_every)
{
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	_vala_assert (update_every >= 1, "update_every >= 1");
	self->priv->update_every = update_every;
}

void
progress_dialog_set_minimum_on_screen_time_msec (ProgressDialog* self,
                                                 gint minimum_on_screen_time_msec)
{
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	self->priv->minimum_on_screen_time_msec = minimum_on_screen_time_msec;
}

void
progress_dialog_set_fraction (ProgressDialog* self,
                              gint current,
                              gint total)
{
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	progress_dialog_set_percentage (self, ((gdouble) current) / ((gdouble) total));
}

void
progress_dialog_set_percentage (ProgressDialog* self,
                                gdouble pct)
{
	GtkProgressBar* _tmp0_;
	GtkProgressBar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	pct = CLAMP (pct, 0.0, 1.0);
	progress_dialog_maybe_show_all (self, pct);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_fraction (_tmp0_, pct);
	_tmp1_ = self->priv->progress_bar;
	_tmp2_ = g_strdup_printf (_ ("%d%%"), (gint) (pct * 100.0));
	_tmp3_ = _tmp2_;
	gtk_progress_bar_set_text (_tmp1_, _tmp3_);
	_g_free0 (_tmp3_);
}

void
progress_dialog_set_status (ProgressDialog* self,
                            const gchar* text)
{
	GtkProgressBar* _tmp0_;
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->progress_bar;
	gtk_progress_bar_set_text (_tmp0_, text);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

gboolean
progress_dialog_monitor (ProgressDialog* self,
                         guint64 count,
                         guint64 total,
                         gboolean do_event_loop)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GCancellable* _tmp2_;
	gboolean keep_going = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_PROGRESS_DIALOG (self), FALSE);
	if (self->priv->last_count == G_MAXUINT64) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = (count - self->priv->last_count) >= ((guint64) self->priv->update_every);
	}
	if (_tmp0_) {
		progress_dialog_set_percentage (self, ((gdouble) count) / ((gdouble) total));
		self->priv->last_count = count;
	}
	_tmp2_ = self->priv->cancellable;
	if (_tmp2_ != NULL) {
		GCancellable* _tmp3_;
		_tmp3_ = self->priv->cancellable;
		_tmp1_ = !g_cancellable_is_cancelled (_tmp3_);
	} else {
		_tmp1_ = TRUE;
	}
	keep_going = _tmp1_;
	if (do_event_loop) {
		spin_event_loop ();
	}
	result = keep_going;
	return result;
}

void
progress_dialog_close (ProgressDialog* self)
{
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

static gboolean
progress_dialog_on_window_closed (ProgressDialog* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PROGRESS_DIALOG (self), FALSE);
	progress_dialog_on_cancel (self);
	result = FALSE;
	return result;
}

static void
progress_dialog_on_cancel (ProgressDialog* self)
{
	GCancellable* _tmp0_;
	GtkButton* _tmp2_;
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->cancel_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), FALSE);
}

static void
progress_dialog_maybe_show_all (ProgressDialog* self,
                                gdouble pct)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (IS_PROGRESS_DIALOG (self));
	_tmp1_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = (now_ms () - self->priv->time_started) > ((gulong) self->priv->minimum_on_screen_time_msec);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gdouble pps = 0.0;
		gdouble ttc = 0.0;
		pps = (pct * 100.0) / self->priv->minimum_on_screen_time_msec;
		ttc = 100.0 / pps;
		if (ttc > ((gdouble) self->priv->minimum_on_screen_time_msec)) {
			gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
			spin_event_loop ();
		}
	}
}

static void
progress_dialog_class_init (ProgressDialogClass * klass,
                            gpointer klass_data)
{
	progress_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ProgressDialog_private_offset);
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget*)) progress_dialog_real_realize;
	G_OBJECT_CLASS (klass)->finalize = progress_dialog_finalize;
}

static void
progress_dialog_instance_init (ProgressDialog * self,
                               gpointer klass)
{
	GtkProgressBar* _tmp0_;
	self->priv = progress_dialog_get_instance_private (self);
	_tmp0_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp0_);
	self->priv->progress_bar = _tmp0_;
	self->priv->cancel_button = NULL;
	self->priv->last_count = G_MAXUINT64;
	self->priv->update_every = 1;
	self->priv->minimum_on_screen_time_msec = 500;
}

static void
progress_dialog_finalize (GObject * obj)
{
	ProgressDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROGRESS_DIALOG, ProgressDialog);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (progress_dialog_parent_class)->finalize (obj);
}

static GType
progress_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ProgressDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) progress_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ProgressDialog), 0, (GInstanceInitFunc) progress_dialog_instance_init, NULL };
	GType progress_dialog_type_id;
	progress_dialog_type_id = g_type_register_static (gtk_window_get_type (), "ProgressDialog", &g_define_type_info, 0);
	ProgressDialog_private_offset = g_type_add_instance_private (progress_dialog_type_id, sizeof (ProgressDialogPrivate));
	return progress_dialog_type_id;
}

GType
progress_dialog_get_type (void)
{
	static volatile gsize progress_dialog_type_id__once = 0;
	if (g_once_init_enter (&progress_dialog_type_id__once)) {
		GType progress_dialog_type_id;
		progress_dialog_type_id = progress_dialog_get_type_once ();
		g_once_init_leave (&progress_dialog_type_id__once, progress_dialog_type_id);
	}
	return progress_dialog_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

