/* SortedList.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SortedList.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;
typedef struct _SortedListPrivate SortedListPrivate;
enum  {
	SORTED_LIST_0_PROPERTY,
	SORTED_LIST_G_TYPE,
	SORTED_LIST_G_DUP_FUNC,
	SORTED_LIST_G_DESTROY_FUNC,
	SORTED_LIST_ELEMENT_TYPE_PROPERTY,
	SORTED_LIST_READ_ONLY_PROPERTY,
	SORTED_LIST_IS_EMPTY_PROPERTY,
	SORTED_LIST_SIZE_PROPERTY,
	SORTED_LIST_READ_ONLY_VIEW_PROPERTY,
	SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY,
	SORTED_LIST_NUM_PROPERTIES
};
static GParamSpec* sorted_list_properties[SORTED_LIST_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SortedList {
	GObject parent_instance;
	SortedListPrivate * priv;
};

struct _SortedListClass {
	GObjectClass parent_class;
};

struct _SortedListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* list;
	Comparator cmp;
	gpointer cmp_target;
};

static gint SortedList_private_offset;
static gpointer sorted_list_parent_class = NULL;
static GeeTraversableIface * sorted_list_gee_traversable_parent_iface = NULL;
static GeeIterableIface * sorted_list_gee_iterable_parent_iface = NULL;
static GeeCollectionIface * sorted_list_gee_collection_parent_iface = NULL;

VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
static GeeIterator* sorted_list_real_iterator (GeeIterable* base);
static gboolean sorted_list_real_foreach (GeeTraversable* base,
                                   GeeForallFunc f,
                                   gpointer f_target);
static gboolean sorted_list_real_add (GeeCollection* base,
                               gconstpointer item);
static gint sorted_list_get_sorted_insert_pos (SortedList* self,
                                        gconstpointer item);
static gboolean sorted_list_real_add_all (GeeCollection* base,
                                   GeeCollection* collection);
VALA_EXTERN gboolean sorted_list_add_list (SortedList* self,
                               GeeList* items);
static gboolean sorted_list_merge_sort (SortedList* self,
                                 GeeList* add);
static void sorted_list_real_clear (GeeCollection* base);
static gboolean sorted_list_real_contains (GeeCollection* base,
                                    gconstpointer item);
static gboolean sorted_list_real_contains_all (GeeCollection* base,
                                        GeeCollection* collection);
static gboolean sorted_list_real_remove (GeeCollection* base,
                                  gconstpointer item);
static gboolean sorted_list_real_remove_all (GeeCollection* base,
                                      GeeCollection* collection);
static gboolean sorted_list_real_retain_all (GeeCollection* base,
                                      GeeCollection* collection);
VALA_EXTERN gint sorted_list_get_count (SortedList* self);
VALA_EXTERN gpointer sorted_list_get_at (SortedList* self,
                             gint index);
static gint sorted_list_binary_search (SortedList* self,
                                gconstpointer search,
                                GEqualFunc equal_func);
VALA_EXTERN gint sorted_list_index_of (SortedList* self,
                           gconstpointer search);
VALA_EXTERN gint sorted_list_locate (SortedList* self,
                         gconstpointer search,
                         gboolean altered,
                         GEqualFunc equal_func);
VALA_EXTERN gpointer sorted_list_remove_at (SortedList* self,
                                gint index);
static gpointer* sorted_list_real_to_array (GeeCollection* base,
                                     gint* result_length1);
VALA_EXTERN void sorted_list_resort (SortedList* self,
                         Comparator new_cmp,
                         gpointer new_cmp_target);
VALA_EXTERN gboolean sorted_list_resort_item (SortedList* self,
                                  gconstpointer item);
VALA_EXTERN SortedList* sorted_list_copy (SortedList* self);
static void _sorted_list_merge_sort (SortedList* self,
                              gpointer* array,
                              gint array_length1,
                              gpointer* scratch,
                              gint scratch_length1,
                              gint start_index,
                              gint end_index);
static void sorted_list_merge (SortedList* self,
                        gpointer* array,
                        gint array_length1,
                        gpointer* scratch,
                        gint scratch_length1,
                        gint start_index,
                        gint middle_index,
                        gint end_index);
VALA_EXTERN GeeList* sorted_list_get_read_only_view_as_list (SortedList* self);
static void sorted_list_finalize (GObject * obj);
static GType sorted_list_get_type_once (void);
static void _vala_sorted_list_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sorted_list_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sorted_list_get_instance_private (SortedList* self)
{
	return G_STRUCT_MEMBER_P (self, SortedList_private_offset);
}

SortedList*
sorted_list_construct (GType object_type,
                       GType g_type,
                       GBoxedCopyFunc g_dup_func,
                       GDestroyNotify g_destroy_func,
                       Comparator cmp,
                       gpointer cmp_target)
{
	SortedList * self = NULL;
	GeeArrayList* _tmp0_;
	self = (SortedList*) g_object_new (object_type, "g-type", g_type, "g-dup-func", g_dup_func, "g-destroy-func", g_destroy_func, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = gee_array_list_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->list);
	self->priv->list = _tmp0_;
	self->priv->cmp = cmp;
	self->priv->cmp_target = cmp_target;
	return self;
}

SortedList*
sorted_list_new (GType g_type,
                 GBoxedCopyFunc g_dup_func,
                 GDestroyNotify g_destroy_func,
                 Comparator cmp,
                 gpointer cmp_target)
{
	return sorted_list_construct (TYPE_SORTED_LIST, g_type, g_dup_func, g_destroy_func, cmp, cmp_target);
}

static GeeIterator*
sorted_list_real_iterator (GeeIterable* base)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_;
	GeeIterator* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	result = _tmp1_;
	return result;
}

static gboolean
sorted_list_real_foreach (GeeTraversable* base,
                          GeeForallFunc f,
                          gpointer f_target)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	result = gee_abstract_collection_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), f, f_target);
	return result;
}

static gboolean
sorted_list_real_add (GeeCollection* base,
                      gconstpointer item)
{
	SortedList * self;
	Comparator _tmp0_;
	gpointer _tmp0__target;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->cmp;
	_tmp0__target = self->priv->cmp_target;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		_tmp1_ = self->priv->list;
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), item);
	} else {
		GeeArrayList* _tmp2_;
		_tmp2_ = self->priv->list;
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), sorted_list_get_sorted_insert_pos (self, item), item);
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
sorted_list_real_add_all (GeeCollection* base,
                          GeeCollection* collection)
{
	SortedList * self;
	gint _tmp0_;
	gint _tmp1_;
	GeeList* as_list = NULL;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	Comparator _tmp5_;
	gpointer _tmp5__target;
	gboolean changed = FALSE;
	gint _tmp7_;
	gint _tmp8_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = gee_collection_get_size (collection);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_LIST) ? ((GeeList*) collection) : NULL);
	as_list = _tmp2_;
	_tmp3_ = as_list;
	if (_tmp3_ != NULL) {
		GeeList* _tmp4_;
		_tmp4_ = as_list;
		result = sorted_list_add_list (self, _tmp4_);
		_g_object_unref0 (as_list);
		return result;
	}
	_tmp5_ = self->priv->cmp;
	_tmp5__target = self->priv->cmp_target;
	if (_tmp5_ == NULL) {
		GeeArrayList* _tmp6_;
		_tmp6_ = self->priv->list;
		result = gee_array_list_add_all (_tmp6_, collection);
		_g_object_unref0 (as_list);
		return result;
	}
	changed = FALSE;
	_tmp7_ = gee_collection_get_size (collection);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 1) {
		GeeIterator* iter = NULL;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		gpointer item = NULL;
		GeeIterator* _tmp11_;
		gpointer _tmp12_;
		GeeArrayList* _tmp13_;
		gconstpointer _tmp14_;
		gconstpointer _tmp15_;
		_tmp9_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (collection, GEE_TYPE_ITERABLE, GeeIterable));
		iter = _tmp9_;
		_tmp10_ = iter;
		gee_iterator_next (_tmp10_);
		_tmp11_ = iter;
		_tmp12_ = gee_iterator_get (_tmp11_);
		item = _tmp12_;
		_tmp13_ = self->priv->list;
		_tmp14_ = item;
		_tmp15_ = item;
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), sorted_list_get_sorted_insert_pos (self, _tmp14_), _tmp15_);
		changed = TRUE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		_g_object_unref0 (iter);
	} else {
		GeeList* items = NULL;
		GeeArrayList* _tmp16_;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		_tmp16_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, NULL, NULL, NULL);
		items = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_LIST, GeeList);
		_tmp17_ = items;
		gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), collection);
		_tmp18_ = items;
		changed = sorted_list_merge_sort (self, _tmp18_);
		_g_object_unref0 (items);
	}
	result = changed;
	_g_object_unref0 (as_list);
	return result;
}

gboolean
sorted_list_add_list (SortedList* self,
                      GeeList* items)
{
	gboolean added = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_LIST), FALSE);
	added = FALSE;
	_tmp0_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp1_ = _tmp0_;
	if (_tmp1_ == 0) {
	} else {
		Comparator _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->cmp;
		_tmp2__target = self->priv->cmp_target;
		if (_tmp2_ != NULL) {
			gint _tmp3_;
			gint _tmp4_;
			_tmp3_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp4_ = _tmp3_;
			if (_tmp4_ == 1) {
				GeeArrayList* _tmp5_;
				gpointer _tmp6_;
				gpointer _tmp7_;
				gpointer _tmp8_;
				gpointer _tmp9_;
				_tmp5_ = self->priv->list;
				_tmp6_ = gee_list_get (items, 0);
				_tmp7_ = _tmp6_;
				_tmp8_ = gee_list_get (items, 0);
				_tmp9_ = _tmp8_;
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), sorted_list_get_sorted_insert_pos (self, _tmp7_), _tmp9_);
				((_tmp9_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_ = (self->priv->g_destroy_func (_tmp9_), NULL));
				((_tmp7_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp7_ = (self->priv->g_destroy_func (_tmp7_), NULL));
				added = TRUE;
			} else {
				added = sorted_list_merge_sort (self, items);
			}
		} else {
			GeeArrayList* _tmp10_;
			_tmp10_ = self->priv->list;
			added = gee_array_list_add_all (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_COLLECTION, GeeCollection));
		}
	}
	result = added;
	return result;
}

static void
sorted_list_real_clear (GeeCollection* base)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
}

static gboolean
sorted_list_real_contains (GeeCollection* base,
                           gconstpointer item)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	result = gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), item);
	return result;
}

static gboolean
sorted_list_real_contains_all (GeeCollection* base,
                               GeeCollection* collection)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = self->priv->list;
	result = gee_collection_contains_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), collection);
	return result;
}

static gboolean
sorted_list_real_remove (GeeCollection* base,
                         gconstpointer item)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	result = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), item);
	return result;
}

static gboolean
sorted_list_real_remove_all (GeeCollection* base,
                             GeeCollection* collection)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = self->priv->list;
	result = gee_collection_remove_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), collection);
	return result;
}

static gboolean
sorted_list_real_retain_all (GeeCollection* base,
                             GeeCollection* collection)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (collection, GEE_TYPE_COLLECTION), FALSE);
	_tmp0_ = self->priv->list;
	result = gee_collection_retain_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), collection);
	return result;
}

inline gint
sorted_list_get_count (SortedList* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gpointer
sorted_list_get_at (SortedList* self,
                    gint index)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
	result = _tmp1_;
	return result;
}

static gint
sorted_list_binary_search (SortedList* self,
                           gconstpointer search,
                           GEqualFunc equal_func)
{
	Comparator _tmp0_;
	gpointer _tmp0__target;
	gint min = 0;
	gint max = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
	_tmp0_ = self->priv->cmp;
	_tmp0__target = self->priv->cmp_target;
	_vala_assert (_tmp0_ != NULL, "cmp != null");
	min = 0;
	_tmp1_ = self->priv->list;
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp3_ = _tmp2_;
	max = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			gint mid = 0;
			gpointer item = NULL;
			GeeArrayList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			gint64 compare = 0LL;
			Comparator _tmp9_;
			gpointer _tmp9__target;
			gconstpointer _tmp10_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			mid = min + ((max - min) / 2);
			_tmp5_ = self->priv->list;
			_tmp6_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), mid);
			item = _tmp6_;
			if (equal_func != NULL) {
				gconstpointer _tmp8_;
				_tmp8_ = item;
				_tmp7_ = equal_func (_tmp8_, search);
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = mid;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				return result;
			}
			_tmp9_ = self->priv->cmp;
			_tmp9__target = self->priv->cmp_target;
			_tmp10_ = item;
			compare = _tmp9_ (_tmp10_, search, _tmp9__target);
			if (compare == ((gint64) 0)) {
				result = mid;
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				return result;
			} else {
				if (compare > ((gint64) 0)) {
					max = mid - 1;
				} else {
					min = mid + 1;
				}
			}
			if (min > max) {
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				break;
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
	}
	result = -1;
	return result;
}

gint
sorted_list_index_of (SortedList* self,
                      gconstpointer search)
{
	gint _tmp0_ = 0;
	Comparator _tmp1_;
	gpointer _tmp1__target;
	gint result;
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
	_tmp1_ = self->priv->cmp;
	_tmp1__target = self->priv->cmp_target;
	if (_tmp1_ != NULL) {
		_tmp0_ = sorted_list_binary_search (self, search, NULL);
	} else {
		GEqualFunc _tmp2_;
		_tmp2_ = g_direct_equal;
		_tmp0_ = sorted_list_locate (self, search, FALSE, _tmp2_);
	}
	result = _tmp0_;
	return result;
}

gint
sorted_list_locate (SortedList* self,
                    gconstpointer search,
                    gboolean altered,
                    GEqualFunc equal_func)
{
	gboolean _tmp0_ = FALSE;
	Comparator _tmp1_;
	gpointer _tmp1__target;
	gint result;
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
	_tmp1_ = self->priv->cmp;
	_tmp1__target = self->priv->cmp_target;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = altered;
	}
	if (_tmp0_) {
		gint count = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->list;
		_tmp3_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp4_ = _tmp3_;
		count = _tmp4_;
		{
			gint ctr = 0;
			ctr = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					GeeArrayList* _tmp7_;
					gpointer _tmp8_;
					gpointer _tmp9_;
					gboolean _tmp10_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = ctr;
						ctr = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					if (!(ctr < count)) {
						break;
					}
					_tmp7_ = self->priv->list;
					_tmp8_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
					_tmp9_ = _tmp8_;
					_tmp10_ = equal_func (_tmp9_, search);
					((_tmp9_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp9_ = (self->priv->g_destroy_func (_tmp9_), NULL));
					if (_tmp10_) {
						result = ctr;
						return result;
					}
				}
			}
		}
		result = -1;
		return result;
	}
	result = sorted_list_binary_search (self, search, equal_func);
	return result;
}

gpointer
sorted_list_remove_at (SortedList* self,
                       gint index)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
	result = _tmp1_;
	return result;
}

static gpointer*
sorted_list_real_to_array (GeeCollection* base,
                           gint* result_length1)
{
	SortedList * self;
	GeeArrayList* _tmp0_;
	gint _tmp1_ = 0;
	gpointer* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	gpointer* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp2_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

void
sorted_list_resort (SortedList* self,
                    Comparator new_cmp,
                    gpointer new_cmp_target)
{
	g_return_if_fail (IS_SORTED_LIST (self));
	self->priv->cmp = new_cmp;
	self->priv->cmp_target = new_cmp_target;
	sorted_list_merge_sort (self, NULL);
}

gboolean
sorted_list_resort_item (SortedList* self,
                         gconstpointer item)
{
	gint index = 0;
	GEqualFunc _tmp0_;
	gint new_index = 0;
	gboolean result;
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
	_tmp0_ = g_direct_equal;
	index = sorted_list_locate (self, item, TRUE, _tmp0_);
	_vala_assert (index >= 0, "index >= 0");
	new_index = sorted_list_get_sorted_insert_pos (self, item);
	if (index == new_index) {
		result = FALSE;
		return result;
	}
	if (new_index > index) {
		GeeArrayList* _tmp1_;
		gpointer removed_item = NULL;
		GeeArrayList* _tmp2_;
		gpointer _tmp3_;
		gconstpointer _tmp4_;
		_tmp1_ = self->priv->list;
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), new_index, item);
		_tmp2_ = self->priv->list;
		_tmp3_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
		removed_item = _tmp3_;
		_tmp4_ = removed_item;
		_vala_assert (item == _tmp4_, "item == removed_item");
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
	} else {
		gpointer removed_item = NULL;
		GeeArrayList* _tmp5_;
		gpointer _tmp6_;
		gconstpointer _tmp7_;
		GeeArrayList* _tmp8_;
		_tmp5_ = self->priv->list;
		_tmp6_ = gee_abstract_list_remove_at (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), index);
		removed_item = _tmp6_;
		_tmp7_ = removed_item;
		_vala_assert (item == _tmp7_, "item == removed_item");
		_tmp8_ = self->priv->list;
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), new_index, item);
		((removed_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (removed_item = (self->priv->g_destroy_func (removed_item), NULL));
	}
	result = TRUE;
	return result;
}

static gint
sorted_list_get_sorted_insert_pos (SortedList* self,
                                   gconstpointer item)
{
	gint low = 0;
	gint high = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_SORTED_LIST (self), 0);
	low = 0;
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	high = _tmp2_;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gint mid = 0;
			gpointer cmp_item = NULL;
			GeeArrayList* _tmp4_;
			gpointer _tmp5_;
			gconstpointer _tmp6_;
			gint64 _result_ = 0LL;
			Comparator _tmp15_;
			gpointer _tmp15__target;
			gconstpointer _tmp16_;
			if (!_tmp3_) {
			}
			_tmp3_ = FALSE;
			if (low == high) {
				result = low;
				return result;
			}
			mid = low + ((high - low) / 2);
			_tmp4_ = self->priv->list;
			_tmp5_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), mid);
			cmp_item = _tmp5_;
			_tmp6_ = cmp_item;
			if (item == _tmp6_) {
				GeeArrayList* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				_tmp7_ = self->priv->list;
				_tmp8_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_tmp9_ = _tmp8_;
				if (mid >= (_tmp9_ - 1)) {
					GeeArrayList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = self->priv->list;
					_tmp11_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
					_tmp12_ = _tmp11_;
					result = _tmp12_;
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
					return result;
				}
				_tmp13_ = self->priv->list;
				_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), mid + 1);
				((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
				cmp_item = _tmp14_;
			}
			_tmp15_ = self->priv->cmp;
			_tmp15__target = self->priv->cmp_target;
			_tmp16_ = cmp_item;
			_result_ = _tmp15_ (item, _tmp16_, _tmp15__target);
			if (_result_ < ((gint64) 0)) {
				high = mid;
			} else {
				if (_result_ > ((gint64) 0)) {
					low = mid + 1;
				} else {
					result = mid;
					((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
					return result;
				}
			}
			((cmp_item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (cmp_item = (self->priv->g_destroy_func (cmp_item), NULL));
		}
	}
}

SortedList*
sorted_list_copy (SortedList* self)
{
	SortedList* copy = NULL;
	Comparator _tmp0_;
	gpointer _tmp0__target;
	SortedList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	SortedList* result;
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
	_tmp0_ = self->priv->cmp;
	_tmp0__target = self->priv->cmp_target;
	_tmp1_ = sorted_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp0_, _tmp0__target);
	copy = _tmp1_;
	_tmp2_ = copy->priv->list;
	_tmp3_ = self->priv->list;
	gee_array_list_add_all (_tmp2_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
	result = copy;
	return result;
}

static gboolean
sorted_list_merge_sort (SortedList* self,
                        GeeList* add)
{
	Comparator _tmp0_;
	gpointer _tmp0__target;
	gint list_count = 0;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	gint add_count = 0;
	gint count = 0;
	gpointer* array = NULL;
	gpointer* _tmp7_;
	gint array_length1;
	gint _array_size_;
	gint offset = 0;
	gpointer* _tmp16_;
	gint _tmp16__length1;
	gpointer* _tmp17_;
	gpointer* _tmp18_;
	gint _tmp18__length1;
	gboolean result;
	g_return_val_if_fail (IS_SORTED_LIST (self), FALSE);
	g_return_val_if_fail ((add == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (add, GEE_TYPE_LIST), FALSE);
	_tmp0_ = self->priv->cmp;
	_tmp0__target = self->priv->cmp_target;
	_vala_assert (_tmp0_ != NULL, "cmp != null");
	_tmp1_ = self->priv->list;
	_tmp2_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp3_ = _tmp2_;
	list_count = _tmp3_;
	if (add != NULL) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (add, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp6_ = _tmp5_;
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = 0;
	}
	add_count = _tmp4_;
	count = list_count + add_count;
	if (count == 0) {
		result = FALSE;
		return result;
	}
	_tmp7_ = g_new0 (gpointer, count);
	array = _tmp7_;
	array_length1 = count;
	_array_size_ = array_length1;
	offset = 0;
	while (TRUE) {
		gpointer* _tmp8_;
		gint _tmp8__length1;
		GeeArrayList* _tmp9_;
		gpointer _tmp10_;
		gint _tmp11_;
		if (!(offset < list_count)) {
			break;
		}
		_tmp8_ = array;
		_tmp8__length1 = array_length1;
		_tmp9_ = self->priv->list;
		_tmp10_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), offset);
		((_tmp8_[offset] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp8_[offset] = (self->priv->g_destroy_func (_tmp8_[offset]), NULL));
		_tmp8_[offset] = _tmp10_;
		_tmp11_ = offset;
		offset = _tmp11_ + 1;
	}
	if (add != NULL) {
		gint add_ctr = 0;
		add_ctr = 0;
		while (TRUE) {
			gpointer* _tmp12_;
			gint _tmp12__length1;
			gint _tmp13_;
			gpointer _tmp14_;
			gint _tmp15_;
			if (!(offset < count)) {
				break;
			}
			_tmp12_ = array;
			_tmp12__length1 = array_length1;
			_tmp13_ = add_ctr;
			add_ctr = _tmp13_ + 1;
			_tmp14_ = gee_list_get (add, _tmp13_);
			((_tmp12_[offset] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp12_[offset] = (self->priv->g_destroy_func (_tmp12_[offset]), NULL));
			_tmp12_[offset] = _tmp14_;
			_tmp15_ = offset;
			offset = _tmp15_ + 1;
		}
	}
	_vala_assert (offset == count, "offset == count");
	_tmp16_ = array;
	_tmp16__length1 = array_length1;
	_tmp17_ = g_new0 (gpointer, count);
	_tmp18_ = _tmp17_;
	_tmp18__length1 = count;
	_sorted_list_merge_sort (self, _tmp16_, (gint) _tmp16__length1, _tmp18_, (gint) count, 0, count - 1);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	offset = 0;
	while (TRUE) {
		GeeArrayList* _tmp19_;
		gpointer* _tmp20_;
		gint _tmp20__length1;
		gconstpointer _tmp21_;
		gint _tmp22_;
		if (!(offset < list_count)) {
			break;
		}
		_tmp19_ = self->priv->list;
		_tmp20_ = array;
		_tmp20__length1 = array_length1;
		_tmp21_ = _tmp20_[offset];
		gee_abstract_list_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), offset, _tmp21_);
		_tmp22_ = offset;
		offset = _tmp22_ + 1;
	}
	while (TRUE) {
		GeeArrayList* _tmp23_;
		gpointer* _tmp24_;
		gint _tmp24__length1;
		gconstpointer _tmp25_;
		gint _tmp26_;
		if (!(offset < count)) {
			break;
		}
		_tmp23_ = self->priv->list;
		_tmp24_ = array;
		_tmp24__length1 = array_length1;
		_tmp25_ = _tmp24_[offset];
		gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), offset, _tmp25_);
		_tmp26_ = offset;
		offset = _tmp26_ + 1;
	}
	result = TRUE;
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	return result;
}

static void
_sorted_list_merge_sort (SortedList* self,
                         gpointer* array,
                         gint array_length1,
                         gpointer* scratch,
                         gint scratch_length1,
                         gint start_index,
                         gint end_index)
{
	gint count = 0;
	gint middle_index = 0;
	Comparator _tmp0_;
	gpointer _tmp0__target;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	g_return_if_fail (IS_SORTED_LIST (self));
	_vala_assert (start_index <= end_index, "start_index <= end_index");
	count = (end_index - start_index) + 1;
	if (count <= 1) {
		return;
	}
	middle_index = start_index + (count / 2);
	_sorted_list_merge_sort (self, array, (gint) array_length1, scratch, (gint) scratch_length1, start_index, middle_index - 1);
	_sorted_list_merge_sort (self, array, (gint) array_length1, scratch, (gint) scratch_length1, middle_index, end_index);
	_tmp0_ = self->priv->cmp;
	_tmp0__target = self->priv->cmp_target;
	_tmp1_ = array[middle_index - 1];
	_tmp2_ = array[middle_index];
	if (_tmp0_ (_tmp1_, _tmp2_, _tmp0__target) > ((gint64) 0)) {
		sorted_list_merge (self, array, (gint) array_length1, scratch, (gint) scratch_length1, start_index, middle_index, end_index);
	}
}

static void
sorted_list_merge (SortedList* self,
                   gpointer* array,
                   gint array_length1,
                   gpointer* scratch,
                   gint scratch_length1,
                   gint start_index,
                   gint middle_index,
                   gint end_index)
{
	gint count = 0;
	gint left_start = 0;
	gint left_end = 0;
	gint right_start = 0;
	gint right_end = 0;
	gint scratch_index = 0;
	g_return_if_fail (IS_SORTED_LIST (self));
	_vala_assert (start_index < end_index, "start_index < end_index");
	count = (end_index - start_index) + 1;
	left_start = start_index;
	left_end = middle_index - 1;
	right_start = middle_index;
	right_end = end_index;
	_vala_assert (scratch_length1 >= count, "scratch.length >= count");
	scratch_index = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gpointer left = NULL;
		gconstpointer _tmp1_;
		gpointer _tmp2_;
		gpointer right = NULL;
		gconstpointer _tmp3_;
		gpointer _tmp4_;
		Comparator _tmp5_;
		gpointer _tmp5__target;
		gconstpointer _tmp6_;
		gconstpointer _tmp7_;
		if (left_start <= left_end) {
			_tmp0_ = right_start <= right_end;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp1_ = array[left_start];
		_tmp2_ = ((_tmp1_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp1_) : ((gpointer) _tmp1_);
		left = _tmp2_;
		_tmp3_ = array[right_start];
		_tmp4_ = ((_tmp3_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp3_) : ((gpointer) _tmp3_);
		right = _tmp4_;
		_tmp5_ = self->priv->cmp;
		_tmp5__target = self->priv->cmp_target;
		_tmp6_ = left;
		_tmp7_ = right;
		if (_tmp5_ (_tmp6_, _tmp7_, _tmp5__target) <= ((gint64) 0)) {
			gint _tmp8_;
			gconstpointer _tmp9_;
			gpointer _tmp10_;
			gint _tmp11_;
			_tmp8_ = scratch_index;
			scratch_index = _tmp8_ + 1;
			_tmp9_ = left;
			_tmp10_ = ((_tmp9_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp9_) : ((gpointer) _tmp9_);
			((scratch[_tmp8_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (scratch[_tmp8_] = (self->priv->g_destroy_func (scratch[_tmp8_]), NULL));
			scratch[_tmp8_] = _tmp10_;
			_tmp11_ = left_start;
			left_start = _tmp11_ + 1;
		} else {
			gint _tmp12_;
			gconstpointer _tmp13_;
			gpointer _tmp14_;
			gint _tmp15_;
			_tmp12_ = scratch_index;
			scratch_index = _tmp12_ + 1;
			_tmp13_ = right;
			_tmp14_ = ((_tmp13_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp13_) : ((gpointer) _tmp13_);
			((scratch[_tmp12_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (scratch[_tmp12_] = (self->priv->g_destroy_func (scratch[_tmp12_]), NULL));
			scratch[_tmp12_] = _tmp14_;
			_tmp15_ = right_start;
			right_start = _tmp15_ + 1;
		}
		((right == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (right = (self->priv->g_destroy_func (right), NULL));
		((left == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (left = (self->priv->g_destroy_func (left), NULL));
	}
	while (TRUE) {
		gint _tmp16_;
		gint _tmp17_;
		gconstpointer _tmp18_;
		gpointer _tmp19_;
		if (!(left_start <= left_end)) {
			break;
		}
		_tmp16_ = scratch_index;
		scratch_index = _tmp16_ + 1;
		_tmp17_ = left_start;
		left_start = _tmp17_ + 1;
		_tmp18_ = array[_tmp17_];
		_tmp19_ = ((_tmp18_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp18_) : ((gpointer) _tmp18_);
		((scratch[_tmp16_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (scratch[_tmp16_] = (self->priv->g_destroy_func (scratch[_tmp16_]), NULL));
		scratch[_tmp16_] = _tmp19_;
	}
	while (TRUE) {
		gint _tmp20_;
		gint _tmp21_;
		gconstpointer _tmp22_;
		gpointer _tmp23_;
		if (!(right_start <= right_end)) {
			break;
		}
		_tmp20_ = scratch_index;
		scratch_index = _tmp20_ + 1;
		_tmp21_ = right_start;
		right_start = _tmp21_ + 1;
		_tmp22_ = array[_tmp21_];
		_tmp23_ = ((_tmp22_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp22_) : ((gpointer) _tmp22_);
		((scratch[_tmp20_] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (scratch[_tmp20_] = (self->priv->g_destroy_func (scratch[_tmp20_]), NULL));
		scratch[_tmp20_] = _tmp23_;
	}
	_vala_assert (scratch_index == count, "scratch_index == count");
	scratch_index = 0;
	{
		gint list_index = 0;
		list_index = start_index;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint _tmp26_;
				gconstpointer _tmp27_;
				gpointer _tmp28_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = list_index;
					list_index = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(list_index <= end_index)) {
					break;
				}
				_tmp26_ = scratch_index;
				scratch_index = _tmp26_ + 1;
				_tmp27_ = scratch[_tmp26_];
				_tmp28_ = ((_tmp27_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp27_) : ((gpointer) _tmp27_);
				((array[list_index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (array[list_index] = (self->priv->g_destroy_func (array[list_index]), NULL));
				array[list_index] = _tmp28_;
			}
		}
	}
}

static GType
sorted_list_real_get_element_type (GeeTraversable* base)
{
	GType result;
	SortedList* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	result = self->priv->g_type;
	return result;
}

static gboolean
sorted_list_real_get_read_only (GeeCollection* base)
{
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gboolean
sorted_list_real_get_is_empty (GeeCollection* base)
{
	gboolean result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gint
sorted_list_real_get_size (GeeCollection* base)
{
	gint result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static GeeCollection*
sorted_list_real_get_read_only_view (GeeCollection* base)
{
	GeeCollection* result;
	SortedList* self;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SORTED_LIST, SortedList);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GeeList*
sorted_list_get_read_only_view_as_list (SortedList* self)
{
	GeeList* result;
	GeeArrayList* _tmp0_;
	GeeBidirList* _tmp1_;
	GeeBidirList* _tmp2_;
	g_return_val_if_fail (IS_SORTED_LIST (self), NULL);
	_tmp0_ = self->priv->list;
	_tmp1_ = gee_abstract_bidir_list_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_BIDIR_LIST, GeeAbstractBidirList));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList);
	return result;
}

static void
sorted_list_class_init (SortedListClass * klass,
                        gpointer klass_data)
{
	sorted_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SortedList_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sorted_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sorted_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = sorted_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_STRINGS | G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_ELEMENT_TYPE_PROPERTY, sorted_list_properties[SORTED_LIST_ELEMENT_TYPE_PROPERTY] = g_param_spec_gtype ("element-type", "element-type", "element-type", G_TYPE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_PROPERTY, sorted_list_properties[SORTED_LIST_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_IS_EMPTY_PROPERTY, sorted_list_properties[SORTED_LIST_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_SIZE_PROPERTY, sorted_list_properties[SORTED_LIST_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW_PROPERTY, sorted_list_properties[SORTED_LIST_READ_ONLY_VIEW_PROPERTY] = g_param_spec_object ("read-only-view", "read-only-view", "read-only-view", GEE_TYPE_COLLECTION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY, sorted_list_properties[SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY] = g_param_spec_object ("read-only-view-as-list", "read-only-view-as-list", "read-only-view-as-list", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static GType
sorted_list_gee_traversable_get_g_type (SortedList* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
sorted_list_gee_traversable_get_g_dup_func (SortedList* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
sorted_list_gee_traversable_get_g_destroy_func (SortedList* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
sorted_list_gee_traversable_interface_init (GeeTraversableIface * iface,
                                            gpointer iface_data)
{
	sorted_list_gee_traversable_parent_iface = g_type_interface_peek_parent (iface);
	iface->foreach = (gboolean (*) (GeeTraversable*, GeeForallFunc, gpointer)) sorted_list_real_foreach;
	iface->get_g_type = (GType (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeTraversable *)) sorted_list_gee_traversable_get_g_destroy_func;
	iface->get_element_type = sorted_list_real_get_element_type;
}

static GType
sorted_list_gee_iterable_get_g_type (SortedList* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
sorted_list_gee_iterable_get_g_dup_func (SortedList* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
sorted_list_gee_iterable_get_g_destroy_func (SortedList* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
sorted_list_gee_iterable_interface_init (GeeIterableIface * iface,
                                         gpointer iface_data)
{
	sorted_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->iterator = (GeeIterator* (*) (GeeIterable*)) sorted_list_real_iterator;
	iface->get_g_type = (GType (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeIterable *)) sorted_list_gee_iterable_get_g_destroy_func;
}

static GType
sorted_list_gee_collection_get_g_type (SortedList* self)
{
	return (GType) self->priv->g_type;
}

static GBoxedCopyFunc
sorted_list_gee_collection_get_g_dup_func (SortedList* self)
{
	return (GBoxedCopyFunc) self->priv->g_dup_func;
}

static GDestroyNotify
sorted_list_gee_collection_get_g_destroy_func (SortedList* self)
{
	return (GDestroyNotify) self->priv->g_destroy_func;
}

static void
sorted_list_gee_collection_interface_init (GeeCollectionIface * iface,
                                           gpointer iface_data)
{
	sorted_list_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->add = (gboolean (*) (GeeCollection*, gconstpointer)) sorted_list_real_add;
	iface->add_all = (gboolean (*) (GeeCollection*, GeeCollection*)) sorted_list_real_add_all;
	iface->clear = (void (*) (GeeCollection*)) sorted_list_real_clear;
	iface->contains = (gboolean (*) (GeeCollection*, gconstpointer)) sorted_list_real_contains;
	iface->contains_all = (gboolean (*) (GeeCollection*, GeeCollection*)) sorted_list_real_contains_all;
	iface->remove = (gboolean (*) (GeeCollection*, gconstpointer)) sorted_list_real_remove;
	iface->remove_all = (gboolean (*) (GeeCollection*, GeeCollection*)) sorted_list_real_remove_all;
	iface->retain_all = (gboolean (*) (GeeCollection*, GeeCollection*)) sorted_list_real_retain_all;
	iface->to_array = (gpointer* (*) (GeeCollection*, gint*)) sorted_list_real_to_array;
	iface->get_g_type = (GType (*) (GeeCollection *)) sorted_list_gee_collection_get_g_type;
	iface->get_g_dup_func = (GBoxedCopyFunc (*) (GeeCollection *)) sorted_list_gee_collection_get_g_dup_func;
	iface->get_g_destroy_func = (GDestroyNotify (*) (GeeCollection *)) sorted_list_gee_collection_get_g_destroy_func;
	iface->get_read_only = sorted_list_real_get_read_only;
	iface->get_is_empty = sorted_list_real_get_is_empty;
	iface->get_size = sorted_list_real_get_size;
	iface->get_read_only_view = sorted_list_real_get_read_only_view;
}

static void
sorted_list_instance_init (SortedList * self,
                           gpointer klass)
{
	self->priv = sorted_list_get_instance_private (self);
}

static void
sorted_list_finalize (GObject * obj)
{
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SORTED_LIST, SortedList);
	_g_object_unref0 (self->priv->list);
	G_OBJECT_CLASS (sorted_list_parent_class)->finalize (obj);
}

static GType
sorted_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SortedListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedList), 0, (GInstanceInitFunc) sorted_list_instance_init, NULL };
	static const GInterfaceInfo gee_traversable_info = { (GInterfaceInitFunc) sorted_list_gee_traversable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) sorted_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) sorted_list_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sorted_list_type_id;
	sorted_list_type_id = g_type_register_static (G_TYPE_OBJECT, "SortedList", &g_define_type_info, 0);
	g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_TRAVERSABLE, &gee_traversable_info);
	g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
	g_type_add_interface_static (sorted_list_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
	SortedList_private_offset = g_type_add_instance_private (sorted_list_type_id, sizeof (SortedListPrivate));
	return sorted_list_type_id;
}

GType
sorted_list_get_type (void)
{
	static volatile gsize sorted_list_type_id__once = 0;
	if (g_once_init_enter (&sorted_list_type_id__once)) {
		GType sorted_list_type_id;
		sorted_list_type_id = sorted_list_get_type_once ();
		g_once_init_leave (&sorted_list_type_id__once, sorted_list_type_id);
	}
	return sorted_list_type_id__once;
}

static void
_vala_sorted_list_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
	switch (property_id) {
		case SORTED_LIST_ELEMENT_TYPE_PROPERTY:
		g_value_set_gtype (value, gee_traversable_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_TRAVERSABLE, GeeTraversable)));
		break;
		case SORTED_LIST_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_collection_get_read_only (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
		break;
		case SORTED_LIST_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, gee_collection_get_is_empty (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
		break;
		case SORTED_LIST_SIZE_PROPERTY:
		g_value_set_int (value, gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
		break;
		case SORTED_LIST_READ_ONLY_VIEW_PROPERTY:
		g_value_take_object (value, gee_collection_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection)));
		break;
		case SORTED_LIST_READ_ONLY_VIEW_AS_LIST_PROPERTY:
		g_value_take_object (value, sorted_list_get_read_only_view_as_list (self));
		break;
		case SORTED_LIST_G_TYPE:
		g_value_set_gtype (value, self->priv->g_type);
		break;
		case SORTED_LIST_G_DUP_FUNC:
		g_value_set_pointer (value, self->priv->g_dup_func);
		break;
		case SORTED_LIST_G_DESTROY_FUNC:
		g_value_set_pointer (value, self->priv->g_destroy_func);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sorted_list_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SortedList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SORTED_LIST, SortedList);
	switch (property_id) {
		case SORTED_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case SORTED_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case SORTED_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

