/* rygel-media-pref-section.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-media-pref-section.vala, do not modify */

/*
 * Copyright (C) 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib-object.h>
#include <glib.h>
#include "rygel-core.h"
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gio/gio.h>

#define RYGEL_MEDIA_PREF_SECTION_NAME "MediaExport"
#define RYGEL_MEDIA_PREF_SECTION_URIS_KEY "uris"
#define RYGEL_MEDIA_PREF_SECTION_URIS_TEXTVIEW RYGEL_MEDIA_PREF_SECTION_URIS_KEY "-treeview"
#define RYGEL_MEDIA_PREF_SECTION_URIS_LISTSTORE RYGEL_MEDIA_PREF_SECTION_URIS_KEY "-liststore"
#define RYGEL_MEDIA_PREF_SECTION_URIS_DIALOG RYGEL_MEDIA_PREF_SECTION_URIS_KEY "-dialog"
#define RYGEL_MEDIA_PREF_SECTION_ADD_BUTTON "add-button"
#define RYGEL_MEDIA_PREF_SECTION_REMOVE_BUTTON "remove-button"
#define RYGEL_MEDIA_PREF_SECTION_TREE_SELECTION "treeview-selection"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define RYGEL_TYPE_PREFERENCES_SECTION (rygel_preferences_section_get_type ())
#define RYGEL_PREFERENCES_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PREFERENCES_SECTION, RygelPreferencesSection))
#define RYGEL_PREFERENCES_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PREFERENCES_SECTION, RygelPreferencesSectionClass))
#define RYGEL_IS_PREFERENCES_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PREFERENCES_SECTION))
#define RYGEL_IS_PREFERENCES_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PREFERENCES_SECTION))
#define RYGEL_PREFERENCES_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PREFERENCES_SECTION, RygelPreferencesSectionClass))

typedef struct _RygelPreferencesSection RygelPreferencesSection;
typedef struct _RygelPreferencesSectionClass RygelPreferencesSectionClass;
typedef struct _RygelPreferencesSectionPrivate RygelPreferencesSectionPrivate;

#define RYGEL_TYPE_WRITABLE_USER_CONFIG (rygel_writable_user_config_get_type ())
#define RYGEL_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfig))
#define RYGEL_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))
#define RYGEL_IS_WRITABLE_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_IS_WRITABLE_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WRITABLE_USER_CONFIG))
#define RYGEL_WRITABLE_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WRITABLE_USER_CONFIG, RygelWritableUserConfigClass))

typedef struct _RygelWritableUserConfig RygelWritableUserConfig;
typedef struct _RygelWritableUserConfigClass RygelWritableUserConfigClass;

#define RYGEL_TYPE_MEDIA_PREF_SECTION (rygel_media_pref_section_get_type ())
#define RYGEL_MEDIA_PREF_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PREF_SECTION, RygelMediaPrefSection))
#define RYGEL_MEDIA_PREF_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_PREF_SECTION, RygelMediaPrefSectionClass))
#define RYGEL_IS_MEDIA_PREF_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PREF_SECTION))
#define RYGEL_IS_MEDIA_PREF_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_PREF_SECTION))
#define RYGEL_MEDIA_PREF_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_PREF_SECTION, RygelMediaPrefSectionClass))

typedef struct _RygelMediaPrefSection RygelMediaPrefSection;
typedef struct _RygelMediaPrefSectionClass RygelMediaPrefSectionClass;
typedef struct _RygelMediaPrefSectionPrivate RygelMediaPrefSectionPrivate;
enum  {
	RYGEL_MEDIA_PREF_SECTION_0_PROPERTY,
	RYGEL_MEDIA_PREF_SECTION_NUM_PROPERTIES
};
static GParamSpec* rygel_media_pref_section_properties[RYGEL_MEDIA_PREF_SECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaPrefSectionAddFoldersData RygelMediaPrefSectionAddFoldersData;
#define __vala_GtkTreeRowReference_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeRowReference_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _RygelPreferencesSection {
	GObject parent_instance;
	RygelPreferencesSectionPrivate * priv;
	RygelWritableUserConfig* config;
	gchar* name;
};

struct _RygelPreferencesSectionClass {
	GObjectClass parent_class;
	void (*save) (RygelPreferencesSection* self);
	void (*set_sensitivity) (RygelPreferencesSection* self, gboolean sensitivity);
};

struct _RygelMediaPrefSection {
	RygelPreferencesSection parent_instance;
	RygelMediaPrefSectionPrivate * priv;
};

struct _RygelMediaPrefSectionClass {
	RygelPreferencesSectionClass parent_class;
};

struct _RygelMediaPrefSectionPrivate {
	GeeArrayList* widgets;
	GtkTreeView* treeview;
	GtkListStore* liststore;
	GtkTreeSelection* tree_selection;
	GtkFileDialog* dialog;
	GtkButton* remove_button;
};

struct _RygelMediaPrefSectionAddFoldersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	RygelMediaPrefSection* self;
	GListModel* folders;
	GtkFileDialog* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkRoot* _tmp2_;
	GListModel* _tmp3_;
	GtkTreeIter iter;
	gint i;
	gboolean _tmp4_;
	gint _tmp5_;
	GListModel* _tmp6_;
	GFile* dir;
	GListModel* _tmp7_;
	GObject* _tmp8_;
	gchar* path;
	GFile* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	gchar* _tmp13_;
	GtkListStore* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkListStore* _tmp16_;
	GtkTreeIter _tmp17_;
	const gchar* _tmp18_;
	GError* err;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GError* _inner_error0_;
};

static gint RygelMediaPrefSection_private_offset;
static gpointer rygel_media_pref_section_parent_class = NULL;

VALA_EXTERN GType rygel_preferences_section_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelPreferencesSection, g_object_unref)
VALA_EXTERN GType rygel_writable_user_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelWritableUserConfig, g_object_unref)
VALA_EXTERN GType rygel_media_pref_section_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RygelMediaPrefSection, g_object_unref)
VALA_EXTERN void rygel_preferences_section_save (RygelPreferencesSection* self);
VALA_EXTERN void rygel_preferences_section_set_sensitivity (RygelPreferencesSection* self,
                                                gboolean sensitivity);
VALA_EXTERN RygelMediaPrefSection* rygel_media_pref_section_new (GtkBuilder* builder,
                                                     RygelWritableUserConfig* config);
VALA_EXTERN RygelMediaPrefSection* rygel_media_pref_section_construct (GType object_type,
                                                           GtkBuilder* builder,
                                                           RygelWritableUserConfig* config);
VALA_EXTERN RygelPreferencesSection* rygel_preferences_section_construct (GType object_type,
                                                              RygelWritableUserConfig* config,
                                                              const gchar* name);
static gchar* rygel_media_pref_section_get_real_uri (RygelMediaPrefSection* self,
                                              const gchar* uri);
static void rygel_media_pref_section_on_add_button_clicked (RygelMediaPrefSection* self,
                                                     GtkButton* button);
static void _rygel_media_pref_section_on_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self);
static void rygel_media_pref_section_on_remove_button_clicked (RygelMediaPrefSection* self,
                                                        GtkButton* button);
static void _rygel_media_pref_section_on_remove_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void rygel_media_pref_section_on_tree_selection_changed (RygelMediaPrefSection* self);
static void _rygel_media_pref_section_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                                     gpointer self);
static void rygel_media_pref_section_real_save (RygelPreferencesSection* base);
static gchar* rygel_media_pref_section_uri_to_magic_variable (RygelMediaPrefSection* self,
                                                       const gchar* uri);
VALA_EXTERN void rygel_writable_user_config_set_string_list (RygelWritableUserConfig* self,
                                                 const gchar* section,
                                                 const gchar* key,
                                                 GeeArrayList* str_list);
static void rygel_media_pref_section_real_set_sensitivity (RygelPreferencesSection* base,
                                                    gboolean sensitivity);
static void rygel_media_pref_section_add_folders (RygelMediaPrefSection* self,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static void rygel_media_pref_section_add_folders_finish (RygelMediaPrefSection* self,
                                                  GAsyncResult* _res_);
static void rygel_media_pref_section_add_folders_data_free (gpointer _data);
static gboolean rygel_media_pref_section_add_folders_co (RygelMediaPrefSectionAddFoldersData* _data_);
static void rygel_media_pref_section_add_folders_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static GtkTreeRowReference* _vala_GtkTreeRowReference_copy (GtkTreeRowReference* self);
static void _vala_GtkTreeRowReference_free (GtkTreeRowReference* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void rygel_media_pref_section_finalize (GObject * obj);
static GType rygel_media_pref_section_get_type_once (void);

static inline gpointer
rygel_media_pref_section_get_instance_private (RygelMediaPrefSection* self)
{
	return G_STRUCT_MEMBER_P (self, RygelMediaPrefSection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_rygel_media_pref_section_on_add_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                    gpointer self)
{
	rygel_media_pref_section_on_add_button_clicked ((RygelMediaPrefSection*) self, _sender);
}

static void
_rygel_media_pref_section_on_remove_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	rygel_media_pref_section_on_remove_button_clicked ((RygelMediaPrefSection*) self, _sender);
}

static void
_rygel_media_pref_section_on_tree_selection_changed_gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                                                                gpointer self)
{
	rygel_media_pref_section_on_tree_selection_changed ((RygelMediaPrefSection*) self);
}

RygelMediaPrefSection*
rygel_media_pref_section_construct (GType object_type,
                                    GtkBuilder* builder,
                                    RygelWritableUserConfig* config)
{
	RygelMediaPrefSection * self = NULL;
	GeeArrayList* _tmp0_;
	GObject* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GObject* _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GObject* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	GObject* _tmp10_;
	GtkFileDialog* _tmp11_;
	GtkFileDialog* _tmp12_;
	GeeArrayList* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkFileDialog* _tmp32_;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	GFile* _tmp35_;
	GtkFileDialog* _tmp36_;
	GtkButton* add_button = NULL;
	GObject* _tmp37_;
	GtkButton* _tmp38_;
	GeeArrayList* _tmp39_;
	GObject* _tmp40_;
	GtkButton* _tmp41_;
	GtkButton* _tmp42_;
	GeeArrayList* _tmp43_;
	GtkButton* _tmp44_;
	GtkTreeSelection* _tmp45_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (builder != NULL, NULL);
	g_return_val_if_fail (config != NULL, NULL);
	self = (RygelMediaPrefSection*) rygel_preferences_section_construct (object_type, config, RYGEL_MEDIA_PREF_SECTION_NAME);
	_tmp0_ = gee_array_list_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->widgets);
	self->priv->widgets = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_URIS_TEXTVIEW);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_tree_view_get_type (), GtkTreeView));
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp2_;
	_tmp3_ = self->priv->treeview;
	_vala_assert (_tmp3_ != NULL, "this.treeview != null");
	_tmp4_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_URIS_LISTSTORE);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_list_store_get_type (), GtkListStore));
	_g_object_unref0 (self->priv->liststore);
	self->priv->liststore = _tmp5_;
	_tmp6_ = self->priv->liststore;
	_vala_assert (_tmp6_ != NULL, "this.liststore != null");
	_tmp7_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_TREE_SELECTION);
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_tree_selection_get_type ()) ? ((GtkTreeSelection*) _tmp7_) : NULL);
	_g_object_unref0 (self->priv->tree_selection);
	self->priv->tree_selection = _tmp8_;
	_tmp9_ = self->priv->tree_selection;
	_vala_assert (_tmp9_ != NULL, "this.tree_selection != null");
	_tmp10_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_URIS_DIALOG);
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_file_dialog_get_type (), GtkFileDialog));
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp11_;
	_tmp12_ = self->priv->dialog;
	_vala_assert (_tmp12_ != NULL, "this.dialog != null");
	_tmp13_ = self->priv->widgets;
	_tmp14_ = self->priv->treeview;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, (GtkWidget*) _tmp14_);
	{
		GeeArrayList* uris = NULL;
		const gchar* _tmp15_;
		GeeArrayList* _tmp16_;
		_tmp15_ = ((RygelPreferencesSection*) self)->name;
		_tmp16_ = rygel_configuration_get_string_list ((RygelConfiguration*) config, _tmp15_, RYGEL_MEDIA_PREF_SECTION_URIS_KEY, &_inner_error0_);
		uris = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeArrayList* _uri_list = NULL;
			GeeArrayList* _tmp17_;
			gint _uri_size = 0;
			GeeArrayList* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _uri_index = 0;
			_tmp17_ = uris;
			_uri_list = _tmp17_;
			_tmp18_ = _uri_list;
			_tmp19_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp18_);
			_tmp20_ = _tmp19_;
			_uri_size = _tmp20_;
			_uri_index = -1;
			while (TRUE) {
				gint _tmp21_;
				gint _tmp22_;
				gchar* uri = NULL;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				gchar* real_uri = NULL;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp27_;
				GtkTreeIter _tmp28_ = {0};
				GtkListStore* _tmp29_;
				GtkTreeIter _tmp30_;
				const gchar* _tmp31_;
				_uri_index = _uri_index + 1;
				_tmp21_ = _uri_index;
				_tmp22_ = _uri_size;
				if (!(_tmp21_ < _tmp22_)) {
					break;
				}
				_tmp23_ = _uri_list;
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _uri_index);
				uri = (gchar*) _tmp24_;
				_tmp25_ = uri;
				_tmp26_ = rygel_media_pref_section_get_real_uri (self, _tmp25_);
				real_uri = _tmp26_;
				_tmp27_ = self->priv->liststore;
				gtk_list_store_append (_tmp27_, &_tmp28_);
				iter = _tmp28_;
				_tmp29_ = self->priv->liststore;
				_tmp30_ = iter;
				_tmp31_ = real_uri;
				gtk_list_store_set (_tmp29_, &_tmp30_, 0, _tmp31_, -1, -1);
				_g_free0 (real_uri);
				_g_free0 (uri);
			}
		}
		_g_object_unref0 (uris);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp32_ = self->priv->dialog;
	_tmp33_ = g_get_home_dir ();
	_tmp34_ = g_file_new_for_commandline_arg (_tmp33_);
	_tmp35_ = _tmp34_;
	gtk_file_dialog_set_initial_folder (_tmp32_, _tmp35_);
	_g_object_unref0 (_tmp35_);
	_tmp36_ = self->priv->dialog;
	gtk_file_dialog_set_modal (_tmp36_, TRUE);
	_tmp37_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_ADD_BUTTON);
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gtk_button_get_type ()) ? ((GtkButton*) _tmp37_) : NULL);
	add_button = _tmp38_;
	g_signal_connect_object (add_button, "clicked", (GCallback) _rygel_media_pref_section_on_add_button_clicked_gtk_button_clicked, self, 0);
	_tmp39_ = self->priv->widgets;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp39_, (GtkWidget*) add_button);
	_tmp40_ = gtk_builder_get_object (builder, RYGEL_MEDIA_PREF_SECTION_REMOVE_BUTTON);
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, gtk_button_get_type ()) ? ((GtkButton*) _tmp40_) : NULL);
	_g_object_unref0 (self->priv->remove_button);
	self->priv->remove_button = _tmp41_;
	_tmp42_ = self->priv->remove_button;
	g_signal_connect_object (_tmp42_, "clicked", (GCallback) _rygel_media_pref_section_on_remove_button_clicked_gtk_button_clicked, self, 0);
	_tmp43_ = self->priv->widgets;
	_tmp44_ = self->priv->remove_button;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, (GtkWidget*) _tmp44_);
	rygel_media_pref_section_on_tree_selection_changed (self);
	_tmp45_ = self->priv->tree_selection;
	g_signal_connect_object (_tmp45_, "changed", (GCallback) _rygel_media_pref_section_on_tree_selection_changed_gtk_tree_selection_changed, self, 0);
	_g_object_unref0 (add_button);
	return self;
}

RygelMediaPrefSection*
rygel_media_pref_section_new (GtkBuilder* builder,
                              RygelWritableUserConfig* config)
{
	return rygel_media_pref_section_construct (RYGEL_TYPE_MEDIA_PREF_SECTION, builder, config);
}

static void
rygel_media_pref_section_real_save (RygelPreferencesSection* base)
{
	RygelMediaPrefSection * self;
	GtkTreeIter iter = {0};
	GeeArrayList* uri_list = NULL;
	GeeArrayList* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	RygelWritableUserConfig* _tmp14_;
	const gchar* _tmp15_;
	GeeArrayList* _tmp16_;
	self = (RygelMediaPrefSection*) base;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	uri_list = _tmp0_;
	_tmp1_ = self->priv->liststore;
	_tmp3_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (_tmp3_) {
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar* uri = NULL;
				GtkListStore* _tmp7_;
				GtkTreeIter _tmp8_;
				gchar* _tmp9_ = NULL;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				GeeArrayList* _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp4_) {
					GtkListStore* _tmp5_;
					gboolean _tmp6_;
					_tmp5_ = self->priv->liststore;
					_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter);
					if (!_tmp6_) {
						break;
					}
				}
				_tmp4_ = FALSE;
				_tmp7_ = self->priv->liststore;
				_tmp8_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp7_, &_tmp8_, 0, &_tmp9_, -1, -1);
				_g_free0 (uri);
				uri = _tmp9_;
				_tmp10_ = uri;
				_tmp11_ = rygel_media_pref_section_uri_to_magic_variable (self, _tmp10_);
				_g_free0 (uri);
				uri = _tmp11_;
				_tmp12_ = uri_list;
				_tmp13_ = uri;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_g_free0 (uri);
			}
		}
	}
	_tmp14_ = ((RygelPreferencesSection*) self)->config;
	_tmp15_ = ((RygelPreferencesSection*) self)->name;
	_tmp16_ = uri_list;
	rygel_writable_user_config_set_string_list (_tmp14_, _tmp15_, RYGEL_MEDIA_PREF_SECTION_URIS_KEY, _tmp16_);
	_g_object_unref0 (uri_list);
}

static void
rygel_media_pref_section_real_set_sensitivity (RygelPreferencesSection* base,
                                               gboolean sensitivity)
{
	RygelMediaPrefSection * self;
	self = (RygelMediaPrefSection*) base;
	{
		GeeArrayList* _widget_list = NULL;
		GeeArrayList* _tmp0_;
		gint _widget_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _widget_index = 0;
		_tmp0_ = self->priv->widgets;
		_widget_list = _tmp0_;
		_tmp1_ = _widget_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_widget_size = _tmp3_;
		_widget_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GtkWidget* widget = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GtkWidget* _tmp8_;
			_widget_index = _widget_index + 1;
			_tmp4_ = _widget_index;
			_tmp5_ = _widget_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _widget_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _widget_index);
			widget = (GtkWidget*) _tmp7_;
			_tmp8_ = widget;
			gtk_widget_set_sensitive (_tmp8_, sensitivity);
			_g_object_unref0 (widget);
		}
	}
	if (sensitivity) {
		rygel_media_pref_section_on_tree_selection_changed (self);
	}
}

static void
rygel_media_pref_section_on_add_button_clicked (RygelMediaPrefSection* self,
                                                GtkButton* button)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	rygel_media_pref_section_add_folders (self, NULL, NULL);
}

static void
rygel_media_pref_section_add_folders_data_free (gpointer _data)
{
	RygelMediaPrefSectionAddFoldersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelMediaPrefSectionAddFoldersData, _data_);
}

static void
rygel_media_pref_section_add_folders (RygelMediaPrefSection* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	RygelMediaPrefSectionAddFoldersData* _data_;
	RygelMediaPrefSection* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (RygelMediaPrefSectionAddFoldersData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, rygel_media_pref_section_add_folders_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_media_pref_section_add_folders_co (_data_);
}

static void
rygel_media_pref_section_add_folders_finish (RygelMediaPrefSection* self,
                                             GAsyncResult* _res_)
{
	RygelMediaPrefSectionAddFoldersData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
rygel_media_pref_section_add_folders_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	RygelMediaPrefSectionAddFoldersData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_media_pref_section_add_folders_co (_data_);
}

static gboolean
rygel_media_pref_section_add_folders_co (RygelMediaPrefSectionAddFoldersData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->dialog;
		_data_->_tmp1_ = _data_->self->priv->treeview;
		_data_->_tmp2_ = gtk_widget_get_root ((GtkWidget*) _data_->_tmp1_);
		_data_->_state_ = 1;
		gtk_file_dialog_select_multiple_folders (_data_->_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_window_get_type (), GtkWindow), NULL, rygel_media_pref_section_add_folders_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = gtk_file_dialog_select_multiple_folders_finish (_data_->_tmp0_, _data_->_res_, &_data_->_inner_error0_);
		_data_->folders = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp4_ = TRUE;
				while (TRUE) {
					if (!_data_->_tmp4_) {
						_data_->_tmp5_ = _data_->i;
						_data_->i = _data_->_tmp5_ + 1;
					}
					_data_->_tmp4_ = FALSE;
					_data_->_tmp6_ = _data_->folders;
					if (!(((guint) _data_->i) < g_list_model_get_n_items (_data_->_tmp6_))) {
						break;
					}
					_data_->_tmp7_ = _data_->folders;
					_data_->_tmp8_ = g_list_model_get_item (_data_->_tmp7_, (guint) _data_->i);
					_data_->dir = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp8_, g_file_get_type (), GFile);
					_data_->_tmp9_ = _data_->dir;
					_data_->_tmp10_ = g_file_get_path (_data_->_tmp9_);
					_data_->path = _data_->_tmp10_;
					_data_->_tmp11_ = _data_->path;
					if (_data_->_tmp11_ == NULL) {
						_data_->_tmp12_ = _data_->dir;
						_data_->_tmp13_ = g_file_get_uri (_data_->_tmp12_);
						_g_free0 (_data_->path);
						_data_->path = _data_->_tmp13_;
					}
					_data_->_tmp14_ = _data_->self->priv->liststore;
					memset (&_data_->_tmp15_, 0, sizeof (GtkTreeIter));
					gtk_list_store_append (_data_->_tmp14_, &_data_->_tmp15_);
					_data_->iter = _data_->_tmp15_;
					_data_->_tmp16_ = _data_->self->priv->liststore;
					_data_->_tmp17_ = _data_->iter;
					_data_->_tmp18_ = _data_->path;
					gtk_list_store_set (_data_->_tmp16_, &_data_->_tmp17_, 0, _data_->_tmp18_, -1, -1);
					_g_free0 (_data_->path);
					_g_object_unref0 (_data_->dir);
				}
			}
		}
		_g_object_unref0 (_data_->folders);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp19_ = _data_->err;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_warning ("rygel-media-pref-section.vala:137: Failed to chose folders: %s", _data_->_tmp20_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GtkTreeRowReference*
_vala_GtkTreeRowReference_copy (GtkTreeRowReference* self)
{
	return g_boxed_copy (gtk_tree_row_reference_get_type (), self);
}

static void
_vala_GtkTreeRowReference_free (GtkTreeRowReference* self)
{
	g_boxed_free (gtk_tree_row_reference_get_type (), self);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static void
rygel_media_pref_section_on_remove_button_clicked (RygelMediaPrefSection* self,
                                                   GtkButton* button)
{
	GtkTreeSelection* selection = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GList* rows = NULL;
	GtkTreeSelection* _tmp3_;
	GList* _tmp4_;
	GeeArrayList* row_refs = NULL;
	GeeArrayList* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = gtk_tree_selection_get_selected_rows (_tmp3_, NULL);
	rows = _tmp4_;
	_tmp5_ = gee_array_list_new (gtk_tree_row_reference_get_type (), (GBoxedCopyFunc) _vala_GtkTreeRowReference_copy, (GDestroyNotify) _vala_GtkTreeRowReference_free, NULL, NULL, NULL);
	row_refs = _tmp5_;
	_tmp6_ = rows;
	{
		GList* row_collection = NULL;
		GList* row_it = NULL;
		row_collection = _tmp6_;
		for (row_it = row_collection; row_it != NULL; row_it = row_it->next) {
			GtkTreePath* _tmp7_;
			GtkTreePath* row = NULL;
			_tmp7_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) row_it->data);
			row = _tmp7_;
			{
				GeeArrayList* _tmp8_;
				GtkListStore* _tmp9_;
				GtkTreePath* _tmp10_;
				GtkTreeRowReference* _tmp11_;
				GtkTreeRowReference* _tmp12_;
				_tmp8_ = row_refs;
				_tmp9_ = self->priv->liststore;
				_tmp10_ = row;
				_tmp11_ = gtk_tree_row_reference_new ((GtkTreeModel*) _tmp9_, _tmp10_);
				_tmp12_ = _tmp11_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp12_);
				__vala_GtkTreeRowReference_free0 (_tmp12_);
				__vala_GtkTreePath_free0 (row);
			}
		}
	}
	{
		GeeArrayList* _row_ref_list = NULL;
		GeeArrayList* _tmp13_;
		gint _row_ref_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _row_ref_index = 0;
		_tmp13_ = row_refs;
		_row_ref_list = _tmp13_;
		_tmp14_ = _row_ref_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_row_ref_size = _tmp16_;
		_row_ref_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			GtkTreeRowReference* row_ref = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			GtkTreeIter iter = {0};
			GtkTreePath* path = NULL;
			GtkTreeRowReference* _tmp21_;
			GtkTreePath* _tmp22_;
			GtkListStore* _tmp23_;
			GtkTreePath* _tmp24_;
			GtkTreeIter _tmp25_ = {0};
			GtkListStore* _tmp26_;
			_row_ref_index = _row_ref_index + 1;
			_tmp17_ = _row_ref_index;
			_tmp18_ = _row_ref_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _row_ref_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _row_ref_index);
			row_ref = (GtkTreeRowReference*) _tmp20_;
			_tmp21_ = row_ref;
			_tmp22_ = gtk_tree_row_reference_get_path (_tmp21_);
			path = _tmp22_;
			_tmp23_ = self->priv->liststore;
			_tmp24_ = path;
			gtk_tree_model_get_iter ((GtkTreeModel*) _tmp23_, &_tmp25_, _tmp24_);
			iter = _tmp25_;
			_tmp26_ = self->priv->liststore;
			gtk_list_store_remove (_tmp26_, &iter);
			__vala_GtkTreePath_free0 (path);
			__vala_GtkTreeRowReference_free0 (row_ref);
		}
	}
	_g_object_unref0 (row_refs);
	(rows == NULL) ? NULL : (rows = (_g_list_free___vala_GtkTreePath_free0_ (rows), NULL));
	_g_object_unref0 (selection);
}

static gchar*
rygel_media_pref_section_get_real_uri (RygelMediaPrefSection* self,
                                       const gchar* uri)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("@MUSIC@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp3_;
				gchar* _tmp4_;
				_tmp3_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
				_tmp4_ = g_strdup (_tmp3_);
				result = _tmp4_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("@VIDEOS@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
				_tmp6_ = g_strdup (_tmp5_);
				result = _tmp6_;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("@PICTURES@")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
				_tmp8_ = g_strdup (_tmp7_);
				result = _tmp8_;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (uri);
				result = _tmp9_;
				return result;
			}
		}
	}
}

static gchar*
rygel_media_pref_section_uri_to_magic_variable (RygelMediaPrefSection* self,
                                                const gchar* uri)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	if (g_strcmp0 (uri, _tmp0_) == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("@MUSIC@");
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
		if (g_strcmp0 (uri, _tmp2_) == 0) {
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("@VIDEOS@");
			result = _tmp3_;
			return result;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
			if (g_strcmp0 (uri, _tmp4_) == 0) {
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("@PICTURES@");
				result = _tmp5_;
				return result;
			} else {
				gchar* _tmp6_;
				_tmp6_ = g_strdup (uri);
				result = _tmp6_;
				return result;
			}
		}
	}
}

static void
rygel_media_pref_section_on_tree_selection_changed (RygelMediaPrefSection* self)
{
	GtkTreeSelection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tree_selection;
	if (gtk_tree_selection_get_selected (_tmp0_, NULL, NULL)) {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->remove_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	} else {
		GtkButton* _tmp2_;
		_tmp2_ = self->priv->remove_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
	}
}

static void
rygel_media_pref_section_class_init (RygelMediaPrefSectionClass * klass,
                                     gpointer klass_data)
{
	rygel_media_pref_section_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelMediaPrefSection_private_offset);
	((RygelPreferencesSectionClass *) klass)->save = (void (*) (RygelPreferencesSection*)) rygel_media_pref_section_real_save;
	((RygelPreferencesSectionClass *) klass)->set_sensitivity = (void (*) (RygelPreferencesSection*, gboolean)) rygel_media_pref_section_real_set_sensitivity;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_pref_section_finalize;
}

static void
rygel_media_pref_section_instance_init (RygelMediaPrefSection * self,
                                        gpointer klass)
{
	self->priv = rygel_media_pref_section_get_instance_private (self);
}

static void
rygel_media_pref_section_finalize (GObject * obj)
{
	RygelMediaPrefSection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_PREF_SECTION, RygelMediaPrefSection);
	_g_object_unref0 (self->priv->widgets);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->liststore);
	_g_object_unref0 (self->priv->tree_selection);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->remove_button);
	G_OBJECT_CLASS (rygel_media_pref_section_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
rygel_media_pref_section_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelMediaPrefSectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_pref_section_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaPrefSection), 0, (GInstanceInitFunc) rygel_media_pref_section_instance_init, NULL };
	GType rygel_media_pref_section_type_id;
	rygel_media_pref_section_type_id = g_type_register_static (RYGEL_TYPE_PREFERENCES_SECTION, "RygelMediaPrefSection", &g_define_type_info, 0);
	RygelMediaPrefSection_private_offset = g_type_add_instance_private (rygel_media_pref_section_type_id, sizeof (RygelMediaPrefSectionPrivate));
	return rygel_media_pref_section_type_id;
}

GType
rygel_media_pref_section_get_type (void)
{
	static volatile gsize rygel_media_pref_section_type_id__once = 0;
	if (g_once_init_enter (&rygel_media_pref_section_type_id__once)) {
		GType rygel_media_pref_section_type_id;
		rygel_media_pref_section_type_id = rygel_media_pref_section_get_type_once ();
		g_once_init_leave (&rygel_media_pref_section_type_id__once, rygel_media_pref_section_type_id);
	}
	return rygel_media_pref_section_type_id__once;
}

