// ----------------------------------------------------------------------------
//
//  Copyright (C) 2015-2018 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __DELAY_H
#define __DELAY_H


#include <stdint.h>


class Delay
{
public:

    Delay (void);
    ~Delay (void);

    void init (int32_t maxdel, int32_t frag);
    void reset (void);
    void commit (void);
    void write (const float *p);
    const float *readp (int32_t delay); 	
    
private:

    int32_t  _size;
    int32_t  _frag;
    int32_t  _wind;
    float   *_data;
};


#endif
