//  ------------------------------------------------------------------------
//
//  Copyright (C) 2023 Fons Adriaensen <fons@linuxaudio.org>
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//  ------------------------------------------------------------------------


#ifndef __BW8FILTER_H
#define __BW8FILTER_H

#include <string.h>


// 8th order Butterworth lowpass and highpass filter.
// The 'f' parameter is the -3 dB frequency divided by
// the sample rate.


class Bw8filter
{
public:

    Bw8filter (void)
    {
	memset (_cz, 0, 8 * sizeof (float));
	memset (_a0, 0, 4 * sizeof (float));
	_g = 0.0f;
	reset ();
    }
    ~Bw8filter (void) {}

    void reset (void)
    {
        memset (_z, 0, 8 * sizeof (float));
    };

    void init (float f);
    void proclowpass (int n, const float *inp, float *out, float gain = 1.0f);
    void prochighpass (int n, const float *inp, float *out, float gain = 1.0f);

private:

    void init1 (int i, float w, float d);
    
    float _z [8];  // filter state 
    float _cz [8]; // integrator coefficients
    float _a0 [4]; // lowpass coefficients
    float _g;      // highpass gain
};


#endif
