/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.12.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/kbdstate.h>



PyDoc_STRVAR(doc_wxKeyboardState_GetModifiers, "GetModifiers() -> int\n"
"\n"
"Return the bit mask of all pressed modifier keys.");

extern "C" {static PyObject *meth_wxKeyboardState_GetModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_GetModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_GetModifiers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_HasAnyModifiers, "HasAnyModifiers() -> bool\n"
"\n"
"Returns true if any modifiers at all are pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_HasAnyModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_HasAnyModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasAnyModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_HasAnyModifiers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_HasModifiers, "HasModifiers() -> bool\n"
"\n"
"Returns true if Control or Alt are pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_HasModifiers(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_HasModifiers(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasModifiers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_HasModifiers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_ControlDown, "ControlDown() -> bool\n"
"\n"
"Returns true if the Control key or Apple/Command key under macOS is\n"
"pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_ControlDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_ControlDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ControlDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_ControlDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_RawControlDown, "RawControlDown() -> bool\n"
"\n"
"Returns true if the Control key (also under macOS).");

extern "C" {static PyObject *meth_wxKeyboardState_RawControlDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_RawControlDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RawControlDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_RawControlDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_ShiftDown, "ShiftDown() -> bool\n"
"\n"
"Returns true if the Shift key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_ShiftDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_ShiftDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ShiftDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_ShiftDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_MetaDown, "MetaDown() -> bool\n"
"\n"
"Returns true if the Meta/Windows/Apple key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_MetaDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_MetaDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->MetaDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_MetaDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_AltDown, "AltDown() -> bool\n"
"\n"
"Returns true if the Alt key is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_AltDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_AltDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AltDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_AltDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_CmdDown, "CmdDown() -> bool\n"
"\n"
"Returns true if the key used for command accelerators is pressed.");

extern "C" {static PyObject *meth_wxKeyboardState_CmdDown(PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_CmdDown(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxKeyboardState *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxKeyboardState, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CmdDown();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_CmdDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetControlDown, "SetControlDown(down) -> None");

extern "C" {static PyObject *meth_wxKeyboardState_SetControlDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetControlDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
        ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetControlDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetControlDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetRawControlDown, "SetRawControlDown(down) -> None");

extern "C" {static PyObject *meth_wxKeyboardState_SetRawControlDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetRawControlDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
        ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetRawControlDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetRawControlDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetShiftDown, "SetShiftDown(down) -> None");

extern "C" {static PyObject *meth_wxKeyboardState_SetShiftDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetShiftDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
        ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetShiftDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetShiftDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetAltDown, "SetAltDown(down) -> None");

extern "C" {static PyObject *meth_wxKeyboardState_SetAltDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetAltDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
        ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAltDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetAltDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxKeyboardState_SetMetaDown, "SetMetaDown(down) -> None");

extern "C" {static PyObject *meth_wxKeyboardState_SetMetaDown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxKeyboardState_SetMetaDown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool down;
        ::wxKeyboardState *sipCpp;

        static const char *sipKwdList[] = {
            sipName_down,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bb", &sipSelf, sipType_wxKeyboardState, &sipCpp, &down))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetMetaDown(down);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_KeyboardState, sipName_SetMetaDown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxKeyboardState(void *, int);}
static void release_wxKeyboardState(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxKeyboardState *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxKeyboardState(Py_ssize_t);}
static void *array_wxKeyboardState(Py_ssize_t sipNrElem)
{
    return new ::wxKeyboardState[sipNrElem];
}


extern "C" {static void array_delete_wxKeyboardState(void *);}
static void array_delete_wxKeyboardState(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxKeyboardState *>(sipCpp);
}


extern "C" {static void assign_wxKeyboardState(void *, Py_ssize_t, void *);}
static void assign_wxKeyboardState(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxKeyboardState *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxKeyboardState *>(sipSrc);
}


extern "C" {static void *copy_wxKeyboardState(const void *, Py_ssize_t);}
static void *copy_wxKeyboardState(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxKeyboardState(reinterpret_cast<const ::wxKeyboardState *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxKeyboardState(sipSimpleWrapper *);}
static void dealloc_wxKeyboardState(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxKeyboardState(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxKeyboardState(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxKeyboardState(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxKeyboardState *sipCpp = SIP_NULLPTR;

    {
        bool controlDown = 0;
        bool shiftDown = 0;
        bool altDown = 0;
        bool metaDown = 0;

        static const char *sipKwdList[] = {
            sipName_controlDown,
            sipName_shiftDown,
            sipName_altDown,
            sipName_metaDown,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|bbbb", &controlDown, &shiftDown, &altDown, &metaDown))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxKeyboardState(controlDown, shiftDown, altDown, metaDown);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxKeyboardState* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxKeyboardState, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxKeyboardState(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxKeyboardState[] = {
    {sipName_AltDown, meth_wxKeyboardState_AltDown, METH_VARARGS, doc_wxKeyboardState_AltDown},
    {sipName_CmdDown, meth_wxKeyboardState_CmdDown, METH_VARARGS, doc_wxKeyboardState_CmdDown},
    {sipName_ControlDown, meth_wxKeyboardState_ControlDown, METH_VARARGS, doc_wxKeyboardState_ControlDown},
    {sipName_GetModifiers, meth_wxKeyboardState_GetModifiers, METH_VARARGS, doc_wxKeyboardState_GetModifiers},
    {sipName_HasAnyModifiers, meth_wxKeyboardState_HasAnyModifiers, METH_VARARGS, doc_wxKeyboardState_HasAnyModifiers},
    {sipName_HasModifiers, meth_wxKeyboardState_HasModifiers, METH_VARARGS, doc_wxKeyboardState_HasModifiers},
    {sipName_MetaDown, meth_wxKeyboardState_MetaDown, METH_VARARGS, doc_wxKeyboardState_MetaDown},
    {sipName_RawControlDown, meth_wxKeyboardState_RawControlDown, METH_VARARGS, doc_wxKeyboardState_RawControlDown},
    {sipName_SetAltDown, SIP_MLMETH_CAST(meth_wxKeyboardState_SetAltDown), METH_VARARGS|METH_KEYWORDS, doc_wxKeyboardState_SetAltDown},
    {sipName_SetControlDown, SIP_MLMETH_CAST(meth_wxKeyboardState_SetControlDown), METH_VARARGS|METH_KEYWORDS, doc_wxKeyboardState_SetControlDown},
    {sipName_SetMetaDown, SIP_MLMETH_CAST(meth_wxKeyboardState_SetMetaDown), METH_VARARGS|METH_KEYWORDS, doc_wxKeyboardState_SetMetaDown},
    {sipName_SetRawControlDown, SIP_MLMETH_CAST(meth_wxKeyboardState_SetRawControlDown), METH_VARARGS|METH_KEYWORDS, doc_wxKeyboardState_SetRawControlDown},
    {sipName_SetShiftDown, SIP_MLMETH_CAST(meth_wxKeyboardState_SetShiftDown), METH_VARARGS|METH_KEYWORDS, doc_wxKeyboardState_SetShiftDown},
    {sipName_ShiftDown, meth_wxKeyboardState_ShiftDown, METH_VARARGS, doc_wxKeyboardState_ShiftDown}
};

sipVariableDef variables_wxKeyboardState[] = {
    {PropertyVariable, sipName_cmdDown, &methods_wxKeyboardState[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_metaDown, &methods_wxKeyboardState[6], &methods_wxKeyboardState[10], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_altDown, &methods_wxKeyboardState[0], &methods_wxKeyboardState[8], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_shiftDown, &methods_wxKeyboardState[13], &methods_wxKeyboardState[12], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_rawControlDown, &methods_wxKeyboardState[7], &methods_wxKeyboardState[11], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_controlDown, &methods_wxKeyboardState[2], &methods_wxKeyboardState[9], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxKeyboardState, "KeyboardState(controlDown=False, shiftDown=False, altDown=False, metaDown=False) -> None\n"
"\n"
"Provides methods for testing the state of the keyboard modifier keys.");


sipClassTypeDef sipTypeDef__core_wxKeyboardState = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxKeyboardState,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_KeyboardState,
        {0, 0, 1},
        14, methods_wxKeyboardState,
        0, SIP_NULLPTR,
        6, variables_wxKeyboardState,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxKeyboardState,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxKeyboardState,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxKeyboardState,
    assign_wxKeyboardState,
    array_wxKeyboardState,
    copy_wxKeyboardState,
    release_wxKeyboardState,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxKeyboardState,
    sizeof (::wxKeyboardState),
};
