#define _CFFI_

/* We try to define Py_LIMITED_API before including Python.h.

   Mess: we can only define it if Py_DEBUG, Py_TRACE_REFS and
   Py_REF_DEBUG are not defined.  This is a best-effort approximation:
   we can learn about Py_DEBUG from pyconfig.h, but it is unclear if
   the same works for the other two macros.  Py_DEBUG implies them,
   but not the other way around.

   The implementation is messy (issue #350): on Windows, with _MSC_VER,
   we have to define Py_LIMITED_API even before including pyconfig.h.
   In that case, we guess what pyconfig.h will do to the macros above,
   and check our guess after the #include.

   Note that on Windows, with CPython 3.x, you need >= 3.5 and virtualenv
   version >= 16.0.0.  With older versions of either, you don't get a
   copy of PYTHON3.DLL in the virtualenv.  We can't check the version of
   CPython *before* we even include pyconfig.h.  ffi.set_source() puts
   a ``#define _CFFI_NO_LIMITED_API'' at the start of this file if it is
   running on Windows < 3.5, as an attempt at fixing it, but that's
   arguably wrong because it may not be the target version of Python.
   Still better than nothing I guess.  As another workaround, you can
   remove the definition of Py_LIMITED_API here.

   See also 'py_limited_api' in cffi/setuptools_ext.py.
*/
#if !defined(_CFFI_USE_EMBEDDING) && !defined(Py_LIMITED_API)
#  ifdef _MSC_VER
#    if !defined(_DEBUG) && !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#    include <pyconfig.h>
     /* sanity-check: Py_LIMITED_API will cause crashes if any of these
        are also defined.  Normally, the Python file PC/pyconfig.h does not
        cause any of these to be defined, with the exception that _DEBUG
        causes Py_DEBUG.  Double-check that. */
#    ifdef Py_LIMITED_API
#      if defined(Py_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_DEBUG, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_TRACE_REFS)
#        error "pyconfig.h unexpectedly defines Py_TRACE_REFS, but Py_LIMITED_API is set"
#      endif
#      if defined(Py_REF_DEBUG)
#        error "pyconfig.h unexpectedly defines Py_REF_DEBUG, but Py_LIMITED_API is set"
#      endif
#    endif
#  else
#    include <pyconfig.h>
#    if !defined(Py_DEBUG) && !defined(Py_TRACE_REFS) && !defined(Py_REF_DEBUG) && !defined(_CFFI_NO_LIMITED_API)
#      define Py_LIMITED_API
#    endif
#  endif
#endif

#include <Python.h>
#ifdef __cplusplus
extern "C" {
#endif
#include <stddef.h>

/* This part is from file 'cffi/parse_c_type.h'.  It is copied at the
   beginning of C sources generated by CFFI's ffi.set_source(). */

typedef void *_cffi_opcode_t;

#define _CFFI_OP(opcode, arg)   (_cffi_opcode_t)(opcode | (((uintptr_t)(arg)) << 8))
#define _CFFI_GETOP(cffi_opcode)    ((unsigned char)(uintptr_t)cffi_opcode)
#define _CFFI_GETARG(cffi_opcode)   (((intptr_t)cffi_opcode) >> 8)

#define _CFFI_OP_PRIMITIVE       1
#define _CFFI_OP_POINTER         3
#define _CFFI_OP_ARRAY           5
#define _CFFI_OP_OPEN_ARRAY      7
#define _CFFI_OP_STRUCT_UNION    9
#define _CFFI_OP_ENUM           11
#define _CFFI_OP_FUNCTION       13
#define _CFFI_OP_FUNCTION_END   15
#define _CFFI_OP_NOOP           17
#define _CFFI_OP_BITFIELD       19
#define _CFFI_OP_TYPENAME       21
#define _CFFI_OP_CPYTHON_BLTN_V 23   // varargs
#define _CFFI_OP_CPYTHON_BLTN_N 25   // noargs
#define _CFFI_OP_CPYTHON_BLTN_O 27   // O  (i.e. a single arg)
#define _CFFI_OP_CONSTANT       29
#define _CFFI_OP_CONSTANT_INT   31
#define _CFFI_OP_GLOBAL_VAR     33
#define _CFFI_OP_DLOPEN_FUNC    35
#define _CFFI_OP_DLOPEN_CONST   37
#define _CFFI_OP_GLOBAL_VAR_F   39
#define _CFFI_OP_EXTERN_PYTHON  41

#define _CFFI_PRIM_VOID          0
#define _CFFI_PRIM_BOOL          1
#define _CFFI_PRIM_CHAR          2
#define _CFFI_PRIM_SCHAR         3
#define _CFFI_PRIM_UCHAR         4
#define _CFFI_PRIM_SHORT         5
#define _CFFI_PRIM_USHORT        6
#define _CFFI_PRIM_INT           7
#define _CFFI_PRIM_UINT          8
#define _CFFI_PRIM_LONG          9
#define _CFFI_PRIM_ULONG        10
#define _CFFI_PRIM_LONGLONG     11
#define _CFFI_PRIM_ULONGLONG    12
#define _CFFI_PRIM_FLOAT        13
#define _CFFI_PRIM_DOUBLE       14
#define _CFFI_PRIM_LONGDOUBLE   15

#define _CFFI_PRIM_WCHAR        16
#define _CFFI_PRIM_INT8         17
#define _CFFI_PRIM_UINT8        18
#define _CFFI_PRIM_INT16        19
#define _CFFI_PRIM_UINT16       20
#define _CFFI_PRIM_INT32        21
#define _CFFI_PRIM_UINT32       22
#define _CFFI_PRIM_INT64        23
#define _CFFI_PRIM_UINT64       24
#define _CFFI_PRIM_INTPTR       25
#define _CFFI_PRIM_UINTPTR      26
#define _CFFI_PRIM_PTRDIFF      27
#define _CFFI_PRIM_SIZE         28
#define _CFFI_PRIM_SSIZE        29
#define _CFFI_PRIM_INT_LEAST8   30
#define _CFFI_PRIM_UINT_LEAST8  31
#define _CFFI_PRIM_INT_LEAST16  32
#define _CFFI_PRIM_UINT_LEAST16 33
#define _CFFI_PRIM_INT_LEAST32  34
#define _CFFI_PRIM_UINT_LEAST32 35
#define _CFFI_PRIM_INT_LEAST64  36
#define _CFFI_PRIM_UINT_LEAST64 37
#define _CFFI_PRIM_INT_FAST8    38
#define _CFFI_PRIM_UINT_FAST8   39
#define _CFFI_PRIM_INT_FAST16   40
#define _CFFI_PRIM_UINT_FAST16  41
#define _CFFI_PRIM_INT_FAST32   42
#define _CFFI_PRIM_UINT_FAST32  43
#define _CFFI_PRIM_INT_FAST64   44
#define _CFFI_PRIM_UINT_FAST64  45
#define _CFFI_PRIM_INTMAX       46
#define _CFFI_PRIM_UINTMAX      47
#define _CFFI_PRIM_FLOATCOMPLEX 48
#define _CFFI_PRIM_DOUBLECOMPLEX 49
#define _CFFI_PRIM_CHAR16       50
#define _CFFI_PRIM_CHAR32       51

#define _CFFI__NUM_PRIM         52
#define _CFFI__UNKNOWN_PRIM           (-1)
#define _CFFI__UNKNOWN_FLOAT_PRIM     (-2)
#define _CFFI__UNKNOWN_LONG_DOUBLE    (-3)

#define _CFFI__IO_FILE_STRUCT         (-1)


struct _cffi_global_s {
    const char *name;
    void *address;
    _cffi_opcode_t type_op;
    void *size_or_direct_fn;  // OP_GLOBAL_VAR: size, or 0 if unknown
                              // OP_CPYTHON_BLTN_*: addr of direct function
};

struct _cffi_getconst_s {
    unsigned long long value;
    const struct _cffi_type_context_s *ctx;
    int gindex;
};

struct _cffi_struct_union_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_STRUCT_UNION
    int flags;               // _CFFI_F_* flags below
    size_t size;
    int alignment;
    int first_field_index;   // -> _cffi_fields array
    int num_fields;
};
#define _CFFI_F_UNION         0x01   // is a union, not a struct
#define _CFFI_F_CHECK_FIELDS  0x02   // complain if fields are not in the
                                     // "standard layout" or if some are missing
#define _CFFI_F_PACKED        0x04   // for CHECK_FIELDS, assume a packed struct
#define _CFFI_F_EXTERNAL      0x08   // in some other ffi.include()
#define _CFFI_F_OPAQUE        0x10   // opaque

struct _cffi_field_s {
    const char *name;
    size_t field_offset;
    size_t field_size;
    _cffi_opcode_t field_type_op;
};

struct _cffi_enum_s {
    const char *name;
    int type_index;          // -> _cffi_types, on a OP_ENUM
    int type_prim;           // _CFFI_PRIM_xxx
    const char *enumerators; // comma-delimited string
};

struct _cffi_typename_s {
    const char *name;
    int type_index;   /* if opaque, points to a possibly artificial
                         OP_STRUCT which is itself opaque */
};

struct _cffi_type_context_s {
    _cffi_opcode_t *types;
    const struct _cffi_global_s *globals;
    const struct _cffi_field_s *fields;
    const struct _cffi_struct_union_s *struct_unions;
    const struct _cffi_enum_s *enums;
    const struct _cffi_typename_s *typenames;
    int num_globals;
    int num_struct_unions;
    int num_enums;
    int num_typenames;
    const char *const *includes;
    int num_types;
    int flags;      /* future extension */
};

struct _cffi_parse_info_s {
    const struct _cffi_type_context_s *ctx;
    _cffi_opcode_t *output;
    unsigned int output_size;
    size_t error_location;
    const char *error_message;
};

struct _cffi_externpy_s {
    const char *name;
    size_t size_of_result;
    void *reserved1, *reserved2;
};

#ifdef _CFFI_INTERNAL
static int parse_c_type(struct _cffi_parse_info_s *info, const char *input);
static int search_in_globals(const struct _cffi_type_context_s *ctx,
                             const char *search, size_t search_len);
static int search_in_struct_unions(const struct _cffi_type_context_s *ctx,
                                   const char *search, size_t search_len);
#endif

/* this block of #ifs should be kept exactly identical between
   c/_cffi_backend.c, cffi/vengine_cpy.py, cffi/vengine_gen.py
   and cffi/_cffi_include.h */
#if defined(_MSC_VER)
# include <malloc.h>   /* for alloca() */
# if _MSC_VER < 1600   /* MSVC < 2010 */
   typedef __int8 int8_t;
   typedef __int16 int16_t;
   typedef __int32 int32_t;
   typedef __int64 int64_t;
   typedef unsigned __int8 uint8_t;
   typedef unsigned __int16 uint16_t;
   typedef unsigned __int32 uint32_t;
   typedef unsigned __int64 uint64_t;
   typedef __int8 int_least8_t;
   typedef __int16 int_least16_t;
   typedef __int32 int_least32_t;
   typedef __int64 int_least64_t;
   typedef unsigned __int8 uint_least8_t;
   typedef unsigned __int16 uint_least16_t;
   typedef unsigned __int32 uint_least32_t;
   typedef unsigned __int64 uint_least64_t;
   typedef __int8 int_fast8_t;
   typedef __int16 int_fast16_t;
   typedef __int32 int_fast32_t;
   typedef __int64 int_fast64_t;
   typedef unsigned __int8 uint_fast8_t;
   typedef unsigned __int16 uint_fast16_t;
   typedef unsigned __int32 uint_fast32_t;
   typedef unsigned __int64 uint_fast64_t;
   typedef __int64 intmax_t;
   typedef unsigned __int64 uintmax_t;
# else
#  include <stdint.h>
# endif
# if _MSC_VER < 1800   /* MSVC < 2013 */
#  ifndef __cplusplus
    typedef unsigned char _Bool;
#  endif
# endif
# define _cffi_float_complex_t   _Fcomplex    /* include <complex.h> for it */
# define _cffi_double_complex_t  _Dcomplex    /* include <complex.h> for it */
#else
# include <stdint.h>
# if (defined (__SVR4) && defined (__sun)) || defined(_AIX) || defined(__hpux)
#  include <alloca.h>
# endif
# define _cffi_float_complex_t   float _Complex
# define _cffi_double_complex_t  double _Complex
#endif

#ifdef __GNUC__
# define _CFFI_UNUSED_FN  __attribute__((unused))
#else
# define _CFFI_UNUSED_FN  /* nothing */
#endif

#ifdef __cplusplus
# ifndef _Bool
   typedef bool _Bool;   /* semi-hackish: C++ has no _Bool; bool is builtin */
# endif
#endif

/**********  CPython-specific section  **********/
#ifndef PYPY_VERSION


#if PY_MAJOR_VERSION >= 3
# define PyInt_FromLong PyLong_FromLong
#endif

#define _cffi_from_c_double PyFloat_FromDouble
#define _cffi_from_c_float PyFloat_FromDouble
#define _cffi_from_c_long PyInt_FromLong
#define _cffi_from_c_ulong PyLong_FromUnsignedLong
#define _cffi_from_c_longlong PyLong_FromLongLong
#define _cffi_from_c_ulonglong PyLong_FromUnsignedLongLong
#define _cffi_from_c__Bool PyBool_FromLong

#define _cffi_to_c_double PyFloat_AsDouble
#define _cffi_to_c_float PyFloat_AsDouble

#define _cffi_from_c_int(x, type)                                        \
    (((type)-1) > 0 ? /* unsigned */                                     \
        (sizeof(type) < sizeof(long) ?                                   \
            PyInt_FromLong((long)x) :                                    \
         sizeof(type) == sizeof(long) ?                                  \
            PyLong_FromUnsignedLong((unsigned long)x) :                  \
            PyLong_FromUnsignedLongLong((unsigned long long)x)) :        \
        (sizeof(type) <= sizeof(long) ?                                  \
            PyInt_FromLong((long)x) :                                    \
            PyLong_FromLongLong((long long)x)))

#define _cffi_to_c_int(o, type)                                          \
    ((type)(                                                             \
     sizeof(type) == 1 ? (((type)-1) > 0 ? (type)_cffi_to_c_u8(o)        \
                                         : (type)_cffi_to_c_i8(o)) :     \
     sizeof(type) == 2 ? (((type)-1) > 0 ? (type)_cffi_to_c_u16(o)       \
                                         : (type)_cffi_to_c_i16(o)) :    \
     sizeof(type) == 4 ? (((type)-1) > 0 ? (type)_cffi_to_c_u32(o)       \
                                         : (type)_cffi_to_c_i32(o)) :    \
     sizeof(type) == 8 ? (((type)-1) > 0 ? (type)_cffi_to_c_u64(o)       \
                                         : (type)_cffi_to_c_i64(o)) :    \
     (Py_FatalError("unsupported size for type " #type), (type)0)))

#define _cffi_to_c_i8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[1])
#define _cffi_to_c_u8                                                    \
                 ((int(*)(PyObject *))_cffi_exports[2])
#define _cffi_to_c_i16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[3])
#define _cffi_to_c_u16                                                   \
                 ((int(*)(PyObject *))_cffi_exports[4])
#define _cffi_to_c_i32                                                   \
                 ((int(*)(PyObject *))_cffi_exports[5])
#define _cffi_to_c_u32                                                   \
                 ((unsigned int(*)(PyObject *))_cffi_exports[6])
#define _cffi_to_c_i64                                                   \
                 ((long long(*)(PyObject *))_cffi_exports[7])
#define _cffi_to_c_u64                                                   \
                 ((unsigned long long(*)(PyObject *))_cffi_exports[8])
#define _cffi_to_c_char                                                  \
                 ((int(*)(PyObject *))_cffi_exports[9])
#define _cffi_from_c_pointer                                             \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[10])
#define _cffi_to_c_pointer                                               \
    ((char *(*)(PyObject *, struct _cffi_ctypedescr *))_cffi_exports[11])
#define _cffi_get_struct_layout                                          \
    not used any more
#define _cffi_restore_errno                                              \
    ((void(*)(void))_cffi_exports[13])
#define _cffi_save_errno                                                 \
    ((void(*)(void))_cffi_exports[14])
#define _cffi_from_c_char                                                \
    ((PyObject *(*)(char))_cffi_exports[15])
#define _cffi_from_c_deref                                               \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[16])
#define _cffi_to_c                                                       \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[17])
#define _cffi_from_c_struct                                              \
    ((PyObject *(*)(char *, struct _cffi_ctypedescr *))_cffi_exports[18])
#define _cffi_to_c_wchar_t                                               \
    ((_cffi_wchar_t(*)(PyObject *))_cffi_exports[19])
#define _cffi_from_c_wchar_t                                             \
    ((PyObject *(*)(_cffi_wchar_t))_cffi_exports[20])
#define _cffi_to_c_long_double                                           \
    ((long double(*)(PyObject *))_cffi_exports[21])
#define _cffi_to_c__Bool                                                 \
    ((_Bool(*)(PyObject *))_cffi_exports[22])
#define _cffi_prepare_pointer_call_argument                              \
    ((Py_ssize_t(*)(struct _cffi_ctypedescr *,                           \
                    PyObject *, char **))_cffi_exports[23])
#define _cffi_convert_array_from_object                                  \
    ((int(*)(char *, struct _cffi_ctypedescr *, PyObject *))_cffi_exports[24])
#define _CFFI_CPIDX  25
#define _cffi_call_python                                                \
    ((void(*)(struct _cffi_externpy_s *, char *))_cffi_exports[_CFFI_CPIDX])
#define _cffi_to_c_wchar3216_t                                           \
    ((int(*)(PyObject *))_cffi_exports[26])
#define _cffi_from_c_wchar3216_t                                         \
    ((PyObject *(*)(int))_cffi_exports[27])
#define _CFFI_NUM_EXPORTS 28

struct _cffi_ctypedescr;

static void *_cffi_exports[_CFFI_NUM_EXPORTS];

#define _cffi_type(index)   (                           \
    assert((((uintptr_t)_cffi_types[index]) & 1) == 0), \
    (struct _cffi_ctypedescr *)_cffi_types[index])

static PyObject *_cffi_init(const char *module_name, Py_ssize_t version,
                            const struct _cffi_type_context_s *ctx)
{
    PyObject *module, *o_arg, *new_module;
    void *raw[] = {
        (void *)module_name,
        (void *)version,
        (void *)_cffi_exports,
        (void *)ctx,
    };

    module = PyImport_ImportModule("_cffi_backend");
    if (module == NULL)
        goto failure;

    o_arg = PyLong_FromVoidPtr((void *)raw);
    if (o_arg == NULL)
        goto failure;

    new_module = PyObject_CallMethod(
        module, (char *)"_init_cffi_1_0_external_module", (char *)"O", o_arg);

    Py_DECREF(o_arg);
    Py_DECREF(module);
    return new_module;

  failure:
    Py_XDECREF(module);
    return NULL;
}


#ifdef HAVE_WCHAR_H
typedef wchar_t _cffi_wchar_t;
#else
typedef uint16_t _cffi_wchar_t;   /* same random pick as _cffi_backend.c */
#endif

_CFFI_UNUSED_FN static uint16_t _cffi_to_c_char16_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return (uint16_t)_cffi_to_c_wchar_t(o);
    else
        return (uint16_t)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char16_t(uint16_t x)
{
    if (sizeof(_cffi_wchar_t) == 2)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

_CFFI_UNUSED_FN static int _cffi_to_c_char32_t(PyObject *o)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return (int)_cffi_to_c_wchar_t(o);
    else
        return (int)_cffi_to_c_wchar3216_t(o);
}

_CFFI_UNUSED_FN static PyObject *_cffi_from_c_char32_t(unsigned int x)
{
    if (sizeof(_cffi_wchar_t) == 4)
        return _cffi_from_c_wchar_t((_cffi_wchar_t)x);
    else
        return _cffi_from_c_wchar3216_t((int)x);
}

union _cffi_union_alignment_u {
    unsigned char m_char;
    unsigned short m_short;
    unsigned int m_int;
    unsigned long m_long;
    unsigned long long m_longlong;
    float m_float;
    double m_double;
    long double m_longdouble;
};

struct _cffi_freeme_s {
    struct _cffi_freeme_s *next;
    union _cffi_union_alignment_u alignment;
};

_CFFI_UNUSED_FN static int
_cffi_convert_array_argument(struct _cffi_ctypedescr *ctptr, PyObject *arg,
                             char **output_data, Py_ssize_t datasize,
                             struct _cffi_freeme_s **freeme)
{
    char *p;
    if (datasize < 0)
        return -1;

    p = *output_data;
    if (p == NULL) {
        struct _cffi_freeme_s *fp = (struct _cffi_freeme_s *)PyObject_Malloc(
            offsetof(struct _cffi_freeme_s, alignment) + (size_t)datasize);
        if (fp == NULL)
            return -1;
        fp->next = *freeme;
        *freeme = fp;
        p = *output_data = (char *)&fp->alignment;
    }
    memset((void *)p, 0, (size_t)datasize);
    return _cffi_convert_array_from_object(p, ctptr, arg);
}

_CFFI_UNUSED_FN static void
_cffi_free_array_arguments(struct _cffi_freeme_s *freeme)
{
    do {
        void *p = (void *)freeme;
        freeme = freeme->next;
        PyObject_Free(p);
    } while (freeme != NULL);
}

/**********  end CPython-specific section  **********/
#else
_CFFI_UNUSED_FN
static void (*_cffi_call_python_org)(struct _cffi_externpy_s *, char *);
# define _cffi_call_python  _cffi_call_python_org
#endif


#define _cffi_array_len(array)   (sizeof(array) / sizeof((array)[0]))

#define _cffi_prim_int(size, sign)                                      \
    ((size) == 1 ? ((sign) ? _CFFI_PRIM_INT8  : _CFFI_PRIM_UINT8)  :    \
     (size) == 2 ? ((sign) ? _CFFI_PRIM_INT16 : _CFFI_PRIM_UINT16) :    \
     (size) == 4 ? ((sign) ? _CFFI_PRIM_INT32 : _CFFI_PRIM_UINT32) :    \
     (size) == 8 ? ((sign) ? _CFFI_PRIM_INT64 : _CFFI_PRIM_UINT64) :    \
     _CFFI__UNKNOWN_PRIM)

#define _cffi_prim_float(size)                                          \
    ((size) == sizeof(float) ? _CFFI_PRIM_FLOAT :                       \
     (size) == sizeof(double) ? _CFFI_PRIM_DOUBLE :                     \
     (size) == sizeof(long double) ? _CFFI__UNKNOWN_LONG_DOUBLE :       \
     _CFFI__UNKNOWN_FLOAT_PRIM)

#define _cffi_check_int(got, got_nonpos, expected)      \
    ((got_nonpos) == (expected <= 0) &&                 \
     (got) == (unsigned long long)expected)

#ifdef MS_WIN32
# define _cffi_stdcall  __stdcall
#else
# define _cffi_stdcall  /* nothing */
#endif

#ifdef __cplusplus
}
#endif

/************************************************************/


#ifdef _WIN32
#define WIN32_LEAN_AND_MEAN
# include <WinSock2.h>
#else
# include <sys/types.h>
# include <sys/socket.h>
# include <netdb.h> /* struct hostent */
# include <netinet/in.h> /* struct sockaddr_in/sockaddr_in6 */
#endif
#include <ares.h>
#include <ares_dns_record.h>


/************************************************************/

static void *_cffi_types[] = {
/*  0 */ _CFFI_OP(_CFFI_OP_FUNCTION, 252), // ares_bool_t()(void)
/*  1 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  2 */ _CFFI_OP(_CFFI_OP_FUNCTION, 24), // ares_dns_class_t()(ares_dns_rr_t const *)
/*  3 */ _CFFI_OP(_CFFI_OP_POINTER, 255), // ares_dns_rr_t const *
/*  4 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  5 */ _CFFI_OP(_CFFI_OP_FUNCTION, 23), // ares_dns_rec_type_t()(ares_dns_rr_t const *)
/*  6 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/*  7 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/*  8 */ _CFFI_OP(_CFFI_OP_FUNCTION, 3), // ares_dns_rr_t const *()(ares_dns_record_t const *, ares_dns_section_t, size_t)
/*  9 */ _CFFI_OP(_CFFI_OP_POINTER, 254), // ares_dns_record_t const *
/* 10 */ _CFFI_OP(_CFFI_OP_ENUM, 7), // ares_dns_section_t
/* 11 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28), // size_t
/* 12 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 13 */ _CFFI_OP(_CFFI_OP_FUNCTION, 227), // ares_status_t()(ares_dns_record_t * *, unsigned short, unsigned short, ares_dns_opcode_t, ares_dns_rcode_t)
/* 14 */ _CFFI_OP(_CFFI_OP_POINTER, 21), // ares_dns_record_t * *
/* 15 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6), // unsigned short
/* 16 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 6),
/* 17 */ _CFFI_OP(_CFFI_OP_ENUM, 3), // ares_dns_opcode_t
/* 18 */ _CFFI_OP(_CFFI_OP_ENUM, 4), // ares_dns_rcode_t
/* 19 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 20 */ _CFFI_OP(_CFFI_OP_FUNCTION, 227), // ares_status_t()(ares_dns_record_t *, char const *, ares_dns_rec_type_t, ares_dns_class_t)
/* 21 */ _CFFI_OP(_CFFI_OP_POINTER, 254), // ares_dns_record_t *
/* 22 */ _CFFI_OP(_CFFI_OP_POINTER, 258), // char const *
/* 23 */ _CFFI_OP(_CFFI_OP_ENUM, 5), // ares_dns_rec_type_t
/* 24 */ _CFFI_OP(_CFFI_OP_ENUM, 1), // ares_dns_class_t
/* 25 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 26 */ _CFFI_OP(_CFFI_OP_FUNCTION, 227), // ares_status_t()(struct ares_channeldata *, ares_dns_record_t const *, void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *), void *)
/* 27 */ _CFFI_OP(_CFFI_OP_POINTER, 272), // struct ares_channeldata *
/* 28 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 29 */ _CFFI_OP(_CFFI_OP_POINTER, 225), // void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *)
/* 30 */ _CFFI_OP(_CFFI_OP_POINTER, 311), // void *
/* 31 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 32 */ _CFFI_OP(_CFFI_OP_FUNCTION, 227), // ares_status_t()(struct ares_channeldata *, char const *, ares_dns_class_t, ares_dns_rec_type_t, void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *), void *, unsigned short *)
/* 33 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 34 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 35 */ _CFFI_OP(_CFFI_OP_NOOP, 24),
/* 36 */ _CFFI_OP(_CFFI_OP_NOOP, 23),
/* 37 */ _CFFI_OP(_CFFI_OP_NOOP, 29),
/* 38 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 39 */ _CFFI_OP(_CFFI_OP_POINTER, 15), // unsigned short *
/* 40 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 41 */ _CFFI_OP(_CFFI_OP_FUNCTION, 227), // ares_status_t()(struct ares_channeldata *, int)
/* 42 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 43 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7), // int
/* 44 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 45 */ _CFFI_OP(_CFFI_OP_FUNCTION, 64), // char *()(struct ares_channeldata *)
/* 46 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 47 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 48 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // char const *()(ares_dns_rr_t const *)
/* 49 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 50 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 51 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // char const *()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 52 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 53 */ _CFFI_OP(_CFFI_OP_ENUM, 6), // ares_dns_rr_key_t
/* 54 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 55 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // char const *()(int *)
/* 56 */ _CFFI_OP(_CFFI_OP_POINTER, 43), // int *
/* 57 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 58 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // char const *()(int)
/* 59 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 60 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 61 */ _CFFI_OP(_CFFI_OP_FUNCTION, 22), // char const *()(int, void const *, char *, ares_socklen_t)
/* 62 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 63 */ _CFFI_OP(_CFFI_OP_POINTER, 311), // void const *
/* 64 */ _CFFI_OP(_CFFI_OP_POINTER, 258), // char *
/* 65 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(ares_socklen_t), (
           ((ares_socklen_t)-1) | 0 /* check that ares_socklen_t is an integer type */
         ) <= 0)), // ares_socklen_t
/* 66 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 67 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(ares_socket_t, int, void *)
/* 68 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(ares_socket_t), (
           ((ares_socket_t)-1) | 0 /* check that ares_socket_t is an integer type */
         ) <= 0)), // ares_socket_t
/* 69 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 70 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 71 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 72 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(int)
/* 73 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 74 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 75 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(int, char const *, void *)
/* 76 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 77 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 78 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 79 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 80 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(struct ares_channeldata * *, struct ares_channeldata *)
/* 81 */ _CFFI_OP(_CFFI_OP_POINTER, 27), // struct ares_channeldata * *
/* 82 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 83 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 84 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(struct ares_channeldata * *, struct ares_options *, int)
/* 85 */ _CFFI_OP(_CFFI_OP_NOOP, 81),
/* 86 */ _CFFI_OP(_CFFI_OP_POINTER, 279), // struct ares_options *
/* 87 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 88 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 89 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(struct ares_channeldata *)
/* 90 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 91 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 92 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(struct ares_channeldata *, char const *)
/* 93 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 94 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 95 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 96 */ _CFFI_OP(_CFFI_OP_FUNCTION, 43), // int()(struct ares_channeldata *, struct ares_options *, int *)
/* 97 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 98 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 99 */ _CFFI_OP(_CFFI_OP_NOOP, 56),
/* 100 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 101 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // size_t()(ares_dns_record_t const *, ares_dns_section_t)
/* 102 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 103 */ _CFFI_OP(_CFFI_OP_NOOP, 10),
/* 104 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 105 */ _CFFI_OP(_CFFI_OP_FUNCTION, 11), // size_t()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 106 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 107 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 108 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 109 */ _CFFI_OP(_CFFI_OP_FUNCTION, 273), // struct ares_in6_addr const *()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 110 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 111 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 112 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 113 */ _CFFI_OP(_CFFI_OP_FUNCTION, 291), // struct in_addr const *()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 114 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 115 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 116 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 117 */ _CFFI_OP(_CFFI_OP_FUNCTION, 119), // struct timeval *()(struct ares_channeldata *, struct timeval *, struct timeval *)
/* 118 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 119 */ _CFFI_OP(_CFFI_OP_POINTER, 297), // struct timeval *
/* 120 */ _CFFI_OP(_CFFI_OP_NOOP, 119),
/* 121 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 122 */ _CFFI_OP(_CFFI_OP_FUNCTION, 196), // unsigned char const *()(ares_dns_rr_t const *, ares_dns_rr_key_t, size_t *)
/* 123 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 124 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 125 */ _CFFI_OP(_CFFI_OP_POINTER, 11), // size_t *
/* 126 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 127 */ _CFFI_OP(_CFFI_OP_FUNCTION, 196), // unsigned char const *()(ares_dns_rr_t const *, ares_dns_rr_key_t, size_t, size_t *)
/* 128 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 129 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 130 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 131 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 132 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 133 */ _CFFI_OP(_CFFI_OP_FUNCTION, 307), // unsigned char()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 134 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 135 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 136 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 137 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // unsigned int()(ares_dns_rr_t const *)
/* 138 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 139 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 140 */ _CFFI_OP(_CFFI_OP_FUNCTION, 200), // unsigned int()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 141 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 142 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 143 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 144 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // unsigned short()(ares_dns_rr_t const *, ares_dns_rr_key_t)
/* 145 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 146 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 147 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 148 */ _CFFI_OP(_CFFI_OP_FUNCTION, 15), // unsigned short()(ares_dns_rr_t const *, ares_dns_rr_key_t, size_t, unsigned char const * *, size_t *)
/* 149 */ _CFFI_OP(_CFFI_OP_NOOP, 3),
/* 150 */ _CFFI_OP(_CFFI_OP_NOOP, 53),
/* 151 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 152 */ _CFFI_OP(_CFFI_OP_POINTER, 196), // unsigned char const * *
/* 153 */ _CFFI_OP(_CFFI_OP_NOOP, 125),
/* 154 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 155 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(ares_dns_record_t *)
/* 156 */ _CFFI_OP(_CFFI_OP_NOOP, 21),
/* 157 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 158 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_addrinfo *)
/* 159 */ _CFFI_OP(_CFFI_OP_POINTER, 263), // struct ares_addrinfo *
/* 160 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 161 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *)
/* 162 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 163 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 164 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, ares_socket_t, ares_socket_t)
/* 165 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 166 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 167 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 168 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 169 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, char const *)
/* 170 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 171 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 172 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 173 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, char const *, char const *, struct ares_addrinfo_hints const *, void(*)(void *, int, int, struct ares_addrinfo *), void *)
/* 174 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 175 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 176 */ _CFFI_OP(_CFFI_OP_NOOP, 22),
/* 177 */ _CFFI_OP(_CFFI_OP_POINTER, 266), // struct ares_addrinfo_hints const *
/* 178 */ _CFFI_OP(_CFFI_OP_POINTER, 238), // void(*)(void *, int, int, struct ares_addrinfo *)
/* 179 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 180 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 181 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, int(*)(ares_socket_t, int, void *), void *)
/* 182 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 183 */ _CFFI_OP(_CFFI_OP_POINTER, 67), // int(*)(ares_socket_t, int, void *)
/* 184 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 185 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 186 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, struct sockaddr const *, ares_socklen_t, int, void(*)(void *, int, int, char *, char *), void *)
/* 187 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 188 */ _CFFI_OP(_CFFI_OP_POINTER, 294), // struct sockaddr const *
/* 189 */ _CFFI_OP(_CFFI_OP_NOOP, 65),
/* 190 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 191 */ _CFFI_OP(_CFFI_OP_POINTER, 231), // void(*)(void *, int, int, char *, char *)
/* 192 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 193 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 194 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, unsigned char const *)
/* 195 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 196 */ _CFFI_OP(_CFFI_OP_POINTER, 307), // unsigned char const *
/* 197 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 198 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, unsigned int)
/* 199 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 200 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 8), // unsigned int
/* 201 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 202 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_channeldata *, void const *, int, int, void(*)(void *, int, int, struct hostent *), void *)
/* 203 */ _CFFI_OP(_CFFI_OP_NOOP, 27),
/* 204 */ _CFFI_OP(_CFFI_OP_NOOP, 63),
/* 205 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 206 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 207 */ _CFFI_OP(_CFFI_OP_POINTER, 244), // void(*)(void *, int, int, struct hostent *)
/* 208 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 209 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 210 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct ares_options *)
/* 211 */ _CFFI_OP(_CFFI_OP_NOOP, 86),
/* 212 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 213 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(struct hostent *)
/* 214 */ _CFFI_OP(_CFFI_OP_POINTER, 288), // struct hostent *
/* 215 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 216 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *)
/* 217 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 218 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 219 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *, ares_socket_t, int, int)
/* 220 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 221 */ _CFFI_OP(_CFFI_OP_NOOP, 68),
/* 222 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 223 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 224 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 225 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *, ares_status_t, size_t, ares_dns_record_t const *)
/* 226 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 227 */ _CFFI_OP(_CFFI_OP_ENUM, 9), // ares_status_t
/* 228 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 28),
/* 229 */ _CFFI_OP(_CFFI_OP_NOOP, 9),
/* 230 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 231 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *, int, int, char *, char *)
/* 232 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 233 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 234 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 235 */ _CFFI_OP(_CFFI_OP_NOOP, 64),
/* 236 */ _CFFI_OP(_CFFI_OP_NOOP, 64),
/* 237 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 238 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *, int, int, struct ares_addrinfo *)
/* 239 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 240 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 241 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 242 */ _CFFI_OP(_CFFI_OP_NOOP, 159),
/* 243 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 244 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void *, int, int, struct hostent *)
/* 245 */ _CFFI_OP(_CFFI_OP_NOOP, 30),
/* 246 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 247 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 7),
/* 248 */ _CFFI_OP(_CFFI_OP_NOOP, 214),
/* 249 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 250 */ _CFFI_OP(_CFFI_OP_FUNCTION, 311), // void()(void)
/* 251 */ _CFFI_OP(_CFFI_OP_FUNCTION_END, 0),
/* 252 */ _CFFI_OP(_CFFI_OP_ENUM, 0), // ares_bool_t
/* 253 */ _CFFI_OP(_CFFI_OP_ENUM, 2), // ares_dns_flags_t
/* 254 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 10), // ares_dns_record_t
/* 255 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 11), // ares_dns_rr_t
/* 256 */ _CFFI_OP(_CFFI_OP_ENUM, 8), // ares_evsys_t
/* 257 */ _CFFI_OP(_CFFI_OP_POINTER, 64), // char * *
/* 258 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 2), // char
/* 259 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(sa_family_t), (
           ((sa_family_t)-1) | 0 /* check that sa_family_t is an integer type */
         ) <= 0)), // sa_family_t
/* 260 */ _CFFI_OP(_CFFI_OP_POINTER, 261), // struct apattern *
/* 261 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 1), // struct apattern
/* 262 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 2), // struct ares_addr6ttl
/* 263 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 3), // struct ares_addrinfo
/* 264 */ _CFFI_OP(_CFFI_OP_POINTER, 265), // struct ares_addrinfo_cname *
/* 265 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 4), // struct ares_addrinfo_cname
/* 266 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 5), // struct ares_addrinfo_hints
/* 267 */ _CFFI_OP(_CFFI_OP_POINTER, 268), // struct ares_addrinfo_node *
/* 268 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 6), // struct ares_addrinfo_node
/* 269 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 7), // struct ares_addrttl
/* 270 */ _CFFI_OP(_CFFI_OP_POINTER, 271), // struct ares_caa_reply *
/* 271 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 8), // struct ares_caa_reply
/* 272 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 9), // struct ares_channeldata
/* 273 */ _CFFI_OP(_CFFI_OP_POINTER, 274), // struct ares_in6_addr const *
/* 274 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 12), // struct ares_in6_addr
/* 275 */ _CFFI_OP(_CFFI_OP_POINTER, 276), // struct ares_mx_reply *
/* 276 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 13), // struct ares_mx_reply
/* 277 */ _CFFI_OP(_CFFI_OP_POINTER, 278), // struct ares_naptr_reply *
/* 278 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 14), // struct ares_naptr_reply
/* 279 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 15), // struct ares_options
/* 280 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 16), // struct ares_server_failover_options
/* 281 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 17), // struct ares_soa_reply
/* 282 */ _CFFI_OP(_CFFI_OP_POINTER, 283), // struct ares_srv_reply *
/* 283 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 18), // struct ares_srv_reply
/* 284 */ _CFFI_OP(_CFFI_OP_POINTER, 285), // struct ares_txt_ext *
/* 285 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 19), // struct ares_txt_ext
/* 286 */ _CFFI_OP(_CFFI_OP_POINTER, 287), // struct ares_txt_reply *
/* 287 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 20), // struct ares_txt_reply
/* 288 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 21), // struct hostent
/* 289 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 22), // struct in6_addr
/* 290 */ _CFFI_OP(_CFFI_OP_POINTER, 292), // struct in_addr *
/* 291 */ _CFFI_OP(_CFFI_OP_POINTER, 292), // struct in_addr const *
/* 292 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 23), // struct in_addr
/* 293 */ _CFFI_OP(_CFFI_OP_POINTER, 294), // struct sockaddr *
/* 294 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 24), // struct sockaddr
/* 295 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 26), // struct sockaddr_in6
/* 296 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 25), // struct sockaddr_in
/* 297 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 27), // struct timeval
/* 298 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(suseconds_t), (
           ((suseconds_t)-1) | 0 /* check that suseconds_t is an integer type */
         ) <= 0)), // suseconds_t
/* 299 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, _cffi_prim_int(sizeof(time_t), (
           ((time_t)-1) | 0 /* check that time_t is an integer type */
         ) <= 0)), // time_t
/* 300 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 20), // uint16_t
/* 301 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 22), // uint32_t
/* 302 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 18), // uint8_t
/* 303 */ _CFFI_OP(_CFFI_OP_ARRAY, 302), // uint8_t[16]
/* 304 */ (_cffi_opcode_t)(16),
/* 305 */ _CFFI_OP(_CFFI_OP_STRUCT_UNION, 0), // union $1
/* 306 */ _CFFI_OP(_CFFI_OP_POINTER, 307), // unsigned char *
/* 307 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 4), // unsigned char
/* 308 */ _CFFI_OP(_CFFI_OP_ARRAY, 307), // unsigned char[16]
/* 309 */ (_cffi_opcode_t)(16),
/* 310 */ _CFFI_OP(_CFFI_OP_POINTER, 219), // void(*)(void *, ares_socket_t, int, int)
/* 311 */ _CFFI_OP(_CFFI_OP_PRIMITIVE, 0), // void
};

static int _cffi_const_ARES_FALSE(unsigned long long *o)
{
  int n = (ARES_FALSE) <= 0;
  *o = (unsigned long long)((ARES_FALSE) | 0);  /* check that ARES_FALSE is an integer */
  return n;
}

static int _cffi_const_ARES_TRUE(unsigned long long *o)
{
  int n = (ARES_TRUE) <= 0;
  *o = (unsigned long long)((ARES_TRUE) | 0);  /* check that ARES_TRUE is an integer */
  return n;
}

static int _cffi_const_ARES_CLASS_IN(unsigned long long *o)
{
  int n = (ARES_CLASS_IN) <= 0;
  *o = (unsigned long long)((ARES_CLASS_IN) | 0);  /* check that ARES_CLASS_IN is an integer */
  return n;
}

static int _cffi_const_ARES_CLASS_CHAOS(unsigned long long *o)
{
  int n = (ARES_CLASS_CHAOS) <= 0;
  *o = (unsigned long long)((ARES_CLASS_CHAOS) | 0);  /* check that ARES_CLASS_CHAOS is an integer */
  return n;
}

static int _cffi_const_ARES_CLASS_HESOID(unsigned long long *o)
{
  int n = (ARES_CLASS_HESOID) <= 0;
  *o = (unsigned long long)((ARES_CLASS_HESOID) | 0);  /* check that ARES_CLASS_HESOID is an integer */
  return n;
}

static int _cffi_const_ARES_CLASS_NONE(unsigned long long *o)
{
  int n = (ARES_CLASS_NONE) <= 0;
  *o = (unsigned long long)((ARES_CLASS_NONE) | 0);  /* check that ARES_CLASS_NONE is an integer */
  return n;
}

static int _cffi_const_ARES_CLASS_ANY(unsigned long long *o)
{
  int n = (ARES_CLASS_ANY) <= 0;
  *o = (unsigned long long)((ARES_CLASS_ANY) | 0);  /* check that ARES_CLASS_ANY is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_QR(unsigned long long *o)
{
  int n = (ARES_FLAG_QR) <= 0;
  *o = (unsigned long long)((ARES_FLAG_QR) | 0);  /* check that ARES_FLAG_QR is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_AA(unsigned long long *o)
{
  int n = (ARES_FLAG_AA) <= 0;
  *o = (unsigned long long)((ARES_FLAG_AA) | 0);  /* check that ARES_FLAG_AA is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_TC(unsigned long long *o)
{
  int n = (ARES_FLAG_TC) <= 0;
  *o = (unsigned long long)((ARES_FLAG_TC) | 0);  /* check that ARES_FLAG_TC is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_RD(unsigned long long *o)
{
  int n = (ARES_FLAG_RD) <= 0;
  *o = (unsigned long long)((ARES_FLAG_RD) | 0);  /* check that ARES_FLAG_RD is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_RA(unsigned long long *o)
{
  int n = (ARES_FLAG_RA) <= 0;
  *o = (unsigned long long)((ARES_FLAG_RA) | 0);  /* check that ARES_FLAG_RA is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_AD(unsigned long long *o)
{
  int n = (ARES_FLAG_AD) <= 0;
  *o = (unsigned long long)((ARES_FLAG_AD) | 0);  /* check that ARES_FLAG_AD is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_CD(unsigned long long *o)
{
  int n = (ARES_FLAG_CD) <= 0;
  *o = (unsigned long long)((ARES_FLAG_CD) | 0);  /* check that ARES_FLAG_CD is an integer */
  return n;
}

static int _cffi_const_ARES_OPCODE_QUERY(unsigned long long *o)
{
  int n = (ARES_OPCODE_QUERY) <= 0;
  *o = (unsigned long long)((ARES_OPCODE_QUERY) | 0);  /* check that ARES_OPCODE_QUERY is an integer */
  return n;
}

static int _cffi_const_ARES_OPCODE_IQUERY(unsigned long long *o)
{
  int n = (ARES_OPCODE_IQUERY) <= 0;
  *o = (unsigned long long)((ARES_OPCODE_IQUERY) | 0);  /* check that ARES_OPCODE_IQUERY is an integer */
  return n;
}

static int _cffi_const_ARES_OPCODE_STATUS(unsigned long long *o)
{
  int n = (ARES_OPCODE_STATUS) <= 0;
  *o = (unsigned long long)((ARES_OPCODE_STATUS) | 0);  /* check that ARES_OPCODE_STATUS is an integer */
  return n;
}

static int _cffi_const_ARES_OPCODE_NOTIFY(unsigned long long *o)
{
  int n = (ARES_OPCODE_NOTIFY) <= 0;
  *o = (unsigned long long)((ARES_OPCODE_NOTIFY) | 0);  /* check that ARES_OPCODE_NOTIFY is an integer */
  return n;
}

static int _cffi_const_ARES_OPCODE_UPDATE(unsigned long long *o)
{
  int n = (ARES_OPCODE_UPDATE) <= 0;
  *o = (unsigned long long)((ARES_OPCODE_UPDATE) | 0);  /* check that ARES_OPCODE_UPDATE is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NOERROR(unsigned long long *o)
{
  int n = (ARES_RCODE_NOERROR) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NOERROR) | 0);  /* check that ARES_RCODE_NOERROR is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_FORMERR(unsigned long long *o)
{
  int n = (ARES_RCODE_FORMERR) <= 0;
  *o = (unsigned long long)((ARES_RCODE_FORMERR) | 0);  /* check that ARES_RCODE_FORMERR is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_SERVFAIL(unsigned long long *o)
{
  int n = (ARES_RCODE_SERVFAIL) <= 0;
  *o = (unsigned long long)((ARES_RCODE_SERVFAIL) | 0);  /* check that ARES_RCODE_SERVFAIL is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NXDOMAIN(unsigned long long *o)
{
  int n = (ARES_RCODE_NXDOMAIN) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NXDOMAIN) | 0);  /* check that ARES_RCODE_NXDOMAIN is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NOTIMP(unsigned long long *o)
{
  int n = (ARES_RCODE_NOTIMP) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NOTIMP) | 0);  /* check that ARES_RCODE_NOTIMP is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_REFUSED(unsigned long long *o)
{
  int n = (ARES_RCODE_REFUSED) <= 0;
  *o = (unsigned long long)((ARES_RCODE_REFUSED) | 0);  /* check that ARES_RCODE_REFUSED is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_YXDOMAIN(unsigned long long *o)
{
  int n = (ARES_RCODE_YXDOMAIN) <= 0;
  *o = (unsigned long long)((ARES_RCODE_YXDOMAIN) | 0);  /* check that ARES_RCODE_YXDOMAIN is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_YXRRSET(unsigned long long *o)
{
  int n = (ARES_RCODE_YXRRSET) <= 0;
  *o = (unsigned long long)((ARES_RCODE_YXRRSET) | 0);  /* check that ARES_RCODE_YXRRSET is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NXRRSET(unsigned long long *o)
{
  int n = (ARES_RCODE_NXRRSET) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NXRRSET) | 0);  /* check that ARES_RCODE_NXRRSET is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NOTAUTH(unsigned long long *o)
{
  int n = (ARES_RCODE_NOTAUTH) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NOTAUTH) | 0);  /* check that ARES_RCODE_NOTAUTH is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_NOTZONE(unsigned long long *o)
{
  int n = (ARES_RCODE_NOTZONE) <= 0;
  *o = (unsigned long long)((ARES_RCODE_NOTZONE) | 0);  /* check that ARES_RCODE_NOTZONE is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_DSOTYPEI(unsigned long long *o)
{
  int n = (ARES_RCODE_DSOTYPEI) <= 0;
  *o = (unsigned long long)((ARES_RCODE_DSOTYPEI) | 0);  /* check that ARES_RCODE_DSOTYPEI is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADSIG(unsigned long long *o)
{
  int n = (ARES_RCODE_BADSIG) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADSIG) | 0);  /* check that ARES_RCODE_BADSIG is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADKEY(unsigned long long *o)
{
  int n = (ARES_RCODE_BADKEY) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADKEY) | 0);  /* check that ARES_RCODE_BADKEY is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADTIME(unsigned long long *o)
{
  int n = (ARES_RCODE_BADTIME) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADTIME) | 0);  /* check that ARES_RCODE_BADTIME is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADMODE(unsigned long long *o)
{
  int n = (ARES_RCODE_BADMODE) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADMODE) | 0);  /* check that ARES_RCODE_BADMODE is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADNAME(unsigned long long *o)
{
  int n = (ARES_RCODE_BADNAME) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADNAME) | 0);  /* check that ARES_RCODE_BADNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADALG(unsigned long long *o)
{
  int n = (ARES_RCODE_BADALG) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADALG) | 0);  /* check that ARES_RCODE_BADALG is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADTRUNC(unsigned long long *o)
{
  int n = (ARES_RCODE_BADTRUNC) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADTRUNC) | 0);  /* check that ARES_RCODE_BADTRUNC is an integer */
  return n;
}

static int _cffi_const_ARES_RCODE_BADCOOKIE(unsigned long long *o)
{
  int n = (ARES_RCODE_BADCOOKIE) <= 0;
  *o = (unsigned long long)((ARES_RCODE_BADCOOKIE) | 0);  /* check that ARES_RCODE_BADCOOKIE is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_A(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_A) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_A) | 0);  /* check that ARES_REC_TYPE_A is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_NS(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_NS) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_NS) | 0);  /* check that ARES_REC_TYPE_NS is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_CNAME(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_CNAME) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_CNAME) | 0);  /* check that ARES_REC_TYPE_CNAME is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_SOA(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_SOA) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_SOA) | 0);  /* check that ARES_REC_TYPE_SOA is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_PTR(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_PTR) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_PTR) | 0);  /* check that ARES_REC_TYPE_PTR is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_MX(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_MX) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_MX) | 0);  /* check that ARES_REC_TYPE_MX is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_TXT(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_TXT) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_TXT) | 0);  /* check that ARES_REC_TYPE_TXT is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_AAAA(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_AAAA) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_AAAA) | 0);  /* check that ARES_REC_TYPE_AAAA is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_SRV(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_SRV) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_SRV) | 0);  /* check that ARES_REC_TYPE_SRV is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_NAPTR(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_NAPTR) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_NAPTR) | 0);  /* check that ARES_REC_TYPE_NAPTR is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_TLSA(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_TLSA) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_TLSA) | 0);  /* check that ARES_REC_TYPE_TLSA is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_HTTPS(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_HTTPS) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_HTTPS) | 0);  /* check that ARES_REC_TYPE_HTTPS is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_CAA(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_CAA) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_CAA) | 0);  /* check that ARES_REC_TYPE_CAA is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_URI(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_URI) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_URI) | 0);  /* check that ARES_REC_TYPE_URI is an integer */
  return n;
}

static int _cffi_const_ARES_REC_TYPE_ANY(unsigned long long *o)
{
  int n = (ARES_REC_TYPE_ANY) <= 0;
  *o = (unsigned long long)((ARES_REC_TYPE_ANY) | 0);  /* check that ARES_REC_TYPE_ANY is an integer */
  return n;
}

static int _cffi_const_ARES_RR_A_ADDR(unsigned long long *o)
{
  int n = (ARES_RR_A_ADDR) <= 0;
  *o = (unsigned long long)((ARES_RR_A_ADDR) | 0);  /* check that ARES_RR_A_ADDR is an integer */
  return n;
}

static int _cffi_const_ARES_RR_AAAA_ADDR(unsigned long long *o)
{
  int n = (ARES_RR_AAAA_ADDR) <= 0;
  *o = (unsigned long long)((ARES_RR_AAAA_ADDR) | 0);  /* check that ARES_RR_AAAA_ADDR is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NS_NSDNAME(unsigned long long *o)
{
  int n = (ARES_RR_NS_NSDNAME) <= 0;
  *o = (unsigned long long)((ARES_RR_NS_NSDNAME) | 0);  /* check that ARES_RR_NS_NSDNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RR_CNAME_CNAME(unsigned long long *o)
{
  int n = (ARES_RR_CNAME_CNAME) <= 0;
  *o = (unsigned long long)((ARES_RR_CNAME_CNAME) | 0);  /* check that ARES_RR_CNAME_CNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_MNAME(unsigned long long *o)
{
  int n = (ARES_RR_SOA_MNAME) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_MNAME) | 0);  /* check that ARES_RR_SOA_MNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_RNAME(unsigned long long *o)
{
  int n = (ARES_RR_SOA_RNAME) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_RNAME) | 0);  /* check that ARES_RR_SOA_RNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_SERIAL(unsigned long long *o)
{
  int n = (ARES_RR_SOA_SERIAL) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_SERIAL) | 0);  /* check that ARES_RR_SOA_SERIAL is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_REFRESH(unsigned long long *o)
{
  int n = (ARES_RR_SOA_REFRESH) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_REFRESH) | 0);  /* check that ARES_RR_SOA_REFRESH is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_RETRY(unsigned long long *o)
{
  int n = (ARES_RR_SOA_RETRY) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_RETRY) | 0);  /* check that ARES_RR_SOA_RETRY is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_EXPIRE(unsigned long long *o)
{
  int n = (ARES_RR_SOA_EXPIRE) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_EXPIRE) | 0);  /* check that ARES_RR_SOA_EXPIRE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SOA_MINIMUM(unsigned long long *o)
{
  int n = (ARES_RR_SOA_MINIMUM) <= 0;
  *o = (unsigned long long)((ARES_RR_SOA_MINIMUM) | 0);  /* check that ARES_RR_SOA_MINIMUM is an integer */
  return n;
}

static int _cffi_const_ARES_RR_PTR_DNAME(unsigned long long *o)
{
  int n = (ARES_RR_PTR_DNAME) <= 0;
  *o = (unsigned long long)((ARES_RR_PTR_DNAME) | 0);  /* check that ARES_RR_PTR_DNAME is an integer */
  return n;
}

static int _cffi_const_ARES_RR_MX_PREFERENCE(unsigned long long *o)
{
  int n = (ARES_RR_MX_PREFERENCE) <= 0;
  *o = (unsigned long long)((ARES_RR_MX_PREFERENCE) | 0);  /* check that ARES_RR_MX_PREFERENCE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_MX_EXCHANGE(unsigned long long *o)
{
  int n = (ARES_RR_MX_EXCHANGE) <= 0;
  *o = (unsigned long long)((ARES_RR_MX_EXCHANGE) | 0);  /* check that ARES_RR_MX_EXCHANGE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_TXT_DATA(unsigned long long *o)
{
  int n = (ARES_RR_TXT_DATA) <= 0;
  *o = (unsigned long long)((ARES_RR_TXT_DATA) | 0);  /* check that ARES_RR_TXT_DATA is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SRV_PRIORITY(unsigned long long *o)
{
  int n = (ARES_RR_SRV_PRIORITY) <= 0;
  *o = (unsigned long long)((ARES_RR_SRV_PRIORITY) | 0);  /* check that ARES_RR_SRV_PRIORITY is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SRV_WEIGHT(unsigned long long *o)
{
  int n = (ARES_RR_SRV_WEIGHT) <= 0;
  *o = (unsigned long long)((ARES_RR_SRV_WEIGHT) | 0);  /* check that ARES_RR_SRV_WEIGHT is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SRV_PORT(unsigned long long *o)
{
  int n = (ARES_RR_SRV_PORT) <= 0;
  *o = (unsigned long long)((ARES_RR_SRV_PORT) | 0);  /* check that ARES_RR_SRV_PORT is an integer */
  return n;
}

static int _cffi_const_ARES_RR_SRV_TARGET(unsigned long long *o)
{
  int n = (ARES_RR_SRV_TARGET) <= 0;
  *o = (unsigned long long)((ARES_RR_SRV_TARGET) | 0);  /* check that ARES_RR_SRV_TARGET is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_ORDER(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_ORDER) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_ORDER) | 0);  /* check that ARES_RR_NAPTR_ORDER is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_PREFERENCE(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_PREFERENCE) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_PREFERENCE) | 0);  /* check that ARES_RR_NAPTR_PREFERENCE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_FLAGS(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_FLAGS) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_FLAGS) | 0);  /* check that ARES_RR_NAPTR_FLAGS is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_SERVICES(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_SERVICES) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_SERVICES) | 0);  /* check that ARES_RR_NAPTR_SERVICES is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_REGEXP(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_REGEXP) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_REGEXP) | 0);  /* check that ARES_RR_NAPTR_REGEXP is an integer */
  return n;
}

static int _cffi_const_ARES_RR_NAPTR_REPLACEMENT(unsigned long long *o)
{
  int n = (ARES_RR_NAPTR_REPLACEMENT) <= 0;
  *o = (unsigned long long)((ARES_RR_NAPTR_REPLACEMENT) | 0);  /* check that ARES_RR_NAPTR_REPLACEMENT is an integer */
  return n;
}

static int _cffi_const_ARES_RR_CAA_CRITICAL(unsigned long long *o)
{
  int n = (ARES_RR_CAA_CRITICAL) <= 0;
  *o = (unsigned long long)((ARES_RR_CAA_CRITICAL) | 0);  /* check that ARES_RR_CAA_CRITICAL is an integer */
  return n;
}

static int _cffi_const_ARES_RR_CAA_TAG(unsigned long long *o)
{
  int n = (ARES_RR_CAA_TAG) <= 0;
  *o = (unsigned long long)((ARES_RR_CAA_TAG) | 0);  /* check that ARES_RR_CAA_TAG is an integer */
  return n;
}

static int _cffi_const_ARES_RR_CAA_VALUE(unsigned long long *o)
{
  int n = (ARES_RR_CAA_VALUE) <= 0;
  *o = (unsigned long long)((ARES_RR_CAA_VALUE) | 0);  /* check that ARES_RR_CAA_VALUE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_TLSA_CERT_USAGE(unsigned long long *o)
{
  int n = (ARES_RR_TLSA_CERT_USAGE) <= 0;
  *o = (unsigned long long)((ARES_RR_TLSA_CERT_USAGE) | 0);  /* check that ARES_RR_TLSA_CERT_USAGE is an integer */
  return n;
}

static int _cffi_const_ARES_RR_TLSA_SELECTOR(unsigned long long *o)
{
  int n = (ARES_RR_TLSA_SELECTOR) <= 0;
  *o = (unsigned long long)((ARES_RR_TLSA_SELECTOR) | 0);  /* check that ARES_RR_TLSA_SELECTOR is an integer */
  return n;
}

static int _cffi_const_ARES_RR_TLSA_MATCH(unsigned long long *o)
{
  int n = (ARES_RR_TLSA_MATCH) <= 0;
  *o = (unsigned long long)((ARES_RR_TLSA_MATCH) | 0);  /* check that ARES_RR_TLSA_MATCH is an integer */
  return n;
}

static int _cffi_const_ARES_RR_TLSA_DATA(unsigned long long *o)
{
  int n = (ARES_RR_TLSA_DATA) <= 0;
  *o = (unsigned long long)((ARES_RR_TLSA_DATA) | 0);  /* check that ARES_RR_TLSA_DATA is an integer */
  return n;
}

static int _cffi_const_ARES_RR_HTTPS_PRIORITY(unsigned long long *o)
{
  int n = (ARES_RR_HTTPS_PRIORITY) <= 0;
  *o = (unsigned long long)((ARES_RR_HTTPS_PRIORITY) | 0);  /* check that ARES_RR_HTTPS_PRIORITY is an integer */
  return n;
}

static int _cffi_const_ARES_RR_HTTPS_TARGET(unsigned long long *o)
{
  int n = (ARES_RR_HTTPS_TARGET) <= 0;
  *o = (unsigned long long)((ARES_RR_HTTPS_TARGET) | 0);  /* check that ARES_RR_HTTPS_TARGET is an integer */
  return n;
}

static int _cffi_const_ARES_RR_HTTPS_PARAMS(unsigned long long *o)
{
  int n = (ARES_RR_HTTPS_PARAMS) <= 0;
  *o = (unsigned long long)((ARES_RR_HTTPS_PARAMS) | 0);  /* check that ARES_RR_HTTPS_PARAMS is an integer */
  return n;
}

static int _cffi_const_ARES_RR_URI_PRIORITY(unsigned long long *o)
{
  int n = (ARES_RR_URI_PRIORITY) <= 0;
  *o = (unsigned long long)((ARES_RR_URI_PRIORITY) | 0);  /* check that ARES_RR_URI_PRIORITY is an integer */
  return n;
}

static int _cffi_const_ARES_RR_URI_WEIGHT(unsigned long long *o)
{
  int n = (ARES_RR_URI_WEIGHT) <= 0;
  *o = (unsigned long long)((ARES_RR_URI_WEIGHT) | 0);  /* check that ARES_RR_URI_WEIGHT is an integer */
  return n;
}

static int _cffi_const_ARES_RR_URI_TARGET(unsigned long long *o)
{
  int n = (ARES_RR_URI_TARGET) <= 0;
  *o = (unsigned long long)((ARES_RR_URI_TARGET) | 0);  /* check that ARES_RR_URI_TARGET is an integer */
  return n;
}

static int _cffi_const_ARES_SECTION_ANSWER(unsigned long long *o)
{
  int n = (ARES_SECTION_ANSWER) <= 0;
  *o = (unsigned long long)((ARES_SECTION_ANSWER) | 0);  /* check that ARES_SECTION_ANSWER is an integer */
  return n;
}

static int _cffi_const_ARES_SECTION_AUTHORITY(unsigned long long *o)
{
  int n = (ARES_SECTION_AUTHORITY) <= 0;
  *o = (unsigned long long)((ARES_SECTION_AUTHORITY) | 0);  /* check that ARES_SECTION_AUTHORITY is an integer */
  return n;
}

static int _cffi_const_ARES_SECTION_ADDITIONAL(unsigned long long *o)
{
  int n = (ARES_SECTION_ADDITIONAL) <= 0;
  *o = (unsigned long long)((ARES_SECTION_ADDITIONAL) | 0);  /* check that ARES_SECTION_ADDITIONAL is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_DEFAULT(unsigned long long *o)
{
  int n = (ARES_EVSYS_DEFAULT) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_DEFAULT) | 0);  /* check that ARES_EVSYS_DEFAULT is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_WIN32(unsigned long long *o)
{
  int n = (ARES_EVSYS_WIN32) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_WIN32) | 0);  /* check that ARES_EVSYS_WIN32 is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_EPOLL(unsigned long long *o)
{
  int n = (ARES_EVSYS_EPOLL) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_EPOLL) | 0);  /* check that ARES_EVSYS_EPOLL is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_KQUEUE(unsigned long long *o)
{
  int n = (ARES_EVSYS_KQUEUE) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_KQUEUE) | 0);  /* check that ARES_EVSYS_KQUEUE is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_POLL(unsigned long long *o)
{
  int n = (ARES_EVSYS_POLL) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_POLL) | 0);  /* check that ARES_EVSYS_POLL is an integer */
  return n;
}

static int _cffi_const_ARES_EVSYS_SELECT(unsigned long long *o)
{
  int n = (ARES_EVSYS_SELECT) <= 0;
  *o = (unsigned long long)((ARES_EVSYS_SELECT) | 0);  /* check that ARES_EVSYS_SELECT is an integer */
  return n;
}

static int _cffi_const_ARES_SUCCESS(unsigned long long *o)
{
  int n = (ARES_SUCCESS) <= 0;
  *o = (unsigned long long)((ARES_SUCCESS) | 0);  /* check that ARES_SUCCESS is an integer */
  return n;
}

static int _cffi_const_ARES_ENODATA(unsigned long long *o)
{
  int n = (ARES_ENODATA) <= 0;
  *o = (unsigned long long)((ARES_ENODATA) | 0);  /* check that ARES_ENODATA is an integer */
  return n;
}

static int _cffi_const_ARES_EFORMERR(unsigned long long *o)
{
  int n = (ARES_EFORMERR) <= 0;
  *o = (unsigned long long)((ARES_EFORMERR) | 0);  /* check that ARES_EFORMERR is an integer */
  return n;
}

static int _cffi_const_ARES_ESERVFAIL(unsigned long long *o)
{
  int n = (ARES_ESERVFAIL) <= 0;
  *o = (unsigned long long)((ARES_ESERVFAIL) | 0);  /* check that ARES_ESERVFAIL is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTFOUND(unsigned long long *o)
{
  int n = (ARES_ENOTFOUND) <= 0;
  *o = (unsigned long long)((ARES_ENOTFOUND) | 0);  /* check that ARES_ENOTFOUND is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTIMP(unsigned long long *o)
{
  int n = (ARES_ENOTIMP) <= 0;
  *o = (unsigned long long)((ARES_ENOTIMP) | 0);  /* check that ARES_ENOTIMP is an integer */
  return n;
}

static int _cffi_const_ARES_EREFUSED(unsigned long long *o)
{
  int n = (ARES_EREFUSED) <= 0;
  *o = (unsigned long long)((ARES_EREFUSED) | 0);  /* check that ARES_EREFUSED is an integer */
  return n;
}

static int _cffi_const_ARES_EBADQUERY(unsigned long long *o)
{
  int n = (ARES_EBADQUERY) <= 0;
  *o = (unsigned long long)((ARES_EBADQUERY) | 0);  /* check that ARES_EBADQUERY is an integer */
  return n;
}

static int _cffi_const_ARES_EBADNAME(unsigned long long *o)
{
  int n = (ARES_EBADNAME) <= 0;
  *o = (unsigned long long)((ARES_EBADNAME) | 0);  /* check that ARES_EBADNAME is an integer */
  return n;
}

static int _cffi_const_ARES_EBADFAMILY(unsigned long long *o)
{
  int n = (ARES_EBADFAMILY) <= 0;
  *o = (unsigned long long)((ARES_EBADFAMILY) | 0);  /* check that ARES_EBADFAMILY is an integer */
  return n;
}

static int _cffi_const_ARES_EBADRESP(unsigned long long *o)
{
  int n = (ARES_EBADRESP) <= 0;
  *o = (unsigned long long)((ARES_EBADRESP) | 0);  /* check that ARES_EBADRESP is an integer */
  return n;
}

static int _cffi_const_ARES_ECONNREFUSED(unsigned long long *o)
{
  int n = (ARES_ECONNREFUSED) <= 0;
  *o = (unsigned long long)((ARES_ECONNREFUSED) | 0);  /* check that ARES_ECONNREFUSED is an integer */
  return n;
}

static int _cffi_const_ARES_ETIMEOUT(unsigned long long *o)
{
  int n = (ARES_ETIMEOUT) <= 0;
  *o = (unsigned long long)((ARES_ETIMEOUT) | 0);  /* check that ARES_ETIMEOUT is an integer */
  return n;
}

static int _cffi_const_ARES_EOF(unsigned long long *o)
{
  int n = (ARES_EOF) <= 0;
  *o = (unsigned long long)((ARES_EOF) | 0);  /* check that ARES_EOF is an integer */
  return n;
}

static int _cffi_const_ARES_EFILE(unsigned long long *o)
{
  int n = (ARES_EFILE) <= 0;
  *o = (unsigned long long)((ARES_EFILE) | 0);  /* check that ARES_EFILE is an integer */
  return n;
}

static int _cffi_const_ARES_ENOMEM(unsigned long long *o)
{
  int n = (ARES_ENOMEM) <= 0;
  *o = (unsigned long long)((ARES_ENOMEM) | 0);  /* check that ARES_ENOMEM is an integer */
  return n;
}

static int _cffi_const_ARES_EDESTRUCTION(unsigned long long *o)
{
  int n = (ARES_EDESTRUCTION) <= 0;
  *o = (unsigned long long)((ARES_EDESTRUCTION) | 0);  /* check that ARES_EDESTRUCTION is an integer */
  return n;
}

static int _cffi_const_ARES_EBADSTR(unsigned long long *o)
{
  int n = (ARES_EBADSTR) <= 0;
  *o = (unsigned long long)((ARES_EBADSTR) | 0);  /* check that ARES_EBADSTR is an integer */
  return n;
}

static int _cffi_const_ARES_EBADFLAGS(unsigned long long *o)
{
  int n = (ARES_EBADFLAGS) <= 0;
  *o = (unsigned long long)((ARES_EBADFLAGS) | 0);  /* check that ARES_EBADFLAGS is an integer */
  return n;
}

static int _cffi_const_ARES_ENONAME(unsigned long long *o)
{
  int n = (ARES_ENONAME) <= 0;
  *o = (unsigned long long)((ARES_ENONAME) | 0);  /* check that ARES_ENONAME is an integer */
  return n;
}

static int _cffi_const_ARES_EBADHINTS(unsigned long long *o)
{
  int n = (ARES_EBADHINTS) <= 0;
  *o = (unsigned long long)((ARES_EBADHINTS) | 0);  /* check that ARES_EBADHINTS is an integer */
  return n;
}

static int _cffi_const_ARES_ENOTINITIALIZED(unsigned long long *o)
{
  int n = (ARES_ENOTINITIALIZED) <= 0;
  *o = (unsigned long long)((ARES_ENOTINITIALIZED) | 0);  /* check that ARES_ENOTINITIALIZED is an integer */
  return n;
}

static int _cffi_const_ARES_ELOADIPHLPAPI(unsigned long long *o)
{
  int n = (ARES_ELOADIPHLPAPI) <= 0;
  *o = (unsigned long long)((ARES_ELOADIPHLPAPI) | 0);  /* check that ARES_ELOADIPHLPAPI is an integer */
  return n;
}

static int _cffi_const_ARES_EADDRGETNETWORKPARAMS(unsigned long long *o)
{
  int n = (ARES_EADDRGETNETWORKPARAMS) <= 0;
  *o = (unsigned long long)((ARES_EADDRGETNETWORKPARAMS) | 0);  /* check that ARES_EADDRGETNETWORKPARAMS is an integer */
  return n;
}

static int _cffi_const_ARES_ECANCELLED(unsigned long long *o)
{
  int n = (ARES_ECANCELLED) <= 0;
  *o = (unsigned long long)((ARES_ECANCELLED) | 0);  /* check that ARES_ECANCELLED is an integer */
  return n;
}

static int _cffi_const_ARES_ESERVICE(unsigned long long *o)
{
  int n = (ARES_ESERVICE) <= 0;
  *o = (unsigned long long)((ARES_ESERVICE) | 0);  /* check that ARES_ESERVICE is an integer */
  return n;
}

static int _cffi_const_ARES_ENOSERVER(unsigned long long *o)
{
  int n = (ARES_ENOSERVER) <= 0;
  *o = (unsigned long long)((ARES_ENOSERVER) | 0);  /* check that ARES_ENOSERVER is an integer */
  return n;
}

static struct _cffi_externpy_s _cffi_externpy___addrinfo_cb =
  { "_cares._addrinfo_cb", 0, 0, 0 };

static void _addrinfo_cb(void * a0, int a1, int a2, struct ares_addrinfo * a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(struct ares_addrinfo * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___addrinfo_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___host_cb =
  { "_cares._host_cb", 0, 0, 0 };

static void _host_cb(void * a0, int a1, int a2, struct hostent * a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(struct hostent * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___host_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___nameinfo_cb =
  { "_cares._nameinfo_cb", 0, 0, 0 };

static void _nameinfo_cb(void * a0, int a1, int a2, char * a3, char * a4)
{
  char a[40];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(int *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(char * *)(p + 24) = a3;
  *(char * *)(p + 32) = a4;
  _cffi_call_python(&_cffi_externpy___nameinfo_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___query_dnsrec_cb =
  { "_cares._query_dnsrec_cb", 0, 0, 0 };

static void _query_dnsrec_cb(void * a0, ares_status_t a1, size_t a2, ares_dns_record_t const * a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(ares_status_t *)(p + 8) = a1;
  *(size_t *)(p + 16) = a2;
  *(ares_dns_record_t const * *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___query_dnsrec_cb, p);
}

static struct _cffi_externpy_s _cffi_externpy___sock_state_cb =
  { "_cares._sock_state_cb", 0, 0, 0 };

static void _sock_state_cb(void * a0, ares_socket_t a1, int a2, int a3)
{
  char a[32];
  char *p = a;
  *(void * *)(p + 0) = a0;
  *(ares_socket_t *)(p + 8) = a1;
  *(int *)(p + 16) = a2;
  *(int *)(p + 24) = a3;
  _cffi_call_python(&_cffi_externpy___sock_state_cb, p);
}

static void _cffi_d_ares_cancel(struct ares_channeldata * x0)
{
  ares_cancel(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_cancel(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_cancel(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_cancel _cffi_d_ares_cancel
#endif

static void _cffi_d_ares_destroy(struct ares_channeldata * x0)
{
  ares_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_destroy(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_destroy _cffi_d_ares_destroy
#endif

static void _cffi_d_ares_destroy_options(struct ares_options * x0)
{
  ares_destroy_options(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_destroy_options(PyObject *self, PyObject *arg0)
{
  struct ares_options * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_destroy_options(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_destroy_options _cffi_d_ares_destroy_options
#endif

static ares_status_t _cffi_d_ares_dns_record_create(ares_dns_record_t * * x0, unsigned short x1, unsigned short x2, ares_dns_opcode_t x3, ares_dns_rcode_t x4)
{
  return ares_dns_record_create(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_record_create(PyObject *self, PyObject *args)
{
  ares_dns_record_t * * x0;
  unsigned short x1;
  unsigned short x2;
  ares_dns_opcode_t x3;
  ares_dns_rcode_t x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_dns_record_create", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(14), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_record_t * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(14), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned short);
  if (x1 == (unsigned short)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, unsigned short);
  if (x2 == (unsigned short)-1 && PyErr_Occurred())
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(17), arg3) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x4, _cffi_type(18), arg4) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_record_create(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_record_create _cffi_d_ares_dns_record_create
#endif

static void _cffi_d_ares_dns_record_destroy(ares_dns_record_t * x0)
{
  ares_dns_record_destroy(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_record_destroy(PyObject *self, PyObject *arg0)
{
  ares_dns_record_t * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_record_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_dns_record_destroy(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_dns_record_destroy _cffi_d_ares_dns_record_destroy
#endif

static ares_status_t _cffi_d_ares_dns_record_query_add(ares_dns_record_t * x0, char const * x1, ares_dns_rec_type_t x2, ares_dns_class_t x3)
{
  return ares_dns_record_query_add(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_record_query_add(PyObject *self, PyObject *args)
{
  ares_dns_record_t * x0;
  char const * x1;
  ares_dns_rec_type_t x2;
  ares_dns_class_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_dns_record_query_add", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(21), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_record_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(21), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(23), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(24), arg3) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_record_query_add(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_record_query_add _cffi_d_ares_dns_record_query_add
#endif

static size_t _cffi_d_ares_dns_record_rr_cnt(ares_dns_record_t const * x0, ares_dns_section_t x1)
{
  return ares_dns_record_rr_cnt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_record_rr_cnt(PyObject *self, PyObject *args)
{
  ares_dns_record_t const * x0;
  ares_dns_section_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_record_rr_cnt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_record_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(10), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_record_rr_cnt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_record_rr_cnt _cffi_d_ares_dns_record_rr_cnt
#endif

static ares_dns_rr_t const * _cffi_d_ares_dns_record_rr_get_const(ares_dns_record_t const * x0, ares_dns_section_t x1, size_t x2)
{
  return ares_dns_record_rr_get_const(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_record_rr_get_const(PyObject *self, PyObject *args)
{
  ares_dns_record_t const * x0;
  ares_dns_section_t x1;
  size_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_dns_rr_t const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_dns_record_rr_get_const", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_record_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(10), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_record_rr_get_const(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(3));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_record_rr_get_const _cffi_d_ares_dns_record_rr_get_const
#endif

static unsigned char const * _cffi_d_ares_dns_rr_get_abin(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1, size_t x2, size_t * x3)
{
  return ares_dns_rr_get_abin(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_abin(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  size_t x2;
  size_t * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_abin", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_abin(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(196));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_abin _cffi_d_ares_dns_rr_get_abin
#endif

static size_t _cffi_d_ares_dns_rr_get_abin_cnt(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_abin_cnt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_abin_cnt(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_abin_cnt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_abin_cnt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_abin_cnt _cffi_d_ares_dns_rr_get_abin_cnt
#endif

static struct in_addr const * _cffi_d_ares_dns_rr_get_addr(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_addr(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_addr(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct in_addr const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_addr", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_addr(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(291));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_addr _cffi_d_ares_dns_rr_get_addr
#endif

static struct ares_in6_addr const * _cffi_d_ares_dns_rr_get_addr6(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_addr6(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_addr6(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct ares_in6_addr const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_addr6", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_addr6(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(273));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_addr6 _cffi_d_ares_dns_rr_get_addr6
#endif

static unsigned char const * _cffi_d_ares_dns_rr_get_bin(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1, size_t * x2)
{
  return ares_dns_rr_get_bin(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_bin(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  size_t * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_bin", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_bin(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(196));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_bin _cffi_d_ares_dns_rr_get_bin
#endif

static ares_dns_class_t _cffi_d_ares_dns_rr_get_class(ares_dns_rr_t const * x0)
{
  return ares_dns_rr_get_class(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_class(PyObject *self, PyObject *arg0)
{
  ares_dns_rr_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_dns_class_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_class(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(24));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_class _cffi_d_ares_dns_rr_get_class
#endif

static char const * _cffi_d_ares_dns_rr_get_name(ares_dns_rr_t const * x0)
{
  return ares_dns_rr_get_name(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_name(PyObject *self, PyObject *arg0)
{
  ares_dns_rr_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_name(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(22));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_name _cffi_d_ares_dns_rr_get_name
#endif

static unsigned short _cffi_d_ares_dns_rr_get_opt(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1, size_t x2, unsigned char const * * x3, size_t * x4)
{
  return ares_dns_rr_get_opt(x0, x1, x2, x3, x4);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_opt(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  size_t x2;
  unsigned char const * * x3;
  size_t * x4;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned short result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_opt", 5, 5, &arg0, &arg1, &arg2, &arg3, &arg4))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  x2 = _cffi_to_c_int(arg2, size_t);
  if (x2 == (size_t)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(152), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (unsigned char const * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(152), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(125), arg4, (char **)&x4);
  if (datasize != 0) {
    x4 = ((size_t)datasize) <= 640 ? (size_t *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(125), arg4, (char **)&x4,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_opt(x0, x1, x2, x3, x4); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned short);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_opt _cffi_d_ares_dns_rr_get_opt
#endif

static size_t _cffi_d_ares_dns_rr_get_opt_cnt(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_opt_cnt(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_opt_cnt(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  size_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_opt_cnt", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_opt_cnt(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, size_t);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_opt_cnt _cffi_d_ares_dns_rr_get_opt_cnt
#endif

static char const * _cffi_d_ares_dns_rr_get_str(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_str(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_str(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_str", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_str(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(22));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_str _cffi_d_ares_dns_rr_get_str
#endif

static unsigned int _cffi_d_ares_dns_rr_get_ttl(ares_dns_rr_t const * x0)
{
  return ares_dns_rr_get_ttl(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_ttl(PyObject *self, PyObject *arg0)
{
  ares_dns_rr_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_ttl(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_ttl _cffi_d_ares_dns_rr_get_ttl
#endif

static ares_dns_rec_type_t _cffi_d_ares_dns_rr_get_type(ares_dns_rr_t const * x0)
{
  return ares_dns_rr_get_type(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_type(PyObject *self, PyObject *arg0)
{
  ares_dns_rr_t const * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_dns_rec_type_t result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_type(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(23));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_type _cffi_d_ares_dns_rr_get_type
#endif

static unsigned short _cffi_d_ares_dns_rr_get_u16(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_u16(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_u16(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned short result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_u16", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_u16(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned short);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_u16 _cffi_d_ares_dns_rr_get_u16
#endif

static unsigned int _cffi_d_ares_dns_rr_get_u32(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_u32(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_u32(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_u32", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_u32(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_u32 _cffi_d_ares_dns_rr_get_u32
#endif

static unsigned char _cffi_d_ares_dns_rr_get_u8(ares_dns_rr_t const * x0, ares_dns_rr_key_t x1)
{
  return ares_dns_rr_get_u8(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dns_rr_get_u8(PyObject *self, PyObject *args)
{
  ares_dns_rr_t const * x0;
  ares_dns_rr_key_t x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  unsigned char result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dns_rr_get_u8", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(3), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (ares_dns_rr_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(3), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x1, _cffi_type(53), arg1) < 0)
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dns_rr_get_u8(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, unsigned char);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dns_rr_get_u8 _cffi_d_ares_dns_rr_get_u8
#endif

static int _cffi_d_ares_dup(struct ares_channeldata * * x0, struct ares_channeldata * x1)
{
  return ares_dup(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_dup(PyObject *self, PyObject *args)
{
  struct ares_channeldata * * x0;
  struct ares_channeldata * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_dup", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_dup(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_dup _cffi_d_ares_dup
#endif

static void _cffi_d_ares_free_data(void * x0)
{
  ares_free_data(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_data(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_data(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_data _cffi_d_ares_free_data
#endif

static void _cffi_d_ares_free_hostent(struct hostent * x0)
{
  ares_free_hostent(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_hostent(PyObject *self, PyObject *arg0)
{
  struct hostent * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(214), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct hostent *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(214), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_hostent(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_hostent _cffi_d_ares_free_hostent
#endif

static void _cffi_d_ares_free_string(void * x0)
{
  ares_free_string(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_free_string(PyObject *self, PyObject *arg0)
{
  void * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_free_string(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_free_string _cffi_d_ares_free_string
#endif

static void _cffi_d_ares_freeaddrinfo(struct ares_addrinfo * x0)
{
  ares_freeaddrinfo(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_freeaddrinfo(PyObject *self, PyObject *arg0)
{
  struct ares_addrinfo * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(159), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_addrinfo *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(159), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_freeaddrinfo(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_freeaddrinfo _cffi_d_ares_freeaddrinfo
#endif

static char * _cffi_d_ares_get_servers_csv(struct ares_channeldata * x0)
{
  return ares_get_servers_csv(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_get_servers_csv(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_get_servers_csv(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(64));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_get_servers_csv _cffi_d_ares_get_servers_csv
#endif

static void _cffi_d_ares_getaddrinfo(struct ares_channeldata * x0, char const * x1, char const * x2, struct ares_addrinfo_hints const * x3, void(* x4)(void *, int, int, struct ares_addrinfo *), void * x5)
{
  ares_getaddrinfo(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_getaddrinfo(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  char const * x2;
  struct ares_addrinfo_hints const * x3;
  void(* x4)(void *, int, int, struct ares_addrinfo *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_getaddrinfo", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(177), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (struct ares_addrinfo_hints const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(177), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x4 = (void(*)(void *, int, int, struct ares_addrinfo *))_cffi_to_c_pointer(arg4, _cffi_type(178));
  if (x4 == (void(*)(void *, int, int, struct ares_addrinfo *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_getaddrinfo(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_getaddrinfo _cffi_d_ares_getaddrinfo
#endif

static void _cffi_d_ares_gethostbyaddr(struct ares_channeldata * x0, void const * x1, int x2, int x3, void(* x4)(void *, int, int, struct hostent *), void * x5)
{
  ares_gethostbyaddr(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_gethostbyaddr(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  void const * x1;
  int x2;
  int x3;
  void(* x4)(void *, int, int, struct hostent *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_gethostbyaddr", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, struct hostent *))_cffi_to_c_pointer(arg4, _cffi_type(207));
  if (x4 == (void(*)(void *, int, int, struct hostent *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_gethostbyaddr(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_gethostbyaddr _cffi_d_ares_gethostbyaddr
#endif

static void _cffi_d_ares_getnameinfo(struct ares_channeldata * x0, struct sockaddr const * x1, ares_socklen_t x2, int x3, void(* x4)(void *, int, int, char *, char *), void * x5)
{
  ares_getnameinfo(x0, x1, x2, x3, x4, x5);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_getnameinfo(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct sockaddr const * x1;
  ares_socklen_t x2;
  int x3;
  void(* x4)(void *, int, int, char *, char *);
  void * x5;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;

  if (!PyArg_UnpackTuple(args, "ares_getnameinfo", 6, 6, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(188), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct sockaddr const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(188), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, ares_socklen_t);
  if (x2 == (ares_socklen_t)-1 && PyErr_Occurred())
    return NULL;

  x3 = _cffi_to_c_int(arg3, int);
  if (x3 == (int)-1 && PyErr_Occurred())
    return NULL;

  x4 = (void(*)(void *, int, int, char *, char *))_cffi_to_c_pointer(arg4, _cffi_type(191));
  if (x4 == (void(*)(void *, int, int, char *, char *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_getnameinfo(x0, x1, x2, x3, x4, x5); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_getnameinfo _cffi_d_ares_getnameinfo
#endif

static char const * _cffi_d_ares_inet_ntop(int x0, void const * x1, char * x2, ares_socklen_t x3)
{
  return ares_inet_ntop(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_inet_ntop(PyObject *self, PyObject *args)
{
  int x0;
  void const * x1;
  char * x2;
  ares_socklen_t x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_inet_ntop", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(63), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (void const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(63), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(64), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (char *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(64), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x3 = _cffi_to_c_int(arg3, ares_socklen_t);
  if (x3 == (ares_socklen_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_inet_ntop(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(22));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_inet_ntop _cffi_d_ares_inet_ntop
#endif

static int _cffi_d_ares_inet_pton(int x0, char const * x1, void * x2)
{
  return ares_inet_pton(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_inet_pton(PyObject *self, PyObject *args)
{
  int x0;
  char const * x1;
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_inet_pton", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_inet_pton(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_inet_pton _cffi_d_ares_inet_pton
#endif

static int _cffi_d_ares_init_options(struct ares_channeldata * * x0, struct ares_options * x1, int x2)
{
  return ares_init_options(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_init_options(PyObject *self, PyObject *args)
{
  struct ares_channeldata * * x0;
  struct ares_options * x1;
  int x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_init_options", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(81), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata * *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(81), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = _cffi_to_c_int(arg2, int);
  if (x2 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_init_options(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_init_options _cffi_d_ares_init_options
#endif

static void _cffi_d_ares_library_cleanup(void)
{
  ares_library_cleanup();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_library_cleanup(PyObject *self, PyObject *noarg)
{

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_library_cleanup(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_library_cleanup _cffi_d_ares_library_cleanup
#endif

static int _cffi_d_ares_library_init(int x0)
{
  return ares_library_init(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_library_init(PyObject *self, PyObject *arg0)
{
  int x0;
  int result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_library_init(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  return pyresult;
}
#else
#  define _cffi_f_ares_library_init _cffi_d_ares_library_init
#endif

static void _cffi_d_ares_process_fd(struct ares_channeldata * x0, ares_socket_t x1, ares_socket_t x2)
{
  ares_process_fd(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_process_fd(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  ares_socket_t x1;
  ares_socket_t x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_process_fd", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, ares_socket_t);
  if (x1 == (ares_socket_t)-1 && PyErr_Occurred())
    return NULL;

  x2 = _cffi_to_c_int(arg2, ares_socket_t);
  if (x2 == (ares_socket_t)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_process_fd(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_process_fd _cffi_d_ares_process_fd
#endif

static ares_status_t _cffi_d_ares_query_dnsrec(struct ares_channeldata * x0, char const * x1, ares_dns_class_t x2, ares_dns_rec_type_t x3, void(* x4)(void *, ares_status_t, size_t, ares_dns_record_t const *), void * x5, unsigned short * x6)
{
  return ares_query_dnsrec(x0, x1, x2, x3, x4, x5, x6);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_query_dnsrec(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  ares_dns_class_t x2;
  ares_dns_rec_type_t x3;
  void(* x4)(void *, ares_status_t, size_t, ares_dns_record_t const *);
  void * x5;
  unsigned short * x6;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;
  PyObject *arg4;
  PyObject *arg5;
  PyObject *arg6;

  if (!PyArg_UnpackTuple(args, "ares_query_dnsrec", 7, 7, &arg0, &arg1, &arg2, &arg3, &arg4, &arg5, &arg6))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  if (_cffi_to_c((char *)&x2, _cffi_type(24), arg2) < 0)
    return NULL;

  if (_cffi_to_c((char *)&x3, _cffi_type(23), arg3) < 0)
    return NULL;

  x4 = (void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *))_cffi_to_c_pointer(arg4, _cffi_type(29));
  if (x4 == (void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg5, (char **)&x5);
  if (datasize != 0) {
    x5 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg5, (char **)&x5,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(39), arg6, (char **)&x6);
  if (datasize != 0) {
    x6 = ((size_t)datasize) <= 640 ? (unsigned short *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(39), arg6, (char **)&x6,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_query_dnsrec(x0, x1, x2, x3, x4, x5, x6); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_query_dnsrec _cffi_d_ares_query_dnsrec
#endif

static ares_status_t _cffi_d_ares_queue_wait_empty(struct ares_channeldata * x0, int x1)
{
  return ares_queue_wait_empty(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_queue_wait_empty(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_queue_wait_empty", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, int);
  if (x1 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_queue_wait_empty(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_queue_wait_empty _cffi_d_ares_queue_wait_empty
#endif

static int _cffi_d_ares_reinit(struct ares_channeldata * x0)
{
  return ares_reinit(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_reinit(PyObject *self, PyObject *arg0)
{
  struct ares_channeldata * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_reinit(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_reinit _cffi_d_ares_reinit
#endif

static int _cffi_d_ares_save_options(struct ares_channeldata * x0, struct ares_options * x1, int * x2)
{
  return ares_save_options(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_save_options(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct ares_options * x1;
  int * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_save_options", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(86), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct ares_options *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(86), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_save_options(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_save_options _cffi_d_ares_save_options
#endif

static ares_status_t _cffi_d_ares_search_dnsrec(struct ares_channeldata * x0, ares_dns_record_t const * x1, void(* x2)(void *, ares_status_t, size_t, ares_dns_record_t const *), void * x3)
{
  return ares_search_dnsrec(x0, x1, x2, x3);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_search_dnsrec(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  ares_dns_record_t const * x1;
  void(* x2)(void *, ares_status_t, size_t, ares_dns_record_t const *);
  void * x3;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  ares_status_t result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;
  PyObject *arg3;

  if (!PyArg_UnpackTuple(args, "ares_search_dnsrec", 4, 4, &arg0, &arg1, &arg2, &arg3))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(9), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (ares_dns_record_t const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(9), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x2 = (void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *))_cffi_to_c_pointer(arg2, _cffi_type(29));
  if (x2 == (void(*)(void *, ares_status_t, size_t, ares_dns_record_t const *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg3, (char **)&x3);
  if (datasize != 0) {
    x3 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg3, (char **)&x3,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_search_dnsrec(x0, x1, x2, x3); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(227));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_search_dnsrec _cffi_d_ares_search_dnsrec
#endif

static void _cffi_d_ares_set_local_dev(struct ares_channeldata * x0, char const * x1)
{
  ares_set_local_dev(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_dev(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_dev", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_dev(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_dev _cffi_d_ares_set_local_dev
#endif

static void _cffi_d_ares_set_local_ip4(struct ares_channeldata * x0, unsigned int x1)
{
  ares_set_local_ip4(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_ip4(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  unsigned int x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_ip4", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = _cffi_to_c_int(arg1, unsigned int);
  if (x1 == (unsigned int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_ip4(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_ip4 _cffi_d_ares_set_local_ip4
#endif

static void _cffi_d_ares_set_local_ip6(struct ares_channeldata * x0, unsigned char const * x1)
{
  ares_set_local_ip6(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_local_ip6(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  unsigned char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_local_ip6", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(196), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (unsigned char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(196), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_local_ip6(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_local_ip6 _cffi_d_ares_set_local_ip6
#endif

static int _cffi_d_ares_set_servers_csv(struct ares_channeldata * x0, char const * x1)
{
  return ares_set_servers_csv(x0, x1);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_servers_csv(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  char const * x1;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  int result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;

  if (!PyArg_UnpackTuple(args, "ares_set_servers_csv", 2, 2, &arg0, &arg1))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(22), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (char const *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(22), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_set_servers_csv(x0, x1); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_int(result, int);
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_set_servers_csv _cffi_d_ares_set_servers_csv
#endif

static void _cffi_d_ares_set_socket_callback(struct ares_channeldata * x0, int(* x1)(ares_socket_t, int, void *), void * x2)
{
  ares_set_socket_callback(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_set_socket_callback(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  int(* x1)(ares_socket_t, int, void *);
  void * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_set_socket_callback", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  x1 = (int(*)(ares_socket_t, int, void *))_cffi_to_c_pointer(arg1, _cffi_type(183));
  if (x1 == (int(*)(ares_socket_t, int, void *))NULL && PyErr_Occurred())
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(30), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (void *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(30), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { ares_set_socket_callback(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  Py_INCREF(Py_None);
  return Py_None;
}
#else
#  define _cffi_f_ares_set_socket_callback _cffi_d_ares_set_socket_callback
#endif

static char const * _cffi_d_ares_strerror(int x0)
{
  return ares_strerror(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_strerror(PyObject *self, PyObject *arg0)
{
  int x0;
  char const * result;
  PyObject *pyresult;

  x0 = _cffi_to_c_int(arg0, int);
  if (x0 == (int)-1 && PyErr_Occurred())
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_strerror(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(22));
  return pyresult;
}
#else
#  define _cffi_f_ares_strerror _cffi_d_ares_strerror
#endif

static ares_bool_t _cffi_d_ares_threadsafety(void)
{
  return ares_threadsafety();
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_threadsafety(PyObject *self, PyObject *noarg)
{
  ares_bool_t result;
  PyObject *pyresult;

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_threadsafety(); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  (void)noarg; /* unused */
  pyresult = _cffi_from_c_deref((char *)&result, _cffi_type(252));
  return pyresult;
}
#else
#  define _cffi_f_ares_threadsafety _cffi_d_ares_threadsafety
#endif

static struct timeval * _cffi_d_ares_timeout(struct ares_channeldata * x0, struct timeval * x1, struct timeval * x2)
{
  return ares_timeout(x0, x1, x2);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_timeout(PyObject *self, PyObject *args)
{
  struct ares_channeldata * x0;
  struct timeval * x1;
  struct timeval * x2;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  struct timeval * result;
  PyObject *pyresult;
  PyObject *arg0;
  PyObject *arg1;
  PyObject *arg2;

  if (!PyArg_UnpackTuple(args, "ares_timeout", 3, 3, &arg0, &arg1, &arg2))
    return NULL;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(27), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (struct ares_channeldata *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(27), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(119), arg1, (char **)&x1);
  if (datasize != 0) {
    x1 = ((size_t)datasize) <= 640 ? (struct timeval *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(119), arg1, (char **)&x1,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(119), arg2, (char **)&x2);
  if (datasize != 0) {
    x2 = ((size_t)datasize) <= 640 ? (struct timeval *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(119), arg2, (char **)&x2,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_timeout(x0, x1, x2); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(119));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_timeout _cffi_d_ares_timeout
#endif

static char const * _cffi_d_ares_version(int * x0)
{
  return ares_version(x0);
}
#ifndef PYPY_VERSION
static PyObject *
_cffi_f_ares_version(PyObject *self, PyObject *arg0)
{
  int * x0;
  Py_ssize_t datasize;
  struct _cffi_freeme_s *large_args_free = NULL;
  char const * result;
  PyObject *pyresult;

  datasize = _cffi_prepare_pointer_call_argument(
      _cffi_type(56), arg0, (char **)&x0);
  if (datasize != 0) {
    x0 = ((size_t)datasize) <= 640 ? (int *)alloca((size_t)datasize) : NULL;
    if (_cffi_convert_array_argument(_cffi_type(56), arg0, (char **)&x0,
            datasize, &large_args_free) < 0)
      return NULL;
  }

  Py_BEGIN_ALLOW_THREADS
  _cffi_restore_errno();
  { result = ares_version(x0); }
  _cffi_save_errno();
  Py_END_ALLOW_THREADS

  (void)self; /* unused */
  pyresult = _cffi_from_c_pointer((char *)result, _cffi_type(22));
  if (large_args_free != NULL) _cffi_free_array_arguments(large_args_free);
  return pyresult;
}
#else
#  define _cffi_f_ares_version _cffi_d_ares_version
#endif

static int _cffi_const_ARES_AI_ADDRCONFIG(unsigned long long *o)
{
  int n = (ARES_AI_ADDRCONFIG) <= 0;
  *o = (unsigned long long)((ARES_AI_ADDRCONFIG) | 0);  /* check that ARES_AI_ADDRCONFIG is an integer */
  return n;
}

static int _cffi_const_ARES_AI_ALL(unsigned long long *o)
{
  int n = (ARES_AI_ALL) <= 0;
  *o = (unsigned long long)((ARES_AI_ALL) | 0);  /* check that ARES_AI_ALL is an integer */
  return n;
}

static int _cffi_const_ARES_AI_CANONIDN(unsigned long long *o)
{
  int n = (ARES_AI_CANONIDN) <= 0;
  *o = (unsigned long long)((ARES_AI_CANONIDN) | 0);  /* check that ARES_AI_CANONIDN is an integer */
  return n;
}

static int _cffi_const_ARES_AI_CANONNAME(unsigned long long *o)
{
  int n = (ARES_AI_CANONNAME) <= 0;
  *o = (unsigned long long)((ARES_AI_CANONNAME) | 0);  /* check that ARES_AI_CANONNAME is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN(unsigned long long *o)
{
  int n = (ARES_AI_IDN) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN) | 0);  /* check that ARES_AI_IDN is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN_ALLOW_UNASSIGNED(unsigned long long *o)
{
  int n = (ARES_AI_IDN_ALLOW_UNASSIGNED) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN_ALLOW_UNASSIGNED) | 0);  /* check that ARES_AI_IDN_ALLOW_UNASSIGNED is an integer */
  return n;
}

static int _cffi_const_ARES_AI_IDN_USE_STD3_ASCII_RULES(unsigned long long *o)
{
  int n = (ARES_AI_IDN_USE_STD3_ASCII_RULES) <= 0;
  *o = (unsigned long long)((ARES_AI_IDN_USE_STD3_ASCII_RULES) | 0);  /* check that ARES_AI_IDN_USE_STD3_ASCII_RULES is an integer */
  return n;
}

static int _cffi_const_ARES_AI_MASK(unsigned long long *o)
{
  int n = (ARES_AI_MASK) <= 0;
  *o = (unsigned long long)((ARES_AI_MASK) | 0);  /* check that ARES_AI_MASK is an integer */
  return n;
}

static int _cffi_const_ARES_AI_NUMERICHOST(unsigned long long *o)
{
  int n = (ARES_AI_NUMERICHOST) <= 0;
  *o = (unsigned long long)((ARES_AI_NUMERICHOST) | 0);  /* check that ARES_AI_NUMERICHOST is an integer */
  return n;
}

static int _cffi_const_ARES_AI_NUMERICSERV(unsigned long long *o)
{
  int n = (ARES_AI_NUMERICSERV) <= 0;
  *o = (unsigned long long)((ARES_AI_NUMERICSERV) | 0);  /* check that ARES_AI_NUMERICSERV is an integer */
  return n;
}

static int _cffi_const_ARES_AI_PASSIVE(unsigned long long *o)
{
  int n = (ARES_AI_PASSIVE) <= 0;
  *o = (unsigned long long)((ARES_AI_PASSIVE) | 0);  /* check that ARES_AI_PASSIVE is an integer */
  return n;
}

static int _cffi_const_ARES_AI_V4MAPPED(unsigned long long *o)
{
  int n = (ARES_AI_V4MAPPED) <= 0;
  *o = (unsigned long long)((ARES_AI_V4MAPPED) | 0);  /* check that ARES_AI_V4MAPPED is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_EDNS(unsigned long long *o)
{
  int n = (ARES_FLAG_EDNS) <= 0;
  *o = (unsigned long long)((ARES_FLAG_EDNS) | 0);  /* check that ARES_FLAG_EDNS is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_IGNTC(unsigned long long *o)
{
  int n = (ARES_FLAG_IGNTC) <= 0;
  *o = (unsigned long long)((ARES_FLAG_IGNTC) | 0);  /* check that ARES_FLAG_IGNTC is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOALIASES(unsigned long long *o)
{
  int n = (ARES_FLAG_NOALIASES) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOALIASES) | 0);  /* check that ARES_FLAG_NOALIASES is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOCHECKRESP(unsigned long long *o)
{
  int n = (ARES_FLAG_NOCHECKRESP) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOCHECKRESP) | 0);  /* check that ARES_FLAG_NOCHECKRESP is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NORECURSE(unsigned long long *o)
{
  int n = (ARES_FLAG_NORECURSE) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NORECURSE) | 0);  /* check that ARES_FLAG_NORECURSE is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NOSEARCH(unsigned long long *o)
{
  int n = (ARES_FLAG_NOSEARCH) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NOSEARCH) | 0);  /* check that ARES_FLAG_NOSEARCH is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_NO_DFLT_SVR(unsigned long long *o)
{
  int n = (ARES_FLAG_NO_DFLT_SVR) <= 0;
  *o = (unsigned long long)((ARES_FLAG_NO_DFLT_SVR) | 0);  /* check that ARES_FLAG_NO_DFLT_SVR is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_PRIMARY(unsigned long long *o)
{
  int n = (ARES_FLAG_PRIMARY) <= 0;
  *o = (unsigned long long)((ARES_FLAG_PRIMARY) | 0);  /* check that ARES_FLAG_PRIMARY is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_STAYOPEN(unsigned long long *o)
{
  int n = (ARES_FLAG_STAYOPEN) <= 0;
  *o = (unsigned long long)((ARES_FLAG_STAYOPEN) | 0);  /* check that ARES_FLAG_STAYOPEN is an integer */
  return n;
}

static int _cffi_const_ARES_FLAG_USEVC(unsigned long long *o)
{
  int n = (ARES_FLAG_USEVC) <= 0;
  *o = (unsigned long long)((ARES_FLAG_USEVC) | 0);  /* check that ARES_FLAG_USEVC is an integer */
  return n;
}

static int _cffi_const_ARES_LIB_INIT_ALL(unsigned long long *o)
{
  int n = (ARES_LIB_INIT_ALL) <= 0;
  *o = (unsigned long long)((ARES_LIB_INIT_ALL) | 0);  /* check that ARES_LIB_INIT_ALL is an integer */
  return n;
}

static int _cffi_const_ARES_NI_DCCP(unsigned long long *o)
{
  int n = (ARES_NI_DCCP) <= 0;
  *o = (unsigned long long)((ARES_NI_DCCP) | 0);  /* check that ARES_NI_DCCP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_DGRAM(unsigned long long *o)
{
  int n = (ARES_NI_DGRAM) <= 0;
  *o = (unsigned long long)((ARES_NI_DGRAM) | 0);  /* check that ARES_NI_DGRAM is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN(unsigned long long *o)
{
  int n = (ARES_NI_IDN) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN) | 0);  /* check that ARES_NI_IDN is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN_ALLOW_UNASSIGNED(unsigned long long *o)
{
  int n = (ARES_NI_IDN_ALLOW_UNASSIGNED) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN_ALLOW_UNASSIGNED) | 0);  /* check that ARES_NI_IDN_ALLOW_UNASSIGNED is an integer */
  return n;
}

static int _cffi_const_ARES_NI_IDN_USE_STD3_ASCII_RULES(unsigned long long *o)
{
  int n = (ARES_NI_IDN_USE_STD3_ASCII_RULES) <= 0;
  *o = (unsigned long long)((ARES_NI_IDN_USE_STD3_ASCII_RULES) | 0);  /* check that ARES_NI_IDN_USE_STD3_ASCII_RULES is an integer */
  return n;
}

static int _cffi_const_ARES_NI_LOOKUPHOST(unsigned long long *o)
{
  int n = (ARES_NI_LOOKUPHOST) <= 0;
  *o = (unsigned long long)((ARES_NI_LOOKUPHOST) | 0);  /* check that ARES_NI_LOOKUPHOST is an integer */
  return n;
}

static int _cffi_const_ARES_NI_LOOKUPSERVICE(unsigned long long *o)
{
  int n = (ARES_NI_LOOKUPSERVICE) <= 0;
  *o = (unsigned long long)((ARES_NI_LOOKUPSERVICE) | 0);  /* check that ARES_NI_LOOKUPSERVICE is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NAMEREQD(unsigned long long *o)
{
  int n = (ARES_NI_NAMEREQD) <= 0;
  *o = (unsigned long long)((ARES_NI_NAMEREQD) | 0);  /* check that ARES_NI_NAMEREQD is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NOFQDN(unsigned long long *o)
{
  int n = (ARES_NI_NOFQDN) <= 0;
  *o = (unsigned long long)((ARES_NI_NOFQDN) | 0);  /* check that ARES_NI_NOFQDN is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICHOST(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICHOST) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICHOST) | 0);  /* check that ARES_NI_NUMERICHOST is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICSCOPE(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICSCOPE) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICSCOPE) | 0);  /* check that ARES_NI_NUMERICSCOPE is an integer */
  return n;
}

static int _cffi_const_ARES_NI_NUMERICSERV(unsigned long long *o)
{
  int n = (ARES_NI_NUMERICSERV) <= 0;
  *o = (unsigned long long)((ARES_NI_NUMERICSERV) | 0);  /* check that ARES_NI_NUMERICSERV is an integer */
  return n;
}

static int _cffi_const_ARES_NI_SCTP(unsigned long long *o)
{
  int n = (ARES_NI_SCTP) <= 0;
  *o = (unsigned long long)((ARES_NI_SCTP) | 0);  /* check that ARES_NI_SCTP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_TCP(unsigned long long *o)
{
  int n = (ARES_NI_TCP) <= 0;
  *o = (unsigned long long)((ARES_NI_TCP) | 0);  /* check that ARES_NI_TCP is an integer */
  return n;
}

static int _cffi_const_ARES_NI_UDP(unsigned long long *o)
{
  int n = (ARES_NI_UDP) <= 0;
  *o = (unsigned long long)((ARES_NI_UDP) | 0);  /* check that ARES_NI_UDP is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_DOMAINS(unsigned long long *o)
{
  int n = (ARES_OPT_DOMAINS) <= 0;
  *o = (unsigned long long)((ARES_OPT_DOMAINS) | 0);  /* check that ARES_OPT_DOMAINS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_EDNSPSZ(unsigned long long *o)
{
  int n = (ARES_OPT_EDNSPSZ) <= 0;
  *o = (unsigned long long)((ARES_OPT_EDNSPSZ) | 0);  /* check that ARES_OPT_EDNSPSZ is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_EVENT_THREAD(unsigned long long *o)
{
  int n = (ARES_OPT_EVENT_THREAD) <= 0;
  *o = (unsigned long long)((ARES_OPT_EVENT_THREAD) | 0);  /* check that ARES_OPT_EVENT_THREAD is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_FLAGS(unsigned long long *o)
{
  int n = (ARES_OPT_FLAGS) <= 0;
  *o = (unsigned long long)((ARES_OPT_FLAGS) | 0);  /* check that ARES_OPT_FLAGS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_LOOKUPS(unsigned long long *o)
{
  int n = (ARES_OPT_LOOKUPS) <= 0;
  *o = (unsigned long long)((ARES_OPT_LOOKUPS) | 0);  /* check that ARES_OPT_LOOKUPS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_NDOTS(unsigned long long *o)
{
  int n = (ARES_OPT_NDOTS) <= 0;
  *o = (unsigned long long)((ARES_OPT_NDOTS) | 0);  /* check that ARES_OPT_NDOTS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_RESOLVCONF(unsigned long long *o)
{
  int n = (ARES_OPT_RESOLVCONF) <= 0;
  *o = (unsigned long long)((ARES_OPT_RESOLVCONF) | 0);  /* check that ARES_OPT_RESOLVCONF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_ROTATE(unsigned long long *o)
{
  int n = (ARES_OPT_ROTATE) <= 0;
  *o = (unsigned long long)((ARES_OPT_ROTATE) | 0);  /* check that ARES_OPT_ROTATE is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SERVERS(unsigned long long *o)
{
  int n = (ARES_OPT_SERVERS) <= 0;
  *o = (unsigned long long)((ARES_OPT_SERVERS) | 0);  /* check that ARES_OPT_SERVERS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_RCVBUF(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_RCVBUF) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_RCVBUF) | 0);  /* check that ARES_OPT_SOCK_RCVBUF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_SNDBUF(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_SNDBUF) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_SNDBUF) | 0);  /* check that ARES_OPT_SOCK_SNDBUF is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SOCK_STATE_CB(unsigned long long *o)
{
  int n = (ARES_OPT_SOCK_STATE_CB) <= 0;
  *o = (unsigned long long)((ARES_OPT_SOCK_STATE_CB) | 0);  /* check that ARES_OPT_SOCK_STATE_CB is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_SORTLIST(unsigned long long *o)
{
  int n = (ARES_OPT_SORTLIST) <= 0;
  *o = (unsigned long long)((ARES_OPT_SORTLIST) | 0);  /* check that ARES_OPT_SORTLIST is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TCP_PORT(unsigned long long *o)
{
  int n = (ARES_OPT_TCP_PORT) <= 0;
  *o = (unsigned long long)((ARES_OPT_TCP_PORT) | 0);  /* check that ARES_OPT_TCP_PORT is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TIMEOUT(unsigned long long *o)
{
  int n = (ARES_OPT_TIMEOUT) <= 0;
  *o = (unsigned long long)((ARES_OPT_TIMEOUT) | 0);  /* check that ARES_OPT_TIMEOUT is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TIMEOUTMS(unsigned long long *o)
{
  int n = (ARES_OPT_TIMEOUTMS) <= 0;
  *o = (unsigned long long)((ARES_OPT_TIMEOUTMS) | 0);  /* check that ARES_OPT_TIMEOUTMS is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_TRIES(unsigned long long *o)
{
  int n = (ARES_OPT_TRIES) <= 0;
  *o = (unsigned long long)((ARES_OPT_TRIES) | 0);  /* check that ARES_OPT_TRIES is an integer */
  return n;
}

static int _cffi_const_ARES_OPT_UDP_PORT(unsigned long long *o)
{
  int n = (ARES_OPT_UDP_PORT) <= 0;
  *o = (unsigned long long)((ARES_OPT_UDP_PORT) | 0);  /* check that ARES_OPT_UDP_PORT is an integer */
  return n;
}

static int _cffi_const_ARES_SOCKET_BAD(unsigned long long *o)
{
  int n = (ARES_SOCKET_BAD) <= 0;
  *o = (unsigned long long)((ARES_SOCKET_BAD) | 0);  /* check that ARES_SOCKET_BAD is an integer */
  return n;
}

static int _cffi_const_INET6_ADDRSTRLEN(unsigned long long *o)
{
  int n = (INET6_ADDRSTRLEN) <= 0;
  *o = (unsigned long long)((INET6_ADDRSTRLEN) | 0);  /* check that INET6_ADDRSTRLEN is an integer */
  return n;
}

static int _cffi_const_INET_ADDRSTRLEN(unsigned long long *o)
{
  int n = (INET_ADDRSTRLEN) <= 0;
  *o = (unsigned long long)((INET_ADDRSTRLEN) | 0);  /* check that INET_ADDRSTRLEN is an integer */
  return n;
}

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addr6ttl(struct ares_addr6ttl *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_in6_addr *tmp = &p->ip6addr; (void)tmp; }
  (void)((p->ttl) | 0);  /* check that 'struct ares_addr6ttl.ttl' is an integer */
}
struct _cffi_align_struct_ares_addr6ttl { char x; struct ares_addr6ttl y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo(struct ares_addrinfo *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_addrinfo_cname * *tmp = &p->cnames; (void)tmp; }
  { struct ares_addrinfo_node * *tmp = &p->nodes; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo { char x; struct ares_addrinfo y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_cname(struct ares_addrinfo_cname *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ttl) | 0);  /* check that 'struct ares_addrinfo_cname.ttl' is an integer */
  { char * *tmp = &p->alias; (void)tmp; }
  { char * *tmp = &p->name; (void)tmp; }
  { struct ares_addrinfo_cname * *tmp = &p->next; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo_cname { char x; struct ares_addrinfo_cname y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_hints(struct ares_addrinfo_hints *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ai_flags) | 0);  /* check that 'struct ares_addrinfo_hints.ai_flags' is an integer */
  (void)((p->ai_family) | 0);  /* check that 'struct ares_addrinfo_hints.ai_family' is an integer */
  (void)((p->ai_socktype) | 0);  /* check that 'struct ares_addrinfo_hints.ai_socktype' is an integer */
  (void)((p->ai_protocol) | 0);  /* check that 'struct ares_addrinfo_hints.ai_protocol' is an integer */
}
struct _cffi_align_struct_ares_addrinfo_hints { char x; struct ares_addrinfo_hints y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrinfo_node(struct ares_addrinfo_node *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->ai_ttl) | 0);  /* check that 'struct ares_addrinfo_node.ai_ttl' is an integer */
  (void)((p->ai_flags) | 0);  /* check that 'struct ares_addrinfo_node.ai_flags' is an integer */
  (void)((p->ai_family) | 0);  /* check that 'struct ares_addrinfo_node.ai_family' is an integer */
  (void)((p->ai_socktype) | 0);  /* check that 'struct ares_addrinfo_node.ai_socktype' is an integer */
  (void)((p->ai_protocol) | 0);  /* check that 'struct ares_addrinfo_node.ai_protocol' is an integer */
  (void)((p->ai_addrlen) | 0);  /* check that 'struct ares_addrinfo_node.ai_addrlen' is an integer */
  { struct sockaddr * *tmp = &p->ai_addr; (void)tmp; }
  { struct ares_addrinfo_node * *tmp = &p->ai_next; (void)tmp; }
}
struct _cffi_align_struct_ares_addrinfo_node { char x; struct ares_addrinfo_node y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_addrttl(struct ares_addrttl *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct in_addr *tmp = &p->ipaddr; (void)tmp; }
  (void)((p->ttl) | 0);  /* check that 'struct ares_addrttl.ttl' is an integer */
}
struct _cffi_align_struct_ares_addrttl { char x; struct ares_addrttl y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_caa_reply(struct ares_caa_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_caa_reply * *tmp = &p->next; (void)tmp; }
  (void)((p->critical) | 0);  /* check that 'struct ares_caa_reply.critical' is an integer */
  { unsigned char * *tmp = &p->property; (void)tmp; }
  (void)((p->plength) | 0);  /* check that 'struct ares_caa_reply.plength' is an integer */
  { unsigned char * *tmp = &p->value; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_caa_reply.length' is an integer */
}
struct _cffi_align_struct_ares_caa_reply { char x; struct ares_caa_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_in6_addr(struct ares_in6_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  /* cannot generate 'union $1' in field '_S6_un': unknown type name */
}
struct _cffi_align_struct_ares_in6_addr { char x; struct ares_in6_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_mx_reply(struct ares_mx_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_mx_reply * *tmp = &p->next; (void)tmp; }
  { char * *tmp = &p->host; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'struct ares_mx_reply.priority' is an integer */
}
struct _cffi_align_struct_ares_mx_reply { char x; struct ares_mx_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_naptr_reply(struct ares_naptr_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_naptr_reply * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->flags; (void)tmp; }
  { unsigned char * *tmp = &p->service; (void)tmp; }
  { unsigned char * *tmp = &p->regexp; (void)tmp; }
  { char * *tmp = &p->replacement; (void)tmp; }
  (void)((p->order) | 0);  /* check that 'struct ares_naptr_reply.order' is an integer */
  (void)((p->preference) | 0);  /* check that 'struct ares_naptr_reply.preference' is an integer */
}
struct _cffi_align_struct_ares_naptr_reply { char x; struct ares_naptr_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_options(struct ares_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->flags) | 0);  /* check that 'struct ares_options.flags' is an integer */
  (void)((p->timeout) | 0);  /* check that 'struct ares_options.timeout' is an integer */
  (void)((p->tries) | 0);  /* check that 'struct ares_options.tries' is an integer */
  (void)((p->ndots) | 0);  /* check that 'struct ares_options.ndots' is an integer */
  (void)((p->udp_port) | 0);  /* check that 'struct ares_options.udp_port' is an integer */
  (void)((p->tcp_port) | 0);  /* check that 'struct ares_options.tcp_port' is an integer */
  (void)((p->socket_send_buffer_size) | 0);  /* check that 'struct ares_options.socket_send_buffer_size' is an integer */
  (void)((p->socket_receive_buffer_size) | 0);  /* check that 'struct ares_options.socket_receive_buffer_size' is an integer */
  { struct in_addr * *tmp = &p->servers; (void)tmp; }
  (void)((p->nservers) | 0);  /* check that 'struct ares_options.nservers' is an integer */
  { char * * *tmp = &p->domains; (void)tmp; }
  (void)((p->ndomains) | 0);  /* check that 'struct ares_options.ndomains' is an integer */
  { char * *tmp = &p->lookups; (void)tmp; }
  { void(* *tmp)(void *, ares_socket_t, int, int) = &p->sock_state_cb; (void)tmp; }
  { void * *tmp = &p->sock_state_cb_data; (void)tmp; }
  { struct apattern * *tmp = &p->sortlist; (void)tmp; }
  (void)((p->nsort) | 0);  /* check that 'struct ares_options.nsort' is an integer */
  (void)((p->ednspsz) | 0);  /* check that 'struct ares_options.ednspsz' is an integer */
  { char * *tmp = &p->resolvconf_path; (void)tmp; }
  { char * *tmp = &p->hosts_path; (void)tmp; }
  (void)((p->udp_max_queries) | 0);  /* check that 'struct ares_options.udp_max_queries' is an integer */
  (void)((p->maxtimeout) | 0);  /* check that 'struct ares_options.maxtimeout' is an integer */
  (void)((p->qcache_max_ttl) | 0);  /* check that 'struct ares_options.qcache_max_ttl' is an integer */
  { ares_evsys_t *tmp = &p->evsys; (void)tmp; }
  { struct ares_server_failover_options *tmp = &p->server_failover_opts; (void)tmp; }
}
struct _cffi_align_struct_ares_options { char x; struct ares_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_server_failover_options(struct ares_server_failover_options *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->retry_chance) | 0);  /* check that 'struct ares_server_failover_options.retry_chance' is an integer */
  (void)((p->retry_delay) | 0);  /* check that 'struct ares_server_failover_options.retry_delay' is an integer */
}
struct _cffi_align_struct_ares_server_failover_options { char x; struct ares_server_failover_options y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_soa_reply(struct ares_soa_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->nsname; (void)tmp; }
  { char * *tmp = &p->hostmaster; (void)tmp; }
  (void)((p->serial) | 0);  /* check that 'struct ares_soa_reply.serial' is an integer */
  (void)((p->refresh) | 0);  /* check that 'struct ares_soa_reply.refresh' is an integer */
  (void)((p->retry) | 0);  /* check that 'struct ares_soa_reply.retry' is an integer */
  (void)((p->expire) | 0);  /* check that 'struct ares_soa_reply.expire' is an integer */
  (void)((p->minttl) | 0);  /* check that 'struct ares_soa_reply.minttl' is an integer */
}
struct _cffi_align_struct_ares_soa_reply { char x; struct ares_soa_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_srv_reply(struct ares_srv_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_srv_reply * *tmp = &p->next; (void)tmp; }
  { char * *tmp = &p->host; (void)tmp; }
  (void)((p->priority) | 0);  /* check that 'struct ares_srv_reply.priority' is an integer */
  (void)((p->weight) | 0);  /* check that 'struct ares_srv_reply.weight' is an integer */
  (void)((p->port) | 0);  /* check that 'struct ares_srv_reply.port' is an integer */
}
struct _cffi_align_struct_ares_srv_reply { char x; struct ares_srv_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_txt_ext(struct ares_txt_ext *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_txt_ext * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->txt; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_txt_ext.length' is an integer */
  (void)((p->record_start) | 0);  /* check that 'struct ares_txt_ext.record_start' is an integer */
}
struct _cffi_align_struct_ares_txt_ext { char x; struct ares_txt_ext y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_ares_txt_reply(struct ares_txt_reply *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { struct ares_txt_reply * *tmp = &p->next; (void)tmp; }
  { unsigned char * *tmp = &p->txt; (void)tmp; }
  (void)((p->length) | 0);  /* check that 'struct ares_txt_reply.length' is an integer */
}
struct _cffi_align_struct_ares_txt_reply { char x; struct ares_txt_reply y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_hostent(struct hostent *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { char * *tmp = &p->h_name; (void)tmp; }
  { char * * *tmp = &p->h_aliases; (void)tmp; }
  (void)((p->h_addrtype) | 0);  /* check that 'struct hostent.h_addrtype' is an integer */
  (void)((p->h_length) | 0);  /* check that 'struct hostent.h_length' is an integer */
  { char * * *tmp = &p->h_addr_list; (void)tmp; }
}
struct _cffi_align_struct_hostent { char x; struct hostent y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_in6_addr(struct in6_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  { uint8_t(*tmp)[16] = &p->s6_addr; (void)tmp; }
}
struct _cffi_align_struct_in6_addr { char x; struct in6_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_in_addr(struct in_addr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->s_addr) | 0);  /* check that 'struct in_addr.s_addr' is an integer */
}
struct _cffi_align_struct_in_addr { char x; struct in_addr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr(struct sockaddr *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sa_family) | 0);  /* check that 'struct sockaddr.sa_family' is an integer */
}
struct _cffi_align_struct_sockaddr { char x; struct sockaddr y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr_in(struct sockaddr_in *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sin_family) | 0);  /* check that 'struct sockaddr_in.sin_family' is an integer */
  (void)((p->sin_port) | 0);  /* check that 'struct sockaddr_in.sin_port' is an integer */
  { struct in_addr *tmp = &p->sin_addr; (void)tmp; }
}
struct _cffi_align_struct_sockaddr_in { char x; struct sockaddr_in y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_sockaddr_in6(struct sockaddr_in6 *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->sin6_family) | 0);  /* check that 'struct sockaddr_in6.sin6_family' is an integer */
  (void)((p->sin6_port) | 0);  /* check that 'struct sockaddr_in6.sin6_port' is an integer */
  (void)((p->sin6_flowinfo) | 0);  /* check that 'struct sockaddr_in6.sin6_flowinfo' is an integer */
  { struct in6_addr *tmp = &p->sin6_addr; (void)tmp; }
  (void)((p->sin6_scope_id) | 0);  /* check that 'struct sockaddr_in6.sin6_scope_id' is an integer */
}
struct _cffi_align_struct_sockaddr_in6 { char x; struct sockaddr_in6 y; };

_CFFI_UNUSED_FN
static void _cffi_checkfld_struct_timeval(struct timeval *p)
{
  /* only to generate compile-time warnings or errors */
  (void)p;
  (void)((p->tv_sec) | 0);  /* check that 'struct timeval.tv_sec' is an integer */
  (void)((p->tv_usec) | 0);  /* check that 'struct timeval.tv_usec' is an integer */
}
struct _cffi_align_struct_timeval { char x; struct timeval y; };

static const struct _cffi_global_s _cffi_globals[] = {
  { "ARES_AI_ADDRCONFIG", (void *)_cffi_const_ARES_AI_ADDRCONFIG, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_ALL", (void *)_cffi_const_ARES_AI_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_CANONIDN", (void *)_cffi_const_ARES_AI_CANONIDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_CANONNAME", (void *)_cffi_const_ARES_AI_CANONNAME, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN", (void *)_cffi_const_ARES_AI_IDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN_ALLOW_UNASSIGNED", (void *)_cffi_const_ARES_AI_IDN_ALLOW_UNASSIGNED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_IDN_USE_STD3_ASCII_RULES", (void *)_cffi_const_ARES_AI_IDN_USE_STD3_ASCII_RULES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_MASK", (void *)_cffi_const_ARES_AI_MASK, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_NUMERICHOST", (void *)_cffi_const_ARES_AI_NUMERICHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_NUMERICSERV", (void *)_cffi_const_ARES_AI_NUMERICSERV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_PASSIVE", (void *)_cffi_const_ARES_AI_PASSIVE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_AI_V4MAPPED", (void *)_cffi_const_ARES_AI_V4MAPPED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_CLASS_ANY", (void *)_cffi_const_ARES_CLASS_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_CLASS_CHAOS", (void *)_cffi_const_ARES_CLASS_CHAOS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_CLASS_HESOID", (void *)_cffi_const_ARES_CLASS_HESOID, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_CLASS_IN", (void *)_cffi_const_ARES_CLASS_IN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_CLASS_NONE", (void *)_cffi_const_ARES_CLASS_NONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EADDRGETNETWORKPARAMS", (void *)_cffi_const_ARES_EADDRGETNETWORKPARAMS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADFAMILY", (void *)_cffi_const_ARES_EBADFAMILY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADFLAGS", (void *)_cffi_const_ARES_EBADFLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADHINTS", (void *)_cffi_const_ARES_EBADHINTS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADNAME", (void *)_cffi_const_ARES_EBADNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADQUERY", (void *)_cffi_const_ARES_EBADQUERY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADRESP", (void *)_cffi_const_ARES_EBADRESP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EBADSTR", (void *)_cffi_const_ARES_EBADSTR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ECANCELLED", (void *)_cffi_const_ARES_ECANCELLED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ECONNREFUSED", (void *)_cffi_const_ARES_ECONNREFUSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EDESTRUCTION", (void *)_cffi_const_ARES_EDESTRUCTION, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EFILE", (void *)_cffi_const_ARES_EFILE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EFORMERR", (void *)_cffi_const_ARES_EFORMERR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ELOADIPHLPAPI", (void *)_cffi_const_ARES_ELOADIPHLPAPI, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENODATA", (void *)_cffi_const_ARES_ENODATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOMEM", (void *)_cffi_const_ARES_ENOMEM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENONAME", (void *)_cffi_const_ARES_ENONAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOSERVER", (void *)_cffi_const_ARES_ENOSERVER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTFOUND", (void *)_cffi_const_ARES_ENOTFOUND, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTIMP", (void *)_cffi_const_ARES_ENOTIMP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ENOTINITIALIZED", (void *)_cffi_const_ARES_ENOTINITIALIZED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EOF", (void *)_cffi_const_ARES_EOF, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EREFUSED", (void *)_cffi_const_ARES_EREFUSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ESERVFAIL", (void *)_cffi_const_ARES_ESERVFAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ESERVICE", (void *)_cffi_const_ARES_ESERVICE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_ETIMEOUT", (void *)_cffi_const_ARES_ETIMEOUT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_DEFAULT", (void *)_cffi_const_ARES_EVSYS_DEFAULT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_EPOLL", (void *)_cffi_const_ARES_EVSYS_EPOLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_KQUEUE", (void *)_cffi_const_ARES_EVSYS_KQUEUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_POLL", (void *)_cffi_const_ARES_EVSYS_POLL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_SELECT", (void *)_cffi_const_ARES_EVSYS_SELECT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_EVSYS_WIN32", (void *)_cffi_const_ARES_EVSYS_WIN32, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FALSE", (void *)_cffi_const_ARES_FALSE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_AA", (void *)_cffi_const_ARES_FLAG_AA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_AD", (void *)_cffi_const_ARES_FLAG_AD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_CD", (void *)_cffi_const_ARES_FLAG_CD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_EDNS", (void *)_cffi_const_ARES_FLAG_EDNS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_IGNTC", (void *)_cffi_const_ARES_FLAG_IGNTC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOALIASES", (void *)_cffi_const_ARES_FLAG_NOALIASES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOCHECKRESP", (void *)_cffi_const_ARES_FLAG_NOCHECKRESP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NORECURSE", (void *)_cffi_const_ARES_FLAG_NORECURSE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NOSEARCH", (void *)_cffi_const_ARES_FLAG_NOSEARCH, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_NO_DFLT_SVR", (void *)_cffi_const_ARES_FLAG_NO_DFLT_SVR, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_PRIMARY", (void *)_cffi_const_ARES_FLAG_PRIMARY, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_QR", (void *)_cffi_const_ARES_FLAG_QR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_RA", (void *)_cffi_const_ARES_FLAG_RA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_RD", (void *)_cffi_const_ARES_FLAG_RD, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_STAYOPEN", (void *)_cffi_const_ARES_FLAG_STAYOPEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_FLAG_TC", (void *)_cffi_const_ARES_FLAG_TC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_FLAG_USEVC", (void *)_cffi_const_ARES_FLAG_USEVC, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_LIB_INIT_ALL", (void *)_cffi_const_ARES_LIB_INIT_ALL, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_DCCP", (void *)_cffi_const_ARES_NI_DCCP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_DGRAM", (void *)_cffi_const_ARES_NI_DGRAM, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN", (void *)_cffi_const_ARES_NI_IDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN_ALLOW_UNASSIGNED", (void *)_cffi_const_ARES_NI_IDN_ALLOW_UNASSIGNED, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_IDN_USE_STD3_ASCII_RULES", (void *)_cffi_const_ARES_NI_IDN_USE_STD3_ASCII_RULES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_LOOKUPHOST", (void *)_cffi_const_ARES_NI_LOOKUPHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_LOOKUPSERVICE", (void *)_cffi_const_ARES_NI_LOOKUPSERVICE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NAMEREQD", (void *)_cffi_const_ARES_NI_NAMEREQD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NOFQDN", (void *)_cffi_const_ARES_NI_NOFQDN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICHOST", (void *)_cffi_const_ARES_NI_NUMERICHOST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICSCOPE", (void *)_cffi_const_ARES_NI_NUMERICSCOPE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_NUMERICSERV", (void *)_cffi_const_ARES_NI_NUMERICSERV, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_SCTP", (void *)_cffi_const_ARES_NI_SCTP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_TCP", (void *)_cffi_const_ARES_NI_TCP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_NI_UDP", (void *)_cffi_const_ARES_NI_UDP, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPCODE_IQUERY", (void *)_cffi_const_ARES_OPCODE_IQUERY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_OPCODE_NOTIFY", (void *)_cffi_const_ARES_OPCODE_NOTIFY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_OPCODE_QUERY", (void *)_cffi_const_ARES_OPCODE_QUERY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_OPCODE_STATUS", (void *)_cffi_const_ARES_OPCODE_STATUS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_OPCODE_UPDATE", (void *)_cffi_const_ARES_OPCODE_UPDATE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_OPT_DOMAINS", (void *)_cffi_const_ARES_OPT_DOMAINS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_EDNSPSZ", (void *)_cffi_const_ARES_OPT_EDNSPSZ, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_EVENT_THREAD", (void *)_cffi_const_ARES_OPT_EVENT_THREAD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_FLAGS", (void *)_cffi_const_ARES_OPT_FLAGS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_LOOKUPS", (void *)_cffi_const_ARES_OPT_LOOKUPS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_NDOTS", (void *)_cffi_const_ARES_OPT_NDOTS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_RESOLVCONF", (void *)_cffi_const_ARES_OPT_RESOLVCONF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_ROTATE", (void *)_cffi_const_ARES_OPT_ROTATE, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SERVERS", (void *)_cffi_const_ARES_OPT_SERVERS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_RCVBUF", (void *)_cffi_const_ARES_OPT_SOCK_RCVBUF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_SNDBUF", (void *)_cffi_const_ARES_OPT_SOCK_SNDBUF, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SOCK_STATE_CB", (void *)_cffi_const_ARES_OPT_SOCK_STATE_CB, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_SORTLIST", (void *)_cffi_const_ARES_OPT_SORTLIST, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TCP_PORT", (void *)_cffi_const_ARES_OPT_TCP_PORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TIMEOUT", (void *)_cffi_const_ARES_OPT_TIMEOUT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TIMEOUTMS", (void *)_cffi_const_ARES_OPT_TIMEOUTMS, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_TRIES", (void *)_cffi_const_ARES_OPT_TRIES, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_OPT_UDP_PORT", (void *)_cffi_const_ARES_OPT_UDP_PORT, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_RCODE_BADALG", (void *)_cffi_const_ARES_RCODE_BADALG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADCOOKIE", (void *)_cffi_const_ARES_RCODE_BADCOOKIE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADKEY", (void *)_cffi_const_ARES_RCODE_BADKEY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADMODE", (void *)_cffi_const_ARES_RCODE_BADMODE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADNAME", (void *)_cffi_const_ARES_RCODE_BADNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADSIG", (void *)_cffi_const_ARES_RCODE_BADSIG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADTIME", (void *)_cffi_const_ARES_RCODE_BADTIME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_BADTRUNC", (void *)_cffi_const_ARES_RCODE_BADTRUNC, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_DSOTYPEI", (void *)_cffi_const_ARES_RCODE_DSOTYPEI, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_FORMERR", (void *)_cffi_const_ARES_RCODE_FORMERR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NOERROR", (void *)_cffi_const_ARES_RCODE_NOERROR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NOTAUTH", (void *)_cffi_const_ARES_RCODE_NOTAUTH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NOTIMP", (void *)_cffi_const_ARES_RCODE_NOTIMP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NOTZONE", (void *)_cffi_const_ARES_RCODE_NOTZONE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NXDOMAIN", (void *)_cffi_const_ARES_RCODE_NXDOMAIN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_NXRRSET", (void *)_cffi_const_ARES_RCODE_NXRRSET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_REFUSED", (void *)_cffi_const_ARES_RCODE_REFUSED, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_SERVFAIL", (void *)_cffi_const_ARES_RCODE_SERVFAIL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_YXDOMAIN", (void *)_cffi_const_ARES_RCODE_YXDOMAIN, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RCODE_YXRRSET", (void *)_cffi_const_ARES_RCODE_YXRRSET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_A", (void *)_cffi_const_ARES_REC_TYPE_A, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_AAAA", (void *)_cffi_const_ARES_REC_TYPE_AAAA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_ANY", (void *)_cffi_const_ARES_REC_TYPE_ANY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_CAA", (void *)_cffi_const_ARES_REC_TYPE_CAA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_CNAME", (void *)_cffi_const_ARES_REC_TYPE_CNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_HTTPS", (void *)_cffi_const_ARES_REC_TYPE_HTTPS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_MX", (void *)_cffi_const_ARES_REC_TYPE_MX, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_NAPTR", (void *)_cffi_const_ARES_REC_TYPE_NAPTR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_NS", (void *)_cffi_const_ARES_REC_TYPE_NS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_PTR", (void *)_cffi_const_ARES_REC_TYPE_PTR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_SOA", (void *)_cffi_const_ARES_REC_TYPE_SOA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_SRV", (void *)_cffi_const_ARES_REC_TYPE_SRV, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_TLSA", (void *)_cffi_const_ARES_REC_TYPE_TLSA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_TXT", (void *)_cffi_const_ARES_REC_TYPE_TXT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_REC_TYPE_URI", (void *)_cffi_const_ARES_REC_TYPE_URI, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_AAAA_ADDR", (void *)_cffi_const_ARES_RR_AAAA_ADDR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_A_ADDR", (void *)_cffi_const_ARES_RR_A_ADDR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_CAA_CRITICAL", (void *)_cffi_const_ARES_RR_CAA_CRITICAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_CAA_TAG", (void *)_cffi_const_ARES_RR_CAA_TAG, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_CAA_VALUE", (void *)_cffi_const_ARES_RR_CAA_VALUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_CNAME_CNAME", (void *)_cffi_const_ARES_RR_CNAME_CNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_HTTPS_PARAMS", (void *)_cffi_const_ARES_RR_HTTPS_PARAMS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_HTTPS_PRIORITY", (void *)_cffi_const_ARES_RR_HTTPS_PRIORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_HTTPS_TARGET", (void *)_cffi_const_ARES_RR_HTTPS_TARGET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_MX_EXCHANGE", (void *)_cffi_const_ARES_RR_MX_EXCHANGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_MX_PREFERENCE", (void *)_cffi_const_ARES_RR_MX_PREFERENCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_FLAGS", (void *)_cffi_const_ARES_RR_NAPTR_FLAGS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_ORDER", (void *)_cffi_const_ARES_RR_NAPTR_ORDER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_PREFERENCE", (void *)_cffi_const_ARES_RR_NAPTR_PREFERENCE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_REGEXP", (void *)_cffi_const_ARES_RR_NAPTR_REGEXP, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_REPLACEMENT", (void *)_cffi_const_ARES_RR_NAPTR_REPLACEMENT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NAPTR_SERVICES", (void *)_cffi_const_ARES_RR_NAPTR_SERVICES, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_NS_NSDNAME", (void *)_cffi_const_ARES_RR_NS_NSDNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_PTR_DNAME", (void *)_cffi_const_ARES_RR_PTR_DNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_EXPIRE", (void *)_cffi_const_ARES_RR_SOA_EXPIRE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_MINIMUM", (void *)_cffi_const_ARES_RR_SOA_MINIMUM, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_MNAME", (void *)_cffi_const_ARES_RR_SOA_MNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_REFRESH", (void *)_cffi_const_ARES_RR_SOA_REFRESH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_RETRY", (void *)_cffi_const_ARES_RR_SOA_RETRY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_RNAME", (void *)_cffi_const_ARES_RR_SOA_RNAME, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SOA_SERIAL", (void *)_cffi_const_ARES_RR_SOA_SERIAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SRV_PORT", (void *)_cffi_const_ARES_RR_SRV_PORT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SRV_PRIORITY", (void *)_cffi_const_ARES_RR_SRV_PRIORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SRV_TARGET", (void *)_cffi_const_ARES_RR_SRV_TARGET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_SRV_WEIGHT", (void *)_cffi_const_ARES_RR_SRV_WEIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_TLSA_CERT_USAGE", (void *)_cffi_const_ARES_RR_TLSA_CERT_USAGE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_TLSA_DATA", (void *)_cffi_const_ARES_RR_TLSA_DATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_TLSA_MATCH", (void *)_cffi_const_ARES_RR_TLSA_MATCH, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_TLSA_SELECTOR", (void *)_cffi_const_ARES_RR_TLSA_SELECTOR, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_TXT_DATA", (void *)_cffi_const_ARES_RR_TXT_DATA, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_URI_PRIORITY", (void *)_cffi_const_ARES_RR_URI_PRIORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_URI_TARGET", (void *)_cffi_const_ARES_RR_URI_TARGET, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_RR_URI_WEIGHT", (void *)_cffi_const_ARES_RR_URI_WEIGHT, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_SECTION_ADDITIONAL", (void *)_cffi_const_ARES_SECTION_ADDITIONAL, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_SECTION_ANSWER", (void *)_cffi_const_ARES_SECTION_ANSWER, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_SECTION_AUTHORITY", (void *)_cffi_const_ARES_SECTION_AUTHORITY, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_SOCKET_BAD", (void *)_cffi_const_ARES_SOCKET_BAD, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "ARES_SUCCESS", (void *)_cffi_const_ARES_SUCCESS, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "ARES_TRUE", (void *)_cffi_const_ARES_TRUE, _CFFI_OP(_CFFI_OP_ENUM, -1), (void *)0 },
  { "INET6_ADDRSTRLEN", (void *)_cffi_const_INET6_ADDRSTRLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "INET_ADDRSTRLEN", (void *)_cffi_const_INET_ADDRSTRLEN, _CFFI_OP(_CFFI_OP_CONSTANT_INT, -1), (void *)0 },
  { "_addrinfo_cb", (void *)&_cffi_externpy___addrinfo_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 178), (void *)_addrinfo_cb },
  { "_host_cb", (void *)&_cffi_externpy___host_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 207), (void *)_host_cb },
  { "_nameinfo_cb", (void *)&_cffi_externpy___nameinfo_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 191), (void *)_nameinfo_cb },
  { "_query_dnsrec_cb", (void *)&_cffi_externpy___query_dnsrec_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 29), (void *)_query_dnsrec_cb },
  { "_sock_state_cb", (void *)&_cffi_externpy___sock_state_cb, _CFFI_OP(_CFFI_OP_EXTERN_PYTHON, 310), (void *)_sock_state_cb },
  { "ares_cancel", (void *)_cffi_f_ares_cancel, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 161), (void *)_cffi_d_ares_cancel },
  { "ares_destroy", (void *)_cffi_f_ares_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 161), (void *)_cffi_d_ares_destroy },
  { "ares_destroy_options", (void *)_cffi_f_ares_destroy_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 210), (void *)_cffi_d_ares_destroy_options },
  { "ares_dns_record_create", (void *)_cffi_f_ares_dns_record_create, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 13), (void *)_cffi_d_ares_dns_record_create },
  { "ares_dns_record_destroy", (void *)_cffi_f_ares_dns_record_destroy, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 155), (void *)_cffi_d_ares_dns_record_destroy },
  { "ares_dns_record_query_add", (void *)_cffi_f_ares_dns_record_query_add, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 20), (void *)_cffi_d_ares_dns_record_query_add },
  { "ares_dns_record_rr_cnt", (void *)_cffi_f_ares_dns_record_rr_cnt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 101), (void *)_cffi_d_ares_dns_record_rr_cnt },
  { "ares_dns_record_rr_get_const", (void *)_cffi_f_ares_dns_record_rr_get_const, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 8), (void *)_cffi_d_ares_dns_record_rr_get_const },
  { "ares_dns_rr_get_abin", (void *)_cffi_f_ares_dns_rr_get_abin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 127), (void *)_cffi_d_ares_dns_rr_get_abin },
  { "ares_dns_rr_get_abin_cnt", (void *)_cffi_f_ares_dns_rr_get_abin_cnt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 105), (void *)_cffi_d_ares_dns_rr_get_abin_cnt },
  { "ares_dns_rr_get_addr", (void *)_cffi_f_ares_dns_rr_get_addr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 113), (void *)_cffi_d_ares_dns_rr_get_addr },
  { "ares_dns_rr_get_addr6", (void *)_cffi_f_ares_dns_rr_get_addr6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 109), (void *)_cffi_d_ares_dns_rr_get_addr6 },
  { "ares_dns_rr_get_bin", (void *)_cffi_f_ares_dns_rr_get_bin, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 122), (void *)_cffi_d_ares_dns_rr_get_bin },
  { "ares_dns_rr_get_class", (void *)_cffi_f_ares_dns_rr_get_class, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 2), (void *)_cffi_d_ares_dns_rr_get_class },
  { "ares_dns_rr_get_name", (void *)_cffi_f_ares_dns_rr_get_name, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 48), (void *)_cffi_d_ares_dns_rr_get_name },
  { "ares_dns_rr_get_opt", (void *)_cffi_f_ares_dns_rr_get_opt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 148), (void *)_cffi_d_ares_dns_rr_get_opt },
  { "ares_dns_rr_get_opt_cnt", (void *)_cffi_f_ares_dns_rr_get_opt_cnt, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 105), (void *)_cffi_d_ares_dns_rr_get_opt_cnt },
  { "ares_dns_rr_get_str", (void *)_cffi_f_ares_dns_rr_get_str, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 51), (void *)_cffi_d_ares_dns_rr_get_str },
  { "ares_dns_rr_get_ttl", (void *)_cffi_f_ares_dns_rr_get_ttl, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 137), (void *)_cffi_d_ares_dns_rr_get_ttl },
  { "ares_dns_rr_get_type", (void *)_cffi_f_ares_dns_rr_get_type, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 5), (void *)_cffi_d_ares_dns_rr_get_type },
  { "ares_dns_rr_get_u16", (void *)_cffi_f_ares_dns_rr_get_u16, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 144), (void *)_cffi_d_ares_dns_rr_get_u16 },
  { "ares_dns_rr_get_u32", (void *)_cffi_f_ares_dns_rr_get_u32, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 140), (void *)_cffi_d_ares_dns_rr_get_u32 },
  { "ares_dns_rr_get_u8", (void *)_cffi_f_ares_dns_rr_get_u8, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 133), (void *)_cffi_d_ares_dns_rr_get_u8 },
  { "ares_dup", (void *)_cffi_f_ares_dup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 80), (void *)_cffi_d_ares_dup },
  { "ares_free_data", (void *)_cffi_f_ares_free_data, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 216), (void *)_cffi_d_ares_free_data },
  { "ares_free_hostent", (void *)_cffi_f_ares_free_hostent, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 213), (void *)_cffi_d_ares_free_hostent },
  { "ares_free_string", (void *)_cffi_f_ares_free_string, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 216), (void *)_cffi_d_ares_free_string },
  { "ares_freeaddrinfo", (void *)_cffi_f_ares_freeaddrinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 158), (void *)_cffi_d_ares_freeaddrinfo },
  { "ares_get_servers_csv", (void *)_cffi_f_ares_get_servers_csv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 45), (void *)_cffi_d_ares_get_servers_csv },
  { "ares_getaddrinfo", (void *)_cffi_f_ares_getaddrinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 173), (void *)_cffi_d_ares_getaddrinfo },
  { "ares_gethostbyaddr", (void *)_cffi_f_ares_gethostbyaddr, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 202), (void *)_cffi_d_ares_gethostbyaddr },
  { "ares_getnameinfo", (void *)_cffi_f_ares_getnameinfo, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 186), (void *)_cffi_d_ares_getnameinfo },
  { "ares_inet_ntop", (void *)_cffi_f_ares_inet_ntop, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 61), (void *)_cffi_d_ares_inet_ntop },
  { "ares_inet_pton", (void *)_cffi_f_ares_inet_pton, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 75), (void *)_cffi_d_ares_inet_pton },
  { "ares_init_options", (void *)_cffi_f_ares_init_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 84), (void *)_cffi_d_ares_init_options },
  { "ares_library_cleanup", (void *)_cffi_f_ares_library_cleanup, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 250), (void *)_cffi_d_ares_library_cleanup },
  { "ares_library_init", (void *)_cffi_f_ares_library_init, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 72), (void *)_cffi_d_ares_library_init },
  { "ares_process_fd", (void *)_cffi_f_ares_process_fd, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 164), (void *)_cffi_d_ares_process_fd },
  { "ares_query_dnsrec", (void *)_cffi_f_ares_query_dnsrec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 32), (void *)_cffi_d_ares_query_dnsrec },
  { "ares_queue_wait_empty", (void *)_cffi_f_ares_queue_wait_empty, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 41), (void *)_cffi_d_ares_queue_wait_empty },
  { "ares_reinit", (void *)_cffi_f_ares_reinit, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 89), (void *)_cffi_d_ares_reinit },
  { "ares_save_options", (void *)_cffi_f_ares_save_options, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 96), (void *)_cffi_d_ares_save_options },
  { "ares_search_dnsrec", (void *)_cffi_f_ares_search_dnsrec, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 26), (void *)_cffi_d_ares_search_dnsrec },
  { "ares_set_local_dev", (void *)_cffi_f_ares_set_local_dev, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 169), (void *)_cffi_d_ares_set_local_dev },
  { "ares_set_local_ip4", (void *)_cffi_f_ares_set_local_ip4, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 198), (void *)_cffi_d_ares_set_local_ip4 },
  { "ares_set_local_ip6", (void *)_cffi_f_ares_set_local_ip6, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 194), (void *)_cffi_d_ares_set_local_ip6 },
  { "ares_set_servers_csv", (void *)_cffi_f_ares_set_servers_csv, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 92), (void *)_cffi_d_ares_set_servers_csv },
  { "ares_set_socket_callback", (void *)_cffi_f_ares_set_socket_callback, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 181), (void *)_cffi_d_ares_set_socket_callback },
  { "ares_strerror", (void *)_cffi_f_ares_strerror, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 58), (void *)_cffi_d_ares_strerror },
  { "ares_threadsafety", (void *)_cffi_f_ares_threadsafety, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_N, 0), (void *)_cffi_d_ares_threadsafety },
  { "ares_timeout", (void *)_cffi_f_ares_timeout, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_V, 117), (void *)_cffi_d_ares_timeout },
  { "ares_version", (void *)_cffi_f_ares_version, _CFFI_OP(_CFFI_OP_CPYTHON_BLTN_O, 55), (void *)_cffi_d_ares_version },
};

static const struct _cffi_field_s _cffi_fields[] = {
  { "ip6addr", offsetof(struct ares_addr6ttl, ip6addr),
               sizeof(((struct ares_addr6ttl *)0)->ip6addr),
               _CFFI_OP(_CFFI_OP_NOOP, 274) },
  { "ttl", offsetof(struct ares_addr6ttl, ttl),
           sizeof(((struct ares_addr6ttl *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "cnames", offsetof(struct ares_addrinfo, cnames),
              sizeof(((struct ares_addrinfo *)0)->cnames),
              _CFFI_OP(_CFFI_OP_NOOP, 264) },
  { "nodes", offsetof(struct ares_addrinfo, nodes),
             sizeof(((struct ares_addrinfo *)0)->nodes),
             _CFFI_OP(_CFFI_OP_NOOP, 267) },
  { "ttl", offsetof(struct ares_addrinfo_cname, ttl),
           sizeof(((struct ares_addrinfo_cname *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "alias", offsetof(struct ares_addrinfo_cname, alias),
             sizeof(((struct ares_addrinfo_cname *)0)->alias),
             _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "name", offsetof(struct ares_addrinfo_cname, name),
            sizeof(((struct ares_addrinfo_cname *)0)->name),
            _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "next", offsetof(struct ares_addrinfo_cname, next),
            sizeof(((struct ares_addrinfo_cname *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 264) },
  { "ai_flags", offsetof(struct ares_addrinfo_hints, ai_flags),
                sizeof(((struct ares_addrinfo_hints *)0)->ai_flags),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_family", offsetof(struct ares_addrinfo_hints, ai_family),
                 sizeof(((struct ares_addrinfo_hints *)0)->ai_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_socktype", offsetof(struct ares_addrinfo_hints, ai_socktype),
                   sizeof(((struct ares_addrinfo_hints *)0)->ai_socktype),
                   _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_protocol", offsetof(struct ares_addrinfo_hints, ai_protocol),
                   sizeof(((struct ares_addrinfo_hints *)0)->ai_protocol),
                   _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_ttl", offsetof(struct ares_addrinfo_node, ai_ttl),
              sizeof(((struct ares_addrinfo_node *)0)->ai_ttl),
              _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_flags", offsetof(struct ares_addrinfo_node, ai_flags),
                sizeof(((struct ares_addrinfo_node *)0)->ai_flags),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_family", offsetof(struct ares_addrinfo_node, ai_family),
                 sizeof(((struct ares_addrinfo_node *)0)->ai_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_socktype", offsetof(struct ares_addrinfo_node, ai_socktype),
                   sizeof(((struct ares_addrinfo_node *)0)->ai_socktype),
                   _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_protocol", offsetof(struct ares_addrinfo_node, ai_protocol),
                   sizeof(((struct ares_addrinfo_node *)0)->ai_protocol),
                   _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ai_addrlen", offsetof(struct ares_addrinfo_node, ai_addrlen),
                  sizeof(((struct ares_addrinfo_node *)0)->ai_addrlen),
                  _CFFI_OP(_CFFI_OP_NOOP, 65) },
  { "ai_addr", offsetof(struct ares_addrinfo_node, ai_addr),
               sizeof(((struct ares_addrinfo_node *)0)->ai_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 293) },
  { "ai_next", offsetof(struct ares_addrinfo_node, ai_next),
               sizeof(((struct ares_addrinfo_node *)0)->ai_next),
               _CFFI_OP(_CFFI_OP_NOOP, 267) },
  { "ipaddr", offsetof(struct ares_addrttl, ipaddr),
              sizeof(((struct ares_addrttl *)0)->ipaddr),
              _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "ttl", offsetof(struct ares_addrttl, ttl),
           sizeof(((struct ares_addrttl *)0)->ttl),
           _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "next", offsetof(struct ares_caa_reply, next),
            sizeof(((struct ares_caa_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 270) },
  { "critical", offsetof(struct ares_caa_reply, critical),
                sizeof(((struct ares_caa_reply *)0)->critical),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "property", offsetof(struct ares_caa_reply, property),
                sizeof(((struct ares_caa_reply *)0)->property),
                _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "plength", offsetof(struct ares_caa_reply, plength),
               sizeof(((struct ares_caa_reply *)0)->plength),
               _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "value", offsetof(struct ares_caa_reply, value),
             sizeof(((struct ares_caa_reply *)0)->value),
             _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "length", offsetof(struct ares_caa_reply, length),
              sizeof(((struct ares_caa_reply *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "_S6_un", offsetof(struct ares_in6_addr, _S6_un),
              sizeof(((struct ares_in6_addr *)0)->_S6_un),
              _CFFI_OP(_CFFI_OP_NOOP, 305) },
  { "next", offsetof(struct ares_mx_reply, next),
            sizeof(((struct ares_mx_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 275) },
  { "host", offsetof(struct ares_mx_reply, host),
            sizeof(((struct ares_mx_reply *)0)->host),
            _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "priority", offsetof(struct ares_mx_reply, priority),
                sizeof(((struct ares_mx_reply *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "next", offsetof(struct ares_naptr_reply, next),
            sizeof(((struct ares_naptr_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 277) },
  { "flags", offsetof(struct ares_naptr_reply, flags),
             sizeof(((struct ares_naptr_reply *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "service", offsetof(struct ares_naptr_reply, service),
               sizeof(((struct ares_naptr_reply *)0)->service),
               _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "regexp", offsetof(struct ares_naptr_reply, regexp),
              sizeof(((struct ares_naptr_reply *)0)->regexp),
              _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "replacement", offsetof(struct ares_naptr_reply, replacement),
                   sizeof(((struct ares_naptr_reply *)0)->replacement),
                   _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "order", offsetof(struct ares_naptr_reply, order),
             sizeof(((struct ares_naptr_reply *)0)->order),
             _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "preference", offsetof(struct ares_naptr_reply, preference),
                  sizeof(((struct ares_naptr_reply *)0)->preference),
                  _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "flags", offsetof(struct ares_options, flags),
             sizeof(((struct ares_options *)0)->flags),
             _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "timeout", offsetof(struct ares_options, timeout),
               sizeof(((struct ares_options *)0)->timeout),
               _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "tries", offsetof(struct ares_options, tries),
             sizeof(((struct ares_options *)0)->tries),
             _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ndots", offsetof(struct ares_options, ndots),
             sizeof(((struct ares_options *)0)->ndots),
             _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "udp_port", offsetof(struct ares_options, udp_port),
                sizeof(((struct ares_options *)0)->udp_port),
                _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "tcp_port", offsetof(struct ares_options, tcp_port),
                sizeof(((struct ares_options *)0)->tcp_port),
                _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "socket_send_buffer_size", offsetof(struct ares_options, socket_send_buffer_size),
                               sizeof(((struct ares_options *)0)->socket_send_buffer_size),
                               _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "socket_receive_buffer_size", offsetof(struct ares_options, socket_receive_buffer_size),
                                  sizeof(((struct ares_options *)0)->socket_receive_buffer_size),
                                  _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "servers", offsetof(struct ares_options, servers),
               sizeof(((struct ares_options *)0)->servers),
               _CFFI_OP(_CFFI_OP_NOOP, 290) },
  { "nservers", offsetof(struct ares_options, nservers),
                sizeof(((struct ares_options *)0)->nservers),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "domains", offsetof(struct ares_options, domains),
               sizeof(((struct ares_options *)0)->domains),
               _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "ndomains", offsetof(struct ares_options, ndomains),
                sizeof(((struct ares_options *)0)->ndomains),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "lookups", offsetof(struct ares_options, lookups),
               sizeof(((struct ares_options *)0)->lookups),
               _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "sock_state_cb", offsetof(struct ares_options, sock_state_cb),
                     sizeof(((struct ares_options *)0)->sock_state_cb),
                     _CFFI_OP(_CFFI_OP_NOOP, 310) },
  { "sock_state_cb_data", offsetof(struct ares_options, sock_state_cb_data),
                          sizeof(((struct ares_options *)0)->sock_state_cb_data),
                          _CFFI_OP(_CFFI_OP_NOOP, 30) },
  { "sortlist", offsetof(struct ares_options, sortlist),
                sizeof(((struct ares_options *)0)->sortlist),
                _CFFI_OP(_CFFI_OP_NOOP, 260) },
  { "nsort", offsetof(struct ares_options, nsort),
             sizeof(((struct ares_options *)0)->nsort),
             _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "ednspsz", offsetof(struct ares_options, ednspsz),
               sizeof(((struct ares_options *)0)->ednspsz),
               _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "resolvconf_path", offsetof(struct ares_options, resolvconf_path),
                       sizeof(((struct ares_options *)0)->resolvconf_path),
                       _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "hosts_path", offsetof(struct ares_options, hosts_path),
                  sizeof(((struct ares_options *)0)->hosts_path),
                  _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "udp_max_queries", offsetof(struct ares_options, udp_max_queries),
                       sizeof(((struct ares_options *)0)->udp_max_queries),
                       _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "maxtimeout", offsetof(struct ares_options, maxtimeout),
                  sizeof(((struct ares_options *)0)->maxtimeout),
                  _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "qcache_max_ttl", offsetof(struct ares_options, qcache_max_ttl),
                      sizeof(((struct ares_options *)0)->qcache_max_ttl),
                      _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "evsys", offsetof(struct ares_options, evsys),
             sizeof(((struct ares_options *)0)->evsys),
             _CFFI_OP(_CFFI_OP_NOOP, 256) },
  { "server_failover_opts", offsetof(struct ares_options, server_failover_opts),
                            sizeof(((struct ares_options *)0)->server_failover_opts),
                            _CFFI_OP(_CFFI_OP_NOOP, 280) },
  { "retry_chance", offsetof(struct ares_server_failover_options, retry_chance),
                    sizeof(((struct ares_server_failover_options *)0)->retry_chance),
                    _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "retry_delay", offsetof(struct ares_server_failover_options, retry_delay),
                   sizeof(((struct ares_server_failover_options *)0)->retry_delay),
                   _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "nsname", offsetof(struct ares_soa_reply, nsname),
              sizeof(((struct ares_soa_reply *)0)->nsname),
              _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "hostmaster", offsetof(struct ares_soa_reply, hostmaster),
                  sizeof(((struct ares_soa_reply *)0)->hostmaster),
                  _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "serial", offsetof(struct ares_soa_reply, serial),
              sizeof(((struct ares_soa_reply *)0)->serial),
              _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "refresh", offsetof(struct ares_soa_reply, refresh),
               sizeof(((struct ares_soa_reply *)0)->refresh),
               _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "retry", offsetof(struct ares_soa_reply, retry),
             sizeof(((struct ares_soa_reply *)0)->retry),
             _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "expire", offsetof(struct ares_soa_reply, expire),
              sizeof(((struct ares_soa_reply *)0)->expire),
              _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "minttl", offsetof(struct ares_soa_reply, minttl),
              sizeof(((struct ares_soa_reply *)0)->minttl),
              _CFFI_OP(_CFFI_OP_NOOP, 200) },
  { "next", offsetof(struct ares_srv_reply, next),
            sizeof(((struct ares_srv_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 282) },
  { "host", offsetof(struct ares_srv_reply, host),
            sizeof(((struct ares_srv_reply *)0)->host),
            _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "priority", offsetof(struct ares_srv_reply, priority),
                sizeof(((struct ares_srv_reply *)0)->priority),
                _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "weight", offsetof(struct ares_srv_reply, weight),
              sizeof(((struct ares_srv_reply *)0)->weight),
              _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "port", offsetof(struct ares_srv_reply, port),
            sizeof(((struct ares_srv_reply *)0)->port),
            _CFFI_OP(_CFFI_OP_NOOP, 15) },
  { "next", offsetof(struct ares_txt_ext, next),
            sizeof(((struct ares_txt_ext *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 284) },
  { "txt", offsetof(struct ares_txt_ext, txt),
           sizeof(((struct ares_txt_ext *)0)->txt),
           _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "length", offsetof(struct ares_txt_ext, length),
              sizeof(((struct ares_txt_ext *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "record_start", offsetof(struct ares_txt_ext, record_start),
                    sizeof(((struct ares_txt_ext *)0)->record_start),
                    _CFFI_OP(_CFFI_OP_NOOP, 307) },
  { "next", offsetof(struct ares_txt_reply, next),
            sizeof(((struct ares_txt_reply *)0)->next),
            _CFFI_OP(_CFFI_OP_NOOP, 286) },
  { "txt", offsetof(struct ares_txt_reply, txt),
           sizeof(((struct ares_txt_reply *)0)->txt),
           _CFFI_OP(_CFFI_OP_NOOP, 306) },
  { "length", offsetof(struct ares_txt_reply, length),
              sizeof(((struct ares_txt_reply *)0)->length),
              _CFFI_OP(_CFFI_OP_NOOP, 11) },
  { "h_name", offsetof(struct hostent, h_name),
              sizeof(((struct hostent *)0)->h_name),
              _CFFI_OP(_CFFI_OP_NOOP, 64) },
  { "h_aliases", offsetof(struct hostent, h_aliases),
                 sizeof(((struct hostent *)0)->h_aliases),
                 _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "h_addrtype", offsetof(struct hostent, h_addrtype),
                  sizeof(((struct hostent *)0)->h_addrtype),
                  _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "h_length", offsetof(struct hostent, h_length),
                sizeof(((struct hostent *)0)->h_length),
                _CFFI_OP(_CFFI_OP_NOOP, 43) },
  { "h_addr_list", offsetof(struct hostent, h_addr_list),
                   sizeof(((struct hostent *)0)->h_addr_list),
                   _CFFI_OP(_CFFI_OP_NOOP, 257) },
  { "s6_addr", offsetof(struct in6_addr, s6_addr),
               sizeof(((struct in6_addr *)0)->s6_addr),
               _CFFI_OP(_CFFI_OP_NOOP, 303) },
  { "s_addr", offsetof(struct in_addr, s_addr),
              sizeof(((struct in_addr *)0)->s_addr),
              _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "sa_family", offsetof(struct sockaddr, sa_family),
                 sizeof(((struct sockaddr *)0)->sa_family),
                 _CFFI_OP(_CFFI_OP_NOOP, 259) },
  { "sin_family", offsetof(struct sockaddr_in, sin_family),
                  sizeof(((struct sockaddr_in *)0)->sin_family),
                  _CFFI_OP(_CFFI_OP_NOOP, 259) },
  { "sin_port", offsetof(struct sockaddr_in, sin_port),
                sizeof(((struct sockaddr_in *)0)->sin_port),
                _CFFI_OP(_CFFI_OP_NOOP, 300) },
  { "sin_addr", offsetof(struct sockaddr_in, sin_addr),
                sizeof(((struct sockaddr_in *)0)->sin_addr),
                _CFFI_OP(_CFFI_OP_NOOP, 292) },
  { "sin6_family", offsetof(struct sockaddr_in6, sin6_family),
                   sizeof(((struct sockaddr_in6 *)0)->sin6_family),
                   _CFFI_OP(_CFFI_OP_NOOP, 259) },
  { "sin6_port", offsetof(struct sockaddr_in6, sin6_port),
                 sizeof(((struct sockaddr_in6 *)0)->sin6_port),
                 _CFFI_OP(_CFFI_OP_NOOP, 300) },
  { "sin6_flowinfo", offsetof(struct sockaddr_in6, sin6_flowinfo),
                     sizeof(((struct sockaddr_in6 *)0)->sin6_flowinfo),
                     _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "sin6_addr", offsetof(struct sockaddr_in6, sin6_addr),
                 sizeof(((struct sockaddr_in6 *)0)->sin6_addr),
                 _CFFI_OP(_CFFI_OP_NOOP, 289) },
  { "sin6_scope_id", offsetof(struct sockaddr_in6, sin6_scope_id),
                     sizeof(((struct sockaddr_in6 *)0)->sin6_scope_id),
                     _CFFI_OP(_CFFI_OP_NOOP, 301) },
  { "tv_sec", offsetof(struct timeval, tv_sec),
              sizeof(((struct timeval *)0)->tv_sec),
              _CFFI_OP(_CFFI_OP_NOOP, 299) },
  { "tv_usec", offsetof(struct timeval, tv_usec),
               sizeof(((struct timeval *)0)->tv_usec),
               _CFFI_OP(_CFFI_OP_NOOP, 298) },
  { "_S6_u8", (size_t)-1,
              (size_t)-1,
              _CFFI_OP(_CFFI_OP_NOOP, 308) },
};

static const struct _cffi_struct_union_s _cffi_struct_unions[] = {
  { "$1", 305, _CFFI_F_UNION|_CFFI_F_CHECK_FIELDS,
    (size_t)-2, -2, 103, 1 /* unnamed */ },
  { "apattern", 261, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_addr6ttl", 262, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addr6ttl), offsetof(struct _cffi_align_struct_ares_addr6ttl, y), 0, 2 },
  { "ares_addrinfo", 263, 0,
    sizeof(struct ares_addrinfo), offsetof(struct _cffi_align_struct_ares_addrinfo, y), 2, 2 },
  { "ares_addrinfo_cname", 265, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_cname), offsetof(struct _cffi_align_struct_ares_addrinfo_cname, y), 4, 4 },
  { "ares_addrinfo_hints", 266, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_hints), offsetof(struct _cffi_align_struct_ares_addrinfo_hints, y), 8, 4 },
  { "ares_addrinfo_node", 268, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrinfo_node), offsetof(struct _cffi_align_struct_ares_addrinfo_node, y), 12, 8 },
  { "ares_addrttl", 269, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_addrttl), offsetof(struct _cffi_align_struct_ares_addrttl, y), 20, 2 },
  { "ares_caa_reply", 271, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_caa_reply), offsetof(struct _cffi_align_struct_ares_caa_reply, y), 22, 6 },
  { "ares_channeldata", 272, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_dns_record", 254, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_dns_rr", 255, _CFFI_F_OPAQUE,
    (size_t)-1, -1, -1, 0 /* opaque */ },
  { "ares_in6_addr", 274, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_in6_addr), offsetof(struct _cffi_align_struct_ares_in6_addr, y), 28, 1 },
  { "ares_mx_reply", 276, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_mx_reply), offsetof(struct _cffi_align_struct_ares_mx_reply, y), 29, 3 },
  { "ares_naptr_reply", 278, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_naptr_reply), offsetof(struct _cffi_align_struct_ares_naptr_reply, y), 32, 7 },
  { "ares_options", 279, 0,
    sizeof(struct ares_options), offsetof(struct _cffi_align_struct_ares_options, y), 39, 25 },
  { "ares_server_failover_options", 280, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_server_failover_options), offsetof(struct _cffi_align_struct_ares_server_failover_options, y), 64, 2 },
  { "ares_soa_reply", 281, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_soa_reply), offsetof(struct _cffi_align_struct_ares_soa_reply, y), 66, 7 },
  { "ares_srv_reply", 283, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_srv_reply), offsetof(struct _cffi_align_struct_ares_srv_reply, y), 73, 5 },
  { "ares_txt_ext", 285, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_txt_ext), offsetof(struct _cffi_align_struct_ares_txt_ext, y), 78, 4 },
  { "ares_txt_reply", 287, _CFFI_F_CHECK_FIELDS,
    sizeof(struct ares_txt_reply), offsetof(struct _cffi_align_struct_ares_txt_reply, y), 82, 3 },
  { "hostent", 288, _CFFI_F_CHECK_FIELDS,
    sizeof(struct hostent), offsetof(struct _cffi_align_struct_hostent, y), 85, 5 },
  { "in6_addr", 289, 0,
    sizeof(struct in6_addr), offsetof(struct _cffi_align_struct_in6_addr, y), 90, 1 },
  { "in_addr", 292, _CFFI_F_CHECK_FIELDS,
    sizeof(struct in_addr), offsetof(struct _cffi_align_struct_in_addr, y), 91, 1 },
  { "sockaddr", 294, 0,
    sizeof(struct sockaddr), offsetof(struct _cffi_align_struct_sockaddr, y), 92, 1 },
  { "sockaddr_in", 296, 0,
    sizeof(struct sockaddr_in), offsetof(struct _cffi_align_struct_sockaddr_in, y), 93, 3 },
  { "sockaddr_in6", 295, 0,
    sizeof(struct sockaddr_in6), offsetof(struct _cffi_align_struct_sockaddr_in6, y), 96, 5 },
  { "timeval", 297, _CFFI_F_CHECK_FIELDS,
    sizeof(struct timeval), offsetof(struct _cffi_align_struct_timeval, y), 101, 2 },
};

static const struct _cffi_enum_s _cffi_enums[] = {
  { "$ares_bool_t", 252, _cffi_prim_int(sizeof(ares_bool_t), ((ares_bool_t)-1) <= 0),
    "ARES_FALSE,ARES_TRUE" },
  { "$ares_dns_class_t", 24, _cffi_prim_int(sizeof(ares_dns_class_t), ((ares_dns_class_t)-1) <= 0),
    "ARES_CLASS_IN,ARES_CLASS_CHAOS,ARES_CLASS_HESOID,ARES_CLASS_NONE,ARES_CLASS_ANY" },
  { "$ares_dns_flags_t", 253, _cffi_prim_int(sizeof(ares_dns_flags_t), ((ares_dns_flags_t)-1) <= 0),
    "ARES_FLAG_QR,ARES_FLAG_AA,ARES_FLAG_TC,ARES_FLAG_RD,ARES_FLAG_RA,ARES_FLAG_AD,ARES_FLAG_CD" },
  { "$ares_dns_opcode_t", 17, _cffi_prim_int(sizeof(ares_dns_opcode_t), ((ares_dns_opcode_t)-1) <= 0),
    "ARES_OPCODE_QUERY,ARES_OPCODE_IQUERY,ARES_OPCODE_STATUS,ARES_OPCODE_NOTIFY,ARES_OPCODE_UPDATE" },
  { "$ares_dns_rcode_t", 18, _cffi_prim_int(sizeof(ares_dns_rcode_t), ((ares_dns_rcode_t)-1) <= 0),
    "ARES_RCODE_NOERROR,ARES_RCODE_FORMERR,ARES_RCODE_SERVFAIL,ARES_RCODE_NXDOMAIN,ARES_RCODE_NOTIMP,ARES_RCODE_REFUSED,ARES_RCODE_YXDOMAIN,ARES_RCODE_YXRRSET,ARES_RCODE_NXRRSET,ARES_RCODE_NOTAUTH,ARES_RCODE_NOTZONE,ARES_RCODE_DSOTYPEI,ARES_RCODE_BADSIG,ARES_RCODE_BADKEY,ARES_RCODE_BADTIME,ARES_RCODE_BADMODE,ARES_RCODE_BADNAME,ARES_RCODE_BADALG,ARES_RCODE_BADTRUNC,ARES_RCODE_BADCOOKIE" },
  { "$ares_dns_rec_type_t", 23, _cffi_prim_int(sizeof(ares_dns_rec_type_t), ((ares_dns_rec_type_t)-1) <= 0),
    "ARES_REC_TYPE_A,ARES_REC_TYPE_NS,ARES_REC_TYPE_CNAME,ARES_REC_TYPE_SOA,ARES_REC_TYPE_PTR,ARES_REC_TYPE_MX,ARES_REC_TYPE_TXT,ARES_REC_TYPE_AAAA,ARES_REC_TYPE_SRV,ARES_REC_TYPE_NAPTR,ARES_REC_TYPE_TLSA,ARES_REC_TYPE_HTTPS,ARES_REC_TYPE_CAA,ARES_REC_TYPE_URI,ARES_REC_TYPE_ANY" },
  { "$ares_dns_rr_key_t", 53, _cffi_prim_int(sizeof(ares_dns_rr_key_t), ((ares_dns_rr_key_t)-1) <= 0),
    "ARES_RR_A_ADDR,ARES_RR_AAAA_ADDR,ARES_RR_NS_NSDNAME,ARES_RR_CNAME_CNAME,ARES_RR_SOA_MNAME,ARES_RR_SOA_RNAME,ARES_RR_SOA_SERIAL,ARES_RR_SOA_REFRESH,ARES_RR_SOA_RETRY,ARES_RR_SOA_EXPIRE,ARES_RR_SOA_MINIMUM,ARES_RR_PTR_DNAME,ARES_RR_MX_PREFERENCE,ARES_RR_MX_EXCHANGE,ARES_RR_TXT_DATA,ARES_RR_SRV_PRIORITY,ARES_RR_SRV_WEIGHT,ARES_RR_SRV_PORT,ARES_RR_SRV_TARGET,ARES_RR_NAPTR_ORDER,ARES_RR_NAPTR_PREFERENCE,ARES_RR_NAPTR_FLAGS,ARES_RR_NAPTR_SERVICES,ARES_RR_NAPTR_REGEXP,ARES_RR_NAPTR_REPLACEMENT,ARES_RR_CAA_CRITICAL,ARES_RR_CAA_TAG,ARES_RR_CAA_VALUE,ARES_RR_TLSA_CERT_USAGE,ARES_RR_TLSA_SELECTOR,ARES_RR_TLSA_MATCH,ARES_RR_TLSA_DATA,ARES_RR_HTTPS_PRIORITY,ARES_RR_HTTPS_TARGET,ARES_RR_HTTPS_PARAMS,ARES_RR_URI_PRIORITY,ARES_RR_URI_WEIGHT,ARES_RR_URI_TARGET" },
  { "$ares_dns_section_t", 10, _cffi_prim_int(sizeof(ares_dns_section_t), ((ares_dns_section_t)-1) <= 0),
    "ARES_SECTION_ANSWER,ARES_SECTION_AUTHORITY,ARES_SECTION_ADDITIONAL" },
  { "$ares_evsys_t", 256, _cffi_prim_int(sizeof(ares_evsys_t), ((ares_evsys_t)-1) <= 0),
    "ARES_EVSYS_DEFAULT,ARES_EVSYS_WIN32,ARES_EVSYS_EPOLL,ARES_EVSYS_KQUEUE,ARES_EVSYS_POLL,ARES_EVSYS_SELECT" },
  { "$ares_status_t", 227, _cffi_prim_int(sizeof(ares_status_t), ((ares_status_t)-1) <= 0),
    "ARES_SUCCESS,ARES_ENODATA,ARES_EFORMERR,ARES_ESERVFAIL,ARES_ENOTFOUND,ARES_ENOTIMP,ARES_EREFUSED,ARES_EBADQUERY,ARES_EBADNAME,ARES_EBADFAMILY,ARES_EBADRESP,ARES_ECONNREFUSED,ARES_ETIMEOUT,ARES_EOF,ARES_EFILE,ARES_ENOMEM,ARES_EDESTRUCTION,ARES_EBADSTR,ARES_EBADFLAGS,ARES_ENONAME,ARES_EBADHINTS,ARES_ENOTINITIALIZED,ARES_ELOADIPHLPAPI,ARES_EADDRGETNETWORKPARAMS,ARES_ECANCELLED,ARES_ESERVICE,ARES_ENOSERVER" },
};

static const struct _cffi_typename_s _cffi_typenames[] = {
  { "ares_addrinfo_callback", 178 },
  { "ares_bool_t", 252 },
  { "ares_callback_dnsrec", 29 },
  { "ares_channel", 27 },
  { "ares_dns_class_t", 24 },
  { "ares_dns_flags_t", 253 },
  { "ares_dns_opcode_t", 17 },
  { "ares_dns_rcode_t", 18 },
  { "ares_dns_rec_type_t", 23 },
  { "ares_dns_record_t", 254 },
  { "ares_dns_rr_key_t", 53 },
  { "ares_dns_rr_t", 255 },
  { "ares_dns_section_t", 10 },
  { "ares_evsys_t", 256 },
  { "ares_host_callback", 207 },
  { "ares_nameinfo_callback", 191 },
  { "ares_sock_create_callback", 183 },
  { "ares_sock_state_cb", 310 },
  { "ares_socket_t", 68 },
  { "ares_socklen_t", 65 },
  { "ares_status_t", 227 },
  { "h_addrtype_t", 43 },
  { "h_length_t", 43 },
  { "in_port_t", 300 },
  { "sa_family_t", 259 },
  { "suseconds_t", 298 },
  { "time_t", 299 },
};

static const struct _cffi_type_context_s _cffi_type_context = {
  _cffi_types,
  _cffi_globals,
  _cffi_fields,
  _cffi_struct_unions,
  _cffi_enums,
  _cffi_typenames,
  244,  /* num_globals */
  28,  /* num_struct_unions */
  10,  /* num_enums */
  27,  /* num_typenames */
  NULL,  /* no includes */
  312,  /* num_types */
  1,  /* flags */
};

#ifdef __GNUC__
#  pragma GCC visibility push(default)  /* for -fvisibility= */
#endif

#ifdef PYPY_VERSION
PyMODINIT_FUNC
_cffi_pypyinit__cares(const void *p[])
{
    if (((intptr_t)p[0]) >= 0x0A03) {
        _cffi_call_python_org = (void(*)(struct _cffi_externpy_s *, char *))p[1];
    }
    p[0] = (const void *)0x2601;
    p[1] = &_cffi_type_context;
#if PY_MAJOR_VERSION >= 3
    return NULL;
#endif
}
#  ifdef _MSC_VER
     PyMODINIT_FUNC
#  if PY_MAJOR_VERSION >= 3
     PyInit__cares(void) { return NULL; }
#  else
     init_cares(void) { }
#  endif
#  endif
#elif PY_MAJOR_VERSION >= 3
PyMODINIT_FUNC
PyInit__cares(void)
{
  return _cffi_init("_cares", 0x2601, &_cffi_type_context);
}
#else
PyMODINIT_FUNC
init_cares(void)
{
  _cffi_init("_cares", 0x2601, &_cffi_type_context);
}
#endif

#ifdef __GNUC__
#  pragma GCC visibility pop
#endif
