// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A1__F54

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": true})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 2, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = true },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 2, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx)xyzw" };
#else
{ R"xyzw(amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_64_F_T_3_0)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1100)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0x09f02f3au, 0x9d44bc39u, 334, 83 }, // 09f02f3a9d44bc39 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0xb3705dcbu, 0x5afc7bdau, 334, 33 }, // b3705dcb5afc7bda = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0xf46c9507u, 0x002d8942u, 334, 50 }, // f46c9507002d8942 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1100
    { 0x7b4274c8u, 0x1cfa49fbu, 471, 83 }, // 7b4274c81cfa49fb = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0x7c440fb8u, 0x50880783u, 471, 16 }, // 7c440fb850880783 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0x51645c92u, 0xc063b360u, 471, 50 }, // 51645c92c063b360 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_16_16_True__CO__wave4_warp2_stg1--Arch_gfx1100
    { 0x7971b863u, 0xd41bba89u, 219, 83 }, // 7971b863d41bba89 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0xf520c583u, 0x978736f9u, 219, 202 }, // f520c583978736f9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0x792a13cau, 0xc3261e8fu, 219, 16 }, // 792a13cac3261e8f = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0x47b36054u, 0x6402bb6cu, 219, 116 }, // 47b360546402bb6c = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave2_warp4_stg1--Arch_gfx1100
    { 0x3b9ff556u, 0xe40dbfa0u, 219, 33 }, // 3b9ff556e40dbfa0 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0xab908b0au, 0x3171ad4bu, 219, 167 }, // ab908b0a3171ad4b = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0xb76d0435u, 0x9a967ea9u, 219, 133 }, // b76d04359a967ea9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_False__CO__wave4_warp4_stg1--Arch_gfx1100
    { 0xf4a5c816u, 0x16d5cbcfu, 411, 83 }, // f4a5c81616d5cbcf = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp2_stg1--Arch_gfx1100
    { 0x1e52ec6au, 0xbecd9467u, 411, 202 }, // 1e52ec6abecd9467 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0x2fc1e573u, 0xf58c3369u, 411, 16 }, // 2fc1e573f58c3369 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp2_stg1--Arch_gfx1100
    { 0xebf3bd13u, 0x8841db46u, 411, 116 }, // ebf3bd138841db46 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave2_warp4_stg1--Arch_gfx1100
    { 0xc9b80cc1u, 0x548f808au, 411, 33 }, // c9b80cc1548f808a = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave3_warp2_stg1--Arch_gfx1100
    { 0x0508494eu, 0xe7fad1c4u, 411, 167 }, // 0508494ee7fad1c4 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0x001628e8u, 0x6869b7a1u, 411, 133 }, // 001628e86869b7a1 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_16_True__CO__wave4_warp4_stg1--Arch_gfx1100
    { 0xd77e42a8u, 0xc2ec1879u, 426, 202 }, // d77e42a8c2ec1879 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0x03be0d13u, 0xc815ef98u, 426, 167 }, // 03be0d13c815ef98 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_32_32_True__CO__wave3_warp4_stg1--Arch_gfx1100
    { 0xa512062du, 0x46f21ac9u, 235, 202 }, // a512062d46f21ac9 = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1100
    { 0xc5ffdbd6u, 0x846904fau, 235, 116 }, // c5ffdbd6846904fa = b2sum -l 64 <<< amd-gfx11xx/flash/attn_fwd/FONLY__＊fp16@16_64_F_T_3_0___gfx11xx__P__2_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1100
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1100_mod0
{{ 0, 3, 5, 2, 4, 0, 1, 1, 3, 1},
 {12,18,16,11, 7,18,16,16,19,18},
 {12, 9,14,19,18,16,19, 7,12, 9},
 { 7,11,13,17,17,15,13,17,17,17},
 {11, 9,15,17,13,17,15,17,13,13},
 {10,20,22,22,22,13,17,17,13,21},
 { 8,22,22,22,22,22,22,22,22,22},
 {10,22,22,22,22,22,22,22,22,22},
 { 6,22,22,22,22,22,22,22,23,23},
 { 6,22,23,22,22,22,22,22,23,22}}
// End of GPU gfx1100_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A1__F54 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 5;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 5;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = 0
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_bz = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 64
// Head_dim = 64
// PADDED_HEAD = False
// ENABLE_DROPOUT = True
// dropout_p = "fp32"
// philox_seed_ptr = "*u64"
// philox_offset1 = "*u64"
// philox_offset2 = "u64"
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 3
// Window_left = "i32"
// BIAS_TYPE = 0
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = "*i32"
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1100_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 64 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = True AND inputs$CAUSAL_TYPE = 3 AND inputs$BIAS_TYPE = 0

// vim: set fileencoding=utf-8

