// Copyright © 2023-2025 Advanced Micro Devices, Inc.
// SPDX-License-Identifier: MIT

#include "../shim.attn_fwd.h"
#include <aotriton/_internal/triton_kernel.h>
#include <aotriton/_internal/kernel_cluster.h>
#include <aotriton/cpp_tune.h>
#include <string_view>
#ifndef NDEBUG
#include <iostream>
#endif

#define CURRENT_ENTRY_PUBLIC Autotune_attn_fwd__A10__F41

#define ARRAY_SIZE(array)  (sizeof(array) / sizeof(array[0]))

namespace { // Anonymous namespace

using namespace std::literals::string_view_literals;

#if AOTRITON_BUILD_FOR_TUNING
// PSels and Copts in JSON String
static const char* kernel_psels[] = {
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 16, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 16, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 32, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw",
  R"xyzw({"PERSISTENT_TYPE": 0, "GRID_CU_MULTIP": 2, "BLOCK_M": 64, "BLOCK_N": 32, "PRE_LOAD_V": false})xyzw"
};
static const char* kernel_copts[] = {
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 1, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 2, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 3, "num_warps": 4, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 2, "num_stages": 1})xyzw",
  R"xyzw({"waves_per_eu": 4, "num_warps": 4, "num_stages": 1})xyzw"
};
#endif

struct PerfFields {
  int16_t BLOCK_M;
    int16_t BLOCK_N;
    int8_t  PERSISTENT_TYPE;
    int8_t  GRID_CU_MULTIP;
    bool    PRE_LOAD_V;
};

static PerfFields image_perf_list [] = {
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 16, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 16, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 32, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false },
    { .BLOCK_M = 64, .BLOCK_N = 32, .PERSISTENT_TYPE = 0, .GRID_CU_MULTIP = 2, .PRE_LOAD_V = false }
};

// u8R generates char8_t which is poorly supported almost everywhere.
constexpr pstring_view PACKAGE_PATH
#if defined(_WIN32)
{ LR"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x)xyzw" };
#else
{ R"xyzw(amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x)xyzw" };
#endif
constexpr std::string_view FUNC_NAME { R"xyzw(＊fp16@16_48_T_F_0_1)xyzw" };
constexpr std::string_view ARCH_NAME { R"xyzw(gfx1200)xyzw" };

// Checksum can be confirmed with `echo -n '<string>' | b2sum -l 64`
// For example:
//   $ echo -n 'amd-gfx110x/flash/attn_fwd/FONLY__^bf16@16,128,False,False,0,0___gfx1100__P__32_32_0_2_False__CO__wave3_warp2_stg1-Gpu-gfx1100' | b2sum -l 64
//   c4b51ee645d79580  -
static AOTRITON_NS::TritonKernelCompactMeta meta_list[] = {
    { 0xaac3cfbcu, 0xa6bbe906u, 302, 83 }, // aac3cfbca6bbe906 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x73b02942u, 0x1d4783a1u, 302, 50 }, // 73b029421d4783a1 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_16_16_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x6d18b98cu, 0x729a5727u, 0, 83 }, // 6d18b98c729a5727 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0x6d4ea169u, 0x83b166e3u, 0, 16 }, // 6d4ea16983b166e3 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xa6bae7cfu, 0x3fab0eb4u, 0, 167 }, // a6bae7cf3fab0eb4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_16_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x4d1c9da4u, 0x5fb12a28u, 318, 83 }, // 4d1c9da45fb12a28 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp2_stg1--Arch_gfx1200
    { 0xe3ce0e74u, 0x178256b4u, 318, 202 }, // e3ce0e74178256b4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x0554aac9u, 0x2c14f86cu, 318, 16 }, // 0554aac92c14f86c = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave2_warp2_stg1--Arch_gfx1200
    { 0xe170caeau, 0xdea43cadu, 318, 116 }, // e170caeadea43cad = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x71c98735u, 0x96593be4u, 318, 33 }, // 71c9873596593be4 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave3_warp2_stg1--Arch_gfx1200
    { 0x581cff31u, 0x948e4defu, 318, 167 }, // 581cff31948e4def = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x05b41d46u, 0x6afc58bdu, 318, 50 }, // 05b41d466afc58bd = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0x772db457u, 0x83e69daeu, 318, 133 }, // 772db45783e69dae = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_32_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
    { 0xad22666cu, 0x41148951u, 67, 202 }, // ad22666c41148951 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave1_warp4_stg1--Arch_gfx1200
    { 0x1704060du, 0xa5e0c6feu, 67, 116 }, // 1704060da5e0c6fe = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave2_warp4_stg1--Arch_gfx1200
    { 0x5498c473u, 0xc1d1f8dau, 67, 167 }, // 5498c473c1d1f8da = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave3_warp4_stg1--Arch_gfx1200
    { 0x51516abau, 0xd3116a51u, 67, 50 }, // 51516abad3116a51 = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave4_warp2_stg1--Arch_gfx1200
    { 0xc7c68564u, 0xca9c319du, 67, 133 }, // c7c68564ca9c319d = b2sum -l 64 <<< amd-gfx120x/flash/attn_fwd/FONLY__＊fp16@16_48_T_F_0_1___gfx120x__P__0_2_64_32_False__CO__wave4_warp4_stg1--Arch_gfx1200
};

static constexpr int kTotalNumKernels = ARRAY_SIZE(meta_list);

using AOTRITON_NS::v3::flash::autotune::attn_fwd_packed_string;

static AOTRITON_NS::TritonKernelCluster<kTotalNumKernels>
kernel_cluster(meta_list,
               attn_fwd_packed_string);

static int8_t lut[1][10][10] =
{
// GPU gfx1200_mod0
{{ 4, 6, 6,12, 8,12,12,12,12,10},
 { 8,17,13,10, 8, 6,12, 9,11,11},
 { 8, 8,12, 9, 9,11,10, 6,11, 7},
 {13, 3, 3,17,17,17,17,12,17,15},
 {17,17,17,13,17,17,17, 9,15, 7},
 {13,11,11,17,17,15, 5, 5,17,14},
 { 2,17, 9,17,17,17, 7,16,11, 5},
 { 8,17, 4, 8,13, 5, 5, 9, 5, 5},
 { 5,17,11, 9, 5, 5,11,10,16,16},
 {14, 5, 9, 5, 5, 0, 7, 1,16,16}}
// End of GPU gfx1200_mod0
}
;

}; // End of anonymous namespace

namespace AOTRITON_NS::v3::flash::autotune {

// using AOTRITON_NS::v2::flash::AttnFwdContext;

void CURRENT_ENTRY_PUBLIC(AttnFwdContext& context, int mod_number) {
#if AOTRITON_BUILD_FOR_TUNING
    int preferred_index = context._has_preferred_kernel;
    context._total_number_of_kernels = kTotalNumKernels;
#ifndef NDEBUG
    std::cerr << "Autotune_attn_fwd__A10__F41 "
              << "kTotalNumKernels = " << kTotalNumKernels << " "
              << "_has_preferred_kernel = " << preferred_index << " "
              << std::endl;
#endif
    if (preferred_index != -1) {
        if (preferred_index >= kTotalNumKernels)
            return ;
        context.kernel_on_device = kernel_cluster.get(preferred_index);
        context.pp_args_index = 7;
        context.package_path = PACKAGE_PATH;
        context.func_name = FUNC_NAME;
        context.arch_name = ARCH_NAME;
        context._preferred_kernel_psels = kernel_psels[preferred_index];
        context._preferred_kernel_copts = kernel_copts[preferred_index];
        const auto& perf = image_perf_list[preferred_index];
        context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
        return ;
    }
#endif
    auto kernel_index = attn_fwd__lut_lambda__0(*context.params, mod_number, lut);
    if (kernel_index < 0) {
      return ;
    }
    context.kernel_on_device = kernel_cluster.get(kernel_index);
    context.pp_args_index = 7;
    context.package_path = PACKAGE_PATH;
    context.func_name = FUNC_NAME;
    context.arch_name = ARCH_NAME;
#ifndef NDEBUG
    std::cerr << __FILE__ << " kernel_index = " << int(kernel_index) << std::endl;
#endif
    const auto& perf = image_perf_list[kernel_index];
    context.PERSISTENT_TYPE = perf.PERSISTENT_TYPE;
    context.GRID_CU_MULTIP = perf.GRID_CU_MULTIP;
    context.BLOCK_M = perf.BLOCK_M;
    context.BLOCK_N = perf.BLOCK_N;
    context.PRE_LOAD_V = perf.PRE_LOAD_V;
}

#undef CURRENT_ENTRY_PUBLIC
}

// Human-readable Signature 
// Q = "*fp16:16"
// B = "*fp16:16"
// A = 0
// Sm_scale = "fp32"
// L = "*fp32:16"
// Q_descale = 0
// stride_az = 0
// Num_head_q = "i32"
// cu_seqlens_q = "*i32:16"
// BLOCK_DMODEL = 48
// Head_dim = "i32"
// PADDED_HEAD = True
// ENABLE_DROPOUT = False
// dropout_p = 0
// philox_seed_ptr = 0
// philox_offset1 = 0
// philox_offset2 = 0
// RETURN_ENCODED_SOFTMAX = False
// encoded_softmax = 0
// CAUSAL_TYPE = 0
// Window_left = 0
// BIAS_TYPE = 1
// USE_ALIBI = False
// INT8 = False
// persistent_atomic_counter = 0
// Num_CU = "i32"

// SELECT * FROM FLASH$attn_fwd WHERE gpu IN ('gfx1201_mod0') AND inputs$Q_dtype = 'torch.float16' AND inputs$BLOCK_DMODEL = 48 AND inputs$PADDED_HEAD = False AND inputs$ENABLE_DROPOUT = False AND inputs$CAUSAL_TYPE = 0 AND inputs$BIAS_TYPE = 1

// vim: set fileencoding=utf-8

