#include <Pythia8/Basics.h>
#include <Pythia8/BeamSetup.h>
#include <Pythia8/Event.h>
#include <Pythia8/HadronWidths.h>
#include <Pythia8/Info.h>
#include <Pythia8/LHEF3.h>
#include <Pythia8/Logger.h>
#include <Pythia8/ParticleData.h>
#include <Pythia8/PartonSystems.h>
#include <Pythia8/Settings.h>
#include <Pythia8/SigmaLowEnergy.h>
#include <Pythia8/SigmaTotal.h>
#include <Pythia8/StandardModel.h>
#include <Pythia8/SusyCouplings.h>
#include <Pythia8/VinciaCommon.h>
#include <Pythia8/Weights.h>
#include <functional>
#include <istream>
#include <iterator>
#include <map>
#include <memory>
#include <ostream>
#include <sstream>
#include <sstream> // __str__
#include <string>
#include <utility>
#include <vector>

#include <pybind11/pybind11.h>
#include <functional>
#include <string>
#include <Pythia8/UserHooks.h>
#include <Pythia8/SplittingsOnia.h>
#include <Pythia8/HeavyIons.h>
#include <Pythia8/BeamShape.h>
#include <pybind11/stl.h>
#include <pybind11/complex.h>
#include <pybind11/functional.h>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>);
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*);
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>);
#endif

void bind_Pythia8_VinciaCommon(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // Pythia8::VinciaClustering file:Pythia8/VinciaCommon.h line:278
		pybind11::class_<Pythia8::VinciaClustering, std::shared_ptr<Pythia8::VinciaClustering>> cl(M("Pythia8"), "VinciaClustering", "");
		pybind11::handle cl_type = cl;

		cl.def( pybind11::init( [](){ return new Pythia8::VinciaClustering(); } ) );
		cl.def( pybind11::init( [](Pythia8::VinciaClustering const &o){ return new Pythia8::VinciaClustering(o); } ) );
		cl.def_readwrite("dau1", &Pythia8::VinciaClustering::dau1);
		cl.def_readwrite("dau2", &Pythia8::VinciaClustering::dau2);
		cl.def_readwrite("dau3", &Pythia8::VinciaClustering::dau3);
		cl.def_readwrite("isFSR", &Pythia8::VinciaClustering::isFSR);
		cl.def_readwrite("antFunType", &Pythia8::VinciaClustering::antFunType);
		cl.def_readwrite("idMot1", &Pythia8::VinciaClustering::idMot1);
		cl.def_readwrite("idMot2", &Pythia8::VinciaClustering::idMot2);
		cl.def_readwrite("helDau", &Pythia8::VinciaClustering::helDau);
		cl.def_readwrite("helMot", &Pythia8::VinciaClustering::helMot);
		cl.def_readwrite("mDau", &Pythia8::VinciaClustering::mDau);
		cl.def_readwrite("mMot", &Pythia8::VinciaClustering::mMot);
		cl.def_readwrite("saj", &Pythia8::VinciaClustering::saj);
		cl.def_readwrite("sjb", &Pythia8::VinciaClustering::sjb);
		cl.def_readwrite("sab", &Pythia8::VinciaClustering::sab);
		cl.def_readwrite("invariants", &Pythia8::VinciaClustering::invariants);
		cl.def_readwrite("q2res", &Pythia8::VinciaClustering::q2res);
		cl.def_readwrite("q2evol", &Pythia8::VinciaClustering::q2evol);
		cl.def_readwrite("kMapType", &Pythia8::VinciaClustering::kMapType);
		cl.def("setDaughters", (void (Pythia8::VinciaClustering::*)(const class Pythia8::Event &, int, int, int)) &Pythia8::VinciaClustering::setDaughters, "C++: Pythia8::VinciaClustering::setDaughters(const class Pythia8::Event &, int, int, int) --> void", pybind11::arg("state"), pybind11::arg("dau1In"), pybind11::arg("dau2In"), pybind11::arg("dau3In"));
		cl.def("setDaughters", (void (Pythia8::VinciaClustering::*)(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, int, int, int)) &Pythia8::VinciaClustering::setDaughters, "C++: Pythia8::VinciaClustering::setDaughters(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, int, int, int) --> void", pybind11::arg("state"), pybind11::arg("dau1In"), pybind11::arg("dau2In"), pybind11::arg("dau3In"));
		cl.def("setMothers", (void (Pythia8::VinciaClustering::*)(int, int)) &Pythia8::VinciaClustering::setMothers, "C++: Pythia8::VinciaClustering::setMothers(int, int) --> void", pybind11::arg("idMot1In"), pybind11::arg("idMot2In"));
		cl.def("setAntenna", (void (Pythia8::VinciaClustering::*)(bool, enum Pythia8::AntFunType)) &Pythia8::VinciaClustering::setAntenna, "C++: Pythia8::VinciaClustering::setAntenna(bool, enum Pythia8::AntFunType) --> void", pybind11::arg("isFSRin"), pybind11::arg("antFunTypeIn"));
		cl.def("init", (bool (Pythia8::VinciaClustering::*)()) &Pythia8::VinciaClustering::init, "C++: Pythia8::VinciaClustering::init() --> bool");
		cl.def("setInvariantsAndMasses", (void (Pythia8::VinciaClustering::*)(const class Pythia8::Event &)) &Pythia8::VinciaClustering::setInvariantsAndMasses, "C++: Pythia8::VinciaClustering::setInvariantsAndMasses(const class Pythia8::Event &) --> void", pybind11::arg("state"));
		cl.def("setInvariantsAndMasses", (void (Pythia8::VinciaClustering::*)(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &)) &Pythia8::VinciaClustering::setInvariantsAndMasses, "C++: Pythia8::VinciaClustering::setInvariantsAndMasses(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &) --> void", pybind11::arg("state"));
		cl.def("swap13", (void (Pythia8::VinciaClustering::*)()) &Pythia8::VinciaClustering::swap13, "C++: Pythia8::VinciaClustering::swap13() --> void");
		cl.def("isFF", (bool (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::isFF, "C++: Pythia8::VinciaClustering::isFF() const --> bool");
		cl.def("isRF", (bool (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::isRF, "C++: Pythia8::VinciaClustering::isRF() const --> bool");
		cl.def("isII", (bool (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::isII, "C++: Pythia8::VinciaClustering::isII() const --> bool");
		cl.def("isIF", (bool (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::isIF, "C++: Pythia8::VinciaClustering::isIF() const --> bool");
		cl.def("getAntName", (std::string (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::getAntName, "C++: Pythia8::VinciaClustering::getAntName() const --> std::string");
		cl.def("is2to3", (bool (Pythia8::VinciaClustering::*)() const) &Pythia8::VinciaClustering::is2to3, "C++: Pythia8::VinciaClustering::is2to3() const --> bool");
	}
	{ // Pythia8::Resolution file:Pythia8/VinciaCommon.h line:382
		pybind11::class_<Pythia8::Resolution, std::shared_ptr<Pythia8::Resolution>> cl(M("Pythia8"), "Resolution", "");
		pybind11::handle cl_type = cl;

		cl.def( pybind11::init( [](){ return new Pythia8::Resolution(); } ) );
		cl.def("initPtr", (void (Pythia8::Resolution::*)(class Pythia8::Settings *, class Pythia8::Info *, class Pythia8::VinciaCommon *)) &Pythia8::Resolution::initPtr, "C++: Pythia8::Resolution::initPtr(class Pythia8::Settings *, class Pythia8::Info *, class Pythia8::VinciaCommon *) --> void", pybind11::arg("settingsPtrIn"), pybind11::arg("infoPtrIn"), pybind11::arg("vinComPtrIn"));
		cl.def("init", (bool (Pythia8::Resolution::*)()) &Pythia8::Resolution::init, "C++: Pythia8::Resolution::init() --> bool");
		cl.def("q2evol", (double (Pythia8::Resolution::*)(struct Pythia8::VinciaClustering &)) &Pythia8::Resolution::q2evol, "C++: Pythia8::Resolution::q2evol(struct Pythia8::VinciaClustering &) --> double", pybind11::arg("clus"));
		cl.def("xTevol", (double (Pythia8::Resolution::*)(struct Pythia8::VinciaClustering &)) &Pythia8::Resolution::xTevol, "C++: Pythia8::Resolution::xTevol(struct Pythia8::VinciaClustering &) --> double", pybind11::arg("clus"));
		cl.def("q2sector", (double (Pythia8::Resolution::*)(struct Pythia8::VinciaClustering &)) &Pythia8::Resolution::q2sector, "C++: Pythia8::Resolution::q2sector(struct Pythia8::VinciaClustering &) --> double", pybind11::arg("clus"));
		cl.def("findSector", (struct Pythia8::VinciaClustering (Pythia8::Resolution::*)(class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::map<int, int, struct std::less<int>, class std::allocator<struct std::pair<const int, int> > >)) &Pythia8::Resolution::findSector, "C++: Pythia8::Resolution::findSector(class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::map<int, int, struct std::less<int>, class std::allocator<struct std::pair<const int, int> > >) --> struct Pythia8::VinciaClustering", pybind11::arg("state"), pybind11::arg("flavsBorn"));
		cl.def("findSector", [](Pythia8::Resolution &o, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > & a0) -> Pythia8::VinciaClustering { return o.findSector(a0); }, "", pybind11::arg("state"));
		cl.def("findSector", [](Pythia8::Resolution &o, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > & a0, int const & a1) -> Pythia8::VinciaClustering { return o.findSector(a0, a1); }, "", pybind11::arg("state"), pybind11::arg("nqpMin"));
		cl.def("findSector", (struct Pythia8::VinciaClustering (Pythia8::Resolution::*)(class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, int, int)) &Pythia8::Resolution::findSector, "C++: Pythia8::Resolution::findSector(class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, int, int) --> struct Pythia8::VinciaClustering", pybind11::arg("state"), pybind11::arg("nqpMin"), pybind11::arg("ngMin"));
		cl.def("sectorVeto", (bool (Pythia8::Resolution::*)(double, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::map<int, int, struct std::less<int>, class std::allocator<struct std::pair<const int, int> > >)) &Pythia8::Resolution::sectorVeto, "C++: Pythia8::Resolution::sectorVeto(double, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::map<int, int, struct std::less<int>, class std::allocator<struct std::pair<const int, int> > >) --> bool", pybind11::arg("q2In"), pybind11::arg("state"), pybind11::arg("nFlavsBorn"));
		cl.def("sectorVeto", (bool (Pythia8::Resolution::*)(const struct Pythia8::VinciaClustering &, const struct Pythia8::VinciaClustering &)) &Pythia8::Resolution::sectorVeto, "C++: Pythia8::Resolution::sectorVeto(const struct Pythia8::VinciaClustering &, const struct Pythia8::VinciaClustering &) --> bool", pybind11::arg("clusMin"), pybind11::arg("clus"));
		cl.def("setVerbose", (void (Pythia8::Resolution::*)(int)) &Pythia8::Resolution::setVerbose, "C++: Pythia8::Resolution::setVerbose(int) --> void", pybind11::arg("verboseIn"));
	}
	{ // Pythia8::VinciaCommon file:Pythia8/VinciaCommon.h line:494
		pybind11::class_<Pythia8::VinciaCommon, std::shared_ptr<Pythia8::VinciaCommon>> cl(M("Pythia8"), "VinciaCommon", "");
		pybind11::handle cl_type = cl;

		cl.def( pybind11::init( [](){ return new Pythia8::VinciaCommon(); } ) );
		cl.def_readwrite("alphaStrong", &Pythia8::VinciaCommon::alphaStrong);
		cl.def_readwrite("alphaStrongCMW", &Pythia8::VinciaCommon::alphaStrongCMW);
		cl.def_readwrite("alphaStrongDef", &Pythia8::VinciaCommon::alphaStrongDef);
		cl.def_readwrite("alphaStrongDefCMW", &Pythia8::VinciaCommon::alphaStrongDefCMW);
		cl.def_readwrite("alphaS", &Pythia8::VinciaCommon::alphaS);
		cl.def_readwrite("alphaEM", &Pythia8::VinciaCommon::alphaEM);
		cl.def_readwrite("mu2freeze", &Pythia8::VinciaCommon::mu2freeze);
		cl.def_readwrite("mu2min", &Pythia8::VinciaCommon::mu2min);
		cl.def_readwrite("alphaSmax", &Pythia8::VinciaCommon::alphaSmax);
		cl.def_readwrite("ms", &Pythia8::VinciaCommon::ms);
		cl.def_readwrite("mc", &Pythia8::VinciaCommon::mc);
		cl.def_readwrite("mb", &Pythia8::VinciaCommon::mb);
		cl.def_readwrite("mt", &Pythia8::VinciaCommon::mt);
		cl.def_readwrite("nFlavZeroMass", &Pythia8::VinciaCommon::nFlavZeroMass);
		cl.def_readwrite("epTolErr", &Pythia8::VinciaCommon::epTolErr);
		cl.def_readwrite("epTolWarn", &Pythia8::VinciaCommon::epTolWarn);
		cl.def_readwrite("mTolErr", &Pythia8::VinciaCommon::mTolErr);
		cl.def_readwrite("mTolWarn", &Pythia8::VinciaCommon::mTolWarn);
		cl.def("initPtr", (bool (Pythia8::VinciaCommon::*)(class Pythia8::Info *)) &Pythia8::VinciaCommon::initPtr, "C++: Pythia8::VinciaCommon::initPtr(class Pythia8::Info *) --> bool", pybind11::arg("infoPtrIn"));
		cl.def("init", (bool (Pythia8::VinciaCommon::*)()) &Pythia8::VinciaCommon::init, "C++: Pythia8::VinciaCommon::init() --> bool");
		cl.def("mHadMin", (double (Pythia8::VinciaCommon::*)(const int, const int)) &Pythia8::VinciaCommon::mHadMin, "C++: Pythia8::VinciaCommon::mHadMin(const int, const int) --> double", pybind11::arg("id1"), pybind11::arg("id2"));
		cl.def("showerChecks", (bool (Pythia8::VinciaCommon::*)(class Pythia8::Event &, bool)) &Pythia8::VinciaCommon::showerChecks, "C++: Pythia8::VinciaCommon::showerChecks(class Pythia8::Event &, bool) --> bool", pybind11::arg("event"), pybind11::arg("ISR"));
		cl.def("resetCounters", (void (Pythia8::VinciaCommon::*)()) &Pythia8::VinciaCommon::resetCounters, "C++: Pythia8::VinciaCommon::resetCounters() --> void");
		cl.def("getNf", (int (Pythia8::VinciaCommon::*)(double)) &Pythia8::VinciaCommon::getNf, "C++: Pythia8::VinciaCommon::getNf(double) --> int", pybind11::arg("q"));
		cl.def("getShowerStartingScale", (double (Pythia8::VinciaCommon::*)(int, const class Pythia8::Event &, double)) &Pythia8::VinciaCommon::getShowerStartingScale, "C++: Pythia8::VinciaCommon::getShowerStartingScale(int, const class Pythia8::Event &, double) --> double", pybind11::arg("iSys"), pybind11::arg("event"), pybind11::arg("sbbSav"));
		cl.def("isValidClustering", (bool (Pythia8::VinciaCommon::*)(const struct Pythia8::VinciaClustering &, const class Pythia8::Event &, int)) &Pythia8::VinciaCommon::isValidClustering, "C++: Pythia8::VinciaCommon::isValidClustering(const struct Pythia8::VinciaClustering &, const class Pythia8::Event &, int) --> bool", pybind11::arg("clus"), pybind11::arg("event"), pybind11::arg("verboseIn"));
		cl.def("clus3to2", (bool (Pythia8::VinciaCommon::*)(const struct Pythia8::VinciaClustering &, const class Pythia8::Event &, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &)) &Pythia8::VinciaCommon::clus3to2, "C++: Pythia8::VinciaCommon::clus3to2(const struct Pythia8::VinciaClustering &, const class Pythia8::Event &, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &) --> bool", pybind11::arg("clus"), pybind11::arg("event"), pybind11::arg("pClustered"));
		cl.def("clus3to2", (bool (Pythia8::VinciaCommon::*)(const struct Pythia8::VinciaClustering &, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &)) &Pythia8::VinciaCommon::clus3to2, "C++: Pythia8::VinciaCommon::clus3to2(const struct Pythia8::VinciaClustering &, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &) --> bool", pybind11::arg("clus"), pybind11::arg("state"), pybind11::arg("pClustered"));
		cl.def("getMomenta3to2", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, const struct Pythia8::VinciaClustering & a2) -> bool { return o.getMomenta3to2(a0, a1, a2); }, "", pybind11::arg("momNow"), pybind11::arg("momClus"), pybind11::arg("clus"));
		cl.def("getMomenta3to2", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const struct Pythia8::VinciaClustering &, int)) &Pythia8::VinciaCommon::getMomenta3to2, "C++: Pythia8::VinciaCommon::getMomenta3to2(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const struct Pythia8::VinciaClustering &, int) --> bool", pybind11::arg("momNow"), pybind11::arg("momClus"), pybind11::arg("clus"), pybind11::arg("iOffset"));
		cl.def("map3to2FF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2) -> bool { return o.map3to2FF(a0, a1, a2); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"));
		cl.def("map3to2FF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3) -> bool { return o.map3to2FF(a0, a1, a2, a3); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"), pybind11::arg("a"));
		cl.def("map3to2FF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4) -> bool { return o.map3to2FF(a0, a1, a2, a3, a4); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"), pybind11::arg("a"), pybind11::arg("r"));
		cl.def("map3to2FF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4, int const & a5) -> bool { return o.map3to2FF(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"));
		cl.def("map3to2FF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4, int const & a5, double const & a6) -> bool { return o.map3to2FF(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mI"));
		cl.def("map3to2FF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> >, int, int, int, int, double, double)) &Pythia8::VinciaCommon::map3to2FF, "C++: Pythia8::VinciaCommon::map3to2FF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> >, int, int, int, int, double, double) --> bool", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("kMapType"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mI"), pybind11::arg("mK"));
		cl.def("map3to2RF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1) -> bool { return o.map3to2RF(a0, a1); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"));
		cl.def("map3to2RF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2) -> bool { return o.map3to2RF(a0, a1, a2); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"));
		cl.def("map3to2RF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3) -> bool { return o.map3to2RF(a0, a1, a2, a3); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"));
		cl.def("map3to2RF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4) -> bool { return o.map3to2RF(a0, a1, a2, a3, a4); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"));
		cl.def("map3to2RF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, int, int, double)) &Pythia8::VinciaCommon::map3to2RF, "C++: Pythia8::VinciaCommon::map3to2RF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, int, int, double) --> bool", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mK"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1) -> bool { return o.map3to2IF(a0, a1); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2) -> bool { return o.map3to2IF(a0, a1, a2); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3) -> bool { return o.map3to2IF(a0, a1, a2, a3); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4) -> bool { return o.map3to2IF(a0, a1, a2, a3, a4); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4, double const & a5) -> bool { return o.map3to2IF(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mj"));
		cl.def("map3to2IF", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, int const & a2, int const & a3, int const & a4, double const & a5, double const & a6) -> bool { return o.map3to2IF(a0, a1, a2, a3, a4, a5, a6); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mj"), pybind11::arg("mk"));
		cl.def("map3to2IF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, int, int, double, double, double)) &Pythia8::VinciaCommon::map3to2IF, "C++: Pythia8::VinciaCommon::map3to2IF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, int, int, double, double, double) --> bool", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mj"), pybind11::arg("mk"), pybind11::arg("mK"));
		cl.def("map3to2II", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, bool const & a2) -> bool { return o.map3to2II(a0, a1, a2); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("doBoost"));
		cl.def("map3to2II", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, bool const & a2, int const & a3) -> bool { return o.map3to2II(a0, a1, a2, a3); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("doBoost"), pybind11::arg("a"));
		cl.def("map3to2II", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, bool const & a2, int const & a3, int const & a4) -> bool { return o.map3to2II(a0, a1, a2, a3, a4); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("doBoost"), pybind11::arg("a"), pybind11::arg("r"));
		cl.def("map3to2II", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, bool const & a2, int const & a3, int const & a4, int const & a5) -> bool { return o.map3to2II(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("doBoost"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"));
		cl.def("map3to2II", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, bool, int, int, int, double)) &Pythia8::VinciaCommon::map3to2II, "C++: Pythia8::VinciaCommon::map3to2II(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, bool, int, int, int, double) --> bool", pybind11::arg("pClu"), pybind11::arg("pIn"), pybind11::arg("doBoost"), pybind11::arg("a"), pybind11::arg("r"), pybind11::arg("b"), pybind11::arg("mj"));
		cl.def("map2to3FF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, const class std::vector<double, class std::allocator<double> > &, double, class std::vector<double, class std::allocator<double> >)) &Pythia8::VinciaCommon::map2to3FF, "C++: Pythia8::VinciaCommon::map2to3FF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, int, const class std::vector<double, class std::allocator<double> > &, double, class std::vector<double, class std::allocator<double> >) --> bool", pybind11::arg("pNew"), pybind11::arg("pOld"), pybind11::arg("kMapType"), pybind11::arg("invariants"), pybind11::arg("phi"), pybind11::arg("masses"));
		cl.def("map2to3II", [](Pythia8::VinciaCommon &o, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a0, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a1, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > & a2, double const & a3, double const & a4, double const & a5, double const & a6, double const & a7) -> bool { return o.map2to3II(a0, a1, a2, a3, a4, a5, a6, a7); }, "", pybind11::arg("pNew"), pybind11::arg("pRec"), pybind11::arg("pOld"), pybind11::arg("sAB"), pybind11::arg("saj"), pybind11::arg("sjb"), pybind11::arg("sab"), pybind11::arg("phi"));
		cl.def("map2to3II", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, double, double, double, double, double, double)) &Pythia8::VinciaCommon::map2to3II, "C++: Pythia8::VinciaCommon::map2to3II(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, double, double, double, double, double, double) --> bool", pybind11::arg("pNew"), pybind11::arg("pRec"), pybind11::arg("pOld"), pybind11::arg("sAB"), pybind11::arg("saj"), pybind11::arg("sjb"), pybind11::arg("sab"), pybind11::arg("phi"), pybind11::arg("m2j"));
		cl.def("map2to3IFlocal", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, double, double, double, double, double, double, double, double)) &Pythia8::VinciaCommon::map2to3IFlocal, "C++: Pythia8::VinciaCommon::map2to3IFlocal(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, double, double, double, double, double, double, double, double) --> bool", pybind11::arg("pNew"), pybind11::arg("pOld"), pybind11::arg("sOldAK"), pybind11::arg("saj"), pybind11::arg("sjk"), pybind11::arg("sak"), pybind11::arg("phi"), pybind11::arg("m2oldK"), pybind11::arg("m2j"), pybind11::arg("m2k"));
		cl.def("map2to3IFglobal", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class Pythia8::Vec4 &, double, double, double, double, double, double, double, double)) &Pythia8::VinciaCommon::map2to3IFglobal, "C++: Pythia8::VinciaCommon::map2to3IFglobal(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class Pythia8::Vec4 &, double, double, double, double, double, double, double, double) --> bool", pybind11::arg("pNew"), pybind11::arg("pRec"), pybind11::arg("pOld"), pybind11::arg("pB"), pybind11::arg("sAK"), pybind11::arg("saj"), pybind11::arg("sjk"), pybind11::arg("sak"), pybind11::arg("phi"), pybind11::arg("mK2"), pybind11::arg("mj2"), pybind11::arg("mk2"));
		cl.def("map2toNRF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> >, unsigned int, unsigned int, const class std::vector<double, class std::allocator<double> >, double, const class std::vector<double, class std::allocator<double> >)) &Pythia8::VinciaCommon::map2toNRF, "C++: Pythia8::VinciaCommon::map2toNRF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> >, unsigned int, unsigned int, const class std::vector<double, class std::allocator<double> >, double, const class std::vector<double, class std::allocator<double> >) --> bool", pybind11::arg("pAfter"), pybind11::arg("pBefore"), pybind11::arg("posR"), pybind11::arg("posF"), pybind11::arg("invariants"), pybind11::arg("phi"), pybind11::arg("masses"));
		cl.def("map1to2RF", (bool (Pythia8::VinciaCommon::*)(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class Pythia8::Vec4, double, double, double, double)) &Pythia8::VinciaCommon::map1to2RF, "C++: Pythia8::VinciaCommon::map1to2RF(class std::vector<class Pythia8::Vec4, class std::allocator<class Pythia8::Vec4> > &, const class Pythia8::Vec4, double, double, double, double) --> bool", pybind11::arg("pNew"), pybind11::arg("pRes"), pybind11::arg("m1"), pybind11::arg("m2"), pybind11::arg("theta"), pybind11::arg("phi"));
		cl.def("onShellCM", [](Pythia8::VinciaCommon &o, class Pythia8::Vec4 & a0, class Pythia8::Vec4 & a1, double const & a2, double const & a3) -> bool { return o.onShellCM(a0, a1, a2, a3); }, "", pybind11::arg("p1"), pybind11::arg("p2"), pybind11::arg("m1"), pybind11::arg("m2"));
		cl.def("onShellCM", (bool (Pythia8::VinciaCommon::*)(class Pythia8::Vec4 &, class Pythia8::Vec4 &, double, double, double)) &Pythia8::VinciaCommon::onShellCM, "C++: Pythia8::VinciaCommon::onShellCM(class Pythia8::Vec4 &, class Pythia8::Vec4 &, double, double, double) --> bool", pybind11::arg("p1"), pybind11::arg("p2"), pybind11::arg("m1"), pybind11::arg("m2"), pybind11::arg("tol"));
		cl.def("mapToMassless", (bool (Pythia8::VinciaCommon::*)(int, class Pythia8::Event &, bool)) &Pythia8::VinciaCommon::mapToMassless, "C++: Pythia8::VinciaCommon::mapToMassless(int, class Pythia8::Event &, bool) --> bool", pybind11::arg("iSys"), pybind11::arg("event"), pybind11::arg("makeNewCopies"));
		cl.def("mapToMassive", (bool (Pythia8::VinciaCommon::*)(class Pythia8::Vec4 &, class Pythia8::Vec4 &, double, double)) &Pythia8::VinciaCommon::mapToMassive, "C++: Pythia8::VinciaCommon::mapToMassive(class Pythia8::Vec4 &, class Pythia8::Vec4 &, double, double) --> bool", pybind11::arg("p1"), pybind11::arg("p2"), pybind11::arg("m1"), pybind11::arg("m2"));
		cl.def("makeParticleList", [](Pythia8::VinciaCommon &o, const int & a0, const class Pythia8::Event & a1) -> std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > { return o.makeParticleList(a0, a1); }, "", pybind11::arg("iSys"), pybind11::arg("event"));
		cl.def("makeParticleList", [](Pythia8::VinciaCommon &o, const int & a0, const class Pythia8::Event & a1, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > & a2) -> std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > { return o.makeParticleList(a0, a1, a2); }, "", pybind11::arg("iSys"), pybind11::arg("event"), pybind11::arg("pNew"));
		cl.def("makeParticleList", (class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > (Pythia8::VinciaCommon::*)(const int, const class Pythia8::Event &, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, const class std::vector<int, class std::allocator<int> > &)) &Pythia8::VinciaCommon::makeParticleList, "C++: Pythia8::VinciaCommon::makeParticleList(const int, const class Pythia8::Event &, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, const class std::vector<int, class std::allocator<int> > &) --> class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> >", pybind11::arg("iSys"), pybind11::arg("event"), pybind11::arg("pNew"), pybind11::arg("iOld"));
		cl.def("colourConnected", (bool (Pythia8::VinciaCommon::*)(const class Pythia8::Particle &, const class Pythia8::Particle &)) &Pythia8::VinciaCommon::colourConnected, "C++: Pythia8::VinciaCommon::colourConnected(const class Pythia8::Particle &, const class Pythia8::Particle &) --> bool", pybind11::arg("ptcl1"), pybind11::arg("ptcl2"));
		cl.def("list", [](Pythia8::VinciaCommon &o, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > & a0) -> void { return o.list(a0); }, "", pybind11::arg("state"));
		cl.def("list", [](Pythia8::VinciaCommon &o, const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > & a0, class std::basic_string<char> const & a1) -> void { return o.list(a0, a1); }, "", pybind11::arg("state"), pybind11::arg("title"));
		cl.def("list", (void (Pythia8::VinciaCommon::*)(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, std::string, bool)) &Pythia8::VinciaCommon::list, "C++: Pythia8::VinciaCommon::list(const class std::vector<class Pythia8::Particle, class std::allocator<class Pythia8::Particle> > &, std::string, bool) --> void", pybind11::arg("state"), pybind11::arg("title"), pybind11::arg("footer"));
		cl.def("getVerbose", (int (Pythia8::VinciaCommon::*)()) &Pythia8::VinciaCommon::getVerbose, "C++: Pythia8::VinciaCommon::getVerbose() --> int");
		cl.def("setVerbose", (void (Pythia8::VinciaCommon::*)(int)) &Pythia8::VinciaCommon::setVerbose, "C++: Pythia8::VinciaCommon::setVerbose(int) --> void", pybind11::arg("verboseIn"));
	}
}
