/**
 * @file coeftab_c.h
 *
 * Precision dependent coeficient array header.
 *
 * @copyright 2012-2024 Bordeaux INP, CNRS (LaBRI UMR 5800), Inria,
 *                      Univ. Bordeaux. All rights reserved.
 *
 * @version 6.4.0
 * @author David Goudin
 * @author Pascal Henon
 * @author Francois Pellegrini
 * @author Pierre Ramet
 * @author Mathieu Faverge
 * @author Xavier Lacoste
 * @author Esragul Korkmaz
 * @author Gregoire Pichon
 * @date 2024-07-05
 *
 * @generated from /build/pastix/src/pastix-6.4.0/sopalin/coeftab_z.h, normal z -> c, Sun Feb 15 18:01:29 2026
 *
 * @addtogroup coeftab
 * @{
 *
 **/
#ifndef _coeftab_c_h_
#define _coeftab_c_h_

/**
 *    @name PastixComplex32 compression/uncompression routines
 *    @{
 */
pastix_int_t coeftab_ccompress  ( SolverMatrix *solvmtx );
void         coeftab_cuncompress( SolverMatrix *solvmtx );
void         coeftab_cmemory    ( const SolverMatrix *solvmtx,
                                  const pastix_int_t *iparm,
                                  pastix_fixdbl_t    *dparm );

/**
 *    @}
 *    @name PastixComplex32 Extraction routines
 *    @{
 */
void coeftab_cgetschur( const SolverMatrix *solvmtx,
                        pastix_complex32_t *S, pastix_int_t lds );

void coeftab_cgetdiag( const SolverMatrix *solvmtx,
                       pastix_complex32_t *D, pastix_int_t incD );

/**
 *    @}
 *    @name PastixComplex32 debug routines
 *    @{
 */
void coeftab_cdump( pastix_data_t      *pastix_data,
                    const SolverMatrix *solvmtx,
                    const char         *filename );
void cpucblk_cdumpfile( pastix_coefside_t side,
                        SolverCblk       *cblk,
                        pastix_int_t      itercblk,
                        const char       *directory );
int  coeftab_cdiff( pastix_coefside_t   side,
                    const SolverMatrix *solvA,
                    SolverMatrix       *solvB );

/**
 *    @}
 */
#endif /* _coeftab_c_h_ */

/**
 * @}
 */
