// python wrapper for vtkPVXYChartView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkStdString.h"
#include "vtkPVXYChartView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVXYChartView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVXYChartView_ClassNew(); }

#ifndef DECLARED_PyvtkPVContextView_ClassNew
extern "C" { PyObject *PyvtkPVContextView_ClassNew(); }
#define DECLARED_PyvtkPVContextView_ClassNew
#endif

static PyObject *
PyvtkPVXYChartView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVXYChartView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVXYChartView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVXYChartView *tempr = vtkPVXYChartView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVXYChartView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVXYChartView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVXYChartView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVXYChartView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetChartType(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetChartType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToLine(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToLine");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToLine();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToLine();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToPoint(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToPoint");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToPoint();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToPoint();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToBar(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToBar");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToBar();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToBar();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToBag(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToBag");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToBag();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToBag();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToBox(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToBox");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToBox();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToBox();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToArea(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToArea");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToArea();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToArea();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToFunctionalBag(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToFunctionalBag");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToFunctionalBag();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToFunctionalBag();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToImage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToImage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToImage();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToImage();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetChartTypeToParallelCoordinates(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetChartTypeToParallelCoordinates");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SetChartTypeToParallelCoordinates();
    }
    else
    {
      op->vtkPVXYChartView::SetChartTypeToParallelCoordinates();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  int temp1;
  bool temp2 = false;
  bool temp3 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTitleFont(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleFont(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetTitleFontFamily() :
      op->vtkPVXYChartView::GetTitleFontFamily());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontSize() :
      op->vtkPVXYChartView::GetTitleFontSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleFontBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontBold() :
      op->vtkPVXYChartView::GetTitleFontBold());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleFontItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleFontItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleFontItalic() :
      op->vtkPVXYChartView::GetTitleFontItalic());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double *tempr = (ap.IsBound() ?
      op->GetTitleColor() :
      op->vtkPVXYChartView::GetTitleColor());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTitleAlignment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTitleAlignment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTitleAlignment(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTitleAlignment(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetTitleAlignment(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTitleAlignment");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTitleAlignment() :
      op->vtkPVXYChartView::GetTitleAlignment());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendLocation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendLocation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetLegendPosition(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendPosition(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLegendSymbolWidth(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLegendSymbolWidth");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLegendSymbolWidth(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLegendSymbolWidth(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetGridVisibility(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetGridVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftGridVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomGridVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightGridVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopGridVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopGridVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopGridVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopGridVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetGridColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetGridColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLeftGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBottomGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetRightGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetRightGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopGridColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopGridColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTopGridColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTopGridColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelVisibility(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelVisibility(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelVisibility(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelVisibility");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelVisibility(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelVisibility(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFont(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelFont(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontFamily(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelFontFamily(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontFile(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelFontFile(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelFontSize(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelFontSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelBold(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelBold(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelItalic(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelItalic(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelNotation(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelNotation(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelNotation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelPrecision(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelPrecision(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelPrecision(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisRangeMinimum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisRangeMinimum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisRangeMinimum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisRangeMinimum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisRangeMinimum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisRangeMinimum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisRangeMinimum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisRangeMinimum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisRangeMinimum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisRangeMinimum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisRangeMinimum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisRangeMinimum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisRangeMinimum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisRangeMaximum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisRangeMaximum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisRangeMaximum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisRangeMaximum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisRangeMaximum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisRangeMaximum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisRangeMaximum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisRangeMaximum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisRangeMaximum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisRangeMaximum(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisRangeMaximum");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisRangeMaximum(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisRangeMaximum(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisUseCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisUseCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisUseCustomRange(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisUseCustomRange(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisUseCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisUseCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisUseCustomRange(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisUseCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisUseCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisUseCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisUseCustomRange(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisUseCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisUseCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisUseCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisUseCustomRange(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisUseCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisUseCustomRange(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisUseCustomRange");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisUseCustomRange(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisUseCustomRange(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLogScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLogScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLogScale(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLogScale(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLogScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLogScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLogScale(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLogScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLogScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLogScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLogScale(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLogScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLogScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLogScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLogScale(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLogScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLogScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLogScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLogScale(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLogScale(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitle(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitle(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitle(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitle(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitle(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitle(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleFont(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleFont");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  int temp2;
  bool temp3 = false;
  bool temp4 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleFont(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleFont(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleFontFamily(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleFontFamily(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleFontFamily(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleFontFamily");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleFontFamily(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleFontFamily(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleFontFile(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleFontFile(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleFontFile(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleFontFile");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleFontFile(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleFontFile(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleFontSize(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleFontSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleFontSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleFontSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleFontSize(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleFontSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleBold(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleBold(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleBold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleBold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleBold(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleBold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleItalic(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleItalic(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleItalic(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleItalic");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleItalic(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleItalic(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisTitleColor(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisTitleColor(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisTitleColor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisTitleColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisTitleColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisTitleColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisUseCustomLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisUseCustomLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  bool temp1 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisUseCustomLabels(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisUseCustomLabels(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisUseCustomLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisUseCustomLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisUseCustomLabels(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisUseCustomLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisUseCustomLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisUseCustomLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisUseCustomLabels(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisUseCustomLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisUseCustomLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisUseCustomLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisUseCustomLabels(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisUseCustomLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisUseCustomLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisUseCustomLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisUseCustomLabels(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisUseCustomLabels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabelsNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabelsNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabelsNumber(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabelsNumber(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabelsNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabelsNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabelsNumber(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabelsNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabelsNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabelsNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabelsNumber(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabelsNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabelsNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabelsNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabelsNumber(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabelsNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabelsNumber(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabelsNumber");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabelsNumber(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabelsNumber(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetAxisLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAxisLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  int temp1;
  std::string temp2;
  std::string temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetAxisLabels(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVXYChartView::SetAxisLabels(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetLeftAxisLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLeftAxisLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetLeftAxisLabels(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetLeftAxisLabels(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetBottomAxisLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetBottomAxisLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetBottomAxisLabels(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetBottomAxisLabels(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetRightAxisLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetRightAxisLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetRightAxisLabels(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetRightAxisLabels(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTopAxisLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTopAxisLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  std::string temp1;
  std::string temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetTopAxisLabels(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVXYChartView::SetTopAxisLabels(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTooltipLabelFormat(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTooltipLabelFormat");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  vtkStdString temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTooltipLabelFormat(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTooltipLabelFormat(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTooltipNotation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTooltipNotation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTooltipNotation(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTooltipNotation(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetTooltipPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTooltipPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTooltipPrecision(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetTooltipPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetHideTimeMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHideTimeMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHideTimeMarker(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetHideTimeMarker(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetHideTimeMarker(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetHideTimeMarker");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetHideTimeMarker() :
      op->vtkPVXYChartView::GetHideTimeMarker());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetSortByXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSortByXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetSortByXAxis() :
      op->vtkPVXYChartView::GetSortByXAxis());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetSortByXAxis(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSortByXAxis");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSortByXAxis(temp0);
    }
    else
    {
      op->vtkPVXYChartView::SetSortByXAxis(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetIgnoreNegativeLogAxisWarning(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod SetIgnoreNegativeLogAxisWarning."
    " (" "Use vtkPVGeneralSettings::SetIgnoreNegativeLogAxisWarning instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "SetIgnoreNegativeLogAxisWarning");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVXYChartView::SetIgnoreNegativeLogAxisWarning(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetIgnoreNegativeLogAxisWarning(PyObject * /*unused*/, PyObject *args)
{
  PyErr_WarnEx(PyExc_DeprecationWarning,
    "Call to deprecated staticmethod GetIgnoreNegativeLogAxisWarning."
    " (" "Use vtkPVGeneralSettings::GetIgnoreNegativeLogAxisWarning instead" ")"
    " -- Deprecated since version " "6.0.0" ".", 1);

  vtkPythonArgs ap(args, "GetIgnoreNegativeLogAxisWarning");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkPVXYChartView::GetIgnoreNegativeLogAxisWarning();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetChart(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetChart");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkChart *tempr = (ap.IsBound() ?
      op->GetChart() :
      op->vtkPVXYChartView::GetChart());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_GetContextItem(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetContextItem");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAbstractContextItem *tempr = (ap.IsBound() ?
      op->GetContextItem() :
      op->vtkPVXYChartView::GetContextItem());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_SetSelection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSelection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  vtkChartRepresentation *temp0 = nullptr;
  vtkSelection *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkChartRepresentation") &&
      ap.GetVTKObject(temp1, "vtkSelection"))
  {
    if (ap.IsBound())
    {
      op->SetSelection(temp0, temp1);
    }
    else
    {
      op->vtkPVXYChartView::SetSelection(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVXYChartView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVXYChartView *op = static_cast<vtkPVXYChartView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkPVXYChartView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVXYChartView_Methods[] = {
  {"IsTypeOf", PyvtkPVXYChartView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVXYChartView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVXYChartView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVXYChartView\nC++: static vtkPVXYChartView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVXYChartView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVXYChartView\nC++: vtkPVXYChartView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVXYChartView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVXYChartView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetChartType", PyvtkPVXYChartView_SetChartType, METH_VARARGS,
   "SetChartType(self, type:str) -> None\nC++: void SetChartType(const char *type)\n\nSet the chart type, defaults to line chart\n"},
  {"SetChartTypeToLine", PyvtkPVXYChartView_SetChartTypeToLine, METH_VARARGS,
   "SetChartTypeToLine(self) -> None\nC++: void SetChartTypeToLine()\n\n"},
  {"SetChartTypeToPoint", PyvtkPVXYChartView_SetChartTypeToPoint, METH_VARARGS,
   "SetChartTypeToPoint(self) -> None\nC++: void SetChartTypeToPoint()\n\n"},
  {"SetChartTypeToBar", PyvtkPVXYChartView_SetChartTypeToBar, METH_VARARGS,
   "SetChartTypeToBar(self) -> None\nC++: void SetChartTypeToBar()\n\n"},
  {"SetChartTypeToBag", PyvtkPVXYChartView_SetChartTypeToBag, METH_VARARGS,
   "SetChartTypeToBag(self) -> None\nC++: void SetChartTypeToBag()\n\n"},
  {"SetChartTypeToBox", PyvtkPVXYChartView_SetChartTypeToBox, METH_VARARGS,
   "SetChartTypeToBox(self) -> None\nC++: void SetChartTypeToBox()\n\n"},
  {"SetChartTypeToArea", PyvtkPVXYChartView_SetChartTypeToArea, METH_VARARGS,
   "SetChartTypeToArea(self) -> None\nC++: void SetChartTypeToArea()\n\n"},
  {"SetChartTypeToFunctionalBag", PyvtkPVXYChartView_SetChartTypeToFunctionalBag, METH_VARARGS,
   "SetChartTypeToFunctionalBag(self) -> None\nC++: void SetChartTypeToFunctionalBag()\n\n"},
  {"SetChartTypeToImage", PyvtkPVXYChartView_SetChartTypeToImage, METH_VARARGS,
   "SetChartTypeToImage(self) -> None\nC++: void SetChartTypeToImage()\n\n"},
  {"SetChartTypeToParallelCoordinates", PyvtkPVXYChartView_SetChartTypeToParallelCoordinates, METH_VARARGS,
   "SetChartTypeToParallelCoordinates(self) -> None\nC++: void SetChartTypeToParallelCoordinates()\n\n"},
  {"SetTitleFont", PyvtkPVXYChartView_SetTitleFont, METH_VARARGS,
   "SetTitleFont(self, family:str, pointSize:int, bold:bool,\n    italic:bool) -> None\nC++: void SetTitleFont(const char *family, int pointSize,\n    bool bold, bool italic) override;\n\nSet the font of the title. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetTitleFontFamily", PyvtkPVXYChartView_SetTitleFontFamily, METH_VARARGS,
   "SetTitleFontFamily(self, family:str) -> None\nC++: void SetTitleFontFamily(const char *family) override;\n\n"},
  {"SetTitleFontSize", PyvtkPVXYChartView_SetTitleFontSize, METH_VARARGS,
   "SetTitleFontSize(self, pointSize:int) -> None\nC++: void SetTitleFontSize(int pointSize) override;\n\n"},
  {"SetTitleBold", PyvtkPVXYChartView_SetTitleBold, METH_VARARGS,
   "SetTitleBold(self, bold:bool) -> None\nC++: void SetTitleBold(bool bold) override;\n\n"},
  {"SetTitleItalic", PyvtkPVXYChartView_SetTitleItalic, METH_VARARGS,
   "SetTitleItalic(self, italic:bool) -> None\nC++: void SetTitleItalic(bool italic) override;\n\n"},
  {"SetTitleFontFile", PyvtkPVXYChartView_SetTitleFontFile, METH_VARARGS,
   "SetTitleFontFile(self, file:str) -> None\nC++: void SetTitleFontFile(const char *file) override;\n\n"},
  {"GetTitleFontFamily", PyvtkPVXYChartView_GetTitleFontFamily, METH_VARARGS,
   "GetTitleFontFamily(self) -> str\nC++: const char *GetTitleFontFamily() override;\n\n"},
  {"GetTitleFontSize", PyvtkPVXYChartView_GetTitleFontSize, METH_VARARGS,
   "GetTitleFontSize(self) -> int\nC++: int GetTitleFontSize() override;\n\n"},
  {"GetTitleFontBold", PyvtkPVXYChartView_GetTitleFontBold, METH_VARARGS,
   "GetTitleFontBold(self) -> int\nC++: int GetTitleFontBold() override;\n\n"},
  {"GetTitleFontItalic", PyvtkPVXYChartView_GetTitleFontItalic, METH_VARARGS,
   "GetTitleFontItalic(self) -> int\nC++: int GetTitleFontItalic() override;\n\n"},
  {"SetTitleColor", PyvtkPVXYChartView_SetTitleColor, METH_VARARGS,
   "SetTitleColor(self, red:float, green:float, blue:float) -> None\nC++: void SetTitleColor(double red, double green, double blue)\n    override;\n\nSet the color of the title. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"GetTitleColor", PyvtkPVXYChartView_GetTitleColor, METH_VARARGS,
   "GetTitleColor(self) -> Pointer\nC++: double *GetTitleColor() override;\n\n"},
  {"SetTitleAlignment", PyvtkPVXYChartView_SetTitleAlignment, METH_VARARGS,
   "SetTitleAlignment(self, alignment:int) -> None\nC++: void SetTitleAlignment(int alignment) override;\n\nSet the alignement of the title. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"GetTitleAlignment", PyvtkPVXYChartView_GetTitleAlignment, METH_VARARGS,
   "GetTitleAlignment(self) -> int\nC++: int GetTitleAlignment() override;\n\n"},
  {"SetLegendVisibility", PyvtkPVXYChartView_SetLegendVisibility, METH_VARARGS,
   "SetLegendVisibility(self, visible:int) -> None\nC++: void SetLegendVisibility(int visible)\n\nSet the legend visibility. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLegendLocation", PyvtkPVXYChartView_SetLegendLocation, METH_VARARGS,
   "SetLegendLocation(self, location:int) -> None\nC++: void SetLegendLocation(int location)\n\nSet the legend location. These methods should not be called\ndirectly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLegendPosition", PyvtkPVXYChartView_SetLegendPosition, METH_VARARGS,
   "SetLegendPosition(self, x:int, y:int) -> None\nC++: void SetLegendPosition(int x, int y)\n\nSet the legend position.\n"},
  {"SetLegendFontFamily", PyvtkPVXYChartView_SetLegendFontFamily, METH_VARARGS,
   "SetLegendFontFamily(self, family:str) -> None\nC++: void SetLegendFontFamily(const char *family)\n\nSet the legend font family.\n"},
  {"SetLegendFontFile", PyvtkPVXYChartView_SetLegendFontFile, METH_VARARGS,
   "SetLegendFontFile(self, file:str) -> None\nC++: void SetLegendFontFile(const char *file)\n\nSet the legend font file.\n"},
  {"SetLegendFontSize", PyvtkPVXYChartView_SetLegendFontSize, METH_VARARGS,
   "SetLegendFontSize(self, pointSize:int) -> None\nC++: void SetLegendFontSize(int pointSize)\n\nSet the legend font size.\n"},
  {"SetLegendBold", PyvtkPVXYChartView_SetLegendBold, METH_VARARGS,
   "SetLegendBold(self, bold:bool) -> None\nC++: void SetLegendBold(bool bold)\n\nSet the legend font bold.\n"},
  {"SetLegendItalic", PyvtkPVXYChartView_SetLegendItalic, METH_VARARGS,
   "SetLegendItalic(self, italic:bool) -> None\nC++: void SetLegendItalic(bool italic)\n\nSet the legend font italic.\n"},
  {"SetLegendSymbolWidth", PyvtkPVXYChartView_SetLegendSymbolWidth, METH_VARARGS,
   "SetLegendSymbolWidth(self, width:int) -> None\nC++: void SetLegendSymbolWidth(int width)\n\nSet the legend symbol width (default is 25)\n"},
  {"SetGridVisibility", PyvtkPVXYChartView_SetGridVisibility, METH_VARARGS,
   "SetGridVisibility(self, index:int, visible:bool) -> None\nC++: void SetGridVisibility(int index, bool visible)\n\nSets whether or not the grid for the given axis is visible. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftGridVisibility", PyvtkPVXYChartView_SetLeftGridVisibility, METH_VARARGS,
   "SetLeftGridVisibility(self, value:bool) -> None\nC++: void SetLeftGridVisibility(bool value)\n\n"},
  {"SetBottomGridVisibility", PyvtkPVXYChartView_SetBottomGridVisibility, METH_VARARGS,
   "SetBottomGridVisibility(self, value:bool) -> None\nC++: void SetBottomGridVisibility(bool value)\n\n"},
  {"SetRightGridVisibility", PyvtkPVXYChartView_SetRightGridVisibility, METH_VARARGS,
   "SetRightGridVisibility(self, value:bool) -> None\nC++: void SetRightGridVisibility(bool value)\n\n"},
  {"SetTopGridVisibility", PyvtkPVXYChartView_SetTopGridVisibility, METH_VARARGS,
   "SetTopGridVisibility(self, value:bool) -> None\nC++: void SetTopGridVisibility(bool value)\n\n"},
  {"SetAxisColor", PyvtkPVXYChartView_SetAxisColor, METH_VARARGS,
   "SetAxisColor(self, index:int, red:float, green:float, blue:float)\n    -> None\nC++: void SetAxisColor(int index, double red, double green,\n    double blue)\n\nSets the color for the given axis. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftAxisColor", PyvtkPVXYChartView_SetLeftAxisColor, METH_VARARGS,
   "SetLeftAxisColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetLeftAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetBottomAxisColor", PyvtkPVXYChartView_SetBottomAxisColor, METH_VARARGS,
   "SetBottomAxisColor(self, value1:float, value2:float, value3:float)\n     -> None\nC++: void SetBottomAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetRightAxisColor", PyvtkPVXYChartView_SetRightAxisColor, METH_VARARGS,
   "SetRightAxisColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetRightAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetTopAxisColor", PyvtkPVXYChartView_SetTopAxisColor, METH_VARARGS,
   "SetTopAxisColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetTopAxisColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetGridColor", PyvtkPVXYChartView_SetGridColor, METH_VARARGS,
   "SetGridColor(self, index:int, red:float, green:float, blue:float)\n    -> None\nC++: void SetGridColor(int index, double red, double green,\n    double blue)\n\nSets the color for the given axis. These methods should not be\ncalled directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftGridColor", PyvtkPVXYChartView_SetLeftGridColor, METH_VARARGS,
   "SetLeftGridColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetLeftGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetBottomGridColor", PyvtkPVXYChartView_SetBottomGridColor, METH_VARARGS,
   "SetBottomGridColor(self, value1:float, value2:float, value3:float)\n     -> None\nC++: void SetBottomGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetRightGridColor", PyvtkPVXYChartView_SetRightGridColor, METH_VARARGS,
   "SetRightGridColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetRightGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetTopGridColor", PyvtkPVXYChartView_SetTopGridColor, METH_VARARGS,
   "SetTopGridColor(self, value1:float, value2:float, value3:float)\n    -> None\nC++: void SetTopGridColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetAxisLabelVisibility", PyvtkPVXYChartView_SetAxisLabelVisibility, METH_VARARGS,
   "SetAxisLabelVisibility(self, index:int, visible:bool) -> None\nC++: void SetAxisLabelVisibility(int index, bool visible)\n\nSets whether or not the labels for the given axis are visible.\nThese methods should not be called directly. They are made public\nonly so that the client-server-stream-interpreter can invoke\nthem. Use the corresponding properties to change these values.\n"},
  {"SetLeftAxisLabelVisibility", PyvtkPVXYChartView_SetLeftAxisLabelVisibility, METH_VARARGS,
   "SetLeftAxisLabelVisibility(self, value:bool) -> None\nC++: void SetLeftAxisLabelVisibility(bool value)\n\n"},
  {"SetBottomAxisLabelVisibility", PyvtkPVXYChartView_SetBottomAxisLabelVisibility, METH_VARARGS,
   "SetBottomAxisLabelVisibility(self, value:bool) -> None\nC++: void SetBottomAxisLabelVisibility(bool value)\n\n"},
  {"SetRightAxisLabelVisibility", PyvtkPVXYChartView_SetRightAxisLabelVisibility, METH_VARARGS,
   "SetRightAxisLabelVisibility(self, value:bool) -> None\nC++: void SetRightAxisLabelVisibility(bool value)\n\n"},
  {"SetTopAxisLabelVisibility", PyvtkPVXYChartView_SetTopAxisLabelVisibility, METH_VARARGS,
   "SetTopAxisLabelVisibility(self, value:bool) -> None\nC++: void SetTopAxisLabelVisibility(bool value)\n\n"},
  {"SetAxisLabelFont", PyvtkPVXYChartView_SetAxisLabelFont, METH_VARARGS,
   "SetAxisLabelFont(self, index:int, family:str, pointSize:int,\n    bold:bool, italic:bool) -> None\nC++: void SetAxisLabelFont(int index, const char *family,\n    int pointSize, bool bold, bool italic)\n\nSet the axis label font for the given axis. These methods should\nnot be called directly. They are made public only so that the\nclient-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetAxisLabelFontFamily", PyvtkPVXYChartView_SetAxisLabelFontFamily, METH_VARARGS,
   "SetAxisLabelFontFamily(self, index:int, family:str) -> None\nC++: void SetAxisLabelFontFamily(int index, const char *family)\n\nSet the axis label font family for the given axis.\n"},
  {"SetLeftAxisLabelFontFamily", PyvtkPVXYChartView_SetLeftAxisLabelFontFamily, METH_VARARGS,
   "SetLeftAxisLabelFontFamily(self, value:str) -> None\nC++: void SetLeftAxisLabelFontFamily(const char *value)\n\n"},
  {"SetBottomAxisLabelFontFamily", PyvtkPVXYChartView_SetBottomAxisLabelFontFamily, METH_VARARGS,
   "SetBottomAxisLabelFontFamily(self, value:str) -> None\nC++: void SetBottomAxisLabelFontFamily(const char *value)\n\n"},
  {"SetRightAxisLabelFontFamily", PyvtkPVXYChartView_SetRightAxisLabelFontFamily, METH_VARARGS,
   "SetRightAxisLabelFontFamily(self, value:str) -> None\nC++: void SetRightAxisLabelFontFamily(const char *value)\n\n"},
  {"SetTopAxisLabelFontFamily", PyvtkPVXYChartView_SetTopAxisLabelFontFamily, METH_VARARGS,
   "SetTopAxisLabelFontFamily(self, value:str) -> None\nC++: void SetTopAxisLabelFontFamily(const char *value)\n\n"},
  {"SetAxisLabelFontFile", PyvtkPVXYChartView_SetAxisLabelFontFile, METH_VARARGS,
   "SetAxisLabelFontFile(self, index:int, file:str) -> None\nC++: void SetAxisLabelFontFile(int index, const char *file)\n\nSet the axis label font file for the given axis.\n"},
  {"SetLeftAxisLabelFontFile", PyvtkPVXYChartView_SetLeftAxisLabelFontFile, METH_VARARGS,
   "SetLeftAxisLabelFontFile(self, value:str) -> None\nC++: void SetLeftAxisLabelFontFile(const char *value)\n\n"},
  {"SetBottomAxisLabelFontFile", PyvtkPVXYChartView_SetBottomAxisLabelFontFile, METH_VARARGS,
   "SetBottomAxisLabelFontFile(self, value:str) -> None\nC++: void SetBottomAxisLabelFontFile(const char *value)\n\n"},
  {"SetRightAxisLabelFontFile", PyvtkPVXYChartView_SetRightAxisLabelFontFile, METH_VARARGS,
   "SetRightAxisLabelFontFile(self, value:str) -> None\nC++: void SetRightAxisLabelFontFile(const char *value)\n\n"},
  {"SetTopAxisLabelFontFile", PyvtkPVXYChartView_SetTopAxisLabelFontFile, METH_VARARGS,
   "SetTopAxisLabelFontFile(self, value:str) -> None\nC++: void SetTopAxisLabelFontFile(const char *value)\n\n"},
  {"SetAxisLabelFontSize", PyvtkPVXYChartView_SetAxisLabelFontSize, METH_VARARGS,
   "SetAxisLabelFontSize(self, index:int, pointSize:int) -> None\nC++: void SetAxisLabelFontSize(int index, int pointSize)\n\nSet the axis label font size for the given axis.\n"},
  {"SetLeftAxisLabelFontSize", PyvtkPVXYChartView_SetLeftAxisLabelFontSize, METH_VARARGS,
   "SetLeftAxisLabelFontSize(self, value:int) -> None\nC++: void SetLeftAxisLabelFontSize(int value)\n\n"},
  {"SetBottomAxisLabelFontSize", PyvtkPVXYChartView_SetBottomAxisLabelFontSize, METH_VARARGS,
   "SetBottomAxisLabelFontSize(self, value:int) -> None\nC++: void SetBottomAxisLabelFontSize(int value)\n\n"},
  {"SetRightAxisLabelFontSize", PyvtkPVXYChartView_SetRightAxisLabelFontSize, METH_VARARGS,
   "SetRightAxisLabelFontSize(self, value:int) -> None\nC++: void SetRightAxisLabelFontSize(int value)\n\n"},
  {"SetTopAxisLabelFontSize", PyvtkPVXYChartView_SetTopAxisLabelFontSize, METH_VARARGS,
   "SetTopAxisLabelFontSize(self, value:int) -> None\nC++: void SetTopAxisLabelFontSize(int value)\n\n"},
  {"SetAxisLabelBold", PyvtkPVXYChartView_SetAxisLabelBold, METH_VARARGS,
   "SetAxisLabelBold(self, index:int, bold:bool) -> None\nC++: void SetAxisLabelBold(int index, bool bold)\n\nSet the axis label font bold for the given axis.\n"},
  {"SetLeftAxisLabelBold", PyvtkPVXYChartView_SetLeftAxisLabelBold, METH_VARARGS,
   "SetLeftAxisLabelBold(self, value:bool) -> None\nC++: void SetLeftAxisLabelBold(bool value)\n\n"},
  {"SetBottomAxisLabelBold", PyvtkPVXYChartView_SetBottomAxisLabelBold, METH_VARARGS,
   "SetBottomAxisLabelBold(self, value:bool) -> None\nC++: void SetBottomAxisLabelBold(bool value)\n\n"},
  {"SetRightAxisLabelBold", PyvtkPVXYChartView_SetRightAxisLabelBold, METH_VARARGS,
   "SetRightAxisLabelBold(self, value:bool) -> None\nC++: void SetRightAxisLabelBold(bool value)\n\n"},
  {"SetTopAxisLabelBold", PyvtkPVXYChartView_SetTopAxisLabelBold, METH_VARARGS,
   "SetTopAxisLabelBold(self, value:bool) -> None\nC++: void SetTopAxisLabelBold(bool value)\n\n"},
  {"SetAxisLabelItalic", PyvtkPVXYChartView_SetAxisLabelItalic, METH_VARARGS,
   "SetAxisLabelItalic(self, index:int, italic:bool) -> None\nC++: void SetAxisLabelItalic(int index, bool italic)\n\nSet the axis label font italic for the given axis.\n"},
  {"SetLeftAxisLabelItalic", PyvtkPVXYChartView_SetLeftAxisLabelItalic, METH_VARARGS,
   "SetLeftAxisLabelItalic(self, value:bool) -> None\nC++: void SetLeftAxisLabelItalic(bool value)\n\n"},
  {"SetBottomAxisLabelItalic", PyvtkPVXYChartView_SetBottomAxisLabelItalic, METH_VARARGS,
   "SetBottomAxisLabelItalic(self, value:bool) -> None\nC++: void SetBottomAxisLabelItalic(bool value)\n\n"},
  {"SetRightAxisLabelItalic", PyvtkPVXYChartView_SetRightAxisLabelItalic, METH_VARARGS,
   "SetRightAxisLabelItalic(self, value:bool) -> None\nC++: void SetRightAxisLabelItalic(bool value)\n\n"},
  {"SetTopAxisLabelItalic", PyvtkPVXYChartView_SetTopAxisLabelItalic, METH_VARARGS,
   "SetTopAxisLabelItalic(self, value:bool) -> None\nC++: void SetTopAxisLabelItalic(bool value)\n\n"},
  {"SetAxisLabelColor", PyvtkPVXYChartView_SetAxisLabelColor, METH_VARARGS,
   "SetAxisLabelColor(self, index:int, red:float, green:float,\n    blue:float) -> None\nC++: void SetAxisLabelColor(int index, double red, double green,\n    double blue)\n\nSets the axis label color for the given axis. These methods\nshould not be called directly. They are made public only so that\nthe client-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftAxisLabelColor", PyvtkPVXYChartView_SetLeftAxisLabelColor, METH_VARARGS,
   "SetLeftAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetLeftAxisLabelColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetBottomAxisLabelColor", PyvtkPVXYChartView_SetBottomAxisLabelColor, METH_VARARGS,
   "SetBottomAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetBottomAxisLabelColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetRightAxisLabelColor", PyvtkPVXYChartView_SetRightAxisLabelColor, METH_VARARGS,
   "SetRightAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetRightAxisLabelColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetTopAxisLabelColor", PyvtkPVXYChartView_SetTopAxisLabelColor, METH_VARARGS,
   "SetTopAxisLabelColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetTopAxisLabelColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetAxisLabelNotation", PyvtkPVXYChartView_SetAxisLabelNotation, METH_VARARGS,
   "SetAxisLabelNotation(self, index:int, notation:int) -> None\nC++: void SetAxisLabelNotation(int index, int notation)\n\nSets the axis label notation for the given axis. These methods\nshould not be called directly. They are made public only so that\nthe client-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftAxisLabelNotation", PyvtkPVXYChartView_SetLeftAxisLabelNotation, METH_VARARGS,
   "SetLeftAxisLabelNotation(self, value:int) -> None\nC++: void SetLeftAxisLabelNotation(int value)\n\n"},
  {"SetBottomAxisLabelNotation", PyvtkPVXYChartView_SetBottomAxisLabelNotation, METH_VARARGS,
   "SetBottomAxisLabelNotation(self, value:int) -> None\nC++: void SetBottomAxisLabelNotation(int value)\n\n"},
  {"SetRightAxisLabelNotation", PyvtkPVXYChartView_SetRightAxisLabelNotation, METH_VARARGS,
   "SetRightAxisLabelNotation(self, value:int) -> None\nC++: void SetRightAxisLabelNotation(int value)\n\n"},
  {"SetTopAxisLabelNotation", PyvtkPVXYChartView_SetTopAxisLabelNotation, METH_VARARGS,
   "SetTopAxisLabelNotation(self, value:int) -> None\nC++: void SetTopAxisLabelNotation(int value)\n\n"},
  {"SetAxisLabelPrecision", PyvtkPVXYChartView_SetAxisLabelPrecision, METH_VARARGS,
   "SetAxisLabelPrecision(self, index:int, precision:int) -> None\nC++: void SetAxisLabelPrecision(int index, int precision)\n\nSets the axis label precision for the given axis. These methods\nshould not be called directly. They are made public only so that\nthe client-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftAxisLabelPrecision", PyvtkPVXYChartView_SetLeftAxisLabelPrecision, METH_VARARGS,
   "SetLeftAxisLabelPrecision(self, value:int) -> None\nC++: void SetLeftAxisLabelPrecision(int value)\n\n"},
  {"SetBottomAxisLabelPrecision", PyvtkPVXYChartView_SetBottomAxisLabelPrecision, METH_VARARGS,
   "SetBottomAxisLabelPrecision(self, value:int) -> None\nC++: void SetBottomAxisLabelPrecision(int value)\n\n"},
  {"SetRightAxisLabelPrecision", PyvtkPVXYChartView_SetRightAxisLabelPrecision, METH_VARARGS,
   "SetRightAxisLabelPrecision(self, value:int) -> None\nC++: void SetRightAxisLabelPrecision(int value)\n\n"},
  {"SetTopAxisLabelPrecision", PyvtkPVXYChartView_SetTopAxisLabelPrecision, METH_VARARGS,
   "SetTopAxisLabelPrecision(self, value:int) -> None\nC++: void SetTopAxisLabelPrecision(int value)\n\n"},
  {"SetLeftAxisRangeMinimum", PyvtkPVXYChartView_SetLeftAxisRangeMinimum, METH_VARARGS,
   "SetLeftAxisRangeMinimum(self, value:float) -> None\nC++: void SetLeftAxisRangeMinimum(double value)\n\nFor axis ranges, ParaView overrides the VTK charts behavior.\nUsers can either specify an explicit range or let the VTK chart\ndetermine the range based on the data. To specify a range\nexplicitly, users should use SetAxisUseCustomRange() to on for\nthe corresponding axis and then use these methods to set the\nranges. Note these ranges are only respected when the\ncorresponding AxisUseCustomRange flag it set.\n"},
  {"SetBottomAxisRangeMinimum", PyvtkPVXYChartView_SetBottomAxisRangeMinimum, METH_VARARGS,
   "SetBottomAxisRangeMinimum(self, value:float) -> None\nC++: void SetBottomAxisRangeMinimum(double value)\n\n"},
  {"SetRightAxisRangeMinimum", PyvtkPVXYChartView_SetRightAxisRangeMinimum, METH_VARARGS,
   "SetRightAxisRangeMinimum(self, value:float) -> None\nC++: void SetRightAxisRangeMinimum(double value)\n\n"},
  {"SetTopAxisRangeMinimum", PyvtkPVXYChartView_SetTopAxisRangeMinimum, METH_VARARGS,
   "SetTopAxisRangeMinimum(self, value:float) -> None\nC++: void SetTopAxisRangeMinimum(double value)\n\n"},
  {"SetLeftAxisRangeMaximum", PyvtkPVXYChartView_SetLeftAxisRangeMaximum, METH_VARARGS,
   "SetLeftAxisRangeMaximum(self, value:float) -> None\nC++: void SetLeftAxisRangeMaximum(double value)\n\n"},
  {"SetBottomAxisRangeMaximum", PyvtkPVXYChartView_SetBottomAxisRangeMaximum, METH_VARARGS,
   "SetBottomAxisRangeMaximum(self, value:float) -> None\nC++: void SetBottomAxisRangeMaximum(double value)\n\n"},
  {"SetRightAxisRangeMaximum", PyvtkPVXYChartView_SetRightAxisRangeMaximum, METH_VARARGS,
   "SetRightAxisRangeMaximum(self, value:float) -> None\nC++: void SetRightAxisRangeMaximum(double value)\n\n"},
  {"SetTopAxisRangeMaximum", PyvtkPVXYChartView_SetTopAxisRangeMaximum, METH_VARARGS,
   "SetTopAxisRangeMaximum(self, value:float) -> None\nC++: void SetTopAxisRangeMaximum(double value)\n\n"},
  {"SetAxisUseCustomRange", PyvtkPVXYChartView_SetAxisUseCustomRange, METH_VARARGS,
   "SetAxisUseCustomRange(self, index:int, useCustomRange:bool)\n    -> None\nC++: void SetAxisUseCustomRange(int index, bool useCustomRange)\n\nSet whether to use the range specified by SetAxisRange(..) (or\nvariants) or to let the chart determine the range automatically\nbased on the data being shown.\n"},
  {"SetLeftAxisUseCustomRange", PyvtkPVXYChartView_SetLeftAxisUseCustomRange, METH_VARARGS,
   "SetLeftAxisUseCustomRange(self, value:bool) -> None\nC++: void SetLeftAxisUseCustomRange(bool value)\n\n"},
  {"SetBottomAxisUseCustomRange", PyvtkPVXYChartView_SetBottomAxisUseCustomRange, METH_VARARGS,
   "SetBottomAxisUseCustomRange(self, value:bool) -> None\nC++: void SetBottomAxisUseCustomRange(bool value)\n\n"},
  {"SetRightAxisUseCustomRange", PyvtkPVXYChartView_SetRightAxisUseCustomRange, METH_VARARGS,
   "SetRightAxisUseCustomRange(self, value:bool) -> None\nC++: void SetRightAxisUseCustomRange(bool value)\n\n"},
  {"SetTopAxisUseCustomRange", PyvtkPVXYChartView_SetTopAxisUseCustomRange, METH_VARARGS,
   "SetTopAxisUseCustomRange(self, value:bool) -> None\nC++: void SetTopAxisUseCustomRange(bool value)\n\n"},
  {"SetAxisLogScale", PyvtkPVXYChartView_SetAxisLogScale, METH_VARARGS,
   "SetAxisLogScale(self, index:int, logScale:bool) -> None\nC++: void SetAxisLogScale(int index, bool logScale)\n\nSets whether or not the given axis uses a log10 scale. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisLogScale", PyvtkPVXYChartView_SetLeftAxisLogScale, METH_VARARGS,
   "SetLeftAxisLogScale(self, value:bool) -> None\nC++: void SetLeftAxisLogScale(bool value)\n\n"},
  {"SetBottomAxisLogScale", PyvtkPVXYChartView_SetBottomAxisLogScale, METH_VARARGS,
   "SetBottomAxisLogScale(self, value:bool) -> None\nC++: void SetBottomAxisLogScale(bool value)\n\n"},
  {"SetRightAxisLogScale", PyvtkPVXYChartView_SetRightAxisLogScale, METH_VARARGS,
   "SetRightAxisLogScale(self, value:bool) -> None\nC++: void SetRightAxisLogScale(bool value)\n\n"},
  {"SetTopAxisLogScale", PyvtkPVXYChartView_SetTopAxisLogScale, METH_VARARGS,
   "SetTopAxisLogScale(self, value:bool) -> None\nC++: void SetTopAxisLogScale(bool value)\n\n"},
  {"SetAxisTitle", PyvtkPVXYChartView_SetAxisTitle, METH_VARARGS,
   "SetAxisTitle(self, index:int, title:str) -> None\nC++: void SetAxisTitle(int index, const char *title)\n\nSet the chart axis title for the given index. These methods\nshould not be called directly. They are made public only so that\nthe client-server-stream-interpreter can invoke them. Use the\ncorresponding properties to change these values.\n"},
  {"SetLeftAxisTitle", PyvtkPVXYChartView_SetLeftAxisTitle, METH_VARARGS,
   "SetLeftAxisTitle(self, value:str) -> None\nC++: void SetLeftAxisTitle(const char *value)\n\n"},
  {"SetBottomAxisTitle", PyvtkPVXYChartView_SetBottomAxisTitle, METH_VARARGS,
   "SetBottomAxisTitle(self, value:str) -> None\nC++: void SetBottomAxisTitle(const char *value)\n\n"},
  {"SetRightAxisTitle", PyvtkPVXYChartView_SetRightAxisTitle, METH_VARARGS,
   "SetRightAxisTitle(self, value:str) -> None\nC++: void SetRightAxisTitle(const char *value)\n\n"},
  {"SetTopAxisTitle", PyvtkPVXYChartView_SetTopAxisTitle, METH_VARARGS,
   "SetTopAxisTitle(self, value:str) -> None\nC++: void SetTopAxisTitle(const char *value)\n\n"},
  {"SetAxisTitleFont", PyvtkPVXYChartView_SetAxisTitleFont, METH_VARARGS,
   "SetAxisTitleFont(self, index:int, family:str, pointSize:int,\n    bold:bool, italic:bool) -> None\nC++: void SetAxisTitleFont(int index, const char *family,\n    int pointSize, bool bold, bool italic)\n\nSet the chart axis title's font for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetAxisTitleFontFamily", PyvtkPVXYChartView_SetAxisTitleFontFamily, METH_VARARGS,
   "SetAxisTitleFontFamily(self, index:int, family:str) -> None\nC++: void SetAxisTitleFontFamily(int index, const char *family)\n\nSet the chart axis title's font family for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleFontFamily", PyvtkPVXYChartView_SetLeftAxisTitleFontFamily, METH_VARARGS,
   "SetLeftAxisTitleFontFamily(self, value:str) -> None\nC++: void SetLeftAxisTitleFontFamily(const char *value)\n\n"},
  {"SetBottomAxisTitleFontFamily", PyvtkPVXYChartView_SetBottomAxisTitleFontFamily, METH_VARARGS,
   "SetBottomAxisTitleFontFamily(self, value:str) -> None\nC++: void SetBottomAxisTitleFontFamily(const char *value)\n\n"},
  {"SetRightAxisTitleFontFamily", PyvtkPVXYChartView_SetRightAxisTitleFontFamily, METH_VARARGS,
   "SetRightAxisTitleFontFamily(self, value:str) -> None\nC++: void SetRightAxisTitleFontFamily(const char *value)\n\n"},
  {"SetTopAxisTitleFontFamily", PyvtkPVXYChartView_SetTopAxisTitleFontFamily, METH_VARARGS,
   "SetTopAxisTitleFontFamily(self, value:str) -> None\nC++: void SetTopAxisTitleFontFamily(const char *value)\n\n"},
  {"SetAxisTitleFontFile", PyvtkPVXYChartView_SetAxisTitleFontFile, METH_VARARGS,
   "SetAxisTitleFontFile(self, index:int, file:str) -> None\nC++: void SetAxisTitleFontFile(int index, const char *file)\n\nSet the chart axis title's font file for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleFontFile", PyvtkPVXYChartView_SetLeftAxisTitleFontFile, METH_VARARGS,
   "SetLeftAxisTitleFontFile(self, value:str) -> None\nC++: void SetLeftAxisTitleFontFile(const char *value)\n\n"},
  {"SetBottomAxisTitleFontFile", PyvtkPVXYChartView_SetBottomAxisTitleFontFile, METH_VARARGS,
   "SetBottomAxisTitleFontFile(self, value:str) -> None\nC++: void SetBottomAxisTitleFontFile(const char *value)\n\n"},
  {"SetRightAxisTitleFontFile", PyvtkPVXYChartView_SetRightAxisTitleFontFile, METH_VARARGS,
   "SetRightAxisTitleFontFile(self, value:str) -> None\nC++: void SetRightAxisTitleFontFile(const char *value)\n\n"},
  {"SetTopAxisTitleFontFile", PyvtkPVXYChartView_SetTopAxisTitleFontFile, METH_VARARGS,
   "SetTopAxisTitleFontFile(self, value:str) -> None\nC++: void SetTopAxisTitleFontFile(const char *value)\n\n"},
  {"SetAxisTitleFontSize", PyvtkPVXYChartView_SetAxisTitleFontSize, METH_VARARGS,
   "SetAxisTitleFontSize(self, index:int, pointSize:int) -> None\nC++: void SetAxisTitleFontSize(int index, int pointSize)\n\nSet the chart axis title's font size for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleFontSize", PyvtkPVXYChartView_SetLeftAxisTitleFontSize, METH_VARARGS,
   "SetLeftAxisTitleFontSize(self, value:int) -> None\nC++: void SetLeftAxisTitleFontSize(int value)\n\n"},
  {"SetBottomAxisTitleFontSize", PyvtkPVXYChartView_SetBottomAxisTitleFontSize, METH_VARARGS,
   "SetBottomAxisTitleFontSize(self, value:int) -> None\nC++: void SetBottomAxisTitleFontSize(int value)\n\n"},
  {"SetRightAxisTitleFontSize", PyvtkPVXYChartView_SetRightAxisTitleFontSize, METH_VARARGS,
   "SetRightAxisTitleFontSize(self, value:int) -> None\nC++: void SetRightAxisTitleFontSize(int value)\n\n"},
  {"SetTopAxisTitleFontSize", PyvtkPVXYChartView_SetTopAxisTitleFontSize, METH_VARARGS,
   "SetTopAxisTitleFontSize(self, value:int) -> None\nC++: void SetTopAxisTitleFontSize(int value)\n\n"},
  {"SetAxisTitleBold", PyvtkPVXYChartView_SetAxisTitleBold, METH_VARARGS,
   "SetAxisTitleBold(self, index:int, bold:bool) -> None\nC++: void SetAxisTitleBold(int index, bool bold)\n\nSet the chart axis title's font bold for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleBold", PyvtkPVXYChartView_SetLeftAxisTitleBold, METH_VARARGS,
   "SetLeftAxisTitleBold(self, value:bool) -> None\nC++: void SetLeftAxisTitleBold(bool value)\n\n"},
  {"SetBottomAxisTitleBold", PyvtkPVXYChartView_SetBottomAxisTitleBold, METH_VARARGS,
   "SetBottomAxisTitleBold(self, value:bool) -> None\nC++: void SetBottomAxisTitleBold(bool value)\n\n"},
  {"SetRightAxisTitleBold", PyvtkPVXYChartView_SetRightAxisTitleBold, METH_VARARGS,
   "SetRightAxisTitleBold(self, value:bool) -> None\nC++: void SetRightAxisTitleBold(bool value)\n\n"},
  {"SetTopAxisTitleBold", PyvtkPVXYChartView_SetTopAxisTitleBold, METH_VARARGS,
   "SetTopAxisTitleBold(self, value:bool) -> None\nC++: void SetTopAxisTitleBold(bool value)\n\n"},
  {"SetAxisTitleItalic", PyvtkPVXYChartView_SetAxisTitleItalic, METH_VARARGS,
   "SetAxisTitleItalic(self, index:int, italic:bool) -> None\nC++: void SetAxisTitleItalic(int index, bool italic)\n\nSet the chart axis title's font italic for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleItalic", PyvtkPVXYChartView_SetLeftAxisTitleItalic, METH_VARARGS,
   "SetLeftAxisTitleItalic(self, value:bool) -> None\nC++: void SetLeftAxisTitleItalic(bool value)\n\n"},
  {"SetBottomAxisTitleItalic", PyvtkPVXYChartView_SetBottomAxisTitleItalic, METH_VARARGS,
   "SetBottomAxisTitleItalic(self, value:bool) -> None\nC++: void SetBottomAxisTitleItalic(bool value)\n\n"},
  {"SetRightAxisTitleItalic", PyvtkPVXYChartView_SetRightAxisTitleItalic, METH_VARARGS,
   "SetRightAxisTitleItalic(self, value:bool) -> None\nC++: void SetRightAxisTitleItalic(bool value)\n\n"},
  {"SetTopAxisTitleItalic", PyvtkPVXYChartView_SetTopAxisTitleItalic, METH_VARARGS,
   "SetTopAxisTitleItalic(self, value:bool) -> None\nC++: void SetTopAxisTitleItalic(bool value)\n\n"},
  {"SetAxisTitleColor", PyvtkPVXYChartView_SetAxisTitleColor, METH_VARARGS,
   "SetAxisTitleColor(self, index:int, red:float, green:float,\n    blue:float) -> None\nC++: void SetAxisTitleColor(int index, double red, double green,\n    double blue)\n\nSet the chart axis title's color for the given index. These\nmethods should not be called directly. They are made public only\nso that the client-server-stream-interpreter can invoke them. Use\nthe corresponding properties to change these values.\n"},
  {"SetLeftAxisTitleColor", PyvtkPVXYChartView_SetLeftAxisTitleColor, METH_VARARGS,
   "SetLeftAxisTitleColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetLeftAxisTitleColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetBottomAxisTitleColor", PyvtkPVXYChartView_SetBottomAxisTitleColor, METH_VARARGS,
   "SetBottomAxisTitleColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetBottomAxisTitleColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetRightAxisTitleColor", PyvtkPVXYChartView_SetRightAxisTitleColor, METH_VARARGS,
   "SetRightAxisTitleColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetRightAxisTitleColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetTopAxisTitleColor", PyvtkPVXYChartView_SetTopAxisTitleColor, METH_VARARGS,
   "SetTopAxisTitleColor(self, value1:float, value2:float,\n    value3:float) -> None\nC++: void SetTopAxisTitleColor(double value1, double value2,\n    double value3)\n\n"},
  {"SetAxisUseCustomLabels", PyvtkPVXYChartView_SetAxisUseCustomLabels, METH_VARARGS,
   "SetAxisUseCustomLabels(self, index:int, useCustomLabels:bool)\n    -> None\nC++: void SetAxisUseCustomLabels(int index, bool useCustomLabels)\n\nSet whether the chart uses custom labels or if the labels are\nplaced automatically.\n"},
  {"SetLeftAxisUseCustomLabels", PyvtkPVXYChartView_SetLeftAxisUseCustomLabels, METH_VARARGS,
   "SetLeftAxisUseCustomLabels(self, value:bool) -> None\nC++: void SetLeftAxisUseCustomLabels(bool value)\n\n"},
  {"SetBottomAxisUseCustomLabels", PyvtkPVXYChartView_SetBottomAxisUseCustomLabels, METH_VARARGS,
   "SetBottomAxisUseCustomLabels(self, value:bool) -> None\nC++: void SetBottomAxisUseCustomLabels(bool value)\n\n"},
  {"SetRightAxisUseCustomLabels", PyvtkPVXYChartView_SetRightAxisUseCustomLabels, METH_VARARGS,
   "SetRightAxisUseCustomLabels(self, value:bool) -> None\nC++: void SetRightAxisUseCustomLabels(bool value)\n\n"},
  {"SetTopAxisUseCustomLabels", PyvtkPVXYChartView_SetTopAxisUseCustomLabels, METH_VARARGS,
   "SetTopAxisUseCustomLabels(self, value:bool) -> None\nC++: void SetTopAxisUseCustomLabels(bool value)\n\n"},
  {"SetAxisLabelsNumber", PyvtkPVXYChartView_SetAxisLabelsNumber, METH_VARARGS,
   "SetAxisLabelsNumber(self, axis:int, number:int) -> None\nC++: void SetAxisLabelsNumber(int axis, int number)\n\nSet the number of labels for the supplied axis.\n"},
  {"SetLeftAxisLabelsNumber", PyvtkPVXYChartView_SetLeftAxisLabelsNumber, METH_VARARGS,
   "SetLeftAxisLabelsNumber(self, value:int) -> None\nC++: void SetLeftAxisLabelsNumber(int value)\n\n"},
  {"SetBottomAxisLabelsNumber", PyvtkPVXYChartView_SetBottomAxisLabelsNumber, METH_VARARGS,
   "SetBottomAxisLabelsNumber(self, value:int) -> None\nC++: void SetBottomAxisLabelsNumber(int value)\n\n"},
  {"SetRightAxisLabelsNumber", PyvtkPVXYChartView_SetRightAxisLabelsNumber, METH_VARARGS,
   "SetRightAxisLabelsNumber(self, value:int) -> None\nC++: void SetRightAxisLabelsNumber(int value)\n\n"},
  {"SetTopAxisLabelsNumber", PyvtkPVXYChartView_SetTopAxisLabelsNumber, METH_VARARGS,
   "SetTopAxisLabelsNumber(self, value:int) -> None\nC++: void SetTopAxisLabelsNumber(int value)\n\n"},
  {"SetAxisLabels", PyvtkPVXYChartView_SetAxisLabels, METH_VARARGS,
   "SetAxisLabels(self, axis:int, index:int, value:str, label:str)\n    -> None\nC++: void SetAxisLabels(int axis, int index,\n    const std::string &value, const std::string &label)\n\nSet the axis labels and positions for the supplied axis at the\ngiven index.\n"},
  {"SetLeftAxisLabels", PyvtkPVXYChartView_SetLeftAxisLabels, METH_VARARGS,
   "SetLeftAxisLabels(self, value1:int, value2:str, value3:str)\n    -> None\nC++: void SetLeftAxisLabels(int value1, const std::string &value2,\n     const std::string &value3)\n\n"},
  {"SetBottomAxisLabels", PyvtkPVXYChartView_SetBottomAxisLabels, METH_VARARGS,
   "SetBottomAxisLabels(self, value1:int, value2:str, value3:str)\n    -> None\nC++: void SetBottomAxisLabels(int value1,\n    const std::string &value2, const std::string &value3)\n\n"},
  {"SetRightAxisLabels", PyvtkPVXYChartView_SetRightAxisLabels, METH_VARARGS,
   "SetRightAxisLabels(self, value1:int, value2:str, value3:str)\n    -> None\nC++: void SetRightAxisLabels(int value1,\n    const std::string &value2, const std::string &value3)\n\n"},
  {"SetTopAxisLabels", PyvtkPVXYChartView_SetTopAxisLabels, METH_VARARGS,
   "SetTopAxisLabels(self, value1:int, value2:str, value3:str) -> None\nC++: void SetTopAxisLabels(int value1, const std::string &value2,\n    const std::string &value3)\n\n"},
  {"SetTooltipLabelFormat", PyvtkPVXYChartView_SetTooltipLabelFormat, METH_VARARGS,
   "SetTooltipLabelFormat(self, labelFormat:str) -> None\nC++: void SetTooltipLabelFormat(const vtkStdString &labelFormat)\n\n"},
  {"SetTooltipNotation", PyvtkPVXYChartView_SetTooltipNotation, METH_VARARGS,
   "SetTooltipNotation(self, notation:int) -> None\nC++: void SetTooltipNotation(int notation)\n\n"},
  {"SetTooltipPrecision", PyvtkPVXYChartView_SetTooltipPrecision, METH_VARARGS,
   "SetTooltipPrecision(self, precision:int) -> None\nC++: void SetTooltipPrecision(int precision)\n\n"},
  {"SetHideTimeMarker", PyvtkPVXYChartView_SetHideTimeMarker, METH_VARARGS,
   "SetHideTimeMarker(self, _arg:bool) -> None\nC++: virtual void SetHideTimeMarker(bool _arg)\n\nSet the visibility for the time-marker in the view. Note, you\ncannot force the time-marker to be shown. One can only hide it\nwhen the view would have shown it otherwise.\n"},
  {"GetHideTimeMarker", PyvtkPVXYChartView_GetHideTimeMarker, METH_VARARGS,
   "GetHideTimeMarker(self) -> bool\nC++: virtual bool GetHideTimeMarker()\n\n"},
  {"GetSortByXAxis", PyvtkPVXYChartView_GetSortByXAxis, METH_VARARGS,
   "GetSortByXAxis(self) -> bool\nC++: virtual bool GetSortByXAxis()\n\nSet whether to sort the data in the chart by the x-axis array so\nthat line plot connectivity is from left to right rather than\nsemi-randomly by index.\n"},
  {"SetSortByXAxis", PyvtkPVXYChartView_SetSortByXAxis, METH_VARARGS,
   "SetSortByXAxis(self, _arg:bool) -> None\nC++: virtual void SetSortByXAxis(bool _arg)\n\n"},
  {"SetIgnoreNegativeLogAxisWarning", PyvtkPVXYChartView_SetIgnoreNegativeLogAxisWarning, METH_VARARGS,
   "SetIgnoreNegativeLogAxisWarning(val:bool) -> None\nC++: static void SetIgnoreNegativeLogAxisWarning(bool val)\n\nWhen plotting data with nonpositive values, ignore the standard\nwarning and draw only the data with positive values.\n"},
  {"GetIgnoreNegativeLogAxisWarning", PyvtkPVXYChartView_GetIgnoreNegativeLogAxisWarning, METH_VARARGS,
   "GetIgnoreNegativeLogAxisWarning() -> bool\nC++: static bool GetIgnoreNegativeLogAxisWarning()\n\n"},
  {"GetChart", PyvtkPVXYChartView_GetChart, METH_VARARGS,
   "GetChart(self) -> vtkChart\nC++: virtual vtkChart *GetChart()\n\nProvides access to the chart view.\n"},
  {"GetContextItem", PyvtkPVXYChartView_GetContextItem, METH_VARARGS,
   "GetContextItem(self) -> vtkAbstractContextItem\nC++: vtkAbstractContextItem *GetContextItem() override;\n\nGet the context item.\n"},
  {"SetSelection", PyvtkPVXYChartView_SetSelection, METH_VARARGS,
   "SetSelection(self, repr:vtkChartRepresentation,\n    selection:vtkSelection) -> None\nC++: void SetSelection(vtkChartRepresentation *repr,\n    vtkSelection *selection) override;\n\nRepresentations can use this method to set the selection for a\nparticular representation. Subclasses override this method to\npass on the selection to the chart using annotation link. Note\nthis is meant to pass selection for the local process alone. The\nview does not manage data movement for the selection.\n"},
  {"Update", PyvtkPVXYChartView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverridden to rescale axes range on every update.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVXYChartView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("chart_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetChartType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetChartType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetChartType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_family"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleFontFamily(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleFontFamily/SetTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleFontSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleFontSize/SetTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_alignment"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleAlignment(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTitleAlignment(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTitleAlignment(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTitleAlignment/SetTitleAlignment\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_location"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendLocation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendLocation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendLocation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_position"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("legend_symbol_width"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLegendSymbolWidth(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLegendSymbolWidth(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLegendSymbolWidth\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_grid_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopGridVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopGridVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopGridVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_grid_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopGridColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopGridColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopGridColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_visibility"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelVisibility(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelVisibility(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelVisibility\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_label_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_range_minimum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisRangeMinimum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisRangeMinimum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisRangeMinimum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_range_minimum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisRangeMinimum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisRangeMinimum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisRangeMinimum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_range_minimum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisRangeMinimum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisRangeMinimum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisRangeMinimum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_range_minimum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisRangeMinimum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisRangeMinimum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisRangeMinimum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_range_maximum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisRangeMaximum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisRangeMaximum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisRangeMaximum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_range_maximum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisRangeMaximum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisRangeMaximum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisRangeMaximum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_range_maximum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisRangeMaximum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisRangeMaximum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisRangeMaximum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_range_maximum"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisRangeMaximum(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisRangeMaximum(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisRangeMaximum\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_use_custom_range"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisUseCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisUseCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisUseCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_use_custom_range"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisUseCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisUseCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisUseCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_use_custom_range"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisUseCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisUseCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisUseCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_use_custom_range"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisUseCustomRange(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisUseCustomRange(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisUseCustomRange\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_log_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLogScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLogScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLogScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_log_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLogScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLogScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLogScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_log_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLogScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLogScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLogScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_log_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLogScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLogScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLogScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_font_family"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontFamily(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontFamily(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleFontFamily\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_font_file"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontFile(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontFile(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleFontFile\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_title_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetAxisTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetAxisTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_font_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleFontSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleFontSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_bold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleBold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleBold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_italic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleItalic(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleItalic(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_title_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisTitleColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisTitleColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_use_custom_labels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisUseCustomLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisUseCustomLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisUseCustomLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_use_custom_labels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisUseCustomLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisUseCustomLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisUseCustomLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_use_custom_labels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisUseCustomLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisUseCustomLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisUseCustomLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_use_custom_labels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisUseCustomLabels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisUseCustomLabels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisUseCustomLabels\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("axis_labels_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetAxisLabelsNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetAxisLabelsNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAxisLabelsNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("left_axis_labels_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelsNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetLeftAxisLabelsNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLeftAxisLabelsNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("bottom_axis_labels_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelsNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetBottomAxisLabelsNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetBottomAxisLabelsNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("right_axis_labels_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetRightAxisLabelsNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetRightAxisLabelsNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetRightAxisLabelsNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("top_axis_labels_number"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTopAxisLabelsNumber(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTopAxisLabelsNumber(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTopAxisLabelsNumber\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tooltip_label_format"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTooltipLabelFormat(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTooltipLabelFormat(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTooltipLabelFormat\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tooltip_notation"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTooltipNotation(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTooltipNotation(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTooltipNotation\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tooltip_precision"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetTooltipPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetTooltipPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTooltipPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("hide_time_marker"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetHideTimeMarker(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetHideTimeMarker(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetHideTimeMarker(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetHideTimeMarker/SetHideTimeMarker\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("sort_by_x_axis"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetSortByXAxis(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetSortByXAxis(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetSortByXAxis(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSortByXAxis/SetSortByXAxis\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ignore_negative_log_axis_warning"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetIgnoreNegativeLogAxisWarning(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVXYChartView_SetIgnoreNegativeLogAxisWarning(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVXYChartView_SetIgnoreNegativeLogAxisWarning(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIgnoreNegativeLogAxisWarning/SetIgnoreNegativeLogAxisWarning\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_bold"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleFontBold(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleFontBold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_font_italic"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleFontItalic(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleFontItalic\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("title_color"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetTitleColor(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetTitleColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("chart"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetChart(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetChart\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("context_item"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVXYChartView_GetContextItem(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetContextItem\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVXYChartView_Doc =
  "vtkPVXYChartView - vtkPVView subclass for drawing charts\n\n"
  "Superclass: vtkPVContextView\n\n"
  "vtkPVXYChartView is a concrete subclass of vtkPVContextView -- which\n"
  "in turn inherits vtkPVView -- that creates a vtkChart to perform\n"
  "rendering.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVXYChartView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVXYChartView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVXYChartView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkPVXYChartView_StaticNew()
{
  return vtkPVXYChartView::New();
}

PyObject *PyvtkPVXYChartView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVXYChartView_Type, PyvtkPVXYChartView_Methods,
    "vtkPVXYChartView",
 &PyvtkPVXYChartView_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkPVContextView_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVXYChartView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVXYChartView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVXYChartView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVXYChartView", o) != 0)
  {
    Py_DECREF(o);
  }

}

